/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockEntryOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockOutOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.AbstractCsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsUpdatePreemptServer;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushStorageOrderHeadReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushStorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutDeliveryDetailMessageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutDeliveryMessageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.SapCenterTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.basicdata.enums.PcpBasicTradeBusinessTypeEnum;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="Csorder_saleBusinessOrderCallBackService")
public class CsOrderSaleCallBackServiceImpl
extends AbstractCsBusinessOrderCallBackService
implements ICsBusinessOrderCallBackService {
    private static Logger logger = LoggerFactory.getLogger(CsOrderSaleCallBackServiceImpl.class);
    private final String ORDER_NO = "ORDER_NO";
    @Autowired
    private ICommonsMqService mqService;
    @Resource
    private CsUpdatePreemptServer csUpdatePreemptServer;

    @Override
    public String getStrategy() {
        return this.getPrefix() + "order_sale";
    }

    @Override
    public Boolean deliveryReceiveNoticeOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean inOutResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean deliveryReceiveResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("deliveryReceiveResultOrderCallBack==>\u9500\u552e\u5355\u636e,\u6536\u53d1\u8d27\u7ed3\u679c\u5355\u5904\u7406\u5b8c\u6210\u540e,callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        Boolean overchargeFlag = callBackContext.getOverchargeFlag();
        if (overchargeFlag.booleanValue()) {
            return true;
        }
        this.noticeOrderSend(callBackContext);
        return true;
    }

    private void pushDeliveryResultOrderMsg(CsOrderBusinessCallBackContext callBackContext) {
        CsInOutResultRespDto csInOutResultRespDto = callBackContext.getCsInOutResultRespDto();
        List detailList = csInOutResultRespDto.getInOutResultDetailRespDtoList();
        logger.info("\u9500\u552e\u6b63\u5411\u56de\u8c03,\u8fdb\u5165pushDeliveryResultOrder\u65b9\u6cd5\uff0ctransferOrderNo:{}", (Object)callBackContext.getRelevanceNo());
        List<String> notSaleBusinessTypes = Arrays.asList(PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_TRIAL_PRODUCTION.getCode(), PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_DEMONSTRATE_RECIPIENTS.getCode(), PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_PACKAGING_RECIPIENTS.getCode(), PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_DEVELOPMENT_ACQUISITION.getCode(), PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_MAINTENANCE_MATERIALS.getCode());
        if (notSaleBusinessTypes.contains(csInOutResultRespDto.getDisplayBusinessType())) {
            logger.info("\u9500\u552e\u6b63\u5411\u56de\u8c03,\u63a8\u9001\u975e\u9500\u552e\u51fa\u5e93,inFlag:{},transferOrderNo:{}", (Object)callBackContext.getInFlag(), (Object)csInOutResultRespDto.getRelevanceNo());
            if (!callBackContext.getInFlag().booleanValue()) {
                this.pushOrder(callBackContext.getOutResultOrderId().toString(), csInOutResultRespDto, detailList, "PUSH_DELIVERY_RESULT_ORDER", csInOutResultRespDto.getOutLogicWarehouseCode(), "pushDeliveryResultOrder\u63a8\u9001\u975e\u9500\u552e\u51fa\u5e93\u5355mq\u6d88\u606f");
            }
        }
    }

    private void pushOrder(String id, CsInOutResultRespDto csDeliveryReceiveResultRespDto, List<CsInOutResultDetailRespDto> detailList, String tag, String warehouseCode, String message) {
        logger.info("\u9500\u552e\u6b63\u5411\u56de\u8c03,\u8fdb\u5165pushOrder\u65b9\u6cd5,id:{},transferOrder:{},csDeliveryReceiveResultRespDto:{}", new Object[]{id, csDeliveryReceiveResultRespDto.getRelevanceNo(), LogUtils.buildLogContent(csDeliveryReceiveResultRespDto)});
        PushStorageOrderHeadReqDto head = new PushStorageOrderHeadReqDto();
        head.setId(id);
        head.setCreateDate(DateUtil.formatDateTime((Date)new Date()));
        head.setSapMoveType(SapCenterTypeEnum.getSapType((String)csDeliveryReceiveResultRespDto.getDisplayBusinessType()));
        head.setKostl("C10005021");
        String factoryType = "1220";
        head.setFactoryType(factoryType);
        head.setCustomerCode("");
        head.setRefNo(csDeliveryReceiveResultRespDto.getDocumentNo());
        head.setTransferOrderNo(csDeliveryReceiveResultRespDto.getRelevanceNo());
        head.setSrcOrderNo(csDeliveryReceiveResultRespDto.getExternalOrderNo());
        ArrayList<PushItemReqDto> itemReqDtoList = new ArrayList<PushItemReqDto>(detailList.size());
        DecimalFormat df = new DecimalFormat("#0.00");
        for (int i = 0; i < detailList.size(); ++i) {
            PushItemReqDto sapItemReqDto = new PushItemReqDto();
            sapItemReqDto.setCode(detailList.get(i).getSkuCode());
            sapItemReqDto.setRowNum(String.valueOf(i + 1));
            sapItemReqDto.setWarehouseCode(warehouseCode);
            sapItemReqDto.setNum(df.format(detailList.get(i).getQuantity()));
            sapItemReqDto.setFactoryType(factoryType);
            sapItemReqDto.setMoveReason("");
            itemReqDtoList.add(sapItemReqDto);
        }
        PushStorageOrderReqDto sapStorageOrderReqDto = new PushStorageOrderReqDto();
        sapStorageOrderReqDto.setStorageOrderHearReqDto(head);
        sapStorageOrderReqDto.setItemReqDtoList(itemReqDtoList);
        logger.info("\u9500\u552e\u6b63\u5411\u56de\u8c03,pushOrder\u63a8\u9001\u975e\u9500\u552e\u51fa\u5e93\u5355mq\u6d88\u606f,sapStorageOrderReqDto:{}", (Object)LogUtils.buildLogContent(sapStorageOrderReqDto));
        this.mqService.sendSingleMessage("SINGLE_TOPIC", tag, (Object)JSON.toJSONString((Object)sapStorageOrderReqDto));
    }

    private CsInOutResultRespDto getCsInOutResultRespDto(CsOrderBusinessCallBackContext callBackContext, CsInOutResultRespDto csInOutResultRespDto) {
        if (null == csInOutResultRespDto || null == csInOutResultRespDto.getRelevanceNo()) {
            csInOutResultRespDto = new CsInOutResultRespDto();
            CsDeliveryReceiveResultRespDto csDeliveryReceiveResultRespDto = callBackContext.getCsDeliveryReceiveResultRespDto();
            CubeBeanUtils.copyProperties((Object)csInOutResultRespDto, (Object)csDeliveryReceiveResultRespDto, (String[])new String[0]);
            csInOutResultRespDto.setDocumentNo(csDeliveryReceiveResultRespDto.getPreOrderNo());
            ArrayList inOutResultDetailRespDtoList = new ArrayList();
            CubeBeanUtils.copyCollection(inOutResultDetailRespDtoList, (Collection)csDeliveryReceiveResultRespDto.getDeliveryReceiveResultDetailRespDtoList(), CsInOutResultDetailRespDto.class);
            csInOutResultRespDto.setInOutResultDetailRespDtoList(inOutResultDetailRespDtoList);
            csInOutResultRespDto.setOutLogicWarehouseCode(csDeliveryReceiveResultRespDto.getDeliveryLogicWarehouseCode());
            csInOutResultRespDto.setOutPhysicsWarehouseCode(csDeliveryReceiveResultRespDto.getDeliveryPhysicsWarehouseCode());
            csInOutResultRespDto.setInLogicWarehouseCode(csDeliveryReceiveResultRespDto.getReceiveLogicWarehouseCode());
            csInOutResultRespDto.setInPhysicsWarehouseCode(csDeliveryReceiveResultRespDto.getReceivePhysicsWarehouseCode());
            callBackContext.setCsInOutResultRespDto(csInOutResultRespDto);
            logger.info("operateInventory==>\u9500\u552e\u5355\u751f\u6210\u7ed3\u679c\u5355\u56de\u8c03\u5e93\u5b58\u5904\u7406,\u7ed3\u679c\u5355\u91cd\u65b0\u62fc\u63a5,callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        }
        return csInOutResultRespDto;
    }

    private String getChannelWarehouseCode(CsInOutResultRespDto csInOutResultRespDto) {
        QueryWrapper InventoryPreemptionEoQueryWrapper = new QueryWrapper();
        InventoryPreemptionEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InventoryPreemptionEoQueryWrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode());
        ArrayList<String> sourceNoList = new ArrayList<String>();
        sourceNoList.add(csInOutResultRespDto.getRelevanceNo());
        if (StringUtils.isNotBlank((CharSequence)csInOutResultRespDto.getExternalOrderNo())) {
            sourceNoList.add(csInOutResultRespDto.getExternalOrderNo());
        }
        InventoryPreemptionEoQueryWrapper.in((Object)"source_no", sourceNoList);
        InventoryPreemptionEoQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.CHANNEL.getCode());
        List InventoryPreemptionEoList = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)InventoryPreemptionEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)InventoryPreemptionEoList)) {
            return null;
        }
        InventoryPreemptionEo InventoryPreemptionEo2 = (InventoryPreemptionEo)InventoryPreemptionEoList.get(0);
        String outChannelWarehouseCode = InventoryPreemptionEo2.getWarehouseCode();
        return outChannelWarehouseCode;
    }

    private void noticeOrderSend(CsOrderBusinessCallBackContext callBackContext) {
        String relevanceNo = callBackContext.getRelevanceNo();
        List inOutResultOrderEos = this.inOutResultOrderDomain.queryByRelevanceNo(relevanceNo);
        AssertUtils.notEmpty((Collection)inOutResultOrderEos, (String)"\u51fa\u5e93\u7ed3\u679c\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
        InOutResultOrderEo inOutResultOrderEo = (InOutResultOrderEo)inOutResultOrderEos.get(0);
        AssertUtils.notBlank((String)relevanceNo, (String)"\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List inOutResultOrderDetailEos = this.inOutResultOrderDetailDomain.queryByDocumentNo(inOutResultOrderEo.getDocumentNo());
        ArrayList deliveryDetailMessageDtoList = Lists.newArrayList();
        BigDecimal totalQuantity = BigDecimal.ZERO;
        for (InOutResultOrderDetailEo detailRespDto : inOutResultOrderDetailEos) {
            CsOutDeliveryDetailMessageDto deliveryDetailMessageDto = new CsOutDeliveryDetailMessageDto();
            deliveryDetailMessageDto.setOrderNo(relevanceNo);
            deliveryDetailMessageDto.setOutQuantity(detailRespDto.getDoneQuantity());
            deliveryDetailMessageDto.setLongCode(detailRespDto.getSkuCode());
            deliveryDetailMessageDto.setBatch(detailRespDto.getBatch());
            deliveryDetailMessageDto.setTradeOrderItemId(detailRespDto.getPreOrderItemId());
            deliveryDetailMessageDtoList.add(deliveryDetailMessageDto);
            totalQuantity = BigDecimalUtils.add((BigDecimal)totalQuantity, (BigDecimal)detailRespDto.getDoneQuantity());
        }
        CsOutDeliveryMessageDto csOutDeliveryMessageDto = new CsOutDeliveryMessageDto();
        csOutDeliveryMessageDto.setDeliveryTime(callBackContext.getInOutTime());
        csOutDeliveryMessageDto.setOrderNo(relevanceNo);
        csOutDeliveryMessageDto.setTotalQuantity(totalQuantity);
        csOutDeliveryMessageDto.setTotalCartons(inOutResultOrderEo.getTotalCartons());
        csOutDeliveryMessageDto.setMergeQuantity(inOutResultOrderEo.getMergeQuantity());
        csOutDeliveryMessageDto.setDeliveryDetailMessageDtoList((List)deliveryDetailMessageDtoList);
        csOutDeliveryMessageDto.setShippingNo(inOutResultOrderEo.getShippingCode());
        csOutDeliveryMessageDto.setShipmentEnterpriseCode(inOutResultOrderEo.getShippingCompanyCode());
        csOutDeliveryMessageDto.setShipmentEnterpriseName(inOutResultOrderEo.getShippingCompany());
        String shippingJson = inOutResultOrderEo.getShippingJson();
        if (StringUtils.isBlank((CharSequence)shippingJson)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"document_no", (Object)callBackContext.getInOutNoticeNo());
            queryWrapper.eq((Object)"dr", (Object)0);
            List outNoticeOrderEos = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)queryWrapper);
            logger.info("noticeOrderSend==>\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3\uff0c\u5165\u53c2\u6ca1\u6709\u7269\u6d41\u4fe1\u606f\uff0c\u67e5\u8be2\u901a\u77e5\u5355\u7269\u6d41\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)outNoticeOrderEos));
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)outNoticeOrderEos), String.format("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u901a\u77e5\u5355\u4fe1\u606f\uff0c\u901a\u77e5\u5355\u53f7\uff1a%s", callBackContext.getInOutNoticeNo()));
            InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)outNoticeOrderEos.get(0);
            shippingJson = outNoticeOrderEo.getShippingJson();
            csOutDeliveryMessageDto.setShippingNo(outNoticeOrderEo.getShippingCode());
            csOutDeliveryMessageDto.setShipmentEnterpriseCode(outNoticeOrderEo.getShippingCompany());
            csOutDeliveryMessageDto.setShipmentEnterpriseName(outNoticeOrderEo.getShippingCompanyName());
        }
        logger.info("noticeOrderSend==>\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3,shippingJson:{}", (Object)LogUtils.buildLogContent(shippingJson));
        if (StringUtils.isNotBlank((CharSequence)shippingJson)) {
            try {
                List csWmsShippingInfoReqDtoList = JSON.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class);
                if (CollectionUtils.isNotEmpty((Collection)csWmsShippingInfoReqDtoList)) {
                    csWmsShippingInfoReqDtoList.stream().filter(e -> Objects.isNull(e.getDeliveryTime())).forEach(e -> e.setDeliveryTime(csOutDeliveryMessageDto.getDeliveryTime()));
                }
                logger.info("noticeOrderSend==>\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3,csWmsShippingInfoReqDtoList:{}", (Object)LogUtils.buildLogContent(csWmsShippingInfoReqDtoList));
                csOutDeliveryMessageDto.setShippingInfoList(csWmsShippingInfoReqDtoList);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        csOutDeliveryMessageDto.setCommonBack(Boolean.TRUE);
        csOutDeliveryMessageDto.setDeliveryNoticeOrderNo(callBackContext.getDeliveryNoticeOrderNo());
        csOutDeliveryMessageDto.setOutNoticeOrderNo(callBackContext.getInOutNoticeNo());
        csOutDeliveryMessageDto.setOutResultOrderNo(inOutResultOrderEo.getDocumentNo());
        csOutDeliveryMessageDto.setCommonBack(Boolean.valueOf(true));
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)csOutDeliveryMessageDto);
        logger.info("outDelivery==>\u5373\u5c06\u53d1\u9001MQ\u901a\u77e5\u8ba2\u5355\u5df2\u53d1\u8d27,messageVo:{}", (Object)LogUtils.buildLogContent(messageVo));
        this.mqService.sendDelaySingleMessage("ORDER_SALE_WMS_SEND_BACK_TAG", (Object)messageVo, Long.valueOf(5L));
    }

    @Override
    public Boolean relieveOverchargeCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean overchargeAdjustCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean wmsCancel(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("wmsCancel==>\u9500\u552e\u8ba2\u5355,WMS\u53d1\u8d77\u53d6\u6d88\u5355\u636e,callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        this.noticeOrderCancel(callBackContext);
        return true;
    }

    private void noticeOrderCancel(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("noticeOrderCancel==>\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3\u4fee\u6539\u5355\u636e\u72b6\u6001\u4e3a\u72b6\u6001,callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        HashMap<String, String> msgMap = new HashMap<String, String>(1);
        msgMap.put("ORDER_NO", callBackContext.getRelevanceNo());
        MessageVo messageVo = new MessageVo();
        messageVo.setData(msgMap);
        logger.info("noticeOrderCancel==>\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3\u4fee\u6539\u5355\u636e\u72b6\u6001\u4e3a\u72b6\u6001,messageVo:{}", (Object)LogUtils.buildLogContent(messageVo));
        this.mqService.sendSingleMessage("ORDER_SALE_REFUND_WMS_CANCEL_TAG", (Object)messageVo);
    }

    @Override
    public void getContactsInfo(WmsStockOutOrderReqDto dto) {
        List InOutNoticeOrderEos = this.inOutNoticeOrderDomain.queryByDocumentNo(dto.getDocumentNo());
        if (CollectionUtils.isNotEmpty((Collection)InOutNoticeOrderEos) && StringUtils.isNotBlank((CharSequence)((InOutNoticeOrderEo)InOutNoticeOrderEos.get(0)).getExtension())) {
            try {
                ContactDto contactDto = (ContactDto)JSON.parseObject((String)((InOutNoticeOrderEo)InOutNoticeOrderEos.get(0)).getExtension(), ContactDto.class);
                WmsStockOutOrderReqDto.ReceiverInfo receiverInfo = new WmsStockOutOrderReqDto.ReceiverInfo();
                contactDto.setPhone(StringUtils.isNotBlank((CharSequence)contactDto.getPhone()) ? contactDto.getPhone() : contactDto.getRecivePhone());
                contactDto.setContacts(StringUtils.isNotBlank((CharSequence)contactDto.getContacts()) ? contactDto.getContacts() : contactDto.getReciveName());
                CubeBeanUtils.copyProperties((Object)receiverInfo, (Object)contactDto, (String[])new String[0]);
                receiverInfo.setCustomerCode(contactDto.getCustomerCode());
                dto.setReceiverInfo(receiverInfo);
            }
            catch (Exception ex) {
                logger.info("\u6355\u83b7\u5f02\u5e38\uff0c\u903b\u8f91\u4e0d\u5904\u7406\uff1a\u524d\u7f6e\u5355\u636e\u6536\u8d27\u4fe1\u606f\u9519\u8bef");
            }
        }
    }

    @Override
    public void getContactsInfo(WmsStockEntryOrderReqDto dto) {
    }

    @Override
    public void closeOrderStatus(String relevanceNo) {
    }

    @Override
    public void beforeNotice(BaseOrderBaseContext context) {
        logger.info("CsOrderSaleCallBackServiceImpl beforeNotice : {}", (Object)JSON.toJSONString((Object)context));
        if (context instanceof InOutNoticeOrderContext) {
            InOutNoticeOrderContext inOutNoticeOrderContext = (InOutNoticeOrderContext)context;
            inOutNoticeOrderContext.setNoticeEnd(Boolean.TRUE.booleanValue());
            InOutNoticeOrderEo inOutNoticeOrderEo = inOutNoticeOrderContext.getInOutNoticeOrderEo();
            ArrayList typeList = Lists.newArrayList((Object[])new String[]{CsInventorySourceTypeEnum.ALLOT_SALE.getCode(), CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode(), CsPcpBusinessTypeEnum.CC_ALLOT.getCode(), CsPcpBusinessTypeEnum.MAIYOU_ALLOT_OUT.getCode()});
            List saleTransferOrderEos = this.csTransferOrderMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"sale_order_no", (Object)inOutNoticeOrderEo.getRelevanceNo())).notIn((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{CsTransferOrderEnum.Status.AUDIT_FAILED.getCode(), CsTransferOrderEnum.Status.CANCELED.getCode()}))).in((Object)"type", (Collection)typeList)).eq((Object)"dr", (Object)YesNoHelper.NO));
            logger.info("\u5f00\u59cb\u5224\u5b9a\u9500\u552e\u5355 \u865a\u51fa: {}", (Object)LogUtils.buildLogContent(saleTransferOrderEos));
            if (CollectionUtils.isNotEmpty((Collection)saleTransferOrderEos)) {
                logger.info("\u5224\u5b9a\u4e3a \u9500\u552e\u5355 \u865a\u51fa.........");
                CsTransferOrderEo saleTransferOrderEo = saleTransferOrderEos.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSecondTransferOrderNo())).findFirst().orElse(null);
                AssertUtils.notNull((Object)saleTransferOrderEo, (String)"\u9500\u552e\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
                if (CsInventorySourceTypeEnum.ALLOT_SALE.getCode().equals(saleTransferOrderEo.getType()) && !CsTransferOrderEnum.Status.FINISH.getCode().equals(saleTransferOrderEo.getOrderStatus())) {
                    throw new BizException("\u8ba2\u5355\u5173\u8054\u9500\u552e\u8c03\u62e8\u5355\u672a\u5b8c\u6210");
                }
                if (StringUtils.isNotBlank((CharSequence)saleTransferOrderEo.getNextPhysicsWarehouseCode())) {
                    CsTransferOrderEo nextTransferOrderEo = saleTransferOrderEos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getSecondTransferOrderNo())).findFirst().orElse(null);
                    AssertUtils.notNull((Object)nextTransferOrderEo, (String)"\u9500\u552e\u4e2d\u8f6c\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
                    if (CsInventorySourceTypeEnum.ALLOT_SALE.getCode().equals(saleTransferOrderEo.getType()) && !CsTransferOrderEnum.Status.FINISH.getCode().equals(nextTransferOrderEo.getOrderStatus())) {
                        throw new BizException("\u8ba2\u5355\u5173\u8054\u9500\u552e\u4e2d\u8f6c\u8c03\u62e8\u5355\u672a\u5b8c\u6210");
                    }
                }
                List saleTransferOutResultOrders = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderEo.class).eq(InOutResultOrderEo::getRelevanceNo, (Object)saleTransferOrderEo.getTransferOrderNo())).eq(InOutResultOrderEo::getOrderStatus, (Object)BaseOrderStatusEnum.ORO_DONE_OUT.getCode())).eq(InOutResultOrderEo::getOrderType, (Object)"out")).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
                AssertUtil.assertNotEmpty(saleTransferOutResultOrders, "\u5bf9\u5e94\u9500\u552e\u8c03\u62e8\u51fa\u5e93\u7ed3\u679c\u5355\u67e5\u8be2\u4e0d\u5b58\u5728", new Object[0]);
                if (saleTransferOutResultOrders.size() > 1) {
                    throw new CsInventoryException("\u5bf9\u5e94\u9500\u552e\u8c03\u62e8\u51fa\u5e93\u7ed3\u679c\u5355\u4e0d\u552f\u4e00", new Object[0]);
                }
                InOutResultOrderEo saleTransferOutResultOrder = (InOutResultOrderEo)saleTransferOutResultOrders.get(0);
                List saleTransferOutResultOrderDetailEos = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderDetailEo.class).eq(InOutResultOrderDetailEo::getDocumentNo, (Object)saleTransferOutResultOrder.getDocumentNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
                AssertUtil.assertNotEmpty(saleTransferOutResultOrderDetailEos, "\u8c03\u62e8\u5355\u51fa\u5e93\u7ed3\u679c\u5355\u660e\u7ec6\u67e5\u8be2\u4e0d\u5b58\u5728", new Object[0]);
                List orderBasicsDetailReqDtoList = context.getOrderBasicsDetailReqDtoList();
                ArrayList splitDetailList = Lists.newArrayList();
                for (InOutResultOrderDetailEo saleTransferOutResultOrderDetailEo : saleTransferOutResultOrderDetailEos) {
                    String skuCode = saleTransferOutResultOrderDetailEo.getSkuCode();
                    BaseOrderDetailReqDto detail = orderBasicsDetailReqDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)skuCode)).findFirst().orElse(null);
                    AssertUtil.assertNotNull(detail, "\u901a\u8fc7\u8c03\u62e8\u5355\u660e\u7ec6\u8d27\u54c1\u627e\u4e0d\u5230\uff0c\u53c2\u6570\u4f20\u5165\u8d27\u54c1", new Object[0]);
                    BaseOrderDetailReqDto splitDetail = new BaseOrderDetailReqDto();
                    BeanUtils.copyProperties((Object)detail, (Object)splitDetail);
                    splitDetail.setBatch(saleTransferOutResultOrderDetailEo.getBatch());
                    splitDetail.setQuantity(saleTransferOutResultOrderDetailEo.getDoneQuantity());
                    splitDetail.setProduceTime(saleTransferOutResultOrderDetailEo.getProduceTime());
                    splitDetail.setExpireTime(saleTransferOutResultOrderDetailEo.getExpireTime());
                    splitDetailList.add(splitDetail);
                }
                context.setOrderBasicsDetailReqDtoList((List)splitDetailList);
                context.setShippingInfoReqDtoList(JSONArray.parseArray((String)saleTransferOutResultOrder.getShippingJson(), CsWmsShippingInfoReqDto.class));
                context.setSendWms(Boolean.FALSE.booleanValue());
                context.setAutoComplete(Boolean.TRUE);
                context.setValidNegative(Boolean.FALSE);
                inOutNoticeOrderContext.getInOutNoticeOrderEo().setOrderStatus(BaseOrderStatusEnum.ONO_TOTAL_OUT.getCode());
                inOutNoticeOrderContext.getInOutNoticeOrderDetailEoList().forEach(detailEo -> {
                    detailEo.setWaitQuantity(BigDecimal.ZERO);
                    detailEo.setDoneQuantity(detailEo.getPlanQuantity());
                });
                inOutNoticeOrderContext.setIsSaleOrder(Boolean.TRUE);
                inOutNoticeOrderContext.setNoticeEnd(Boolean.TRUE.booleanValue());
                logger.info("\u901a\u8fc7\u8c03\u62e8\u5355 \u7ec4\u88c5 \u7ed3\u679c\u56de\u8c03\u53c2\u6570: {}", (Object)LogUtils.buildLogContent(context));
            }
        }
    }
}

