/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.BusinessOrderCallBackParseHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.IOrderPreemptWrapperHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsPhysicsInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsBusinessOrderCallBackUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.IPcpOutNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.constant.ShipmentMappingConstant;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsTransferOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOrderShipmentCheckReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutDeliveryDetailMessageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutDeliveryMessageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.ShippingJsonDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBusinessCallBackStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.CsOutNoticePushStatusEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csPhysicsInventoryExposedServiceImpl")
public class CsPhysicsInventoryExposedServiceImpl
implements ICsPhysicsInventoryExposedService {
    private static final Logger log = LoggerFactory.getLogger(CsPhysicsInventoryExposedServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(CsPhysicsInventoryExposedServiceImpl.class);
    @Autowired
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Autowired
    IRelWarehouseDomain relWarehouseDomain;
    @Autowired
    ICsPhysicsInventoryExposedService csPhysicsInventoryExposedService;
    @Autowired
    ICsOutNoticeOrderService csOutNoticeOrderService;
    @Autowired
    IPcpOutNoticeOrderService pcpOutNoticeOrderService;
    @Autowired
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Autowired
    BaseOrderFacade baseOrderFacade;
    @Autowired
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private ICommonsMqService mqService;
    @Resource
    private IOrderPreemptWrapperHelper orderPreemptWrapperHelper;
    @Resource
    CsTransferOrderMapper csTransferOrderMapper;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Autowired
    TransactionCallBackService transactionCallBackService;
    @Autowired
    ICommonsMqService commonsMqService;
    @Autowired
    IPhysicsWarehouseDomain physicsWarehouseDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean preemptOrderInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        this.logger.info("preemptOrderInventory==>\u5e93\u5b58\u9884\u5360\uff0c\u5305\u542b\u5355\u636e\u64cd\u4f5c-\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        AssertUtil.assertNotNull(inventoryOperateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        String businessType = StringUtils.isNotBlank((CharSequence)inventoryOperateReqDto.getBusinessType()) ? inventoryOperateReqDto.getBusinessType() : CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode();
        inventoryOperateReqDto.setBusinessType(businessType);
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        ArrayList outNoticeOrderStatusList = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.ONO_PORTION_OUT.getCode()});
        List InOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"relevance_no", (Object)sourceNo)).in((Object)"order_status", (Collection)outNoticeOrderStatusList));
        if (CollectionUtils.isNotEmpty((Collection)InOutNoticeOrderEoList)) {
            return true;
        }
        QueryWrapper ReceiveDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)sourceNo);
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_status", (Object)BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
        List receiveDeliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)ReceiveDeliveryNoticeOrderEoQueryWrapper);
        AssertUtil.assertNotEmpty(receiveDeliveryNoticeOrderEoList, "\u67e5\u8be2\u4e0d\u5230\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f", new Object[0]);
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)receiveDeliveryNoticeOrderEoList.get(0);
        inventoryOperateReqDto.setRelevanceNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
        inventoryOperateReqDto.setPlatformOrderNo(receiveDeliveryNoticeOrderEo.getExternalOrderNo());
        Long outNoticeOrderId = this.createOutNoticeOrder(inventoryOperateReqDto, receiveDeliveryNoticeOrderEo);
        if (null == outNoticeOrderId) {
            throw new BizException("\u751f\u6210\u51fa\u5e93\u901a\u77e5\u5355\u5931\u8d25");
        }
        return true;
    }

    private Long createOutNoticeOrder(final CsInventoryOperateReqDto inventoryOperateReqDto, final ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo) {
        LogicWarehouseEo warehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)inventoryOperateReqDto.getLogicWarehouseCode())).one();
        AssertUtil.isTrue(Objects.nonNull(warehouse), "\u4ed3\u5e93\u4e0d\u5b58\u5728:{}", inventoryOperateReqDto.getLogicWarehouseCode());
        this.logger.info("preemptOrderInventory==>\u751f\u6210\u51fa\u5e93\u901a\u77e5\u5355,orderNo:{}", (Object)inventoryOperateReqDto.getSourceNo());
        InOutNoticeOrderContext csBasicsOrderReqDto = new InOutNoticeOrderContext();
        CubeBeanUtils.copyProperties((Object)csBasicsOrderReqDto, (Object)inventoryOperateReqDto, (String[])new String[0]);
        csBasicsOrderReqDto.setPreOrderNo(inventoryOperateReqDto.getRelevanceNo());
        csBasicsOrderReqDto.setExternalOrderNo(inventoryOperateReqDto.getPlatformOrderNo());
        csBasicsOrderReqDto.setRelevanceNo(inventoryOperateReqDto.getSourceNo());
        csBasicsOrderReqDto.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_SALE);
        csBasicsOrderReqDto.setPlanTime(StringUtils.isNotBlank((CharSequence)inventoryOperateReqDto.getPlanTime()) ? inventoryOperateReqDto.getPlanTime() : DateUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss"));
        BigDecimal totalQuantity = BigDecimal.ZERO;
        ArrayList<BaseOrderDetailReqDto> deliveryDetailList = new ArrayList<BaseOrderDetailReqDto>(inventoryOperateReqDto.getOperateCargoReqDtoList().size());
        for (CsInventoryOperateCargoReqDto detail : inventoryOperateReqDto.getOperateCargoReqDtoList()) {
            BaseOrderDetailReqDto basic = new BaseOrderDetailReqDto();
            basic.setSkuCode(detail.getLongCode());
            basic.setSkuName(detail.getCargoName());
            basic.setQuantity(detail.getChangeInventory());
            basic.setBatch(detail.getBatch());
            basic.setPreOrderItemId(detail.getTradeOrderItemId());
            basic.setLineNo(detail.getLineNo());
            totalQuantity = BigDecimalUtils.add((BigDecimal)totalQuantity, (BigDecimal)basic.getQuantity());
            deliveryDetailList.add(basic);
        }
        csBasicsOrderReqDto.setTotalQuantity(totalQuantity);
        csBasicsOrderReqDto.setOrderBasicsDetailReqDtoList(deliveryDetailList);
        final boolean isComplete = "enable".equals(warehouse.getVirtualMatterFlag());
        csBasicsOrderReqDto.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                InOutNoticeOrderContext context1 = (InOutNoticeOrderContext)context;
                InOutNoticeOrderEo inOutNoticeOrderEo = context1.getInOutNoticeOrderEo();
                inOutNoticeOrderEo.setDisplayBusinessName(receiveDeliveryNoticeOrderEo.getDisplayBusinessName());
                inOutNoticeOrderEo.setDisplayBusinessType(receiveDeliveryNoticeOrderEo.getDisplayBusinessType());
                inOutNoticeOrderEo.setJumpDocumentType(receiveDeliveryNoticeOrderEo.getJumpDocumentType());
                inOutNoticeOrderEo.setJumpDocumentName(receiveDeliveryNoticeOrderEo.getJumpDocumentName());
                inOutNoticeOrderEo.setShipmentEnterpriseCode(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseCode());
                inOutNoticeOrderEo.setShipmentEnterpriseName(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseName());
                inOutNoticeOrderEo.setOaidOrderSourceCode(receiveDeliveryNoticeOrderEo.getOaidOrderSourceCode());
                inOutNoticeOrderEo.setSourcePlatformCode(receiveDeliveryNoticeOrderEo.getSourcePlatformCode());
                inOutNoticeOrderEo.setPayTime(receiveDeliveryNoticeOrderEo.getPayTime());
                inOutNoticeOrderEo.setTradeOrderCreateTime(receiveDeliveryNoticeOrderEo.getTradeOrderCreateTime());
                inOutNoticeOrderEo.setYfRepairOrderNo(receiveDeliveryNoticeOrderEo.getYfRepairOrderNo());
                inOutNoticeOrderEo.setPushStatus(CsOutNoticePushStatusEnum.WAITING.getCode());
                inOutNoticeOrderEo.setExtension(inventoryOperateReqDto.getExtension());
                inOutNoticeOrderEo.setExchangePlatformAfterSaleOrderNo(receiveDeliveryNoticeOrderEo.getExchangePlatformAfterSaleOrderNo());
            }

            public void afterCallBack(BaseOrderBaseContext context) {
                InOutNoticeOrderContext context1 = (InOutNoticeOrderContext)context;
                context1.setSendWms(!isComplete);
                if (!isComplete) {
                    return;
                }
                InOutNoticeOrderEo inOutNoticeOrderEo = context1.getInOutNoticeOrderEo();
                InOutResultOrderFacadeBo inOutResultOrderFacadeBo = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)context, InOutResultOrderFacadeBo.class, (String[])new String[0]);
                inOutResultOrderFacadeBo.setInOutNoticeOrderEo(inOutNoticeOrderEo);
                inOutResultOrderFacadeBo.setInOutNoticeOrderDetailEos(context1.getInOutNoticeOrderDetailEoList());
                inOutResultOrderFacadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

                    public void beforeCallBack(BaseOrderBaseContext context) {
                        InOutResultOrderContext context2 = (InOutResultOrderContext)context;
                        context2.setNoticeEnd(true);
                    }

                    public void afterCallBack(BaseOrderBaseContext context) {
                    }
                });
                inOutResultOrderFacadeBo.setShippingInfoReqDtoList(CsPhysicsInventoryExposedServiceImpl.this.orderPreemptWrapperHelper.shipmentDispose(inOutNoticeOrderEo));
                InOutResultOrderContext inOutResultOrderContext = CsPhysicsInventoryExposedServiceImpl.this.baseOrderFacade.outResultOrderGen(inOutResultOrderFacadeBo);
                CsPhysicsInventoryExposedServiceImpl.this.doCallback(inventoryOperateReqDto, inOutResultOrderContext);
            }
        });
        this.baseOrderFacade.outNoticeOrderGen(csBasicsOrderReqDto);
        return csBasicsOrderReqDto.getInOutNoticeOrderEo().getId();
    }

    private void doCallback(CsInventoryOperateReqDto inventoryOperateReqDto, InOutResultOrderContext inOutResultOrderContext) {
        BigDecimal total = inventoryOperateReqDto.getOperateCargoReqDtoList().stream().map(CsInventoryOperateCargoReqDto::getChangeInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
        List messageDtos = inventoryOperateReqDto.getOperateCargoReqDtoList().stream().map(detailRespDto -> {
            CsOutDeliveryDetailMessageDto deliveryDetailMessageDto = new CsOutDeliveryDetailMessageDto();
            deliveryDetailMessageDto.setOrderNo(inOutResultOrderContext.getRelevanceNo());
            deliveryDetailMessageDto.setOutQuantity(detailRespDto.getChangeInventory());
            deliveryDetailMessageDto.setLongCode(detailRespDto.getCargoCode());
            deliveryDetailMessageDto.setBatch(detailRespDto.getBatch());
            deliveryDetailMessageDto.setTradeOrderItemId(detailRespDto.getTradeOrderItemId());
            return deliveryDetailMessageDto;
        }).collect(Collectors.toList());
        CsOutDeliveryMessageDto csOutDeliveryMessageDto = new CsOutDeliveryMessageDto();
        csOutDeliveryMessageDto.setOrderNo(inOutResultOrderContext.getRelevanceNo());
        csOutDeliveryMessageDto.setTotalQuantity(total);
        csOutDeliveryMessageDto.setTotalCartons(BigDecimal.ZERO);
        csOutDeliveryMessageDto.setMergeQuantity(BigDecimal.ZERO);
        csOutDeliveryMessageDto.setDeliveryDetailMessageDtoList(messageDtos);
        csOutDeliveryMessageDto.setCommonBack(Boolean.valueOf(true));
        InOutResultOrderEo inOutResultOrderEo = inOutResultOrderContext.getInOutResultOrderEo();
        csOutDeliveryMessageDto.setDeliveryTime(inOutResultOrderEo.getInOutTime());
        csOutDeliveryMessageDto.setShippingNo(inOutResultOrderEo.getShippingCode());
        csOutDeliveryMessageDto.setShipmentEnterpriseCode(inOutResultOrderEo.getShippingCompanyCode());
        csOutDeliveryMessageDto.setShipmentEnterpriseName(inOutResultOrderEo.getShippingCompany());
        String shippingJson = inOutResultOrderEo.getShippingJson();
        this.logger.info("noticeOrderSend==>\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3,shippingJson:{}", (Object)LogUtils.buildLogContent(shippingJson));
        if (StringUtils.isNotBlank((CharSequence)shippingJson)) {
            try {
                List csWmsShippingInfoReqDtoList = JSON.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class);
                if (CollectionUtils.isNotEmpty((Collection)csWmsShippingInfoReqDtoList)) {
                    CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)csWmsShippingInfoReqDtoList.get(0);
                    csOutDeliveryMessageDto.setShippingNo(csWmsShippingInfoReqDto.getShippingNo());
                    csOutDeliveryMessageDto.setShipmentEnterpriseCode(csWmsShippingInfoReqDto.getShippingCompanyCode());
                    csOutDeliveryMessageDto.setShipmentEnterpriseName(csWmsShippingInfoReqDto.getShippingCompanyName());
                    csWmsShippingInfoReqDtoList.stream().filter(e -> Objects.isNull(e.getDeliveryTime())).forEach(e -> e.setDeliveryTime(csOutDeliveryMessageDto.getDeliveryTime()));
                    log.info("noticeOrderSend==>\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3,csWmsShippingInfoReqDtoList:{}", (Object)LogUtils.buildLogContent(csWmsShippingInfoReqDtoList));
                    csOutDeliveryMessageDto.setShippingInfoList(csWmsShippingInfoReqDtoList);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        csOutDeliveryMessageDto.setCommonBack(Boolean.TRUE);
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)csOutDeliveryMessageDto);
        log.info("outDelivery==>\u5373\u5c06\u53d1\u9001MQ\u901a\u77e5\u8ba2\u5355\u5df2\u53d1\u8d27,messageVo:{}", (Object)LogUtils.buildLogContent(messageVo));
        this.mqService.sendDelaySingleMessage("ORDER_SALE_WMS_SEND_BACK_TAG", (Object)messageVo, Long.valueOf(5L));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean cancelOrder(String orderNo) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u8ba2\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.csOutNoticeOrderService.cancelOutNoticeOrderByPreOrderNo(orderNo);
        return true;
    }

    @Override
    public Boolean continueDelivery(String orderNo) {
        this.logger.info("continueDelivery==>\u6839\u636e\u8ba2\u5355\u53f7\u8fdb\u884c\u7ee7\u7eed\u53d1\u8d27,orderNo:{}", (Object)LogUtils.buildLogContent(orderNo));
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List InventoryPreemptionEos = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryPreemptionEo.class).select(new SFunction[]{BaseEo::getId}).eq(InventoryPreemptionEo::getSourceNo, (Object)orderNo)).eq(InventoryPreemptionEo::getValid, (Object)ValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotEmpty(InventoryPreemptionEos, "\u6ca1\u6709\u6709\u6548\u9884\u5360\u8bb0\u5f55", new Object[0]);
        QueryWrapper ReceiveDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)orderNo);
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_status", (Object)BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
        List receiveDeliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)ReceiveDeliveryNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)receiveDeliveryNoticeOrderEoList), "\u67e5\u8be2\u4e0d\u5230\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f");
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)receiveDeliveryNoticeOrderEoList.get(0);
        QueryWrapper detailEoQueryWrapper = new QueryWrapper();
        detailEoQueryWrapper.eq((Object)"document_no", (Object)deliveryNoticeOrderEo.getDocumentNo());
        detailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List deliveryNoticeOrderDetailEos = this.receiveDeliveryNoticeOrderDetailDomain.getMapper().selectList((Wrapper)detailEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderDetailEos), "\u53d1\u8d27\u901a\u77e5\u5355\u8be6\u60c5\u4fe1\u606f\u4e0d\u5b58\u5728");
        InOutNoticeOrderFacadeBo outNoticeOrderFacadeBo = new InOutNoticeOrderFacadeBo();
        outNoticeOrderFacadeBo.setReceiveDeliveryNoticeOrderEo(deliveryNoticeOrderEo);
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode());
        final ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        List inOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"pre_order_no", (Object)deliveryNoticeOrderEo.getDocumentNo())).eq((Object)"order_status", (Object)BaseOrderStatusEnum.ONO_WAIT_OUT.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEos)) {
            log.info("\u5355\u636e\u91cd\u590d\u63a8\u9001:{}", (Object)orderNo);
            return true;
        }
        outNoticeOrderFacadeBo.setSendWms(true);
        LogicWarehouseEo logicWarehouseEo = this.logicWarehouseDomain.queryByCode(deliveryNoticeOrderEo.getDeliveryLogicWarehouseCode());
        AssertUtils.notNull((Object)logicWarehouseEo, (String)"\u51fa\u5e93\u903b\u8f91\u4ed3\u67e5\u8be2\u4e0d\u5b58\u5728");
        if (YesNoHelper.YES.equals(logicWarehouseEo.getIsVirtual())) {
            outNoticeOrderFacadeBo.setSendWms(Boolean.FALSE.booleanValue());
            outNoticeOrderFacadeBo.setAutoComplete(Boolean.valueOf(true));
        }
        outNoticeOrderFacadeBo.setIsSaleOrder(Boolean.TRUE);
        outNoticeOrderFacadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                context.setTransparentCallback(Boolean.valueOf(true));
                if (context instanceof InOutNoticeOrderContext) {
                    log.info("continueDelivery CallBack beforeCallBack :{}", (Object)LogUtils.buildLogContent(context));
                    businessOrderCallBackService.beforeNotice(context);
                    InOutNoticeOrderEo inOutNoticeOrderEo = ((InOutNoticeOrderContext)context).getInOutNoticeOrderEo();
                    Boolean sendWms = businessOrderCallBackService.sendWms(inOutNoticeOrderEo);
                    log.info("continueDelivery send wms : {}", (Object)sendWms);
                    context.setSendWms(sendWms.booleanValue());
                } else if (context instanceof InOutResultOrderContext) {
                    log.info("InOutResultOrderContext CallBack beforeCallBack :{}", (Object)LogUtils.buildLogContent(context));
                    InOutResultOrderEo inOutResultOrderEo = ((InOutResultOrderContext)context).getInOutResultOrderEo();
                    ArrayList orderStatusList = Lists.newArrayList((Object[])new String[]{CsTransferOrderEnum.Status.CANCELED.getCode(), CsTransferOrderEnum.Status.AUDIT_FAILED.getCode()});
                    List csTransferOrderEos = CsPhysicsInventoryExposedServiceImpl.this.csTransferOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getSaleOrderNo, (Object)inOutResultOrderEo.getRelevanceNo())).notIn(CsTransferOrderEo::getOrderStatus, (Collection)orderStatusList)).isNull(CsTransferOrderEo::getSecondTransferOrderNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
                    if (CollectionUtils.isNotEmpty((Collection)csTransferOrderEos)) {
                        log.info("\u8fdb\u5165\u9500\u552e\u8ba2\u5355\u7ee7\u627f\u9500\u552e\u8c03\u62e8\u5355\u7269\u6d41\u4fe1\u606f");
                        CsPhysicsInventoryExposedServiceImpl.this.getCsWmsShippingInfoReqDto(inOutResultOrderEo, csTransferOrderEos, context);
                    }
                }
            }

            public void afterCallBack(BaseOrderBaseContext context) {
                if (context instanceof InOutResultOrderContext) {
                    log.info("continueDelivery CallBack afterCallBack :{}", (Object)LogUtils.buildLogContent(context));
                    CsOrderBusinessCallBackContext csOrderBusinessCallBackContext = BusinessOrderCallBackParseHelper.parseResultCallBack(context);
                    csOrderBusinessCallBackContext.setPortionFlag(Boolean.valueOf(false));
                    businessOrderCallBackService.deliveryReceiveResultOrderCallBack(csOrderBusinessCallBackContext);
                    InOutResultOrderEo inOutResultOrderEo = ((InOutResultOrderContext)context).getInOutResultOrderEo();
                    CsBasicsReceiveReqDto basicsReceiveBasicsReqDto = new CsBasicsReceiveReqDto();
                    basicsReceiveBasicsReqDto.setInOutResultOrderNo(inOutResultOrderEo.getDocumentNo());
                    List shippingInfoReqDtoList = Lists.newArrayList();
                    if (StringUtils.isNotBlank((CharSequence)inOutResultOrderEo.getShippingJson())) {
                        shippingInfoReqDtoList = JSONArray.parseArray((String)inOutResultOrderEo.getShippingJson(), CsWmsShippingInfoReqDto.class);
                    }
                    basicsReceiveBasicsReqDto.setShippingInfoReqDtoList(shippingInfoReqDtoList);
                    CsPhysicsInventoryExposedServiceImpl.this.transactionCallBackService.execute(() -> {
                        MessageVo messageVo = new MessageVo();
                        messageVo.setData((Object)JSON.toJSONString((Object)basicsReceiveBasicsReqDto));
                        CsPhysicsInventoryExposedServiceImpl.this.commonsMqService.sendDelaySingleMessage("INVENTORY_BUSINESS_TOPIC", "CREATE_CONSIGNMENT_ORDER", (Object)messageVo, Long.valueOf(2L));
                    });
                }
            }
        });
        this.baseOrderFacade.outNoticeOrderGen(outNoticeOrderFacadeBo);
        return true;
    }

    private void getCsWmsShippingInfoReqDto(InOutResultOrderEo inOutResultOrderEo, List<CsTransferOrderEo> csTransferOrderEos, BaseOrderBaseContext context) {
        ArrayList shippingInfoReqDtoList = Lists.newArrayList();
        CsTransferOrderEo csTransferOrderEo = csTransferOrderEos.get(0);
        CsWmsShippingInfoReqDto infoReqDto = new CsWmsShippingInfoReqDto();
        List inOutResultOrderEos = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderEo.class).eq(InOutResultOrderEo::getRelevanceNo, (Object)csTransferOrderEo.getTransferOrderNo())).eq(InOutResultOrderEo::getOrderType, (Object)CsInventoryInOutEnum.OUT.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)inOutResultOrderEos, (String)"\u9500\u552e\u8c03\u62e8\u5355\u7684\u7ed3\u679c\u5355\u4e0d\u5b58\u5728");
        InOutResultOrderEo csOutResultOrderEo = (InOutResultOrderEo)inOutResultOrderEos.get(0);
        List inOutResultOrderDetailEos = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderDetailEo.class).eq(InOutResultOrderDetailEo::getDocumentNo, (Object)csOutResultOrderEo.getDocumentNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)inOutResultOrderDetailEos, (String)"\u9500\u552e\u8c03\u62e8\u5355\u7684\u7ed3\u679c\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        Map detailEoMap = inOutResultOrderDetailEos.stream().collect(Collectors.toMap(o -> o.getSkuCode() + o.getBatch(), Function.identity(), (o1, o2) -> o1));
        List inOutResultOrderDetailEoList = ((InOutResultOrderContext)context).getInOutResultOrderDetailEoList();
        String shippingJson = csOutResultOrderEo.getShippingJson();
        AssertUtil.assertNotBlank(shippingJson, "\u7ed3\u679c\u5355\u7269\u6d41\u4fe1\u606f\u4e3a\u7a7a\uff0c\u6216\u8005\u4e0d\u5b58\u5728", new Object[0]);
        List shippingJsonDtoList = JSONObject.parseArray((String)shippingJson, ShippingJsonDto.class);
        ShippingJsonDto shippingJsonDto = (ShippingJsonDto)shippingJsonDtoList.get(0);
        for (InOutResultOrderDetailEo detailEo : inOutResultOrderDetailEoList) {
            String key = detailEo.getSkuCode() + detailEo.getBatch();
            if (!detailEoMap.containsKey(key)) continue;
            InOutResultOrderDetailEo resultOrderDetailEo = (InOutResultOrderDetailEo)detailEoMap.get(key);
            detailEo.setVolume(resultOrderDetailEo.getVolume());
            detailEo.setWeight(resultOrderDetailEo.getWeight());
        }
        inOutResultOrderEo.setConsignmentNo(shippingJsonDto.getConsignNo());
        if (CsPcpBusinessTypeEnum.maiyouAllotList().contains(csTransferOrderEo.getType())) {
            inOutResultOrderEo.setShippingType(StringUtils.isNotBlank((CharSequence)shippingJsonDto.getLogisticsType()) ? shippingJsonDto.getLogisticsType() : shippingJsonDto.getShippingType());
            inOutResultOrderEo.setShippingCompanyCode(shippingJsonDto.getShippingCompanyCode());
            inOutResultOrderEo.setShippingCompany(shippingJsonDto.getShippingCompanyName());
        } else if (StringUtils.isNotBlank((CharSequence)inOutResultOrderEo.getOutPhysicsWarehouseCode())) {
            inOutResultOrderEo.setShippingType((String)ShipmentMappingConstant.SHIPMENT_TYPE_MAP.get(inOutResultOrderEo.getOutPhysicsWarehouseCode()));
            inOutResultOrderEo.setShippingCompanyCode((String)ShipmentMappingConstant.MAPPING.get(inOutResultOrderEo.getOutPhysicsWarehouseCode()));
            inOutResultOrderEo.setShippingCompany((String)ShipmentMappingConstant.SHIPMENT_NAME_MAP.get(inOutResultOrderEo.getOutPhysicsWarehouseCode()));
        }
        inOutResultOrderEo.setShippingCode(shippingJsonDto.getShippingNo());
        inOutResultOrderEo.setTotalCartons(csOutResultOrderEo.getTotalCartons());
        inOutResultOrderEo.setMergeQuantity(csOutResultOrderEo.getMergeQuantity());
        inOutResultOrderEo.setTotalWeight(csOutResultOrderEo.getTotalWeight());
        inOutResultOrderEo.setTotalVolume(csOutResultOrderEo.getTotalVolume());
        infoReqDto.setConsignNo(shippingJsonDto.getConsignNo());
        if (CsPcpBusinessTypeEnum.maiyouAllotList().contains(csTransferOrderEo.getType())) {
            infoReqDto.setLogisticsType(StringUtils.isNotBlank((CharSequence)shippingJsonDto.getLogisticsType()) ? shippingJsonDto.getLogisticsType() : shippingJsonDto.getShippingType());
            infoReqDto.setShippingCompanyCode(shippingJsonDto.getShippingCompanyCode());
            infoReqDto.setShippingCompanyName(shippingJsonDto.getShippingCompanyName());
        } else if (StringUtils.isNotBlank((CharSequence)inOutResultOrderEo.getOutPhysicsWarehouseCode())) {
            infoReqDto.setLogisticsType((String)ShipmentMappingConstant.SHIPMENT_TYPE_MAP.get(inOutResultOrderEo.getOutPhysicsWarehouseCode()));
            infoReqDto.setShippingCompanyCode((String)ShipmentMappingConstant.MAPPING.get(inOutResultOrderEo.getOutPhysicsWarehouseCode()));
            infoReqDto.setShippingCompanyName((String)ShipmentMappingConstant.SHIPMENT_NAME_MAP.get(inOutResultOrderEo.getOutPhysicsWarehouseCode()));
        }
        infoReqDto.setShippingNo(shippingJsonDto.getShippingNo());
        infoReqDto.setWmsOrderNo(shippingJsonDto.getWmsOrderNo());
        infoReqDto.setDeliveryTime(new Date());
        shippingInfoReqDtoList.add(infoReqDto);
        inOutResultOrderEo.setShippingJson(JSON.toJSONString((Object)shippingInfoReqDtoList));
        inOutResultOrderEo.setInOutTime(new Date());
        InOutResultOrderContext outResultOrderContext = (InOutResultOrderContext)context;
        outResultOrderContext.setInOutResultOrderEo(inOutResultOrderEo);
        outResultOrderContext.setInOutResultOrderDetailEoList(inOutResultOrderDetailEoList);
        outResultOrderContext.setShippingInfoReqDtoList((List)shippingInfoReqDtoList);
        log.info("\u9500\u552e\u8ba2\u5355\u7ee7\u627f\u9500\u552e\u8c03\u62e8\u5355\u7269\u6d41\u4fe1\u606f,\u5b8c\u6210\u540econtext:{}", (Object)JSON.toJSONString((Object)outResultOrderContext));
    }

    @Override
    public Boolean orderShipmentCheck(CsInventoryOrderShipmentCheckReqDto inventoryOrderShipmentCheckReqDto) {
        this.logger.info("orderShipmentCheck==>\u67e5\u8be2\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u5355\u4e0e\u672c\u6b21\u7269\u6d41\u5355\u53f7\u662f\u5426\u4e00\u81f4,inventoryOrderShipmentCheckReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOrderShipmentCheckReqDto));
        AssertUtil.isTrue(null != inventoryOrderShipmentCheckReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String sourceNo = inventoryOrderShipmentCheckReqDto.getSourceNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceNo), "\u8ba2\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String shipmentEnterpriseCode = inventoryOrderShipmentCheckReqDto.getShipmentEnterpriseCode();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)shipmentEnterpriseCode), "\u7269\u6d41\u5546\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String shipmentEnterpriseName = inventoryOrderShipmentCheckReqDto.getShipmentEnterpriseName();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)shipmentEnterpriseName), "\u7269\u6d41\u5546\u540d\u79f0\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper ReceiveDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)sourceNo);
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_status", (Object)BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
        List receiveDeliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)ReceiveDeliveryNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)receiveDeliveryNoticeOrderEoList), "\u67e5\u4e0d\u5230\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f");
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)receiveDeliveryNoticeOrderEoList.get(0);
        String deliveryOrderShipmentEnterpriseCode = receiveDeliveryNoticeOrderEo.getShipmentEnterpriseCode();
        if (!shipmentEnterpriseCode.equals(deliveryOrderShipmentEnterpriseCode)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void joinWarehouse(CsInventoryOperateReqDto inventoryOperateReqDto, RelWarehouseEo csRelWarehouseEo) {
        inventoryOperateReqDto.setLogicWarehouseCode(csRelWarehouseEo.getWarehouseCode());
        inventoryOperateReqDto.setLogicWarehouseName(csRelWarehouseEo.getWarehouseName());
        inventoryOperateReqDto.setPhysicsWarehouseCode(csRelWarehouseEo.getRefWarehouseCode());
        inventoryOperateReqDto.setPhysicsWarehouseName(csRelWarehouseEo.getRefWarehouseName());
    }
}

