/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IAdjustmentInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.IAdjustInTransitHandler;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.CodeGenerateUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.AdjustmentInventoryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.AdjustmentInventoryMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AdjustInTransitHandler
implements IAdjustInTransitHandler {
    private static final Logger log = LoggerFactory.getLogger(AdjustInTransitHandler.class);
    @Resource(name="${yunxi.dg.base.project}_AdjustmentInventoryApi")
    IAdjustmentInventoryApi adjustmentInventoryApiImpl;
    @Resource
    ICsLogicInventoryQueryService csLogicInventoryQueryService;
    @Resource
    CsTransferOrderDas csTransferOrderDas;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    AdjustmentInventoryMapper adjustmentInventoryMapper;
    @Resource
    CodeGenerateUtil codeGenerateUtil;
    private static final List<String> handlerTransferTypeList = Lists.newArrayList((Object[])new String[]{CsPcpBusinessTypeEnum.ALLOT_OUT.getCode(), CsPcpBusinessTypeEnum.ALLOT_SALE.getCode(), CsPcpBusinessTypeEnum.ALLOT_SALE_BH.getCode(), CsPcpBusinessTypeEnum.MAIYOU_ALLOT_OUT.getCode()});

    @Override
    public void handle(IAdjustInTransitHandler.AdjustInTransitHandlerVo adjustInTransitHandlerVo) {
        LogicWarehouseEo logicWarehouseEo;
        log.info("\u6267\u884c\u8c03\u6574\u5355\u751f\u6210\u903b\u8f91:{}", (Object)JSONObject.toJSONString((Object)adjustInTransitHandlerVo.getInOutNoticeOrderEo()));
        String transferOrderNo = adjustInTransitHandlerVo.getInOutNoticeOrderEo().getRelevanceNo();
        if (StringUtils.isBlank((CharSequence)transferOrderNo)) {
            log.info("\u8c03\u6574\u5355\u4e0d\u751f\u6210\uff0c\u8c03\u62e8\u5355\u53f7\u4e3a\u7a7a");
            return;
        }
        CsTransferOrderEo transferOrderEo = (CsTransferOrderEo)((ExtQueryChainWrapper)this.csTransferOrderDas.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).one();
        if (null == transferOrderEo) {
            log.info("\u8c03\u6574\u5355\u4e0d\u751f\u6210\uff0c\u8c03\u62e8\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            return;
        }
        if (!handlerTransferTypeList.contains(transferOrderEo.getType())) {
            log.info("\u8c03\u6574\u5355\u4e0d\u751f\u6210\uff0c\u8c03\u62e8\u5355\u7c7b\u578b\u4e0d\u7b26\u5408\u6761\u4ef6");
            return;
        }
        if (Objects.equals(transferOrderEo.getInPhysicsWarehouseCode(), transferOrderEo.getOutPhysicsWarehouseCode())) {
            log.info("\u8c03\u6574\u5355\u4e0d\u751f\u6210\uff0c\u8c03\u62e8\u5355\u540c\u7269\u7406\u4ed3");
            return;
        }
        String logicWarehouseCode = transferOrderEo.getInLogicWarehouseCode();
        if (adjustInTransitHandlerVo.isInFlag()) {
            logicWarehouseCode = adjustInTransitHandlerVo.getInOutResultOrderEo().getInLogicWarehouseCode();
        }
        if (null == (logicWarehouseEo = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)logicWarehouseCode)).one())) {
            log.info("\u8c03\u6574\u5355\u4e0d\u751f\u6210\uff0c{}\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)logicWarehouseCode);
            return;
        }
        LogicWarehouseEo inTransitWarehouseEo = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"subordinate_logic_warehouse_id", (Object)logicWarehouseEo.getId())).one();
        if (null == inTransitWarehouseEo) {
            log.info("\u8c03\u6574\u5355\u4e0d\u751f\u6210\uff0c{}\u903b\u8f91\u4ed3\u5bf9\u5e94\u7684\u5728\u9014\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)logicWarehouseCode);
            return;
        }
        this.doSave(adjustInTransitHandlerVo.getInOutNoticeOrderEo(), adjustInTransitHandlerVo.isInFlag(), adjustInTransitHandlerVo.getInOutResultOrderDetailEoList(), adjustInTransitHandlerVo.getInOutResultOrderEo(), inTransitWarehouseEo, adjustInTransitHandlerVo.getAutoAudit());
    }

    private void doSave(InOutNoticeOrderEo InOutNoticeOrderEo2, boolean inFlag, List<InOutResultOrderDetailEo> InOutNoticeOrderDetailEoList, InOutResultOrderEo InOutResultOrderEo2, LogicWarehouseEo inTransitWarehouse, boolean autoAudit) {
        this.adjustmentInventoryApiImpl.addAdjustmentInventory(this.getAdjustmentInventoryReqDto(InOutNoticeOrderEo2, inFlag, InOutNoticeOrderDetailEoList, InOutResultOrderEo2, inTransitWarehouse, autoAudit));
    }

    private AdjustmentInventoryReqDto getAdjustmentInventoryReqDto(InOutNoticeOrderEo InOutNoticeOrderEo2, boolean inFlag, List<InOutResultOrderDetailEo> InOutNoticeOrderDetailEoList, InOutResultOrderEo InOutResultOrderEo2, LogicWarehouseEo inTransitWarehouse, boolean autoAudit) {
        AdjustmentInventoryReqDto csInventoryAdjustAddReqDto = new AdjustmentInventoryReqDto();
        String adjustNo = this.getAdjustNo();
        csInventoryAdjustAddReqDto.setAdjustmentNo(adjustNo);
        csInventoryAdjustAddReqDto.setPreOrderNo(InOutResultOrderEo2.getDocumentNo());
        csInventoryAdjustAddReqDto.setRelevanceNo(InOutNoticeOrderEo2.getRelevanceNo());
        csInventoryAdjustAddReqDto.setSourceType(inFlag ? "receiveResult" : "deliverResult");
        csInventoryAdjustAddReqDto.setWarehouseCode(inTransitWarehouse.getWarehouseCode());
        csInventoryAdjustAddReqDto.setWarehouseClassify("in_transit");
        csInventoryAdjustAddReqDto.setWarehouseName(inTransitWarehouse.getWarehouseName());
        csInventoryAdjustAddReqDto.setWarehouseId(inTransitWarehouse.getId());
        csInventoryAdjustAddReqDto.setBusinessType(inFlag ? CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT_OUT.getCode() : CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT_IN.getCode());
        csInventoryAdjustAddReqDto.setAdjustmentType(CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT.getCode());
        csInventoryAdjustAddReqDto.setDetailReqDtoList(InOutNoticeOrderDetailEoList.stream().map(r -> this.buildDetail(inFlag, adjustNo, (InOutResultOrderDetailEo)r)).collect(Collectors.toList()));
        csInventoryAdjustAddReqDto.setAutoAuditPass(Boolean.valueOf(autoAudit));
        return csInventoryAdjustAddReqDto;
    }

    private String getAdjustNo() {
        String adjustNo = this.codeGenerateUtil.generateNo("TZ", 4);
        List adjustmentInventoryEos = this.adjustmentInventoryMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(AdjustmentInventoryEo.class).select(new SFunction[]{AdjustmentInventoryEo::getAdjustmentNo}).eq(AdjustmentInventoryEo::getAdjustmentNo, (Object)adjustNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isNotEmpty((Collection)adjustmentInventoryEos)) {
            adjustNo = this.getAdjustNo();
        }
        return adjustNo;
    }

    private AdjustmentInventoryDetailReqDto buildDetail(boolean inFlag, String adjustNo, InOutResultOrderDetailEo r) {
        AdjustmentInventoryDetailReqDto addReqDto = (AdjustmentInventoryDetailReqDto)BeanUtil.copyProperties((Object)r, AdjustmentInventoryDetailReqDto.class, (String[])new String[0]);
        addReqDto.setAdjustmentNo(adjustNo);
        addReqDto.setChangeType(inFlag ? "decrease" : "increase");
        addReqDto.setArtNo(r.getSkuCode());
        addReqDto.setLongCode(r.getSkuCode());
        addReqDto.setBatch(r.getBatch());
        addReqDto.setCargoCode(r.getSkuCode());
        addReqDto.setCargoName(r.getSkuName());
        addReqDto.setChangeQuantity(r.getQuantity());
        if (addReqDto.getProduceTime() == null) {
            CsLogicInventoryRespDto csLogicInventory = this.getCsLogicInventory(r);
            addReqDto.setProduceTime(csLogicInventory.getProduceTime());
            addReqDto.setExpireTime(csLogicInventory.getExpireTime());
        }
        return addReqDto;
    }

    private CsLogicInventoryRespDto getCsLogicInventory(InOutResultOrderDetailEo csOutResultOrderDetailRespDto) {
        CsLogicInventoryQueryDto req = new CsLogicInventoryQueryDto();
        req.setLongCode(csOutResultOrderDetailRespDto.getSkuCode());
        req.setBatch(csOutResultOrderDetailRespDto.getBatch());
        req.setFilterProduceTime(Boolean.valueOf(true));
        req.setPageNum(Integer.valueOf(1));
        req.setPageSize(Integer.valueOf(1));
        return Optional.ofNullable(this.csLogicInventoryQueryService.queryByPage(req).getList()).filter(CollectionUtils::isNotEmpty).map(list -> (CsLogicInventoryRespDto)list.get(0)).orElse(new CsLogicInventoryRespDto());
    }
}

