/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.receive.IReceiveStrategyApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.receive.IReceiveStrategyChannelService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.receive.IReceiveStrategyService;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.receive.ReceiveStrategyChannelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.receive.ReceiveStrategyGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.receive.ReceiveStrategyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.receive.ReceiveStrategyChannelRespDto;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

public abstract class ReceiveStrategyApiImpl
implements IReceiveStrategyApi {
    @Resource
    protected IReceiveStrategyService receiveStrategyService;
    @Resource
    protected IReceiveStrategyChannelService channelService;

    public RestResponse<Long> addReceiveStrategy(ReceiveStrategyReqDto addReqDto) {
        this.checkParam(addReqDto);
        Long id = this.receiveStrategyService.addReceiveStrategy(addReqDto);
        if (!"all".equals(addReqDto.getChannelScope())) {
            for (ReceiveStrategyChannelReqDto itemReqDto : addReqDto.getChannelList()) {
                itemReqDto.setStrategyCode(addReqDto.getStrategyCode());
                itemReqDto.setStrategyName(addReqDto.getStrategyName());
                this.channelService.addReceiveStrategyChannel(itemReqDto);
            }
        }
        return new RestResponse((Object)id);
    }

    public RestResponse<Void> modifyReceiveStrategy(ReceiveStrategyReqDto modifyReqDto) {
        this.checkParam(modifyReqDto);
        this.receiveStrategyService.modifyReceiveStrategy(modifyReqDto);
        if (!"all".equals(modifyReqDto.getChannelScope())) {
            List channelRespDtoList = this.channelService.queryByPage("{strategyCode:'" + modifyReqDto.getChannelScope() + "'}", 1, 100000).getList();
            if (CollectionUtil.isNotEmpty((Collection)channelRespDtoList)) {
                List ids = channelRespDtoList.stream().map(ReceiveStrategyChannelRespDto::getId).collect(Collectors.toList());
                String idStr = StringUtils.join(ids, (String)",");
                this.channelService.removeReceiveStrategyChannel(idStr, 0L);
            }
            for (ReceiveStrategyChannelReqDto itemReqDto : modifyReqDto.getChannelList()) {
                itemReqDto.setStrategyCode(modifyReqDto.getStrategyCode());
                itemReqDto.setStrategyName(modifyReqDto.getStrategyName());
                this.channelService.addReceiveStrategyChannel(itemReqDto);
            }
        }
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeReceiveStrategy(String ids) {
        this.receiveStrategyService.removeReceiveStrategy(ids);
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyReceiveStrategyStatus(String id, String type) {
        this.receiveStrategyService.modifyReceiveStrategyStatus(id, type);
        return RestResponse.VOID;
    }

    public RestResponse<Long> generateReceiveStrategy(ReceiveStrategyGenerateReqDto receiveStrategyGenerateReqDto) {
        Long generateId = this.receiveStrategyService.generateReceiveStrategy(receiveStrategyGenerateReqDto);
        return new RestResponse((Object)generateId);
    }

    public RestResponse<Boolean> editReceiveStrategy(ReceiveStrategyGenerateReqDto receiveStrategyGenerateReqDto) {
        Boolean resFlag = this.receiveStrategyService.editReceiveStrategy(receiveStrategyGenerateReqDto);
        return new RestResponse((Object)resFlag);
    }

    public RestResponse<Boolean> deleteReceiveStrategy(String strategyCode) {
        Boolean resFlag = this.receiveStrategyService.deleteReceiveStrategy(strategyCode);
        return new RestResponse((Object)resFlag);
    }

    public void checkParam(ReceiveStrategyReqDto dto) {
        if (!"all".equals(dto.getChannelScope()) && CollectionUtil.isEmpty((Collection)dto.getChannelList())) {
            throw new BizException("\u5173\u8054\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

