/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.AbstractCsBasicsOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.anno.CsBasicsOrderQueryStrategy;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.basics.CsBasicsOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.basics.CsBasicsOrderRespDto;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@CsBasicsOrderQueryStrategy(strategyName="inOutNoticeOrder")
@Component(value="CsinOutNoticeOrderbasicsOrderStrategyQueryService")
public class CsInOutNoticeOrderQueryServiceImpl
extends AbstractCsBasicsOrderQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsInOutNoticeOrderQueryServiceImpl.class);
    @Resource
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;

    @Override
    public CsBasicsOrderRespDto queryDetailByDocumentNo(String documentNo) {
        List list = this.inOutNoticeOrderDomain.queryByDocumentNo(documentNo);
        List<CsBasicsOrderRespDto> respDtoList = this.getCsBasicsOrderRespDto(list);
        return CollectionUtils.isNotEmpty(respDtoList) ? respDtoList.get(0) : new CsBasicsOrderRespDto();
    }

    @Override
    public List<CsBasicsOrderRespDto> queryDetailByRelevanceNo(String relevanceNo) {
        List list = this.inOutNoticeOrderDomain.queryByRelevanceNo(relevanceNo);
        List<CsBasicsOrderRespDto> respDtoList = this.getCsBasicsOrderRespDto(list);
        return respDtoList;
    }

    @Override
    public CsBasicsOrderRespDto queryByDocumentNo(String documentNo) {
        List list = this.inOutNoticeOrderDomain.queryByDocumentNo(documentNo);
        InOutNoticeOrderEo eo = CollectionUtils.isNotEmpty((Collection)list) ? (InOutNoticeOrderEo)list.get(0) : null;
        CsBasicsOrderRespDto respDto = new CsBasicsOrderRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)eo, (String[])new String[0]);
        return respDto;
    }

    @Override
    public List<CsBasicsOrderRespDto> queryByRelevanceNo(String relevanceNo) {
        List list = this.inOutNoticeOrderDomain.queryByRelevanceNo(relevanceNo);
        ArrayList<CsBasicsOrderRespDto> respDtoList = new ArrayList<CsBasicsOrderRespDto>();
        CubeBeanUtils.copyCollection(respDtoList, (Collection)list, CsBasicsOrderRespDto.class);
        return respDtoList;
    }

    private List<CsBasicsOrderRespDto> getCsBasicsOrderRespDto(List<InOutNoticeOrderEo> orderEos) {
        logger.info("orderEos\u54cd\u5e94=>{}", (Object)JSON.toJSONString(orderEos));
        if (CollectionUtils.isEmpty(orderEos)) {
            logger.info("\u67e5\u8be2\u4e0d\u5230\u8be5\u5165/\u51fa\u5e93\u901a\u77e5\u5355");
            return null;
        }
        ArrayList<CsBasicsOrderRespDto> respDtoList = new ArrayList<CsBasicsOrderRespDto>();
        CubeBeanUtils.copyCollection(respDtoList, orderEos, CsBasicsOrderRespDto.class);
        logger.info("respDtoList\u54cd\u5e94=>{}", (Object)JSON.toJSONString(respDtoList));
        Set documentNoSet = orderEos.stream().filter(e -> Objects.nonNull(e) && StringUtils.isNotBlank((CharSequence)e.getDocumentNo())).map(e -> e.getDocumentNo()).collect(Collectors.toSet());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"document_no", documentNoSet);
        queryWrapper.eq((Object)"dr", (Object)0);
        List detailEos = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)detailEos)) {
            Map<String, List<InOutNoticeOrderDetailEo>> detailMap = detailEos.stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getDocumentNo));
            respDtoList.stream().forEach(dto -> {
                List detailEoList = (List)detailMap.get(dto.getDocumentNo());
                if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
                    ArrayList csBasicsOrderDetailRespDtoList = new ArrayList();
                    CubeBeanUtils.copyCollection(csBasicsOrderDetailRespDtoList, (Collection)detailEoList, CsBasicsOrderDetailRespDto.class);
                    dto.setCsBasicsOrderDetailRespDtoList(csBasicsOrderDetailRespDtoList);
                }
            });
        }
        logger.info("\u8fd4\u56de\u5165/\u51fa\u5e93\u901a\u77e5\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(respDtoList));
        return respDtoList;
    }
}

