/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.shop.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.RandomUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaTreeRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.shop.ICsShopEnquiryApplyDetailExtService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.shop.ICsShopEnquiryApplyExtService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.Assert;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.other.CsShipmenetEnterpriseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.shop.CsShopEnquiryApplyDetailExtDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.shop.CsShopEnquiryApplyExtDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsShipmenetEnterpriseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.shop.CsShopEnquiryApplyDetailExtEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.shop.CsShopEnquiryApplyExtEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.shop.CsShopEnquiryApplyDetailExtMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.shop.CsShopEnquiryApplyExtMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.message.CsInventoryAutoAuditMessageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.shop.CsShopEnquiryApplyAddDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.shop.CsShopEnquiryApplyAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.shop.CsShopEnquiryApplyAuditDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.shop.CsShopEnquiryApplyAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.shop.CsShopEnquiryApplyExtReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.shop.CsShopEnquiryApplyPageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.shop.CsShopEnquiryApplyQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.shop.CsShopEnquiryApplyUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryTotalRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.shop.CsItemAvailableInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.shop.CsShopEnquiryApplyAuditRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.shop.CsShopEnquiryApplyDetailExtRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.shop.CsShopEnquiryApplyExtRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsShopEnquiryApplyStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsShopEnquiryApplyStatusExtEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderSourceExtEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.BdLogicWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.BdLogicWarehousePropertyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.BdTypeOfDocumentEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.PcpBasicInventoryBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsShopEnquiryApplyExtServiceImpl
implements ICsShopEnquiryApplyExtService {
    private static final Logger logger = LoggerFactory.getLogger(CsShopEnquiryApplyExtServiceImpl.class);
    @Resource
    private CsShopEnquiryApplyExtDas csShopEnquiryApplyExtDas;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private CsShopEnquiryApplyDetailExtDas shopEnquiryApplyDetailExtDas;
    @Resource
    private CsShopEnquiryApplyDetailExtMapper csShopEnquiryApplyDetailExtMapper;
    @Resource
    private CsShipmenetEnterpriseDas csShipmenetEnterpriseDas;
    @Resource
    private ICsShopEnquiryApplyDetailExtService csShopEnquiryApplyDetailExtService;
    @Resource
    private IAreaQueryApi areaQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ICsLogicWarehouseService csLogicWarehouseService;
    @Resource
    private CsShopEnquiryApplyExtMapper csShopEnquiryApplyExtMapper;
    @Resource
    private ICommonsMqService mqService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ILockService lockService;
    @Resource
    private ILogicInventoryTotalDomain logicInventoryTotalDomain;
    @Resource
    private ICsLogicWarehouseQueryService csLogicWarehouseQueryService;
    private static final String REMARK = "\u7b2c\u4e09\u65b9\u65b0\u589e\u95e8\u5e97\u8981\u8d27\u5355\uff0c\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addShopEnquiryApplyExt(CsShopEnquiryApplyAddReqDto addReqDto) {
        MessageVo messageVo;
        logger.info("\u65b0\u589e\u95e8\u5e97\u8981\u8d27\u7533\u8bf7\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        CsShopEnquiryApplyExtEo shopEnquiryApplyExtEo = this.addVerify(addReqDto);
        List<CsShopEnquiryApplyDetailExtEo> detailExtList = this.checkDetailInfo(addReqDto, shopEnquiryApplyExtEo.getId());
        Long totalSum = detailExtList.stream().filter(o -> null != o.getNum()).map(CsShopEnquiryApplyDetailExtEo::getNum).reduce(0L, Long::sum);
        shopEnquiryApplyExtEo.setTotalNum(totalSum);
        this.csShopEnquiryApplyExtDas.insert((BaseEo)shopEnquiryApplyExtEo);
        this.shopEnquiryApplyDetailExtDas.insertBatch(detailExtList);
        boolean sendDelaySingleMessage = false;
        if (StringUtils.isNotBlank((CharSequence)shopEnquiryApplyExtEo.getAddress()) && StringUtils.isBlank((CharSequence)shopEnquiryApplyExtEo.getProvinceCode())) {
            messageVo = new MessageVo();
            addReqDto = new CsShopEnquiryApplyAddReqDto();
            addReqDto.setId(shopEnquiryApplyExtEo.getId());
            addReqDto.setRequisitionOrderNo(shopEnquiryApplyExtEo.getRequisitionOrderNo());
            addReqDto.setAddress(shopEnquiryApplyExtEo.getAddress());
            messageVo.setData((Object)JSONObject.toJSONString((Object)addReqDto));
            logger.info("\u53d1\u9001\u5730\u5740\u81ea\u52a8\u8bc6\u522bmq,tagStr:{},messageVo:{}", (Object)"CS_SHOP_ENQUIRY_ADDRESS_RECOGNITION_TAG", (Object)LogUtils.buildLogContent(messageVo));
            this.mqService.sendSingleMessage("SINGLE_TOPIC", "CS_SHOP_ENQUIRY_ADDRESS_RECOGNITION_TAG", (Object)messageVo);
            sendDelaySingleMessage = true;
        }
        messageVo = new MessageVo();
        CsInventoryAutoAuditMessageReqDto auditMessageReqDto = new CsInventoryAutoAuditMessageReqDto();
        String businessTypeCode = 7 == shopEnquiryApplyExtEo.getType() ? PcpBasicInventoryBusinessTypeEnum.SHOP_ENQUIRY.getCode() : PcpBasicInventoryBusinessTypeEnum.SHOP_SALES_WARHEOUSE_SEND.getCode();
        auditMessageReqDto.setBusinessTypeCode(businessTypeCode);
        auditMessageReqDto.setGroupCode(BdTypeOfDocumentEnum.SHOP_ENQUIRY.getCode());
        auditMessageReqDto.setDocumentNo(shopEnquiryApplyExtEo.getOrderNo());
        messageVo.setData((Object)auditMessageReqDto);
        if (sendDelaySingleMessage) {
            logger.info("\u53d1\u9001\u5ef6\u8fdf\u5e93\u5b58\u81ea\u52a8\u5ba1\u6838\u6d88\u8d39\u8005mq\u6d88\u606f,map:{}", (Object)LogUtils.buildLogContent(messageVo));
            this.commonsMqService.sendDelaySingleMessage("SINGLE_TOPIC", "INVENTORY_AUTO_AUDIT_TAG", (Object)messageVo, Long.valueOf(120L));
        } else {
            logger.info("\u53d1\u9001\u5e93\u5b58\u81ea\u52a8\u5ba1\u6838\u6d88\u8d39\u8005mq\u6d88\u606f,map:{}", (Object)LogUtils.buildLogContent(messageVo));
            this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", "INVENTORY_AUTO_AUDIT_TAG", (Object)messageVo);
        }
        return shopEnquiryApplyExtEo.getId();
    }

    private CsShopEnquiryApplyExtEo addVerify(CsShopEnquiryApplyAddReqDto addReqDto) {
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)addReqDto.getInWarehouseCode())).one();
        Assert.notNull(csLogicWarehouseEo, CsInventoryExceptionCode.WAREHOUSE_NOT_EXIST_OR_CODE_ERROR);
        CsShopEnquiryApplyExtEo applyExtEo = (CsShopEnquiryApplyExtEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.csShopEnquiryApplyExtDas.filter().eq((Object)"source_code", (Object)addReqDto.getSourceCode())).ne((Object)"status", (Object)CsShopEnquiryApplyStatusExtEnum.CANCEL.getType())).eq((Object)"dr", (Object)0)).one();
        Assert.isTrue(applyExtEo == null, CsInventoryExceptionCode.SOURCE_CODE_EXIST);
        CsShopEnquiryApplyExtEo shopEnquiryApplyExtEo = CsShopEnquiryApplyExtEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)shopEnquiryApplyExtEo);
        Long id = IdWorker.getId();
        shopEnquiryApplyExtEo.setId(id);
        shopEnquiryApplyExtEo.setOrderNo(id.toString());
        String requisitionOrderNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.SHOP_ENQUIRY_APPLY.getCode()).getCode();
        shopEnquiryApplyExtEo.setRequisitionOrderNo(requisitionOrderNo);
        if (StringUtils.isEmpty((CharSequence)shopEnquiryApplyExtEo.getSourceCode())) {
            shopEnquiryApplyExtEo.setSourceCode(requisitionOrderNo);
        }
        if (null == shopEnquiryApplyExtEo.getSource()) {
            shopEnquiryApplyExtEo.setSource(CsTransferOrderSourceExtEnum.MIDDLE.getCode());
        }
        shopEnquiryApplyExtEo.setInWarehouseId(csLogicWarehouseEo.getId());
        shopEnquiryApplyExtEo.setInWarehouseName(csLogicWarehouseEo.getWarehouseName());
        shopEnquiryApplyExtEo.setStatus(CsShopEnquiryApplyStatusExtEnum.WAIT_AUDIT.getType());
        return shopEnquiryApplyExtEo;
    }

    private void creadeMockData() {
        try {
            CsShopEnquiryApplyAddReqDto csShopEnquiryApplyAddReqDto = new CsShopEnquiryApplyAddReqDto();
            List provinceTreeRespDtos = (List)this.areaQueryApi.queryByLevelForTree(Integer.valueOf(1)).getData();
            AreaTreeRespDto areaTreeRespDto = (AreaTreeRespDto)provinceTreeRespDtos.get(RandomUtil.getInt((int)0, (int)(provinceTreeRespDtos.size() - 1)));
            csShopEnquiryApplyAddReqDto.setProvinceCode(areaTreeRespDto.getCode());
            csShopEnquiryApplyAddReqDto.setProvince(areaTreeRespDto.getName());
            List cityDtos = (List)this.areaQueryApi.queryByParentCode(areaTreeRespDto.getCode()).getData();
            AreaDto city = (AreaDto)cityDtos.get(RandomUtil.getInt((int)0, (int)(cityDtos.size() - 1)));
            csShopEnquiryApplyAddReqDto.setCityCode(city.getCode());
            csShopEnquiryApplyAddReqDto.setCity(city.getName());
            List areaDtos = (List)this.areaQueryApi.queryByParentCode(city.getCode()).getData();
            AreaDto area = (AreaDto)areaDtos.get(RandomUtil.getInt((int)0, (int)(areaDtos.size() - 1)));
            csShopEnquiryApplyAddReqDto.setAreaCode(area.getCode());
            csShopEnquiryApplyAddReqDto.setArea(area.getName());
            csShopEnquiryApplyAddReqDto.setStreet(RandomUtil.generateString((String)"abcdefghijklmnopqrstuvwxyz", (int)10));
            csShopEnquiryApplyAddReqDto.setAddress(csShopEnquiryApplyAddReqDto.getProvince() + csShopEnquiryApplyAddReqDto.getCity() + csShopEnquiryApplyAddReqDto.getArea() + csShopEnquiryApplyAddReqDto.getStreet());
            csShopEnquiryApplyAddReqDto.setContact(RandomUtil.generateString((String)"abcdefghijklmnopqrstuvwxyz", (int)5));
            csShopEnquiryApplyAddReqDto.setPhone("1" + RandomUtil.generateString((String)"0123456789", (int)10));
            List csLogicWarehouseEoList = this.logicWarehouseDomain.selectAll();
            Assert.notEmpty(csLogicWarehouseEoList, CsInventoryExceptionCode.WAREHOUSE_NOT_EXIST_OR_CODE_ERROR);
            LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)csLogicWarehouseEoList.get(RandomUtil.getInt((int)0, (int)(csLogicWarehouseEoList.size() - 1)));
            csShopEnquiryApplyAddReqDto.setInWarehouseCode(logicWarehouseEo.getWarehouseCode());
            csShopEnquiryApplyAddReqDto.setRemark("\u6d4b\u8bd5\u95e8\u5e97\u8981\u8d27\u5355" + RandomUtil.generateString((String)"abcdefghijklmnopqrstuvwxyz", (int)10));
            CsShipmenetEnterpriseEo csShipmenetEnterpriseEo = CsShipmenetEnterpriseEo.newInstance();
            csShipmenetEnterpriseEo.setDr(0);
            List csShipmenetEnterpriseEos = this.csShipmenetEnterpriseDas.select((BaseEo)csShipmenetEnterpriseEo);
            Assert.notEmpty(csShipmenetEnterpriseEos, CsInventoryExceptionCode.SHIPPINGCAMPONY_NOT_EXIST);
            CsShipmenetEnterpriseEo shipmenetEnterpriseEo = (CsShipmenetEnterpriseEo)csShipmenetEnterpriseEos.get(RandomUtil.getInt((int)0, (int)(csShipmenetEnterpriseEos.size() - 1)));
            csShopEnquiryApplyAddReqDto.setShippingCode(shipmenetEnterpriseEo.getShipmentEnterpriseCode());
            csShopEnquiryApplyAddReqDto.setShippingName(shipmenetEnterpriseEo.getShipmentEnterpriseName());
            ArrayList<String> skuCodeList = new ArrayList<String>();
            skuCodeList.add("BD1200000038");
            skuCodeList.add("BD1300000303");
            ArrayList<CsShopEnquiryApplyAddDetailReqDto> csShopEnquiryApplyAddDetailReqDtoList = new ArrayList<CsShopEnquiryApplyAddDetailReqDto>();
            List itemSkuRespDtoList = (List)this.itemSkuQueryApi.queryBySkuCode(skuCodeList).getData();
            for (ItemSkuRespDto itemSkuRespDto : itemSkuRespDtoList) {
                CsShopEnquiryApplyAddDetailReqDto csShopEnquiryApplyAddDetailReqDto = new CsShopEnquiryApplyAddDetailReqDto();
                csShopEnquiryApplyAddDetailReqDto.setCargoCode(itemSkuRespDto.getCode());
                csShopEnquiryApplyAddDetailReqDto.setNum(Long.valueOf(RandomUtil.getInt((int)20, (int)200)));
                csShopEnquiryApplyAddDetailReqDtoList.add(csShopEnquiryApplyAddDetailReqDto);
            }
            csShopEnquiryApplyAddReqDto.setShopEnquiryApplyDetailExtReqDtoList(csShopEnquiryApplyAddDetailReqDtoList);
            csShopEnquiryApplyAddReqDto.setType(Integer.valueOf(7));
            logger.info(JSON.toJSONString((Object)csShopEnquiryApplyAddReqDto));
            this.addShopEnquiryApplyExt(csShopEnquiryApplyAddReqDto);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addShopEnquiryApplySync(CsShopEnquiryApplyAddReqDto addReqDto) {
        logger.info("\u65b0\u589e\u95e8\u5e97\u8981\u8d27\u7533\u8bf7\u5355\u5e76\u81ea\u52a8\u5ba1\u6838\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)addReqDto));
        Long id = this.addShopEnquiryApplyExt(addReqDto);
        List<CsShopEnquiryApplyDetailExtRespDto> applyDetailExtRespDtos = this.csShopEnquiryApplyDetailExtService.queryDetailByApplyId(id);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(applyDetailExtRespDtos), "\u65b0\u589e\u95e8\u5e97\u8981\u8d27\u7533\u8bf7\u5355-\u7b2c\u4e09\u65b9\u8c03\u7528\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        CsShopEnquiryApplyAuditReqDto csShopEnquiryApplyAuditReqDto = new CsShopEnquiryApplyAuditReqDto();
        csShopEnquiryApplyAuditReqDto.setAuditRemark(REMARK);
        csShopEnquiryApplyAuditReqDto.setAuditStatus(YesNoEnum.YES.getValue());
        csShopEnquiryApplyAuditReqDto.setId(id);
        List orderItemReqDtoList = applyDetailExtRespDtos.stream().map(e -> {
            CsShopEnquiryApplyAuditDetailReqDto auditDetailReqDto = new CsShopEnquiryApplyAuditDetailReqDto();
            auditDetailReqDto.setConfirmNum(e.getNum());
            auditDetailReqDto.setId(e.getId());
            return auditDetailReqDto;
        }).collect(Collectors.toList());
        csShopEnquiryApplyAuditReqDto.setCsShopEnquiryApplyAuditDetailReqDtoList(orderItemReqDtoList);
        logger.info("\u5ba1\u6838\u95e8\u5e97\u8981\u8d27\u5355\u5ba1\u6838\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)csShopEnquiryApplyAuditReqDto));
        try {
            this.audit(csShopEnquiryApplyAuditReqDto);
        }
        catch (Exception e2) {
            logger.error("\u65b0\u589e\u95e8\u5e97\u8981\u8d27\u7533\u8bf7\u5355\u7b2c\u4e09\u65b9\u8c03\u7528)\u52a8\u5ba1\u6838\u62a5\u9519:{}", (Object)e2.getLocalizedMessage());
            CsShopEnquiryApplyUpdateReqDto updateReqDto = new CsShopEnquiryApplyUpdateReqDto();
            updateReqDto.setStatus(CsShopEnquiryApplyStatusExtEnum.WAIT_DISTRIBUTION.getType());
            updateReqDto.setId(id);
            logger.info("\u5f02\u5e38\u66f4\u65b0\u95e8\u5e97\u8981\u8d27\u5355\u72b6\u6001\u4e3a\u5f85\u914d\u8d27:{}", (Object)JSON.toJSONString((Object)updateReqDto));
            this.updateStatus(updateReqDto);
        }
        return id;
    }

    @NotNull
    private List<CsShopEnquiryApplyDetailExtEo> checkDetailInfo(CsShopEnquiryApplyAddReqDto csShopEnquiryApplyAddReqDto, Long orderId) {
        List detailExtList = csShopEnquiryApplyAddReqDto.getShopEnquiryApplyDetailExtReqDtoList();
        Assert.isTrue(CollectionUtils.isNotEmpty((Collection)detailExtList), CsInventoryExceptionCode.TRANSFER_CARGO_CAN_NOT_EMPTY);
        List cargoCodes = detailExtList.stream().map(CsShopEnquiryApplyAddDetailReqDto::getCargoCode).collect(Collectors.toList());
        List list = (List)this.itemSkuQueryApi.queryBySkuCode(cargoCodes).getData();
        Assert.isTrue(cargoCodes.size() == list.size(), CsInventoryExceptionCode.CARGO_CODE_NOT_EXIST);
        Map<String, ItemSkuRespDto> cMap = list.stream().collect(Collectors.toMap(ItemSkuRespDto::getCode, c -> c));
        ArrayList<CsShopEnquiryApplyDetailExtEo> csShopEnquiryApplyDetailExtEos = new ArrayList<CsShopEnquiryApplyDetailExtEo>();
        detailExtList.forEach(td -> {
            CsShopEnquiryApplyDetailExtEo csShopEnquiryApplyDetailExtEo = CsShopEnquiryApplyDetailExtEo.newInstance();
            csShopEnquiryApplyDetailExtEo.setCargoName(((ItemSkuRespDto)cMap.get(td.getCargoCode())).getName());
            csShopEnquiryApplyDetailExtEo.setCargoId(((ItemSkuRespDto)cMap.get(td.getCargoCode())).getId());
            csShopEnquiryApplyDetailExtEo.setCargoCode(td.getCargoCode());
            csShopEnquiryApplyDetailExtEo.setNum(td.getNum());
            csShopEnquiryApplyDetailExtEo.setOrderId(orderId);
            csShopEnquiryApplyDetailExtEos.add(csShopEnquiryApplyDetailExtEo);
        });
        return csShopEnquiryApplyDetailExtEos;
    }

    @Override
    public void modifyShopEnquiryApplyExt(CsShopEnquiryApplyExtReqDto modifyReqDto) {
        CsShopEnquiryApplyExtEo shopEnquiryApplyExtEo = new CsShopEnquiryApplyExtEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)shopEnquiryApplyExtEo);
        this.csShopEnquiryApplyExtDas.updateSelective((BaseEo)shopEnquiryApplyExtEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeShopEnquiryApplyExt(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.csShopEnquiryApplyExtDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CsShopEnquiryApplyExtRespDto queryById(Long id) {
        CsShopEnquiryApplyExtEo shopEnquiryApplyExtEo = (CsShopEnquiryApplyExtEo)this.csShopEnquiryApplyExtMapper.selectById((Serializable)id);
        CsShopEnquiryApplyExtRespDto shopEnquiryApplyExtRespDto = new CsShopEnquiryApplyExtRespDto();
        DtoHelper.eo2Dto((BaseEo)shopEnquiryApplyExtEo, (BaseVo)shopEnquiryApplyExtRespDto);
        return shopEnquiryApplyExtRespDto;
    }

    @Override
    public CsShopEnquiryApplyExtRespDto queryByParam(CsShopEnquiryApplyQueryReqDto param) {
        ExtQueryChainWrapper filter = this.csShopEnquiryApplyExtDas.filter();
        this.queryCondition((ExtQueryChainWrapper<CsShopEnquiryApplyExtEo>)filter, param);
        CsShopEnquiryApplyExtEo csShopEnquiryApplyExtEo = (CsShopEnquiryApplyExtEo)filter.one();
        CsShopEnquiryApplyExtRespDto respDto = new CsShopEnquiryApplyExtRespDto();
        if (null != csShopEnquiryApplyExtEo) {
            DtoHelper.eo2Dto((BaseEo)csShopEnquiryApplyExtEo, (BaseVo)respDto);
        }
        return respDto;
    }

    @Override
    public List<CsShopEnquiryApplyExtRespDto> queryByListParam(CsShopEnquiryApplyQueryReqDto param) {
        ExtQueryChainWrapper filter = this.csShopEnquiryApplyExtDas.filter();
        this.queryCondition((ExtQueryChainWrapper<CsShopEnquiryApplyExtEo>)filter, param);
        List list = filter.list();
        ArrayList<CsShopEnquiryApplyExtRespDto> respDtos = new ArrayList<CsShopEnquiryApplyExtRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(o -> {
                CsShopEnquiryApplyExtRespDto respDto = new CsShopEnquiryApplyExtRespDto();
                BeanUtils.copyProperties((Object)o, (Object)respDto);
            });
        }
        return respDtos;
    }

    private void queryCondition(ExtQueryChainWrapper<CsShopEnquiryApplyExtEo> filter, CsShopEnquiryApplyQueryReqDto param) {
        if (null != param.getId()) {
            filter.eq((Object)"id", (Object)param.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSourceCode())) {
            filter.eq((Object)"source_code", (Object)param.getSourceCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getStatus())) {
            filter.eq((Object)"status", (Object)param.getStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getInWarehouseName())) {
            filter.eq((Object)"in_warehouse_name", (Object)param.getInWarehouseName());
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getInWarehouseCode())) {
            filter.eq((Object)"in_warehouse_code", (Object)param.getInWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getRequisitionOrderNo())) {
            filter.eq((Object)"requisition_order_no", (Object)param.getRequisitionOrderNo());
        }
    }

    @Override
    public PageInfo<CsShopEnquiryApplyExtRespDto> queryByPage(CsShopEnquiryApplyPageReqDto csShopEnquiryApplyPageReqDto) {
        logger.info("\u5217\u8868\u67e5\u8be2\u5165\u53c2:" + JSON.toJSONString((Object)csShopEnquiryApplyPageReqDto));
        CsShopEnquiryApplyExtEo shopEnquiryApplyDetailExtEo = new CsShopEnquiryApplyExtEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)csShopEnquiryApplyPageReqDto.getStartTime())) {
            sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)csShopEnquiryApplyPageReqDto.getStartTime()));
        }
        if (StringUtils.isNotEmpty((CharSequence)csShopEnquiryApplyPageReqDto.getEndTime())) {
            sqlFilters.add(SqlFilter.le((String)"create_time", (Object)csShopEnquiryApplyPageReqDto.getEndTime()));
        }
        if (StringUtils.isNotEmpty((CharSequence)csShopEnquiryApplyPageReqDto.getSourceCode())) {
            sqlFilters.add(SqlFilter.like((String)"source_code", (Object)csShopEnquiryApplyPageReqDto.getSourceCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)csShopEnquiryApplyPageReqDto.getInWarehouseName())) {
            sqlFilters.add(SqlFilter.like((String)"in_warehouse_name", (Object)csShopEnquiryApplyPageReqDto.getInWarehouseName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)csShopEnquiryApplyPageReqDto.getStatus())) {
            sqlFilters.add(SqlFilter.eq((String)"status", (Object)csShopEnquiryApplyPageReqDto.getStatus()));
        }
        if (StringUtils.isNotEmpty((CharSequence)csShopEnquiryApplyPageReqDto.getOrderNo())) {
            sqlFilters.add(SqlFilter.eq((String)"order_no", (Object)csShopEnquiryApplyPageReqDto.getOrderNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)csShopEnquiryApplyPageReqDto.getType())) {
            sqlFilters.add(SqlFilter.eq((String)"type", (Object)csShopEnquiryApplyPageReqDto.getType()));
        }
        shopEnquiryApplyDetailExtEo.setSqlFilters(sqlFilters);
        shopEnquiryApplyDetailExtEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.csShopEnquiryApplyExtDas.selectPage((BaseEo)shopEnquiryApplyDetailExtEo, csShopEnquiryApplyPageReqDto.getPageNum(), csShopEnquiryApplyPageReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CsShopEnquiryApplyExtRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancel(Long shopEnquiryId, String cancelRemark) {
        logger.info("\u53d6\u6d88\u95e8\u5e97\u8981\u8d27\u5355id\uff1a{}\uff0c\u53d6\u6d88\u539f\u56e0\uff1a{}", (Object)shopEnquiryId.toString(), (Object)cancelRemark);
        CsShopEnquiryApplyExtEo shopEnquiryApplyExtEo = (CsShopEnquiryApplyExtEo)this.csShopEnquiryApplyExtMapper.selectById((Serializable)shopEnquiryId);
        logger.info("\u67e5\u8be2\u95e8\u5e97\u8981\u8d27\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)shopEnquiryApplyExtEo));
        Assert.notNull(shopEnquiryApplyExtEo, CsInventoryExceptionCode.TRANSFER_ORDER_NOT_EXIST);
        if (CsShopEnquiryApplyStatusExtEnum.CANCEL.getType().equals(shopEnquiryApplyExtEo.getStatus())) {
            return;
        }
        Assert.isTrue((CsShopEnquiryApplyStatusExtEnum.WAIT_AUDIT.getType().equals(shopEnquiryApplyExtEo.getStatus()) || CsShopEnquiryApplyStatusExtEnum.WAIT_DISTRIBUTION.getType().equals(shopEnquiryApplyExtEo.getStatus()) || CsShopEnquiryApplyStatusExtEnum.PROCESSING.getType().equals(shopEnquiryApplyExtEo.getStatus()) ? 1 : 0) != 0, (String)CsInventoryExceptionCode.CANCEL_STATUS_ERROR.getCode(), (String)CsInventoryExceptionCode.CANCEL_STATUS_ERROR.getMsg());
        CsShopEnquiryApplyExtEo shopEnquiryApplyUpdateEo = new CsShopEnquiryApplyExtEo();
        shopEnquiryApplyUpdateEo.setId(shopEnquiryApplyExtEo.getId());
        shopEnquiryApplyUpdateEo.setStatus(CsShopEnquiryApplyStatusExtEnum.CANCEL.getType());
        shopEnquiryApplyUpdateEo.setAuditRemark(cancelRemark);
        this.csShopEnquiryApplyExtDas.updateSelective((BaseEo)shopEnquiryApplyUpdateEo);
        if (CsTransferOrderSourceExtEnum.POS.getCode().equals(shopEnquiryApplyExtEo.getSource())) {
            CsShopEnquiryApplyAddReqDto reqDto = new CsShopEnquiryApplyAddReqDto();
            DtoHelper.eo2Dto((BaseEo)shopEnquiryApplyExtEo, (BaseVo)reqDto);
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)JSONObject.toJSONString((Object)reqDto));
            logger.info("cancel=====>\u5373\u5c06\u53d1\u9001MQ\u901a\u77e5pos\u7533\u8bf7\u8981\u8d27\u5355\u5df2\u53d6\u6d88,messageVo:{}", (Object)LogUtils.buildLogContent(messageVo));
            this.mqService.sendSingleMessage("SINGLE_TOPIC", "PUSH_CANCEL_REQUISITION_ORDER_TO_POS_TAG", (Object)messageVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void distribution(Long shopEnquiryId) {
        CsShopEnquiryApplyExtEo shopEnquiryApplyExtEo = (CsShopEnquiryApplyExtEo)this.csShopEnquiryApplyExtMapper.selectById((Serializable)shopEnquiryId);
        logger.info("\u95e8\u5e97\u8981\u8d27\u7533\u8bf7\u5355\u914d\u8d27\u6839\u636eid\uff1a{}\u67e5\u8be2\u5230\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)shopEnquiryId), (Object)JSON.toJSONString((Object)shopEnquiryApplyExtEo));
        Assert.notNull((Object)shopEnquiryApplyExtEo, (String)CsInventoryExceptionCode.TRANSFER_ORDER_NOT_EXIST.getCode(), (String)CsInventoryExceptionCode.TRANSFER_ORDER_NOT_EXIST.getMsg());
        Assert.isTrue(CsShopEnquiryApplyStatusExtEnum.WAIT_DISTRIBUTION.getType().equals(shopEnquiryApplyExtEo.getStatus()), CsInventoryExceptionCode.DISTRIBUTION_STATUS_ERROR);
        CsShopEnquiryApplyExtEo shopEnquiryApplyUpdateEo = new CsShopEnquiryApplyExtEo();
        shopEnquiryApplyUpdateEo.setId(shopEnquiryApplyExtEo.getId());
        shopEnquiryApplyUpdateEo.setStatus(CsShopEnquiryApplyStatusExtEnum.DISTRIBUTION.getType());
        this.csShopEnquiryApplyExtDas.updateSelective((BaseEo)shopEnquiryApplyUpdateEo);
        HashMap<String, Long> message = new HashMap<String, Long>();
        message.put("id", shopEnquiryApplyExtEo.getId());
        logger.info("\u8fdb\u884c\u95e8\u5e97\u8981\u8d27\u5bfb\u6e90\u548c\u65b0\u589e\u8c03\u62e8\u5355\u64cd\u4f5c,tagStr:{},message:{}", (Object)"SHOP_ENQUIRY_SOURCE_AND_ADD_TRANSFER_ORDER_TAG", (Object)LogUtils.buildLogContent(message));
        this.mqService.sendSingleMessage("SINGLE_TOPIC", "SHOP_ENQUIRY_SOURCE_AND_ADD_TRANSFER_ORDER_TAG", message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public CsShopEnquiryApplyAuditRespDto audit(CsShopEnquiryApplyAuditReqDto csShopEnquiryApplyAuditReqDto) {
        CsShopEnquiryApplyAuditRespDto respDto = new CsShopEnquiryApplyAuditRespDto();
        ArrayList<CsShopEnquiryApplyDetailExtRespDto> detaillist = new ArrayList<CsShopEnquiryApplyDetailExtRespDto>();
        logger.info("\u5ba1\u6838\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)csShopEnquiryApplyAuditReqDto));
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("shopEnquiryApplyAudit", csShopEnquiryApplyAuditReqDto.getId());
            if (null == mutex) {
                throw new BizException("\u5e93\u5b58\u4e2d\u5fc3\uff0c\u95e8\u5e97\u8981\u8d27\u7533\u8bf7\u5355\u5ba1\u6838\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
            }
            CsShopEnquiryApplyExtEo shopEnquiryApplyExtEo = (CsShopEnquiryApplyExtEo)this.csShopEnquiryApplyExtMapper.selectById((Serializable)csShopEnquiryApplyAuditReqDto.getId());
            Integer status = shopEnquiryApplyExtEo.getStatus();
            Assert.notNull(shopEnquiryApplyExtEo, CsInventoryExceptionCode.TRANSFER_ORDER_NOT_EXIST);
            Assert.isTrue(CsShopEnquiryApplyStatusExtEnum.WAIT_AUDIT.getType().equals(status) || CsShopEnquiryApplyStatusExtEnum.PORTION_AUDIT.getType().equals(status), CsInventoryExceptionCode.SEPARATE_AUDIT_STATUS_ERROR);
            if (YesNoEnum.YES.getValue().equals(csShopEnquiryApplyAuditReqDto.getAuditStatus())) {
                List<LogicWarehouseEo> csLogicWarehouseEos = this.csLogicWarehouseService.queryByExcludeWarehouseType(BdLogicWarehouseClassifyEnum.JD.getCode(), BdLogicWarehouseClassifyEnum.CAINIAO.getCode(), BdLogicWarehouseClassifyEnum.STORE.getCode(), BdLogicWarehouseClassifyEnum.MATERIAL_AFTER_SALE.getCode());
                Assert.notEmpty(csLogicWarehouseEos, CsInventoryExceptionCode.OUT_WAREHOUSE_ANY_NOT_EXIST);
                Long num = 0L;
                num = this.getNum();
                Long confirmNum = 0L;
                confirmNum = this.getConfirmNum();
                List<String> cargoCodes = csShopEnquiryApplyAuditReqDto.getCsShopEnquiryApplyAuditDetailReqDtoList().stream().map(CsShopEnquiryApplyAuditDetailReqDto::getCargoCode).collect(Collectors.toList());
                List<CsLogicInventoryTotalRespDto> inventoryTotalRespDtos = this.getInventoryList(cargoCodes);
                Map<String, List<CsLogicInventoryTotalRespDto>> dtoMap = inventoryTotalRespDtos.stream().collect(Collectors.groupingBy(CsLogicInventoryTotalRespDto::getCargoCode));
                Long totalConfirmNum = 0L;
                for (CsShopEnquiryApplyAuditDetailReqDto detailReqDto : csShopEnquiryApplyAuditReqDto.getCsShopEnquiryApplyAuditDetailReqDtoList()) {
                    CsShopEnquiryApplyDetailExtEo detailExtEo = (CsShopEnquiryApplyDetailExtEo)this.csShopEnquiryApplyDetailExtMapper.selectById((Serializable)detailReqDto.getId());
                    List<CsItemAvailableInventoryRespDto> respDtos = this.csShopEnquiryApplyDetailExtService.queryItemAvailableInventory(Collections.singletonList(detailExtEo.getCargoCode()));
                    Long availableNum = 0L;
                    if (CollectionUtils.isNotEmpty(respDtos)) {
                        availableNum = ParamConverter.convertToLong((Object)respDtos.get(0).getAvailableInventory());
                    }
                    Long channelInventory = Objects.isNull(detailReqDto.getChannelInventory()) ? 0L : detailReqDto.getChannelInventory();
                    Long outletTotalInventory = 0L;
                    List<CsLogicInventoryTotalRespDto> totalRespDtos = dtoMap.get(detailReqDto.getCargoCode());
                    BigDecimal totalInventory = new BigDecimal(0);
                    if (CollectionUtils.isNotEmpty(totalRespDtos)) {
                        for (CsLogicInventoryTotalRespDto totalRespDto : totalRespDtos) {
                            if (!Objects.nonNull(totalRespDto.getBalance())) continue;
                            totalInventory = totalInventory.add(totalRespDto.getBalance());
                        }
                    }
                    outletTotalInventory = totalInventory.longValue();
                    Assert.isTrue(detailReqDto.getConfirmNum() >= 0L, CsInventoryExceptionCode.NUM_NOT_CORRECT);
                    Assert.isTrue(Objects.nonNull(detailReqDto.getConfirmNum()), CsInventoryExceptionCode.CONFIRM_NUM_NULL_ERROR);
                    Assert.isTrue((detailReqDto.getConfirmNum() <= detailExtEo.getNum() && detailReqDto.getConfirmNum() <= availableNum ? 1 : 0) != 0, (String)"500", (String)("\u4ee5\u4e0b\u5546\u54c1\u5b9e\u7269\u4ed3\u5e93\u5b58\u4e0d\u8db3\uff0c\u5ba1\u6838\u5931\u8d25\uff1a" + detailExtEo.getCargoCode()));
                    logger.info("\u95e8\u5e97\u6e20\u9053\u4ed3\u5e93\u5b58\u6821\u9a8c======>" + detailExtEo.getCargoCode() + ",\u95e8\u5e97\u6e20\u9053\u4ed3\u5e93\u5b58channelInventory:" + channelInventory + ",\u95e8\u5e97\u903b\u8f91\u4ed3\u603b\u5e93\u5b58outletTotalInventory:" + outletTotalInventory + ",\u6240\u6709\u95e8\u5e97\u5f53\u524d\u672a\u5904\u7406\u5b8c\u6210\u7684\u8981\u8d27\u7533\u8bf7\u6570\u91cfnum:" + num + ",\u786e\u8ba4\u8981\u8d27\u603b\u6570\u91cfconfirmNum:" + confirmNum);
                    if (channelInventory - outletTotalInventory - num < confirmNum && !csShopEnquiryApplyAuditReqDto.getCheckedAgain().booleanValue()) {
                        logger.info("\u95e8\u5e97\u6e20\u9053\u4ed3\u5e93\u5b58\u4e0d\u8db3,\u5ba1\u6838\u5931\u8d25");
                        CsShopEnquiryApplyDetailExtRespDto extRespDto = new CsShopEnquiryApplyDetailExtRespDto();
                        extRespDto.setCargoCode(detailExtEo.getCargoCode());
                        detaillist.add(extRespDto);
                        respDto.setDetailExtRespDtos(detaillist);
                        CsShopEnquiryApplyAuditRespDto csShopEnquiryApplyAuditRespDto = respDto;
                        this.lockService.unlock(mutex);
                        return csShopEnquiryApplyAuditRespDto;
                    }
                    totalConfirmNum = totalConfirmNum + detailReqDto.getConfirmNum();
                    CsShopEnquiryApplyDetailExtEo csShopEnquiryApplyDetailExtEo = CsShopEnquiryApplyDetailExtEo.newInstance();
                    csShopEnquiryApplyDetailExtEo.setId(detailReqDto.getId());
                    csShopEnquiryApplyDetailExtEo.setConfirmNum(detailReqDto.getConfirmNum());
                    this.shopEnquiryApplyDetailExtDas.updateSelective((BaseEo)csShopEnquiryApplyDetailExtEo);
                }
                DtoHelper.dto2Eo((BaseVo)csShopEnquiryApplyAuditReqDto, (BaseEo)shopEnquiryApplyExtEo);
                shopEnquiryApplyExtEo.setTotalConfirmNum(totalConfirmNum);
                shopEnquiryApplyExtEo.setStatus(CsShopEnquiryApplyStatusExtEnum.DISTRIBUTION.getType());
                shopEnquiryApplyExtEo.setAuditPerson(StringUtils.isNotBlank((CharSequence)this.context.userName()) ? this.context.userName() : "system");
                shopEnquiryApplyExtEo.setAuditTime(new Date());
                this.csShopEnquiryApplyExtDas.updateSelective((BaseEo)shopEnquiryApplyExtEo);
                HashMap<String, Long> message = new HashMap<String, Long>();
                message.put("id", shopEnquiryApplyExtEo.getId());
                logger.info("\u5ba1\u6838\u901a\u8fc7\u53d1\u9001mq\u5230mgmt\u6d88\u8d39\uff0c\u8fdb\u884c\u95e8\u5e97\u8981\u8d27\u5bfb\u6e90\u548c\u65b0\u589e\u8c03\u62e8\u5355\u64cd\u4f5c,tagStr:{},message:{}", (Object)"SHOP_ENQUIRY_SOURCE_AND_ADD_TRANSFER_ORDER_TAG", (Object)LogUtils.buildLogContent(message));
                this.mqService.sendDelaySingleMessage("SINGLE_TOPIC", "SHOP_ENQUIRY_SOURCE_AND_ADD_TRANSFER_ORDER_TAG", message, Long.valueOf(3L));
            }
            Assert.notNull(csShopEnquiryApplyAuditReqDto.getAuditRemark(), CsInventoryExceptionCode.AUDIT_REMARK_NOT_NULL);
            shopEnquiryApplyExtEo.setStatus(CsShopEnquiryApplyStatusExtEnum.CLOSE.getType());
            shopEnquiryApplyExtEo.setAuditRemark(StringUtils.isNotBlank((CharSequence)csShopEnquiryApplyAuditReqDto.getAuditRemark()) ? csShopEnquiryApplyAuditReqDto.getAuditRemark() : "");
            shopEnquiryApplyExtEo.setAuditPerson(StringUtils.isNotBlank((CharSequence)this.context.userName()) ? this.context.userName() : "system");
            shopEnquiryApplyExtEo.setAuditTime(new Date());
            this.csShopEnquiryApplyExtDas.updateSelective((BaseEo)shopEnquiryApplyExtEo);
            CsShopEnquiryApplyAddReqDto reqDto = new CsShopEnquiryApplyAddReqDto();
            DtoHelper.eo2Dto((BaseEo)shopEnquiryApplyExtEo, (BaseVo)reqDto);
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)JSONObject.toJSONString((Object)reqDto));
            logger.info("audit=====>\u5373\u5c06\u53d1\u9001MQ\u901a\u77e5pos\u7533\u8bf7\u8981\u8d27\u5355\u5df2\u53d6\u6d88,messageVo:{}", (Object)LogUtils.buildLogContent(messageVo));
            this.mqService.sendSingleMessage("SINGLE_TOPIC", "PUSH_CANCEL_REQUISITION_ORDER_TO_POS_TAG", (Object)messageVo);
        }
        catch (Exception e) {
            try {
                logger.info("\u95e8\u5e97\u8981\u8d27\u7533\u8bf7\u5355\u5ba1\u6838\u5f02\u5e38\uff1a{}", (Object)e.getLocalizedMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
        return null;
    }

    @Override
    public List<CsShopEnquiryApplyExtRespDto> queryByExcludeStatus(Boolean flag, List<Integer> status) {
        ArrayList<CsShopEnquiryApplyExtRespDto> respDtos = new ArrayList<CsShopEnquiryApplyExtRespDto>();
        List eos = new ArrayList();
        ExtQueryChainWrapper filter = this.csShopEnquiryApplyExtDas.filter();
        filter.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        eos = flag != false ? ((ExtQueryChainWrapper)filter.in((Object)"status", status)).list() : ((ExtQueryChainWrapper)filter.notIn((Object)"status", status)).list();
        if (CollectionUtils.isNotEmpty(eos)) {
            CubeBeanUtils.copyCollection(respDtos, eos, CsShopEnquiryApplyExtRespDto.class);
        }
        return respDtos;
    }

    @Override
    public CsShopEnquiryApplyExtRespDto queryBySourceCode(String sourceCode) {
        CsShopEnquiryApplyExtEo query = new CsShopEnquiryApplyExtEo();
        query.setSourceCode(sourceCode);
        CsShopEnquiryApplyExtEo shopEnquiryApplyExtEo = (CsShopEnquiryApplyExtEo)this.csShopEnquiryApplyExtDas.selectOne((BaseEo)query);
        if (shopEnquiryApplyExtEo == null) {
            return null;
        }
        CsShopEnquiryApplyExtRespDto respDto = new CsShopEnquiryApplyExtRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)shopEnquiryApplyExtEo, (String[])new String[0]);
        return respDto;
    }

    @Override
    public void updateStatus(CsShopEnquiryApplyUpdateReqDto csShopEnquiryApplyUpdateReqDto) {
        logger.info("\u66f4\u65b0\u72b6\u6001\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)csShopEnquiryApplyUpdateReqDto));
        AssertUtil.isTrue(Objects.nonNull(csShopEnquiryApplyUpdateReqDto), "\u66f4\u65b0\u72b6\u6001\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(csShopEnquiryApplyUpdateReqDto.getId()) || StringUtils.isNotBlank((CharSequence)csShopEnquiryApplyUpdateReqDto.getRequisitionOrderNo()), "\u66f4\u65b0\u72b6\u6001\u95e8\u5e97\u8981\u8d27\u5355\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(csShopEnquiryApplyUpdateReqDto.getStatus()), "\u66f4\u65b0\u72b6\u6001\u5165\u53c2\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        CsShopEnquiryApplyExtRespDto respDto = new CsShopEnquiryApplyExtRespDto();
        if (Objects.nonNull(csShopEnquiryApplyUpdateReqDto.getId())) {
            respDto = this.queryById(csShopEnquiryApplyUpdateReqDto.getId());
            logger.info("\u6839\u636eid\uff1a{} \u67e5\u8be2\u5230\u95e8\u5e97\u8981\u8d27\u5355\u4fe1\u606f\uff1a{}", (Object)csShopEnquiryApplyUpdateReqDto.getId().toString(), (Object)JSON.toJSONString((Object)respDto));
        } else {
            CsShopEnquiryApplyQueryReqDto param = new CsShopEnquiryApplyQueryReqDto();
            param.setRequisitionOrderNo(csShopEnquiryApplyUpdateReqDto.getRequisitionOrderNo());
            respDto = this.queryByParam(param);
        }
        AssertUtil.isTrue(Objects.nonNull(respDto), "\u627e\u4e0d\u5230\u95e8\u5e97\u8981\u8d27\u5355\u4fe1\u606f");
        if (csShopEnquiryApplyUpdateReqDto.getStatus().equals(respDto.getStatus())) {
            return;
        }
        if (CsShopEnquiryApplyStatusExtEnum.PROCESSING.getType().equals(csShopEnquiryApplyUpdateReqDto.getStatus()) || CsShopEnquiryApplyStatusExtEnum.WAIT_DISTRIBUTION.getType().equals(csShopEnquiryApplyUpdateReqDto.getStatus())) {
            AssertUtil.isTrue(CsShopEnquiryApplyStatusExtEnum.DISTRIBUTION.getType().equals(respDto.getStatus()), String.format("\u8981\u8d27\u5355\u72b6\u6001\u662f\u914d\u8d27\u4e2d\u624d\u80fd\u66f4\u65b0\u4e3a:%s", CsShopEnquiryApplyStatusExtEnum.getDescByStatus((Integer)csShopEnquiryApplyUpdateReqDto.getStatus())));
        }
        if (CsShopEnquiryApplyStatusExtEnum.COMPLETE.getType().equals(csShopEnquiryApplyUpdateReqDto.getStatus())) {
            AssertUtil.isTrue(CsShopEnquiryApplyStatusExtEnum.PROCESSING.getType().equals(respDto.getStatus()), String.format("\u8981\u8d27\u5355\u72b6\u6001\u662f\u5904\u7406\u4e2d\u624d\u80fd\u66f4\u65b0\u4e3a:%s", CsShopEnquiryApplyStatusExtEnum.getDescByStatus((Integer)csShopEnquiryApplyUpdateReqDto.getStatus())));
        }
        CsShopEnquiryApplyExtEo eo = new CsShopEnquiryApplyExtEo();
        eo.setStatus(csShopEnquiryApplyUpdateReqDto.getStatus());
        eo.setId(respDto.getId());
        this.csShopEnquiryApplyExtMapper.updateById((BaseEo)eo);
    }

    @Override
    @Transactional
    public void updateShopEnquiryApplyExt(CsShopEnquiryApplyAddReqDto updateReqDto) {
        logger.info("\u66f4\u65b0\u95e8\u5e97\u8981\u8d27\u7533\u8bf7\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)updateReqDto));
        Assert.isTrue((null != updateReqDto.getId() ? 1 : 0) != 0, (String)"500", (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)updateReqDto.getInWarehouseCode())).one();
        Assert.notNull(csLogicWarehouseEo, CsInventoryExceptionCode.WAREHOUSE_NOT_EXIST_OR_CODE_ERROR);
        CsShopEnquiryApplyExtEo applyExtEo = (CsShopEnquiryApplyExtEo)((ExtQueryChainWrapper)this.csShopEnquiryApplyExtDas.filter().eq((Object)"source_code", (Object)updateReqDto.getSourceCode())).one();
        Assert.isTrue(Objects.equals(applyExtEo.getId(), updateReqDto.getId()), CsInventoryExceptionCode.SOURCE_CODE_EXIST);
        CsShopEnquiryApplyExtEo shopEnquiryApplyExtEo = CsShopEnquiryApplyExtEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)updateReqDto, (BaseEo)shopEnquiryApplyExtEo);
        shopEnquiryApplyExtEo.setOrderNo(updateReqDto.getId().toString());
        shopEnquiryApplyExtEo.setInWarehouseId(csLogicWarehouseEo.getId());
        shopEnquiryApplyExtEo.setInWarehouseName(csLogicWarehouseEo.getWarehouseName());
        shopEnquiryApplyExtEo.setStatus(CsShopEnquiryApplyStatusExtEnum.WAIT_AUDIT.getType());
        this.csShopEnquiryApplyExtDas.updateSelective((BaseEo)shopEnquiryApplyExtEo);
        List detailExtReqDtoList = updateReqDto.getShopEnquiryApplyDetailExtReqDtoList();
        if (CollectionUtils.isNotEmpty((Collection)detailExtReqDtoList)) {
            List cargoCodes = detailExtReqDtoList.stream().map(CsShopEnquiryApplyAddDetailReqDto::getCargoCode).collect(Collectors.toList());
            List cargos = ((ExtQueryChainWrapper)this.shopEnquiryApplyDetailExtDas.filter().in((Object)"cargo_code", cargoCodes)).list();
            List ids = cargos.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.csShopEnquiryApplyDetailExtMapper.deleteBatchIds(ids);
        }
        List<CsShopEnquiryApplyDetailExtEo> detailExtList = this.checkDetailInfo(updateReqDto, updateReqDto.getId());
        this.shopEnquiryApplyDetailExtDas.insertBatch(detailExtList);
    }

    @Override
    public void updateShopEnquiryApplyExtByParam(Long id, CsShopEnquiryApplyAddReqDto param) {
        CsShopEnquiryApplyExtEo eo = (CsShopEnquiryApplyExtEo)((ExtQueryChainWrapper)this.csShopEnquiryApplyExtDas.filter().eq((Object)"id", (Object)id)).one();
        AssertUtil.isTrue(eo != null, "ID\u4e3a\u3010" + id + "\u3011\u7684\u95e8\u5e97\u8981\u8d27\u5355\u4e0d\u5b58\u5728\uff01");
        logger.info("\u95e8\u5e97\u8981\u8d27\u5355:{},\u66f4\u65b0\u53c2\u6570param:{}", (Object)id, (Object)JSON.toJSONString((Object)param));
        CsShopEnquiryApplyExtEo applyExtEo = new CsShopEnquiryApplyExtEo();
        applyExtEo.setId(id);
        this.setParam(eo, param);
        this.csShopEnquiryApplyExtDas.updateSelective((BaseEo)eo);
    }

    private void setParam(CsShopEnquiryApplyExtEo eo, CsShopEnquiryApplyAddReqDto param) {
        if (Objects.nonNull(param.getSource())) {
            eo.setSource(param.getSource());
        }
        if (Objects.nonNull(param.getSourceCode())) {
            eo.setSourceCode(param.getSourceCode());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getInWarehouseCode())) {
            eo.setInWarehouseCode(param.getInWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getInWarehouseName())) {
            eo.setInWarehouseName(param.getInWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getShippingCode())) {
            eo.setShippingCode(param.getShippingCode());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getShippingName())) {
            eo.setShippingName(param.getShippingName());
        }
        if (Objects.nonNull(param.getType())) {
            eo.setType(param.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getExternalShopCode())) {
            eo.setExternalShopCode(param.getExternalShopCode());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getExternalShopName())) {
            eo.setExternalShopName(param.getExternalShopName());
        }
        if (Objects.nonNull(param.getSgOrderId())) {
            eo.setSgOrderId(param.getSgOrderId());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getProvinceCode())) {
            eo.setProvinceCode(param.getProvinceCode());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getProvince())) {
            eo.setProvince(param.getProvince());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getCityCode())) {
            eo.setCityCode(param.getCityCode());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getCity())) {
            eo.setCity(param.getCity());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getAreaCode())) {
            eo.setAreaCode(param.getAreaCode());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getArea())) {
            eo.setArea(param.getArea());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getStreet())) {
            eo.setStreet(param.getStreet());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getAddress())) {
            eo.setAddress(param.getAddress());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getPhone())) {
            eo.setPhone(param.getPhone());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getContact())) {
            eo.setContact(param.getContact());
        }
    }

    private Long getNum() {
        Long num = 0L;
        List<CsShopEnquiryApplyExtRespDto> waitAudit = this.queryByExcludeStatus(false, Arrays.asList(CsShopEnquiryApplyStatusEnum.WAIT_AUDIT.getCode()));
        List waitAuditIds = waitAudit.stream().map(CsShopEnquiryApplyExtRespDto::getOrderNo).collect(Collectors.toList());
        List waitAuditCargos = ((ExtQueryChainWrapper)this.shopEnquiryApplyDetailExtDas.filter().in((Object)"order_id", waitAuditIds)).list();
        logger.info("\u5df2\u5ba1\u6838\u8981\u8d27\u5355\u7684\u5546\u54c1\u5217\u8868waitAuditCargos:{}", (Object)waitAuditCargos);
        if (CollectionUtils.isNotEmpty((Collection)waitAuditCargos)) {
            for (CsShopEnquiryApplyDetailExtEo waitAuditCargo : waitAuditCargos) {
                num = (long)waitAuditCargo.getNum();
            }
        }
        return num;
    }

    private Long getConfirmNum() {
        Long confirmNum = 0L;
        List<CsShopEnquiryApplyExtRespDto> audited = this.queryByExcludeStatus(true, Arrays.asList(CsShopEnquiryApplyStatusEnum.WAIT_AUDIT.getCode()));
        List auditedIds = audited.stream().map(CsShopEnquiryApplyExtRespDto::getOrderNo).collect(Collectors.toList());
        List auditedCargos = ((ExtQueryChainWrapper)this.shopEnquiryApplyDetailExtDas.filter().in((Object)"order_id", auditedIds)).list();
        logger.info("\u5df2\u5ba1\u6838\u8981\u8d27\u5355\u7684\u5546\u54c1\u5217\u8868auditedCargos:{}", (Object)auditedCargos);
        if (CollectionUtils.isNotEmpty((Collection)auditedCargos)) {
            for (CsShopEnquiryApplyDetailExtEo auditedCargo : auditedCargos) {
                if (!Objects.nonNull(auditedCargo.getConfirmNum())) continue;
                confirmNum = (long)auditedCargo.getConfirmNum();
            }
        }
        return confirmNum;
    }

    private List<CsLogicInventoryTotalRespDto> getInventoryList(List<String> cargoCodes) {
        CsLogicWarehouseQueryDto logicWarehouseQueryDto = new CsLogicWarehouseQueryDto();
        logicWarehouseQueryDto.setWarehouseProperty(BdLogicWarehousePropertyEnum.OUTLET.getCode());
        List<CsLogicWarehouseRespDto> csLogicWarehouseRespDtos = this.csLogicWarehouseQueryService.queryByParam(logicWarehouseQueryDto);
        List<Object> warehouseCodes = new ArrayList();
        if (CollectionUtils.isNotEmpty(csLogicWarehouseRespDtos)) {
            warehouseCodes = csLogicWarehouseRespDtos.stream().map(CsLogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toList());
        }
        List inventoryTotalEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryTotalDomain.filter().in((Object)"sku_code", cargoCodes)).in((Object)"warehouse_code", warehouseCodes)).list();
        return inventoryTotalEos.stream().map(r -> {
            CsLogicInventoryTotalRespDto csLogicInventoryTotalRespDto = (CsLogicInventoryTotalRespDto)BeanUtil.copyProperties((Object)r, CsLogicInventoryTotalRespDto.class, (String[])new String[0]);
            csLogicInventoryTotalRespDto.setCargoCode(r.getSkuCode());
            csLogicInventoryTotalRespDto.setCargoName(r.getSkuName());
            return csLogicInventoryTotalRespDto;
        }).collect(Collectors.toList());
    }
}

