/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsWarehouseAddressQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsWarehouseAddressRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class LogicWarehouseApiImpl
implements ICsLogicWarehouseApi {
    private static final Logger log = LoggerFactory.getLogger(LogicWarehouseApiImpl.class);
    @Autowired
    protected ICsLogicWarehouseService csLogicWarehouseService;
    @Autowired
    protected ICsLogicWarehouseQueryService csLogicWarehouseQueryService;
    @Autowired
    protected ICsWarehouseAddressQueryService csWarehouseAddressQueryService;

    public RestResponse<Long> add(CsLogicWarehouseAddReqDto addReqDto) {
        log.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csLogicWarehouseService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsLogicWarehouseUpdateReqDto updateReqDto) {
        log.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.csLogicWarehouseService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        log.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csLogicWarehouseService.delete(id);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addLogicWarehouse(CsLogicWarehouseAddReqDto addReqDto) {
        addReqDto.setNegativeFlag(addReqDto.getWarehouseIsNegative());
        Long warehouseId = this.csLogicWarehouseService.addLogicWarehouse(addReqDto);
        return new RestResponse((Object)warehouseId);
    }

    public RestResponse<CsLogicWarehouseRespDto> queryByPrimaryKey(Long id) {
        log.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        CsLogicWarehouseRespDto dto = this.csLogicWarehouseQueryService.selectByPrimaryKey(id);
        dto.setWarehouseIsNegative(dto.getNegativeFlag());
        AssertUtil.isTrue(dto != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        Long warehouseId = dto.getId();
        WarehouseAddressEo csWarehouseAddressEo = this.csWarehouseAddressQueryService.selectByWarehouseId(warehouseId);
        CsWarehouseAddressRespDto warehouseAddressRespDto = null;
        if (null != csWarehouseAddressEo) {
            warehouseAddressRespDto = new CsWarehouseAddressRespDto();
            CubeBeanUtils.copyProperties((Object)warehouseAddressRespDto, (Object)csWarehouseAddressEo, (String[])new String[0]);
        }
        dto.setWarehouseAddress(warehouseAddressRespDto);
        return new RestResponse((Object)dto);
    }

    public RestResponse<PageInfo<CsLogicWarehouseRespDto>> queryByPage(CsLogicWarehouseQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        return new RestResponse(this.csLogicWarehouseQueryService.queryByPage(queryDto));
    }

    public RestResponse<List<CsLogicWarehouseRespDto>> queryByParam(CsLogicWarehouseQueryDto queryDto) {
        log.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto));
        return new RestResponse(this.csLogicWarehouseQueryService.queryByParam(queryDto));
    }

    public RestResponse<CsLogicWarehouseRespDto> queryReturnWarehouseByOrganizationId(Long organizationId) {
        log.info("\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u5173\u8054\u7684\u9ed8\u8ba4\u9000\u8d27\u4ed3\u4fe1\u606f\uff1a[{}]", (Object)organizationId);
        return new RestResponse((Object)this.csLogicWarehouseQueryService.queryReturnWarehouseByOrganizationId(organizationId));
    }

    public RestResponse<CsLogicWarehouseRespDto> queryByCodeAndFlag(String warehouseCode) {
        log.info("\u6839\u636e\u4ed3\u5e93\u7f16\u53f7\u67e5\u8be2\u4ed3\u5e93\u4fe1\u606f\uff1a[{}]", (Object)warehouseCode);
        return new RestResponse((Object)this.csLogicWarehouseQueryService.queryByCodeAndFlag(warehouseCode));
    }
}

