/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInspectionReleaseTaskService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsCancelReqDto;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INVENTORY_BUSINESS_TOPIC", tag="WMS_CANCEL_COMPLETE")
public class WmsCancelProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(WmsCancelProcess.class);
    @Autowired
    IInspectionReleaseTaskService inspectionReleaseTaskService;
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;

    public MessageResponse process(MessageVo message) {
        log.info("WmsCancelProcess\uff1a{}", (Object)LogUtils.buildLogContent(message));
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        CsBasicsCancelReqDto cancelReqDto = (CsBasicsCancelReqDto)JSONObject.parseObject((String)message.getData().toString(), CsBasicsCancelReqDto.class);
        log.info("errorByTransferCancel : {}", (Object)cancelReqDto.getNoticeOrderNo());
        QueryWrapper csOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        csOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)cancelReqDto.getNoticeOrderNo());
        csOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutNoticeOrderEo csOutNoticeOrderEo = (InOutNoticeOrderEo)this.inOutNoticeOrderDomain.getMapper().selectOne((Wrapper)csOutNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(null != csOutNoticeOrderEo, "\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        this.cancelOtherOut(csOutNoticeOrderEo);
        this.cancelTransfer(csOutNoticeOrderEo);
        this.errorByTransferCancel(csOutNoticeOrderEo);
        return MessageResponse.SUCCESS;
    }

    private void errorByTransferCancel(InOutNoticeOrderEo csOutNoticeOrderEo) {
        try {
            String relevanceNo = csOutNoticeOrderEo.getRelevanceNo();
            log.info("errorByTransferCancel : {}", (Object)relevanceNo);
            this.inspectionReleaseTaskService.errorByTransferCancel(relevanceNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("errorByTransferCancel \u5931\u8d25\uff1a{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void cancelOtherOut(InOutNoticeOrderEo csOutNoticeOrderEo) {
        try {
            String relevanceNo = csOutNoticeOrderEo.getRelevanceNo();
            log.info("cancelOtherOut : {}", (Object)relevanceNo);
            this.inspectionReleaseTaskService.cancelOtherOut(relevanceNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("cancelOtherOut \u5931\u8d25\uff1a{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void cancelTransfer(InOutNoticeOrderEo csOutNoticeOrderEo) {
        try {
            String relevanceNo = csOutNoticeOrderEo.getRelevanceNo();
            log.info("cancelTransfer : {}", (Object)relevanceNo);
            this.inspectionReleaseTaskService.cancelTransfer(relevanceNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("cancelTransfer \u5931\u8d25\uff1a{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

