/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.IOrderPreemptWrapperHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.other.CsShipmenetEnterpriseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsShipmenetEnterpriseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsShipmenetEnterpriseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicPreemptInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutDeliveryDetailMessageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutDeliveryMessageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsBaseOrderAddressAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBaseOrderAddressContactsTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentTypeEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderPreemptWrapperHelperImpl
implements IOrderPreemptWrapperHelper {
    private static final Logger log = LoggerFactory.getLogger(OrderPreemptWrapperHelperImpl.class);
    @Resource
    private ICommonsMqService mqService;
    @Resource
    private CsShipmenetEnterpriseDas csShipmenetEnterpriseDas;
    @Autowired
    private CsShipmenetEnterpriseMapper shipmenetEnterpriseMapper;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    private final String DEFAULT_OTHER = "OTHER";
    private final String DEFALUT_NO = "XN123456";
    private final String ZT = "ZT";
    private final String OTHER = "OTHER";
    private final String ZT_SHIPMENT_NO = "zitifahuo";
    private final String OTHER_SHIPMENT_NO = "xunifahuo";

    @Override
    public void wrapperOrderInfo(ReceiveDeliveryNoticeOrderContext deliveryNoticeOrderContext, CsInventoryOperateReqDto inventoryOperateReqDto, CsLogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = deliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderEo();
        this.wrapperOrderInfo(deliveryNoticeOrderContext, inventoryOperateReqDto);
        receiveDeliveryNoticeOrderEo.setRepairOrderNo(deliveryNoticeOrderContext.getRelevanceNo());
        receiveDeliveryNoticeOrderEo.setSourcePlatformCode((String)DataExtractUtils.ifNullElse((Object)logicPreemptInventoryOperateReqDto.getSourcePlatformCode(), (Object)inventoryOperateReqDto.getPlatformOrderNo()));
        receiveDeliveryNoticeOrderEo.setOaidOrderSourceCode(logicPreemptInventoryOperateReqDto.getOaidOrderSourceCode());
        receiveDeliveryNoticeOrderEo.setPayTime(logicPreemptInventoryOperateReqDto.getPayTime());
        receiveDeliveryNoticeOrderEo.setTradeOrderCreateTime(logicPreemptInventoryOperateReqDto.getTradeOrderCreateTime());
        receiveDeliveryNoticeOrderEo.setExchangePlatformAfterSaleOrderNo(logicPreemptInventoryOperateReqDto.getExchangePlatformAfterSaleOrderNo());
        receiveDeliveryNoticeOrderEo.setShopId(logicPreemptInventoryOperateReqDto.getShopId());
        receiveDeliveryNoticeOrderEo.setShopCode(logicPreemptInventoryOperateReqDto.getShopCode());
        receiveDeliveryNoticeOrderEo.setShopName(logicPreemptInventoryOperateReqDto.getShopName());
        if (StringUtils.isNotBlank((CharSequence)logicPreemptInventoryOperateReqDto.getExchangeOrderNo())) {
            receiveDeliveryNoticeOrderEo.setExtension(logicPreemptInventoryOperateReqDto.getExchangeOrderNo());
        }
        List baseOrderAddressEoList = CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderContext.getBaseOrderAddressEoList()) ? deliveryNoticeOrderContext.getBaseOrderAddressEoList() : new ArrayList();
        List<BaseOrderAddressEo> insertEos = this.setBaseAddressInfo(logicPreemptInventoryOperateReqDto);
        if (CollectionUtils.isNotEmpty(insertEos)) {
            baseOrderAddressEoList.addAll(insertEos);
            deliveryNoticeOrderContext.setBaseOrderAddressEoList(baseOrderAddressEoList);
        }
        this.copyDeliveryToContext(deliveryNoticeOrderContext, receiveDeliveryNoticeOrderEo);
    }

    @Override
    public void wrapperOrderInfo(ReceiveDeliveryNoticeOrderContext deliveryNoticeOrderContext, CsInventoryOperateReqDto inventoryOperateReqDto) {
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = deliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderEo();
        receiveDeliveryNoticeOrderEo.setShipmentEnterpriseCode(inventoryOperateReqDto.getShipmentEnterpriseCode());
        receiveDeliveryNoticeOrderEo.setShipmentEnterpriseName((String)DataExtractUtils.ifNullElse((Object)inventoryOperateReqDto.getShipmentEnterpriseName(), t -> this.getShipmentEnterpriseInfo(receiveDeliveryNoticeOrderEo, inventoryOperateReqDto.getShipmentEnterpriseCode())));
        receiveDeliveryNoticeOrderEo.setYfRepairOrderNo(inventoryOperateReqDto.getYfRepairOrderNo());
        this.copyDeliveryToContext(deliveryNoticeOrderContext, receiveDeliveryNoticeOrderEo);
    }

    @Override
    public void copyDeliveryToContext(ReceiveDeliveryNoticeOrderContext deliveryNoticeOrderContext, ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo) {
        deliveryNoticeOrderContext.setShipmentEnterpriseCode(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseCode());
        deliveryNoticeOrderContext.setShipmentEnterpriseName(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseName());
        deliveryNoticeOrderContext.setYfRepairOrderNo(receiveDeliveryNoticeOrderEo.getYfRepairOrderNo());
        deliveryNoticeOrderContext.setSourcePlatformCode(receiveDeliveryNoticeOrderEo.getSourcePlatformCode());
        deliveryNoticeOrderContext.setOaidOrderSourceCode(receiveDeliveryNoticeOrderEo.getOaidOrderSourceCode());
        deliveryNoticeOrderContext.setPayTime(receiveDeliveryNoticeOrderEo.getPayTime());
        deliveryNoticeOrderContext.setTradeOrderCreateTime(receiveDeliveryNoticeOrderEo.getTradeOrderCreateTime());
        deliveryNoticeOrderContext.setExchangePlatformAfterSaleOrderNo(receiveDeliveryNoticeOrderEo.getExchangePlatformAfterSaleOrderNo());
        deliveryNoticeOrderContext.setShopId(receiveDeliveryNoticeOrderEo.getShopId());
        deliveryNoticeOrderContext.setShopCode(receiveDeliveryNoticeOrderEo.getShopCode());
        deliveryNoticeOrderContext.setShopName(receiveDeliveryNoticeOrderEo.getShopName());
        deliveryNoticeOrderContext.setShipmentEnterpriseCode(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseCode());
        deliveryNoticeOrderContext.setShipmentEnterpriseName(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseName());
        deliveryNoticeOrderContext.setYfRepairOrderNo(receiveDeliveryNoticeOrderEo.getYfRepairOrderNo());
        deliveryNoticeOrderContext.setRepairOrderNo(receiveDeliveryNoticeOrderEo.getRepairOrderNo());
    }

    private String getShipmentEnterpriseInfo(ReceiveDeliveryNoticeOrderEo csDeliveryNoticeOrderEo, String shipmentEnterpriseCode) {
        log.info("buildShipmentEnterpriseInfo==>\u7269\u6d41\u5546\u4fe1\u606f\u76f8\u5173,deliveryNoticeOrderNo:{},shipmentEnterpriseCode:{}", (Object)csDeliveryNoticeOrderEo.getDocumentNo(), (Object)shipmentEnterpriseCode);
        if (StringUtils.isBlank((CharSequence)shipmentEnterpriseCode)) {
            return "";
        }
        csDeliveryNoticeOrderEo.setShipmentEnterpriseCode(shipmentEnterpriseCode);
        List csShipmenetEnterpriseEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.csShipmenetEnterpriseDas.filter().eq((Object)"shipment_enterprise_code", (Object)shipmentEnterpriseCode)).eq((Object)"shipment_enterprise_status", (Object)YesNoEnum.YES.getValue())).list();
        if (CollectionUtils.isEmpty((Collection)csShipmenetEnterpriseEoList)) {
            return "";
        }
        CsShipmenetEnterpriseEo csShipmenetEnterpriseEo = (CsShipmenetEnterpriseEo)csShipmenetEnterpriseEoList.get(0);
        return csShipmenetEnterpriseEo.getShipmentEnterpriseName();
    }

    @Override
    public void setCompleteCallBack(CsInventoryOperateReqDto inventoryOperateReqDto, ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo) {
        receiveDeliveryNoticeOrderFacadeBo.setCompleteCallBack(context -> {
            BigDecimal total = inventoryOperateReqDto.getOperateCargoReqDtoList().stream().map(CsInventoryOperateCargoReqDto::getChangeInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
            List messageDtos = inventoryOperateReqDto.getOperateCargoReqDtoList().stream().map(detailRespDto -> {
                CsOutDeliveryDetailMessageDto deliveryDetailMessageDto = new CsOutDeliveryDetailMessageDto();
                deliveryDetailMessageDto.setOrderNo(receiveDeliveryNoticeOrderFacadeBo.getRelevanceNo());
                deliveryDetailMessageDto.setOutQuantity(detailRespDto.getChangeInventory());
                deliveryDetailMessageDto.setLongCode((String)DataExtractUtils.ifNullElse((Object)detailRespDto.getCargoCode(), (Object)detailRespDto.getLongCode()));
                deliveryDetailMessageDto.setBatch(detailRespDto.getBatch());
                deliveryDetailMessageDto.setTradeOrderItemId(detailRespDto.getTradeOrderItemId());
                return deliveryDetailMessageDto;
            }).collect(Collectors.toList());
            CsOutDeliveryMessageDto csOutDeliveryMessageDto = new CsOutDeliveryMessageDto();
            csOutDeliveryMessageDto.setOrderNo(receiveDeliveryNoticeOrderFacadeBo.getRelevanceNo());
            csOutDeliveryMessageDto.setTotalQuantity(total);
            csOutDeliveryMessageDto.setTotalCartons(BigDecimal.ZERO);
            csOutDeliveryMessageDto.setMergeQuantity(BigDecimal.ZERO);
            csOutDeliveryMessageDto.setDeliveryDetailMessageDtoList(messageDtos);
            csOutDeliveryMessageDto.setDeliveryTime(new Date());
            csOutDeliveryMessageDto.setCommonBack(Boolean.valueOf(true));
            List outResultOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)context.getRelevanceNo())).eq((Object)"order_type", (Object)"out")).list();
            Optional.ofNullable(outResultOrderEos).filter(CollectionUtils::isNotEmpty).map(r -> ((InOutResultOrderEo)r.get(0)).getShippingJson()).filter(StringUtils::isNotBlank).map(shippingJson -> JSON.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class)).ifPresent(csWmsShippingInfoReqDtoList -> {
                CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)csWmsShippingInfoReqDtoList.get(0);
                csOutDeliveryMessageDto.setShippingNo(csWmsShippingInfoReqDto.getShippingNo());
                csOutDeliveryMessageDto.setShipmentEnterpriseCode(csWmsShippingInfoReqDto.getShippingCompanyCode());
                csOutDeliveryMessageDto.setShipmentEnterpriseName(csWmsShippingInfoReqDto.getShippingCompanyName());
                csWmsShippingInfoReqDtoList.stream().filter(e -> Objects.isNull(e.getDeliveryTime())).forEach(e -> e.setDeliveryTime(csOutDeliveryMessageDto.getDeliveryTime()));
                log.info("noticeOrderSend==>\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3,csWmsShippingInfoReqDtoList:{}", (Object)LogUtils.buildLogContent(csWmsShippingInfoReqDtoList));
                csOutDeliveryMessageDto.setShippingInfoList(csWmsShippingInfoReqDtoList);
            });
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)csOutDeliveryMessageDto);
            log.info("outDelivery==>\u5373\u5c06\u53d1\u9001MQ\u901a\u77e5\u8ba2\u5355\u5df2\u53d1\u8d27,messageVo:{}", (Object)LogUtils.buildLogContent(messageVo));
            this.mqService.sendDelaySingleMessage("ORDER_SALE_WMS_SEND_BACK_TAG", (Object)messageVo, Long.valueOf(30L));
        });
    }

    private List<BaseOrderAddressEo> setBaseAddressInfo(CsLogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        CsBaseOrderAddressAddReqDto receivePersonAddressInfo;
        ArrayList<BaseOrderAddressEo> baseOrderAddressEoList = new ArrayList<BaseOrderAddressEo>();
        CsBaseOrderAddressAddReqDto sendPersonAddressInfo = logicPreemptInventoryOperateReqDto.getSendPersonAddressInfo();
        if (null != sendPersonAddressInfo) {
            BaseOrderAddressEo csBaseOrderAddressEo = new BaseOrderAddressEo();
            csBaseOrderAddressEo.setOrderType(CsDocumentTypeEnum.DELIVERY_NOTICE_ORDER.getCode());
            csBaseOrderAddressEo.setContactsType(CsBaseOrderAddressContactsTypeEnum.CONSIGNOR.getCode());
            csBaseOrderAddressEo.setProvince(sendPersonAddressInfo.getProvince());
            csBaseOrderAddressEo.setEncryptProvince(sendPersonAddressInfo.getEncryptProvince());
            csBaseOrderAddressEo.setProvinceCode(sendPersonAddressInfo.getProvinceCode());
            csBaseOrderAddressEo.setEncryptProvinceCode(sendPersonAddressInfo.getEncryptProvinceCode());
            csBaseOrderAddressEo.setCity(sendPersonAddressInfo.getCity());
            csBaseOrderAddressEo.setEncryptCity(sendPersonAddressInfo.getEncryptCity());
            csBaseOrderAddressEo.setCityCode(sendPersonAddressInfo.getCityCode());
            csBaseOrderAddressEo.setEncryptCityCode(sendPersonAddressInfo.getEncryptCityCode());
            csBaseOrderAddressEo.setDistrict(sendPersonAddressInfo.getDistrict());
            csBaseOrderAddressEo.setEncryptDistrict(sendPersonAddressInfo.getEncryptDistrict());
            csBaseOrderAddressEo.setDistrictCode(sendPersonAddressInfo.getDistrictCode());
            csBaseOrderAddressEo.setEncryptDistrictCode(sendPersonAddressInfo.getEncryptDistrictCode());
            csBaseOrderAddressEo.setDetailAddress(sendPersonAddressInfo.getDetailAddress());
            csBaseOrderAddressEo.setEncryptDetailAddress(sendPersonAddressInfo.getEncryptDetailAddress());
            csBaseOrderAddressEo.setContacts(sendPersonAddressInfo.getContacts());
            csBaseOrderAddressEo.setEncryptContacts(sendPersonAddressInfo.getEncryptContacts());
            csBaseOrderAddressEo.setPhone(sendPersonAddressInfo.getPhone());
            csBaseOrderAddressEo.setEncryptPhone(sendPersonAddressInfo.getEncryptPhone());
            csBaseOrderAddressEo.setOaid(sendPersonAddressInfo.getOaid());
            baseOrderAddressEoList.add(csBaseOrderAddressEo);
        }
        if (null != (receivePersonAddressInfo = logicPreemptInventoryOperateReqDto.getReceivePersonAddressInfo())) {
            BaseOrderAddressEo csBaseOrderAddressEo = new BaseOrderAddressEo();
            csBaseOrderAddressEo.setOrderType(CsDocumentTypeEnum.DELIVERY_NOTICE_ORDER.getCode());
            csBaseOrderAddressEo.setContactsType(CsBaseOrderAddressContactsTypeEnum.CONSIGNEE.getCode());
            csBaseOrderAddressEo.setProvince(receivePersonAddressInfo.getProvince());
            csBaseOrderAddressEo.setEncryptProvince(receivePersonAddressInfo.getEncryptProvince());
            csBaseOrderAddressEo.setProvinceCode(receivePersonAddressInfo.getProvinceCode());
            csBaseOrderAddressEo.setEncryptProvinceCode(receivePersonAddressInfo.getEncryptProvinceCode());
            csBaseOrderAddressEo.setCity(receivePersonAddressInfo.getCity());
            csBaseOrderAddressEo.setEncryptCity(receivePersonAddressInfo.getEncryptCity());
            csBaseOrderAddressEo.setCityCode(receivePersonAddressInfo.getCityCode());
            csBaseOrderAddressEo.setEncryptCityCode(receivePersonAddressInfo.getEncryptCityCode());
            csBaseOrderAddressEo.setDistrict(receivePersonAddressInfo.getDistrict());
            csBaseOrderAddressEo.setEncryptDistrict(receivePersonAddressInfo.getEncryptDistrict());
            csBaseOrderAddressEo.setDistrictCode(receivePersonAddressInfo.getDistrictCode());
            csBaseOrderAddressEo.setEncryptDistrictCode(receivePersonAddressInfo.getEncryptDistrictCode());
            csBaseOrderAddressEo.setDetailAddress(receivePersonAddressInfo.getDetailAddress());
            csBaseOrderAddressEo.setEncryptDetailAddress(receivePersonAddressInfo.getEncryptDetailAddress());
            csBaseOrderAddressEo.setContacts(receivePersonAddressInfo.getContacts());
            csBaseOrderAddressEo.setEncryptContacts(receivePersonAddressInfo.getEncryptContacts());
            csBaseOrderAddressEo.setPhone(receivePersonAddressInfo.getPhone());
            csBaseOrderAddressEo.setEncryptPhone(receivePersonAddressInfo.getEncryptPhone());
            csBaseOrderAddressEo.setOaid(receivePersonAddressInfo.getOaid());
            baseOrderAddressEoList.add(csBaseOrderAddressEo);
        }
        return baseOrderAddressEoList;
    }

    @Override
    public ReceiveDeliveryNoticeOrderFacadeBo getPreemptFacadeBo(CsInventoryOperateReqDto inventoryOperateReqDto) {
        ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        receiveDeliveryNoticeOrderFacadeBo.setBusinessType(inventoryOperateReqDto.getBusinessType());
        receiveDeliveryNoticeOrderFacadeBo.setSourceType(inventoryOperateReqDto.getSourceType());
        receiveDeliveryNoticeOrderFacadeBo.setExternalOrderNo(inventoryOperateReqDto.getPlatformOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setPreOrderNo(null);
        receiveDeliveryNoticeOrderFacadeBo.setDisplayBusinessType(inventoryOperateReqDto.getBasicDataBusinessType());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceNo((String)DataExtractUtils.ifNullElse((Object)inventoryOperateReqDto.getRelevanceNo(), (Object)inventoryOperateReqDto.getSourceNo()));
        receiveDeliveryNoticeOrderFacadeBo.setLogicWarehouseCode(Optional.ofNullable(inventoryOperateReqDto.getLogicWarehouseCode()).filter(StringUtils::isNotEmpty).orElseGet(() -> ((CsInventoryOperateCargoReqDto)inventoryOperateReqDto.getOperateCargoReqDtoList().get(0)).getWarehouseCode()));
        ArrayList deliveryNoticeOrderDetails = Lists.newArrayList();
        for (CsInventoryOperateCargoReqDto detail : inventoryOperateReqDto.getOperateCargoReqDtoList()) {
            BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
            detailReqDto.setPreOrderItemId((Long)DataExtractUtils.ifNullElse((Object)detail.getTradeOrderItemId(), (Object)detail.getId()));
            detailReqDto.setBatch(detail.getBatch());
            detailReqDto.setQuantity(BigDecimalUtils.abs((BigDecimal)detail.getChangeInventory()));
            detailReqDto.setSkuCode((String)DataExtractUtils.ifNullElse((Object)detail.getLongCode(), (Object)detail.getCargoCode()));
            detailReqDto.setSkuName(detail.getCargoName());
            detailReqDto.setExpireTime(detail.getExpireTime());
            detailReqDto.setProduceTime(detail.getProduceTime());
            deliveryNoticeOrderDetails.add(detailReqDto);
        }
        receiveDeliveryNoticeOrderFacadeBo.setOrderBasicsDetailReqDtoList((List)deliveryNoticeOrderDetails);
        return receiveDeliveryNoticeOrderFacadeBo;
    }

    @Override
    public List<CsWmsShippingInfoReqDto> shipmentDispose(InOutNoticeOrderEo inOutNoticeOrderEo) {
        log.info("shipmentDispose==>\u7279\u6b8a\u5904\u7406\uff0c\u9488\u5bf9\u4e8e\u81ea\u63d0\u548c\u5176\u4ed6\u7c7b\u578b\u7684\u7269\u6d41\u5355,InOutNoticeOrderEo#documentNo:{},basicsReceiveBasicsReqDto:{}", (Object)inOutNoticeOrderEo.getDocumentNo(), (Object)LogUtils.buildLogContent(inOutNoticeOrderEo));
        String shipmentEnterpriseCode = inOutNoticeOrderEo.getShipmentEnterpriseCode();
        if (!"ZT".equals(shipmentEnterpriseCode) && !"OTHER".equals(shipmentEnterpriseCode)) {
            return Lists.newArrayList();
        }
        String shippingJson = inOutNoticeOrderEo.getShippingJson();
        if (StringUtils.isNotBlank((CharSequence)shippingJson)) {
            return Lists.newArrayList();
        }
        String shippingNo = "zitifahuo";
        String shippingCompany = "ZT";
        if ("OTHER".equals(shipmentEnterpriseCode)) {
            shippingNo = "xunifahuo";
            shippingCompany = "OTHER";
        }
        ArrayList<CsWmsShippingInfoReqDto> shippingInfoReqDtoList = new ArrayList<CsWmsShippingInfoReqDto>(1);
        CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = new CsWmsShippingInfoReqDto();
        csWmsShippingInfoReqDto.setShippingNo(shippingNo);
        csWmsShippingInfoReqDto.setShippingCompanyCode(shippingCompany);
        csWmsShippingInfoReqDto.setShippingCompanyName(this.getShipmentName(shippingCompany));
        csWmsShippingInfoReqDto.setOutNoticeOrderNo(inOutNoticeOrderEo.getDocumentNo());
        csWmsShippingInfoReqDto.setPlatformOrderNo(inOutNoticeOrderEo.getExternalOrderNo());
        csWmsShippingInfoReqDto.setDeliveryTime(new Date());
        shippingInfoReqDtoList.add(csWmsShippingInfoReqDto);
        log.info("shipmentDispose==>\u7279\u6b8a\u5904\u7406\uff0c\u9488\u5bf9\u4e8e\u81ea\u63d0\u548c\u5176\u4ed6\u7c7b\u578b\u7684\u7269\u6d41\u5355,shippingInfoReqDtoList:{}", (Object)LogUtils.buildLogContent(shippingInfoReqDtoList));
        return shippingInfoReqDtoList;
    }

    private String getShipmentName(String shippingCompanyCode) {
        QueryWrapper csShipmenetEnterpriseEoQueryWrapper = new QueryWrapper();
        csShipmenetEnterpriseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csShipmenetEnterpriseEoQueryWrapper.eq((Object)"shipment_enterprise_code", (Object)shippingCompanyCode);
        csShipmenetEnterpriseEoQueryWrapper.eq((Object)"shipment_enterprise_status", (Object)YesNoEnum.YES.getValue());
        List csShipmenetEnterpriseEoList = this.shipmenetEnterpriseMapper.selectList((Wrapper)csShipmenetEnterpriseEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csShipmenetEnterpriseEoList)) {
            return null;
        }
        return ((CsShipmenetEnterpriseEo)csShipmenetEnterpriseEoList.get(0)).getShipmentEnterpriseName();
    }
}

