/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IThirdWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ThirdWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ThirdWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.ThirdWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.ThirdWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.ThirdWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ThirdWarehouseServiceImpl
implements IThirdWarehouseService {
    @Resource
    private ThirdWarehouseDas thirdWarehouseDas;
    @Resource
    private ThirdWarehouseMapper thirdWarehouseMapper;

    @Override
    public Long addThirdWarehouse(ThirdWarehouseReqDto addReqDto) {
        this.condition(addReqDto);
        ThirdWarehouseEo thirdWarehouseEo = new ThirdWarehouseEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)thirdWarehouseEo);
        this.thirdWarehouseDas.insert((BaseEo)thirdWarehouseEo);
        return thirdWarehouseEo.getId();
    }

    @Override
    public void modifyThirdWarehouse(ThirdWarehouseReqDto modifyReqDto) {
        this.condition(modifyReqDto);
        AssertUtil.isTrue(!Objects.isNull(modifyReqDto.getId()), "id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ThirdWarehouseEo thirdWarehouseEo = new ThirdWarehouseEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)thirdWarehouseEo);
        this.thirdWarehouseDas.updateSelective((BaseEo)thirdWarehouseEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeThirdWarehouse(List<String> ids) {
        AssertUtil.isTrue(!CollectionUtil.isEmpty(ids), "id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (String id : ids) {
            this.thirdWarehouseDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ThirdWarehouseRespDto queryById(Long id) {
        AssertUtil.isTrue(!Objects.isNull(id), "id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ThirdWarehouseEo thirdWarehouseEo = (ThirdWarehouseEo)this.thirdWarehouseDas.selectByPrimaryKey(id);
        ThirdWarehouseRespDto thirdWarehouseRespDto = new ThirdWarehouseRespDto();
        DtoHelper.eo2Dto((BaseEo)thirdWarehouseEo, (BaseVo)thirdWarehouseRespDto);
        return thirdWarehouseRespDto;
    }

    @Override
    public PageInfo<ThirdWarehouseRespDto> queryByPage(ThirdWarehouseReqDto reqDto, Integer pageNum, Integer pageSize) {
        ExtQueryChainWrapper filter = new ExtQueryChainWrapper((BaseMapper)this.thirdWarehouseMapper, true);
        filter.orderByDesc((Object)"update_time");
        if (StringUtil.isNotEmpty((String)reqDto.getWarehouseName())) {
            filter.like((Object)"warehouse_name", (Object)reqDto.getWarehouseName());
        }
        if (StringUtil.isNotEmpty((String)reqDto.getWarehouseCode())) {
            filter.like((Object)"warehouse_code", (Object)reqDto.getWarehouseCode());
        }
        if (StringUtil.isNotEmpty((String)reqDto.getVerifySign())) {
            filter.like((Object)"verify_sign", (Object)reqDto.getVerifySign());
        }
        PageInfo eoPageInfo = filter.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ThirdWarehouseRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    public void condition(ThirdWarehouseReqDto reqDto) {
        AssertUtil.isTrue(!Objects.isNull(reqDto), "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isTrue(!StringUtil.isEmpty((String)reqDto.getWarehouseCode()), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isTrue(!StringUtil.isEmpty((String)reqDto.getWarehouseName()), "\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }
}

