/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsPhysicsWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsPhysicsWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsWarehouseAddressRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class PhysicsWarehouseApiImpl
implements ICsPhysicsWarehouseApi {
    private static final Logger log = LoggerFactory.getLogger(PhysicsWarehouseApiImpl.class);
    @Autowired
    protected ICsPhysicsWarehouseService csPhysicsWarehouseService;
    @Resource
    protected ICsPhysicsWarehouseQueryService csPhysicsWarehouseQueryService;
    @Autowired
    protected IWarehouseAddressDomain warehouseAddressDomain;

    public RestResponse<Long> add(CsPhysicsWarehouseAddReqDto addReqDto) {
        log.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csPhysicsWarehouseService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsPhysicsWarehouseUpdateReqDto updateReqDto) {
        log.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csPhysicsWarehouseService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        log.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csPhysicsWarehouseService.delete(id);
        return RestResponse.VOID;
    }

    public RestResponse<Long> initPhysicsWarehouse(CsPhysicsWarehouseAddReqDto addReqDto) {
        Long physicsWarehouseId = this.csPhysicsWarehouseService.initPhysicsWarehouse(addReqDto);
        return new RestResponse((Object)physicsWarehouseId);
    }

    public RestResponse<Long> initPhysicsWarehouseByOrganizationIdList(List<Long> organizationIdList) {
        return null;
    }

    public RestResponse<Void> updatePhysicsWarehouse(Long id, CsPhysicsWarehouseUpdateReqDto updateReqDto) {
        this.csPhysicsWarehouseService.updatePhysicsWarehouse(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<CsPhysicsWarehouseRespDto> queryByPrimaryKey(Long id) {
        log.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        PhysicsWarehouseEo eo = this.csPhysicsWarehouseQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        CsPhysicsWarehouseRespDto dto = new CsPhysicsWarehouseRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)eo, (String[])new String[0]);
        if (eo != null || eo.getId() != null) {
            WarehouseAddressEo csWarehouseAddressEo = new WarehouseAddressEo();
            csWarehouseAddressEo.setWarehouseId(id);
            csWarehouseAddressEo.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
            List warehouseAddressEos = this.warehouseAddressDomain.selectList((BaseEo)csWarehouseAddressEo);
            if (CollectionUtils.isNotEmpty((Collection)warehouseAddressEos)) {
                CsWarehouseAddressRespDto warehouseAddressRespDto = new CsWarehouseAddressRespDto();
                CubeBeanUtils.copyProperties((Object)warehouseAddressRespDto, warehouseAddressEos.get(0), (String[])new String[0]);
                dto.setWarehouseAddress(warehouseAddressRespDto);
            }
        }
        return new RestResponse((Object)dto);
    }

    public RestResponse<PageInfo<CsPhysicsWarehouseRespDto>> queryByPage(CsPhysicsWarehouseQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        return new RestResponse(this.csPhysicsWarehouseQueryService.queryByPage(queryDto));
    }

    public RestResponse<List<CsPhysicsWarehouseRespDto>> queryByParam(CsPhysicsWarehouseQueryDto queryDto) {
        log.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto));
        return new RestResponse(this.csPhysicsWarehouseQueryService.queryByParam(queryDto));
    }
}

