/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.config.OrderInformMqConfig;
import com.dtyunxi.yundt.cube.center.inventory.biz.dto.MqCommonDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.IMqCommonsService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.IMqMessageService;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.MqContentOrderDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsStorageSendMqReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.MqMessageEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderInformMqService {
    private final Logger logger = LoggerFactory.getLogger(OrderInformMqService.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IMqMessageService mqMessageService;
    @Resource
    private OrderInformMqConfig orderInformMqConfig;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IMqCommonsService commonsService;
    private static final String SRC_SYSTEM = "OTHER";

    public void sendDeliverOrderInformMq(String messageKey) {
        MqCommonDto mqCommonDto = new MqCommonDto();
        mqCommonDto.setMessageKey(messageKey);
        mqCommonDto.setSrcSystem(SRC_SYSTEM);
        mqCommonDto.setOrigin(false);
        mqCommonDto.setContent(null);
        mqCommonDto.setMethod(this.orderInformMqConfig.getMethod());
        mqCommonDto.setUrl(this.orderInformMqConfig.getUrl());
        String msg = JSONObject.toJSONString((Object)mqCommonDto);
        this.logger.info("=================\u53d1\u9001\u53d1\u8d27\u901a\u77e5\u5355MQ================={}", (Object)msg);
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage(this.orderInformMqConfig.getDeliverOrderInformExchange(), this.orderInformMqConfig.getDeliverOrderInformRouteKey(), (Object)msg);
        this.commonsService.saveMqSendLog(this.orderInformMqConfig.getDeliverOrderInformExchange(), this.orderInformMqConfig.getDeliverOrderInformRouteKey(), msg, messageResponse);
    }

    public boolean sendOutInNoticeReceiveDeliveryMq(CsStorageSendMqReqDto csStorageSendMqReqDto) {
        String message;
        String tag;
        if (MqMessageEnum.Type.OUT_IN_NOTICE_ORDER.getType().equals(csStorageSendMqReqDto.getType())) {
            tag = "CREATE_OUT_IN_NOTICE_ORDER_TAG";
            message = "\u521b\u5efa\u51fa\u5165\u5e93\u901a\u77e5\u5355";
        } else if (MqMessageEnum.Type.RECEIVE_DELIVERY_RESULT_ORDER.getType().equals(csStorageSendMqReqDto.getType())) {
            tag = "CREATE_RECEIVE_DELIVERY_RESULT_ORDER_TAG";
            message = "\u6536\u53d1\u8d27\u7ed3\u679c\u5355";
        } else {
            throw new BizException("\u627e\u4e0d\u5230\u53d1\u9001mq\u7c7b\u578b");
        }
        this.logger.info("\u53d1\u9001" + message + "mq\u4fe1\u606f");
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", tag, (Object)JSON.toJSONString((Object)csStorageSendMqReqDto));
        this.logger.info("\u53d1\u9001" + message + "mq\u4fe1\u606f\u7ed3\u679c: {}", (Object)JSON.toJSONString((Object)messageResponse));
        this.commonsService.saveMqSendLog(this.orderInformMqConfig.getDeliverOrderInformExchange(), this.orderInformMqConfig.getDeliverOrderInformRouteKey(), csStorageSendMqReqDto, messageResponse);
        return CsInventoryExceptionCode.SUCCESS_CODE.getMsg().equals(messageResponse.getResultMsg());
    }

    public void sendReceiveOrderInformMq(String messageKey) {
        MqCommonDto mqCommonDto = new MqCommonDto();
        mqCommonDto.setMessageKey(messageKey);
        mqCommonDto.setSrcSystem(SRC_SYSTEM);
        mqCommonDto.setOrigin(false);
        mqCommonDto.setContent(null);
        mqCommonDto.setMethod(this.orderInformMqConfig.getReceiveMethod());
        mqCommonDto.setUrl(this.orderInformMqConfig.getUrl());
        String msg = JSONObject.toJSONString((Object)mqCommonDto);
        this.logger.info("=================\u53d1\u9001\u6536\u8d27\u901a\u77e5\u5355MQ================={}", (Object)msg);
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage(this.orderInformMqConfig.getReceiveOrderInformExchange(), this.orderInformMqConfig.getReceiveOrderInFormRouteKey(), (Object)msg);
        this.commonsService.saveMqSendLog(this.orderInformMqConfig.getDeliverOrderInformExchange(), this.orderInformMqConfig.getDeliverOrderInformRouteKey(), msg, messageResponse);
    }

    private MqContentOrderDto getMqContentOrder(String orderNo) {
        return null;
    }
}

