/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsRelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseStatusEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csRelWarehouseQueryService")
public class CsRelWarehouseQueryServiceImpl
implements ICsRelWarehouseQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsRelWarehouseQueryServiceImpl.class);
    @Autowired
    IRelWarehouseDomain relWarehouseDomain;

    @Override
    public RelWarehouseEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        return (RelWarehouseEo)this.relWarehouseDomain.selectByPrimaryKey(id);
    }

    @Override
    public List<RelWarehouseEo> queryByRefWarehouseCode(String warehouseCode, String warehouseClassify) {
        List csRelWarehouseEos = this.relWarehouseDomain.queryByRefWarehouseCode(warehouseCode, warehouseClassify);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csRelWarehouseEos), "\u5173\u8054\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
        return csRelWarehouseEos;
    }

    @Override
    public List<RelWarehouseEo> queryByWarehouseCode(String warehouseCode, String warehouseClassify) {
        List csRelWarehouseEos = this.relWarehouseDomain.queryByWarehouseCode(warehouseCode, warehouseClassify);
        return csRelWarehouseEos;
    }

    @Override
    public PageInfo<CsRelWarehouseRespDto> queryByPage(CsRelWarehouseQueryDto queryDto) {
        logger.info("queryByPage==>\u4ed3\u5e93\u5173\u7cfb\u5206\u9875\u67e5\u8be2,queryDto:{}", (Object)LogUtils.buildLogContent(queryDto));
        this.checkParams(queryDto);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != queryDto.getWarehouseId()) {
            queryWrapper.eq((Object)"warehouse_id", (Object)queryDto.getWarehouseId());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseCode())) {
            queryWrapper.likeRight((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseName())) {
            queryWrapper.likeRight((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseClassify())) {
            queryWrapper.eq((Object)"warehouse_classify", (Object)queryDto.getWarehouseClassify());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseType())) {
            queryWrapper.eq((Object)"warehouse_type", (Object)queryDto.getWarehouseType());
        }
        if (null != queryDto.getRefWarehouseId()) {
            queryWrapper.eq((Object)"ref_warehouse_id", (Object)queryDto.getRefWarehouseId());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getRefWarehouseCode())) {
            queryWrapper.likeRight((Object)"ref_warehouse_code", (Object)queryDto.getRefWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getRefWarehouseName())) {
            queryWrapper.likeRight((Object)"ref_warehouse_name", (Object)queryDto.getRefWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getRefWarehouseClassify())) {
            queryWrapper.eq((Object)"ref_warehouse_classify", (Object)queryDto.getRefWarehouseClassify());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseType())) {
            queryWrapper.eq((Object)"ref_warehouse_type", (Object)queryDto.getRefWarehouseType());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getValidFlag())) {
            queryWrapper.eq((Object)"valid_flag", (Object)queryDto.getValidFlag());
        }
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        List csRelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)queryWrapper);
        List respDtoList = csRelWarehouseEoList.stream().map(e -> {
            CsRelWarehouseRespDto respDto = new CsRelWarehouseRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)e, (String[])new String[0]);
            return respDto;
        }).collect(Collectors.toList());
        PageInfo info = new PageInfo(csRelWarehouseEoList);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(respDtoList);
        return result;
    }

    @Override
    public List<CsRelWarehouseRespDto> queryWarehouseByConditions(CsRelWarehouseQueryDto queryDto) {
        logger.info("queryWarehouseByConditions==>,queryDto:{}", (Object)LogUtils.buildLogContent(queryDto));
        RelWarehouseEo eo = new RelWarehouseEo();
        BeanUtils.copyProperties((Object)queryDto, (Object)eo);
        List resultList = this.relWarehouseDomain.selectList((BaseEo)eo);
        ArrayList dtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)resultList, CsRelWarehouseRespDto.class);
        return dtoList;
    }

    @Override
    public List<CsRelWarehouseRespDto> queryList(CsRelWarehouseQueryDto queryDto) {
        if (StringUtils.isBlank((CharSequence)queryDto.getWarehouseCode()) && CollectionUtils.isEmpty((Collection)queryDto.getWarehouseCodeList())) {
            throw new BizException("-1", "\u67e5\u8be2\u53c2\u6570\u6709\u65e0\uff0c\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"valid_flag", (Object)CsLogicWarehouseStatusEnum.ENABLE.getCode());
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseCode())) {
            queryWrapper.eq((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getWarehouseCodeList())) {
            queryWrapper.in((Object)"warehouse_code", (Collection)queryDto.getWarehouseCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseClassify())) {
            queryWrapper.eq((Object)"warehouse_classify", (Object)queryDto.getWarehouseClassify());
        }
        List csRelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<CsRelWarehouseRespDto> csRelWarehouseRespDtoList = new ArrayList<CsRelWarehouseRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)csRelWarehouseEoList)) {
            DtoHelper.eoList2DtoList((Collection)csRelWarehouseEoList, csRelWarehouseRespDtoList, CsRelWarehouseRespDto.class);
        }
        return csRelWarehouseRespDtoList;
    }

    private void checkParams(CsRelWarehouseQueryDto queryDto) {
        AssertUtil.isTrue(null != queryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != queryDto.getPageNum() && queryDto.getPageNum() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != queryDto.getPageSize() && queryDto.getPageSize() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
    }
}

