/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.enums.ExternalSystenEnum;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.CreateOutInNoticeOrderProcess;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.CreateReceiveDeliveryResultOrderProcess;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory.CommonOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.ICsOtherStorageOrderDetailService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.ICsOtherStorageOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.ICsStorageAuditRecordService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsBatchItemQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderEditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsStorageAdjustReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsStorageAuditRecordReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsStorageCancelHangUpReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsStorageOrderCallBackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsStorageSendMqReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsBatchItemRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRelevanceOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOtherStorageOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.OtherStorageAuditBatchReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.BasicsOrderOperateTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

public abstract class OtherStorageOrderApiImpl
implements ICsOtherStorageOrderApi {
    private static final Logger log = LoggerFactory.getLogger(OtherStorageOrderApiImpl.class);
    @Resource
    protected ICsOtherStorageOrderService csOtherStorageOrderService;
    @Resource
    protected ICsStorageAuditRecordService csStorageAuditRecordService;
    @Resource
    protected ICsOtherStorageOrderDetailService csOtherStorageOrderDetailService;
    @Resource
    protected CommonOrderService commonOrderService;
    @Resource
    protected CreateOutInNoticeOrderProcess outInNoticeOrderProcess;
    @Resource
    protected CreateReceiveDeliveryResultOrderProcess deliveryResultOrderProcess;
    @Resource
    protected ICalcInventoryService calcInventoryService;
    @Autowired
    RepeatFilter repeatFilter;
    @Autowired
    BaseOrderFacade baseOrderFacade;
    @Value(value="${yunxi.dg.base.project}_OtherStorageOrderApi")
    private String project;

    public RestResponse<Long> addCsOtherStorageOrder(CsOtherStorageOrderComboReqDto csOtherStorageOrderComboReqDto) {
        return new RestResponse((Object)this.csOtherStorageOrderService.addCsOtherStorageOrder(csOtherStorageOrderComboReqDto));
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> batchAddCsOtherStorageOrder(List<CsOtherStorageOrderComboReqDto> list) {
        log.info("\u6279\u91cf\u751f\u6210\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u636e");
        ArrayList errorMsg = new ArrayList();
        ArrayList preemptOrderList = new ArrayList();
        list.forEach(add -> {
            try {
                CsOtherStorageOrderReqDto dto = add.getCsOtherStorageOrderReqDto();
                add.getCsOtherStorageOrderReqDto().setId(null);
                this.csOtherStorageOrderService.addCsOtherStorageOrder((CsOtherStorageOrderComboReqDto)add);
                if (CsOtherStorageOrderEnum.InOrOut.OUT.getCode().equals(dto.getType()) && ExternalSystenEnum.OA.getCode().equals(dto.getSourceSystem())) {
                    preemptOrderList.add(add);
                }
            }
            catch (Exception e) {
                errorMsg.add(e.getMessage());
            }
        });
        if (!preemptOrderList.isEmpty()) {
            this.batchPreemptInventory(list);
        }
        AssertUtil.isTrue(ObjectUtil.isEmpty(errorMsg), "10000", ((Object)errorMsg).toString());
        return RestResponse.VOID;
    }

    public RestResponse<Long> saveCsOtherStorageOrder(CsOtherStorageOrderComboReqDto csOtherStorageOrderComboReqDto) {
        return new RestResponse((Object)this.csOtherStorageOrderService.saveCsOtherStorageOrder(csOtherStorageOrderComboReqDto));
    }

    public RestResponse<Void> modifyCsOtherStorageOrder(CsOtherStorageOrderComboReqDto modifyReqDto) {
        this.csOtherStorageOrderService.modifyCsOtherStorageOrder(modifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeCsOtherStorageOrder(String ids, Long instanceId) {
        this.csOtherStorageOrderService.removeCsOtherStorageOrder(ids, instanceId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> deleteById(Long id) {
        this.csOtherStorageOrderService.deleteById(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> submitById(Long id) {
        this.csOtherStorageOrderService.submitById(id);
        return RestResponse.VOID;
    }

    public RestResponse<String> storageOrderCallBack(CsStorageOrderCallBackReqDto csStorageOrderCallBackReqDto) {
        return new RestResponse((Object)this.csOtherStorageOrderService.storageOrderCallBack(csStorageOrderCallBackReqDto));
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> auditCsOtherStorageOrder(CsOtherStorageOrderAuditReqDto auditReqDto) {
        log.info("\u63a5\u6536\u5230\u5ba1\u6838\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u636e:{}", (Object)LogUtils.buildLogContent(auditReqDto));
        String key = "AUDIT_OTHER_STORAGE:" + auditReqDto.getOtherStorageOrderNoId() + auditReqDto.getAutoPass();
        this.repeatFilter.checkRepeat(key, () -> this.auditOtherStorageOrder(auditReqDto), true, "\u64cd\u4f5c\u9891\u7e41\uff0c\u5176\u4ed6\u51fa\u5165\u5e93id:[" + auditReqDto.getOtherStorageOrderNoId() + "]\u6b63\u5728\u64cd\u4f5c\u5ba1\u6838\u5355\u636e");
        return RestResponse.VOID;
    }

    private void auditOtherStorageOrder(CsOtherStorageOrderAuditReqDto auditReqDto) {
        Long orderNoId = auditReqDto.getOtherStorageOrderNoId();
        AssertUtil.isTrue(Objects.nonNull(orderNoId), "\u5ba1\u6838\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        CsOtherStorageOrderRespDto respDto = this.csOtherStorageOrderService.queryById(orderNoId);
        AssertUtil.isTrue(Objects.nonNull(respDto), "\u5355\u636e\u4e0d\u5b58\u5728");
        String nextStatus = this.getNextStatus(auditReqDto.getAuditResult(), respDto.getOrderStatus(), respDto.getType(), auditReqDto.getAutoPass());
        this.insertAuditLog(auditReqDto.getAuditResult(), auditReqDto.getRemark(), respDto.getStorageOrderNo(), respDto.getType());
        if (CsOtherStorageOrderEnum.AuditEnum.AUDIT_PASS.getCode().equals(auditReqDto.getAuditResult())) {
            log.info("\u5ba1\u6838\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u636e\u901a\u8fc7");
            this.otherStoragePass(auditReqDto, orderNoId, respDto, nextStatus);
        } else {
            log.info("\u5ba1\u6838\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u636e\u4e0d\u901a\u8fc7");
            this.otherStorageNoPass(orderNoId, respDto, nextStatus);
        }
    }

    private void otherStorageNoPass(Long orderNoId, CsOtherStorageOrderRespDto respDto, String nextStatus) {
        this.csOtherStorageOrderService.updateOtherStorageStatus(orderNoId, nextStatus);
        if (CsOtherStorageOrderEnum.InOrOut.OUT.getCode().equals(respDto.getType()) && CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_TWO_AUDIT.getCode().equals(respDto.getOrderStatus())) {
            this.rollbackOutLogicInventory(respDto);
        }
    }

    private void otherStoragePass(CsOtherStorageOrderAuditReqDto auditReqDto, Long orderNoId, CsOtherStorageOrderRespDto respDto, String nextStatus) {
        if (CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_TWO_AUDIT.getCode().equals(respDto.getOrderStatus())) {
            this.csOtherStorageOrderService.updateOtherStorageStatus(orderNoId, nextStatus);
        } else {
            CsOtherStorageOrderComboReqDto csOtherStorageOrderComboReqDto = auditReqDto.getCsOtherStorageOrderComboReqDto();
            csOtherStorageOrderComboReqDto.getCsOtherStorageOrderReqDto().setOrderStatus(nextStatus);
            csOtherStorageOrderComboReqDto.getCsOtherStorageOrderReqDto().setStorageOrderNo(respDto.getStorageOrderNo());
            csOtherStorageOrderComboReqDto.getCsOtherStorageOrderReqDto().setRemark(auditReqDto.getRemark());
            this.csOtherStorageOrderService.updateOtherStorage(csOtherStorageOrderComboReqDto);
            respDto.setWarehouseCode(auditReqDto.getCsOtherStorageOrderComboReqDto().getCsOtherStorageOrderReqDto().getWarehouseCode());
            respDto.setMessage(auditReqDto.getCsOtherStorageOrderComboReqDto().getCsOtherStorageOrderReqDto().getMessage());
        }
        if (CsOtherStorageOrderEnum.InOrOut.OUT.getCode().equals(respDto.getType())) {
            if (CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_ONE_AUDIT.getCode().equals(respDto.getOrderStatus())) {
                if (auditReqDto.getAutoPass().booleanValue()) {
                    this.secondAudit(respDto);
                } else if (!ExternalSystenEnum.OA.getCode().equals(respDto.getSourceSystem())) {
                    this.preemptInventory(respDto, auditReqDto.getCsOtherStorageOrderComboReqDto().getDetailList());
                }
            } else {
                this.secondAudit(respDto);
            }
        }
        if (CsOtherStorageOrderEnum.InOrOut.IN.getCode().equals(respDto.getType())) {
            List<CsOtherStorageOrderDetailRespDto> details = this.csOtherStorageOrderDetailService.queryListByOtherOrderNo(respDto.getStorageOrderNo(), respDto.getType());
            ArrayList<CsOtherStorageOrderDetailReqDto> detailList = new ArrayList<CsOtherStorageOrderDetailReqDto>(details.size());
            details.forEach(d -> {
                CsOtherStorageOrderDetailReqDto req = new CsOtherStorageOrderDetailReqDto();
                req.setId(d.getId());
                req.setLongCode(d.getLongCode());
                req.setCargoCode(d.getCargoCode());
                req.setCargoName(d.getCargoName());
                req.setQuantity(d.getQuantity());
                req.setSpecification(d.getSpecification());
                req.setVolume(d.getVolume());
                req.setExtension(d.getExtension());
                req.setBatch(d.getBatch());
                detailList.add(req);
            });
            this.generateReceiveDeliveryNoticeOrder(respDto, detailList, BasicsOrderOperateTypeEnum.RECEIVE.getCode(), BaseOrderStatusEnum.RNO_WAIT_RECEIVE.getCode(), CsPcpBusinessTypeEnum.OTHER_IN.getCode());
        }
    }

    private void secondAudit(CsOtherStorageOrderRespDto respDto) {
        List<CsOtherStorageOrderDetailRespDto> details = this.csOtherStorageOrderDetailService.queryListByOtherOrderNo(respDto.getStorageOrderNo(), respDto.getType());
        ArrayList<CsOtherStorageOrderDetailReqDto> detailList = new ArrayList<CsOtherStorageOrderDetailReqDto>(details.size());
        details.forEach(d -> {
            CsOtherStorageOrderDetailReqDto req = new CsOtherStorageOrderDetailReqDto();
            req.setId(d.getId());
            req.setLongCode(d.getLongCode());
            req.setCargoCode(d.getCargoCode());
            req.setCargoName(d.getCargoName());
            req.setQuantity(d.getQuantity());
            req.setSpecification(d.getSpecification());
            req.setVolume(d.getVolume());
            req.setExtension(d.getExtension());
            req.setBatch(d.getBatch());
            detailList.add(req);
        });
        this.generateReceiveDeliveryNoticeOrder(respDto, detailList, BasicsOrderOperateTypeEnum.DELIVERY.getCode(), BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode(), CsPcpBusinessTypeEnum.OTHER_OUT.getCode());
    }

    public RestResponse<Void> rollbackOutLogicInventory(CsOtherStorageOrderRespDto respDto) {
        ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
        releasePreemptParam.setSourceNo(respDto.getStorageOrderNo());
        releasePreemptParam.setSourceType(respDto.getType());
        releasePreemptParam.setBusinessType(respDto.getType());
        this.calcInventoryService.releasePreempt(releasePreemptParam);
        return null;
    }

    private void generateReceiveDeliveryNoticeOrder(final CsOtherStorageOrderRespDto respDto, List<CsOtherStorageOrderDetailReqDto> detailList, String operateType, String status, String sourceType) {
        log.info("generateWarehousingNotice==>\u5176\u4ed6\u51fa\u5e93\u5355\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,orderNo:{}", (Object)respDto.getStorageOrderNo());
        ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        receiveDeliveryNoticeOrderFacadeBo.setSourceType(sourceType);
        receiveDeliveryNoticeOrderFacadeBo.setLogicWarehouseCode(respDto.getWarehouseCode());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceNo(respDto.getStorageOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_OTHER_STORAGE_ORDER);
        receiveDeliveryNoticeOrderFacadeBo.setPreOrderNo(respDto.getPreOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setExternalOrderNo(respDto.getExternalOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setBusinessType(respDto.getType());
        receiveDeliveryNoticeOrderFacadeBo.setRemark(respDto.getMessage());
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (CsOtherStorageOrderDetailReqDto detail : detailList) {
            BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
            detailReqDto.setSkuCode(detail.getLongCode());
            detailReqDto.setSkuName(detail.getCargoName());
            detailReqDto.setQuantity(detail.getQuantity());
            detailReqDto.setVolume(detail.getVolume());
            detailReqDto.setExtension(detail.getExtension());
            detailReqDto.setBatch(detail.getBatch());
            detailReqDto.setPreOrderItemId(detail.getId());
            detailReqDtoList.add(detailReqDto);
        }
        receiveDeliveryNoticeOrderFacadeBo.setOrderBasicsDetailReqDtoList((List)detailReqDtoList);
        final ContactDto contactDto = new ContactDto();
        contactDto.setProvinceCode(respDto.getProvinceCode());
        contactDto.setProvince(respDto.getProvinceName());
        contactDto.setCityCode(respDto.getCityCode());
        contactDto.setCity(respDto.getCityName());
        contactDto.setDistrictCode(respDto.getAreaCode());
        contactDto.setDistrict(respDto.getAreaName());
        contactDto.setDetailAddress(respDto.getAddress());
        contactDto.setReciveName(respDto.getConsignee());
        contactDto.setRecivePhone(respDto.getPhone());
        contactDto.setRemark(respDto.getRemark());
        receiveDeliveryNoticeOrderFacadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                context.setTransparentCallback(Boolean.valueOf(true));
                if (context instanceof ReceiveDeliveryNoticeOrderContext) {
                    ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = ((ReceiveDeliveryNoticeOrderContext)context).getReceiveDeliveryNoticeOrderEo();
                    JSONObject jsonObject = new JSONObject();
                    if (StringUtils.isNotBlank((CharSequence)respDto.getExtension())) {
                        jsonObject = JSONObject.parseObject((String)respDto.getExtension());
                    }
                    jsonObject.putAll((Map)JSON.parseObject((String)JSONObject.toJSONString((Object)contactDto)));
                    receiveDeliveryNoticeOrderEo.setExtension(jsonObject.toJSONString());
                }
            }

            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        if (BasicsOrderOperateTypeEnum.DELIVERY.getCode().equals(operateType)) {
            this.baseOrderFacade.deliveryNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
        } else {
            this.baseOrderFacade.receiveNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
        }
    }

    private void batchPreemptInventory(List<CsOtherStorageOrderComboReqDto> list) {
        List batchPreemptDto = list.stream().map(combo -> {
            CsOtherStorageOrderReqDto order = combo.getCsOtherStorageOrderReqDto();
            List detailList = combo.getDetailList();
            PreemptDto preemptParam = new PreemptDto();
            preemptParam.setSourceNo(order.getStorageOrderNo());
            preemptParam.setSourceType(order.getType());
            preemptParam.setBusinessType(order.getType());
            preemptParam.setExternalOrderNo(order.getPreOrderNo());
            preemptParam.setNoneLineNo(Boolean.valueOf(true));
            boolean noneBatch = detailList.stream().anyMatch(detail -> StringUtils.isEmpty((CharSequence)detail.getBatch()));
            preemptParam.setNoneBatch(Boolean.valueOf(noneBatch));
            ArrayList<CalcDetailDto> detailParams = new ArrayList<CalcDetailDto>();
            for (CsOtherStorageOrderDetailReqDto detail2 : detailList) {
                CalcDetailDto detailParam = new CalcDetailDto();
                detailParam.setNum(BigDecimalUtils.abs((BigDecimal)detail2.getQuantity()));
                detailParam.setSkuCode(detail2.getLongCode());
                detailParam.setLogicWarehouseCode(order.getWarehouseCode());
                detailParam.setBatch(detail2.getBatch());
                detailParams.add(detailParam);
            }
            preemptParam.setDetails(detailParams);
            return preemptParam;
        }).collect(Collectors.toList());
        this.calcInventoryService.batchPreempt(batchPreemptDto);
    }

    private void preemptInventory(CsOtherStorageOrderRespDto respDto, List<CsOtherStorageOrderDetailReqDto> detailList) {
        PreemptDto preemptParam = new PreemptDto();
        preemptParam.setSourceNo(respDto.getStorageOrderNo());
        preemptParam.setSourceType(respDto.getType());
        preemptParam.setBusinessType(respDto.getType());
        preemptParam.setExternalOrderNo(respDto.getPreOrderNo());
        preemptParam.setNoneLineNo(Boolean.valueOf(true));
        ArrayList detailParams = Lists.newArrayList();
        for (CsOtherStorageOrderDetailReqDto detailReqDto : detailList) {
            CalcDetailDto detailParam = new CalcDetailDto();
            BigDecimal preempt = BigDecimalUtils.abs((BigDecimal)detailReqDto.getQuantity());
            detailParam.setNum(preempt);
            detailParam.setSkuCode(detailReqDto.getLongCode());
            String warehouseCode = respDto.getWarehouseCode();
            detailParam.setLogicWarehouseCode(warehouseCode);
            detailParam.setBatch(detailReqDto.getBatch());
            preemptParam.setNoneBatch(Boolean.valueOf(StringUtils.isEmpty((CharSequence)detailReqDto.getBatch())));
            detailParams.add(detailParam);
        }
        preemptParam.setDetails((List)detailParams);
        this.calcInventoryService.preempt(preemptParam);
    }

    private void insertAuditLog(String auditResult, String remark, String storageOrderNo, String type) {
        CsStorageAuditRecordReqDto auditLog = new CsStorageAuditRecordReqDto();
        auditLog.setAuditResult(auditResult);
        auditLog.setRemark(remark);
        auditLog.setType(type);
        auditLog.setOrderSrcNo(storageOrderNo);
        this.csStorageAuditRecordService.addCsStorageAuditRecord(auditLog);
    }

    private String getNextStatus(String auditResult, String currentOrderStatus, String type, Boolean autoPass) {
        String status;
        if (CsOtherStorageOrderEnum.AuditEnum.AUDIT_PASS.getCode().equals(auditResult)) {
            if (CsOtherStorageOrderEnum.InOrOut.OUT.getCode().equals(type)) {
                if (CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_ONE_AUDIT.getCode().equals(currentOrderStatus)) {
                    status = CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_TWO_AUDIT.getCode();
                    if (autoPass.booleanValue()) {
                        status = CsOtherStorageOrderStatusEnum.OUT.WAIT_OUT.getCode();
                    }
                } else {
                    status = CsOtherStorageOrderStatusEnum.OUT.WAIT_OUT.getCode();
                }
            } else {
                status = CsOtherStorageOrderStatusEnum.IN.WAIT_IN.getCode();
            }
        } else {
            status = CsOtherStorageOrderEnum.InOrOut.OUT.getCode().equals(type) && CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_TWO_AUDIT.getCode().equals(currentOrderStatus) ? CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_ONE_AUDIT.getCode() : CsOtherStorageOrderStatusEnum.IN.AUDIT_FAILED.getCode();
        }
        AssertUtil.isTrue(!currentOrderStatus.equals(status), "\u5355\u636e\u72b6\u6001\u5df2\u5904\u7406");
        return status;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> cancelHangUpStorageOrder(CsStorageCancelHangUpReqDto csStorageCancelHangUpReqDto) {
        CsOtherStorageOrderRespDto respDto = this.csOtherStorageOrderService.queryByStorageOrderNo(csStorageCancelHangUpReqDto.getOrderSrcNo());
        this.csOtherStorageOrderService.updateOtherStorageStatus(respDto.getId(), CsOtherStorageOrderStatusEnum.OUT.FINISH.getCode());
        return RestResponse.VOID;
    }

    public RestResponse<Void> adjustStorageResultOrder(CsStorageAdjustReqDto csStorageAdjustReqDto) {
        CsOtherStorageOrderRespDto respDto = this.csOtherStorageOrderService.queryByStorageOrderNo(csStorageAdjustReqDto.getOrderSrcNo());
        this.csOtherStorageOrderService.updateOtherStorageStatus(respDto.getId(), CsOtherStorageOrderStatusEnum.OUT.FINISH.getCode());
        return RestResponse.VOID;
    }

    public RestResponse<Void> testSendMq(CsStorageSendMqReqDto csStorageSendMqReqDto) {
        this.commonOrderService.insertLogAndSendMq(csStorageSendMqReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> testMq(CsStorageSendMqReqDto csStorageSendMqReqDto) {
        if (csStorageSendMqReqDto.getType() == 1) {
            this.outInNoticeOrderProcess.process(csStorageSendMqReqDto.getBusinessOrderNo());
        } else {
            this.deliveryResultOrderProcess.process(csStorageSendMqReqDto.getBusinessOrderNo());
        }
        return RestResponse.VOID;
    }

    public RestResponse<Void> batchCreateCsOtherStorageOrder(List<CsOtherStorageOrderComboReqDto> list) {
        this.csOtherStorageOrderService.batchCreateCsOtherStorageOrder(list);
        return RestResponse.VOID;
    }

    public RestResponse<Void> batchAuditCsOtherStorageOrder(OtherStorageAuditBatchReqDto auditBatchReqDto) {
        CsOtherStorageOrderQueryDto storageOrderQueryDto;
        log.info("\u6279\u91cf\u5ba1\u6838\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u636e");
        if (CollectionUtils.isNotEmpty((Collection)auditBatchReqDto.getAuditIds())) {
            storageOrderQueryDto = new CsOtherStorageOrderQueryDto();
            storageOrderQueryDto.setIds(auditBatchReqDto.getAuditIds());
            Optional.ofNullable(this.csOtherStorageOrderService.queryByPage(storageOrderQueryDto, 1, auditBatchReqDto.getAuditIds().size()).getList()).filter(CollectionUtils::isNotEmpty).ifPresent(list -> {
                Map<String, List<CsOtherStorageOrderDetailRespDto>> detailMap = this.csOtherStorageOrderDetailService.queryListByOtherOrderNo(list.stream().map(CsOtherStorageOrderRespDto::getStorageOrderNo).distinct().collect(Collectors.toList())).stream().collect(Collectors.groupingBy(CsOtherStorageOrderDetailRespDto::getOtherOrderNo));
                list.stream().map(t -> this.transferCommonDto((CsOtherStorageOrderRespDto)t, (List)detailMap.get(t.getStorageOrderNo()))).forEach(r -> {
                    CsOtherStorageOrderAuditReqDto reqDto = new CsOtherStorageOrderAuditReqDto();
                    reqDto.setAuditResult(auditBatchReqDto.getAuditResult());
                    reqDto.setAutoPass(Boolean.valueOf(true));
                    reqDto.setRemark(auditBatchReqDto.getAuditReason());
                    reqDto.setOtherStorageOrderNoId(r.getCsOtherStorageOrderReqDto().getId());
                    reqDto.setCsOtherStorageOrderComboReqDto(r);
                    ((OtherStorageOrderApiImpl)SpringBeanUtil.getBean((String)this.project, OtherStorageOrderApiImpl.class)).auditCsOtherStorageOrder(reqDto);
                });
            });
        }
        if (auditBatchReqDto.getAuditId() != null) {
            storageOrderQueryDto = new CsOtherStorageOrderQueryDto();
            storageOrderQueryDto.setId(auditBatchReqDto.getAuditId());
            Optional.ofNullable(this.csOtherStorageOrderService.queryByPage(storageOrderQueryDto, 1, 1).getList()).filter(CollectionUtils::isNotEmpty).ifPresent(list -> {
                Map<String, List<CsOtherStorageOrderDetailRespDto>> detailMap = this.csOtherStorageOrderDetailService.queryListByOtherOrderNo(list.stream().map(CsOtherStorageOrderRespDto::getStorageOrderNo).distinct().collect(Collectors.toList())).stream().collect(Collectors.groupingBy(CsOtherStorageOrderDetailRespDto::getOtherOrderNo));
                list.stream().map(t -> this.transferCommonDto((CsOtherStorageOrderRespDto)t, (List)detailMap.get(t.getStorageOrderNo()))).forEach(r -> {
                    CsOtherStorageOrderAuditReqDto reqDto = new CsOtherStorageOrderAuditReqDto();
                    reqDto.setAuditResult(auditBatchReqDto.getAuditResult());
                    reqDto.setAutoPass(Boolean.valueOf(true));
                    reqDto.setRemark(auditBatchReqDto.getAuditReason());
                    reqDto.setOtherStorageOrderNoId(r.getCsOtherStorageOrderReqDto().getId());
                    reqDto.setCsOtherStorageOrderComboReqDto(r);
                    ((OtherStorageOrderApiImpl)SpringBeanUtil.getBean((String)this.project, OtherStorageOrderApiImpl.class)).auditCsOtherStorageOrder(reqDto);
                });
            });
        }
        return RestResponse.VOID;
    }

    public RestResponse<Void> editOtherStorageOrder(CsOtherStorageOrderEditReqDto otherStorageOrderEditReqDto) {
        this.csOtherStorageOrderService.editOtherStorageOrder(otherStorageOrderEditReqDto);
        return RestResponse.VOID;
    }

    private CsOtherStorageOrderComboReqDto transferCommonDto(CsOtherStorageOrderRespDto t, List<CsOtherStorageOrderDetailRespDto> csOtherStorageOrderDetailRespDtos) {
        CsOtherStorageOrderComboReqDto reqDto = new CsOtherStorageOrderComboReqDto();
        CsOtherStorageOrderReqDto csOtherStorageOrderReqDto = (CsOtherStorageOrderReqDto)BeanUtil.copyProperties((Object)t, CsOtherStorageOrderReqDto.class, (String[])new String[0]);
        reqDto.setCsOtherStorageOrderReqDto(csOtherStorageOrderReqDto);
        reqDto.setDetailList(csOtherStorageOrderDetailRespDtos.stream().map(cs -> (CsOtherStorageOrderDetailReqDto)BeanUtil.copyProperties((Object)cs, CsOtherStorageOrderDetailReqDto.class, (String[])new String[0])).collect(Collectors.toList()));
        return reqDto;
    }

    public RestResponse<CsOtherStorageOrderRespDto> queryById(Long id) {
        return new RestResponse((Object)this.csOtherStorageOrderService.queryById(id));
    }

    public RestResponse<CsOtherStorageOrderRespDto> queryByOtherStorageNo(String otherStorageNo) {
        return new RestResponse((Object)this.csOtherStorageOrderService.queryByStorageOrderNo(otherStorageNo));
    }

    public RestResponse<PageInfo<CsOtherStorageOrderRespDto>> queryByPage(CsOtherStorageOrderQueryDto csOtherStorageOrderQueryDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.csOtherStorageOrderService.queryByPage(csOtherStorageOrderQueryDto, pageNum, pageSize));
    }

    public RestResponse<List<CsBatchItemRespDto>> queryBatchItemByStorageOrderNo(CsBatchItemQueryDto csBatchItemQueryDto) {
        return new RestResponse(this.csOtherStorageOrderService.queryBatchItemByStorageOrderNo(csBatchItemQueryDto));
    }

    public RestResponse<List<CsOtherStorageOrderRelevanceOrderRespDto>> queryOtherStorageOrderRelevanceOrder(String storageOrderNo, String type) {
        List<Object> relevanceList = this.csOtherStorageOrderService.queryOtherStorageOrderRelevanceOrder(storageOrderNo, type);
        if (CollectionUtils.isNotEmpty(relevanceList)) {
            relevanceList = relevanceList.stream().sorted(Comparator.comparing(CsOtherStorageOrderRelevanceOrderRespDto::getCreateTime)).collect(Collectors.toList());
        }
        return new RestResponse(relevanceList);
    }

    public RestResponse<List<CsOtherStorageOrderRespDto>> queryByParams(CsOtherStorageOrderReqDto reqDto) {
        return new RestResponse(this.csOtherStorageOrderService.queryByParams(reqDto));
    }
}

