/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsPhysicsWarehouseExposedQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseLogicDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseLogicDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csPhysicsWarehouseExposedQueryServiceImpl")
public class CsPhysicsWarehouseExposedQueryServiceImpl
implements ICsPhysicsWarehouseExposedQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsPhysicsWarehouseExposedQueryServiceImpl.class);
    @Autowired
    IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Autowired
    IWarehouseAddressDomain warehouseAddressDomain;
    @Autowired
    IRelWarehouseDomain relWarehouseDomain;
    @Autowired
    ILogicWarehouseDomain logicWarehouseDomain;

    @Override
    public CsPhysicsWarehouseDetailRespDto queryDetailById(Long id) {
        logger.info("queryDetailById==>\u6839\u636e\u4ed3\u5e93\u4fe1\u606f\u67e5\u8be2\u4ed3\u5e93\u8be6\u60c5\u4fe1\u606f,id:{}", (Object)id);
        AssertUtil.isTrue(null != id, "\u4ed3\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a");
        PhysicsWarehouseEo csPhysicsWarehouseEo = (PhysicsWarehouseEo)this.physicsWarehouseDomain.getMapper().selectById((Serializable)id);
        AssertUtil.isTrue(null != csPhysicsWarehouseEo, "\u67e5\u8be2\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f");
        CsPhysicsWarehouseDetailRespDto respDto = new CsPhysicsWarehouseDetailRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)csPhysicsWarehouseEo, (String[])new String[0]);
        respDto.setRdcFlag(String.valueOf(csPhysicsWarehouseEo.getRdcFlag()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"warehouse_id", (Object)id);
        queryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        queryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        WarehouseAddressEo csWarehouseAddressEo = (WarehouseAddressEo)this.warehouseAddressDomain.getMapper().selectOne((Wrapper)queryWrapper);
        if (null != csWarehouseAddressEo) {
            logger.info("queryDetailById==>\u67e5\u8be2\u5230\u5730\u5740\u4fe1\u606f");
            CubeBeanUtils.copyProperties((Object)respDto, (Object)csWarehouseAddressEo, (String[])new String[]{"createTime", "updateTime", "createPerson", "updatePerson"});
            respDto.setDetailAddress("" + csWarehouseAddressEo.getProvince() + csWarehouseAddressEo.getCity() + csWarehouseAddressEo.getDistrict() + csWarehouseAddressEo.getDetailAddress());
        }
        logger.info("queryDetailById==>\u7269\u7406\u4ed3\u8be6\u60c5\u4fe1\u606f,respDto:{}", (Object)LogUtils.buildLogContent(respDto));
        return respDto;
    }

    @Override
    public PageInfo<CsPhysicsWarehouseLogicDetailRespDto> queryLogicInfo(CsPhysicsWarehouseLogicDetailReqDto csPhysicsWarehouseLogicDetailReqDto) {
        String logicWarehouseName;
        AssertUtil.isTrue(null != csPhysicsWarehouseLogicDetailReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != csPhysicsWarehouseLogicDetailReqDto.getPageNum() && csPhysicsWarehouseLogicDetailReqDto.getPageNum() > 0, "\u5206\u9875\u9875\u7801\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != csPhysicsWarehouseLogicDetailReqDto.getPageSize() && csPhysicsWarehouseLogicDetailReqDto.getPageSize() > 0, "\u5206\u9875\u5927\u5c0f\u53c2\u6570\u6709\u8bef");
        Long physicsWarehouseId = csPhysicsWarehouseLogicDetailReqDto.getPhysicsWarehouseId();
        AssertUtil.isTrue(null != physicsWarehouseId, "\u7269\u7406\u4ed3\u4ed3\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper relWrapper = new QueryWrapper();
        relWrapper.eq((Object)"warehouse_id", (Object)physicsWarehouseId);
        relWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        relWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        relWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        String logicWarehouseCode = csPhysicsWarehouseLogicDetailReqDto.getLogicWarehouseCode();
        if (StringUtils.isNotBlank((CharSequence)logicWarehouseCode)) {
            relWrapper.eq((Object)"ref_warehouse_code", (Object)logicWarehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(logicWarehouseName = csPhysicsWarehouseLogicDetailReqDto.getLogicWarehouseName()))) {
            relWrapper.likeRight((Object)"ref_warehouse_name", (Object)logicWarehouseName);
        }
        PageHelper.startPage((int)csPhysicsWarehouseLogicDetailReqDto.getPageNum(), (int)csPhysicsWarehouseLogicDetailReqDto.getPageSize());
        logger.info("queryLogicInfo===>\u7269\u7406\u4ed3\u8be6\u60c5\u67e5\u8be2\u5173\u8054\u903b\u8f91\u4ed3\u4fe1\u606f,relWrapper:{}", (Object)LogUtils.buildLogContent(relWrapper));
        List csRelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)relWrapper);
        logger.info("queryLogicInfo===>\u7269\u7406\u4ed3\u8be6\u60c5\u67e5\u8be2\u5173\u8054\u903b\u8f91\u4ed3\u4fe1\u606f,csRelWarehouseEoList:{}", (Object)LogUtils.buildLogContent(csRelWarehouseEoList));
        if (CollectionUtils.isEmpty((Collection)csRelWarehouseEoList)) {
            return new PageInfo();
        }
        List relLogicWarehouseIdList = csRelWarehouseEoList.stream().map(RelWarehouseEo::getRefWarehouseId).collect(Collectors.toList());
        QueryWrapper logicWrapper = new QueryWrapper();
        logicWrapper.in((Object)"id", relLogicWarehouseIdList);
        List csLogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)logicWrapper);
        logger.info("\u5173\u8054\u7684\u903b\u8f91\u4ed3\u4fe1\u606f,csLogicWarehouseEoList:{}", (Object)LogUtils.buildLogContent(csLogicWarehouseEoList));
        Map<Object, Object> logicWarehouseEoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)csLogicWarehouseEoList)) {
            logicWarehouseEoMap = csLogicWarehouseEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        }
        ArrayList physicsWarehouseLogicDetailRespDtoList = Lists.newArrayList();
        for (RelWarehouseEo relWarehouseEo : csRelWarehouseEoList) {
            Long resPhysicsWarehouseId = relWarehouseEo.getWarehouseId();
            Long relLogicWarehouseId = relWarehouseEo.getRefWarehouseId();
            String refWarehouseCode = relWarehouseEo.getRefWarehouseCode();
            String refWarehouseName = relWarehouseEo.getRefWarehouseName();
            CsPhysicsWarehouseLogicDetailRespDto respDto = new CsPhysicsWarehouseLogicDetailRespDto();
            respDto.setPhysicsWarehouseId(resPhysicsWarehouseId);
            respDto.setLogicWarehouseName(refWarehouseName);
            respDto.setLogicWarehouseCode(refWarehouseCode);
            LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)logicWarehouseEoMap.get(relLogicWarehouseId);
            if (null != csLogicWarehouseEo) {
                respDto.setLogicWarehouseStatus(csLogicWarehouseEo.getWarehouseStatus());
            }
            physicsWarehouseLogicDetailRespDtoList.add(respDto);
        }
        PageInfo info = new PageInfo(csLogicWarehouseEoList);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList((List)physicsWarehouseLogicDetailRespDtoList);
        logger.info("queryLogicInfo==>\u8fd4\u56de\u67e5\u8be2\u5230\u7684\u903b\u8f91\u4ed3\u6570\u636e,result:{}", (Object)LogUtils.buildLogContent(result));
        return result;
    }

    @Override
    public PageInfo<CsPhysicsWarehousePageRespDto> queryPageInfo(CsPhysicsWarehousePageQueryDto csPhysicsWarehousePageQueryDto) {
        String easWarehouseCode;
        String rdcFlag;
        String warehouseStatus;
        String warehouseName;
        logger.info("queryPageInfo==>\u7269\u7406\u4ed3\u5206\u9875\u5217\u8868\u67e5\u8be2,csPhysicsWarehousePageQueryDto:{}", (Object)LogUtils.buildLogContent(csPhysicsWarehousePageQueryDto));
        AssertUtil.isTrue(null != csPhysicsWarehousePageQueryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != csPhysicsWarehousePageQueryDto.getPageNum() && csPhysicsWarehousePageQueryDto.getPageNum() > 0, "\u5206\u9875\u9875\u7801\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != csPhysicsWarehousePageQueryDto.getPageSize() && csPhysicsWarehousePageQueryDto.getPageSize() > 0, "\u5206\u9875\u5927\u5c0f\u53c2\u6570\u6709\u8bef");
        QueryWrapper physicsWrapper = new QueryWrapper();
        String warehouseCode = csPhysicsWarehousePageQueryDto.getWarehouseCode();
        if (StringUtils.isNotBlank((CharSequence)warehouseCode)) {
            physicsWrapper.like((Object)"warehouse_code", (Object)warehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseName = csPhysicsWarehousePageQueryDto.getWarehouseName()))) {
            physicsWrapper.like((Object)"warehouse_name", (Object)warehouseName);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseStatus = csPhysicsWarehousePageQueryDto.getWarehouseStatus()))) {
            physicsWrapper.eq((Object)"warehouse_status", (Object)warehouseStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)(rdcFlag = csPhysicsWarehousePageQueryDto.getRdcFlag()))) {
            physicsWrapper.eq((Object)"rdc_flag", (Object)rdcFlag);
        }
        if (StringUtils.isNotBlank((CharSequence)(easWarehouseCode = csPhysicsWarehousePageQueryDto.getEasWarehouseCode()))) {
            physicsWrapper.like((Object)"eas_warehouse_code", (Object)easWarehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)csPhysicsWarehousePageQueryDto.getSampleCode())) {
            physicsWrapper.like((Object)"sample_code", (Object)csPhysicsWarehousePageQueryDto.getSampleCode());
        }
        if (null != csPhysicsWarehousePageQueryDto.getIsLogistics()) {
            physicsWrapper.eq((Object)"is_logistics", (Object)csPhysicsWarehousePageQueryDto.getIsLogistics());
        }
        physicsWrapper.orderByDesc((Object)"create_time");
        PageHelper.startPage((int)csPhysicsWarehousePageQueryDto.getPageNum(), (int)csPhysicsWarehousePageQueryDto.getPageSize());
        logger.info("queryPageInfo===>\u7269\u7406\u4ed3\u5206\u9875\u5217\u8868\u67e5\u8be2,relWrapper:{}", (Object)LogUtils.buildLogContent(physicsWrapper));
        List csPhysicsWarehouseEoList = this.physicsWarehouseDomain.getMapper().selectList((Wrapper)physicsWrapper);
        logger.info("queryPageInfo===>\u7269\u7406\u4ed3\u5206\u9875\u5217\u8868\u67e5\u8be2,csPhysicsWarehouseEoList:{}", (Object)LogUtils.buildLogContent(csPhysicsWarehouseEoList));
        if (CollectionUtils.isEmpty((Collection)csPhysicsWarehouseEoList)) {
            return new PageInfo();
        }
        List physicsWarehouseIdList = csPhysicsWarehouseEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        QueryWrapper addressEoQueryWrapper = new QueryWrapper();
        addressEoQueryWrapper.in((Object)"warehouse_id", physicsWarehouseIdList);
        addressEoQueryWrapper.in((Object)"valid_flag", new Object[]{CsValidFlagEnum.ENABLE.getCode()});
        addressEoQueryWrapper.in((Object)"warehouse_classify", new Object[]{CsWarehouseClassifyEnum.PHYSICS.getCode()});
        List csWarehouseAddressEoList = this.warehouseAddressDomain.getMapper().selectList((Wrapper)addressEoQueryWrapper);
        Map<Object, Object> addressEoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)csWarehouseAddressEoList)) {
            addressEoMap = csWarehouseAddressEoList.stream().collect(Collectors.toMap(WarehouseAddressEo::getWarehouseId, Function.identity()));
        }
        ArrayList physicsRespList = Lists.newArrayList();
        for (PhysicsWarehouseEo csPhysicsWarehouseEo : csPhysicsWarehouseEoList) {
            CsPhysicsWarehousePageRespDto csPhysicsWarehousePageRespDto = new CsPhysicsWarehousePageRespDto();
            CubeBeanUtils.copyProperties((Object)csPhysicsWarehousePageRespDto, (Object)csPhysicsWarehouseEo, (String[])new String[0]);
            csPhysicsWarehousePageRespDto.setRdcFlag(String.valueOf(csPhysicsWarehouseEo.getRdcFlag()));
            Long physicsWarehouseEoId = csPhysicsWarehouseEo.getId();
            WarehouseAddressEo csWarehouseAddressEo = (WarehouseAddressEo)addressEoMap.get(physicsWarehouseEoId);
            if (null != csWarehouseAddressEo) {
                csPhysicsWarehousePageRespDto.setProvince(csWarehouseAddressEo.getProvince());
                csPhysicsWarehousePageRespDto.setCity(csWarehouseAddressEo.getCity());
                csPhysicsWarehousePageRespDto.setDistrict(csWarehouseAddressEo.getDistrict());
                csPhysicsWarehousePageRespDto.setDetailAddress("" + csWarehouseAddressEo.getProvince() + csWarehouseAddressEo.getCity() + csWarehouseAddressEo.getDistrict() + csWarehouseAddressEo.getDetailAddress());
            }
            physicsRespList.add(csPhysicsWarehousePageRespDto);
        }
        PageInfo info = new PageInfo(csPhysicsWarehouseEoList);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList((List)physicsRespList);
        logger.info("\u7269\u7406\u4ed3\u5206\u9875\u5217\u8868\u67e5\u8be2\uff0c\u6700\u7ec8\u8fd4\u56de\u7ed3\u679c,result:{}", (Object)LogUtils.buildLogContent(result));
        return result;
    }

    @Override
    public List<CsPhysicsWarehousePageRespDto> queryParam(CsPhysicsWarehouseParamQueryDto csPhysicsWarehouseParamQueryDto) {
        String easWarehouseCode;
        String rdcFlag;
        String warehouseStatus;
        String warehouseName;
        logger.info("queryPageInfo==>\u7269\u7406\u4ed3\u53c2\u6570\u5217\u8868\u67e5\u8be2,csPhysicsWarehouseParamQueryDto:{}", (Object)LogUtils.buildLogContent(csPhysicsWarehouseParamQueryDto));
        AssertUtil.isTrue(null != csPhysicsWarehouseParamQueryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper physicsWrapper = new QueryWrapper();
        List warehouseCodeList = csPhysicsWarehouseParamQueryDto.getWarehouseCodeList();
        if (CollectionUtils.isNotEmpty((Collection)warehouseCodeList)) {
            physicsWrapper.in((Object)"warehouse_code", (Collection)warehouseCodeList);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseName = csPhysicsWarehouseParamQueryDto.getWarehouseName()))) {
            physicsWrapper.like((Object)"warehouse_name", (Object)warehouseName);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseStatus = csPhysicsWarehouseParamQueryDto.getWarehouseStatus()))) {
            physicsWrapper.eq((Object)"warehouse_status", (Object)warehouseStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)(rdcFlag = csPhysicsWarehouseParamQueryDto.getRdcFlag()))) {
            physicsWrapper.eq((Object)"rdc_flag", (Object)rdcFlag);
        }
        if (StringUtils.isNotBlank((CharSequence)(easWarehouseCode = csPhysicsWarehouseParamQueryDto.getEasWarehouseCode()))) {
            physicsWrapper.like((Object)"eas_warehouse_code", (Object)easWarehouseCode);
        }
        physicsWrapper.orderByDesc((Object)"create_time");
        logger.info("queryParam===>\u7269\u7406\u4ed3\u53c2\u6570\u5217\u8868\u67e5\u8be2,relWrapper:{}", (Object)LogUtils.buildLogContent(physicsWrapper));
        List csPhysicsWarehouseEoList = this.physicsWarehouseDomain.getMapper().selectList((Wrapper)physicsWrapper);
        logger.info("queryPageInfo===>\u7269\u7406\u4ed3\u53c2\u6570\u5217\u8868\u67e5\u8be2,csPhysicsWarehouseEoList:{}", (Object)LogUtils.buildLogContent(csPhysicsWarehouseEoList));
        if (CollectionUtils.isEmpty((Collection)csPhysicsWarehouseEoList)) {
            return Lists.newArrayList();
        }
        ArrayList physicsRespList = Lists.newArrayList();
        for (PhysicsWarehouseEo csPhysicsWarehouseEo : csPhysicsWarehouseEoList) {
            CsPhysicsWarehousePageRespDto csPhysicsWarehousePageRespDto = new CsPhysicsWarehousePageRespDto();
            CubeBeanUtils.copyProperties((Object)csPhysicsWarehousePageRespDto, (Object)csPhysicsWarehouseEo, (String[])new String[0]);
            csPhysicsWarehousePageRespDto.setRdcFlag(String.valueOf(csPhysicsWarehouseEo.getRdcFlag()));
            physicsRespList.add(csPhysicsWarehousePageRespDto);
        }
        return physicsRespList;
    }
}

