/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.eas.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.eas.ICsEasService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.wms.ICsWmsService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.ICsInPlannedOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.ICsOutPlannedOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInPlannedOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsOutPlannedOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateDetailExposedReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateExposedReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsPlannedCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderAuditResultEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderOperateEnum;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="CsEasServiceImpl")
public class CsEasServiceImpl
implements ICsEasService {
    private static Logger logger = LoggerFactory.getLogger(CsEasServiceImpl.class);
    @Autowired
    private ICsWmsService csWmsService;
    @Autowired
    private ICsInPlannedOrderService csInPlannedOrderService;
    @Autowired
    private CsInPlannedOrderMapper csInPlannedOrderMapper;
    @Autowired
    private CsOutPlannedOrderMapper csOutPlannedOrderMapper;
    @Resource
    private ICsOutPlannedOrderService outPlannedOrderService;

    @Override
    public void cancel(CsWmsCancelReqDto csWmsCancelReqDto) {
        this.csWmsService.cancel(csWmsCancelReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long generateRetreatOrder(CsOutPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        logger.info("generateRetreatOrder\u300bEAS\u751f\u6210\u9000\u8d27\u5355\u636e,plannedOrderGenerateReqDto:{}", (Object)LogUtils.buildLogContent(plannedOrderGenerateReqDto));
        this.checkParams(plannedOrderGenerateReqDto);
        plannedOrderGenerateReqDto.setOperateFlag(CsPlannedOrderOperateEnum.SUBMIT.getCode());
        Long id = this.outPlannedOrderService.generateRetreatOrder(plannedOrderGenerateReqDto);
        QueryWrapper csOutPlannedOrderEoQueryWrapper = new QueryWrapper();
        csOutPlannedOrderEoQueryWrapper.eq((Object)"id", (Object)id);
        CsOutPlannedOrderEo csOutPlannedOrderEo = (CsOutPlannedOrderEo)this.csOutPlannedOrderMapper.selectOne((Wrapper)csOutPlannedOrderEoQueryWrapper);
        CsOutPlannedOrderAuditReqDto csOutPlannedOrderAuditReqDto = new CsOutPlannedOrderAuditReqDto();
        csOutPlannedOrderAuditReqDto.setOrderNo(csOutPlannedOrderEo.getOrderNo());
        csOutPlannedOrderAuditReqDto.setRemark("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7");
        csOutPlannedOrderAuditReqDto.setAuditResult(CsPlannedOrderAuditResultEnum.AUDIT_PASS.getCode());
        this.outPlannedOrderService.auditRetreatOrder(csOutPlannedOrderAuditReqDto);
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long generatePlannedOrderExposed(CsInPlannedOrderGenerateExposedReqDto plannedOrderGenerateExposedReqDto) {
        logger.info("\u751f\u6210\u5355\u636e\u91c7\u8d2d/\u59d4\u5916/\u751f\u4ea7\u8ba2\u5355\u5bf9\u5916\u66b4\u9732\uff1a{}", (Object)JSON.toJSONString((Object)plannedOrderGenerateExposedReqDto));
        this.checkParams(plannedOrderGenerateExposedReqDto);
        List itemDetailList = plannedOrderGenerateExposedReqDto.getItemDetailList();
        Map<String, List<CsInPlannedOrderGenerateDetailExposedReqDto>> detailMap = itemDetailList.stream().collect(Collectors.groupingBy(CsInPlannedOrderGenerateDetailExposedReqDto::getWarehouseCode));
        Set<Map.Entry<String, List<CsInPlannedOrderGenerateDetailExposedReqDto>>> entrySet = detailMap.entrySet();
        for (Map.Entry<String, List<CsInPlannedOrderGenerateDetailExposedReqDto>> entry : entrySet) {
            ArrayList detailReqDtoList = Lists.newArrayList();
            String warehouseCode = entry.getKey();
            List<CsInPlannedOrderGenerateDetailExposedReqDto> exposedReqDtoList = entry.getValue();
            CsInPlannedOrderGenerateReqDto plannedOrderGenerateReqDto = new CsInPlannedOrderGenerateReqDto();
            plannedOrderGenerateReqDto.setPlatformOrderNo(plannedOrderGenerateExposedReqDto.getPlatformOrderNo());
            plannedOrderGenerateReqDto.setOrderType(plannedOrderGenerateExposedReqDto.getOrderType());
            plannedOrderGenerateReqDto.setRemark(plannedOrderGenerateExposedReqDto.getRemark());
            plannedOrderGenerateReqDto.setSupplierCode(plannedOrderGenerateExposedReqDto.getSupplierCode());
            plannedOrderGenerateReqDto.setWarehouseCode(warehouseCode);
            plannedOrderGenerateReqDto.setBusinessType(plannedOrderGenerateExposedReqDto.getOrderType());
            plannedOrderGenerateReqDto.setExtension(plannedOrderGenerateExposedReqDto.getExtension());
            plannedOrderGenerateReqDto.setProductionWorkshop(plannedOrderGenerateExposedReqDto.getProductionWorkshop());
            plannedOrderGenerateReqDto.setProductionWarehouseCode(plannedOrderGenerateExposedReqDto.getProductionWarehouseCode());
            plannedOrderGenerateReqDto.setProductionWarehouseName(plannedOrderGenerateExposedReqDto.getProductionWarehouseName());
            for (CsInPlannedOrderGenerateDetailExposedReqDto exposedReqDto : exposedReqDtoList) {
                CsInPlannedOrderGenerateDetailReqDto csInPlannedOrderGenerateDetailReqDto = new CsInPlannedOrderGenerateDetailReqDto();
                csInPlannedOrderGenerateDetailReqDto.setLongCode(exposedReqDto.getSkuCode());
                csInPlannedOrderGenerateDetailReqDto.setPlanQuantity(exposedReqDto.getQuantity());
                csInPlannedOrderGenerateDetailReqDto.setProduceTime(exposedReqDto.getProduceTime());
                csInPlannedOrderGenerateDetailReqDto.setBatch(exposedReqDto.getBatch());
                csInPlannedOrderGenerateDetailReqDto.setExtension(exposedReqDto.getExtension());
                detailReqDtoList.add(csInPlannedOrderGenerateDetailReqDto);
            }
            plannedOrderGenerateReqDto.setItemDetailList((List)detailReqDtoList);
            this.generatePlannedOrder(plannedOrderGenerateReqDto);
        }
        return null;
    }

    private void checkParams(CsInPlannedOrderGenerateExposedReqDto plannedOrderGenerateExposedReqDto) {
        AssertUtil.isTrue(null != plannedOrderGenerateExposedReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String platformOrderNo = plannedOrderGenerateExposedReqDto.getPlatformOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)platformOrderNo), "\u5e73\u53f0\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List itemDetailList = plannedOrderGenerateExposedReqDto.getItemDetailList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)itemDetailList), "\u5546\u54c1\u4fe1\u606f\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsInPlannedOrderGenerateDetailExposedReqDto detailExposedReqDto : itemDetailList) {
            String skuCode = detailExposedReqDto.getSkuCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)skuCode), "\u5546\u54c1\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            String warehouseCode = detailExposedReqDto.getWarehouseCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseCode), "\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal quantity = detailExposedReqDto.getQuantity();
            AssertUtil.isTrue(null != quantity, "\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public Long generateRetreatOrderExposed(CsInPlannedOrderGenerateExposedReqDto plannedOrderGenerateExposedReqDto) {
        return null;
    }

    @Override
    public void plannedOrderExposedCancel(CsPlannedCancelReqDto plannedCancelReqDto) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long generatePlannedOrder(CsInPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        logger.info("generatePlannedOrder==>EAS\u751f\u6210\u5355\u636e,plannedOrderGenerateReqDto:{}", (Object)LogUtils.buildLogContent(plannedOrderGenerateReqDto));
        this.checkParams(plannedOrderGenerateReqDto);
        plannedOrderGenerateReqDto.setOperateFlag(CsPlannedOrderOperateEnum.SUBMIT.getCode());
        Long id = this.csInPlannedOrderService.generatePlannedOrder(plannedOrderGenerateReqDto);
        QueryWrapper csInPlannedOrderEoQueryWrapper = new QueryWrapper();
        csInPlannedOrderEoQueryWrapper.eq((Object)"id", (Object)id);
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)csInPlannedOrderEoQueryWrapper);
        CsInPlannedOrderAuditReqDto csInPlannedOrderAuditReqDto = new CsInPlannedOrderAuditReqDto();
        csInPlannedOrderAuditReqDto.setOrderNo(csInPlannedOrderEo.getOrderNo());
        csInPlannedOrderAuditReqDto.setRemark("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7");
        csInPlannedOrderAuditReqDto.setAuditResult(CsPlannedOrderAuditResultEnum.AUDIT_PASS.getCode());
        this.csInPlannedOrderService.auditPlannedOrder(csInPlannedOrderAuditReqDto);
        return id;
    }

    private void checkParams(CsInPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        String platformOrderNo = plannedOrderGenerateReqDto.getPlatformOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)platformOrderNo), "\u5e73\u53f0\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void checkParams(CsOutPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        String platformOrderNo = plannedOrderGenerateReqDto.getPlatformOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)platformOrderNo), "\u5e73\u53f0\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

