/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DispatcherOperateLogReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DispatcherOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.BusinessOrderCallBackParseHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.wms.ICsWmsService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsDispatcherOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.IDispatcherOperateLogService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.difforder.DiffOrderOptContext;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.difforder.DispatchOperateBo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.difforder.DispatcherOperateWayEnum;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsInSendBackDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsInSendBackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDisPatcherOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferDispatcherHandleStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferDispatcherStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.PcpBasicInventoryBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemUnitRecordReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemDataQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemUnitConversionRecordRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtendQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemUnitConversionRecordQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IDispatcherOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IDispatcherOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.dto.request.DispatcherOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.DispatcherOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.DispatcherOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.DispatcherOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsDispatcherOrderServiceImpl
implements ICsDispatcherOrderService {
    private static final Logger log = LoggerFactory.getLogger(CsDispatcherOrderServiceImpl.class);
    @Resource
    private IDispatcherOrderDomain dispatcherOrderDomain;
    @Resource
    private IDispatcherOrderDetailDomain dispatcherOrderDetailDomain;
    @Resource
    private CsTransferOrderDas csTransferOrderDas;
    @Resource
    private CsTransferOrderDetailDas csTransferOrderDetailDas;
    @Resource
    private IContext context;
    @Autowired
    private RepeatFilter repeatFilter;
    @Autowired
    BaseOrderFacade baseOrderFacade;
    @Autowired
    private IItemUnitConversionRecordQueryApi itemUnitConversionRecordQueryApi;
    @Resource
    private ICsWmsService csWmsService;
    @Resource
    private IItemExtendQueryApi iItemQueryApi;
    @Resource
    private IItemSkuQueryApiProxy itemSkuQueryApiProxy;
    @Resource
    private IDispatcherOperateLogService dispatcherOperateLogService;
    @Resource
    IInOutNoticeOrderDomain iInOutNoticeOrderDomain;
    @Resource
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource(name="CsBdtransfer_orderBusinessOrderCallBackService")
    ICsBusinessOrderCallBackService csBusinessOrderCallBackService;
    @Value(value="${inventory.dispatcher.split.module:0}")
    private Integer splitModule;

    @Override
    public Long addDispatcherOrder(DispatcherOrderReqDto addReqDto) {
        DispatcherOrderEo dispatcherOrderEo = new DispatcherOrderEo();
        this.dispatcherOrderDomain.insert((BaseEo)dispatcherOrderEo);
        return dispatcherOrderEo.getId();
    }

    @Override
    public void modifyDispatcherOrder(DispatcherOrderReqDto modifyReqDto) {
        DispatcherOrderEo dispatcherOrderEo = new DispatcherOrderEo();
        this.dispatcherOrderDomain.updateSelective((BaseEo)dispatcherOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void calculateDifferencesDispatcher(String transferOrderNo) {
        String key = "DISPATCHER_ORDER:" + transferOrderNo;
        this.repeatFilter.checkRepeat(key, () -> this.checkParams(transferOrderNo), true);
        CsTransferOrderEo transferOrderEo = (CsTransferOrderEo)((ExtQueryChainWrapper)this.csTransferOrderDas.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).one();
        AssertUtil.isTrue(null != transferOrderEo, "\u5355\u53f7" + transferOrderNo + "\u4e0d\u5b58\u5728!");
        log.info("\u8fdb\u884c\u6536\u53d1\u5dee\u5f02\u5904\u7406\u7684\u6311\u62e8\u5355\u8be6\u60c5\u662f:{}", (Object)JSON.toJSONString((Object)transferOrderEo));
        AssertUtil.isTrue(CsTransferOrderEnum.Status.FINISH.getCode().equals(transferOrderEo.getOrderStatus()), "\u8c03\u62e8\u5355\u53ea\u6709\u5df2\u5b8c\u7ed3\u6216\u5df2\u5b8c\u6210\u624d\u53ef\u4ee5\u8ba1\u7b97\u5dee\u5f02\uff01");
        List dispatcherOrderEos = ((ExtQueryChainWrapper)this.dispatcherOrderDomain.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).list();
        AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)dispatcherOrderEos), "\u8c03\u62e8\u5355\u53f7" + transferOrderNo + "\u5df2\u751f\u6210\u4e86\u6536\u53d1\u5dee\u5f02\u5355\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210!");
        List csTransferOrderDetailEos = this.csTransferOrderDetailDas.queryByTransferOrderNo(transferOrderNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csTransferOrderDetailEos), "\u8c03\u62e8\u5355\u8be6\u60c5\u4e3a\u7a7a");
        InOutResultOrderDetailEo outResultOrderDetailEo = new InOutResultOrderDetailEo();
        outResultOrderDetailEo.setRelevanceNo(transferOrderNo);
        List csOutNoticeOrderDetailEos = this.inOutNoticeOrderDetailDomain.queryCsOutNoticeOrderDetailList(outResultOrderDetailEo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csOutNoticeOrderDetailEos), "\u5165\u5e93\u901a\u77e5\u5355\u8be6\u60c5\u4e3a\u7a7a");
        InOutResultOrderEo outResultOrderEo = new InOutResultOrderEo();
        outResultOrderEo.setRelevanceNo(transferOrderNo);
        outResultOrderEo.setDispatcherStatus(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
        List csOutResultOrderDetailEos = this.inOutResultOrderDetailDomain.queryCsOutResultOrderDetailList(outResultOrderEo);
        this.dispatcher(transferOrderEo, csTransferOrderDetailEos, csOutNoticeOrderDetailEos, csOutResultOrderDetailEos);
        transferOrderEo.setDispatcherHandleStatus(CsTransferDispatcherHandleStatusEnum.WAIT_PENGDING.getCode());
        this.csTransferOrderDas.update((BaseEo)transferOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDispatcherOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.dispatcherOrderDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public DispatcherOrderRespDto queryById(Long id) {
        DispatcherOrderEo dispatcherOrderEo = (DispatcherOrderEo)this.dispatcherOrderDomain.selectByPrimaryKey(id);
        DispatcherOrderRespDto dispatcherOrderRespDto = new DispatcherOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)dispatcherOrderEo, (BaseVo)dispatcherOrderRespDto);
        return dispatcherOrderRespDto;
    }

    @Override
    public PageInfo<DispatcherOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        DispatcherOrderReqDto dispatcherOrderReqDto = (DispatcherOrderReqDto)JSON.parseObject((String)filter, DispatcherOrderReqDto.class);
        DispatcherOrderEo dispatcherOrderEo = new DispatcherOrderEo();
        CubeBeanUtils.copyProperties((Object)dispatcherOrderEo, (Object)dispatcherOrderReqDto, (String[])new String[0]);
        PageInfo eoPageInfo = this.dispatcherOrderDomain.selectPage((BaseEo)dispatcherOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DispatcherOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handleDifferencesDispatcher(DispatcherOrderReqDto dispatcherOrderReqDto) {
        AssertUtil.isTrue(null != dispatcherOrderReqDto, "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)dispatcherOrderReqDto.getOrderNo()), "\u5dee\u5f02\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String key = "DISPATCHER_ORDER:" + dispatcherOrderReqDto.getOrderNo();
        this.repeatFilter.checkRepeat(key, () -> this.checkParams(dispatcherOrderReqDto.getOrderNo()), true);
        DispatcherOrderEo dispatcherOrderEo = (DispatcherOrderEo)((ExtQueryChainWrapper)this.dispatcherOrderDomain.filter().eq((Object)"order_no", (Object)dispatcherOrderReqDto.getOrderNo())).one();
        AssertUtil.isTrue(null != dispatcherOrderEo, "\u5dee\u5f02\u5355\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(!CsDisPatcherOrderEnum.Status.CANCEL.getCode().equals(dispatcherOrderEo.getOrderStatus()) && !CsDisPatcherOrderEnum.Status.FINISH.getCode().equals(dispatcherOrderEo.getOrderStatus()), "\u5df2\u5b8c\u6210\u6216\u5df2\u53d6\u6d88\u7684\u5dee\u5f02\u5355\u7981\u6b62\u64cd\u4f5c");
        List dispatcherOrderDetailEos = ((ExtQueryChainWrapper)this.dispatcherOrderDetailDomain.filter().eq((Object)"order_id", (Object)dispatcherOrderEo.getId())).list();
        List dispatcherOrderDetailReqDtos = dispatcherOrderReqDto.getDispatcherOrderDetailReqDtos();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)dispatcherOrderDetailReqDtos), "\u5dee\u5f02\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        List<DispatcherOrderDetailEo> dispatcherOrderDetailEos1 = this.checkQuantity(dispatcherOrderEo, dispatcherOrderDetailReqDtos, dispatcherOrderDetailEos);
        if (CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode().equals(dispatcherOrderEo.getBusinessType())) {
            this.generateDeliveryNoticeOrder(dispatcherOrderEo, dispatcherOrderDetailEos1);
        }
        CsTransferOrderEo transferOrder = (CsTransferOrderEo)((ExtQueryChainWrapper)this.csTransferOrderDas.filter().eq((Object)"transfer_order_no", (Object)dispatcherOrderEo.getTransferOrderNo())).one();
        Map<String, List<DispatcherOrderDetailEo>> collect = dispatcherOrderDetailEos1.stream().collect(Collectors.groupingBy(DispatcherOrderDetailEo::getOperationWay));
        collect.keySet().forEach(k -> {
            Map<String, List<DispatcherOrderDetailEo>> operationWayWarehouseCode = ((List)collect.get(k)).stream().collect(Collectors.groupingBy(a -> a.getOperationWay() + (StringUtils.isBlank((CharSequence)a.getWarehouseCode()) ? "" : a.getWarehouseCode())));
            operationWayWarehouseCode.keySet().forEach(v -> DiffOrderOptContext.getDiffOrderOptAble(dispatcherOrderEo.getType()).handle(DispatchOperateBo.builder().dispatcherOperateWayEnum(DispatcherOperateWayEnum.getByCode(k)).dispatcherOrderDetailEos((List)operationWayWarehouseCode.get(v)).dispatcherOrderReqDto(dispatcherOrderReqDto).originalTransferOrderEo(transferOrder).eo(dispatcherOrderEo).build()));
        });
        DispatcherOperateLogReqDto addReqDto = new DispatcherOperateLogReqDto();
        addReqDto.setOrderNo(dispatcherOrderReqDto.getOrderNo());
        addReqDto.setOrderType(dispatcherOrderEo.getOrderType());
        addReqDto.setBusinessType("\u5904\u7406\u5dee\u5f02");
        addReqDto.setRelevanceNo(dispatcherOrderEo.getTransferOrderNo());
        addReqDto.setRemark(Objects.equals(dispatcherOrderReqDto.getBusinessType(), "less_dispatcher") ? "\u5c11\u6536" : "\u591a\u6536");
        addReqDto.setOperatePerson(StringUtils.isNotBlank((CharSequence)this.context.userName()) ? this.context.userName() : "system");
        addReqDto.setOperateTime(new Date());
        this.dispatcherOperateLogService.addDispatcherOperateLog(addReqDto);
        log.info("\u6536\u53d1\u5dee\u5f02\u56de\u5199\u8c03\u62e8\u5355\u72b6\u6001:dispatcherOrderDetailEos:{}", (Object)JSON.toJSONString((Object)dispatcherOrderDetailEos));
        BigDecimal dispatcher1 = dispatcherOrderDetailEos.stream().map(DispatcherOrderDetailEo::getProcessedQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal dispatcher2 = dispatcherOrderDetailReqDtos.stream().map(DispatcherOrderDetailReqDto::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumDispatcher = dispatcher1.abs().add(dispatcher2.abs());
        BigDecimal sum = transferOrder.getOverchargeQuantity().abs().add(transferOrder.getReceivelessQuantity().abs());
        log.info("\u6536\u53d1\u5dee\u5f02\u56de\u5199\u8c03\u62e8\u5355\u72b6\u6001:dispatcher1:{},dispatcher2:{},sumDispatcher:{},sum:{}", new Object[]{dispatcher1, dispatcher2, sumDispatcher, sum});
        log.info("\u6536\u53d1\u5dee\u5f02\u72b6\u6001:{}", (Object)dispatcherOrderEo.getOrderStatus());
        if (Objects.equals(CsDisPatcherOrderEnum.Status.FINISH.getCode(), dispatcherOrderEo.getOrderStatus())) {
            transferOrder.setDispatcherHandleStatus(CsTransferDispatcherHandleStatusEnum.PROCESSED.getCode());
        } else {
            transferOrder.setDispatcherHandleStatus(CsTransferDispatcherHandleStatusEnum.PORTION_PENGDING.getCode());
        }
        this.csTransferOrderDas.update((BaseEo)transferOrder);
    }

    private void generateDeliveryNoticeOrder(DispatcherOrderEo dispatcherOrderEo, List<DispatcherOrderDetailEo> dispatcherOrderDetailEos) {
        if (CsPcpBusinessTypeEnum.ALLOT_ONLY_RECORD.getCode().equals(dispatcherOrderEo.getSubType())) {
            return;
        }
        ReceiveDeliveryNoticeOrderFacadeBo facadeBo = this.getReceiveDeliveryNoticeOrderFacadeBo(dispatcherOrderEo, dispatcherOrderDetailEos);
        facadeBo.setAutoComplete(Boolean.TRUE);
        facadeBo.setLogicWarehouseCode(dispatcherOrderEo.getInLogicWarehouseCode());
        facadeBo.setLogicWarehouseName(dispatcherOrderEo.getInLogicWarehouseName());
        facadeBo.setPhysicsWarehouseCode(dispatcherOrderEo.getInPhysicsWarehouseCode());
        facadeBo.setPhysicsWarehouseName(dispatcherOrderEo.getInPhysicsWarehouseName());
        this.baseOrderFacade.receiveNoticeOrderGen(facadeBo);
    }

    private ReceiveDeliveryNoticeOrderFacadeBo getReceiveDeliveryNoticeOrderFacadeBo(DispatcherOrderEo dispatcherOrderEo, List<DispatcherOrderDetailEo> dispatcherOrderDetailEos) {
        log.info("generateDeliveryNoticeOrder==>\u6536\u53d1\u5dee\u5f02\u5355\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,orderNo:{}", (Object)dispatcherOrderEo.getOrderNo());
        ReceiveDeliveryNoticeOrderFacadeBo facadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        log.info("generateDeliveryNoticeOrder==>\u8c03\u62e8\u5355\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,orderNo:{}", (Object)dispatcherOrderEo.getTransferOrderNo());
        CubeBeanUtils.copyProperties((Object)facadeBo, (Object)dispatcherOrderEo, (String[])new String[0]);
        facadeBo.setPreOrderNo(dispatcherOrderEo.getOrderNo());
        String externalOrderNo = dispatcherOrderEo.getOrderNo();
        facadeBo.setExternalOrderNo(externalOrderNo);
        facadeBo.setRelevanceNo(dispatcherOrderEo.getTransferOrderNo());
        facadeBo.setSourceType(CsInventorySourceTypeEnum.IN_ALLOT.getCode());
        facadeBo.setBusinessType(dispatcherOrderEo.getType());
        facadeBo.setDisplayBusinessType(PcpBasicInventoryBusinessTypeEnum.EXCHANGE_ORDER_IN.getCode());
        facadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.IN_DISPATCHER_ORDER);
        facadeBo.setRemark(dispatcherOrderEo.getRemark());
        ArrayList<BaseOrderDetailReqDto> deliveryDetailList = new ArrayList<BaseOrderDetailReqDto>(dispatcherOrderDetailEos.size());
        for (DispatcherOrderDetailEo detail : dispatcherOrderDetailEos) {
            BaseOrderDetailReqDto basic = new BaseOrderDetailReqDto();
            CubeBeanUtils.copyProperties((Object)basic, (Object)detail, (String[])new String[0]);
            basic.setSkuCode(detail.getSkuCode());
            basic.setSkuName(detail.getSkuName());
            basic.setQuantity(detail.getDispatcherQuantity());
            basic.setBatch((String)DataExtractUtils.ifNullElse((Object)detail.getBatch(), (Object)""));
            basic.setVolume(detail.getVolume());
            basic.setPreOrderItemId(detail.getId());
            basic.setExpireTime(detail.getDueDate());
            basic.setProduceTime(detail.getProductDate());
            deliveryDetailList.add(basic);
        }
        facadeBo.setOrderBasicsDetailReqDtoList(deliveryDetailList);
        facadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
            }

            public void afterCallBack(BaseOrderBaseContext context) {
                context.setTransparentCallback(Boolean.valueOf(true));
                if (context instanceof InOutResultOrderContext) {
                    CsOrderBusinessCallBackContext csOrderBusinessCallBackContext = BusinessOrderCallBackParseHelper.parseResultCallBack(context);
                    String reqId = MDC.get((String)"yes.req.requestId");
                    CompletableFuture.runAsync(() -> {
                        MDC.put((String)"yes.req.requestId", (String)reqId);
                        CsDispatcherOrderServiceImpl.this.csBusinessOrderCallBackService.pushResultOrder(csOrderBusinessCallBackContext);
                    });
                }
            }
        });
        return facadeBo;
    }

    public void createInResultShifting(DispatcherOrderEo dispatcherOrderEo, List<DispatcherOrderDetailEo> dispatcherOrderDetailEos) {
        InOutNoticeOrderEo csOutNoticeOrderEo;
        List csOutNoticeOrderDetailEoList;
        List csOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iInOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)dispatcherOrderEo.getOrderNo())).eq((Object)"order_type", (Object)CsInventoryInOutEnum.IN.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)csOutNoticeOrderEoList) && CollectionUtils.isNotEmpty((Collection)(csOutNoticeOrderDetailEoList = this.inOutNoticeOrderDetailDomain.queryByDocumentNo((csOutNoticeOrderEo = (InOutNoticeOrderEo)csOutNoticeOrderEoList.stream().sorted(Comparator.comparing(BaseEo::getCreateTime).reversed()).collect(Collectors.toList()).get(0)).getDocumentNo())))) {
            CsWmsInSendBackReqDto csWmsInSendBackReqDto = new CsWmsInSendBackReqDto();
            csWmsInSendBackReqDto.setInNoticeOrderNo(csOutNoticeOrderEo.getDocumentNo());
            csWmsInSendBackReqDto.setInTime(new Date());
            if (!Objects.isNull(dispatcherOrderEo.getBizDate())) {
                csWmsInSendBackReqDto.setInTime(dispatcherOrderEo.getBizDate());
                csWmsInSendBackReqDto.setInOutTime(dispatcherOrderEo.getBizDate());
            }
            csWmsInSendBackReqDto.setCalculateOverchargeFlag(Boolean.valueOf(true));
            csWmsInSendBackReqDto.setExtension(csOutNoticeOrderEo.getExtension());
            ArrayList detailReqDtoList = new ArrayList();
            csOutNoticeOrderDetailEoList.forEach(itemInfo -> {
                CsWmsInSendBackDetailReqDto csWmsInSendBackDetailReqDto = new CsWmsInSendBackDetailReqDto();
                csWmsInSendBackDetailReqDto.setTradeOrderItemId(itemInfo.getId());
                csWmsInSendBackDetailReqDto.setSkuCode(itemInfo.getSkuCode());
                csWmsInSendBackDetailReqDto.setBatch((String)DataExtractUtils.ifNullElse((Object)itemInfo.getBatch(), (Object)""));
                csWmsInSendBackDetailReqDto.setQuantity(itemInfo.getWaitQuantity());
                csWmsInSendBackDetailReqDto.setWarehouseCode(csOutNoticeOrderEo.getWarehouseCode());
                csWmsInSendBackDetailReqDto.setProduceTime(itemInfo.getProduceTime());
                csWmsInSendBackDetailReqDto.setExpireTime(itemInfo.getExpireTime());
                detailReqDtoList.add(csWmsInSendBackDetailReqDto);
            });
            csWmsInSendBackReqDto.setDetailReqDtoList(detailReqDtoList);
            this.csWmsService.inSendBack(csWmsInSendBackReqDto);
        }
    }

    private List<DispatcherOrderDetailEo> checkQuantity(DispatcherOrderEo dispatcherOrderEo, List<DispatcherOrderDetailReqDto> dispatcherOrderDetailReqDtos, List<DispatcherOrderDetailEo> dispatcherOrderDetailEos) {
        List<DispatcherOrderDetailEo> collect = dispatcherOrderDetailEos.stream().filter(a -> CsDisPatcherOrderEnum.Status.WAIT.getCode().equals(a.getOrderStatus())).collect(Collectors.toList());
        BigDecimal processedQuantity = collect.stream().map(DispatcherOrderDetailEo::getProcessedQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal dispatcherQuantity = dispatcherOrderDetailReqDtos.stream().map(DispatcherOrderDetailReqDto::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("\u6536\u53d1\u5dee\u5f02\u5355{}\uff0c\u5224\u5b9a\u5dee\u5f02\u5355\u7684\u4e3b\u5355\u72b6\u6001\u7684\u6570\u91cf:{},{},{},{}", new Object[]{dispatcherOrderEo.getOrderNo(), dispatcherOrderEo.getTotalQuantity(), processedQuantity, dispatcherQuantity, processedQuantity.add(dispatcherQuantity)});
        if (dispatcherOrderEo.getTotalQuantity().compareTo(processedQuantity.add(dispatcherQuantity)) == 0) {
            dispatcherOrderEo.setOrderStatus(CsDisPatcherOrderEnum.Status.FINISH.getCode());
        } else {
            dispatcherOrderEo.setOrderStatus(CsDisPatcherOrderEnum.Status.PORTION_WAIT.getCode());
        }
        this.dispatcherOrderDomain.updateSelective((BaseEo)dispatcherOrderEo);
        Map<String, BigDecimal> reduceMap2 = dispatcherOrderDetailReqDtos.stream().collect(Collectors.groupingBy(a -> a.getSkuCode() + "_" + (InventoryConfig.isNoneBatch() ? "" : a.getBatch()), Collectors.collectingAndThen(Collectors.mapping(DispatcherOrderDetailReqDto::getDispatcherQuantity, Collectors.reducing(BigDecimal::add)), Optional::get)));
        Map<String, List<DispatcherOrderDetailReqDto>> DispatcherOrderDetailReqDtoMap = dispatcherOrderDetailReqDtos.stream().collect(Collectors.groupingBy(a -> a.getSkuCode() + "_" + (InventoryConfig.isNoneBatch() ? "" : a.getBatch())));
        StringBuffer sbuffer = new StringBuffer();
        ArrayList<DispatcherOrderDetailEo> list = new ArrayList<DispatcherOrderDetailEo>();
        log.info("\u6536\u53d1\u5dee\u5f02\u5355,\u5224\u5b9a\u662f\u5426\u9700\u8981\u62c6\u884c\u7684\u5904\u7406\u6570\u91cfreduceMap2:{}", (Object)JSON.toJSONString(reduceMap2));
        log.info("\u6536\u53d1\u5dee\u5f02\u5355,\u5224\u5b9a\u662f\u5426\u9700\u8981\u62c6\u884c\u7684\u5904\u7406\u6570\u91cfDispatcherOrderDetailReqDtoMap:{}", (Object)JSON.toJSONString(DispatcherOrderDetailReqDtoMap));
        collect.forEach(order -> {
            String key = order.getSkuCode() + "_" + (String)DataExtractUtils.ifNullElse((Object)order.getBatch(), (Object)"");
            log.info("\u6536\u53d1\u5dee\u5f02\u5355,\u5224\u5b9a\u662f\u5426\u9700\u8981\u62c6\u884c\u7684\u5904\u7406\u6570\u91cforder.getUntreatedQuantity():{},key:{}", (Object)order.getUntreatedQuantity(), (Object)key);
            if (order.getUntreatedQuantity().compareTo(BigDecimal.ZERO) > 0 && reduceMap2.containsKey(key)) {
                if (order.getUntreatedQuantity().compareTo((BigDecimal)reduceMap2.get(key)) < 0) {
                    sbuffer.append("\u7269\u6599").append(order.getSkuCode()).append("\u5f85\u5904\u7406\u6570\u91cf\u5927\u4e8e\u5355\u636e\u7684\u5f85\u5904\u7406\u6570\u91cf");
                } else if (order.getUntreatedQuantity().compareTo((BigDecimal)reduceMap2.get(key)) > 0) {
                    this.splitDispathcerOrderDetail((DispatcherOrderDetailEo)order, (List)DispatcherOrderDetailReqDtoMap.get(key), order.getUntreatedQuantity().subtract((BigDecimal)reduceMap2.get(key)), (List<DispatcherOrderDetailEo>)list);
                } else if (((List)DispatcherOrderDetailReqDtoMap.get(key)).size() == 1) {
                    order.setProcessedQuantity(order.getUntreatedQuantity());
                    order.setUntreatedQuantity(BigDecimal.ZERO);
                    order.setRemark(((DispatcherOrderDetailReqDto)((List)DispatcherOrderDetailReqDtoMap.get(key)).get(0)).getRemark());
                    order.setOperationWay(((DispatcherOrderDetailReqDto)((List)DispatcherOrderDetailReqDtoMap.get(key)).get(0)).getOperationWay());
                    order.setDispatcherCause(((DispatcherOrderDetailReqDto)((List)DispatcherOrderDetailReqDtoMap.get(key)).get(0)).getDispatcherCause());
                    order.setOperationTime(new Date());
                    order.setOperationPerson(this.context.userName());
                    order.setLiabilityProject(((DispatcherOrderDetailReqDto)((List)DispatcherOrderDetailReqDtoMap.get(key)).get(0)).getLiabilityProject());
                    order.setWarehouseName(((DispatcherOrderDetailReqDto)((List)DispatcherOrderDetailReqDtoMap.get(key)).get(0)).getWarehouseName());
                    order.setWarehouseCode(((DispatcherOrderDetailReqDto)((List)DispatcherOrderDetailReqDtoMap.get(key)).get(0)).getWarehouseCode());
                    this.dispatcherOrderDetailDomain.update((BaseEo)order);
                    list.add((DispatcherOrderDetailEo)order);
                } else {
                    this.splitDispathcerOrderDetail((DispatcherOrderDetailEo)order, (List)DispatcherOrderDetailReqDtoMap.get(key), order.getUntreatedQuantity().subtract((BigDecimal)reduceMap2.get(key)), (List<DispatcherOrderDetailEo>)list);
                }
            }
        });
        AssertUtil.isTrue(StringUtils.isBlank((CharSequence)sbuffer), sbuffer.toString());
        BigDecimal unQuantity = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)) {
            unQuantity = list.stream().map(DispatcherOrderDetailEo::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        log.info("\u524d\u7aef\u4f20\u8fc7\u6765\u7684\u5f85\u5904\u7406\u6570\u91cf:{},\u8ba1\u7b97\u4e4b\u540e\u7684\u5f85\u5904\u7406\u6570\u91cf:{}", (Object)dispatcherQuantity, (Object)unQuantity);
        AssertUtil.isTrue(unQuantity.compareTo(dispatcherQuantity) == 0, "\u5dee\u5f02\u6570\u91cf\u8ba1\u7b97\u6709\u8bef\uff0c\u8bf7\u8c03\u6574\uff01");
        return list;
    }

    public void splitDispathcerOrderDetail(DispatcherOrderDetailEo eo, List<DispatcherOrderDetailReqDto> list, BigDecimal subtract, List<DispatcherOrderDetailEo> listDetailEo) {
        boolean splitUnProcessLine = subtract.compareTo(BigDecimal.ZERO) > 0;
        ArrayList<DispatcherOrderDetailEo> curProcessList = new ArrayList<DispatcherOrderDetailEo>(list.size() + list.size() / 2);
        for (int i = 0; i < list.size(); ++i) {
            DispatcherOrderDetailReqDto dto = list.get(i);
            DispatcherOrderDetailEo dispatcherOrderDetailEo = this.setDispatcherOrderDetailEo(eo, dto.getDispatcherQuantity(), dto.getDispatcherQuantity(), BigDecimal.ZERO, dto.getDispatcherCause(), dto.getWarehouseCode(), dto.getWarehouseName(), dto.getOperationWay(), CsDisPatcherOrderEnum.Status.WAIT.getCode(), dto.getRemark(), dto.getOldUnit(), dto.getLiabilityProject());
            if (list.size() - 1 == i && !splitUnProcessLine) {
                this.compensation(eo, curProcessList, dispatcherOrderDetailEo);
            }
            curProcessList.add(dispatcherOrderDetailEo);
            this.dispatcherOrderDetailDomain.insert((BaseEo)dispatcherOrderDetailEo);
        }
        if (splitUnProcessLine) {
            DispatcherOrderDetailEo dispatcherOrderDetailEo = this.setDispatcherOrderDetailEo(eo, subtract, BigDecimal.ZERO, subtract, null, null, null, null, CsDisPatcherOrderEnum.Status.WAIT.getCode(), eo.getRemark(), eo.getUnit(), null);
            this.compensation(eo, curProcessList, dispatcherOrderDetailEo);
            this.dispatcherOrderDetailDomain.insert((BaseEo)dispatcherOrderDetailEo);
        }
        eo.setOrderStatus(null != eo.getParentId() ? CsDisPatcherOrderEnum.Status.CANCEL.getCode() : CsDisPatcherOrderEnum.Status.SPLIT.getCode());
        this.dispatcherOrderDetailDomain.update((BaseEo)eo);
        listDetailEo.addAll(curProcessList);
    }

    private void compensation(DispatcherOrderDetailEo eo, List<DispatcherOrderDetailEo> curProcessList, DispatcherOrderDetailEo dispatcherOrderDetailEo) {
        dispatcherOrderDetailEo.setPlanQuantity(eo.getPlanQuantity().subtract(curProcessList.stream().map(DispatcherOrderDetailEo::getPlanQuantity).reduce(BigDecimal.ZERO, BigDecimal::add)));
        dispatcherOrderDetailEo.setQuantity(eo.getQuantity().subtract(curProcessList.stream().map(DispatcherOrderDetailEo::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add)));
        dispatcherOrderDetailEo.setCancelQuantity(eo.getCancelQuantity().subtract(curProcessList.stream().map(DispatcherOrderDetailEo::getCancelQuantity).reduce(BigDecimal.ZERO, BigDecimal::add)));
        dispatcherOrderDetailEo.setInQuantity(eo.getInQuantity().subtract(curProcessList.stream().map(DispatcherOrderDetailEo::getInQuantity).reduce(BigDecimal.ZERO, BigDecimal::add)));
        dispatcherOrderDetailEo.setOutQuantity(eo.getOutQuantity().subtract(curProcessList.stream().map(DispatcherOrderDetailEo::getOutQuantity).reduce(BigDecimal.ZERO, BigDecimal::add)));
    }

    public DispatcherOrderDetailEo setDispatcherOrderDetailEo(DispatcherOrderDetailEo eo, BigDecimal subtract, BigDecimal processedQuantity, BigDecimal untreatedQuantity, String dispatcherCause, String warehouseCoe, String warehouseName, String operationWay, String orderStatus, String remark, String oldUnit, String liabilityProject) {
        int inventoryPrecision = InventoryConfig.getInventoryPrecision();
        DispatcherOrderDetailEo dispatcherOrderDetailEo = new DispatcherOrderDetailEo();
        dispatcherOrderDetailEo.setParentId(null != eo.getParentId() ? eo.getParentId() : eo.getId());
        dispatcherOrderDetailEo.setOrderId(eo.getOrderId());
        dispatcherOrderDetailEo.setOrderNo(eo.getOrderNo());
        dispatcherOrderDetailEo.setOrderType(eo.getOrderType());
        dispatcherOrderDetailEo.setBusinessType(eo.getBusinessType());
        dispatcherOrderDetailEo.setSkuCode(eo.getSkuCode());
        dispatcherOrderDetailEo.setSkuName(eo.getSkuName());
        dispatcherOrderDetailEo.setBatch(eo.getBatch());
        dispatcherOrderDetailEo.setSpecification(eo.getSpecification());
        dispatcherOrderDetailEo.setStorageCondition(eo.getStorageCondition());
        dispatcherOrderDetailEo.setProductDate(eo.getProductDate());
        dispatcherOrderDetailEo.setDueDate(eo.getDueDate());
        dispatcherOrderDetailEo.setDispatcherQuantity(subtract);
        dispatcherOrderDetailEo.setDispatcherStatus(eo.getDispatcherStatus());
        BigDecimal cardinal = eo.getDispatcherQuantity();
        dispatcherOrderDetailEo.setQuantity(this.calQuantityByCell(inventoryPrecision, cardinal, eo.getQuantity(), subtract));
        dispatcherOrderDetailEo.setPlanQuantity(this.calQuantityByCell(inventoryPrecision, cardinal, eo.getPlanQuantity(), subtract));
        dispatcherOrderDetailEo.setInQuantity(this.calQuantityByCell(inventoryPrecision, cardinal, eo.getInQuantity(), subtract));
        dispatcherOrderDetailEo.setOutQuantity(this.calQuantityByCell(inventoryPrecision, cardinal, eo.getOutQuantity(), subtract));
        dispatcherOrderDetailEo.setCancelQuantity(this.calQuantityByCell(inventoryPrecision, cardinal, eo.getCancelQuantity(), subtract));
        dispatcherOrderDetailEo.setProcessedQuantity(processedQuantity);
        dispatcherOrderDetailEo.setUntreatedQuantity(untreatedQuantity);
        dispatcherOrderDetailEo.setDispatcherCause(dispatcherCause);
        dispatcherOrderDetailEo.setWarehouseCode(warehouseCoe);
        dispatcherOrderDetailEo.setWarehouseName(warehouseName);
        dispatcherOrderDetailEo.setWeight(subtract.divide(eo.getDispatcherQuantity(), 6, 1).multiply(eo.getWeight()).setScale(2, 1));
        dispatcherOrderDetailEo.setVolume(subtract.divide(eo.getDispatcherQuantity(), 6, 1).multiply(eo.getVolume()).setScale(2, 1));
        dispatcherOrderDetailEo.setUnit(eo.getUnit());
        dispatcherOrderDetailEo.setOperationPerson(this.context.userName());
        dispatcherOrderDetailEo.setOperationTime(new Date());
        dispatcherOrderDetailEo.setOperationWay(operationWay);
        dispatcherOrderDetailEo.setOrderStatus(orderStatus);
        dispatcherOrderDetailEo.setRemark(remark);
        dispatcherOrderDetailEo.setLiabilityProject(liabilityProject);
        return dispatcherOrderDetailEo;
    }

    @NotNull
    private BigDecimal getMaxValue(BigDecimal quantity, BigDecimal subtract, int inventoryPrecision, BigDecimal cardinal) {
        BigDecimal decimal = this.calQuantityByCell(inventoryPrecision, cardinal, quantity, subtract);
        return decimal.compareTo(subtract) < 0 ? subtract : decimal;
    }

    @NotNull
    private BigDecimal calQuantityByCell(int inventoryPrecision, BigDecimal divide, BigDecimal quantity, BigDecimal subtract) {
        if (this.splitModule == 0) {
            return BigDecimal.ZERO;
        }
        return subtract.multiply(quantity).divide(divide, inventoryPrecision, RoundingMode.HALF_DOWN);
    }

    private void dispatcher(CsTransferOrderEo transferOrderEo, List<CsTransferOrderDetailEo> csTransferOrderDetailEos, List<InOutNoticeOrderDetailEo> csOutNoticeOrderDetailEos, List<InOutResultOrderDetailEo> csOutResultOrderDetailEos) {
        ItemUnitRecordReqDto itemUnitRecordReqDto = new ItemUnitRecordReqDto();
        itemUnitRecordReqDto.setDocumentCode(transferOrderEo.getTransferOrderNo());
        List<ItemUnitConversionRecordRespDto> itemUnitConversionRecordRespDtos = this.getItemUnitConversionRecordRespDtos(itemUnitRecordReqDto);
        if (CollectionUtils.isEmpty(itemUnitConversionRecordRespDtos)) {
            itemUnitConversionRecordRespDtos = new ArrayList<ItemUnitConversionRecordRespDto>();
        }
        Map<String, ItemUnitConversionRecordRespDto> itemConversionMap = itemUnitConversionRecordRespDtos.stream().collect(Collectors.toMap(ItemUnitConversionRecordRespDto::getItemCode, Function.identity(), (key1, key2) -> key2));
        log.info("\u539f\u8c03\u62e8\u5355{}\u7684\u5355\u4f4d\u8f6c\u6362\u6570\u636e\u662fitemConversionMap\uff1a{}", (Object)transferOrderEo, (Object)JSON.toJSONString(itemConversionMap));
        DispatcherOrderEo eo = new DispatcherOrderEo();
        this.packageDispathcer(eo, transferOrderEo);
        Map<String, CsTransferOrderDetailEo> transferOrderDetailEoMap = csTransferOrderDetailEos.stream().collect(Collectors.toMap(a -> a.getLongCode() + "_" + (InventoryConfig.isNoneBatch() ? "" : a.getBatch()), Function.identity(), (key1, key2) -> key2));
        Map<String, InOutNoticeOrderDetailEo> outNoticeOrderDetailEoMap = csOutNoticeOrderDetailEos.stream().collect(Collectors.toMap(a -> a.getSkuCode() + "_" + (InventoryConfig.isNoneBatch() ? "" : a.getBatch()), Function.identity(), (key1, key2) -> key2));
        if (CollectionUtils.isEmpty(csOutResultOrderDetailEos)) {
            csOutResultOrderDetailEos = new ArrayList<InOutResultOrderDetailEo>();
        }
        Map<String, InOutResultOrderDetailEo> outResultOrderDetailEoMap = csOutResultOrderDetailEos.stream().collect(Collectors.toMap(a -> a.getSkuCode() + "_" + (InventoryConfig.isNoneBatch() ? "" : a.getBatch()), Function.identity(), (key1, key2) -> key2));
        List<String> itemCodeList = csTransferOrderDetailEos.stream().filter(info -> StringUtils.isNotEmpty((CharSequence)info.getLongCode())).map(CsTransferOrderDetailEo::getLongCode).distinct().collect(Collectors.toList());
        List<ItemDataQueryRespDto> respDtoList = this.selectItem(itemCodeList);
        Map<String, Object> itemMap = new HashMap<String, ItemDataQueryRespDto>();
        if (CollectionUtils.isNotEmpty(respDtoList)) {
            itemMap = respDtoList.stream().collect(Collectors.toMap(ItemDataQueryRespDto::getCode, Function.identity(), (c1, c2) -> c2));
        }
        ArrayList<DispatcherOrderDetailEo> list = new ArrayList<DispatcherOrderDetailEo>();
        HashMap<String, ItemDataQueryRespDto> finalItemMap = itemMap;
        this.sendBackMore(csOutResultOrderDetailEos, transferOrderDetailEoMap, outNoticeOrderDetailEoMap, list, finalItemMap);
        this.matchDispatch(csOutNoticeOrderDetailEos, transferOrderDetailEoMap, outNoticeOrderDetailEoMap, outResultOrderDetailEoMap, list, finalItemMap);
        this.saveAndInsertLog(itemConversionMap, eo, list);
    }

    private void saveAndInsertLog(Map<String, ItemUnitConversionRecordRespDto> itemConversionMap, DispatcherOrderEo eo, List<DispatcherOrderDetailEo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            DispatcherOperateLogReqDto addReqDto;
            ArrayList<ItemUnitRecordReqDto> reqDtoList;
            List<DispatcherOrderDetailEo> dispatcherOrderDetailEos;
            Map<String, List<DispatcherOrderDetailEo>> collect = list.stream().collect(Collectors.groupingBy(DispatcherOrderDetailEo::getBusinessType));
            if (collect.containsKey(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode())) {
                dispatcherOrderDetailEos = collect.get(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                String moreDispatcherNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.DISPATCHER_ORDER.getCode()).getCode();
                eo.setId(null);
                eo.setOrderNo(moreDispatcherNo);
                eo.setOrderType(CsDocumentTypeEnum.DISPATCHER_ORDER.getCode());
                eo.setBusinessType(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                eo.setTotalQuantity(dispatcherOrderDetailEos.stream().map(DispatcherOrderDetailEo::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                this.dispatcherOrderDomain.insert((BaseEo)eo);
                reqDtoList = new ArrayList<ItemUnitRecordReqDto>();
                dispatcherOrderDetailEos.forEach(detail -> {
                    detail.setId(null);
                    detail.setOrderId(eo.getId());
                    detail.setOrderNo(eo.getOrderNo());
                });
                this.dispatcherOrderDetailDomain.insertBatch(dispatcherOrderDetailEos);
                addReqDto = new DispatcherOperateLogReqDto();
                addReqDto.setOrderNo(moreDispatcherNo);
                addReqDto.setOrderType(eo.getOrderType());
                addReqDto.setBusinessType("\u521b\u5efa\u6536\u53d1\u5dee\u5f02\u5355");
                addReqDto.setRelevanceNo(eo.getTransferOrderNo());
                addReqDto.setRemark("\u7cfb\u7edf\u81ea\u52a8\u751f\u6210");
                addReqDto.setOperatePerson(StringUtils.isNotBlank((CharSequence)this.context.userName()) ? this.context.userName() : "system");
                addReqDto.setOperateTime(new Date());
                this.dispatcherOperateLogService.addDispatcherOperateLog(addReqDto);
                log.info("\u591a\u6536\u5904\u7406\u6536\u53d1\u5dee\u5f02\u5355\u7684\u5355\u4f4d\u96c6\u5408\u4e3a:{}", (Object)JSON.toJSONString(reqDtoList));
                if (CollectionUtils.isNotEmpty(reqDtoList)) {
                    this.saveItemRecord(reqDtoList);
                }
            }
            if (collect.containsKey(CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode())) {
                dispatcherOrderDetailEos = collect.get(CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
                String lessDispatcherNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.DISPATCHER_ORDER.getCode()).getCode();
                eo.setId(null);
                eo.setOrderNo(lessDispatcherNo);
                eo.setOrderType(CsDocumentTypeEnum.DISPATCHER_ORDER.getCode());
                eo.setBusinessType(CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
                eo.setTotalQuantity(dispatcherOrderDetailEos.stream().map(DispatcherOrderDetailEo::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                this.dispatcherOrderDomain.insert((BaseEo)eo);
                reqDtoList = new ArrayList();
                dispatcherOrderDetailEos.forEach(detail -> {
                    detail.setId(null);
                    detail.setOrderId(eo.getId());
                    detail.setOrderNo(eo.getOrderNo());
                    if (null != itemConversionMap.get(detail.getSkuCode())) {
                        ItemUnitConversionRecordRespDto respDto = (ItemUnitConversionRecordRespDto)itemConversionMap.get(detail.getSkuCode());
                        ItemUnitRecordReqDto reqDto = new ItemUnitRecordReqDto();
                        reqDto.setDocumentCode(eo.getOrderNo());
                        reqDto.setType(CsRelevanceTableNameEnum.IN_DISPATCHER_ORDER.getCode());
                        reqDto.setItemCode(detail.getSkuCode());
                        BigDecimal dispatcherQuantity = detail.getDispatcherQuantity();
                        reqDto.setItemNum(this.numTo(respDto, dispatcherQuantity));
                        reqDto.setItemUnit(respDto.getItemUnit());
                        detail.setUnit(respDto.getToItemUnit());
                        reqDtoList.add(reqDto);
                    }
                });
                this.dispatcherOrderDetailDomain.insertBatch(dispatcherOrderDetailEos);
                addReqDto = new DispatcherOperateLogReqDto();
                addReqDto.setOrderNo(lessDispatcherNo);
                addReqDto.setOrderType(eo.getOrderType());
                addReqDto.setBusinessType("\u521b\u5efa\u6536\u53d1\u5dee\u5f02\u5355");
                addReqDto.setRelevanceNo(eo.getTransferOrderNo());
                addReqDto.setRemark("\u521b\u5efa\u6536\u53d1\u5dee\u5f02\u5355");
                addReqDto.setOperatePerson(StringUtils.isNotBlank((CharSequence)this.context.userName()) ? this.context.userName() : "system");
                addReqDto.setOperateTime(new Date());
                this.dispatcherOperateLogService.addDispatcherOperateLog(addReqDto);
                log.info("\u5c11\u6536\u5904\u7406\u6536\u53d1\u5dee\u5f02\u5355\u7684\u5355\u4f4d\u96c6\u5408\u4e3a:{}", (Object)JSON.toJSONString(reqDtoList));
                if (CollectionUtils.isNotEmpty(reqDtoList)) {
                    this.saveItemRecord(reqDtoList);
                }
            }
        }
    }

    private void matchDispatch(List<InOutNoticeOrderDetailEo> csOutNoticeOrderDetailEos, Map<String, CsTransferOrderDetailEo> transferOrderDetailEoMap, Map<String, InOutNoticeOrderDetailEo> outNoticeOrderDetailEoMap, Map<String, InOutResultOrderDetailEo> outResultOrderDetailEoMap, List<DispatcherOrderDetailEo> list, Map<String, ItemDataQueryRespDto> finalItemMap) {
        csOutNoticeOrderDetailEos.forEach(dto -> {
            String key = dto.getSkuCode() + "_" + (InventoryConfig.isNoneBatch() ? "" : dto.getBatch());
            if (outNoticeOrderDetailEoMap.containsKey(key)) {
                InOutNoticeOrderDetailEo csOutNoticeOrderDetailEo = (InOutNoticeOrderDetailEo)outNoticeOrderDetailEoMap.get(key);
                DispatcherOrderDetailEo dispatcherOrderDetailEo = new DispatcherOrderDetailEo();
                CsTransferOrderDetailEo transferOrderDetailEo1 = (CsTransferOrderDetailEo)transferOrderDetailEoMap.get(key);
                this.packageDispathcerDetail(dispatcherOrderDetailEo, transferOrderDetailEo1);
                dispatcherOrderDetailEo.setInQuantity(csOutNoticeOrderDetailEo.getDoneQuantity());
                dispatcherOrderDetailEo.setOutQuantity(csOutNoticeOrderDetailEo.getPlanQuantity());
                dispatcherOrderDetailEo.setProcessedQuantity(BigDecimal.ZERO);
                dispatcherOrderDetailEo.setCancelQuantity(csOutNoticeOrderDetailEo.getCancelQuantity());
                dispatcherOrderDetailEo.setOrderStatus(CsDisPatcherOrderEnum.Status.WAIT.getCode());
                dispatcherOrderDetailEo.setOrderType(CsGenerateCodeStrategyEnum.DISPATCHER_ORDER.getCode());
                if (outResultOrderDetailEoMap.containsKey(key)) {
                    log.info("\u5165\u5e93\u901a\u77e5\u547d\u4e2d\u4e86\u5165\u5e93\u7ed3\u679ckey:{}", (Object)key);
                    InOutResultOrderDetailEo outResultOrderDetailEo = (InOutResultOrderDetailEo)outResultOrderDetailEoMap.get(key);
                    log.info("\u6536\u53d1\u5dee\u5f02\u5355\u65b0\u589eoutResultOrderDetailEo:{}", (Object)JSON.toJSONString((Object)outResultOrderDetailEo));
                    log.info("\u6536\u53d1\u5dee\u5f02\u5355\u65b0\u589ecsOutNoticeOrderDetailEo:{}", (Object)JSON.toJSONString((Object)csOutNoticeOrderDetailEo));
                    BigDecimal subtract = outResultOrderDetailEo.getDoneQuantity().subtract(csOutNoticeOrderDetailEo.getPlanQuantity());
                    dispatcherOrderDetailEo.setDispatcherQuantity(subtract.abs());
                    dispatcherOrderDetailEo.setUntreatedQuantity(subtract.abs());
                    if (BigDecimal.ZERO.compareTo(subtract) > 0) {
                        dispatcherOrderDetailEo.setBusinessType(CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
                    } else if (BigDecimal.ZERO.compareTo(subtract) < 0) {
                        dispatcherOrderDetailEo.setBusinessType(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                    }
                } else {
                    log.info("\u5165\u5e93\u901a\u77e5\u6ca1\u6709\u547d\u4e2d\u5165\u5e93\u7ed3\u679ckey:{}", (Object)key);
                    dispatcherOrderDetailEo.setDispatcherQuantity(dto.getPlanQuantity());
                    dispatcherOrderDetailEo.setUntreatedQuantity(dto.getPlanQuantity());
                    dispatcherOrderDetailEo.setBusinessType(CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
                }
                log.info("\u5dee\u5f02\u5355\u591a\u6536\u65b0\u589e\u660e\u7ec6\u884c\uff1a{}", (Object)JSON.toJSONString((Object)dispatcherOrderDetailEo));
                if (dispatcherOrderDetailEo.getDispatcherQuantity().compareTo(BigDecimal.ZERO) > 0) {
                    log.info("\u5dee\u5f02\u5355\u591a\u6536\u65b0\u589e\u660e\u7ec6\u884c\uff1a{}", (Object)JSON.toJSONString((Object)dispatcherOrderDetailEo));
                    list.add(dispatcherOrderDetailEo);
                }
            }
        });
    }

    private void sendBackMore(List<InOutResultOrderDetailEo> csOutResultOrderDetailEos, Map<String, CsTransferOrderDetailEo> transferOrderDetailEoMap, Map<String, InOutNoticeOrderDetailEo> outNoticeOrderDetailEoMap, List<DispatcherOrderDetailEo> list, Map<String, ItemDataQueryRespDto> finalItemMap) {
        if (CollectionUtils.isNotEmpty(csOutResultOrderDetailEos)) {
            csOutResultOrderDetailEos.stream().forEach(dto -> {
                String key = dto.getSkuCode() + "_" + (InventoryConfig.isNoneBatch() ? "" : dto.getBatch());
                if (!outNoticeOrderDetailEoMap.containsKey(key)) {
                    DispatcherOrderDetailEo dispatcherOrderDetailEo = new DispatcherOrderDetailEo();
                    CsTransferOrderDetailEo transferOrderDetailEo1 = (CsTransferOrderDetailEo)transferOrderDetailEoMap.get(key);
                    InOutNoticeOrderDetailEo csOutNoticeOrderDetailEo = (InOutNoticeOrderDetailEo)outNoticeOrderDetailEoMap.get(key);
                    this.packageDispathcerDetail(dispatcherOrderDetailEo, transferOrderDetailEo1);
                    dispatcherOrderDetailEo.setInQuantity(BigDecimal.ZERO);
                    dispatcherOrderDetailEo.setInQuantity(BigDecimal.ZERO);
                    dispatcherOrderDetailEo.setDispatcherQuantity(dto.getDoneQuantity());
                    dispatcherOrderDetailEo.setProcessedQuantity(BigDecimal.ZERO);
                    dispatcherOrderDetailEo.setCancelQuantity(BigDecimal.ZERO);
                    dispatcherOrderDetailEo.setUntreatedQuantity(dto.getDoneQuantity());
                    dispatcherOrderDetailEo.setOrderType(CsGenerateCodeStrategyEnum.DISPATCHER_ORDER.getCode());
                    dispatcherOrderDetailEo.setBusinessType(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                    dispatcherOrderDetailEo.setOrderStatus(CsDisPatcherOrderEnum.Status.WAIT.getCode());
                    log.info("\u5dee\u5f02\u5355\u591a\u6536\u65b0\u589e\u660e\u7ec6\u884c\uff1a{}", (Object)JSON.toJSONString((Object)dispatcherOrderDetailEo));
                    list.add(dispatcherOrderDetailEo);
                }
            });
        }
    }

    @Nullable
    private List<ItemUnitConversionRecordRespDto> getItemUnitConversionRecordRespDtos(ItemUnitRecordReqDto itemUnitRecordReqDto) {
        if (InventoryConfig.isEnableUnit()) {
            return (List)RestResponseHelper.extractData((RestResponse)this.itemUnitConversionRecordQueryApi.selectItemUnitByParams(itemUnitRecordReqDto));
        }
        return new ArrayList<ItemUnitConversionRecordRespDto>();
    }

    private void checkParams(String transferOrderNo) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)transferOrderNo), "\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    private void packageDispathcer(DispatcherOrderEo eo, CsTransferOrderEo transferOrderEo) {
        eo.setTransferOrderNo(transferOrderEo.getTransferOrderNo());
        eo.setPreOrderNo(transferOrderEo.getPreOrderNo());
        eo.setParentOrderNo(transferOrderEo.getPreOrderNo());
        eo.setExternalPurchaseOrderNo(transferOrderEo.getExternalPurchaseOrderNo());
        eo.setExternalSaleOrderNo(transferOrderEo.getExternalSaleOrderNo());
        eo.setType(transferOrderEo.getType());
        eo.setOrderSrc(transferOrderEo.getOrderSrc());
        eo.setOutLogicWarehouseCode(transferOrderEo.getOutLogicWarehouseCode());
        eo.setOutLogicWarehouseName(transferOrderEo.getOutLogicWarehouseName());
        eo.setInLogicWarehouseCode(transferOrderEo.getInLogicWarehouseCode());
        eo.setInLogicWarehouseName(transferOrderEo.getInLogicWarehouseName());
        eo.setOutPhysicsWarehouseCode(transferOrderEo.getOutPhysicsWarehouseCode());
        eo.setOutPhysicsWarehouseName(transferOrderEo.getOutPhysicsWarehouseName());
        eo.setInPhysicsWarehouseCode(transferOrderEo.getInPhysicsWarehouseCode());
        eo.setInPhysicsWarehouseName(transferOrderEo.getInPhysicsWarehouseName());
        eo.setOutOrganization(transferOrderEo.getOutOrganization());
        eo.setOutOrganizationId(transferOrderEo.getOutOrganizationId());
        eo.setInOrganization(transferOrderEo.getInOrganization());
        eo.setInOrganizationId(transferOrderEo.getInOrganizationId());
        eo.setRemark(transferOrderEo.getRemark());
        eo.setSourceSystem(transferOrderEo.getSourceSystem());
        eo.setSubType(transferOrderEo.getSubType());
        eo.setPlanInTime(transferOrderEo.getPlanInTime());
        eo.setPlanOutTime(transferOrderEo.getPlanOutTime());
        eo.setNoBatch(transferOrderEo.getNoBatch());
        eo.setInOrganizationCode(transferOrderEo.getInOrganizationCode());
        eo.setOutOrganizationCode(transferOrderEo.getOutOrganizationCode());
        eo.setIsSendEas(transferOrderEo.getIsSendEas());
        eo.setOrderStatus(CsDisPatcherOrderEnum.Status.WAIT.getCode());
        eo.setBizDate(new Date());
    }

    private void packageDispathcerDetail(DispatcherOrderDetailEo eo, CsTransferOrderDetailEo transferOrderDetailEo) {
        eo.setSkuCode(transferOrderDetailEo.getLongCode());
        eo.setSkuName(transferOrderDetailEo.getCargoName());
        eo.setVolume(transferOrderDetailEo.getVolume());
        eo.setBatch(transferOrderDetailEo.getBatch());
        eo.setSpecification(transferOrderDetailEo.getSpecification());
        eo.setStorageCondition(transferOrderDetailEo.getSpecification());
        try {
            if (StringUtils.isNotBlank((CharSequence)transferOrderDetailEo.getProductDate())) {
                eo.setProductDate(DateUtils.parseString(transferOrderDetailEo.getProductDate(), "yyyy-MM-dd HH:mm:ss"));
            }
            if (StringUtils.isNotBlank((CharSequence)transferOrderDetailEo.getDueDate())) {
                eo.setDueDate(DateUtils.parseString(transferOrderDetailEo.getDueDate(), "yyyy-MM-dd HH:mm:ss"));
            }
        }
        catch (ParseException e) {
            log.error("\u751f\u4ea7\u6216\u8fc7\u671f\u65e5\u671f\u683c\u5f0f\u5316\u5f02\u5e38");
        }
        eo.setQuantity(transferOrderDetailEo.getQuantity());
        eo.setPlanQuantity(transferOrderDetailEo.getQuantity());
    }

    private List<ItemDataQueryRespDto> selectItem(List<String> itemCodeList) {
        return Optional.ofNullable(this.itemSkuQueryApiProxy.queryBySkuCodes(itemCodeList)).map(list -> list.stream().map(itemSkuDto -> {
            ItemDataQueryRespDto respDto = new ItemDataQueryRespDto();
            respDto.setCode(itemSkuDto.getSkuCode());
            respDto.setName(itemSkuDto.getSkuName());
            return respDto;
        }).collect(Collectors.toList())).orElse(new ArrayList());
    }

    private void saveItemRecord(List<ItemUnitRecordReqDto> reqDtoList) {
    }

    private BigDecimal numTo(ItemUnitConversionRecordRespDto respDto, BigDecimal num) {
        Integer conversionNum = null != respDto.getToConversionNum() ? respDto.getToConversionNum() : 0;
        Integer baseUnitNum = null != respDto.getToBaseUnitNum() ? respDto.getToBaseUnitNum() : 0;
        Integer toConversionNum = null != respDto.getConversionNum() ? respDto.getConversionNum() : 0;
        Integer toBaseUnitNum = null != respDto.getBaseUnitNum() ? respDto.getBaseUnitNum() : 0;
        BigDecimal it = num.multiply(new BigDecimal(baseUnitNum)).divide(new BigDecimal(conversionNum), 10, 6);
        BigDecimal toIt = new BigDecimal(toBaseUnitNum).divide(new BigDecimal(toConversionNum), 10, 6);
        BigDecimal budgetItemNum = it.divide(toIt, 10, 6).setScale(3, 1);
        return budgetItemNum;
    }
}

