/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business;

import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBusinessCallBackStrategyEnum;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="csBusinessOrderCallBackUtils")
public class CsBusinessOrderCallBackUtils {
    private static Logger logger = LoggerFactory.getLogger(CsBusinessOrderCallBackUtils.class);
    @Autowired
    private List<ICsBusinessOrderCallBackService> callBackServiceList;
    private static Map<String, ICsBusinessOrderCallBackService> businessOrderCallBackServiceHashMap = Maps.newHashMap();
    public static final String PREFIX = "Cs";
    public static final String SUFFIX = "BusinessOrderCallBackService";
    public static final String COMMON = "common";
    public static final String PLANNED_ORDER = "planned_order";
    public static final String OTHER_IN_OUT = "other_in_out";
    public static final String ORDER_SALE_REFUND = "order_sale_refund";
    public static final String BATCH_ADJUSTMENT_ORDER = "batch_adjustment_order";
    public static final String ORDER_SALE = "order_sale";
    public static final String TRANSFER_ORDER = "transfer_order";
    public static final String PREFIX_BD = "CsBd";
    public static final String DEFAULT_ORDER = "default_order";
    public static final String ORDER_AFTER_SALE = "order_after_sale";

    @PostConstruct
    public void initStrategy() {
        businessOrderCallBackServiceHashMap = this.callBackServiceList.stream().collect(Collectors.toMap(ICsBusinessOrderCallBackService::getStrategy, Function.identity()));
    }

    public static ICsBusinessOrderCallBackService getBusinessOrderCallBackService(String strategy) {
        logger.info("getInventoryService==>\u6839\u636e\u4f20\u5165\u7684\u7b56\u7565\u83b7\u53d6\u64cd\u4f5c\u5355\u636e\u7684\u7b56\u7565\u7c7b,strategy:{}", (Object)strategy);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategy), "\u64cd\u4f5c\u7b56\u7565\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsBusinessCallBackStrategyEnum businessCallBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByCode((String)strategy);
        AssertUtil.isTrue(null != businessCallBackStrategyEnum, "\u83b7\u53d6\u4e0d\u5230\u56de\u8c03\u7c7b");
        return businessOrderCallBackServiceHashMap.get(InventoryConfig.getProjectCode() + businessCallBackStrategyEnum.getCode());
    }
}

