/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.ICsInventoryWarningQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.ICsInventoryWarningService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.other.CsInventoryWarningDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsInventoryWarningEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsInventoryWarningMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsInventoryWarningAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsInventoryWarningUpdateReqDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csInventoryWarningService")
public class CsInventoryWarningServiceImpl
implements ICsInventoryWarningService {
    private static Logger logger = LoggerFactory.getLogger(CsInventoryWarningServiceImpl.class);
    @Autowired
    private CsInventoryWarningDas csInventoryWarningDas;
    @Autowired
    private ICsInventoryWarningQueryService csInventoryWarningQueryService;
    @Autowired
    private CsInventoryWarningMapper csInventoryWarningMapper;

    @Override
    public Long add(CsInventoryWarningAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsInventoryWarningEo insertEo = CsInventoryWarningEo.newInstance();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.csInventoryWarningDas.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsInventoryWarningUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u6709\u8bef");
        CsInventoryWarningEo updateEo = CsInventoryWarningEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.csInventoryWarningDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        CsInventoryWarningEo eo = this.csInventoryWarningQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        this.csInventoryWarningDas.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean batchInsert(List<CsInventoryWarningAddReqDto> addReqDtoList) {
        logger.info("batchInsert==>\u6279\u91cf\u63d2\u5165,addReqDtoList:{}", (Object)LogUtils.buildLogContent(addReqDtoList));
        this.checkParams(addReqDtoList);
        ArrayList csInventoryWarningEoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)csInventoryWarningEoList, addReqDtoList, CsInventoryWarningEo.class);
        this.csInventoryWarningMapper.insertBatch((List)csInventoryWarningEoList);
        return true;
    }

    private void checkParams(List<CsInventoryWarningAddReqDto> addReqDtoList) {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(addReqDtoList), "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsInventoryWarningAddReqDto addReqDto : addReqDtoList) {
            String skuCode = addReqDto.getSkuCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)skuCode), "\u5546\u54c1sku\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            String skuName = addReqDto.getSkuName();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)skuName), "\u5546\u54c1sku\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            String warehouseCode = addReqDto.getWarehouseCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseCode), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            String warehouseName = addReqDto.getWarehouseName();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseName), "\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            String warehouseClassify = addReqDto.getWarehouseClassify();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseClassify) && null != CsWarehouseClassifyEnum.getByCode((String)warehouseClassify), "\u4ed3\u5e93\u5206\u7c7b\u53c2\u6570\u6709\u8bef");
            BigDecimal warningInventory = addReqDto.getWarningInventory();
            AssertUtil.isTrue(null != warningInventory, "\u5e93\u5b58\u9884\u8b66\u53c2\u6570\u6709\u8bef");
        }
    }
}

