/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.AbstractCsInventoryQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsPhysicsInventoryMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BasePageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.InventoryItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsPageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component(value="CsphysicsinventoryStrategyQueryService")
public class CsPhysicsInventoryQueryServiceImpl
extends AbstractCsInventoryQueryService {
    private Logger logger = LoggerFactory.getLogger(CsPhysicsInventoryQueryServiceImpl.class);
    @Autowired
    private CsPhysicsInventoryMapper csPhysicsInventoryMapper;

    @Override
    public String getStrategy() {
        return CsInventoryStrategyEnum.PHYSICS.getCode();
    }

    @Override
    public List<CsInventoryBasicsQueryRespDto> queryCommonInventory(CsInventoryBasicsQueryReqDto query) {
        this.logger.info("queryCommonInventory==>physics,\u57fa\u7840\u5e93\u5b58\u67e5\u8be2,query:{}", (Object)LogUtils.buildLogContent(query));
        if (!this.checkQueryCommonParams(query).booleanValue()) {
            return Lists.newArrayList();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        this.buildQueryCommonWrapper(query, queryWrapper);
        ArrayList resultList = Lists.newArrayList();
        List csPhysicsInventoryEoList = this.csPhysicsInventoryMapper.selectList((Wrapper)queryWrapper);
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)csPhysicsInventoryEoList, CsInventoryBasicsQueryRespDto.class);
        return resultList;
    }

    @Override
    public PageInfo<CsInventoryBasicsPageQueryRespDto> queryInventoryPage(CsInventoryBasicsPageQueryReqDto queryParamDto) {
        this.logger.info("queryInventoryPage===>\u7269\u7406\u4ed3\u5e93\u5b58,\u5e93\u5b58\u5206\u9875\u67e5\u8be2,queryParamDto:{}", (Object)LogUtils.buildLogContent(queryParamDto));
        this.checkParams((BasePageDto)queryParamDto);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!this.buildInventoryPageQueryDto(queryParamDto, queryWrapper).booleanValue()) {
            return new PageInfo();
        }
        PageHelper.startPage((int)queryParamDto.getPageNum(), (int)queryParamDto.getPageSize());
        this.logger.info("queryInventoryPage===>\u7269\u7406\u4ed3\u5e93\u5b58,\u6784\u5efa\u540e\u7684\u67e5\u8be2\u53c2\u6570,queryWrapper:{}", (Object)LogUtils.buildLogContent(queryWrapper));
        List resultList = this.csPhysicsInventoryMapper.selectList((Wrapper)queryWrapper);
        this.logger.info("queryInventoryPage===>\u7269\u7406\u4ed3\u5e93\u5b58,\u67e5\u8be2\u7ed3\u679c\u96c6\u5408,resultList:{}", (Object)LogUtils.buildLogContent(resultList));
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return new PageInfo();
        }
        List<String> cargoCodes = resultList.stream().map(c -> c.getCargoCode()).distinct().collect(Collectors.toList());
        List<String> batchs = resultList.stream().map(c -> c.getBatch()).distinct().collect(Collectors.toList());
        Map<String, InventoryItemExtendRespDto> inventoryItemExtendMap = this.getInventoryItemExtendMap(cargoCodes, batchs);
        List respDtoList = resultList.stream().map(e -> {
            InventoryItemExtendRespDto orDefault;
            CsInventoryBasicsPageQueryRespDto csInventoryBasicsPageQueryRespDto = new CsInventoryBasicsPageQueryRespDto();
            CubeBeanUtils.copyProperties((Object)csInventoryBasicsPageQueryRespDto, (Object)e, (String[])new String[0]);
            if (!ObjectUtils.isEmpty((Object)inventoryItemExtendMap) && !ObjectUtils.isEmpty((Object)(orDefault = (InventoryItemExtendRespDto)inventoryItemExtendMap.getOrDefault(e.getCargoCode() + e.getBatch(), null)))) {
                csInventoryBasicsPageQueryRespDto.setExpireTime(orDefault.getExpireTime());
                csInventoryBasicsPageQueryRespDto.setProduceTime(orDefault.getProduceTime());
            }
            return csInventoryBasicsPageQueryRespDto;
        }).collect(Collectors.toList());
        PageInfo info = new PageInfo(resultList);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(respDtoList);
        return result;
    }
}

