/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InTransitInNoticeDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.IntransitCargoQueryDto;
import com.dtyunxi.tcbj.api.dto.response.IntransitCargoRespDto;
import com.dtyunxi.tcbj.api.query.ICsOutNoticeOrderDetailQueryApi;
import com.dtyunxi.tcbj.api.query.IOutResultOrderQueryApi;
import com.dtyunxi.tcbj.api.vo.Batch;
import com.dtyunxi.tcbj.api.vo.InTransitInNoticeDetailVo;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalWmsApi;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASExtendKeyEnum;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsItemLine;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsOrderCancelReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockEntryOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.response.WmsBaseRespDto;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.BusinessOrderCallBackParseHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.IOrderPreemptWrapperHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.ITransferOrderWrapperHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsDispatcherOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderDetailQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsBusinessOrderCallBackUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsUpdatePreemptServer;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.shop.ICsShopEnquiryApplyExtService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseExposedQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsPhysicsWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsWarehouseAddressQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.CodeGenerateUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsStorageAuditRecordDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsStorageAuditRecordEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsTransferOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsCancelTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderComReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.shop.CsShopEnquiryApplyQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.shop.CsShopEnquiryApplyUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.shop.CsShopEnquiryApplyExtRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsWarehouseAddressRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBusinessCallBackStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsShopEnquiryApplyStatusExtEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferDispatcherHandleStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferDispatcherStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.PcpBasicInventoryBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.dtyunxi.yundt.cube.center.inventory.utils.AddressResolutionUtil;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.basicdata.api.query.IPcpRegionQueryApi;
import com.yunxi.dg.base.center.basicdata.dto.request.PcpRegionReqDto;
import com.yunxi.dg.base.center.basicdata.dto.response.PcpRegionRespDto;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.InventoryPreemptionConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptLendDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.TranferOrderCountRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutNoticeOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutNoticeOrderDetailPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryNoticeOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryNoticeOrderDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.proxy.data.IPcpDictApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.service.entity.IInOutNoticeOrderDetailService;
import com.yunxi.dg.base.center.inventory.service.entity.IReceiveDeliveryNoticeOrderService;
import com.yunxi.dg.base.center.inventory.transcation.TransactionAfterService;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.dto.BasePageDto;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsTransferOrderServiceImpl
implements ICsTransferOrderService {
    private static final Logger logger = LoggerFactory.getLogger(CsTransferOrderServiceImpl.class);
    @Resource
    CsTransferOrderDas csTransferOrderDas;
    @Resource
    CsTransferOrderDetailDas csTransferOrderDetailDas;
    @Resource
    CsCommonService csCommonService;
    @Resource
    IContext context;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource
    CsStorageAuditRecordDas csStorageAuditRecordDas;
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    IRelWarehouseDomain relWarehouseDomain;
    @Resource
    ILogicInventoryDomain logicInventoryDomain;
    @Resource
    CsUpdatePreemptServer csUpdatePreemptServer;
    @Resource
    IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Resource
    CsTransferOrderMapper csTransferOrderMapper;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    ICalcInventoryService calcInventoryService;
    @Resource
    ICsInventoryPreemptionQueryService csInventoryPreemptionQueryService;
    @Autowired
    RepeatFilter repeatFilter;
    @Autowired
    TransactionCallBackService transactionCallBackService;
    @Autowired
    ICommonsMqService commonsMqService;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;
    @Autowired
    BaseOrderFacade baseOrderFacade;
    @Resource
    private ICsShopEnquiryApplyExtService csShopEnquiryApplyExtService;
    @Resource
    private ICsDispatcherOrderService dispatcherOrderService;
    @Resource
    private IPcpDictApiProxy pcpDictApiProxy;
    @Resource
    private IOrderPreemptWrapperHelper orderPreemptWrapperHelper;
    @Resource
    private ITransferOrderWrapperHelper transferOrderWrapperHelper;
    @Resource
    IPcpItemQueryApi pcpItemQueryApi;
    @Autowired
    IWarehouseAddressDomain warehouseAddressDomain;
    @Autowired
    IPcpRegionQueryApi pcpRegionQueryApi;
    @Resource
    private ICsLogicInventoryQueryService inventoryQueryService;
    @Autowired
    IOutResultOrderQueryApi outResultOrderQueryApi;
    @Autowired
    ILockService lockService;
    @Autowired
    TransactionAfterService transactionAfterService;
    @Autowired
    CodeGenerateUtil codeGenerateUtil;
    @Autowired
    IItemSkuQueryApiProxy itemSkuQueryApiProxy;
    @Autowired
    IExternalWmsApi externalWmsApi;
    @Autowired
    ICsWarehouseAddressQueryService csWarehouseAddressQueryService;
    @Autowired
    protected ICsOutResultOrderQueryService csOutResultOrderQueryService;
    @Autowired
    protected ICsOutNoticeOrderQueryService csOutNoticeOrderQueryService;
    @Autowired
    protected IInOutNoticeOrderDetailService inOutNoticeOrderDetailService;
    @Autowired
    protected ICsOutNoticeOrderDetailQueryService csOutNoticeOrderDetailQueryService;
    @Autowired
    private ICsOutNoticeOrderDetailQueryApi csOutNoticeOrderDetailQueryApi;
    @Autowired
    private ICsLogicWarehouseExposedQueryService csLogicWarehouseExposedQueryService;
    @Resource
    protected ICsPhysicsWarehouseQueryService csPhysicsWarehouseQueryService;
    @Autowired
    private IReceiveDeliveryNoticeOrderService receiveDeliveryNoticeOrderService;

    @Override
    public Long addCsTransferOrder(CsTransferOrderReqDto addReqDto) {
        CsTransferOrderEo csTransferOrderEo = new CsTransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)csTransferOrderEo);
        this.csTransferOrderDas.insert((BaseEo)csTransferOrderEo);
        return csTransferOrderEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchEasAddTransferOrder(List<EasTransferOrderReqDto> easTransferOrderReqDtoList) {
        logger.info("batchEasAddTransferOrder,\u6279\u91cf\u521b\u5efa\u8c03\u62e8\u5355:{}", (Object)LogUtils.buildLogContent(easTransferOrderReqDtoList));
        this.validBatchEasAddTransferOrder(easTransferOrderReqDtoList);
        logger.info("batchEasAddTransferOrder,\u6279\u91cf\u521b\u5efa\u8c03\u62e8\u5355\uff0c\u6821\u9a8c\u901a\u8fc7");
        Integer noBatch = this.joinTransferOrderBatch(easTransferOrderReqDtoList);
        ArrayList<String> warehouseCodeList = new ArrayList<String>();
        ArrayList<String> cargoCodeList = new ArrayList<String>();
        ArrayList<CsTransferOrderEo> transferOrderEoList = new ArrayList<CsTransferOrderEo>();
        ArrayList<CsTransferOrderDetailEo> transferOrderDetailEoList = new ArrayList<CsTransferOrderDetailEo>();
        this.joinTransferOrder(noBatch, easTransferOrderReqDtoList, warehouseCodeList, cargoCodeList, transferOrderEoList, transferOrderDetailEoList);
        logger.info("batchEasAddTransferOrder,\u6279\u91cf\u521b\u5efa\u8c03\u62e8\u5355\uff0c\u57fa\u7840\u4fe1\u606f\u62fc\u63a5\u6210\u529f");
        Map<String, RelWarehouseEo> warehouseMap = this.getCsRelWarehouseEoMap(warehouseCodeList);
        List logicWarehouseEoList = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", warehouseCodeList)).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicWarehouseEoList), "\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map<String, LogicWarehouseEo> logicWarehouseMap = logicWarehouseEoList.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, entity -> entity));
        logger.info("batchEasAddTransferOrder,\u6279\u91cf\u521b\u5efa\u8c03\u62e8\u5355\uff0c\u6839\u636e\u903b\u8f91\u4ed3\u7f16\u7801\u67e5\u8be2\u5173\u8054\u7684\u7269\u7406\u4ed3\u7f16\u7801\u67e5\u8be2\u6210\u529f");
        Map<String, ItemSkuDto> itemMap = this.getCsItemEoMap(cargoCodeList);
        logger.info("batchEasAddTransferOrder,\u6279\u91cf\u521b\u5efa\u8c03\u62e8\u5355\uff0c\u6279\u91cf\u67e5\u8be2\u8d27\u54c1\u57fa\u7840\u4fe1\u606f\u6210\u529f");
        this.join(transferOrderEoList, transferOrderDetailEoList, warehouseMap, logicWarehouseMap, itemMap);
        this.csTransferOrderDas.insertBatch(transferOrderEoList);
        this.csTransferOrderDetailDas.insertBatch(transferOrderDetailEoList);
        transferOrderEoList.forEach(r -> this.transactionCallBackService.execute(() -> {
            MessageVo messageVo = new MessageVo();
            CsTransferOrderRespDto respDto = new CsTransferOrderRespDto();
            BeanUtils.copyProperties((Object)r, (Object)respDto);
            messageVo.setData((Object)JSON.toJSONString((Object)respDto));
            this.commonsMqService.publishMessage("TRANSFER_CREATE", (Object)messageVo);
        }));
        logger.info("batchEasAddTransferOrder,\u6279\u91cf\u521b\u5efa\u8c03\u62e8\u5355\uff0c\u5355\u636e\u65b0\u589e\u6210\u529f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long easAddTransferOrder(EasTransferOrderReqDto easTransferOrderReqDto) {
        logger.info("easAddTransferOrder\u521b\u5efa\u8c03\u62e8\u5355\u53c2\u6570:{}", (Object)LogUtils.buildLogContent(easTransferOrderReqDto));
        CsTransferOrderEo csTransferOrderEo = this.validTransferOrder(easTransferOrderReqDto);
        return this.covertParamAndInsert(easTransferOrderReqDto, csTransferOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long easAddRouterTransferOrder(EasTransferOrderReqDto easTransferOrderReqDto) {
        logger.info("easAddRouterTransferOrder\u521b\u5efa\u5728\u9014\u8c03\u62e8\u5355\u53c2\u6570:{}", (Object)LogUtils.buildLogContent(easTransferOrderReqDto));
        CsTransferOrderEo csTransferOrderEo = this.validTransferOrder(easTransferOrderReqDto);
        InTransitInNoticeDetailVo inTransitInNoticeVo = this.routeAllotMatchNotice(easTransferOrderReqDto);
        CsOutNoticeOrderRespDto noticeOrder = this.csOutNoticeOrderQueryService.queryByDocumentNo(inTransitInNoticeVo.getInNoticeNo());
        this.setRouteExtensionMap(easTransferOrderReqDto, inTransitInNoticeVo);
        this.cancelNoticeOrder(inTransitInNoticeVo, noticeOrder);
        this.splitNoticeOrder(inTransitInNoticeVo, noticeOrder);
        return this.covertParamAndInsert(easTransferOrderReqDto, csTransferOrderEo);
    }

    private InTransitInNoticeDetailVo routeAllotMatchNotice(EasTransferOrderReqDto easTransferOrderReqDto) {
        EasTransferOrderDetailReqDto allotOrderDetailDto = (EasTransferOrderDetailReqDto)easTransferOrderReqDto.getItemDetailList().get(0);
        InTransitInNoticeDetailReqDto reqDto = new InTransitInNoticeDetailReqDto();
        reqDto.setSkuCode(allotOrderDetailDto.getLongCode());
        reqDto.setQuantity(Integer.valueOf(allotOrderDetailDto.getQuantity().intValue()));
        reqDto.setInTransitWarehouseCode(allotOrderDetailDto.getOutWarehouseCode());
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1000));
        logger.info("\u5339\u914d\u5165\u5e93\u901a\u77e5\u660e\u7ec6\uff1a{}", (Object)JacksonUtil.toJson((Object)reqDto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderDetailQueryApi.inTransitInNoticeDetail(reqDto));
        if (ObjectUtil.isEmpty((Object)pageInfo) || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            String msg = String.format("\u5339\u914d\u4e0d\u5230\u5bf9\u5e94\u7684\u5165\u5e93\u901a\u77e5\uff0c\u54c1\uff1a%s\uff0c\u6570\u91cf\uff1a%s\uff0c\u51fa\u5e93\u4ed3\uff1a%s", reqDto.getSkuCode(), reqDto.getQuantity(), reqDto.getInTransitWarehouseCode());
            throw new BizException("-1", msg);
        }
        logger.info("\u5339\u914d\u5165\u5e93\u901a\u77e5\u660e\u7ec6\u7ed3\u679c\uff1a{}", (Object)JacksonUtil.toJson((Object)pageInfo.getList()));
        return (InTransitInNoticeDetailVo)pageInfo.getList().get(0);
    }

    private void setRouteExtensionMap(EasTransferOrderReqDto easTransferOrderReqDto, InTransitInNoticeDetailVo inTransitInNoticeVo) {
        Map extensionMap = JacksonUtil.toMap((String)easTransferOrderReqDto.getExtension());
        extensionMap.put(EASExtendKeyEnum.ROUTE_DEAL_TRANSFER_NO.code, inTransitInNoticeVo.getTransferOrderNo());
        extensionMap.put(EASExtendKeyEnum.ROUTE_DEAL_NOTICE_NO.code, inTransitInNoticeVo.getInNoticeNo());
        String ids = inTransitInNoticeVo.getBatches().stream().map(Batch::getId).map(String::valueOf).collect(Collectors.joining(","));
        extensionMap.put(EASExtendKeyEnum.ROUTE_DEAL_DETAIL_ID.code, ids);
        easTransferOrderReqDto.setExtension(JSONObject.toJSONString((Object)extensionMap));
    }

    private void cancelNoticeOrder(InTransitInNoticeDetailVo noticeDetailVo, CsOutNoticeOrderRespDto noticeOrder) {
        CsTransferOrderRespDto transferOrder = this.queryByTransferOrderNo(noticeDetailVo.getTransferOrderNo());
        AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)transferOrder), "-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u62e8\u5355\uff1a" + noticeDetailVo.getTransferOrderNo());
        WmsOrderCancelReqDto cancelReqDto = new WmsOrderCancelReqDto();
        cancelReqDto.setOrderCode(noticeDetailVo.getInNoticeNo());
        cancelReqDto.setOrderType(CsPcpBusinessTypeEnum.ALLOT_IN_ONLY.getCode());
        cancelReqDto.setWarehouseCode(transferOrder.getInPhysicsWarehouseCode());
        cancelReqDto.setLogicWarehouseCode(transferOrder.getInLogicWarehouseCode());
        logger.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\uff0cWMS\u53d6\u6d88\u5165\u5e93\u901a\u77e5\u5355:{}", (Object)JSON.toJSONString((Object)cancelReqDto));
        try {
            WmsBaseRespDto wmsBaseRespDto = (WmsBaseRespDto)RestResponseHelper.extractData((RestResponse)this.externalWmsApi.cancel(cancelReqDto));
            AssertUtil.isTrue(wmsBaseRespDto.isSuccess(), "-1", "\u8bf7\u6c42WMS\u53d6\u6d88\u5165\u5e93\u5931\u8d25\uff1a" + wmsBaseRespDto.getContent());
        }
        catch (Exception e) {
            logger.error("WMS\u53d6\u6d88\u5165\u5e93\u901a\u77e5\u5355\u5931\u8d25\uff1a" + cancelReqDto.getOrderCode() + "\u3002" + e.getMessage());
            throw new BizException("-1", "\u5339\u914d\u5230\u7684\u5165\u5e93\u901a\u77e5\u5355\u53d6\u6d88\u5931\u8d25");
        }
        logger.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\uff0cWMS\u53d6\u6d88\u6536\u8d27\u901a\u77e5\u5355:{}", (Object)JSON.toJSONString((Object)cancelReqDto));
        try {
            RestResponseHelper.extractData((RestResponse)this.receiveDeliveryNoticeOrderService.cancel(noticeOrder.getPreOrderNo()));
        }
        catch (Exception e) {
            logger.error("OCS\u53d6\u6d88\u6536\u8d27\u901a\u77e5\u5355\u5931\u8d25\uff1a" + e.getMessage());
            throw new BizException("-1", "\u5339\u914d\u5230\u7684\u6536\u8d27\u901a\u77e5\u5355\u53d6\u6d88\u5931\u8d25");
        }
    }

    private void splitNoticeOrder(InTransitInNoticeDetailVo inTransitInNoticeVo, CsOutNoticeOrderRespDto noticeOrder) {
        InOutNoticeOrderDetailPageReqDto query = new InOutNoticeOrderDetailPageReqDto();
        query.setDocumentNo(noticeOrder.getDocumentNo());
        query.setPageNum(Integer.valueOf(1));
        query.setPageSize(Integer.valueOf(1000));
        List noticeDetailList = ((PageInfo)this.inOutNoticeOrderDetailService.page((BasePageDto)query).getData()).getList();
        if (noticeDetailList.size() == inTransitInNoticeVo.getBatches().size()) {
            return;
        }
        logger.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\u62c6\u5355");
        List inNoticeDetailIds = inTransitInNoticeVo.getBatches().stream().map(Batch::getId).collect(Collectors.toList());
        List<InOutNoticeOrderDetailDto> spiltNoticeDetailList = noticeDetailList.stream().filter(f -> !inNoticeDetailIds.contains(f.getId())).collect(Collectors.toList());
        ReceiveDeliveryNoticeOrderDto splitNoticeOrderDto = new ReceiveDeliveryNoticeOrderDto();
        BeanUtil.copyProperties((Object)noticeOrder, (Object)splitNoticeOrderDto, (String[])new String[0]);
        splitNoticeOrderDto.setDocumentNo(null);
        splitNoticeOrderDto.setId(null);
        splitNoticeOrderDto.setWmsOrderNo(null);
        splitNoticeOrderDto.setBizDate(null);
        splitNoticeOrderDto.setPreOrderNo(null);
        splitNoticeOrderDto.setOrderType("receive");
        splitNoticeOrderDto.setOrderStatus(null);
        splitNoticeOrderDto.setAutoComplete(Boolean.valueOf(false));
        splitNoticeOrderDto.setSendWms(Boolean.valueOf(true));
        splitNoticeOrderDto.setIgnoreRepeat(Boolean.valueOf(true));
        splitNoticeOrderDto.setExternalOrderNo(noticeOrder.getExternalOrderNo());
        splitNoticeOrderDto.setDeliveryLogicWarehouseCode(noticeOrder.getOutLogicWarehouseCode());
        splitNoticeOrderDto.setDeliveryLogicWarehouseName(noticeOrder.getOutLogicWarehouseName());
        splitNoticeOrderDto.setDeliveryPhysicsWarehouseCode(noticeOrder.getOutPhysicsWarehouseCode());
        splitNoticeOrderDto.setDeliveryPhysicsWarehouseName(noticeOrder.getOutPhysicsWarehouseName());
        splitNoticeOrderDto.setReceiveLogicWarehouseCode(noticeOrder.getInLogicWarehouseCode());
        splitNoticeOrderDto.setReceiveLogicWarehouseName(noticeOrder.getInLogicWarehouseName());
        splitNoticeOrderDto.setReceivePhysicsWarehouseCode(noticeOrder.getInPhysicsWarehouseCode());
        splitNoticeOrderDto.setReceivePhysicsWarehouseName(noticeOrder.getInPhysicsWarehouseName());
        List detailDtoList = spiltNoticeDetailList.stream().map(detail -> {
            ReceiveDeliveryNoticeOrderDetailDto splitDetailDto = new ReceiveDeliveryNoticeOrderDetailDto();
            BeanUtil.copyProperties((Object)detail, (Object)splitDetailDto, (String[])new String[0]);
            splitDetailDto.setId(null);
            splitDetailDto.setDocumentNo(null);
            splitDetailDto.setWmsOrderNo(null);
            splitDetailDto.setPreOrderNo(null);
            if (ObjectUtil.isEmpty((Object)detail.getTradeOrderItemId())) {
                splitDetailDto.setTradeOrderItemId(detail.getPreOrderItemId());
            }
            return splitDetailDto;
        }).collect(Collectors.toList());
        splitNoticeOrderDto.setReceiveDeliveryNoticeOrderDetailDtos(detailDtoList);
        logger.info("\u62c6\u5355\uff0c\u521b\u5efa\u65b0\u7684\u6536\u8d27\u901a\u77e5\u5355\uff1a{}", (Object)JacksonUtil.toJson((Object)splitNoticeOrderDto));
        try {
            ReceiveDeliveryNoticeOrderDto noticeOrderDto = (ReceiveDeliveryNoticeOrderDto)this.receiveDeliveryNoticeOrderService.create(splitNoticeOrderDto).getData();
            noticeOrder.setDocumentNo(noticeOrderDto.getDocumentNo());
            noticeOrder.setId(noticeOrderDto.getId());
            spiltNoticeDetailList.forEach(detail -> detail.setDocumentNo(noticeOrder.getDocumentNo()));
        }
        catch (Exception e) {
            throw new BizException("-1", "\u62c6\u5355\u521b\u5efa\u901a\u77e5\u5355\u5931\u8d25\uff1a" + e.getMessage());
        }
        try {
            this.externalWmsApi.entryOrderCreate(this.buildInWmsSendInfo(noticeOrder, spiltNoticeDetailList));
        }
        catch (Exception e) {
            throw new BizException("-1", "\u62c6\u5355\u63a8\u9001WMS\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private WmsStockEntryOrderReqDto buildInWmsSendInfo(CsOutNoticeOrderRespDto outNoticeOrderEo, List<InOutNoticeOrderDetailDto> detailEoList) {
        WmsStockEntryOrderReqDto wmsStockEntryOrderReqDto = new WmsStockEntryOrderReqDto();
        CsWarehouseAddressParamQueryDto addressDto = new CsWarehouseAddressParamQueryDto();
        addressDto.setWarehouseCode(outNoticeOrderEo.getInPhysicsWarehouseCode());
        List<CsWarehouseAddressRespDto> csWarehouseAddressRespDtoList = this.csWarehouseAddressQueryService.queryParam(addressDto);
        if (CollectionUtil.isNotEmpty(csWarehouseAddressRespDtoList)) {
            CubeBeanUtils.copyProperties((Object)wmsStockEntryOrderReqDto, (Object)csWarehouseAddressRespDtoList.get(0), (String[])new String[0]);
        }
        wmsStockEntryOrderReqDto.setExtensionExternal(this.getExtensionExternal(outNoticeOrderEo.getRelevanceNo()));
        wmsStockEntryOrderReqDto.setDocumentNo(outNoticeOrderEo.getDocumentNo());
        wmsStockEntryOrderReqDto.setRelevanceNo(outNoticeOrderEo.getRelevanceNo());
        wmsStockEntryOrderReqDto.setThirdOrderNo(outNoticeOrderEo.getExternalOrderNo());
        wmsStockEntryOrderReqDto.setOrderCreateTime(DateUtils.formatYMDHms(outNoticeOrderEo.getCreateTime()));
        wmsStockEntryOrderReqDto.setRemark(outNoticeOrderEo.getRemark());
        wmsStockEntryOrderReqDto.setOrderType(outNoticeOrderEo.getOrderType());
        wmsStockEntryOrderReqDto.setBusinessType(outNoticeOrderEo.getBusinessType());
        wmsStockEntryOrderReqDto.setWarehouseCode(outNoticeOrderEo.getInPhysicsWarehouseCode());
        wmsStockEntryOrderReqDto.setLogicWarehouseCode(outNoticeOrderEo.getInLogicWarehouseCode());
        wmsStockEntryOrderReqDto.setEnableBatch(!YesNoEnum.YES.getValue().equals(outNoticeOrderEo.getNoBatch()));
        List<WmsItemLine> itemLines = this.getWmsItemLines(detailEoList);
        CsLogicWarehouseRespDto warehouseRespDto = this.csLogicWarehouseExposedQueryService.queryWarehouseTypeByCode(wmsStockEntryOrderReqDto.getLogicWarehouseCode());
        if (ObjectUtil.isNotEmpty((Object)warehouseRespDto)) {
            wmsStockEntryOrderReqDto.setOrganizationCode(warehouseRespDto.getCargoEscheatageId() + "");
            wmsStockEntryOrderReqDto.setOrganizationName(warehouseRespDto.getCargoEscheatageName());
        }
        CsPhysicsWarehouseQueryDto warehouseQueryDto = new CsPhysicsWarehouseQueryDto();
        warehouseQueryDto.setWarehouseCode(wmsStockEntryOrderReqDto.getWarehouseCode());
        List<CsPhysicsWarehouseRespDto> physicsWarehouseRespDtoList = this.csPhysicsWarehouseQueryService.queryByParam(warehouseQueryDto);
        if (CollectionUtil.isNotEmpty(physicsWarehouseRespDtoList)) {
            wmsStockEntryOrderReqDto.setPhysicsOrganizationCode(physicsWarehouseRespDtoList.get(0).getOrganizationCode());
            wmsStockEntryOrderReqDto.setPhysicsOrganizationName(physicsWarehouseRespDtoList.get(0).getOrganizationName());
        }
        wmsStockEntryOrderReqDto.setItemLines(itemLines);
        return wmsStockEntryOrderReqDto;
    }

    private List<WmsItemLine> getWmsItemLines(List<InOutNoticeOrderDetailDto> detailEoList) {
        ArrayList<WmsItemLine> itemLines = new ArrayList<WmsItemLine>();
        for (InOutNoticeOrderDetailDto InOutNoticeOrderDetailEo2 : detailEoList) {
            WmsItemLine itemLine = new WmsItemLine();
            itemLine.setCargoCode(InOutNoticeOrderDetailEo2.getSkuCode());
            itemLine.setCargoName(InOutNoticeOrderDetailEo2.getSkuName());
            itemLine.setBatch(InOutNoticeOrderDetailEo2.getBatch());
            itemLine.setPlanQuantity(InOutNoticeOrderDetailEo2.getPlanQuantity());
            itemLine.setTradeOrderItemId(null != InOutNoticeOrderDetailEo2.getPreOrderItemId() ? InOutNoticeOrderDetailEo2.getPreOrderItemId().toString() : InOutNoticeOrderDetailEo2.getId().toString());
            itemLines.add(itemLine);
            String productDate = null != InOutNoticeOrderDetailEo2.getProduceTime() ? DateUtils.formatYMDHms(InOutNoticeOrderDetailEo2.getProduceTime()) : null;
            String arrivalDate = null != InOutNoticeOrderDetailEo2.getExpireTime() ? DateUtils.formatYMDHms(InOutNoticeOrderDetailEo2.getExpireTime()) : null;
            itemLine.setProductDate(productDate);
            itemLine.setArrivalDate(arrivalDate);
        }
        return itemLines;
    }

    private String getExtensionExternal(String relevanceNo) {
        logger.info("\u83b7\u53d6\u51fa\u5e93\u7ed3\u679c\u5355\uff1a{}", (Object)relevanceNo);
        CsOutResultOrderQueryDto queryDto = new CsOutResultOrderQueryDto();
        queryDto.setRelevanceNo(relevanceNo);
        List<CsOutResultOrderRespDto> respDtoList = this.csOutResultOrderQueryService.queryByParam(queryDto);
        if (CollectionUtils.isNotEmpty(respDtoList)) {
            return respDtoList.get(0).getExtensionExternal();
        }
        return null;
    }

    private Integer joinTransferOrderBatch(List<EasTransferOrderReqDto> easTransferOrderReqDtoList) {
        String batch = ((EasTransferOrderDetailReqDto)easTransferOrderReqDtoList.get(0).getItemDetailList().get(0)).getBatch();
        if (StringUtils.isNotBlank((CharSequence)batch)) {
            return YesNoEnum.NO.getValue();
        }
        List<String> sourceNoList = easTransferOrderReqDtoList.stream().map(EasTransferOrderReqDto::getExternalSaleOrderNo).collect(Collectors.toList());
        List<InventoryPreemptionEo> InventoryPreemptionEoList = this.getInventoryPreemptionEos(sourceNoList);
        List batchPreemptList = InventoryPreemptionEoList.stream().filter(obj -> StringUtils.isNotBlank((CharSequence)obj.getBatch())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(batchPreemptList)) {
            logger.info("joinTransferOrderBatch,\u5355\u636e\u6ca1\u6709\u9884\u5360\u5230\u6279\u6b21");
            return YesNoEnum.YES.getValue();
        }
        HashMap<String, List> batchMap = new HashMap<String, List>();
        for (InventoryPreemptionEo InventoryPreemptionEo2 : batchPreemptList) {
            String key = InventoryPreemptionEo2.getSourceNo() + "_" + InventoryPreemptionEo2.getSkuCode();
            List preemptionEoList = (List)batchMap.get(key);
            preemptionEoList = CollectionUtils.isNotEmpty((Collection)preemptionEoList) ? preemptionEoList : new ArrayList();
            preemptionEoList.add(InventoryPreemptionEo2);
            batchMap.put(key, preemptionEoList);
        }
        for (EasTransferOrderReqDto easTransferOrderReqDto : easTransferOrderReqDtoList) {
            ArrayList<EasTransferOrderDetailReqDto> itemDetailList = new ArrayList<EasTransferOrderDetailReqDto>();
            for (EasTransferOrderDetailReqDto detailReqDto : easTransferOrderReqDto.getItemDetailList()) {
                String key = easTransferOrderReqDto.getExternalSaleOrderNo() + "_" + detailReqDto.getLongCode();
                List preemptionEoList = (List)batchMap.get(key);
                if (CollectionUtils.isNotEmpty((Collection)preemptionEoList)) {
                    if (preemptionEoList.size() == 1) {
                        InventoryPreemptionEo InventoryPreemptionEo3 = (InventoryPreemptionEo)preemptionEoList.get(0);
                        detailReqDto.setBatch(InventoryPreemptionEo3.getBatch());
                        itemDetailList.add(detailReqDto);
                        continue;
                    }
                    ArrayList<EasTransferOrderDetailReqDto> list = new ArrayList<EasTransferOrderDetailReqDto>();
                    for (InventoryPreemptionEo InventoryPreemptionEo4 : preemptionEoList) {
                        EasTransferOrderDetailReqDto detailReqDto1 = new EasTransferOrderDetailReqDto();
                        CubeBeanUtils.copyProperties((Object)detailReqDto1, (Object)detailReqDto, (String[])new String[0]);
                        detailReqDto1.setBatch(InventoryPreemptionEo4.getBatch());
                        detailReqDto1.setQuantity(InventoryPreemptionEo4.getPreemptNum());
                        list.add(detailReqDto1);
                    }
                    this.apportion(list, detailReqDto);
                    itemDetailList.addAll(list);
                    continue;
                }
                itemDetailList.add(detailReqDto);
            }
            easTransferOrderReqDto.setItemDetailList(itemDetailList);
        }
        logger.info("batchEasAddTransferOrder,\u6279\u91cf\u521b\u5efa\u8c03\u62e8\u5355,\u62fc\u63a5\u7ed3\u679c:{}", (Object)LogUtils.buildLogContent(easTransferOrderReqDtoList));
        return YesNoEnum.YES.getValue();
    }

    private void apportion(List<EasTransferOrderDetailReqDto> list, EasTransferOrderDetailReqDto reqDto) {
        try {
            logger.info("\u82e5\u8fdb\u884c\u62c6\u5206\u5546\u54c1\u884c\uff0c\u5219\u5546\u54c1\u884c\u5185\u7684\u91d1\u989d\u4e5f\u9700\u8981\u5206\u644a\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)reqDto), (Object)JSON.toJSONString(list));
            int i = 0;
            BigDecimal discountAmount = BigDecimal.ZERO;
            BigDecimal payableAmount = BigDecimal.ZERO;
            BigDecimal actuallyAmount = BigDecimal.ZERO;
            for (EasTransferOrderDetailReqDto dto : list) {
                if (++i < list.size()) {
                    discountAmount = discountAmount.add(this.apportionSingle(dto, reqDto.getQuantity(), EASExtendKeyEnum.DISCOUNT_AMOUNT.code, null));
                    payableAmount = payableAmount.add(this.apportionSingle(dto, reqDto.getQuantity(), EASExtendKeyEnum.ITEM_PAYABLE_AMOUNT.code, null));
                    actuallyAmount = actuallyAmount.add(this.apportionSingle(dto, reqDto.getQuantity(), EASExtendKeyEnum.ITEM_ACTUALLY_AMOUNT.code, null));
                    continue;
                }
                this.apportionSingle(dto, reqDto.getQuantity(), EASExtendKeyEnum.DISCOUNT_AMOUNT.code, discountAmount);
                this.apportionSingle(dto, reqDto.getQuantity(), EASExtendKeyEnum.ITEM_PAYABLE_AMOUNT.code, payableAmount);
                this.apportionSingle(dto, reqDto.getQuantity(), EASExtendKeyEnum.ITEM_ACTUALLY_AMOUNT.code, actuallyAmount);
            }
        }
        catch (Exception e) {
            logger.error("\u82e5\u8fdb\u884c\u62c6\u5206\u5546\u54c1\u884c\uff0c\u5219\u5546\u54c1\u884c\u5185\u7684\u91d1\u989d\u4e5f\u9700\u8981\u5206\u644a\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private BigDecimal apportionSingle(EasTransferOrderDetailReqDto reqDto, BigDecimal totalQuantity, String code, BigDecimal total) {
        if (StringUtils.isBlank((CharSequence)reqDto.getExtension())) {
            return BigDecimal.ZERO;
        }
        Map extMap = (Map)JSON.parseObject((String)reqDto.getExtension(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        Object amount = extMap.get(code);
        if (ObjectUtil.isNotEmpty(amount) && new BigDecimal(amount.toString()).compareTo(BigDecimal.ZERO) > 0) {
            if (ObjectUtil.isNotEmpty((Object)total)) {
                extMap.put(code, new BigDecimal(amount.toString()).subtract(total));
                reqDto.setExtension(JSON.toJSONString((Object)extMap));
                return BigDecimal.ZERO;
            }
            BigDecimal divide = new BigDecimal(amount.toString()).divide(totalQuantity, 2, 1);
            BigDecimal multiply = divide.multiply(reqDto.getQuantity());
            extMap.put(code, multiply);
            reqDto.setExtension(JSON.toJSONString((Object)extMap));
            return multiply;
        }
        return BigDecimal.ZERO;
    }

    private void join(List<CsTransferOrderEo> transferOrderEoList, List<CsTransferOrderDetailEo> transferOrderDetailEoList, Map<String, RelWarehouseEo> warehouseMap, Map<String, LogicWarehouseEo> logicWarehouseMap, Map<String, ItemSkuDto> itemMap) {
        for (CsTransferOrderEo transferOrderEo : transferOrderEoList) {
            RelWarehouseEo outRelWarehouseEo = warehouseMap.get(transferOrderEo.getOutLogicWarehouseCode());
            RelWarehouseEo inRelWarehouseEo = warehouseMap.get(transferOrderEo.getInLogicWarehouseCode());
            LogicWarehouseEo outLogicWarehouseEo = logicWarehouseMap.get(transferOrderEo.getOutLogicWarehouseCode());
            LogicWarehouseEo inLogicWarehouseEo = logicWarehouseMap.get(transferOrderEo.getInLogicWarehouseCode());
            AssertUtil.isTrue(null != outLogicWarehouseEo, "\u51fa\u5e93\u4ed3\u5e93[" + transferOrderEo.getOutLogicWarehouseCode() + "]\u4ed3\u5e93\u4e0d\u5b58\u5728");
            AssertUtil.isTrue(null != inLogicWarehouseEo, "\u5165\u5e93\u4ed3\u5e93[" + transferOrderEo.getInLogicWarehouseCode() + "]\u4e0d\u5b58\u5728");
            AssertUtil.isTrue(null != outRelWarehouseEo, "\u51fa\u5e93\u4ed3\u5e93[" + transferOrderEo.getOutLogicWarehouseCode() + "]\u5173\u8054\u7684\u7269\u7406\u4ed3\u5e93\u4e0d\u5b58\u5728");
            AssertUtil.isTrue(null != inRelWarehouseEo, "\u5165\u5e93\u4ed3\u5e93[" + transferOrderEo.getInLogicWarehouseCode() + "]\u5173\u8054\u7684\u7269\u7406\u4ed3\u5e93\u4e0d\u5b58\u5728");
            transferOrderEo.setOutLogicWarehouseName(outRelWarehouseEo.getWarehouseName());
            transferOrderEo.setOutPhysicsWarehouseCode(outRelWarehouseEo.getRefWarehouseCode());
            transferOrderEo.setOutPhysicsWarehouseName(outRelWarehouseEo.getRefWarehouseName());
            transferOrderEo.setInLogicWarehouseName(inRelWarehouseEo.getWarehouseName());
            transferOrderEo.setInPhysicsWarehouseCode(inRelWarehouseEo.getRefWarehouseCode());
            transferOrderEo.setInPhysicsWarehouseName(inRelWarehouseEo.getRefWarehouseName());
            transferOrderEo.setOutOrganizationId(outLogicWarehouseEo.getOrganizationId());
            transferOrderEo.setOutOrganization(outLogicWarehouseEo.getOrganizationName());
            transferOrderEo.setInOrganizationId(inLogicWarehouseEo.getOrganizationId());
            transferOrderEo.setInOrganization(inLogicWarehouseEo.getOrganizationName());
        }
        for (CsTransferOrderDetailEo detailEo : transferOrderDetailEoList) {
            ItemSkuDto csItemEo = itemMap.get(detailEo.getLongCode());
            AssertUtil.isTrue(null != csItemEo, detailEo.getLongCode() + "\u8d27\u54c1\u7f16\u7801\u4e0d\u5b58\u5728");
            detailEo.setCargoName(csItemEo.getSkuName());
            if (!ObjectUtil.isEmpty((Object)detailEo.getVolume()) || !ObjectUtil.isNotEmpty((Object)csItemEo.getVolume())) continue;
            detailEo.setVolume(csItemEo.getVolume().multiply(detailEo.getQuantity()).setScale(4, RoundingMode.DOWN));
        }
    }

    private void joinTransferOrder(Integer noBatch, List<EasTransferOrderReqDto> easTransferOrderReqDtoList, List<String> warehouseCodeList, List<String> cargoCodeList, List<CsTransferOrderEo> transferOrderEoList, List<CsTransferOrderDetailEo> transferOrderDetailEoList) {
        for (EasTransferOrderReqDto easTransferOrderReqDto : easTransferOrderReqDtoList) {
            CsTransferOrderEo transferOrderEo = new CsTransferOrderEo();
            CubeBeanUtils.copyProperties((Object)transferOrderEo, (Object)easTransferOrderReqDto, (String[])new String[0]);
            transferOrderEo.setOrderStatus(CsTransferOrderEnum.Status.WAIT_AUDIT.getCode());
            String transferNo = easTransferOrderReqDto.getExternalSaleOrderNo();
            transferOrderEo.setTransferOrderNo(transferNo);
            transferOrderEo.setType(easTransferOrderReqDto.getAllotType());
            transferOrderEo.setPreOrderNo(easTransferOrderReqDto.getPlatformOrderNo());
            transferOrderEo.setOrderSrc("EAS");
            transferOrderEo.setNoBatch(noBatch);
            BigDecimal totalQuantity = BigDecimal.ZERO;
            List<String> itemCodes = easTransferOrderReqDto.getItemDetailList().stream().map(EasTransferOrderDetailReqDto::getLongCode).collect(Collectors.toList());
            Map<String, PcpItemRespDto> itemCenterMap = this.queryItemInfo(itemCodes);
            for (EasTransferOrderDetailReqDto detailReqDto : easTransferOrderReqDto.getItemDetailList()) {
                PcpItemRespDto pcpItemRespDto;
                CsTransferOrderDetailEo csTransferOrderDetailEo = new CsTransferOrderDetailEo();
                csTransferOrderDetailEo.setBatch(detailReqDto.getBatch());
                csTransferOrderDetailEo.setQuantity(detailReqDto.getQuantity());
                csTransferOrderDetailEo.setLongCode(detailReqDto.getLongCode());
                csTransferOrderDetailEo.setExtension(detailReqDto.getExtension());
                csTransferOrderDetailEo.setTransferOrderNo(transferNo);
                csTransferOrderDetailEo.setVolume(detailReqDto.getVolume());
                csTransferOrderDetailEo.setProduceTime(detailReqDto.getProduceTime());
                csTransferOrderDetailEo.setExpireTime(detailReqDto.getExpireTime());
                if (ObjectUtil.isNotEmpty(itemCenterMap) && ObjectUtil.isNotEmpty((Object)itemCenterMap.get(detailReqDto.getLongCode())) && ObjectUtil.isNotEmpty((Object)(pcpItemRespDto = itemCenterMap.get(detailReqDto.getLongCode())).getGrossWeight())) {
                    csTransferOrderDetailEo.setWeight(pcpItemRespDto.getGrossWeight().multiply(csTransferOrderDetailEo.getQuantity()));
                }
                transferOrderDetailEoList.add(csTransferOrderDetailEo);
                cargoCodeList.add(detailReqDto.getLongCode());
                totalQuantity = totalQuantity.add(csTransferOrderDetailEo.getQuantity());
            }
            transferOrderEo.setTotalQuantity(totalQuantity);
            easTransferOrderReqDto.setBusinessOrderNo(transferNo);
            transferOrderEo.setOutLogicWarehouseCode(easTransferOrderReqDto.getOutWarehouseCode());
            transferOrderEo.setInLogicWarehouseCode(easTransferOrderReqDto.getInWarehouseCode());
            transferOrderEoList.add(transferOrderEo);
            warehouseCodeList.add(easTransferOrderReqDto.getOutWarehouseCode());
            warehouseCodeList.add(easTransferOrderReqDto.getInWarehouseCode());
        }
    }

    private Map<String, ItemSkuDto> getCsItemEoMap(List<String> cargoCodeList) {
        List itemEoList = this.itemSkuProxy.queryBySkuCodes(cargoCodeList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)itemEoList), "\u8bf7\u914d\u7f6e\u8d27\u54c1\u57fa\u7840\u4fe1\u606f");
        return itemEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, entity -> entity));
    }

    private Map<String, RelWarehouseEo> getCsRelWarehouseEoMap(List<String> warehouseCodeList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        queryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        queryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        queryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List csRelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)queryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csRelWarehouseEoList), "\u4ed3\u5e93\u672a\u914d\u7f6e\u5173\u8054\u7684\u7269\u7406\u4ed3");
        return csRelWarehouseEoList.stream().collect(Collectors.toMap(RelWarehouseEo::getWarehouseCode, entity -> entity));
    }

    private void validBatchEasAddTransferOrder(List<EasTransferOrderReqDto> easTransferOrderReqDtoList) {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(easTransferOrderReqDtoList), "\u5355\u636e\u4e0d\u5b58\u5728");
        ArrayList<String> sourceNoList = new ArrayList<String>();
        for (EasTransferOrderReqDto easTransferOrderReqDto : easTransferOrderReqDtoList) {
            String key = "CREATE_TRANSFER:" + easTransferOrderReqDto.getExternalSaleOrderNo();
            this.repeatFilter.checkRepeat(key, () -> this.validParam(sourceNoList, easTransferOrderReqDto), true, "\u64cd\u4f5c\u9891\u7e41\uff0c[" + easTransferOrderReqDto.getExternalSaleOrderNo() + "]\u8be5\u5355\u6b63\u5728\u64cd\u4f5c\u521b\u5efa\u5355\u636e");
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.in((Object)"external_sale_order_no", sourceNoList);
        queryWrapper1.eq((Object)"dr", (Object)0);
        List transferOrderEoList = this.csTransferOrderMapper.selectList((Wrapper)queryWrapper1);
        if (CollectionUtils.isNotEmpty((Collection)transferOrderEoList)) {
            List transferOrderEoList1 = transferOrderEoList.stream().filter(obj -> !CsTransferOrderEnum.Status.CANCELED.getCode().equals(obj.getOrderStatus())).collect(Collectors.toList());
            AssertUtil.isTrue(CollectionUtils.isEmpty(transferOrderEoList1), JSON.toJSONString(transferOrderEoList1.stream().map(CsTransferOrderEo::getPreOrderNo).collect(Collectors.toList())) + "\u8c03\u62e8\u5355\u5df2\u5b58\u5728");
        }
        List<InventoryPreemptionEo> InventoryPreemptionEoList = this.getInventoryPreemptionEos(sourceNoList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(InventoryPreemptionEoList), "\u5355\u636e\u672a\u9884\u5360\uff0c\u8bf7\u786e\u8ba4\u540e\u53d1\u8d77");
        List sourceNos = InventoryPreemptionEoList.stream().map(InventoryPreemptionEo::getSourceNo).distinct().collect(Collectors.toList());
        sourceNoList.removeAll(sourceNos);
        AssertUtil.isTrue(CollectionUtils.isEmpty(sourceNoList), JSON.toJSONString(sourceNoList) + "\u5355\u636e\u672a\u9884\u5360\uff0c\u8bf7\u786e\u8ba4\u540e\u53d1\u8d77");
    }

    private void validParam(List<String> sourceNoList, EasTransferOrderReqDto easTransferOrderReqDto) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)easTransferOrderReqDto.getPlatformOrderNo()), "\u5e73\u53f0\u5355\u53f7\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)easTransferOrderReqDto.getExternalPurchaseOrderNo()), "\u5916\u90e8\u91c7\u8d2d\u5355\u53f7\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)easTransferOrderReqDto.getExternalSaleOrderNo()), "\u5916\u90e8\u9500\u552e\u5355\u53f7\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)easTransferOrderReqDto.getAllotType()), "\u8c03\u62e8\u5355\u636e\u7c7b\u578b\u4e0d\u5b58\u5728");
        CsPcpBusinessTypeEnum typeEnum = CsPcpBusinessTypeEnum.getByCode((String)easTransferOrderReqDto.getAllotType());
        AssertUtil.isTrue(Objects.nonNull(typeEnum), "\u8c03\u62e8\u5355\u7c7b\u578b\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)easTransferOrderReqDto.getOutWarehouseCode()), "\u8c03\u51fa\u4ed3\u5e93\u7f16\u7801\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)easTransferOrderReqDto.getInWarehouseCode()), "\u8c03\u5165\u4ed3\u5e93\u7f16\u7801\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)easTransferOrderReqDto.getSourceSystem()), "\u6765\u6e90\u7cfb\u7edf\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)easTransferOrderReqDto.getItemDetailList()), "\u8d27\u54c1\u660e\u7ec6\u4e0d\u5b58\u5728");
        for (EasTransferOrderDetailReqDto detailReqDto : easTransferOrderReqDto.getItemDetailList()) {
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)detailReqDto.getLongCode()), "\u8d27\u54c1\u7f16\u7801\u4e0d\u5b58\u5728");
            AssertUtil.isTrue(null != detailReqDto.getQuantity() && BigDecimal.ZERO.compareTo(detailReqDto.getQuantity()) < 0, "\u8bf7\u6307\u5b9a\u53d8\u52a8\u6570\u91cf,\u4e14\u4e3a\u6b63\u6570");
        }
        sourceNoList.add(easTransferOrderReqDto.getExternalSaleOrderNo());
    }

    private List<InventoryPreemptionEo> getInventoryPreemptionEos(List<String> sourceNoList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_no", sourceNoList);
        queryWrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode());
        queryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List InventoryPreemptionEoList = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)queryWrapper);
        return InventoryPreemptionEoList;
    }

    private Map<String, List<LogicInventoryEo>> getLogicEoMap(List<EasTransferOrderDetailReqDto> commonCargoList1) {
        List warehouseCodeList = commonCargoList1.stream().map(EasTransferOrderDetailReqDto::getOutWarehouseCode).collect(Collectors.toList());
        List longCodeList = commonCargoList1.stream().map(EasTransferOrderDetailReqDto::getLongCode).collect(Collectors.toList());
        QueryWrapper logicWrapper = new QueryWrapper();
        logicWrapper.in((Object)"warehouse_code", warehouseCodeList);
        logicWrapper.in((Object)"sku_code", longCodeList);
        logicWrapper.gt((Object)"available", (Object)0);
        logicWrapper.eq((Object)"dr", (Object)0);
        List csLogicInventoryEoList = this.logicInventoryDomain.getMapper().selectList((Wrapper)logicWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csLogicInventoryEoList), "\u903b\u8f91\u4ed3\u5e93\u5b58\u4e0d\u5b58\u5728");
        Map<String, List<LogicInventoryEo>> logicEoMap = csLogicInventoryEoList.stream().collect(Collectors.groupingBy(eo -> eo.getWarehouseCode() + "_" + eo.getSkuCode()));
        return logicEoMap;
    }

    private void joinBatch(List<EasTransferOrderReqDto> easTransferOrderReqDtoList, Map<String, List<LogicInventoryEo>> logicEoMap) {
        for (EasTransferOrderReqDto easTransferOrderReqDto : easTransferOrderReqDtoList) {
            ArrayList<EasTransferOrderDetailReqDto> itemDetailList = new ArrayList<EasTransferOrderDetailReqDto>();
            block1: for (EasTransferOrderDetailReqDto detailReqDto : easTransferOrderReqDto.getItemDetailList()) {
                String key = detailReqDto.getOutWarehouseCode() + "_" + detailReqDto.getLongCode();
                List<LogicInventoryEo> logicEoList = logicEoMap.get(key);
                if (CollectionUtils.isEmpty(logicEoList)) continue;
                List actBalanceList = logicEoList.stream().sorted(Comparator.comparing(LogicInventoryEo::getBatch)).collect(Collectors.toList());
                LogicInventoryEo inventoryEo = logicEoList.get(0);
                BigDecimal changeInventory = detailReqDto.getQuantity();
                BigDecimal totalBatchAvailable = logicEoList.stream().map(LogicInventoryEo::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
                logger.info("preBatchCalculate==>totalBatchAvailable:{}", (Object)totalBatchAvailable);
                if (changeInventory.compareTo(totalBatchAvailable) > 0) {
                    logger.info("\u5355\u636e\u53f7sourceNo:{},\u8d27\u54c1longCode:{}\uff0c\u53ef\u7528\u5e93\u5b58available:{}", new Object[]{easTransferOrderReqDto.getExternalSaleOrderNo(), inventoryEo.getSkuCode(), inventoryEo.getAvailable()});
                    throw new BizException(String.format("\u8d27\u54c1\u3010%s\u3011\u5269\u4f59\u5e93\u5b58\u4e0d\u8db3", inventoryEo.getSkuName()));
                }
                int count = 1;
                for (LogicInventoryEo logicEo : actBalanceList) {
                    BigDecimal available = logicEo.getAvailable();
                    BigDecimal subtract = available.subtract(changeInventory);
                    logger.info("preBatchCalculate==>\u6570\u636e\u5bf9\u6bd4,sourceNo:{},available:{},subtract:{},changeInventory:{}", new Object[]{easTransferOrderReqDto.getExternalSaleOrderNo(), available, subtract, changeInventory});
                    int compareVal = subtract.compareTo(BigDecimal.ZERO);
                    EasTransferOrderDetailReqDto batchReqDto = new EasTransferOrderDetailReqDto();
                    CubeBeanUtils.copyProperties((Object)batchReqDto, (Object)detailReqDto, (String[])new String[0]);
                    if (StringUtils.isBlank((CharSequence)detailReqDto.getBatch())) {
                        batchReqDto.setBatch(logicEo.getBatch());
                        detailReqDto.setBatch(logicEo.getBatch());
                    }
                    if (compareVal >= 0) {
                        batchReqDto.setQuantity(changeInventory);
                        detailReqDto.setQuantity(changeInventory);
                        continue block1;
                    }
                    batchReqDto.setQuantity(available);
                    changeInventory = subtract.abs();
                    if (count > 1) {
                        itemDetailList.add(batchReqDto);
                    }
                    ++count;
                }
            }
            if (!CollectionUtils.isNotEmpty(itemDetailList)) continue;
            easTransferOrderReqDto.getItemDetailList().addAll(itemDetailList);
        }
    }

    private CsTransferOrderEo validTransferOrder(EasTransferOrderReqDto easTransferOrderReqDto) {
        CsTransferOrderEo csTransferOrderEo = new CsTransferOrderEo();
        CubeBeanUtils.copyProperties((Object)csTransferOrderEo, (Object)easTransferOrderReqDto, (String[])new String[0]);
        csTransferOrderEo.setAddress(easTransferOrderReqDto.getDetailAddress());
        CsPcpBusinessTypeEnum typeEnum = CsPcpBusinessTypeEnum.getByCode((String)easTransferOrderReqDto.getAllotType());
        AssertUtil.isTrue(Objects.nonNull(typeEnum), "\u8c03\u62e8\u5355\u7c7b\u578b\u4e0d\u5b58\u5728");
        if (!CsPcpBusinessTypeEnum.ALLOT_LOSE_EFFICACY.getCode().equals(typeEnum.getCode())) {
            AssertUtil.isTrue(StringUtils.isNotEmpty((CharSequence)easTransferOrderReqDto.getPlatformOrderNo()), "\u5e73\u53f0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            List transferOrderEoList = ((ExtQueryChainWrapper)this.csTransferOrderDas.filter().eq((Object)"pre_order_no", (Object)easTransferOrderReqDto.getPlatformOrderNo())).list();
            if (CollectionUtils.isNotEmpty((Collection)transferOrderEoList)) {
                List transferOrderEoList1 = transferOrderEoList.stream().filter(obj -> !CsTransferOrderEnum.Status.CANCELED.getCode().equals(obj.getOrderStatus())).collect(Collectors.toList());
                AssertUtil.isTrue(CollectionUtils.isEmpty(transferOrderEoList1), "\u8c03\u62e8\u5355\u5df2\u5b58\u5728");
            }
        }
        String outWarehouseCode = easTransferOrderReqDto.getOutWarehouseCode();
        String inWarehouseCode = easTransferOrderReqDto.getInWarehouseCode();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)outWarehouseCode) && StringUtils.isNotBlank((CharSequence)inWarehouseCode), "\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8865\u5168");
        this.validJoinWarehouse(easTransferOrderReqDto, csTransferOrderEo, outWarehouseCode, inWarehouseCode);
        return csTransferOrderEo;
    }

    private void validJoinWarehouse(EasTransferOrderReqDto easTransferOrderReqDto, CsTransferOrderEo csTransferOrderEo, String outWarehouseCode, String inWarehouseCode) {
        String subType = easTransferOrderReqDto.getAllotType();
        String outWarehouseQuality = null;
        String inWarehouseQuality = null;
        if (StringUtils.isNotBlank((CharSequence)outWarehouseCode)) {
            LogicWarehouseEo outWarehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)outWarehouseCode)).one();
            if (ObjectUtil.isNotEmpty((Object)outWarehouse)) {
                csTransferOrderEo.setOutLogicWarehouseCode(outWarehouse.getWarehouseCode());
                csTransferOrderEo.setOutLogicWarehouseName(outWarehouse.getWarehouseName());
            } else {
                csTransferOrderEo.setOutLogicWarehouseCode(outWarehouseCode);
                csTransferOrderEo.setOutLogicWarehouseName(outWarehouseCode);
            }
            if (null == outWarehouse || null == outWarehouse.getId() || CsWarehouseTypeEnum.TCBJ_C.getCode().equals(outWarehouse.getWarehouseType())) {
                subType = CsPcpBusinessTypeEnum.ALLOT_IN_ONLY.getCode();
                csTransferOrderEo.setType(subType);
            } else {
                outWarehouseQuality = outWarehouse.getWarehouseQuality();
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"warehouse_code", (Object)outWarehouseCode);
                queryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
                queryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
                queryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
                queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
                RelWarehouseEo outPhysicWarehouse = (RelWarehouseEo)this.relWarehouseDomain.getMapper().selectOne((Wrapper)queryWrapper);
                AssertUtil.isTrue(Objects.nonNull(outPhysicWarehouse), inWarehouseCode + "\u5173\u8054\u7269\u7406\u4ed3\u4e0d\u5b58\u5728");
                csTransferOrderEo.setOutOrganization(outWarehouse.getOrganizationCode());
                csTransferOrderEo.setOutOrganizationId(outWarehouse.getOrganizationId());
                csTransferOrderEo.setOutPhysicsWarehouseCode(outPhysicWarehouse.getRefWarehouseCode());
                csTransferOrderEo.setOutPhysicsWarehouseName(outPhysicWarehouse.getRefWarehouseName());
                csTransferOrderEo.setOutOrganization(outWarehouse.getCargoEscheatageName());
                csTransferOrderEo.setOutOrganizationId(outWarehouse.getOrganizationId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)inWarehouseCode)) {
            LogicWarehouseEo intWarehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)inWarehouseCode)).one();
            if (ObjectUtil.isNotEmpty((Object)intWarehouse)) {
                csTransferOrderEo.setInLogicWarehouseCode(intWarehouse.getWarehouseCode());
                csTransferOrderEo.setInLogicWarehouseName(intWarehouse.getWarehouseName());
            } else {
                csTransferOrderEo.setInLogicWarehouseCode(inWarehouseCode);
                csTransferOrderEo.setInLogicWarehouseName(inWarehouseCode);
            }
            if (CsPcpBusinessTypeEnum.INTERNAL_EXPORT_DEAL.getCode().equals(subType)) {
                inWarehouseQuality = intWarehouse.getWarehouseQuality();
                csTransferOrderEo.setInOrganization(intWarehouse.getOrganizationCode());
                csTransferOrderEo.setInOrganization(intWarehouse.getCargoEscheatageName());
                csTransferOrderEo.setInOrganizationId(intWarehouse.getOrganizationId());
            } else if (null == intWarehouse || null == intWarehouse.getId() || CsWarehouseTypeEnum.TCBJ_C.getCode().equals(intWarehouse.getWarehouseType())) {
                subType = CsPcpBusinessTypeEnum.ALLOT_OUT_ONLY.getCode().equals(subType) ? CsPcpBusinessTypeEnum.ALLOT_ONLY_RECORD.getCode() : CsPcpBusinessTypeEnum.ALLOT_OUT_ONLY.getCode();
                csTransferOrderEo.setType(subType);
            } else {
                inWarehouseQuality = intWarehouse.getWarehouseQuality();
                AssertUtil.isTrue(Objects.nonNull(intWarehouse), inWarehouseCode + "\u4ed3\u5e93\u4e0d\u5b58\u5728");
                QueryWrapper queryWrapper2 = new QueryWrapper();
                queryWrapper2.eq((Object)"warehouse_code", (Object)inWarehouseCode);
                queryWrapper2.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
                queryWrapper2.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
                queryWrapper2.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
                queryWrapper2.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
                RelWarehouseEo inPhysicWarehouse = (RelWarehouseEo)this.relWarehouseDomain.getMapper().selectOne((Wrapper)queryWrapper2);
                AssertUtil.isTrue(Objects.nonNull(inPhysicWarehouse), inWarehouseCode + "\u5173\u8054\u7269\u7406\u4ed3\u4e0d\u5b58\u5728");
                csTransferOrderEo.setInOrganization(intWarehouse.getOrganizationCode());
                csTransferOrderEo.setInPhysicsWarehouseCode(inPhysicWarehouse.getRefWarehouseCode());
                csTransferOrderEo.setInPhysicsWarehouseName(inPhysicWarehouse.getRefWarehouseName());
                csTransferOrderEo.setInOrganization(intWarehouse.getCargoEscheatageName());
                csTransferOrderEo.setInOrganizationId(intWarehouse.getOrganizationId());
            }
            csTransferOrderEo.setSubType(subType);
        }
        if (CsLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode().equals(outWarehouseQuality) && CsLogicWarehouseQualityEnum.QUALIFIED.getCode().equals(inWarehouseQuality)) {
            AssertUtil.isTrue(CsPcpBusinessTypeEnum.INSPECTION_QUALIFIED.getCode().equals(easTransferOrderReqDto.getAllotType()) || CsPcpBusinessTypeEnum.IN_TRANSIT_TRANSFER.getCode().equals(easTransferOrderReqDto.getAllotType()), "\u5f85\u68c0\u4ed3\u4e0d\u80fd\u76f4\u63a5\u8c03\u5165\u5408\u683c\u4ed3");
        }
        logger.info("\u6839\u636e\u4ed3\u5e93\u8bb0\u5f55\uff0c\u5224\u65ad\u8c03\u6574\u5355\u5b50\u7c7b\u578b\u5b8c:{}", (Object)JSON.toJSONString((Object)csTransferOrderEo));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long easInsiderTradeTransferOrder(EasTransferOrderReqDto easTransferOrderDetailReqDto) {
        logger.info("easInsiderTradeTransferOrder\u5185\u90e8\u4ea4\u6613\u65b0\u589e/\u8ffd\u52a0\u8c03\u62e8\u5355\u53c2\u6570:{}", (Object)LogUtils.buildLogContent(easTransferOrderDetailReqDto));
        CsTransferOrderEo transferOrderEo = this.validParam(easTransferOrderDetailReqDto);
        this.addInsiderTradeCsTransferOrder(transferOrderEo, easTransferOrderDetailReqDto);
        this.updateInsiderTradeCsTransferOrder(transferOrderEo, easTransferOrderDetailReqDto);
        return transferOrderEo.getId();
    }

    @Override
    public void modifyCsTransferOrderExtension(CsTransferOrderReqDto csTransferOrderReqDto) {
        logger.info("\u8ffd\u52a0\u8c03\u62e8\u5355\u6269\u5c55\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)csTransferOrderReqDto));
        CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)this.csTransferOrderDas.selectByPrimaryKey(csTransferOrderReqDto.getId());
        csTransferOrderEo.setPreOrderNo(csTransferOrderReqDto.getPreOrderNo());
        if (ObjectUtil.isNotEmpty((Object)csTransferOrderEo) && StringUtils.isNotBlank((CharSequence)csTransferOrderReqDto.getExtension())) {
            String extensionData = csTransferOrderEo.getExtension();
            if (StringUtils.isBlank((CharSequence)extensionData)) {
                csTransferOrderEo.setExtension(csTransferOrderReqDto.getExtension());
            } else {
                Map map = (Map)JSON.parseObject((String)extensionData, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
                Map extensionMap = (Map)JSON.parseObject((String)csTransferOrderReqDto.getExtension(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
                map.putAll(extensionMap);
                csTransferOrderEo.setExtension(JSON.toJSONString((Object)map));
            }
            logger.info("\u8ffd\u52a0\u66f4\u65b0\uff1a{}", (Object)JSON.toJSONString((Object)csTransferOrderEo));
            this.csTransferOrderDas.updateSelective((BaseEo)csTransferOrderEo);
        }
    }

    @Override
    public List<CsTransferOrderRespDto> queryTransferOrderList(CsTransferOrderReqDto reqDto) {
        if (ObjectUtil.isEmpty((Object)reqDto)) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        logger.info("\u67e5\u8be2\u8c03\u62e8\u5355\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (StringUtils.isBlank((CharSequence)reqDto.getTransferOrderNo()) && StringUtils.isBlank((CharSequence)reqDto.getPreOrderNo()) && StringUtils.isBlank((CharSequence)reqDto.getSaleOrderNo())) {
            throw new BizException("-1", "\u8c03\u62e8\u5355\u53f7\u3001\u5916\u90e8\u5355\u53f7\u3001\u5185\u90e8\u5355\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        CsTransferOrderEo eo = new CsTransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
        QueryWrapper queryWrapper = new QueryWrapper((Object)eo);
        queryWrapper.eq((Object)"dr", (Object)0);
        List csTransferOrderEos = this.csTransferOrderMapper.selectList((Wrapper)queryWrapper);
        ArrayList<CsTransferOrderRespDto> list = new ArrayList<CsTransferOrderRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)csTransferOrderEos)) {
            DtoHelper.eoList2DtoList((Collection)csTransferOrderEos, list, CsTransferOrderRespDto.class);
        }
        return list;
    }

    @Override
    public List<TranferOrderCountRespDto> transferOrderCount(CsTransferOrderQueryDto queryDto) {
        if (StringUtils.isNotBlank((CharSequence)queryDto.getTransferOrderNo()) && queryDto.getTransferOrderNo().contains(",")) {
            queryDto.setTransferOrderNoList(Arrays.asList(queryDto.getTransferOrderNo().split(",")));
            queryDto.setTransferOrderNo("");
        }
        List tranferOrderCountRespDtos = this.csTransferOrderDetailDas.tranferOrderCount(queryDto);
        return tranferOrderCountRespDtos;
    }

    @Override
    public Boolean linkageUpdateRequisitionOrder(CsTransferOrderReqDto transferOrderReqDto, String updateTransferStatus, Integer requisitionOrderStatus) {
        logger.info("\u66f4\u65b0\u95e8\u5e97\u8981\u8d27\u72b6\u6001:\u3010{}\u3011\uff0c\u8981\u66f4\u65b0\u8c03\u62e8\u5355\u72b6\u6001updateTransferStatus\uff1a{}\uff0c\u8981\u66f4\u65b0\u7684\u95e8\u5e97\u8981\u8d27\u5355\u72b6\u6001requisitionOrderStatus\uff1a{}", new Object[]{JSON.toJSONString((Object)transferOrderReqDto), updateTransferStatus, requisitionOrderStatus});
        if (Objects.isNull(transferOrderReqDto) || StringUtils.isBlank((CharSequence)transferOrderReqDto.getRequisitionOrderNo()) || !CsTransferOrderEnum.Status.CANCELED.getCode().equals(updateTransferStatus) && !CsTransferOrderEnum.Status.CLOSED.getCode().equals(updateTransferStatus) && !CsTransferOrderEnum.Status.FINISH.getCode().equals(updateTransferStatus) || Objects.isNull(requisitionOrderStatus)) {
            logger.info("\u5165\u53c2\u6709\u8bef\uff0c\u76f4\u63a5\u8fd4\u56de");
            return true;
        }
        List transferOrderReqDtos = ((ExtQueryChainWrapper)this.csTransferOrderDas.filter().eq((Object)"requisition_order_no", (Object)transferOrderReqDto.getRequisitionOrderNo())).list();
        logger.info("\u6839\u636e\u95e8\u5e97\u8981\u8d27\u5355\u53f7\u67e5\u8be2\u8c03\u62e8\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)transferOrderReqDtos));
        Set transferOrderStatusSet = transferOrderReqDtos.stream().filter(e -> !e.getTransferOrderNo().equals(transferOrderReqDto.getTransferOrderNo())).map(e -> e.getOrderStatus()).collect(Collectors.toSet());
        logger.info("transferOrderStatusSet:{}", (Object)JSON.toJSONString(transferOrderStatusSet));
        String transferOrderStatus = null;
        if (CsShopEnquiryApplyStatusExtEnum.CANCEL.getType().equals(requisitionOrderStatus)) {
            transferOrderStatus = CsTransferOrderEnum.Status.CANCELED.getCode();
        }
        if (CsShopEnquiryApplyStatusExtEnum.COMPLETE.getType().equals(requisitionOrderStatus)) {
            transferOrderStatus = CsTransferOrderEnum.Status.FINISH.getCode();
        }
        logger.info("\u95e8\u5e97\u8981\u8d27\u5355\u8981\u66f4\u65b0\u7684\u72b6\u6001requisitionOrderStatus:{} \u8c03\u62e8\u5355\u72b6\u6001transferOrderStatus:{}", (Object)CsShopEnquiryApplyStatusExtEnum.getDescByStatus((Integer)requisitionOrderStatus), (Object)transferOrderStatus);
        if (transferOrderStatusSet.size() > 1 || CollectionUtils.isNotEmpty(transferOrderStatusSet) && !transferOrderStatusSet.contains(transferOrderStatus)) {
            logger.info("\u95e8\u5e97\u8981\u8d27\u5355\u5bf9\u5e94\u7684\u8c03\u62e8\u5355\u6709\u591a\u79cd\u72b6\u6001\u6216\u8c03\u62e8\u5355\u72b6\u6001\u548c\u672c\u6b21\u66f4\u65b0\u7684\u72b6\u6001\u4e0d\u4e00\u81f4\uff0c\u4e0d\u8054\u52a8\u66f4\u65b0\u95e8\u5e97\u8981\u8d27\u5355\u72b6\u6001");
            return false;
        }
        CsShopEnquiryApplyQueryReqDto param = new CsShopEnquiryApplyQueryReqDto();
        param.setRequisitionOrderNo(transferOrderReqDto.getRequisitionOrderNo());
        CsShopEnquiryApplyExtRespDto respDto = this.csShopEnquiryApplyExtService.queryByParam(param);
        logger.info("\u95e8\u5e97\u8981\u8d27\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
        if (Objects.isNull(respDto)) {
            return false;
        }
        if (CsShopEnquiryApplyStatusExtEnum.CANCEL.getType().equals(requisitionOrderStatus)) {
            this.csShopEnquiryApplyExtService.cancel(respDto.getId(), "\u8c03\u62e8\u5355\u53d6\u6d88\u8054\u52a8\u95e8\u5e97\u8981\u8d27\u5355\u53d6\u6d88");
        } else {
            CsShopEnquiryApplyUpdateReqDto csShopEnquiryApplyUpdateReqDto = new CsShopEnquiryApplyUpdateReqDto();
            csShopEnquiryApplyUpdateReqDto.setRequisitionOrderNo(transferOrderReqDto.getRequisitionOrderNo());
            csShopEnquiryApplyUpdateReqDto.setStatus(requisitionOrderStatus);
            this.csShopEnquiryApplyExtService.updateStatus(csShopEnquiryApplyUpdateReqDto);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CsTransferOrderEo dispatcherTransferOrder(String transferOrderNo) {
        if (!InventoryConfig.isDispatchOrderEnable()) {
            return null;
        }
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)transferOrderNo), "\u8c03\u62e8\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CsTransferOrderEo transferOrderEo = (CsTransferOrderEo)((ExtQueryChainWrapper)this.csTransferOrderDas.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).one();
        AssertUtil.isTrue(null != transferOrderEo, "\u5355\u53f7" + transferOrderNo + "\u4e0d\u5b58\u5728!");
        logger.info("\u8fdb\u884c\u6536\u53d1\u5dee\u5f02\u5904\u7406\u7684\u6311\u62e8\u5355\u8be6\u60c5\u662f:{}", (Object)JSON.toJSONString((Object)transferOrderEo));
        AssertUtil.isTrue(CsTransferOrderEnum.Status.FINISH.getCode().equals(transferOrderEo.getOrderStatus()), "\u8c03\u62e8\u5355\u53ea\u6709\u5df2\u5b8c\u6210\u624d\u53ef\u4ee5\u8ba1\u7b97\u5dee\u5f02\uff01");
        if (StringUtils.isNotBlank((CharSequence)transferOrderEo.getDispatcherHandleStatus())) {
            return transferOrderEo;
        }
        List csTransferOrderDetailEos = this.csTransferOrderDetailDas.queryByTransferOrderNo(transferOrderNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csTransferOrderDetailEos), "\u8c03\u62e8\u5355\u8be6\u60c5\u4e3a\u7a7a");
        InOutResultOrderDetailEo outResultOrderDetailEo = new InOutResultOrderDetailEo();
        outResultOrderDetailEo.setRelevanceNo(transferOrderNo);
        List csOutNoticeOrderDetailEos = this.inOutNoticeOrderDetailDomain.queryCsOutNoticeOrderDetailList(outResultOrderDetailEo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csOutNoticeOrderDetailEos), "\u5165\u5e93\u901a\u77e5\u5355\u8be6\u60c5\u4e3a\u7a7a");
        InOutResultOrderEo outResultOrderEo = new InOutResultOrderEo();
        outResultOrderEo.setRelevanceNo(transferOrderNo);
        outResultOrderEo.setDispatcherStatus(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
        List csOutResultOrderDetailEos = this.inOutResultOrderDetailDomain.queryCsOutResultOrderDetailList(outResultOrderEo);
        this.dispatcher(transferOrderEo, csTransferOrderDetailEos, csOutNoticeOrderDetailEos, csOutResultOrderDetailEos);
        logger.info("\u5224\u65ad\u662f\u5426\u81ea\u52a8\u751f\u6210\u6536\u53d1\u5dee\u5f02\u5355\u7684dict");
        if (CsTransferDispatcherStatusEnum.NO_DISPATCHER.getCode().equals(transferOrderEo.getDispatcherStatus())) {
            return transferOrderEo;
        }
        DictDto dictDto = this.pcpDictApiProxy.queryByGroupCodeAndCode("COMMON_CONFIG", "AUTO_CREATE_DISPATCHER");
        logger.info("\u5224\u65ad\u662f\u5426\u81ea\u52a8\u751f\u6210\u6536\u53d1\u5dee\u5f02\u5355\u7684dict:{}", (Object)JSON.toJSONString((Object)dictDto));
        if (null != dictDto && "0".equals(dictDto.getValue())) {
            try {
                this.dispatcherOrderService.calculateDifferencesDispatcher(transferOrderNo);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u81ea\u52a8\u751f\u6210\u5dee\u5f02\u5355\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            logger.info("\u6536\u53d1\u5dee\u5f02\u5904\u7406\u5b8c\u6210");
        }
        return transferOrderEo;
    }

    private void dispatcher(CsTransferOrderEo transferOrderEo, List<CsTransferOrderDetailEo> csTransferOrderDetailEos, List<InOutNoticeOrderDetailEo> csOutNoticeOrderDetailEos, List<InOutResultOrderDetailEo> csOutResultOrderDetailEos) {
        transferOrderEo.setReceivelessQuantity(BigDecimal.ZERO);
        transferOrderEo.setOverchargeQuantity(BigDecimal.ZERO);
        Map transferOrderDetailEoMap = csTransferOrderDetailEos.stream().collect(Collectors.toMap(a -> a.getLongCode() + "_" + (InventoryConfig.isNoneBatch() ? "" : a.getBatch()), Function.identity(), (key1, key2) -> key2));
        Map transferOrderDetailEoItemMap = csTransferOrderDetailEos.stream().collect(Collectors.toMap(CsTransferOrderDetailEo::getLongCode, Function.identity(), (key1, key2) -> key2));
        Map outNoticeOrderDetailEoMap = csOutNoticeOrderDetailEos.stream().collect(Collectors.toMap(a -> a.getSkuCode() + "_" + (InventoryConfig.isNoneBatch() ? "" : a.getBatch()), Function.identity(), (key1, key2) -> key2));
        if (CollectionUtils.isEmpty(csOutResultOrderDetailEos)) {
            csOutResultOrderDetailEos = new ArrayList<InOutResultOrderDetailEo>();
        }
        Map outResultOrderDetailEoMap = csOutResultOrderDetailEos.stream().collect(Collectors.toMap(a -> a.getSkuCode() + "_" + (InventoryConfig.isNoneBatch() ? "" : a.getBatch()), Function.identity(), (key1, key2) -> key2));
        logger.info("\u5f00\u59cb\u8ba1\u7b97\u8c03\u62e8\u5355\u7684\u5dee\u5f02\u503ccsTransferOrderDetailEos1111:{}", (Object)JSON.toJSONString(csTransferOrderDetailEos));
        if (CollectionUtils.isNotEmpty(csOutResultOrderDetailEos)) {
            csOutResultOrderDetailEos.forEach(dto -> {
                String key = dto.getSkuCode() + "_" + (InventoryConfig.isNoneBatch() ? "" : dto.getBatch());
                if (!transferOrderDetailEoMap.containsKey(key)) {
                    AssertUtil.isTrue(transferOrderDetailEoItemMap.containsKey(dto.getSkuCode()), "\u8c03\u62e8\u5355\u660e\u7ec6\u4e2d\u6ca1\u6709\u8be5\u7269\u6599" + dto.getSkuCode());
                    CsTransferOrderDetailEo eo = new CsTransferOrderDetailEo();
                    BeanUtils.copyProperties(transferOrderDetailEoItemMap.get(dto.getSkuCode()), (Object)eo);
                    eo.setId(null);
                    eo.setDispatcherStatus(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                    eo.setDispatcherQuantity(dto.getDoneQuantity());
                    eo.setQuantity(BigDecimal.ZERO);
                    eo.setBatch(InventoryConfig.isNoneBatch() ? "" : dto.getBatch());
                    eo.setCreateTime(new Date());
                    eo.setUpdateTime(new Date());
                    logger.info("\u8c03\u62e8\u5355{},\u65b0\u589e\u660e\u7ec6\u884c\uff1a{}", (Object)eo.getTransferOrderNo(), (Object)JSON.toJSONString((Object)eo));
                    logger.info("\u8c03\u62e8\u5355{},dto\uff1a{}", (Object)eo.getTransferOrderNo(), (Object)JSON.toJSONString((Object)dto));
                    transferOrderEo.setOverchargeQuantity(transferOrderEo.getOverchargeQuantity().add(eo.getDispatcherQuantity()));
                    this.csTransferOrderDetailDas.insert((BaseEo)eo);
                }
            });
        }
        logger.info("\u5f00\u59cb\u8ba1\u7b97\u8c03\u62e8\u5355\u7684\u5dee\u5f02\u503ccsTransferOrderDetailEos2222:{}", (Object)JSON.toJSONString(csTransferOrderDetailEos));
        csTransferOrderDetailEos.forEach(dto -> {
            logger.info("\u5f00\u59cb\u8ba1\u7b97\u8c03\u62e8\u5355\u7684\u5dee\u5f02\u503cdto:{}", (Object)JSON.toJSONString((Object)dto));
            logger.info("\u5f00\u59cb\u8ba1\u7b97\u8c03\u62e8\u5355\u7684\u5dee\u5f02\u503coutNoticeOrderDetailEoMap:{}", (Object)JSON.toJSONString((Object)outNoticeOrderDetailEoMap));
            logger.info("\u5f00\u59cb\u8ba1\u7b97\u8c03\u62e8\u5355\u7684\u5dee\u5f02\u503coutResultOrderDetailEoMap:{}", (Object)JSON.toJSONString((Object)outResultOrderDetailEoMap));
            String key = dto.getLongCode() + "_" + (InventoryConfig.isNoneBatch() ? "" : dto.getBatch());
            logger.info("\u5f00\u59cb\u8ba1\u7b97\u8c03\u62e8\u5355\u7684\u5dee\u5f02\u503ckey:{}", (Object)key);
            if (outNoticeOrderDetailEoMap.containsKey(key)) {
                InOutNoticeOrderDetailEo csOutNoticeOrderDetailEo = (InOutNoticeOrderDetailEo)outNoticeOrderDetailEoMap.get(key);
                if (outResultOrderDetailEoMap.containsKey(key)) {
                    InOutResultOrderDetailEo outResultOrderDetailEo = (InOutResultOrderDetailEo)outResultOrderDetailEoMap.get(key);
                    BigDecimal subtract = outResultOrderDetailEo.getDoneQuantity().subtract(csOutNoticeOrderDetailEo.getPlanQuantity());
                    dto.setDispatcherStatus(this.getDispatcherStatus((null == dto.getDispatcherQuantity() ? BigDecimal.ZERO : dto.getDispatcherQuantity()).add(subtract)));
                    dto.setDispatcherQuantity((null == dto.getDispatcherQuantity() ? BigDecimal.ZERO : dto.getDispatcherQuantity()).add(subtract).abs());
                    if (CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode().equals(dto.getDispatcherStatus())) {
                        transferOrderEo.setOverchargeQuantity(transferOrderEo.getOverchargeQuantity().add(subtract));
                    } else {
                        transferOrderEo.setReceivelessQuantity(transferOrderEo.getReceivelessQuantity().add(subtract.abs()));
                    }
                    this.csTransferOrderDetailDas.updateTransferOrderDetailDispatcher(dto);
                } else {
                    logger.info("key:{},\u8d70\u4e86\u5c11\u6536", (Object)key);
                    dto.setDispatcherStatus(this.getDispatcherStatus((null == dto.getDispatcherQuantity() ? BigDecimal.ZERO : dto.getDispatcherQuantity()).subtract(csOutNoticeOrderDetailEo.getPlanQuantity())));
                    dto.setDispatcherQuantity((null == dto.getDispatcherQuantity() ? BigDecimal.ZERO : dto.getDispatcherQuantity()).subtract(csOutNoticeOrderDetailEo.getPlanQuantity()).abs());
                    transferOrderEo.setReceivelessQuantity(transferOrderEo.getReceivelessQuantity().add(csOutNoticeOrderDetailEo.getPlanQuantity()));
                    this.csTransferOrderDetailDas.updateTransferOrderDetailDispatcher(dto);
                }
            }
        });
        transferOrderEo.setDispatcherStatus(this.getDispatcherStatus(transferOrderEo.getOverchargeQuantity(), transferOrderEo.getReceivelessQuantity()));
        transferOrderEo.setDispatcherHandleStatus(CsTransferDispatcherStatusEnum.NO_DISPATCHER.getCode().equals(transferOrderEo.getDispatcherStatus()) ? CsTransferDispatcherHandleStatusEnum.NO_DISPATCHER.getCode() : CsTransferDispatcherHandleStatusEnum.WAIT_CREATE.getCode());
        logger.info("\u66f4\u65b0\u8c03\u62e8\u4e3b\u5355\u4fe1\u606f\u4e3a:{}", (Object)JSON.toJSONString((Object)transferOrderEo));
        this.csTransferOrderDas.updateTransferOrderDispatcher(transferOrderEo);
    }

    private String getDispatcherStatus(BigDecimal overchargeQuantity, BigDecimal receivelessQuantity) {
        overchargeQuantity = null == overchargeQuantity ? BigDecimal.ZERO : overchargeQuantity;
        BigDecimal bigDecimal = receivelessQuantity = null == receivelessQuantity ? BigDecimal.ZERO : receivelessQuantity;
        if (overchargeQuantity.compareTo(BigDecimal.ZERO) != 0 && receivelessQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return CsTransferDispatcherStatusEnum.DISPATCHER.getCode();
        }
        if (overchargeQuantity.compareTo(BigDecimal.ZERO) == 0 && receivelessQuantity.compareTo(BigDecimal.ZERO) == 0) {
            return CsTransferDispatcherStatusEnum.NO_DISPATCHER.getCode();
        }
        if (overchargeQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode();
        }
        if (receivelessQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode();
        }
        return null;
    }

    private String getDispatcherStatus(BigDecimal dispatcherQuantity) {
        BigDecimal bigDecimal = dispatcherQuantity = null == dispatcherQuantity ? BigDecimal.ZERO : dispatcherQuantity;
        if (dispatcherQuantity.compareTo(BigDecimal.ZERO) > 0) {
            return CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode();
        }
        if (dispatcherQuantity.compareTo(BigDecimal.ZERO) == 0) {
            return CsTransferDispatcherStatusEnum.NO_DISPATCHER.getCode();
        }
        if (dispatcherQuantity.compareTo(BigDecimal.ZERO) < 0) {
            return CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode();
        }
        return null;
    }

    @Override
    public void modifyTranferOrder(CsTransferOrderRespDto csTransferOrderRespDto) {
        CsTransferOrderEo csTransferOrderEo = new CsTransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)csTransferOrderRespDto, (BaseEo)csTransferOrderEo);
        if (csTransferOrderRespDto.getId() != null) {
            CsTransferOrderEo eo = (CsTransferOrderEo)this.csTransferOrderDas.selectByPrimaryKey(csTransferOrderRespDto.getId());
            if (eo == null) {
                throw new BizException("\u8be5id\u4e0d\u5b58\u5728");
            }
            this.csTransferOrderDas.updateSelective((BaseEo)csTransferOrderEo);
        }
    }

    @Override
    public void refreshInBelongOrganization() {
        logger.info("\u5237\u65b0\u5185\u90e8\u4ea4\u6613\u8c03\u62e8\u5355\u8c03\u5165\u5f52\u5c5e\u7ec4\u7ec7");
        ArrayList types = Lists.newArrayList((Object[])new String[]{CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode(), CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL.getCode(), CsPcpBusinessTypeEnum.INTERNAL_ALLOT.getCode(), CsPcpBusinessTypeEnum.ROUTE_INTERNAL_ALLOT.getCode(), CsPcpBusinessTypeEnum.INTERNAL_EXPORT_DEAL.getCode(), CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN.getCode(), CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL.getCode(), CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN_BA.getCode(), CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL_BA.getCode(), CsPcpBusinessTypeEnum.INTERNAL_DEAL_BA.getCode(), CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL_BA.getCode()});
        List transferOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.csTransferOrderDas.filter().in((Object)"type", (Collection)types)).isNull((Object)"in_belong_organization_name")).isNotNull((Object)"in_logic_warehouse_code")).list();
        if (CollectionUtils.isEmpty((Collection)transferOrderEoList)) {
            logger.info("\u65e0\u5355\u636e\u9700\u8981\u5904\u7406");
            return;
        }
        List inLogicWarehouseCodeList = transferOrderEoList.stream().map(CsTransferOrderEo::getInLogicWarehouseCode).distinct().collect(Collectors.toList());
        List logicWarehouseEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", inLogicWarehouseCodeList)).isNotNull((Object)"cost_org")).isNotNull((Object)"cost_org_name")).list();
        if (CollectionUtils.isEmpty((Collection)logicWarehouseEoList)) {
            logger.info("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u903b\u8f91\u4ed3\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(inLogicWarehouseCodeList));
            return;
        }
        Map logicWarehouseEoMap = logicWarehouseEoList.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        transferOrderEoList.forEach(transferOrderEo -> {
            LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)logicWarehouseEoMap.get(transferOrderEo.getInLogicWarehouseCode());
            if (ObjectUtil.isNotEmpty((Object)logicWarehouseEo)) {
                CsTransferOrderEo updateEo = new CsTransferOrderEo();
                updateEo.setId(transferOrderEo.getId());
                updateEo.setInBelongOrganizationCode(logicWarehouseEo.getCostOrg());
                updateEo.setInBelongOrganizationName(logicWarehouseEo.getCostOrgName());
                this.csTransferOrderDas.updateSelective((BaseEo)updateEo);
            }
        });
    }

    @Override
    public void refreshOutBelongOrganization() {
        logger.info("\u5237\u65b0\u5185\u90e8\u4ea4\u6613\u8c03\u62e8\u5355\u8c03\u51fa\u5f52\u5c5e\u7ec4\u7ec7");
        ArrayList types = Lists.newArrayList((Object[])new String[]{CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode(), CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL.getCode(), CsPcpBusinessTypeEnum.INTERNAL_ALLOT.getCode(), CsPcpBusinessTypeEnum.ROUTE_INTERNAL_ALLOT.getCode(), CsPcpBusinessTypeEnum.INTERNAL_EXPORT_DEAL.getCode(), CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN.getCode(), CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL.getCode(), CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN_BA.getCode(), CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL_BA.getCode(), CsPcpBusinessTypeEnum.INTERNAL_DEAL_BA.getCode(), CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL_BA.getCode()});
        List transferOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.csTransferOrderDas.filter().in((Object)"type", (Collection)types)).isNull((Object)"out_belong_organization_name")).isNotNull((Object)"out_logic_warehouse_code")).list();
        if (CollectionUtils.isEmpty((Collection)transferOrderEoList)) {
            logger.info("\u65e0\u5355\u636e\u9700\u8981\u5904\u7406");
            return;
        }
        List outLogicWarehouseCodeList = transferOrderEoList.stream().map(CsTransferOrderEo::getOutLogicWarehouseCode).distinct().collect(Collectors.toList());
        List logicWarehouseEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", outLogicWarehouseCodeList)).isNotNull((Object)"cost_org")).isNotNull((Object)"cost_org_name")).list();
        if (CollectionUtils.isEmpty((Collection)logicWarehouseEoList)) {
            logger.info("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u903b\u8f91\u4ed3\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(outLogicWarehouseCodeList));
            return;
        }
        Map logicWarehouseEoMap = logicWarehouseEoList.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        transferOrderEoList.forEach(transferOrderEo -> {
            LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)logicWarehouseEoMap.get(transferOrderEo.getInLogicWarehouseCode());
            if (ObjectUtil.isNotEmpty((Object)logicWarehouseEo)) {
                CsTransferOrderEo updateEo = new CsTransferOrderEo();
                updateEo.setId(transferOrderEo.getId());
                updateEo.setOutBelongOrganizationCode(logicWarehouseEo.getCostOrg());
                updateEo.setOutBelongOrganizationName(logicWarehouseEo.getCostOrgName());
                this.csTransferOrderDas.updateSelective((BaseEo)updateEo);
            }
        });
    }

    private void addInsiderTradeCsTransferOrder(CsTransferOrderEo transferOrderEo, EasTransferOrderReqDto easTransferOrderReqDto) {
        if (null == transferOrderEo.getId()) {
            List detailList = easTransferOrderReqDto.getItemDetailList();
            ArrayList<CsTransferOrderDetailEo> detailEoList = new ArrayList<CsTransferOrderDetailEo>(detailList.size());
            List itemSet = detailList.stream().map(EasTransferOrderDetailReqDto::getLongCode).collect(Collectors.toList());
            List itemEoList = this.itemSkuProxy.queryBySkuCodes(itemSet);
            Map<String, ItemSkuDto> itemMap = itemEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, entity -> entity));
            detailList.forEach(d -> {
                AssertUtil.isTrue(d.getQuantity().compareTo(BigDecimal.ZERO) > 0, d.getLongCode() + "\u5546\u54c1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
                AssertUtil.isTrue(StringUtils.isNotEmpty((CharSequence)d.getBatch()), d.getLongCode() + "\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                CsTransferOrderDetailEo csTransferOrderDetailEo = new CsTransferOrderDetailEo();
                csTransferOrderDetailEo.setBatch(d.getBatch());
                csTransferOrderDetailEo.setQuantity(d.getQuantity());
                csTransferOrderDetailEo.setLongCode(d.getLongCode());
                ItemSkuDto csItemEo = (ItemSkuDto)itemMap.get(d.getLongCode());
                csTransferOrderDetailEo.setVolume(csItemEo.getVolume());
                csTransferOrderDetailEo.setExtension(d.getExtension());
                csTransferOrderDetailEo.setCargoName(csItemEo.getSkuName());
                detailEoList.add(csTransferOrderDetailEo);
            });
            transferOrderEo.setOrderStatus(CsTransferOrderEnum.Status.WAIT_AUDIT.getCode());
            String transferNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.TRANSFER_ORDER.getCode()).getCode();
            transferOrderEo.setTransferOrderNo(transferNo);
            BigDecimal totalQuantity = BigDecimal.ZERO;
            for (CsTransferOrderDetailEo csTransferOrderDetailEo : detailEoList) {
                csTransferOrderDetailEo.setTransferOrderNo(transferNo);
                totalQuantity = totalQuantity.add(csTransferOrderDetailEo.getQuantity());
            }
            transferOrderEo.setTotalQuantity(totalQuantity);
            transferOrderEo.setSourceSystem(easTransferOrderReqDto.getSourceSystem());
            transferOrderEo.setExtension(easTransferOrderReqDto.getExtension());
            this.csTransferOrderDas.insert((BaseEo)transferOrderEo);
            this.csTransferOrderDetailDas.insertBatch(detailEoList);
            easTransferOrderReqDto.setBusinessOrderNo(transferNo);
            if (StringUtils.isNotBlank((CharSequence)transferOrderEo.getOutLogicWarehouseCode())) {
                this.preemptInventory(detailEoList, transferOrderEo);
            }
            this.transactionCallBackService.execute(() -> {
                MessageVo messageVo = new MessageVo();
                CsTransferOrderRespDto respDto = new CsTransferOrderRespDto();
                BeanUtils.copyProperties((Object)transferOrderEo, (Object)respDto);
                messageVo.setData((Object)JSON.toJSONString((Object)respDto));
                this.commonsMqService.publishMessage("TRANSFER_CREATE", (Object)messageVo);
            });
        }
    }

    private void updateInsiderTradeCsTransferOrder(CsTransferOrderEo transferOrderEo, EasTransferOrderReqDto easTransferOrderDetailReqDto) {
        if (null != transferOrderEo.getId()) {
            transferOrderEo.setExternalSaleOrderNo(StringUtils.isNotBlank((CharSequence)easTransferOrderDetailReqDto.getExternalSaleOrderNo()) ? easTransferOrderDetailReqDto.getExternalSaleOrderNo() : transferOrderEo.getExternalSaleOrderNo());
            transferOrderEo.setExternalPurchaseOrderNo(StringUtils.isNotBlank((CharSequence)easTransferOrderDetailReqDto.getExternalPurchaseOrderNo()) ? easTransferOrderDetailReqDto.getExternalPurchaseOrderNo() : transferOrderEo.getExternalPurchaseOrderNo());
            this.csTransferOrderDas.update((BaseEo)transferOrderEo);
            easTransferOrderDetailReqDto.setBusinessOrderNo(transferOrderEo.getTransferOrderNo());
            if (StringUtils.isNotBlank((CharSequence)transferOrderEo.getOutLogicWarehouseCode()) && StringUtils.isNotBlank((CharSequence)transferOrderEo.getInLogicWarehouseCode())) {
                CsAuditReqDto auditReqDto = this.getCsAuditReqDto(easTransferOrderDetailReqDto);
                this.auditTransferOrder(auditReqDto);
            }
        }
    }

    private CsTransferOrderEo validParam(EasTransferOrderReqDto easTransferOrderDetailReqDto) {
        List transferOrderEoList1;
        CsTransferOrderEo csTransferOrderEo = new CsTransferOrderEo();
        CubeBeanUtils.copyProperties((Object)csTransferOrderEo, (Object)easTransferOrderDetailReqDto, (String[])new String[0]);
        AssertUtil.isTrue(StringUtils.isNotEmpty((CharSequence)easTransferOrderDetailReqDto.getPlatformOrderNo()), "\u5e73\u53f0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        CsPcpBusinessTypeEnum typeEnum = CsPcpBusinessTypeEnum.getByCode((String)easTransferOrderDetailReqDto.getAllotType());
        AssertUtil.isTrue(Objects.nonNull(typeEnum), "\u8c03\u62e8\u5355\u7c7b\u578b\u4e0d\u5b58\u5728");
        String outWarehouseCode = easTransferOrderDetailReqDto.getOutWarehouseCode();
        String inWarehouseCode = easTransferOrderDetailReqDto.getInWarehouseCode();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)outWarehouseCode) || StringUtils.isNotBlank((CharSequence)inWarehouseCode), "\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8865\u5168");
        List transferOrderEoList = ((ExtQueryChainWrapper)this.csTransferOrderDas.filter().eq((Object)"pre_order_no", (Object)easTransferOrderDetailReqDto.getPlatformOrderNo())).list();
        if (CollectionUtils.isNotEmpty((Collection)transferOrderEoList) && CollectionUtils.isNotEmpty(transferOrderEoList1 = transferOrderEoList.stream().filter(obj -> !CsTransferOrderEnum.Status.CANCELED.getCode().equals(obj.getOrderStatus())).collect(Collectors.toList()))) {
            csTransferOrderEo = (CsTransferOrderEo)transferOrderEoList1.get(0);
        }
        if (StringUtils.isNotBlank((CharSequence)outWarehouseCode)) {
            LogicWarehouseEo outWarehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)outWarehouseCode)).one();
            AssertUtil.isTrue(Objects.nonNull(outWarehouse), outWarehouseCode + "\u4ed3\u5e93\u4e0d\u5b58\u5728");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"warehouse_code", (Object)outWarehouseCode);
            queryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
            queryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
            queryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
            RelWarehouseEo outPhysicWarehouse = (RelWarehouseEo)this.relWarehouseDomain.getMapper().selectOne((Wrapper)queryWrapper);
            AssertUtil.isTrue(Objects.nonNull(outPhysicWarehouse), inWarehouseCode + "\u5173\u8054\u7269\u7406\u4ed3\u4e0d\u5b58\u5728");
            csTransferOrderEo.setOutLogicWarehouseCode(outWarehouse.getWarehouseCode());
            csTransferOrderEo.setOutLogicWarehouseName(outWarehouse.getWarehouseName());
            csTransferOrderEo.setOutOrganization(outWarehouse.getOrganizationCode());
            csTransferOrderEo.setOutOrganizationId(outWarehouse.getOrganizationId());
            csTransferOrderEo.setOutPhysicsWarehouseCode(outPhysicWarehouse.getRefWarehouseCode());
            csTransferOrderEo.setOutPhysicsWarehouseName(outPhysicWarehouse.getRefWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)inWarehouseCode)) {
            LogicWarehouseEo intWarehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)inWarehouseCode)).one();
            AssertUtil.isTrue(Objects.nonNull(intWarehouse), inWarehouseCode + "\u4ed3\u5e93\u4e0d\u5b58\u5728");
            QueryWrapper queryWrapper2 = new QueryWrapper();
            queryWrapper2.eq((Object)"warehouse_code", (Object)inWarehouseCode);
            queryWrapper2.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
            queryWrapper2.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
            queryWrapper2.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
            RelWarehouseEo inPhysicWarehouse = (RelWarehouseEo)this.relWarehouseDomain.getMapper().selectOne((Wrapper)queryWrapper2);
            AssertUtil.isTrue(Objects.nonNull(inPhysicWarehouse), inWarehouseCode + "\u5173\u8054\u7269\u7406\u4ed3\u4e0d\u5b58\u5728");
            csTransferOrderEo.setInLogicWarehouseCode(intWarehouse.getWarehouseCode());
            csTransferOrderEo.setInLogicWarehouseName(intWarehouse.getWarehouseName());
            csTransferOrderEo.setInOrganization(intWarehouse.getOrganizationCode());
            csTransferOrderEo.setInOrganizationId(intWarehouse.getOrganizationId());
            csTransferOrderEo.setInPhysicsWarehouseCode(inPhysicWarehouse.getRefWarehouseCode());
            csTransferOrderEo.setInPhysicsWarehouseName(inPhysicWarehouse.getRefWarehouseName());
        }
        return csTransferOrderEo;
    }

    private CsAuditReqDto getCsAuditReqDto(EasTransferOrderReqDto easTransferOrderDetailReqDto) {
        CsAuditReqDto auditReqDto = new CsAuditReqDto();
        auditReqDto.setBusinessOrderNo(easTransferOrderDetailReqDto.getBusinessOrderNo());
        auditReqDto.setAuditResult(CsOtherStorageOrderEnum.AuditEnum.AUDIT_PASS.getCode());
        return auditReqDto;
    }

    private Long covertParamAndInsert(EasTransferOrderReqDto easTransferOrderReqDto, CsTransferOrderEo insertEo) {
        List WarehouseAddressEos;
        List detailList = easTransferOrderReqDto.getItemDetailList();
        ArrayList<CsTransferOrderDetailEo> detailEoList = new ArrayList<CsTransferOrderDetailEo>(detailList.size());
        List itemSet = detailList.stream().map(EasTransferOrderDetailReqDto::getLongCode).collect(Collectors.toList());
        List itemEoList = this.itemSkuProxy.queryBySkuCodes(itemSet);
        Map<String, ItemSkuDto> itemMap = itemEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, entity -> entity));
        detailList.forEach(d -> {
            AssertUtil.isTrue(d.getQuantity().compareTo(BigDecimal.ZERO) > 0, d.getLongCode() + "\u5546\u54c1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            CsTransferOrderDetailEo csTransferOrderDetailEo = new CsTransferOrderDetailEo();
            csTransferOrderDetailEo.setBatch(d.getBatch());
            csTransferOrderDetailEo.setQuantity(d.getQuantity());
            csTransferOrderDetailEo.setLongCode(d.getLongCode());
            ItemSkuDto csItemEo = (ItemSkuDto)itemMap.get(d.getLongCode());
            csTransferOrderDetailEo.setCargoName(csItemEo.getSkuName());
            csTransferOrderDetailEo.setVolume(d.getVolume());
            ItemSkuDto pcpItemRespDto = new ItemSkuDto();
            if (ObjectUtil.isNotEmpty((Object)itemMap) && ObjectUtil.isNotEmpty(itemMap.get(d.getLongCode()))) {
                pcpItemRespDto = (ItemSkuDto)itemMap.get(d.getLongCode());
            }
            if (ObjectUtil.isNotEmpty((Object)pcpItemRespDto.getVolume())) {
                csTransferOrderDetailEo.setVolume(BigDecimalUtils.multiply((BigDecimal)csTransferOrderDetailEo.getQuantity(), (BigDecimal)pcpItemRespDto.getVolume()).setScale(4, RoundingMode.DOWN));
            }
            if (ObjectUtil.isNotEmpty((Object)pcpItemRespDto.getWeight())) {
                csTransferOrderDetailEo.setWeight(pcpItemRespDto.getWeight().multiply(csTransferOrderDetailEo.getQuantity()));
            }
            csTransferOrderDetailEo.setExtension(d.getExtension());
            csTransferOrderDetailEo.setProduceTime(d.getProduceTime());
            csTransferOrderDetailEo.setExpireTime(d.getExpireTime());
            detailEoList.add(csTransferOrderDetailEo);
        });
        insertEo.setNoBatch(StringUtils.isBlank((CharSequence)((CsTransferOrderDetailEo)detailEoList.get(0)).getBatch()) ? YesNoEnum.YES.getValue() : YesNoEnum.NO.getValue());
        insertEo.setOrderStatus(CsTransferOrderEnum.Status.WAIT_AUDIT.getCode());
        insertEo.setRemark(easTransferOrderReqDto.getRemark());
        insertEo.setType(StringUtils.isNotBlank((CharSequence)insertEo.getType()) ? insertEo.getType() : easTransferOrderReqDto.getAllotType());
        String transferNo = this.getBcOrCcTransferNo(insertEo);
        if (StringUtils.isBlank((CharSequence)transferNo)) {
            transferNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.TRANSFER_ORDER.getCode()).getCode();
        }
        insertEo.setTransferOrderNo(transferNo);
        insertEo.setPreOrderNo(easTransferOrderReqDto.getPlatformOrderNo());
        insertEo.setOrderSrc(easTransferOrderReqDto.getSourceSystem());
        BigDecimal totalQuantity = BigDecimal.ZERO;
        for (CsTransferOrderDetailEo csTransferOrderDetailEo : detailEoList) {
            csTransferOrderDetailEo.setTransferOrderNo(transferNo);
            totalQuantity = totalQuantity.add(csTransferOrderDetailEo.getQuantity());
        }
        insertEo.setTotalQuantity(totalQuantity);
        insertEo.setSourceSystem(easTransferOrderReqDto.getSourceSystem());
        insertEo.setExtension(easTransferOrderReqDto.getExtension());
        insertEo.setBizDate(easTransferOrderReqDto.getBizDate());
        try {
            this.analysisEasAddress(easTransferOrderReqDto, insertEo);
            logger.info("analysisEasAddress end: {}", (Object)LogUtils.buildLogContent(insertEo));
        }
        catch (Exception e) {
            logger.error("\u5206\u6790EAS \u4f20\u9012\u5730\u5740\u4fe1\u606f \u5931\u8d25: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        if (StringUtils.isBlank((CharSequence)insertEo.getProvinceCode()) && StringUtils.isNotBlank((CharSequence)insertEo.getInPhysicsWarehouseCode()) && CollectionUtils.isNotEmpty((Collection)(WarehouseAddressEos = this.warehouseAddressDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(WarehouseAddressEo.class).eq(WarehouseAddressEo::getWarehouseCode, (Object)insertEo.getInPhysicsWarehouseCode())).eq(WarehouseAddressEo::getValidFlag, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO))))) {
            WarehouseAddressEo inWarehouseAddressEo = (WarehouseAddressEo)WarehouseAddressEos.get(0);
            insertEo.setProvinceCode(inWarehouseAddressEo.getProvinceCode());
            insertEo.setProvince(inWarehouseAddressEo.getProvince());
            insertEo.setCityCode(inWarehouseAddressEo.getCityCode());
            insertEo.setCity(inWarehouseAddressEo.getCity());
            insertEo.setAreaCode(inWarehouseAddressEo.getDistrictCode());
            insertEo.setArea(inWarehouseAddressEo.getDistrict());
            insertEo.setAddress(inWarehouseAddressEo.getDetailAddress());
            insertEo.setContact(inWarehouseAddressEo.getContacts());
            insertEo.setContactPhone(inWarehouseAddressEo.getPhone());
        }
        this.csTransferOrderDas.insert((BaseEo)insertEo);
        this.csTransferOrderDetailDas.insertBatch(detailEoList);
        easTransferOrderReqDto.setBusinessOrderNo(transferNo);
        if (CsPcpBusinessTypeEnum.ALLOT_IN_ONLY.getCode().equals(insertEo.getSubType()) || CsPcpBusinessTypeEnum.ALLOT_ONLY_RECORD.getCode().equals(insertEo.getSubType())) {
            return insertEo.getId();
        }
        this.preemptInventory(detailEoList, insertEo);
        this.transactionCallBackService.execute(() -> {
            MessageVo messageVo = new MessageVo();
            CsTransferOrderRespDto respDto = new CsTransferOrderRespDto();
            BeanUtils.copyProperties((Object)insertEo, (Object)respDto);
            messageVo.setData((Object)JSON.toJSONString((Object)respDto));
            this.commonsMqService.publishMessage("TRANSFER_CREATE", (Object)messageVo);
        });
        return insertEo.getId();
    }

    private String getBcOrCcTransferNo(CsTransferOrderEo eo) {
        logger.info("CsTransferOrderEo: {}", (Object)LogUtils.buildLogContent(eo));
        AssertUtils.notBlank((String)eo.getInLogicWarehouseCode(), (String)"\u5165\u5e93\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
        AssertUtils.notBlank((String)eo.getOutLogicWarehouseCode(), (String)"\u51fa\u5e93\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
        ArrayList typeList = Lists.newArrayList((Object[])new String[]{CsPcpBusinessTypeEnum.BC_ALLOT.getCode(), CsPcpBusinessTypeEnum.CC_ALLOT.getCode(), CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode()});
        if (!typeList.contains(eo.getType())) {
            return "";
        }
        LogicWarehouseEo inLogicWarehouseEo = this.logicWarehouseDomain.queryByCode(eo.getInLogicWarehouseCode());
        AssertUtils.notNull((Object)inLogicWarehouseEo, (String)"\u5165\u5e93\u903b\u8f91\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        LogicWarehouseEo outLogicWarehouseEo = this.logicWarehouseDomain.queryByCode(eo.getOutLogicWarehouseCode());
        AssertUtils.notNull((Object)outLogicWarehouseEo, (String)"\u5165\u5e93\u903b\u8f91\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        logger.info("inLogicWarehouseEo: {}", (Object)LogUtils.buildLogContent(inLogicWarehouseEo));
        logger.info("outLogicWarehouseEo: {}", (Object)LogUtils.buildLogContent(outLogicWarehouseEo));
        if (Objects.equals(CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode(), eo.getType()) && StringUtils.isNotBlank((CharSequence)eo.getSaleOrderNo()) && StringUtils.isNotBlank((CharSequence)eo.getSecondTransferOrderNo())) {
            eo.setOutOrganizationCode(outLogicWarehouseEo.getOrganizationCode());
            eo.setOutOrganizationId(outLogicWarehouseEo.getOrganizationId());
            eo.setOutOrganization(outLogicWarehouseEo.getOrganizationName());
            eo.setInOrganization(inLogicWarehouseEo.getOrganizationCode());
            eo.setInOrganizationId(inLogicWarehouseEo.getOrganizationId());
            eo.setInOrganization(inLogicWarehouseEo.getOrganizationName());
        }
        if (StringUtils.equals((CharSequence)inLogicWarehouseEo.getOrganizationCode(), (CharSequence)outLogicWarehouseEo.getOrganizationCode())) {
            return "";
        }
        if (CsPcpBusinessTypeEnum.BC_ALLOT.getCode().equals(eo.getType()) || CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode().equals(eo.getType()) || CsPcpBusinessTypeEnum.BC_EQUAL_ALLOT.getCode().equals(eo.getType()) || CsPcpBusinessTypeEnum.CB_EQUAL_ALLOT.getCode().equals(eo.getType())) {
            return this.codeGenerateUtil.generateNo("BC", 6);
        }
        if (CsPcpBusinessTypeEnum.CC_ALLOT.getCode().equals(eo.getType())) {
            return this.codeGenerateUtil.generateNo("CC", 6);
        }
        return "";
    }

    private void analysisEasAddress(EasTransferOrderReqDto easTransferOrderReqDto, CsTransferOrderEo insertEo) {
        PcpRegionReqDto pcpRegionReqDto;
        AddressResolutionUtil.AddressDto addressDto;
        List pcpRegionRespDtos;
        PcpRegionReqDto pcpRegionReqDto2;
        PcpRegionRespDto pcpRegionRespDto;
        logger.info("analysisEasAddress: {}", (Object)LogUtils.buildLogContent(easTransferOrderReqDto));
        insertEo.setProvinceCode(null);
        insertEo.setProvince(null);
        insertEo.setCityCode(null);
        insertEo.setCity(null);
        insertEo.setAreaCode(null);
        insertEo.setArea(null);
        if (StringUtils.isNotBlank((CharSequence)easTransferOrderReqDto.getProvinceCode())) {
            pcpRegionRespDto = (PcpRegionRespDto)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByCode(easTransferOrderReqDto.getProvinceCode()));
            if (null != pcpRegionRespDto) {
                insertEo.setProvinceCode(pcpRegionRespDto.getCode());
                insertEo.setProvince(pcpRegionRespDto.getName());
            }
        } else if (StringUtils.isNotBlank((CharSequence)easTransferOrderReqDto.getProvince())) {
            pcpRegionReqDto2 = new PcpRegionReqDto();
            pcpRegionReqDto2.setName(easTransferOrderReqDto.getProvince());
            pcpRegionRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByList(pcpRegionReqDto2));
            if (CollectionUtils.isNotEmpty((Collection)pcpRegionRespDtos) && pcpRegionRespDtos.size() == 1) {
                PcpRegionRespDto provinceDto = (PcpRegionRespDto)pcpRegionRespDtos.get(0);
                insertEo.setProvince(provinceDto.getName());
                insertEo.setProvinceCode(provinceDto.getCode());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)easTransferOrderReqDto.getCityCode())) {
            pcpRegionRespDto = (PcpRegionRespDto)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByCode(easTransferOrderReqDto.getCityCode()));
            if (null != pcpRegionRespDto && StringUtils.equals((CharSequence)pcpRegionRespDto.getParentCode(), (CharSequence)insertEo.getProvinceCode())) {
                insertEo.setCityCode(pcpRegionRespDto.getCode());
                insertEo.setCity(pcpRegionRespDto.getName());
            }
        } else if (StringUtils.isNotBlank((CharSequence)easTransferOrderReqDto.getCity()) && StringUtils.isNotBlank((CharSequence)insertEo.getProvinceCode())) {
            insertEo.setCity(easTransferOrderReqDto.getCity());
            pcpRegionReqDto2 = new PcpRegionReqDto();
            pcpRegionReqDto2.setName(easTransferOrderReqDto.getCity());
            pcpRegionReqDto2.setParentCode(insertEo.getProvinceCode());
            pcpRegionRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByList(pcpRegionReqDto2));
            if (CollectionUtils.isNotEmpty((Collection)pcpRegionRespDtos) && pcpRegionRespDtos.size() == 1) {
                PcpRegionRespDto cityDto = (PcpRegionRespDto)pcpRegionRespDtos.get(0);
                insertEo.setCityCode(cityDto.getCode());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)easTransferOrderReqDto.getAreaCode())) {
            pcpRegionRespDto = (PcpRegionRespDto)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByCode(easTransferOrderReqDto.getAreaCode()));
            if (null != pcpRegionRespDto && StringUtils.equals((CharSequence)pcpRegionRespDto.getParentCode(), (CharSequence)insertEo.getCityCode())) {
                insertEo.setAreaCode(pcpRegionRespDto.getCode());
                insertEo.setArea(pcpRegionRespDto.getName());
            }
        } else if (StringUtils.isNotBlank((CharSequence)easTransferOrderReqDto.getArea()) && StringUtils.isNotBlank((CharSequence)insertEo.getCityCode())) {
            insertEo.setArea(easTransferOrderReqDto.getArea());
            pcpRegionReqDto2 = new PcpRegionReqDto();
            pcpRegionReqDto2.setName(easTransferOrderReqDto.getArea());
            pcpRegionReqDto2.setParentCode(insertEo.getCityCode());
            pcpRegionRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByList(pcpRegionReqDto2));
            if (CollectionUtils.isNotEmpty((Collection)pcpRegionRespDtos) && pcpRegionRespDtos.size() == 1) {
                PcpRegionRespDto areaDto = (PcpRegionRespDto)pcpRegionRespDtos.get(0);
                insertEo.setAreaCode(areaDto.getCode());
            }
        }
        logger.info("analysisEasAddress \u5206\u6790\u5b8c EAS \u4f20\u9012\u53c2\u6570\u540e \u5bf9\u8c61\u4fe1\u606f: {}", (Object)LogUtils.buildLogContent(insertEo));
        if (StringUtils.isBlank((CharSequence)insertEo.getProvinceCode()) && StringUtils.isBlank((CharSequence)insertEo.getCityCode()) && StringUtils.isBlank((CharSequence)insertEo.getAreaCode()) && StringUtils.isBlank((CharSequence)insertEo.getProvince()) && StringUtils.isBlank((CharSequence)insertEo.getCity()) && StringUtils.isBlank((CharSequence)insertEo.getArea()) && StringUtils.isNotBlank((CharSequence)easTransferOrderReqDto.getDetailAddress())) {
            logger.info("\u8fdb\u5165 \u7701\u5e02\u533a \u7a7a\u903b\u8f91 \u5339\u914d\u8be6\u7ec6\u5730\u5740\u903b\u8f91.......: {}", (Object)easTransferOrderReqDto.getDetailAddress());
            addressDto = AddressResolutionUtil.addressResolution((String)easTransferOrderReqDto.getDetailAddress());
            if (null == addressDto) {
                return;
            }
            insertEo.setProvince(addressDto.getProvince());
            insertEo.setCity(addressDto.getCity());
            insertEo.setArea(addressDto.getCounty());
            pcpRegionReqDto = new PcpRegionReqDto();
            pcpRegionReqDto.setNameList((List)Lists.newArrayList((Object[])new String[]{insertEo.getProvince(), insertEo.getCity(), insertEo.getArea()}));
            List pcpRegionRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByList(pcpRegionReqDto));
            if (CollectionUtils.isEmpty((Collection)pcpRegionRespDtoList)) {
                return;
            }
            Map<String, List<PcpRegionRespDto>> regionRespMap = pcpRegionRespDtoList.stream().collect(Collectors.groupingBy(PcpRegionRespDto::getName));
            List<PcpRegionRespDto> provinceList = regionRespMap.get(insertEo.getProvince());
            if (CollectionUtils.isEmpty(provinceList) && provinceList.size() > 1) {
                return;
            }
            insertEo.setProvinceCode(provinceList.get(0).getCode());
            List<PcpRegionRespDto> cityList = regionRespMap.get(insertEo.getCity());
            if (CollectionUtils.isEmpty(cityList)) {
                return;
            }
            PcpRegionRespDto cityDto = cityList.stream().filter(o -> StringUtils.equals((CharSequence)o.getParentCode(), (CharSequence)insertEo.getProvinceCode())).findFirst().orElse(null);
            if (null == cityDto) {
                return;
            }
            insertEo.setCityCode(cityDto.getCode());
            List<PcpRegionRespDto> areaList = regionRespMap.get(insertEo.getArea());
            if (CollectionUtils.isEmpty(areaList)) {
                return;
            }
            PcpRegionRespDto areaDto = areaList.stream().filter(o -> StringUtils.equals((CharSequence)o.getParentCode(), (CharSequence)insertEo.getCityCode())).findFirst().orElse(null);
            if (null == areaDto) {
                return;
            }
            insertEo.setAreaCode(areaDto.getCode());
        } else if (StringUtils.isNotBlank((CharSequence)insertEo.getProvinceCode()) && StringUtils.isNotBlank((CharSequence)insertEo.getCityCode()) && StringUtils.isBlank((CharSequence)insertEo.getAreaCode()) && StringUtils.isNotBlank((CharSequence)easTransferOrderReqDto.getDetailAddress())) {
            logger.info("\u8fdb\u5165 \u533a\u57df \u7a7a\u903b\u8f91 \u5339\u914d\u8be6\u7ec6\u5730\u5740\u903b\u8f91.......: {}", (Object)easTransferOrderReqDto.getDetailAddress());
            addressDto = AddressResolutionUtil.addressResolution((String)easTransferOrderReqDto.getDetailAddress());
            if (null == addressDto) {
                return;
            }
            insertEo.setArea(addressDto.getCounty());
            if (StringUtils.isBlank((CharSequence)insertEo.getArea())) {
                return;
            }
            pcpRegionReqDto = new PcpRegionReqDto();
            pcpRegionReqDto.setName(insertEo.getArea());
            pcpRegionReqDto.setParentCode(insertEo.getCityCode());
            List pcpRegionRespDtos2 = (List)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByList(pcpRegionReqDto));
            if (CollectionUtils.isNotEmpty((Collection)pcpRegionRespDtos2) && pcpRegionRespDtos2.size() == 1) {
                PcpRegionRespDto areaDto = (PcpRegionRespDto)pcpRegionRespDtos2.get(0);
                insertEo.setAreaCode(areaDto.getCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InventoryPreemptionEo> preemptInventoryByParam(List<CsTransferOrderDetailReqDto> detailList, CsTransferOrderReqDto reqDto) {
        List<String> skuCodes = detailList.stream().map(CsTransferOrderDetailReqDto::getLongCode).distinct().collect(Collectors.toList());
        LogicWarehouseEo logicWarehouseEo = this.logicWarehouseDomain.queryByCode(reqDto.getOutLogicWarehouseCode());
        AssertUtils.notNull((Object)logicWarehouseEo, (String)"\u903b\u8f91\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        PreemptDto preemptParam = new PreemptDto();
        preemptParam.setSourceNo(reqDto.getTransferOrderNo());
        preemptParam.setSourceType(reqDto.getType());
        preemptParam.setBusinessType(reqDto.getType());
        preemptParam.setExternalOrderNo(reqDto.getPreOrderNo());
        preemptParam.setValidNegative(reqDto.getValidNegative());
        preemptParam.setNoneLineNo(Boolean.valueOf(true));
        if (CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(reqDto.getType()) || CsPcpBusinessTypeEnum.ALLOT_SALE_BH.getCode().equals(reqDto.getType()) || CsPcpBusinessTypeEnum.maiyouBcAllotList().contains(reqDto.getType())) {
            preemptParam.setIsSaleOrder(Boolean.valueOf(true));
            preemptParam.setShoutBatch(Boolean.valueOf(detailList.stream().allMatch(r -> StringUtils.isNotBlank((CharSequence)r.getBatch()))));
            Boolean intransitPreemptFlag = detailList.stream().anyMatch(o -> Boolean.TRUE.equals(o.getIntransitPreemptFlag()));
            if (intransitPreemptFlag.booleanValue()) {
                Mutex mutex = this.lockService.lock("preemptOrderInventory#checkInventory", logicWarehouseEo.getWarehouseCode(), 20, 25, TimeUnit.SECONDS);
                try {
                    this.checkInventory(detailList, logicWarehouseEo, skuCodes);
                }
                finally {
                    this.transactionAfterService.execute(() -> this.lockService.unlock(mutex));
                }
            }
            preemptParam.setLendEnable(intransitPreemptFlag.booleanValue());
        }
        ArrayList detailParams = Lists.newArrayList();
        for (CsTransferOrderDetailReqDto detailReqDto : detailList) {
            CalcDetailDto detailParam = new CalcDetailDto();
            this.getLendEnable(logicWarehouseEo, detailReqDto, detailParam);
            BigDecimal preempt = BigDecimalUtils.abs((BigDecimal)detailReqDto.getQuantity());
            detailParam.setNum(preempt);
            detailParam.setSkuCode(detailReqDto.getLongCode());
            String warehouseCode = StringUtils.isNotBlank((CharSequence)reqDto.getOutLogicWarehouseCode()) ? reqDto.getOutLogicWarehouseCode() : reqDto.getInLogicWarehouseCode();
            detailParam.setLogicWarehouseCode(warehouseCode);
            detailParam.setBatch(detailReqDto.getBatch());
            detailParams.add(detailParam);
            preemptParam.setNoneBatch(Boolean.valueOf(StringUtils.isEmpty((CharSequence)detailReqDto.getBatch())));
        }
        preemptParam.setDetails((List)detailParams);
        return this.calcInventoryService.preempt(preemptParam);
    }

    private void checkInventory(List<CsTransferOrderDetailReqDto> detailList, LogicWarehouseEo logicWarehouseEo, List<String> skuCodeList) {
        String key;
        List logicInventoryEos = this.logicInventoryDomain.queryByWarehouseCodesAndSkuCodesAndBatches((List)Lists.newArrayList((Object[])new String[]{logicWarehouseEo.getWarehouseCode()}), skuCodeList, (List)Lists.newArrayList());
        AssertUtils.notEmpty((Collection)logicInventoryEos, (String)"\u903b\u8f91\u4ed3\u5e93\u5b58\u67e5\u8be2\u4e0d\u5b58\u5728");
        HashMap<String, BigDecimal> logicMap = new HashMap<String, BigDecimal>();
        for (LogicInventoryEo logicInventoryEo : logicInventoryEos) {
            String key2 = logicInventoryEo.getWarehouseCode() + "_" + logicInventoryEo.getSkuCode();
            logicMap.put(key2, BigDecimalUtils.add((BigDecimal)((BigDecimal)logicMap.get(key2)), (BigDecimal)logicInventoryEo.getAvailable()));
        }
        List intransitSkuCodes = detailList.stream().filter(o -> Boolean.TRUE.equals(o.getIntransitPreemptFlag())).map(CsTransferOrderDetailReqDto::getLongCode).distinct().collect(Collectors.toList());
        IntransitCargoQueryDto intransitCargoQueryDto = new IntransitCargoQueryDto();
        intransitCargoQueryDto.setLogicWarehouseCodes((List)Lists.newArrayList((Object[])new String[]{logicWarehouseEo.getWarehouseCode()}));
        intransitCargoQueryDto.setCargoCodes(intransitSkuCodes);
        List intransitCargoRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.outResultOrderQueryApi.queryIntransitCargoNum(intransitCargoQueryDto));
        if (null == intransitCargoRespDtoList) {
            intransitCargoRespDtoList = Lists.newArrayList();
        }
        HashMap intransitMap = Maps.newHashMap();
        for (IntransitCargoRespDto intransitCargoRespDto : intransitCargoRespDtoList) {
            String key3 = intransitCargoRespDto.getLogicWarehouseCode() + "_" + intransitCargoRespDto.getCargoCode();
            intransitMap.put(key3, BigDecimalUtils.add((BigDecimal)((BigDecimal)intransitMap.get(key3)), (BigDecimal)intransitCargoRespDto.getNum()));
        }
        HashMap intransitPreemptionMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)intransitCargoRespDtoList)) {
            List intransitPreemptionEos = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryPreemptionEo.class).eq(InventoryPreemptionEo::getLendWarehouseCode, (Object)((IntransitCargoRespDto)intransitCargoRespDtoList.get(0)).getIntransitWarehouseCode())).eq(InventoryPreemptionEo::getValid, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            if (null == intransitPreemptionEos) {
                intransitPreemptionEos = Lists.newArrayList();
            }
            for (InventoryPreemptionEo intransitPreemptionEo : intransitPreemptionEos) {
                key = intransitPreemptionEo.getWarehouseCode() + "_" + intransitPreemptionEo.getSkuCode();
                intransitPreemptionMap.put(key, BigDecimalUtils.add((BigDecimal)((BigDecimal)intransitPreemptionMap.get(key)), (BigDecimal)intransitPreemptionEo.getPreemptNum()));
            }
        }
        ArrayList errorList = Lists.newArrayList();
        for (CsTransferOrderDetailReqDto operateCargoReqDto : detailList) {
            if (!Boolean.TRUE.equals(operateCargoReqDto.getIntransitPreemptFlag())) continue;
            key = logicWarehouseEo.getWarehouseCode() + "_" + operateCargoReqDto.getLongCode();
            BigDecimal total = BigDecimalUtils.subtract((BigDecimal)BigDecimalUtils.add((BigDecimal)((BigDecimal)logicMap.get(key)), (BigDecimal)((BigDecimal)intransitMap.get(key))), (BigDecimal)((BigDecimal)intransitPreemptionMap.get(key)));
            if (!BigDecimalUtils.gt((BigDecimal)operateCargoReqDto.getQuantity(), (BigDecimal)total).booleanValue()) continue;
            errorList.add(String.format("\u903b\u8f91\u4ed3: %s, skuCode: %s, \u6240\u9700\u5e93\u5b58: %s, \u53ef\u7528\u5e93\u5b58: %s, \u5728\u9014\u5e93\u5b58: %s", logicWarehouseEo.getWarehouseCode(), operateCargoReqDto.getLongCode(), operateCargoReqDto.getQuantity(), BigDecimalUtils.check((BigDecimal)((BigDecimal)logicMap.get(key))), BigDecimalUtils.check((BigDecimal)((BigDecimal)intransitMap.get(key)))));
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            throw new BizException(StringUtils.join((Iterable)errorList, (String)","));
        }
    }

    private void getLendEnable(LogicWarehouseEo logicWarehouseEo, CsTransferOrderDetailReqDto detailReqDto, CalcDetailDto detailParam) {
        Boolean intransitPreemptFlag = detailReqDto.getIntransitPreemptFlag();
        if (null == intransitPreemptFlag) {
            intransitPreemptFlag = Boolean.FALSE;
        }
        if (intransitPreemptFlag.booleanValue()) {
            List intransitWarehouseEos = this.logicWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getSubordinateLogicWarehouseId, (Object)logicWarehouseEo.getId())).eq(LogicWarehouseEo::getWarehouseStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            if (CollectionUtils.isNotEmpty((Collection)intransitWarehouseEos)) {
                if (intransitWarehouseEos.size() > 1) {
                    throw new BizException(String.format("\u903b\u8f91\u4ed3[%s]\u5173\u8054\u5728\u9014\u4ed3\u4fe1\u606f\u4e0d\u552f\u4e00", logicWarehouseEo.getWarehouseCode()));
                }
                PreemptLendDto preemptLendDto = new PreemptLendDto();
                preemptLendDto.setLendType(PreemptLendDto.LendType.WAREHOUSE);
                preemptLendDto.setLendKey(((LogicWarehouseEo)intransitWarehouseEos.get(0)).getWarehouseCode());
                detailParam.setLendDto(preemptLendDto);
            } else {
                detailReqDto.setIntransitPreemptFlag(Boolean.FALSE);
            }
        }
    }

    private void preemptInventory(List<CsTransferOrderDetailEo> detailEoList, CsTransferOrderEo insertEo) {
        PreemptDto preemptParam = new PreemptDto();
        preemptParam.setSourceNo(insertEo.getTransferOrderNo());
        preemptParam.setSourceType(insertEo.getType());
        preemptParam.setBusinessType(insertEo.getType());
        preemptParam.setNoneLineNo(Boolean.valueOf(true));
        String externalOrderNo = StringUtils.isNotBlank((CharSequence)insertEo.getExternalSaleOrderNo()) ? insertEo.getExternalSaleOrderNo() : insertEo.getPreOrderNo();
        preemptParam.setExternalOrderNo(externalOrderNo);
        ArrayList detailParams = Lists.newArrayList();
        for (CsTransferOrderDetailEo detailReqDto : detailEoList) {
            CalcDetailDto detailParam = new CalcDetailDto();
            BigDecimal preempt = BigDecimalUtils.abs((BigDecimal)detailReqDto.getQuantity());
            detailParam.setNum(preempt);
            detailParam.setSkuCode(detailReqDto.getLongCode());
            String warehouseCode = StringUtils.isNotBlank((CharSequence)insertEo.getOutLogicWarehouseCode()) ? insertEo.getOutLogicWarehouseCode() : insertEo.getInLogicWarehouseCode();
            detailParam.setLogicWarehouseCode(warehouseCode);
            detailParam.setBatch(detailReqDto.getBatch());
            detailParams.add(detailParam);
            preemptParam.setNoneBatch(Boolean.valueOf(StringUtils.isEmpty((CharSequence)detailReqDto.getBatch())));
        }
        preemptParam.setDetails((List)detailParams);
        this.calcInventoryService.preempt(preemptParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addTransferOrder(CsTransferOrderComboReqDto csTransferOrderComboReqDto) {
        String transferNo;
        logger.info("\u521b\u5efa\u8c03\u62e8\u5355\u53c2\u6570:{}", (Object)LogUtils.buildLogContent(csTransferOrderComboReqDto));
        CsTransferOrderReqDto reqDto = csTransferOrderComboReqDto.getCsOtherStorageOrderReqDto();
        if (reqDto.getType().equals(CsPcpBusinessTypeEnum.BC_EQUAL_ALLOT.getCode()) || reqDto.getType().equals(CsPcpBusinessTypeEnum.CB_EQUAL_ALLOT.getCode())) {
            logger.info("BC\u540c\u7ec4\u7ec7\u8c03\u62e8\u65e0\u9700\u67e5\u8be2\u7269\u7406\u4ed3\u4fe1\u606f\u5e76\u8865\u5145");
        } else {
            this.queryWarehouseCodeAddress(reqDto);
            logger.info("\u521b\u5efa\u8c03\u62e8\u5355\u53c2\u6570,\u8865\u5145\u5b8c\u5730\u5740\u4fe1\u606f:{}", (Object)LogUtils.buildLogContent(csTransferOrderComboReqDto));
        }
        if (reqDto.getIsEnd().booleanValue()) {
            return this.addEndTransferOrder(csTransferOrderComboReqDto);
        }
        List detailList = csTransferOrderComboReqDto.getDetailList();
        ArrayList notValidNegativeTypes = Lists.newArrayList((Object[])new String[]{CsPcpBusinessTypeEnum.CB_ALLOT.getCode(), CsPcpBusinessTypeEnum.CB_EQUAL_ALLOT.getCode(), CsPcpBusinessTypeEnum.CC_ALLOT.getCode()});
        if (notValidNegativeTypes.contains(reqDto.getType())) {
            for (CsTransferOrderDetailReqDto detailReqDto2 : detailList) {
                if (!StringUtils.isBlank((CharSequence)detailReqDto2.getBatch())) continue;
                detailReqDto2.setBatch("20221221-666");
            }
            reqDto.setValidNegative(Boolean.valueOf(false));
        }
        CsTransferOrderEo insertEo = new CsTransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)insertEo);
        if (StringUtils.isBlank((CharSequence)insertEo.getOrderStatus())) {
            insertEo.setOrderStatus(CsTransferOrderEnum.Status.WAIT_AUDIT.getCode());
            if (reqDto.getIsEnd().booleanValue()) {
                logger.info("\u521b\u5efa\u8c03\u62e8\u5355,\u76f4\u63a5\u7ec8\u6781\u72b6\u6001");
                insertEo.setOrderStatus(CsTransferOrderEnum.Status.FINISH.getCode());
            }
        }
        if (StringUtils.isBlank((CharSequence)(transferNo = reqDto.getTransferOrderNo()))) {
            String generateCodeStrategy = CsGenerateCodeStrategyEnum.PCP_TRANSFER_ORDER.getCode();
            if (CsPcpBusinessTypeEnum.CLAIM_ALLOT.getCode().equals(reqDto.getType())) {
                generateCodeStrategy = CsGenerateCodeStrategyEnum.CLAIM_TRANSFER_ORDER.getCode();
                transferNo = GenerateCodeUtils.getStrategy(generateCodeStrategy).getCode();
            } else if (CsPcpBusinessTypeEnum.BORROW_ALLOT.getCode().equals(reqDto.getType())) {
                generateCodeStrategy = CsGenerateCodeStrategyEnum.BORROW_TRANSFER_ORDER.getCode();
                transferNo = GenerateCodeUtils.getStrategy(generateCodeStrategy).getCode();
            } else if (CsPcpBusinessTypeEnum.IN_TRANSIT_TRANSFER.getCode().equals(reqDto.getType())) {
                generateCodeStrategy = CsGenerateCodeStrategyEnum.IN_TRANSIT_TRANSFER_ORDER.getCode();
                transferNo = GenerateCodeUtils.getStrategy(generateCodeStrategy).getCode();
            } else {
                transferNo = this.getBcOrCcTransferNo(insertEo);
                if (StringUtils.isBlank((CharSequence)transferNo)) {
                    transferNo = GenerateCodeUtils.getStrategy(generateCodeStrategy).getCode();
                }
            }
            reqDto.setTransferOrderNo(transferNo);
        }
        insertEo.setId(null);
        insertEo.setTransferOrderNo(transferNo);
        BigDecimal totalQuantity = detailList.stream().map(CsTransferOrderDetailReqDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        insertEo.setTotalQuantity(totalQuantity);
        List<InventoryPreemptionEo> inventoryPreemptionEos = this.preemptInventoryByParam(detailList, reqDto);
        AssertUtil.assertNotEmpty(inventoryPreemptionEos, "\u9884\u5360\u8bb0\u5f55\u67e5\u8be2\u4e0d\u5b58\u5728\uff1a\u9884\u5360\u5931\u8d25", new Object[0]);
        this.transactionCallBackService.execute(() -> {
            List inventoryPreemptionDtoList = InventoryPreemptionConverter.INSTANCE.toDtoList(inventoryPreemptionEos);
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)JSONObject.toJSONString((Object)inventoryPreemptionDtoList));
            logger.info("TRANSFER_ORDER_PREEMPT_SUCCESS: {}", (Object)LogUtils.buildLogContent(inventoryPreemptionDtoList));
            this.commonsMqService.sendDelaySingleMessage("INVENTORY_BUSINESS_TOPIC", "TRANSFER_ORDER_PREEMPT_SUCCESS", (Object)messageVo, Long.valueOf(5L));
        });
        ArrayList splitDetailList = Lists.newArrayList();
        for (InventoryPreemptionEo InventoryPreemptionEo2 : inventoryPreemptionEos) {
            String cargoCode = InventoryPreemptionEo2.getSkuCode();
            CsTransferOrderDetailReqDto detail = detailList.stream().filter(o -> StringUtils.equals((CharSequence)o.getLongCode(), (CharSequence)cargoCode)).findFirst().orElse(null);
            AssertUtil.assertNotNull(detail, "\u901a\u8fc7\u9884\u5360\u8bb0\u5f55\u8d27\u54c1\u627e\u4e0d\u5230\uff0c\u53c2\u6570\u4f20\u5165\u8d27\u54c1", new Object[0]);
            CsTransferOrderDetailReqDto splitDetail = new CsTransferOrderDetailReqDto();
            BeanUtils.copyProperties((Object)detail, (Object)splitDetail);
            splitDetail.setBatch(InventoryPreemptionEo2.getBatch());
            splitDetail.setQuantity(InventoryPreemptionEo2.getPreemptNum());
            splitDetail.setTransferOrderNo(transferNo);
            splitDetailList.add(splitDetail);
        }
        List longCodes = splitDetailList.stream().map(CsTransferOrderDetailReqDto::getLongCode).distinct().collect(Collectors.toList());
        List batchs = splitDetailList.stream().map(CsTransferOrderDetailReqDto::getBatch).distinct().collect(Collectors.toList());
        CsLogicInventoryQueryDto dto = new CsLogicInventoryQueryDto();
        dto.setLongCodes(longCodes);
        dto.setBatchList(batchs);
        dto.setWarehouseCode(reqDto.getOutLogicWarehouseCode());
        List<CsLogicInventoryRespDto> inventoryRespDtos = this.inventoryQueryService.queryInfoList(dto);
        logger.info("\u67e5\u8be2\u5230\u5546\u54c1\u751f\u4ea7\u65e5\u671f\u548c\u8fc7\u671f\u65e5\u671finventoryRespDtos:{}", (Object)JSON.toJSONString(inventoryRespDtos));
        HashMap respDtoMap = new HashMap();
        if (CollectionUtil.isNotEmpty(inventoryRespDtos)) {
            Map dtoMap = inventoryRespDtos.stream().collect(Collectors.toMap(r -> r.getSkuCode() + "_" + r.getBatch(), Function.identity(), (o, o1) -> o));
            respDtoMap.putAll(dtoMap);
        }
        csTransferOrderComboReqDto.setDetailList((List)splitDetailList);
        this.checkParam(csTransferOrderComboReqDto);
        this.checkParam(csTransferOrderComboReqDto);
        detailList = splitDetailList;
        ArrayList<CsTransferOrderDetailEo> detailEoList = new ArrayList<CsTransferOrderDetailEo>(detailList.size());
        detailList.forEach(detailReqDto -> {
            CsTransferOrderDetailEo eo = new CsTransferOrderDetailEo();
            BeanUtils.copyProperties((Object)detailReqDto, (Object)eo);
            String key = String.format("%s_%s", detailReqDto.getLongCode(), detailReqDto.getBatch());
            if (respDtoMap.containsKey(key)) {
                CsLogicInventoryRespDto csLogicInventoryRespDto = (CsLogicInventoryRespDto)respDtoMap.get(key);
                eo.setProduceTime(csLogicInventoryRespDto.getProduceTime());
                eo.setExpireTime(csLogicInventoryRespDto.getExpireTime());
            }
            detailEoList.add(eo);
        });
        this.handlingVolumeWeight(detailEoList);
        if (null == this.context || StringUtils.isBlank((CharSequence)this.context.userName())) {
            insertEo.setCreatePerson("system");
        }
        if (StringUtils.equals((CharSequence)insertEo.getInLogicWarehouseCode(), (CharSequence)insertEo.getOutLogicWarehouseCode())) {
            throw new CsInventoryException("\u8c03\u5165\u4ed3\u4e0d\u80fd\u4e0e\u8c03\u51fa\u4ed3\u4e00\u81f4", new Object[0]);
        }
        this.csTransferOrderDas.insert((BaseEo)insertEo);
        this.csTransferOrderDetailDas.insertBatch(detailEoList);
        this.transactionCallBackService.execute(() -> {
            MessageVo messageVo = new MessageVo();
            CsTransferOrderRespDto respDto = new CsTransferOrderRespDto();
            BeanUtils.copyProperties((Object)insertEo, (Object)respDto);
            messageVo.setData((Object)JSON.toJSONString((Object)respDto));
            this.commonsMqService.publishMessage("TRANSFER_CREATE", (Object)messageVo);
        });
        return insertEo.getId();
    }

    private void handlingVolumeWeight(List<CsTransferOrderDetailEo> detailList) {
        try {
            List skuCodes = detailList.stream().map(CsTransferOrderDetailEo::getLongCode).distinct().collect(Collectors.toList());
            List pcpItemRespDtos = this.itemSkuQueryApiProxy.queryBySkuCodes(skuCodes);
            logger.info("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)pcpItemRespDtos));
            Map<Object, Object> itemRespDtoMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)pcpItemRespDtos)) {
                itemRespDtoMap = pcpItemRespDtos.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (k1, k3) -> k1));
            }
            for (CsTransferOrderDetailEo detailEo : detailList) {
                ItemSkuDto itemSkuDto = (ItemSkuDto)itemRespDtoMap.get(detailEo.getLongCode());
                if (ObjectUtil.isEmpty((Object)itemSkuDto)) continue;
                detailEo.setWeight(BigDecimalUtils.multiply((BigDecimal)itemSkuDto.getWeight(), (BigDecimal)detailEo.getQuantity()));
                detailEo.setVolume(BigDecimalUtils.multiply((BigDecimal)itemSkuDto.getVolume(), (BigDecimal)detailEo.getQuantity()));
            }
            logger.info("\u65b0\u589e\u8c03\u62e8\u5355,\u8865\u5145\u4f53\u79ef\u548c\u91cd\u91cf\u540e: {}", (Object)LogUtils.buildLogContent(detailList));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void queryWarehouseCodeAddress(CsTransferOrderReqDto reqDto) {
        List WarehouseAddressEos;
        if (StringUtils.isNotBlank((CharSequence)reqDto.getInPhysicsWarehouseCode()) && CollectionUtils.isNotEmpty((Collection)(WarehouseAddressEos = this.warehouseAddressDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(WarehouseAddressEo.class).eq(WarehouseAddressEo::getWarehouseCode, (Object)reqDto.getInPhysicsWarehouseCode())).eq(WarehouseAddressEo::getValidFlag, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO))))) {
            WarehouseAddressEo inWarehouseAddressEo = (WarehouseAddressEo)WarehouseAddressEos.get(0);
            reqDto.setProvinceCode(inWarehouseAddressEo.getProvinceCode());
            reqDto.setProvince(inWarehouseAddressEo.getProvince());
            reqDto.setCityCode(inWarehouseAddressEo.getCityCode());
            reqDto.setCity(inWarehouseAddressEo.getCity());
            reqDto.setAreaCode(inWarehouseAddressEo.getDistrictCode());
            reqDto.setArea(inWarehouseAddressEo.getDistrict());
            reqDto.setAddress(inWarehouseAddressEo.getDetailAddress());
            reqDto.setContact(inWarehouseAddressEo.getContacts());
            reqDto.setContactPhone(inWarehouseAddressEo.getPhone());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addTransferOrders(List<CsTransferOrderComboReqDto> csTransferOrderComboReqDtoList) {
        for (CsTransferOrderComboReqDto csTransferOrderComboReqDto : csTransferOrderComboReqDtoList) {
            this.addTransferOrder(csTransferOrderComboReqDto);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CsTransferOrderRespDto addTransferOrderAndResp(CsTransferOrderComboReqDto csTransferOrderComboReqDto) {
        Long id = this.addTransferOrder(csTransferOrderComboReqDto);
        logger.info("addTransferOrderAndResp\u521b\u5efa\u8c03\u62e8\u5355\u8fd4\u56deid:{}", (Object)LogUtils.buildLogContent(id));
        CsTransferOrderEo insertEo = (CsTransferOrderEo)this.csTransferOrderMapper.findById(id);
        CsTransferOrderRespDto respDto = new CsTransferOrderRespDto();
        BeanUtils.copyProperties((Object)insertEo, (Object)respDto);
        return respDto;
    }

    @Override
    public void preemptInventoryBy(CsTransferOrderComReqDto csTransferOrderComboReqDto) {
        logger.info("\u521b\u5efa\u8c03\u62e8\u5355\u53c2\u6570:{}", (Object)LogUtils.buildLogContent(csTransferOrderComboReqDto));
        CsTransferOrderRespDto reqDto = csTransferOrderComboReqDto.getCsOtherStorageOrderReqDto();
        List detailList = csTransferOrderComboReqDto.getDetailList();
        String transferNo = reqDto.getTransferOrderNo();
        PreemptDto preemptParam = new PreemptDto();
        preemptParam.setSourceNo(transferNo);
        preemptParam.setSourceType(reqDto.getType());
        preemptParam.setBusinessType(reqDto.getType());
        String externalOrderNo = StringUtils.isNotBlank((CharSequence)reqDto.getExternalSaleOrderNo()) ? reqDto.getExternalSaleOrderNo() : reqDto.getPreOrderNo();
        preemptParam.setExternalOrderNo(externalOrderNo);
        if (CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(reqDto.getType()) || CsPcpBusinessTypeEnum.ALLOT_SALE_BH.getCode().equals(reqDto.getType()) || CsPcpBusinessTypeEnum.maiyouBcAllotList().contains(reqDto.getType())) {
            preemptParam.setIsSaleOrder(Boolean.valueOf(true));
        }
        if (CsPcpBusinessTypeEnum.CB_EQUAL_ALLOT.getCode().contains(reqDto.getType())) {
            preemptParam.setValidNegative(Boolean.valueOf(false));
        }
        ArrayList detailParams = Lists.newArrayList();
        for (CsTransferOrderDetailRespDto detailReqDto : detailList) {
            CalcDetailDto detailParam = new CalcDetailDto();
            BigDecimal preempt = BigDecimalUtils.abs((BigDecimal)detailReqDto.getQuantity());
            detailParam.setNum(preempt);
            detailParam.setSkuCode(detailReqDto.getLongCode());
            String warehouseCode = StringUtils.isNotBlank((CharSequence)reqDto.getOutLogicWarehouseCode()) ? reqDto.getOutLogicWarehouseCode() : reqDto.getInLogicWarehouseCode();
            detailParam.setLogicWarehouseCode(warehouseCode);
            detailParam.setBatch(detailReqDto.getBatch());
            detailParams.add(detailParam);
            preemptParam.setNoneBatch(Boolean.valueOf(StringUtils.isEmpty((CharSequence)detailReqDto.getBatch())));
        }
        preemptParam.setDetails((List)detailParams);
        this.calcInventoryService.preempt(preemptParam);
    }

    public Long addEndTransferOrder(CsTransferOrderComboReqDto csTransferOrderComboReqDto) {
        logger.info("\u521b\u5efa\u8c03\u62e8\u5355\u53c2\u6570:{}", (Object)LogUtils.buildLogContent(csTransferOrderComboReqDto));
        this.checkParam(csTransferOrderComboReqDto);
        CsTransferOrderReqDto reqDto = csTransferOrderComboReqDto.getCsOtherStorageOrderReqDto();
        CsTransferOrderEo insertEo = new CsTransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)insertEo);
        if (StringUtils.isBlank((CharSequence)insertEo.getOrderStatus())) {
            insertEo.setOrderStatus(CsTransferOrderEnum.Status.WAIT_AUDIT.getCode());
            if (reqDto.getIsEnd().booleanValue()) {
                logger.info("\u521b\u5efa\u8c03\u62e8\u5355,\u76f4\u63a5\u7ec8\u6781\u72b6\u6001");
                insertEo.setOrderStatus(CsTransferOrderEnum.Status.FINISH.getCode());
            }
        }
        insertEo.setId(null);
        String transferNo = "";
        if (StringUtils.isNotBlank((CharSequence)insertEo.getTransferOrderNo())) {
            transferNo = insertEo.getTransferOrderNo();
        } else {
            transferNo = this.getBcOrCcTransferNo(insertEo);
            if (StringUtils.isBlank((CharSequence)transferNo)) {
                transferNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.TRANSFER_ORDER.getCode()).getCode();
            }
        }
        insertEo.setTransferOrderNo(transferNo);
        List detailList = csTransferOrderComboReqDto.getDetailList();
        BigDecimal totalQuantity = detailList.stream().map(CsTransferOrderDetailReqDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        insertEo.setTotalQuantity(totalQuantity);
        for (CsTransferOrderDetailReqDto d : detailList) {
            d.setTransferOrderNo(transferNo);
        }
        ArrayList detailEoList = new ArrayList(detailList.size());
        DtoHelper.dtoList2EoList((Collection)detailList, detailEoList, CsTransferOrderDetailEo.class);
        this.csTransferOrderDas.insert((BaseEo)insertEo);
        this.csTransferOrderDetailDas.insertBatch(detailEoList);
        logger.info("\u521b\u5efa\u8c03\u62e8\u5355,\u76f4\u63a5\u7ec8\u6781\u72b6\u6001");
        return insertEo.getId();
    }

    @Override
    public void modifyCsTransferOrder(CsTransferOrderComboReqDto csTransferOrderComboReqDto) {
        logger.info("\u7f16\u8f91\u8c03\u62e8\u5355\u53c2\u6570:{}", (Object)LogUtils.buildLogContent(csTransferOrderComboReqDto));
        Long id = csTransferOrderComboReqDto.getCsOtherStorageOrderReqDto().getId();
        AssertUtil.isTrue(id != null && id > 0L, "\u8c03\u62e8\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        CsTransferOrderReqDto reqDto = csTransferOrderComboReqDto.getCsOtherStorageOrderReqDto();
        String inLogicWarehouseCode = reqDto.getInLogicWarehouseCode();
        String outLogicWarehouseCode = reqDto.getOutLogicWarehouseCode();
        AssertUtil.isTrue(!inLogicWarehouseCode.equals(outLogicWarehouseCode), "\u8c03\u62e8\u51fa\u4e0e\u8c03\u62e8\u5165\u7684\u903b\u8f91\u4ed3\u4e00\u81f4,\u65e0\u6cd5\u4fee\u6539\u8c03\u62e8\u5355");
        CsTransferOrderEo insertEo = new CsTransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)insertEo, (String[])new String[]{"sourceSystem"});
        insertEo.setOrderStatus(CsTransferOrderEnum.Status.WAIT_AUDIT.getCode());
        insertEo.setId(id);
        String transferOrderNo = reqDto.getTransferOrderNo();
        AssertUtil.isTrue(StringUtils.isNotEmpty((CharSequence)transferOrderNo), "\u8c03\u62e8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List detailList = csTransferOrderComboReqDto.getDetailList();
        this.queryWarehouseCodeAddress(reqDto);
        BigDecimal totalQuantity = detailList.stream().map(CsTransferOrderDetailReqDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        insertEo.setTotalQuantity(totalQuantity);
        for (CsTransferOrderDetailReqDto d : detailList) {
            d.setTransferOrderNo(transferOrderNo);
        }
        ArrayList<CsTransferOrderDetailEo> detailEoList = new ArrayList<CsTransferOrderDetailEo>(detailList.size());
        ArrayList notValidNegativeTypes = Lists.newArrayList((Object[])new String[]{CsPcpBusinessTypeEnum.CB_ALLOT.getCode(), CsPcpBusinessTypeEnum.CC_ALLOT.getCode()});
        if (notValidNegativeTypes.contains(reqDto.getType())) {
            for (CsTransferOrderDetailReqDto detailReqDto : detailList) {
                if (!StringUtils.isBlank((CharSequence)detailReqDto.getBatch())) continue;
                detailReqDto.setBatch("20221221-666");
            }
            reqDto.setValidNegative(Boolean.valueOf(false));
        }
        DtoHelper.dtoList2EoList((Collection)detailList, detailEoList, CsTransferOrderDetailEo.class);
        this.getProduceTime(reqDto, detailEoList);
        this.csTransferOrderDas.updateSelective((BaseEo)insertEo);
        CsTransferOrderDetailEo logicDeleteEo = new CsTransferOrderDetailEo();
        logicDeleteEo.setTransferOrderNo(transferOrderNo);
        this.csTransferOrderDetailDas.logicDelete((BaseEo)logicDeleteEo);
        this.csTransferOrderDetailDas.insertBatch(detailEoList);
        this.preemptInventoryByParam(detailList, reqDto);
    }

    private void getProduceTime(CsTransferOrderReqDto reqDto, List<CsTransferOrderDetailEo> detailEoList) {
        List longCodes = detailEoList.stream().map(CsTransferOrderDetailEo::getLongCode).distinct().collect(Collectors.toList());
        List batchs = detailEoList.stream().map(CsTransferOrderDetailEo::getBatch).distinct().collect(Collectors.toList());
        CsLogicInventoryQueryDto dto = new CsLogicInventoryQueryDto();
        dto.setLongCodes(longCodes);
        dto.setBatchList(batchs);
        dto.setWarehouseCode(reqDto.getOutLogicWarehouseCode());
        List<CsLogicInventoryRespDto> inventoryRespDtos = this.inventoryQueryService.queryInfoList(dto);
        logger.info("\u67e5\u8be2\u5230\u5546\u54c1\u751f\u4ea7\u65e5\u671f\u548c\u8fc7\u671f\u65e5\u671finventoryRespDtos:{}", (Object)JSON.toJSONString(inventoryRespDtos));
        HashMap respDtoMap = new HashMap();
        if (CollectionUtil.isNotEmpty(inventoryRespDtos)) {
            Map dtoMap = inventoryRespDtos.stream().collect(Collectors.toMap(r -> r.getSkuCode() + "_" + r.getBatch(), Function.identity(), (o, o1) -> o));
            respDtoMap.putAll(dtoMap);
        }
        detailEoList.forEach(detailEo -> {
            String key = detailEo.getLongCode() + "_" + detailEo.getBatch();
            if (respDtoMap.containsKey(key)) {
                CsLogicInventoryRespDto csLogicInventoryRespDto = (CsLogicInventoryRespDto)respDtoMap.get(key);
                detailEo.setProduceTime(csLogicInventoryRespDto.getProduceTime());
                detailEo.setExpireTime(csLogicInventoryRespDto.getExpireTime());
            }
        });
    }

    private void checkParam(CsTransferOrderComboReqDto csTransferOrderComboReqDto) {
        this.checkWarehouse(csTransferOrderComboReqDto.getCsOtherStorageOrderReqDto());
        List detailList = csTransferOrderComboReqDto.getDetailList();
        AssertUtil.isTrue(CollectionUtil.isNotEmpty((Collection)detailList), "\u53c2\u6570\u9519\u8bef,\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsTransferOrderDetailReqDto d : detailList) {
            AssertUtil.isTrue(d.getQuantity().compareTo(BigDecimal.ZERO) > 0, "\u5546\u54c1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            if (InventoryConfig.isNoneBatch()) continue;
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)d.getBatch()), "\u5546\u54c1\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> itemSet = detailList.stream().map(CsTransferOrderDetailReqDto::getLongCode).distinct().collect(Collectors.toList());
        this.checkSku(itemSet);
    }

    private void checkSku(List<String> itemSet) {
        List itemEoList = this.itemSkuProxy.queryBySkuCodes(itemSet);
        if (itemEoList.size() != itemSet.size()) {
            Map<Object, Object> cargoMap = new HashMap();
            StringBuilder sb = new StringBuilder();
            if (CollectionUtil.isNotEmpty((Collection)itemEoList)) {
                cargoMap = itemEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, entity -> entity));
            }
            for (String itemCode : itemSet) {
                if (cargoMap.containsKey(itemCode)) continue;
                sb.append(itemCode).append(",");
            }
            sb.append("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            throw new BizException(sb.toString());
        }
    }

    private void checkWarehouse(CsTransferOrderReqDto csOtherStorageOrderReqDto) {
        String outLogicWarehouseCode;
        String inLogicWarehouseCode = csOtherStorageOrderReqDto.getInLogicWarehouseCode();
        AssertUtil.isTrue(!inLogicWarehouseCode.equals(outLogicWarehouseCode = csOtherStorageOrderReqDto.getOutLogicWarehouseCode()), "\u8c03\u62e8\u51fa\u4e0e\u8c03\u62e8\u5165\u7684\u903b\u8f91\u4ed3\u4e00\u81f4\uff0c\u65e0\u6cd5\u521b\u5efa\u8c03\u62e8\u5355");
        LogicWarehouseEo outLogicWarehouseEo = this.logicWarehouseDomain.queryByCode(outLogicWarehouseCode);
        LogicWarehouseEo inLogicWarehouseEo = this.logicWarehouseDomain.queryByCode(inLogicWarehouseCode);
        AssertUtil.isTrue(null != outLogicWarehouseEo, "\u51fa\u5e93\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(null != inLogicWarehouseEo, "\u5165\u5e93\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728");
        String outWarehouseQuality = outLogicWarehouseEo.getWarehouseQuality();
        String inWarehouseQuality = inLogicWarehouseEo.getWarehouseQuality();
        csOtherStorageOrderReqDto.setOutLogicWarehouseName(outLogicWarehouseEo.getWarehouseName());
        csOtherStorageOrderReqDto.setOutOrganizationId(outLogicWarehouseEo.getOrganizationId());
        csOtherStorageOrderReqDto.setOutOrganization(outLogicWarehouseEo.getOrganizationName());
        csOtherStorageOrderReqDto.setInLogicWarehouseName(inLogicWarehouseEo.getWarehouseName());
        csOtherStorageOrderReqDto.setInOrganizationId(inLogicWarehouseEo.getOrganizationId());
        csOtherStorageOrderReqDto.setInOrganization(inLogicWarehouseEo.getOrganizationName());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"warehouse_code", Arrays.asList(inLogicWarehouseCode, outLogicWarehouseCode));
        queryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        queryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        queryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List csRelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)csRelWarehouseEoList)) {
            for (RelWarehouseEo csRelWarehouseEo : csRelWarehouseEoList) {
                if (csRelWarehouseEo.getWarehouseCode().equals(outLogicWarehouseCode)) {
                    csOtherStorageOrderReqDto.setOutPhysicsWarehouseCode(csRelWarehouseEo.getRefWarehouseCode());
                    csOtherStorageOrderReqDto.setOutPhysicsWarehouseName(csRelWarehouseEo.getRefWarehouseName());
                }
                if (!csRelWarehouseEo.getWarehouseCode().equals(inLogicWarehouseCode)) continue;
                csOtherStorageOrderReqDto.setInPhysicsWarehouseCode(csRelWarehouseEo.getRefWarehouseCode());
                csOtherStorageOrderReqDto.setInPhysicsWarehouseName(csRelWarehouseEo.getRefWarehouseName());
            }
        }
        if (CsLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode().equals(outWarehouseQuality) && CsLogicWarehouseQualityEnum.QUALIFIED.getCode().equals(inWarehouseQuality)) {
            AssertUtil.isTrue(CsPcpBusinessTypeEnum.INSPECTION_QUALIFIED.getCode().equals(csOtherStorageOrderReqDto.getType()) || CsPcpBusinessTypeEnum.IN_TRANSIT_TRANSFER.getCode().equals(csOtherStorageOrderReqDto.getType()), "\u5f85\u68c0\u4ed3\u4e0d\u80fd\u76f4\u63a5\u8c03\u5165\u5408\u683c\u4ed3");
        }
    }

    private void checkLogicWarehouse(Set<String> warehouseCodes) {
        List list = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", warehouseCodes)).list();
        if (warehouseCodes.size() != list.size()) {
            Map<String, String> logicMap = list.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, LogicWarehouseEo::getWarehouseName));
            this.checkExist(warehouseCodes, logicMap);
        }
    }

    private void checkExist(Set<String> warehouseCodes, Map<String, String> warehouseMap) {
        StringBuilder errorMsg = new StringBuilder();
        for (String warehouseCode : warehouseCodes) {
            if (warehouseMap.containsKey(warehouseCode)) continue;
            errorMsg.append(warehouseCode);
        }
        errorMsg.append("\u4ed3\u5e93\u7f16\u7801\u4e0d\u5b58\u5728");
        throw new BizException(errorMsg.toString());
    }

    private void checkPhysicsWarehouse(Set<String> warehouseCodes) {
        List list = ((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().in((Object)"warehouse_code", warehouseCodes)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        if (warehouseCodes.size() != list.size()) {
            Map<String, String> physicsMap = list.stream().collect(Collectors.toMap(PhysicsWarehouseEo::getWarehouseCode, PhysicsWarehouseEo::getWarehouseName));
            this.checkExist(warehouseCodes, physicsMap);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCsTransferOrder(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.csTransferOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CsTransferOrderRespDto queryById(Long id) {
        CsTransferOrderEo transferOrder = (CsTransferOrderEo)this.csTransferOrderDas.selectByPrimaryKey(id);
        logger.info("queryById-->transferOrder:{}", (Object)LogUtils.buildLogContent(transferOrder));
        AssertUtil.isTrue(Objects.nonNull(transferOrder), "\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
        CsTransferOrderRespDto csTransferOrderRespDto = new CsTransferOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)transferOrder, (BaseVo)csTransferOrderRespDto);
        logger.info("queryById-->csTransferOrderRespDto:{}", (Object)LogUtils.buildLogContent(csTransferOrderRespDto));
        return csTransferOrderRespDto;
    }

    @Override
    public CsTransferOrderRespDto queryByTransferOrderNo(String transferOrderNo) {
        List transferOrderEos = ((ExtQueryChainWrapper)this.csTransferOrderDas.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).list();
        logger.info("queryByTransferOrderNo-->transferOrder:{}", (Object)LogUtils.buildLogContent(transferOrderEos));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)transferOrderEos), "\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
        CsTransferOrderRespDto csTransferOrderRespDto = new CsTransferOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)((BaseEo)transferOrderEos.get(0)), (BaseVo)csTransferOrderRespDto);
        return csTransferOrderRespDto;
    }

    @Override
    public PageInfo<CsTransferOrderRespDto> queryByPage(CsTransferOrderQueryDto queryDto, Integer pageNum, Integer pageSize) {
        List<String> strings;
        logger.info("\u5206\u9875\u67e5\u8be2\u8c03\u62e8\u5355\u53c2\u6570:{}", (Object)LogUtils.buildLogContent(queryDto));
        if (StringUtils.isNotBlank((CharSequence)queryDto.getConsignmentNo()) || StringUtils.isNotBlank((CharSequence)queryDto.getShippingCode()) || StringUtils.isNotBlank((CharSequence)queryDto.getShippingType()) || StringUtils.isNotBlank((CharSequence)queryDto.getShippingCompany())) {
            List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().like(StringUtils.isNotBlank((CharSequence)queryDto.getConsignmentNo()), (Object)"consignment_no", (Object)queryDto.getConsignmentNo())).like(StringUtils.isNotBlank((CharSequence)queryDto.getShippingCode()), (Object)"shipping_code", (Object)queryDto.getShippingCode())).like(StringUtils.isNotBlank((CharSequence)queryDto.getShippingType()), (Object)"shipping_type", (Object)queryDto.getShippingType())).like(StringUtils.isNotBlank((CharSequence)queryDto.getShippingCompany()), (Object)"shipping_company", (Object)queryDto.getShippingCompany())).list();
            if (CollectionUtils.isNotEmpty((Collection)eos)) {
                List relevanceNos = eos.stream().map(InOutResultOrderEo::getRelevanceNo).distinct().collect(Collectors.toList());
                queryDto.setTransferOrderNoList(relevanceNos);
            } else {
                return new PageInfo();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getTransferOrderNo()) && (strings = Arrays.asList(queryDto.getTransferOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            queryDto.setTransferOrderNoList(strings);
            queryDto.setTransferOrderNo(null);
        }
        ExtQueryChainWrapper<CsTransferOrderEo> param = this.getQueryEo(queryDto);
        PageInfo eoPageInfo = param.select(new String[0]).page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CsTransferOrderRespDto.class);
        if (CollectionUtil.isNotEmpty(dtoList)) {
            Map<String, Double> inMap;
            Object csTransferOrderRespDto2;
            logger.info("\u67e5\u8be2\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(dtoList));
            List outPhysicsWarehouseCodes = dtoList.stream().map(CsTransferOrderRespDto::getOutPhysicsWarehouseCode).distinct().collect(Collectors.toList());
            Map<Object, Object> outPhysicsWarehouseMap = new HashMap();
            if (CollectionUtils.isNotEmpty(outPhysicsWarehouseCodes)) {
                outPhysicsWarehouseMap = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().eq((Object)"dr", (Object)0)).in((Object)"warehouse_code", outPhysicsWarehouseCodes)).list().stream().collect(Collectors.toMap(PhysicsWarehouseEo::getWarehouseCode, PhysicsWarehouseEo::getIsLogistics));
            }
            List<String> transferNoList = dtoList.stream().map(CsTransferOrderRespDto::getTransferOrderNo).distinct().collect(Collectors.toList());
            List logicWarehouseCodeList = dtoList.stream().flatMap(r -> Lists.newArrayList((Object[])new String[]{r.getOutLogicWarehouseCode(), r.getInLogicWarehouseCode()}).stream()).distinct().collect(Collectors.toList());
            Map<String, String> warehouseNameMap = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", logicWarehouseCodeList)).list().stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, LogicWarehouseEo::getWarehouseName));
            Map<Object, Object> finalOutPhysicsWarehouseMap = outPhysicsWarehouseMap;
            dtoList.forEach(r -> {
                r.setOutPhysicsWarehouseIsLogistics((Integer)finalOutPhysicsWarehouseMap.get(r.getOutPhysicsWarehouseCode()));
                r.setInLogicWarehouseName((String)warehouseNameMap.get(r.getInLogicWarehouseCode()));
                r.setOutLogicWarehouseName((String)warehouseNameMap.get(r.getOutLogicWarehouseCode()));
            });
            Map<String, Map<String, Double>> finishMap = this.queryInOutResult(transferNoList);
            Map<String, Double> outMap = finishMap.get("delivery");
            if (CollectionUtil.isNotEmpty(outMap)) {
                Iterator iterator = dtoList.iterator();
                while (iterator.hasNext()) {
                    csTransferOrderRespDto2.setDoneOutQuantity(outMap.get((csTransferOrderRespDto2 = (CsTransferOrderRespDto)iterator.next()).getTransferOrderNo()) == null ? BigDecimal.ZERO : BigDecimal.valueOf(outMap.get(csTransferOrderRespDto2.getTransferOrderNo())));
                }
            } else {
                for (Object csTransferOrderRespDto2 : dtoList) {
                    csTransferOrderRespDto2.setDoneOutQuantity(BigDecimal.ZERO);
                }
            }
            if (CollectionUtil.isNotEmpty(inMap = finishMap.get("receive"))) {
                csTransferOrderRespDto2 = dtoList.iterator();
                while (csTransferOrderRespDto2.hasNext()) {
                    CsTransferOrderRespDto csTransferOrderRespDto3;
                    csTransferOrderRespDto3.setDoneInQuantity(inMap.get((csTransferOrderRespDto3 = (CsTransferOrderRespDto)csTransferOrderRespDto2.next()).getTransferOrderNo()) == null ? BigDecimal.ZERO : BigDecimal.valueOf(inMap.get(csTransferOrderRespDto3.getTransferOrderNo())));
                }
            }
            HashMap<String, BigDecimal> volumeSumMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> weightSumMap = new HashMap<String, BigDecimal>();
            List csTransferOrderDetailEos = ((ExtQueryChainWrapper)this.csTransferOrderDetailDas.filter().in((Object)"transfer_order_no", transferNoList)).list();
            for (CsTransferOrderDetailEo eo : csTransferOrderDetailEos) {
                String key = eo.getTransferOrderNo();
                volumeSumMap.put(key, BigDecimalUtils.add((BigDecimal)volumeSumMap.getOrDefault(key, BigDecimal.ZERO), (BigDecimal)eo.getVolume()));
                weightSumMap.put(key, BigDecimalUtils.add((BigDecimal)weightSumMap.getOrDefault(key, BigDecimal.ZERO), (BigDecimal)eo.getWeight()));
            }
            Map map = ((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().in((Object)"relevance_no", transferNoList)).list().stream().collect(Collectors.toMap(InOutResultOrderEo::getRelevanceNo, Function.identity(), (k1, k2) -> k1));
            dtoList.forEach(o -> {
                if (StringUtils.isNotBlank((CharSequence)o.getTransferOrderNo())) {
                    InOutResultOrderEo eo = (InOutResultOrderEo)map.get(o.getTransferOrderNo());
                    o.setTotalVolume((BigDecimal)volumeSumMap.get(o.getTransferOrderNo()));
                    o.setTotalWeight((BigDecimal)weightSumMap.get(o.getTransferOrderNo()));
                    if (ObjectUtil.isNotNull((Object)eo)) {
                        o.setTotalCartons(eo.getTotalCartons());
                        o.setMergeQuantity(eo.getMergeQuantity());
                        o.setShippingCompany(eo.getShippingCompany());
                        o.setShippingCode(eo.getShippingCode());
                        o.setConsignmentNo(eo.getConsignmentNo());
                        o.setShippingType(eo.getShippingType());
                    }
                }
            });
            Map map1 = ((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().in((Object)"relevance_no", transferNoList)).list().stream().collect(Collectors.toMap(InOutNoticeOrderEo::getRelevanceNo, Function.identity(), (k1, k2) -> k1));
            dtoList.forEach(o -> {
                InOutNoticeOrderEo eo;
                if (StringUtils.isNotBlank((CharSequence)o.getTransferOrderNo()) && ObjectUtil.isNotNull((Object)(eo = (InOutNoticeOrderEo)map1.get(o.getTransferOrderNo())))) {
                    o.setOutNoticeNo(eo.getDocumentNo());
                }
            });
        }
        dtoPageInfo.setList(dtoList);
        this.filterButtonDisplay((PageInfo<CsTransferOrderRespDto>)dtoPageInfo);
        return dtoPageInfo;
    }

    public Map<String, Map<String, Double>> queryInOutResult(List<String> transferNoList) {
        Set in;
        HashMap<String, Map<String, Double>> map = new HashMap<String, Map<String, Double>>(2);
        List resultList = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDomain.filter().in((Object)"relevance_no", transferNoList)).list();
        Map longCodeMap = resultList.stream().collect(Collectors.groupingBy(ReceiveDeliveryResultOrderEo::getOrderType, Collectors.mapping(ReceiveDeliveryResultOrderEo::getDocumentNo, Collectors.toSet())));
        Set out = longCodeMap.get("delivery");
        if (CollectionUtil.isNotEmpty(out)) {
            List outList = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDetailDomain.filter().in((Object)"document_no", out)).list();
            Map<String, Double> finishMap = outList.stream().collect(Collectors.groupingBy(ReceiveDeliveryResultOrderDetailEo::getRelevanceNo, Collectors.summingDouble(c -> c.getQuantity().doubleValue())));
            map.put("delivery", finishMap);
        }
        if (CollectionUtil.isNotEmpty(in = longCodeMap.get("receive"))) {
            List inList = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDetailDomain.filter().in((Object)"document_no", in)).list();
            Map<String, Double> inFinishMap = inList.stream().collect(Collectors.groupingBy(ReceiveDeliveryResultOrderDetailEo::getRelevanceNo, Collectors.summingDouble(c -> c.getQuantity().doubleValue())));
            map.put("receive", inFinishMap);
        }
        return map;
    }

    private ExtQueryChainWrapper<CsTransferOrderEo> getQueryEo(CsTransferOrderQueryDto queryDto) {
        Consumer<QueryWrapper> wrapperConsumer;
        ExtQueryChainWrapper filter = this.csTransferOrderDas.filter();
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getStartTime())) {
            filter.ge((Object)"create_time", (Object)queryDto.getStartTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getEndTime())) {
            filter.le((Object)"create_time", (Object)queryDto.getEndTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getTransferOrderNo())) {
            wrapperConsumer = qw -> {
                qw.like((Object)"transfer_order_no", (Object)queryDto.getTransferOrderNo());
                qw.or();
                qw.like((Object)"pre_order_no", (Object)queryDto.getTransferOrderNo());
                qw.or();
                qw.like((Object)"parent_order_no", (Object)queryDto.getTransferOrderNo());
                qw.or();
                qw.like((Object)"external_sale_order_no", (Object)queryDto.getTransferOrderNo());
                qw.or();
                qw.like((Object)"external_purchase_order_no", (Object)queryDto.getTransferOrderNo());
            };
            filter.and(wrapperConsumer);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getTransferOrderNoList())) {
            wrapperConsumer = qw -> {
                qw.in((Object)"transfer_order_no", (Collection)queryDto.getTransferOrderNoList());
                qw.or();
                qw.in((Object)"pre_order_no", (Collection)queryDto.getTransferOrderNoList());
                qw.or();
                qw.in((Object)"parent_order_no", (Collection)queryDto.getTransferOrderNoList());
            };
            filter.and(wrapperConsumer);
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getOutLogicWarehouseCode())) {
            filter.like((Object)"out_logic_warehouse_code", (Object)queryDto.getOutLogicWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getOutLogicWarehouseName())) {
            filter.like((Object)"out_logic_warehouse_name", (Object)queryDto.getOutLogicWarehouseName());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getInLogicWarehouseCode())) {
            filter.like((Object)"in_logic_warehouse_code", (Object)queryDto.getInLogicWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getInLogicWarehouseName())) {
            filter.like((Object)"in_logic_warehouse_name", (Object)queryDto.getInLogicWarehouseName());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getType())) {
            filter.eq((Object)"type", (Object)queryDto.getType());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getTypeList())) {
            filter.in((Object)"type", (Collection)queryDto.getTypeList());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getOrderStatus())) {
            filter.eq((Object)"order_status", (Object)queryDto.getOrderStatus());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getOrderStatusList())) {
            filter.in((Object)"order_status", (Collection)queryDto.getOrderStatusList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getPreOrderNoList())) {
            filter.in((Object)"pre_order_no", (Collection)queryDto.getPreOrderNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getOutPhysicsWarehouseCodeList())) {
            filter.in((Object)"out_physics_warehouse_code", (Collection)queryDto.getOutPhysicsWarehouseCodeList());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getDispatcherStatus())) {
            filter.in((Object)"dispatcher_status", Arrays.asList(queryDto.getDispatcherStatus(), CsTransferDispatcherStatusEnum.DISPATCHER.getCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getDispatcherHandleStatus())) {
            filter.eq((Object)"dispatcher_handle_status", (Object)queryDto.getDispatcherHandleStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getCreatePerson())) {
            filter.like((Object)"create_person", (Object)queryDto.getCreatePerson());
        }
        filter.orderByDesc((Object)"update_time");
        return filter;
    }

    @Override
    public void updateStatusById(Long id, String status, String remark) {
        logger.info("\u4fee\u6539\u8c03\u62e8\u5355\u72b6\u6001,id:{};status:{}", (Object)id, (Object)status);
        CsTransferOrderEo updateEo = new CsTransferOrderEo();
        updateEo.setId(id);
        updateEo.setOrderStatus(status);
        if (StringUtils.isNotBlank((CharSequence)remark)) {
            updateEo.setRemark(remark);
        }
        this.csTransferOrderDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditTransferOrder(CsAuditReqDto auditReqDto) {
        logger.info("\u5ba1\u6838\u8c03\u62e8\u5355\u5355\u636e:{}", (Object)LogUtils.buildLogContent(auditReqDto));
        String key = "AUDIT_TRANSFER:" + auditReqDto.getBusinessOrderNo();
        this.repeatFilter.checkRepeat(key, () -> this.auditTransferOrder1(auditReqDto), true, "\u64cd\u4f5c\u9891\u7e41\uff0c[" + auditReqDto.getBusinessOrderNo() + "]\u8be5\u5355\u6b63\u5728\u64cd\u4f5c\u5ba1\u6838\u5355\u636e");
    }

    private void auditTransferOrder1(CsAuditReqDto auditReqDto) {
        CsTransferOrderRespDto respDto = this.queryByTransferOrderNo(auditReqDto.getBusinessOrderNo());
        List detailList = ((ExtQueryChainWrapper)this.csTransferOrderDetailDas.filter().eq((Object)"transfer_order_no", (Object)respDto.getTransferOrderNo())).list();
        AssertUtil.isTrue(CollectionUtil.isNotEmpty((Collection)detailList), "\u8c03\u62e8\u5355\u660e\u7ec6\u6570\u636e\u4e0d\u5b58\u5728");
        this.insertAuditLog(auditReqDto.getAuditResult(), auditReqDto.getRemark(), respDto.getTransferOrderNo(), respDto.getType());
        AssertUtil.isTrue(CsTransferOrderEnum.Status.WAIT_AUDIT.getCode().equals(respDto.getOrderStatus()), "\u5355\u636e\u5f53\u524d\u975e\u5f85\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u786e\u8ba4\u540e\u64cd\u4f5c");
        if (CsOtherStorageOrderEnum.AuditEnum.AUDIT_PASS.getCode().equals(auditReqDto.getAuditResult())) {
            logger.info("\u5ba1\u6838\u8c03\u62e8\u5355\u5355\u636e\u901a\u8fc7");
            String status = CsTransferOrderEnum.Status.WAIT_DELIVERY.getCode();
            this.generateDeliveryNoticeOrder(respDto, detailList);
            if (CsPcpBusinessTypeEnum.cAllotList().contains(respDto.getType())) {
                this.updateStatusById(respDto.getId(), status, "");
            }
        } else {
            String status = CsTransferOrderEnum.Status.AUDIT_FAILED.getCode();
            logger.info("\u5ba1\u6838\u8c03\u62e8\u5355\u5355\u636e\u4e0d\u901a\u8fc7,\u91ca\u653e\u9884\u5360\u5e93\u5b58");
            this.rollbackLogicInventory(respDto);
            this.transactionCallBackService.execute(() -> {
                MessageVo messageVo = new MessageVo();
                messageVo.setData((Object)JSON.toJSONString((Object)respDto));
                this.commonsMqService.publishMessage("TRANSFER_AUDIT_FAIL", (Object)messageVo);
            });
            this.updateStatusById(respDto.getId(), status, "");
        }
    }

    private void generateDeliveryNoticeOrder(final CsTransferOrderRespDto respDto, List<CsTransferOrderDetailEo> detailList) {
        logger.info("\u53d1\u8d27\u901a\u77e5generateDeliveryNoticeOrder\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
        if (CsPcpBusinessTypeEnum.ALLOT_ONLY_RECORD.getCode().equals(respDto.getSubType())) {
            return;
        }
        ReceiveDeliveryNoticeOrderFacadeBo facadeBo = this.getReceiveDeliveryNoticeOrderFacadeBo(respDto, detailList);
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode());
        final ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        facadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                context.setTransparentCallback(Boolean.valueOf(true));
                if (context instanceof ReceiveDeliveryNoticeOrderContext) {
                    ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)context;
                    ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = receiveDeliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderEo();
                    receiveDeliveryNoticeOrderEo.setTotalQuantity(respDto.getTotalQuantity());
                    receiveDeliveryNoticeOrderEo.setSourceSystem(respDto.getSourceSystem());
                    if (StringUtils.isEmpty((CharSequence)receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseCode())) {
                        receiveDeliveryNoticeOrderEo.setReceiveLogicWarehouseCode(respDto.getInLogicWarehouseCode());
                        receiveDeliveryNoticeOrderEo.setReceiveLogicWarehouseName(respDto.getInLogicWarehouseName());
                        receiveDeliveryNoticeOrderEo.setReceivePhysicsWarehouseCode(respDto.getInPhysicsWarehouseCode());
                        receiveDeliveryNoticeOrderEo.setReceivePhysicsWarehouseName(respDto.getInPhysicsWarehouseName());
                    }
                    if (StringUtils.isEmpty((CharSequence)receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseCode())) {
                        receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseCode(respDto.getOutLogicWarehouseCode());
                        receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseName(respDto.getOutLogicWarehouseName());
                        receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseCode(respDto.getOutPhysicsWarehouseCode());
                        receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseName(respDto.getOutPhysicsWarehouseName());
                    }
                    ContactDto contactDto = new ContactDto();
                    contactDto.setProvinceCode(respDto.getProvinceCode());
                    contactDto.setProvince(respDto.getProvince());
                    contactDto.setCityCode(respDto.getCityCode());
                    contactDto.setCity(respDto.getCity());
                    contactDto.setDistrictCode(respDto.getAreaCode());
                    contactDto.setDistrict(respDto.getArea());
                    contactDto.setDetailAddress(respDto.getAddress());
                    contactDto.setReciveName(respDto.getContact());
                    contactDto.setRecivePhone(respDto.getContactPhone());
                    contactDto.setRemark(respDto.getRemark());
                    if (StringUtils.isBlank((CharSequence)receiveDeliveryNoticeOrderEo.getExtension())) {
                        receiveDeliveryNoticeOrderEo.setExtension(JSON.toJSONString((Object)contactDto));
                    } else {
                        Map jsonMap = (Map)JSONObject.parseObject((String)receiveDeliveryNoticeOrderEo.getExtension(), Map.class);
                        if (null == jsonMap) {
                            jsonMap = Maps.newHashMap();
                        }
                        jsonMap.putAll((Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)contactDto), Map.class));
                        receiveDeliveryNoticeOrderEo.setExtension(JSONObject.toJSONString((Object)jsonMap));
                    }
                }
                if (context instanceof InOutNoticeOrderContext) {
                    CsOrderBusinessCallBackContext csOrderBusinessCallBackContext = BusinessOrderCallBackParseHelper.parseNoticeCallBack(context);
                    InOutNoticeOrderEo inOutNoticeOrderEo = ((InOutNoticeOrderContext)context).getInOutNoticeOrderEo();
                    List csTransferOrderEos = CsTransferOrderServiceImpl.this.csTransferOrderMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"transfer_order_no", (Object)inOutNoticeOrderEo.getRelevanceNo())).eq((Object)"dr", (Object)YesNoHelper.NO));
                    logger.info("\u5f00\u59cb\u5224\u5b9a\u9500\u552e\u8c03\u62e8\u5355 \u865a\u5165/\u865a\u51fa: {}", (Object)LogUtils.buildLogContent(csTransferOrderEos));
                    if (CollectionUtils.isNotEmpty((Collection)csTransferOrderEos)) {
                        String physicsWarehouseCode = inOutNoticeOrderEo.getOutPhysicsWarehouseCode();
                        logger.info("\u7269\u7406\u4ed3\u7f16\u7801\u4e3a:{}", (Object)physicsWarehouseCode);
                        PhysicsWarehouseEo csPhysicsWarehouseEo = null;
                        if (StringUtils.isNotBlank((CharSequence)physicsWarehouseCode)) {
                            csPhysicsWarehouseEo = (PhysicsWarehouseEo)CsTransferOrderServiceImpl.this.physicsWarehouseDomain.getMapper().selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)physicsWarehouseCode)).eq((Object)"dr", (Object)YesNoHelper.NO));
                            AssertUtil.assertNotNull(csPhysicsWarehouseEo, "\u7269\u7406\u4ed3\u4fe1\u606f\u67e5\u8be2\u65e0\u6548: %s", physicsWarehouseCode);
                        }
                        if (csTransferOrderEos.size() == 1 && StringUtils.equals((CharSequence)((CsTransferOrderEo)csTransferOrderEos.get(0)).getType(), (CharSequence)CsInventorySourceTypeEnum.ALLOT_SALE.getCode())) {
                            if (csOrderBusinessCallBackContext.getInFlag().booleanValue()) {
                                logger.info("\u5224\u5b9a\u4e3a \u9500\u552e\u8c03\u62e8\u5355 \u865a\u5165.........");
                                context.setSendWms(Boolean.FALSE.booleanValue());
                            } else if (Objects.nonNull(csPhysicsWarehouseEo) && YesNoHelper.YES.equals(csPhysicsWarehouseEo.getIsLogistics())) {
                                logger.info("\u5224\u5b9a\u4e3a \u7269\u6d41\u4ed3.........");
                                context.setSendWms(Boolean.FALSE.booleanValue());
                            } else {
                                logger.info("\u5f00\u59cb\u5224\u5b9a \u4e8c\u6b21\u9500\u552e\u8c03\u62e8\u865a\u51fa.........");
                                CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)csTransferOrderEos.get(0);
                                List saleTransferOrderEos = CsTransferOrderServiceImpl.this.csTransferOrderMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"sale_order_no", (Object)csTransferOrderEo.getSaleOrderNo())).in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{CsTransferOrderEnum.Status.WAIT_AUDIT.getCode(), CsTransferOrderEnum.Status.WAIT_DELIVERY.getCode(), CsTransferOrderEnum.Status.FINISH.getCode()}))).eq((Object)"dr", (Object)YesNoHelper.NO));
                                logger.info("\u9500\u552e\u5355\u5173\u8054\u9500\u552e\u8c03\u62e8\u5355\u4fe1\u606f: {}", (Object)LogUtils.buildLogContent(saleTransferOrderEos));
                                if (CollectionUtils.isNotEmpty((Collection)saleTransferOrderEos) && saleTransferOrderEos.size() > 1) {
                                    logger.info("\u5224\u5b9a\u4e3a \u4e8c\u6b21\u9500\u552e\u8c03\u62e8\u865a\u51fa.........");
                                    context.setSendWms(Boolean.FALSE.booleanValue());
                                }
                            }
                        } else if (Objects.nonNull(csPhysicsWarehouseEo) && YesNoHelper.YES.equals(csPhysicsWarehouseEo.getIsLogistics())) {
                            logger.info("\u5224\u5b9a\u4e3a \u9500\u552e\u8c03\u62e8\u8865\u8d27 \u7269\u6d41\u4ed3.........");
                            context.setSendWms(Boolean.FALSE.booleanValue());
                        } else {
                            Boolean sendWms = businessOrderCallBackService.sendWms(inOutNoticeOrderEo);
                            context.setSendWms(sendWms.booleanValue());
                        }
                    } else {
                        Boolean sendWms = businessOrderCallBackService.sendWms(inOutNoticeOrderEo);
                        context.setSendWms(sendWms.booleanValue());
                    }
                }
            }

            public void afterCallBack(BaseOrderBaseContext context) {
                if (context instanceof InOutNoticeOrderContext) {
                    CsOrderBusinessCallBackContext csOrderBusinessCallBackContext = BusinessOrderCallBackParseHelper.parseNoticeCallBack(context);
                    businessOrderCallBackService.inOutNoticeOrderCallBack(csOrderBusinessCallBackContext);
                }
            }
        });
        if (CsPcpBusinessTypeEnum.ALLOT_IN_ONLY.getCode().equals(respDto.getSubType())) {
            facadeBo.setLogicWarehouseCode(respDto.getInLogicWarehouseCode());
            facadeBo.setLogicWarehouseName(respDto.getInLogicWarehouseName());
            facadeBo.setPhysicsWarehouseCode(respDto.getInPhysicsWarehouseCode());
            facadeBo.setPhysicsWarehouseName(respDto.getInPhysicsWarehouseName());
            facadeBo.setRemark(respDto.getRemark());
            this.baseOrderFacade.receiveNoticeOrderGen(facadeBo);
        } else {
            if (CsPcpBusinessTypeEnum.CB_ALLOT.getCode().equals(respDto.getType()) || CsPcpBusinessTypeEnum.CC_ALLOT.getCode().equals(respDto.getType())) {
                facadeBo.setValidNegative(Boolean.valueOf(false));
            }
            facadeBo.setLogicWarehouseCode(respDto.getOutLogicWarehouseCode());
            facadeBo.setLogicWarehouseName(respDto.getOutLogicWarehouseName());
            facadeBo.setPhysicsWarehouseCode(respDto.getOutPhysicsWarehouseCode());
            facadeBo.setPhysicsWarehouseName(respDto.getOutPhysicsWarehouseName());
            this.baseOrderFacade.deliveryNoticeOrderGen(facadeBo);
        }
    }

    @NotNull
    private ReceiveDeliveryNoticeOrderFacadeBo getReceiveDeliveryNoticeOrderFacadeBo(final CsTransferOrderRespDto respDto, List<CsTransferOrderDetailEo> detailList) {
        ReceiveDeliveryNoticeOrderFacadeBo facadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        logger.info("generateDeliveryNoticeOrder==>\u8c03\u62e8\u5355\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,orderNo:{}", (Object)respDto.getTransferOrderNo());
        CubeBeanUtils.copyProperties((Object)facadeBo, (Object)respDto, (String[])new String[0]);
        facadeBo.setPreOrderNo(respDto.getPreOrderNo());
        String externalOrderNo = (String)DataExtractUtils.ifNullElse((Object)respDto.getExternalSaleOrderNo(), (Object)respDto.getPreOrderNo());
        facadeBo.setExternalOrderNo(externalOrderNo);
        facadeBo.setRelevanceNo(respDto.getTransferOrderNo());
        facadeBo.setSourceType(CsInventorySourceTypeEnum.OUT_ALLOT.getCode());
        facadeBo.setBusinessType(respDto.getType());
        facadeBo.setDisplayBusinessType(respDto.getType());
        facadeBo.setTransferInLogicWarehouseCode(respDto.getInLogicWarehouseCode());
        facadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER);
        facadeBo.setRemark(respDto.getRemark());
        if (CsPcpBusinessTypeEnum.BC_EQUAL_ALLOT.getCode().equals(respDto.getType())) {
            facadeBo.setIsSaleOrder(Boolean.valueOf(true));
        }
        List<BaseOrderDetailReqDto> deliveryDetailList = new ArrayList<BaseOrderDetailReqDto>(detailList.size());
        for (CsTransferOrderDetailEo detail : detailList) {
            BaseOrderDetailReqDto basic = new BaseOrderDetailReqDto();
            CubeBeanUtils.copyProperties((Object)basic, (Object)detail, (String[])new String[0]);
            basic.setPreOrderItemId(detail.getId());
            basic.setSkuCode(detail.getLongCode());
            basic.setSkuName(detail.getCargoName());
            basic.setQuantity(detail.getQuantity());
            basic.setBatch(detail.getBatch());
            basic.setVolume(detail.getVolume());
            basic.setPreOrderItemId(detail.getId());
            basic.setExpireTime(detail.getExpireTime());
            basic.setProduceTime(detail.getProduceTime());
            deliveryDetailList.add(basic);
        }
        if (YesNoEnum.YES.getValue().equals(respDto.getNoBatch())) {
            logger.info("generateDeliveryNoticeOrder==>\u5e93\u5b58\u9884\u5360\uff0c\u6ca1\u6709\u6307\u5b9a\u6279\u6b21\u9884\u5360:relevanceNo{}", (Object)facadeBo.getRelevanceNo());
            deliveryDetailList = this.getCsBasicsOrderDetailList(facadeBo.getRelevanceNo(), deliveryDetailList);
            facadeBo.setShoutBatch(Boolean.valueOf(true));
        }
        facadeBo.setOrderBasicsDetailReqDtoList(deliveryDetailList);
        facadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                ReceiveDeliveryNoticeOrderContext context1 = (ReceiveDeliveryNoticeOrderContext)context;
                ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = context1.getReceiveDeliveryNoticeOrderEo();
                receiveDeliveryNoticeOrderEo.setTotalQuantity(respDto.getTotalQuantity());
                receiveDeliveryNoticeOrderEo.setSourceSystem(respDto.getSourceSystem());
                if (StringUtils.isEmpty((CharSequence)receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseCode())) {
                    receiveDeliveryNoticeOrderEo.setReceiveLogicWarehouseCode(respDto.getInLogicWarehouseCode());
                    receiveDeliveryNoticeOrderEo.setReceiveLogicWarehouseName(respDto.getInLogicWarehouseName());
                    receiveDeliveryNoticeOrderEo.setReceivePhysicsWarehouseCode(respDto.getInPhysicsWarehouseCode());
                    receiveDeliveryNoticeOrderEo.setReceivePhysicsWarehouseName(respDto.getInPhysicsWarehouseName());
                }
                if (StringUtils.isEmpty((CharSequence)receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseCode())) {
                    receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseCode(respDto.getOutLogicWarehouseCode());
                    receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseName(respDto.getOutLogicWarehouseName());
                    receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseCode(respDto.getOutPhysicsWarehouseCode());
                    receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseName(respDto.getOutPhysicsWarehouseName());
                }
                ContactDto contactDto = new ContactDto();
                contactDto.setProvinceCode(respDto.getProvinceCode());
                contactDto.setProvince(respDto.getProvince());
                contactDto.setCityCode(respDto.getCityCode());
                contactDto.setCity(respDto.getCity());
                contactDto.setDistrictCode(respDto.getAreaCode());
                contactDto.setDistrict(respDto.getArea());
                contactDto.setDetailAddress(respDto.getAddress());
                contactDto.setReciveName(respDto.getContact());
                contactDto.setRecivePhone(respDto.getContactPhone());
                contactDto.setRemark(respDto.getRemark());
                if (StringUtils.isBlank((CharSequence)receiveDeliveryNoticeOrderEo.getExtension())) {
                    receiveDeliveryNoticeOrderEo.setExtension(JSON.toJSONString((Object)contactDto));
                } else {
                    Map jsonMap = (Map)JSONObject.parseObject((String)receiveDeliveryNoticeOrderEo.getExtension(), Map.class);
                    jsonMap.putAll((Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)contactDto), Map.class));
                    receiveDeliveryNoticeOrderEo.setExtension(JSONObject.toJSONString((Object)jsonMap));
                }
                CsTransferOrderServiceImpl.this.transferOrderWrapperHelper.wrapperTransferOrderDelivery(receiveDeliveryNoticeOrderEo, (CsTransferOrderEo)BeanUtil.copyProperties((Object)respDto, CsTransferOrderEo.class, (String[])new String[0]));
                CsTransferOrderServiceImpl.this.orderPreemptWrapperHelper.copyDeliveryToContext(context1, receiveDeliveryNoticeOrderEo);
            }

            public void afterCallBack(BaseOrderBaseContext context) {
                if (PcpBasicInventoryBusinessTypeEnum.isVirtualTransferOrder((String)respDto.getType())) {
                    context.setCallBack(CsTransferOrderServiceImpl.this.getInNoticeCallBack());
                    context.setTransparentCallback(Boolean.valueOf(true));
                }
            }
        });
        return facadeBo;
    }

    @NotNull
    private BaseOrderCallBack<BaseOrderBaseContext> getInNoticeCallBack() {
        return new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                if (context instanceof InOutNoticeOrderContext) {
                    InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)context;
                    logger.info("\u865a\u62df\u8c03\u62e8\u5355\u4e0d\u63a8\u9001wms");
                    outNoticeOrderContext.setSendWms(false);
                }
            }

            public void afterCallBack(BaseOrderBaseContext context) {
            }
        };
    }

    private List<BaseOrderDetailReqDto> getCsBasicsOrderDetailList(String relevanceNo, List<BaseOrderDetailReqDto> buildList) {
        List<InventoryPreemptionEo> InventoryPreemptionEoList = this.csInventoryPreemptionQueryService.queryPreemptTypeBySourceNo(relevanceNo, CsValidFlagEnum.ENABLE.getCode(), CsWarehouseClassifyEnum.LOGIC.getCode());
        if (CollectionUtils.isNotEmpty(InventoryPreemptionEoList)) {
            Map tradeOrderItemMap = buildList.stream().collect(HashMap::new, (m, v) -> m.put(v.getSkuCode(), v), HashMap::putAll);
            ArrayList<BaseOrderDetailReqDto> detailReqDtoList = new ArrayList<BaseOrderDetailReqDto>();
            for (InventoryPreemptionEo InventoryPreemptionEo2 : InventoryPreemptionEoList) {
                BaseOrderDetailReqDto basic = new BaseOrderDetailReqDto();
                basic.setSkuCode(InventoryPreemptionEo2.getSkuCode());
                basic.setSkuName(InventoryPreemptionEo2.getSkuName());
                basic.setQuantity(InventoryPreemptionEo2.getPreemptNum());
                basic.setBatch(InventoryPreemptionEo2.getBatch());
                BaseOrderDetailReqDto csBasicsOrderDetailReqDto = (BaseOrderDetailReqDto)tradeOrderItemMap.get(InventoryPreemptionEo2.getSkuCode());
                basic.setPreOrderItemId(csBasicsOrderDetailReqDto.getPreOrderItemId());
                basic.setExtension(csBasicsOrderDetailReqDto.getExtension());
                basic.setExpireTime(csBasicsOrderDetailReqDto.getExpireTime());
                basic.setProduceTime(csBasicsOrderDetailReqDto.getProduceTime());
                detailReqDtoList.add(basic);
            }
            return detailReqDtoList;
        }
        return buildList;
    }

    private void rollbackLogicInventory(CsTransferOrderRespDto respDto) {
        if (CsPcpBusinessTypeEnum.ALLOT_IN_ONLY.getCode().equals(respDto.getSubType()) || CsPcpBusinessTypeEnum.ALLOT_ONLY_RECORD.getCode().equals(respDto.getSubType())) {
            return;
        }
        ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
        releasePreemptParam.setSourceNo(respDto.getTransferOrderNo());
        releasePreemptParam.setSourceType(respDto.getType());
        releasePreemptParam.setBusinessType(respDto.getType());
        if (CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(respDto.getType()) || CsPcpBusinessTypeEnum.maiyouBcAllotList().contains(respDto.getType())) {
            releasePreemptParam.setIsSaleOrder(Boolean.TRUE);
        }
        this.calcInventoryService.releasePreempt(releasePreemptParam);
    }

    private void insertAuditLog(String auditResult, String remark, String storageOrderNo, String type) {
        CsStorageAuditRecordEo auditLog = new CsStorageAuditRecordEo();
        auditLog.setAuditResult(auditResult);
        auditLog.setRemark(remark);
        auditLog.setType(type);
        auditLog.setOrderSrcNo(storageOrderNo);
        this.csStorageAuditRecordDas.insert((BaseEo)auditLog);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void closeTransferOrder(String transferOrderNo) {
        logger.info("\u5173\u95ed\u8c03\u62e8\u5355transferOrderNo:{}", (Object)transferOrderNo);
        CsTransferOrderRespDto respDto = this.queryByTransferOrderNo(transferOrderNo);
        List detailList = ((ExtQueryChainWrapper)this.csTransferOrderDetailDas.filter().eq((Object)"transfer_order_no", (Object)respDto.getTransferOrderNo())).list();
        AssertUtil.isTrue(CollectionUtil.isNotEmpty((Collection)detailList), "\u8c03\u62e8\u5355\u660e\u7ec6\u6570\u636e\u4e0d\u5b58\u5728");
        String status = "";
        if (CsTransferOrderEnum.Status.WAIT_AUDIT.getCode().equals(respDto.getOrderStatus())) {
            status = CsTransferOrderEnum.Status.CANCELED.getCode();
        } else if (CsTransferOrderEnum.Status.WAIT_DELIVERY.getCode().equals(respDto.getOrderStatus())) {
            status = CsTransferOrderEnum.Status.CANCELED.getCode();
            this.updateDeliveryNoticeOrder(transferOrderNo, new HashMap<String, BigDecimal>());
            this.selectAndUpdateOutNoticeOrder(transferOrderNo, BaseOrderStatusEnum.ONO_CANCEL.getCode(), new HashMap<String, BigDecimal>());
        } else if (CsTransferOrderEnum.Status.PORTION_DELIVERY.getCode().equals(respDto.getOrderStatus())) {
            Map<String, BigDecimal> releaseItemMap = this.queryReleaseItem(detailList, transferOrderNo);
            this.updateDeliveryNoticeOrder(transferOrderNo, releaseItemMap);
            this.selectAndUpdateOutNoticeOrder(transferOrderNo, BaseOrderStatusEnum.ONO_CANCEL.getCode(), releaseItemMap);
            status = CsTransferOrderEnum.Status.CLOSED.getCode();
        }
        this.rollbackLogicInventory(respDto);
        this.updateStatusById(respDto.getId(), status, "");
    }

    private Map<String, BigDecimal> queryReleaseItem(List<CsTransferOrderDetailEo> detailList, String transferOrderNo) {
        List resultList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).list();
        return this.compareAndGetReleaseItem(detailList, resultList);
    }

    private void selectAndUpdateOutNoticeOrder(String transferOrderNo, String status, Map<String, BigDecimal> releaseItemMap) {
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).one();
        if (outNoticeOrderEo != null) {
            outNoticeOrderEo.setOrderStatus(status);
            this.updateOutNoticeOrder(outNoticeOrderEo, releaseItemMap);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelTransferOrder(CsCancelTransferOrderReqDto cancelTransferOrder) {
        logger.info("\u53d6\u6d88\u8c03\u62e8\u5355cancelTransferOrder,{}", (Object)LogUtils.buildLogContent(cancelTransferOrder));
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)cancelTransferOrder)).one();
        AssertUtil.isTrue(Objects.nonNull(outNoticeOrderEo), "\u51fa\u5e93\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        if (BaseOrderStatusEnum.ONO_CANCEL.getCode().equals(outNoticeOrderEo.getOrderStatus())) {
            return;
        }
        String transferOrderStatus = CsTransferOrderEnum.Status.CANCELED.getCode();
        String transferOrderNo = outNoticeOrderEo.getRelevanceNo();
        CsTransferOrderRespDto transfer = this.queryByTransferOrderNo(transferOrderNo);
        if (BaseOrderStatusEnum.ONO_PORTION_OUT.getCode().equals(outNoticeOrderEo.getOrderStatus())) {
            transferOrderStatus = CsTransferOrderEnum.Status.FINISH.getCode();
            List detailList = ((ExtQueryChainWrapper)this.csTransferOrderDetailDas.filter().eq((Object)"transfer_order_no", (Object)transfer.getTransferOrderNo())).list();
            AssertUtil.isTrue(CollectionUtil.isNotEmpty((Collection)detailList), "\u8c03\u62e8\u5355\u660e\u7ec6\u6570\u636e\u4e0d\u5b58\u5728");
            List resultOrderDetail = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"pre_order_no", (Object)cancelTransferOrder.getOutNoticeNo())).list();
            Map<String, BigDecimal> releaseItemMap = this.compareAndGetReleaseItem(detailList, resultOrderDetail);
            List<CsTransferOrderDetailEo> rollBackList = this.covertToRollbackList(detailList, releaseItemMap);
            this.rollbackLogicInventory(transfer);
            this.updateDeliveryNoticeOrder(transfer.getTransferOrderNo(), releaseItemMap);
            outNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.ONO_CANCEL.getCode());
            this.updateOutNoticeOrder(outNoticeOrderEo, releaseItemMap);
        } else {
            this.updateDeliveryNoticeOrder(transfer.getTransferOrderNo(), new HashMap<String, BigDecimal>());
            outNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.ONO_CANCEL.getCode());
            this.updateOutNoticeOrder(outNoticeOrderEo, new HashMap<String, BigDecimal>());
        }
        this.csUpdatePreemptServer.updateLogicPreemptRecord(CsWarehouseClassifyEnum.LOGIC.getCode(), Arrays.asList(transfer.getTransferOrderNo(), transfer.getExternalSaleOrderNo()), false, new ArrayList<CsDeliveryReceiveResultDetailRespDto>());
        this.updateStatusById(transfer.getId(), transferOrderStatus, cancelTransferOrder.getRemark());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelNoAuditTransferOrder(CsCancelTransferOrderReqDto cancelTransferOrder) {
        logger.info("\u53d6\u6d88\u8c03\u62e8\u5355(eas\u6216\u8005pcp\u53d1\u8d77\u53d6\u6d88\u3001\u53cd\u5ba1\u6838),keyword:{}", (Object)cancelTransferOrder.getKeyWord());
        QueryWrapper queryWrapper = new QueryWrapper();
        Consumer<QueryWrapper> queryWrapper2 = qw -> {
            qw.eq((Object)"transfer_order_no", (Object)cancelTransferOrder.getKeyWord());
            qw.or();
            qw.eq((Object)"pre_order_no", (Object)cancelTransferOrder.getKeyWord());
        };
        queryWrapper.and(queryWrapper2);
        queryWrapper.eq((Object)"dr", (Object)0);
        List transferOrderEoList = this.csTransferOrderMapper.selectList((Wrapper)queryWrapper);
        AssertUtil.isTrue(CollectionUtil.isNotEmpty((Collection)transferOrderEoList), "\u8c03\u62e8\u5355\u6570\u636e\u4e0d\u5b58\u5728");
        for (CsTransferOrderEo transferOrderEo : transferOrderEoList) {
            AssertUtil.isTrue(CsTransferOrderEnum.Status.WAIT_AUDIT.getCode().equals(transferOrderEo.getOrderStatus()), "\u5355\u636e\u72b6\u6001\u53ea\u80fd\u662f\u3010\u5f85\u5ba1\u6838\u3011\u72b6\u6001");
            transferOrderEo.setOrderStatus(CsTransferOrderEnum.Status.CANCELED.getCode());
            this.csTransferOrderMapper.updateById((BaseEo)transferOrderEo);
            CsTransferOrderRespDto respDto = new CsTransferOrderRespDto();
            DtoHelper.eo2Dto((BaseEo)transferOrderEo, (BaseVo)respDto);
            this.rollbackLogicInventory(respDto);
        }
    }

    private void updateOutNoticeOrder(InOutNoticeOrderEo outNoticeOrderEo, Map<String, BigDecimal> releaseItemMap) {
        logger.info("\u4fee\u6539\u51fa\u5165\u5e93\u901a\u77e5\u5355updateOutNoticeOrder");
        InOutNoticeOrderEo update = new InOutNoticeOrderEo();
        update.setId(outNoticeOrderEo.getId());
        update.setOrderStatus(outNoticeOrderEo.getOrderStatus());
        this.inOutNoticeOrderDomain.updateSelective((BaseEo)update);
        List outNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)outNoticeOrderEo.getDocumentNo())).list();
        if (CollectionUtil.isNotEmpty(releaseItemMap)) {
            for (InOutNoticeOrderDetailEo outNoticeOrderDetailEo : outNoticeOrderDetailEoList) {
                outNoticeOrderDetailEo.setCancelQuantity(releaseItemMap.get(outNoticeOrderDetailEo.getSkuCode()));
                outNoticeOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
            }
        } else {
            for (InOutNoticeOrderDetailEo outNoticeOrderDetailEo : outNoticeOrderDetailEoList) {
                outNoticeOrderDetailEo.setCancelQuantity(outNoticeOrderDetailEo.getPlanQuantity());
                outNoticeOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
            }
        }
        outNoticeOrderDetailEoList.forEach(out -> {
            InOutNoticeOrderDetailEo outUpdate = new InOutNoticeOrderDetailEo();
            outUpdate.setId(out.getId());
            outUpdate.setCancelQuantity(out.getCancelQuantity());
            outUpdate.setWaitQuantity(out.getWaitQuantity());
            this.inOutNoticeOrderDetailDomain.updateSelective((BaseEo)out);
        });
    }

    private void updateDeliveryNoticeOrder(String transferOrderNo, Map<String, BigDecimal> releaseItemMap) {
        logger.info("\u4fee\u6539\u6536\u53d1\u8d27\u901a\u77e5\u5355updateDeliveryNoticeOrder");
        ReceiveDeliveryNoticeOrderEo delivery = (ReceiveDeliveryNoticeOrderEo)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).one();
        if (delivery != null) {
            ReceiveDeliveryNoticeOrderEo update = new ReceiveDeliveryNoticeOrderEo();
            update.setId(delivery.getId());
            update.setOrderStatus(BaseOrderStatusEnum.ONO_CANCEL.getCode());
            this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)update);
            List deliveryList = ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)delivery.getDocumentNo())).list();
            if (CollectionUtil.isNotEmpty(releaseItemMap)) {
                for (ReceiveDeliveryNoticeOrderDetailEo deliveryNoticeOrderDetailEo : deliveryList) {
                    deliveryNoticeOrderDetailEo.setCancelQuantity(releaseItemMap.get(deliveryNoticeOrderDetailEo.getSkuCode()));
                    deliveryNoticeOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
                }
            } else {
                for (ReceiveDeliveryNoticeOrderDetailEo deliveryNoticeOrderDetailEo : deliveryList) {
                    deliveryNoticeOrderDetailEo.setCancelQuantity(deliveryNoticeOrderDetailEo.getPlanQuantity());
                    deliveryNoticeOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
                }
            }
            deliveryList.forEach(d -> {
                ReceiveDeliveryNoticeOrderDetailEo deliveryUpdate = new ReceiveDeliveryNoticeOrderDetailEo();
                deliveryUpdate.setId(d.getId());
                deliveryUpdate.setCancelQuantity(d.getCancelQuantity());
                deliveryUpdate.setWaitQuantity(d.getWaitQuantity());
                this.receiveDeliveryNoticeOrderDetailDomain.updateSelective((BaseEo)deliveryUpdate);
            });
        }
    }

    private List<CsTransferOrderDetailEo> covertToRollbackList(List<CsTransferOrderDetailEo> detailList, Map<String, BigDecimal> releaseItemMap) {
        ArrayList<CsTransferOrderDetailEo> rollBackList = new ArrayList<CsTransferOrderDetailEo>(releaseItemMap.size());
        Map<String, CsTransferOrderDetailEo> detailEoMap = detailList.stream().collect(Collectors.toMap(CsTransferOrderDetailEo::getLongCode, c -> c));
        releaseItemMap.forEach((key, value) -> {
            CsTransferOrderDetailEo csTransferOrderDetailEo = (CsTransferOrderDetailEo)detailEoMap.get(key);
            csTransferOrderDetailEo.setQuantity(value);
            rollBackList.add(csTransferOrderDetailEo);
        });
        return rollBackList;
    }

    private Map<String, BigDecimal> compareAndGetReleaseItem(List<CsTransferOrderDetailEo> detailList, List<InOutResultOrderDetailEo> resultOrderDetail) {
        logger.info("compareAndGetReleaseItem");
        HashMap<String, BigDecimal> releaseItemMap = new HashMap<String, BigDecimal>();
        Map<String, Double> transferDetailMap = detailList.stream().collect(Collectors.groupingBy(CsTransferOrderDetailEo::getLongCode, Collectors.summingDouble(c -> c.getQuantity().doubleValue())));
        if (CollectionUtil.isNotEmpty(resultOrderDetail)) {
            Map<String, Double> resultDetailMap = resultOrderDetail.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode, Collectors.summingDouble(c -> c.getQuantity().doubleValue())));
            transferDetailMap.forEach((key, value) -> {
                Double resultNum = (Double)resultDetailMap.get(key);
                if (resultNum != null) {
                    if (!value.equals(resultNum)) {
                        releaseItemMap.put((String)key, new BigDecimal(value - resultNum));
                    }
                } else {
                    releaseItemMap.put((String)key, new BigDecimal((double)value));
                }
            });
        } else {
            transferDetailMap.forEach((key, value) -> releaseItemMap.put((String)key, new BigDecimal((double)value)));
        }
        return releaseItemMap;
    }

    private void filterButtonDisplay(PageInfo<CsTransferOrderRespDto> dtoPageInfo) {
        List list = dtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List inLogicWarehouseList = list.stream().map(CsTransferOrderRespDto::getInLogicWarehouseCode).collect(Collectors.toList());
        List outLogicWarehouseList = list.stream().map(CsTransferOrderRespDto::getOutLogicWarehouseCode).collect(Collectors.toList());
        ArrayList warehouseCodeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(inLogicWarehouseList)) {
            warehouseCodeList.addAll(inLogicWarehouseList);
        }
        if (CollectionUtils.isNotEmpty(outLogicWarehouseList)) {
            warehouseCodeList.addAll(outLogicWarehouseList);
        }
        logger.info("filterButtonDisplay==>warehouseCodeList:{}", (Object)LogUtils.buildLogContent(warehouseCodeList));
        List csLogicWarehouseEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", (Collection)warehouseCodeList)).eq((Object)"warehouse_status", (Object)CsLogicWarehouseStatusEnum.ENABLE.getCode())).list();
        logger.info("filterButtonDisplay==>csLogicWarehouseEoList:{}", (Object)LogUtils.buildLogContent(csLogicWarehouseEoList));
        if (CollectionUtils.isEmpty((Collection)csLogicWarehouseEoList)) {
            return;
        }
        Map logicWarehouseEoMap = csLogicWarehouseEoList.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity()));
        for (CsTransferOrderRespDto orderRespDto : list) {
            String inLogicWarehouseCode = orderRespDto.getInLogicWarehouseCode();
            LogicWarehouseEo inLogicWarehouse = (LogicWarehouseEo)logicWarehouseEoMap.get(inLogicWarehouseCode);
            orderRespDto.setDisableReceiveButton(Boolean.TRUE);
            if (null != inLogicWarehouse) {
                Integer warehouseCorrespondingSystem = inLogicWarehouse.getInterconnectionFlag();
                if (YesNoEnum.YES.getValue().equals(warehouseCorrespondingSystem)) {
                    orderRespDto.setDisableReceiveButton(Boolean.FALSE);
                }
            }
            String outLogicWarehouseCode = orderRespDto.getOutLogicWarehouseCode();
            LogicWarehouseEo outLogicWarehouse = (LogicWarehouseEo)logicWarehouseEoMap.get(outLogicWarehouseCode);
            orderRespDto.setDisableDeliveryButton(Boolean.TRUE);
            if (null != outLogicWarehouse) {
                Integer warehouseCorrespondingSystem = outLogicWarehouse.getInterconnectionFlag();
                if (YesNoEnum.YES.getValue().equals(warehouseCorrespondingSystem)) {
                    orderRespDto.setDisableDeliveryButton(Boolean.FALSE);
                }
            }
            orderRespDto.setAllOutFlag(Boolean.valueOf(orderRespDto.getDoneOutQuantity().compareTo(orderRespDto.getTotalQuantity()) >= 0));
        }
        logger.info("filterButtonDisplay==>\u8fc7\u6ee4\u7b5b\u9009\u540elist:{}", (Object)LogUtils.buildLogContent(list));
    }

    private Map<String, PcpItemRespDto> queryItemInfo(List<String> longCodes) {
        try {
            logger.info("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(longCodes));
            if (CollectionUtils.isEmpty(longCodes)) {
                return new HashMap<String, PcpItemRespDto>();
            }
            List itemList = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(longCodes));
            if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                return itemList.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, entity -> entity));
            }
            return new HashMap<String, PcpItemRespDto>();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

