/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.IGenerateCodeService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsReceiveNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInNoticeOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsReceiveNoticeOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsReceiveNoticeOrderRespDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csInNoticeOrderService")
public class CsInNoticeOrderServiceImpl
implements ICsInNoticeOrderService {
    private static final Logger logger = LoggerFactory.getLogger(CsInNoticeOrderServiceImpl.class);
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    IInOutNoticeOrderDetailDomain iInOutNoticeOrderDetailDomain;
    @Resource
    private ICsReceiveNoticeOrderQueryService csReceiveNoticeOrderQueryService;
    @Resource
    private ICsRelWarehouseQueryService csRelWarehouseQueryService;
    @Resource
    private SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    private RepeatFilter repeatFilter;

    @Override
    public Long add(CsInNoticeOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InOutNoticeOrderEo insertEo = new InOutNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.inOutNoticeOrderDomain.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsInNoticeOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InOutNoticeOrderEo updateEo = new InOutNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.inOutNoticeOrderDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        InOutNoticeOrderEo eo = (InOutNoticeOrderEo)this.inOutNoticeOrderDomain.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        this.inOutNoticeOrderDomain.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createInNoticeOrder(String relevanceNo) {
        logger.info("\u6839\u636e\u6536\u8d27\u901a\u77e5\u5355\u53f7\uff0c\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\uff1a[relevanceNo:{}]", (Object)relevanceNo);
        this.repeatFilter.checkRepeat("InNotice:" + relevanceNo, () -> this.preValid(relevanceNo), true);
        CsReceiveNoticeOrderRespDto dto = this.csReceiveNoticeOrderQueryService.queryByDocumentNo(relevanceNo);
        List<RelWarehouseEo> csRelWarehouseEos = this.csRelWarehouseQueryService.queryByRefWarehouseCode(dto.getWarehouseCode(), dto.getWarehouseClassify());
        for (RelWarehouseEo relWarehouseEo : csRelWarehouseEos) {
            if (!CsWarehouseClassifyEnum.PHYSICS.getCode().equals(relWarehouseEo.getWarehouseClassify())) continue;
            dto.setWarehouseId(relWarehouseEo.getWarehouseId());
            dto.setWarehouseCode(relWarehouseEo.getWarehouseCode());
            dto.setWarehouseName(relWarehouseEo.getWarehouseName());
        }
        InOutNoticeOrderEo csInNoticeOrderEo = new InOutNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)csInNoticeOrderEo, (Object)dto, (String[])new String[]{"id"});
        String orderNo = this.generateCode();
        String orderStatus = BaseOrderStatusEnum.RECEIVE_WAIT_RECEIVE.getCode();
        csInNoticeOrderEo.setDocumentNo(orderNo);
        csInNoticeOrderEo.setOrderStatus(orderStatus);
        csInNoticeOrderEo.setRelevanceNo(relevanceNo);
        csInNoticeOrderEo.setExternalOrderNo(dto.getExternalOrderNo());
        csInNoticeOrderEo.setExtension(JSON.toJSONString((Object)dto.getContactDto()));
        this.inOutNoticeOrderDomain.insert((BaseEo)csInNoticeOrderEo);
        if (CollectionUtils.isNotEmpty((Collection)dto.getReceiveNoticeOrderDetailRespDtoList())) {
            ArrayList detailEoList = Lists.newArrayList();
            for (CsReceiveNoticeOrderDetailRespDto detailRespDto : dto.getReceiveNoticeOrderDetailRespDtoList()) {
                InOutNoticeOrderDetailEo detailEo = new InOutNoticeOrderDetailEo();
                CubeBeanUtils.copyProperties((Object)detailEo, (Object)dto, (String[])new String[]{"id"});
                CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailRespDto, (String[])new String[]{"id"});
                detailEo.setDocumentNo(orderNo);
                detailEo.setRelevanceNo(relevanceNo);
                detailEoList.add(detailEo);
            }
            this.iInOutNoticeOrderDetailDomain.insertBatch((List)detailEoList);
        }
        logger.info("\u6839\u636e\u6536\u8d27\u901a\u77e5\u5355\u53f7\uff0c\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\uff0c\u7ed3\u679c\uff1a[id:{}]", (Object)csInNoticeOrderEo.getId());
        return csInNoticeOrderEo.getId();
    }

    private void preValid(String relevanceNo) {
        List oldList = this.inOutNoticeOrderDomain.queryByRelevanceNo(relevanceNo);
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (InOutNoticeOrderEo noticeOrderEo : oldList) {
                AssertUtil.isTrue(BaseOrderStatusEnum.DELIVERY_CANCEL.getCode().equals(noticeOrderEo.getOrderStatus()), "304", noticeOrderEo.getPreOrderNo() + "\u5df2\u5b58\u5728\u6d41\u8f6c\u6b63\u5e38\u7684\u524d\u7f6e\u5355\u636e");
            }
        }
    }

    private String generateCode() {
        IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.IN_NOTICE_ORDER.getCode());
        return generateCodeService.getCode();
    }
}

