/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.ICsRelWarehouseShipmentQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.other.CsRelWarehouseShipmentDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsRelWarehouseShipmentEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsShipmenetEnterpriseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsRelWarehouseShipmentMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsShipmenetEnterpriseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsRelWarehouseShipmentPageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsRelWarehouseShipmentParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsRelWarehouseShipmentDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsRelWarehouseShipmentPageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsRelWarehouseShipmentParticularsRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsRelWarehouseShipmentRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csRelWarehouseShipmentQueryService")
public class CsRelWarehouseShipmentQueryServiceImpl
implements ICsRelWarehouseShipmentQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsRelWarehouseShipmentQueryServiceImpl.class);
    @Autowired
    private CsRelWarehouseShipmentDas csRelWarehouseShipmentDas;
    @Autowired
    private CsRelWarehouseShipmentMapper csRelWarehouseShipmentMapper;
    @Autowired
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    private CsShipmenetEnterpriseMapper csShipmenetEnterpriseMapper;

    @Override
    public CsRelWarehouseShipmentEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        return (CsRelWarehouseShipmentEo)this.csRelWarehouseShipmentDas.selectByPrimaryKey(id);
    }

    @Override
    public CsRelWarehouseShipmentParticularsRespDto queryByWarehouseCode(String warehouseCode) {
        logger.info("queryByWarehouseCode==>\u6839\u636e\u4ed3\u5e93\u7f16\u7801\u5220\u9664\u4ed3\u5e93\u7269\u6d41\u7ba1\u7406\u4fe1\u606f,warehouseCode:{}", (Object)warehouseCode);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseCode), "\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper csRelWarehouseShipmentEoQueryWrapper = new QueryWrapper();
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        csRelWarehouseShipmentEoQueryWrapper.orderByAsc((Object)"shipment_priority");
        List csRelWarehouseShipmentEoList = this.csRelWarehouseShipmentMapper.selectList((Wrapper)csRelWarehouseShipmentEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csRelWarehouseShipmentEoList)) {
            return new CsRelWarehouseShipmentParticularsRespDto();
        }
        CsRelWarehouseShipmentParticularsRespDto relWarehouseShipmentPageRespDto = new CsRelWarehouseShipmentParticularsRespDto();
        CsRelWarehouseShipmentEo csRelWarehouseShipmentEo = (CsRelWarehouseShipmentEo)csRelWarehouseShipmentEoList.get(0);
        relWarehouseShipmentPageRespDto.setId(csRelWarehouseShipmentEo.getId());
        relWarehouseShipmentPageRespDto.setWarehouseCode(csRelWarehouseShipmentEo.getWarehouseCode());
        relWarehouseShipmentPageRespDto.setWarehouseName(csRelWarehouseShipmentEo.getWarehouseName());
        ArrayList detailRespDtoList = Lists.newArrayList();
        for (CsRelWarehouseShipmentEo relWarehouseShipmentEo : csRelWarehouseShipmentEoList) {
            CsRelWarehouseShipmentDetailRespDto detailRespDto = new CsRelWarehouseShipmentDetailRespDto();
            detailRespDto.setId(relWarehouseShipmentEo.getId());
            detailRespDto.setShipmentEnterpriseCode(relWarehouseShipmentEo.getShipmentEnterpriseCode());
            detailRespDto.setShipmentEnterpriseName(relWarehouseShipmentEo.getShipmentEnterpriseName());
            detailRespDto.setShipmentPriority(relWarehouseShipmentEo.getShipmentPriority());
            detailRespDtoList.add(detailRespDto);
        }
        relWarehouseShipmentPageRespDto.setDetailRespDtoList((List)detailRespDtoList);
        this.filterDisableShipmentInfo(relWarehouseShipmentPageRespDto);
        return relWarehouseShipmentPageRespDto;
    }

    private void filterDisableShipmentInfo(CsRelWarehouseShipmentParticularsRespDto relWarehouseShipmentPageRespDto) {
        logger.info("filterDisableShipmentInfo==>\u8fc7\u6ee4\u5df2\u7ecf\u7981\u7528\u7684\u7269\u6d41\u5546\u4fe1\u606f,relWarehouseShipmentPageRespDto:{}", (Object)LogUtils.buildLogContent(relWarehouseShipmentPageRespDto));
        List detailRespDtoList = relWarehouseShipmentPageRespDto.getDetailRespDtoList();
        if (CollectionUtils.isEmpty((Collection)detailRespDtoList)) {
            return;
        }
        List shipmentEnterpriceCodeList = detailRespDtoList.stream().map(CsRelWarehouseShipmentDetailRespDto::getShipmentEnterpriseCode).collect(Collectors.toList());
        QueryWrapper csShipmenetEnterpriseEoQueryWrapper = new QueryWrapper();
        csShipmenetEnterpriseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csShipmenetEnterpriseEoQueryWrapper.in((Object)"shipment_enterprise_code", shipmentEnterpriceCodeList);
        csShipmenetEnterpriseEoQueryWrapper.eq((Object)"shipment_enterprise_status", (Object)YesNoEnum.YES.getValue());
        List csShipmenetEnterpriseEoList = this.csShipmenetEnterpriseMapper.selectList((Wrapper)csShipmenetEnterpriseEoQueryWrapper);
        logger.info("filterDisableShipmentInfo==>\u8fc7\u6ee4\u5df2\u7ecf\u7981\u7528\u7684\u7269\u6d41\u5546\u4fe1\u606f,csShipmenetEnterpriseEoList:{}", (Object)LogUtils.buildLogContent(csShipmenetEnterpriseEoList));
        if (CollectionUtils.isEmpty((Collection)csShipmenetEnterpriseEoList)) {
            relWarehouseShipmentPageRespDto.setDetailRespDtoList(null);
            return;
        }
        Map shipmentEnterpriseEoMap = csShipmenetEnterpriseEoList.stream().collect(Collectors.toMap(CsShipmenetEnterpriseEo::getShipmentEnterpriseCode, Function.identity()));
        ArrayList filterList = Lists.newArrayList();
        for (CsRelWarehouseShipmentDetailRespDto detailRespDto : detailRespDtoList) {
            String shipmentEnterpriseCode = detailRespDto.getShipmentEnterpriseCode();
            CsShipmenetEnterpriseEo csShipmenetEnterpriseEo = (CsShipmenetEnterpriseEo)shipmentEnterpriseEoMap.get(shipmentEnterpriseCode);
            if (null == csShipmenetEnterpriseEo) continue;
            filterList.add(detailRespDto);
        }
        relWarehouseShipmentPageRespDto.setDetailRespDtoList((List)filterList);
        logger.info("filterDisableShipmentInfo==>\u6700\u7ec8\u8fc7\u6ee4\u540e\u7684\u4fe1\u606f,relWarehouseShipmentPageRespDto:{}", (Object)LogUtils.buildLogContent(relWarehouseShipmentPageRespDto));
    }

    @Override
    public PageInfo<CsRelWarehouseShipmentPageRespDto> queryPage(CsRelWarehouseShipmentPageQueryDto relWarehouseShipmentPageQueryDto) {
        logger.info("queryPage==>\u5217\u8868\u5206\u9875\u67e5\u8be2,relWarehouseShipmentPageQueryDto:{}", (Object)LogUtils.buildLogContent(relWarehouseShipmentPageQueryDto));
        AssertUtil.isTrue(null != relWarehouseShipmentPageQueryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != relWarehouseShipmentPageQueryDto.getPageNum() && relWarehouseShipmentPageQueryDto.getPageNum() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != relWarehouseShipmentPageQueryDto.getPageSize() && relWarehouseShipmentPageQueryDto.getPageSize() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        PageHelper.startPage((int)relWarehouseShipmentPageQueryDto.getPageNum(), (int)relWarehouseShipmentPageQueryDto.getPageSize());
        List resultList = this.csRelWarehouseShipmentMapper.queryList(relWarehouseShipmentPageQueryDto);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return new PageInfo();
        }
        PageInfo selectPage = new PageInfo(resultList);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList csChannelWarehouseRespDtoList = Lists.newArrayList();
        for (CsRelWarehouseShipmentEo relWarehouseShipmentEo : resultList) {
            CsRelWarehouseShipmentPageRespDto relWarehouseShipmentPageRespDto = new CsRelWarehouseShipmentPageRespDto();
            relWarehouseShipmentPageRespDto.setId(relWarehouseShipmentEo.getId());
            relWarehouseShipmentPageRespDto.setWarehouseCode(relWarehouseShipmentEo.getWarehouseCode());
            relWarehouseShipmentPageRespDto.setWarehouseName(relWarehouseShipmentEo.getWarehouseName());
            csChannelWarehouseRespDtoList.add(relWarehouseShipmentPageRespDto);
        }
        pageInfo.setList((List)csChannelWarehouseRespDtoList);
        return pageInfo;
    }

    @Override
    public List<CsRelWarehouseShipmentPageRespDto> queryRelInfoList(CsRelWarehouseShipmentPageQueryDto relWarehouseShipmentPageQueryDto) {
        List csLogicWarehouseEoList;
        logger.info("queryRelInfoList==>\u67e5\u8be2\u53ef\u7528\u7684\u7269\u6d41\u5546\u4ed3\u5e93\u96c6\u5408,relWarehouseShipmentPageQueryDto:{}", (Object)LogUtils.buildLogContent(relWarehouseShipmentPageQueryDto));
        List eoList = this.csRelWarehouseShipmentMapper.queryList(relWarehouseShipmentPageQueryDto);
        QueryWrapper csLogicWarehouseEoQueryWrapper = new QueryWrapper();
        csLogicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csLogicWarehouseEoQueryWrapper.eq((Object)"warehouse_status", (Object)CsValidFlagEnum.ENABLE.getCode());
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            List warehouseCodeList = eoList.stream().map(CsRelWarehouseShipmentEo::getWarehouseCode).collect(Collectors.toList());
            csLogicWarehouseEoQueryWrapper.notIn((Object)"warehouse_code", warehouseCodeList);
        }
        if (CollectionUtils.isEmpty((Collection)(csLogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)csLogicWarehouseEoQueryWrapper)))) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        for (LogicWarehouseEo csLogicWarehouseEo : csLogicWarehouseEoList) {
            CsRelWarehouseShipmentPageRespDto respDto = new CsRelWarehouseShipmentPageRespDto();
            respDto.setId(csLogicWarehouseEo.getId());
            respDto.setWarehouseCode(csLogicWarehouseEo.getWarehouseCode());
            respDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
            resultList.add(respDto);
        }
        return resultList;
    }

    @Override
    public List<CsRelWarehouseShipmentRespDto> queryByParam(CsRelWarehouseShipmentParamQueryDto relWarehouseShipmentParamQueryDto) {
        logger.info("queryByParam==>\u591a\u6761\u4ef6\u67e5\u8be2,relWarehouseShipmentParamQueryDto:{}", (Object)LogUtils.buildLogContent(relWarehouseShipmentParamQueryDto));
        if (null == relWarehouseShipmentParamQueryDto) {
            return Lists.newArrayList();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        this.buildQueryWrapper((QueryWrapper<CsRelWarehouseShipmentEo>)queryWrapper, relWarehouseShipmentParamQueryDto);
        List csRelWarehouseShipmentEoList = this.csRelWarehouseShipmentMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)csRelWarehouseShipmentEoList)) {
            return Lists.newArrayList();
        }
        ArrayList relWarehouseShipmentRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)relWarehouseShipmentRespDtoList, (Collection)csRelWarehouseShipmentEoList, CsRelWarehouseShipmentRespDto.class);
        return relWarehouseShipmentRespDtoList;
    }

    @Override
    public CsRelWarehouseShipmentDetailRespDto queryHighestPriorityByWarehouseCode(String warehouseCode) {
        logger.info("queryHighestPriorityByWarehouseCode==>\u6839\u636e\u4ed3\u5e93\u7f16\u7801\u67e5\u8be2\u4ed3\u5e93\u7269\u6d41\u8be6\u60c5\u4fe1\u606f,\u83b7\u53d6\u4f18\u5148\u7ea7\u6700\u9ad8\u7684,warehouseCode:{}", (Object)warehouseCode);
        CsRelWarehouseShipmentParticularsRespDto csRelWarehouseShipmentParticularsRespDto = this.queryByWarehouseCode(warehouseCode);
        logger.info("queryHighestPriorityByWarehouseCode==>\u4ed3\u5e93\u7269\u6d41\u4fe1\u606f\u83b7\u53d6\u4f18\u5148\u7ea7\u6700\u9ad8\u7684,\u67e5\u8be2csRelWarehouseShipmentParticularsRespDto:{}", (Object)LogUtils.buildLogContent(csRelWarehouseShipmentParticularsRespDto));
        List detailRespDtoList = csRelWarehouseShipmentParticularsRespDto.getDetailRespDtoList();
        if (CollectionUtils.isEmpty((Collection)detailRespDtoList)) {
            return null;
        }
        List sortedList = detailRespDtoList.stream().sorted(Comparator.comparing(CsRelWarehouseShipmentDetailRespDto::getShipmentPriority)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sortedList)) {
            return null;
        }
        return (CsRelWarehouseShipmentDetailRespDto)sortedList.get(0);
    }

    private void buildQueryWrapper(QueryWrapper<CsRelWarehouseShipmentEo> queryWrapper, CsRelWarehouseShipmentParamQueryDto relWarehouseShipmentParamQueryDto) {
        Integer shipmentPriority;
        List shipmentEnterpriseCodeList;
        String shipmentEnterpriseCode;
        List warehouseCodeList;
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        queryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        String warehouseCode = relWarehouseShipmentParamQueryDto.getWarehouseCode();
        if (StringUtils.isNotBlank((CharSequence)warehouseCode)) {
            queryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        }
        if (CollectionUtils.isNotEmpty((Collection)(warehouseCodeList = relWarehouseShipmentParamQueryDto.getWarehouseCodeList()))) {
            queryWrapper.in((Object)"warehouse_code", (Collection)warehouseCodeList);
        }
        if (StringUtils.isNotBlank((CharSequence)(shipmentEnterpriseCode = relWarehouseShipmentParamQueryDto.getShipmentEnterpriseCode()))) {
            queryWrapper.eq((Object)"shipment_enterprise_code", (Object)shipmentEnterpriseCode);
        }
        if (CollectionUtils.isNotEmpty((Collection)(shipmentEnterpriseCodeList = relWarehouseShipmentParamQueryDto.getShipmentEnterpriseCodeList()))) {
            queryWrapper.in((Object)"shipment_enterprise_code", (Collection)shipmentEnterpriseCodeList);
        }
        if (null != (shipmentPriority = relWarehouseShipmentParamQueryDto.getShipmentPriority())) {
            queryWrapper.eq((Object)"shipment_priority", (Object)shipmentPriority);
        }
    }
}

