/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.pcp.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.pcp.ICsLockOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.pcp.ICsLockOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsLockLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsLockOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.pcp.CsLockLogMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.pcp.CsLockOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLockOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLockOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLockOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLockLogStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLockTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.LockDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleaseLockDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csLockOrderService")
public class CsLockOrderServiceImpl
implements ICsLockOrderService {
    private static final Logger logger = LoggerFactory.getLogger(CsLockOrderServiceImpl.class);
    @Resource
    CsLockOrderMapper csLockOrderMapper;
    @Resource
    ILogicInventoryDomain logicInventoryDomain;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    ICsLockOrderQueryService csLockOrderQueryService;
    @Resource
    CsLockLogMapper csLockLogMapper;
    @Autowired
    RepeatFilter repeatFilter;
    @Autowired
    ICalcInventoryService calcInventoryService;
    private static final String COMMA = "\uff0c";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String updateLockInventory(String type, CsLockOrderUpdateReqDto updateReqDto, boolean isThrowException) {
        CsLockLogEo lockLogEo = new CsLockLogEo();
        CubeBeanUtils.copyProperties((Object)lockLogEo, (Object)updateReqDto, (String[])new String[0]);
        try {
            this.checkParam(type, updateReqDto, lockLogEo);
            lockLogEo.setCurrentQuantity(updateReqDto.getCurrentLockQuantity());
            String generateCodeStrategy = CsLockTypeEnum.LOCK.getCode().equals(type) ? CsGenerateCodeStrategyEnum.LOCK_ORDER.getCode() : CsGenerateCodeStrategyEnum.UNLOCK_ORDER.getCode();
            String documentNo = GenerateCodeUtils.getStrategy(generateCodeStrategy).getCode();
            lockLogEo.setDocumentNo(documentNo);
            lockLogEo.setType(type);
            this.updateInventory(type, updateReqDto, documentNo);
            lockLogEo.setUpdatePerson(updateReqDto.getCreatePerson());
            lockLogEo.setLogStatus(CsLockLogStatusEnum.NORMAL.getCode());
            this.csLockLogMapper.insert((Object)lockLogEo);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"long_code", (Object)updateReqDto.getLongCode());
            queryWrapper.eq((Object)"warehouse_code", (Object)updateReqDto.getWarehouseCode());
            queryWrapper.eq((Object)"batch", (Object)updateReqDto.getBatch());
            queryWrapper.eq((Object)"dr", (Object)0);
            List lockOrderEos = this.csLockOrderMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)lockOrderEos)) {
                CsLockOrderEo eo = (CsLockOrderEo)lockOrderEos.get(0);
                BigDecimal currentLockQuantity = CsLockTypeEnum.LOCK.getCode().equals(type) ? updateReqDto.getCurrentLockQuantity() : updateReqDto.getCurrentLockQuantity().negate();
                eo.setCurrentLockQuantity(currentLockQuantity);
                eo.setRemark(updateReqDto.getRemark());
                eo.setUpdatePerson(updateReqDto.getCreatePerson());
                this.csLockOrderMapper.updateLock(eo);
            } else {
                CsLockOrderEo lockOrderEo = new CsLockOrderEo();
                lockOrderEo.setCargoName(lockLogEo.getCargoName());
                lockOrderEo.setCargoCode(lockLogEo.getCargoCode());
                lockOrderEo.setArtNo(lockLogEo.getArtNo());
                CubeBeanUtils.copyProperties((Object)lockOrderEo, (Object)updateReqDto, (String[])new String[0]);
                lockOrderEo.setNumber(Integer.valueOf(1));
                lockOrderEo.setUpdatePerson(updateReqDto.getCreatePerson());
                this.csLockOrderMapper.insert((Object)lockOrderEo);
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u64cd\u4f5c\u9501\u5e93\u5355\u5f02\u5e38\uff1a%s", e.getLocalizedMessage()));
            if (isThrowException) {
                throw e;
            }
            return (StringUtils.isNotBlank((CharSequence)lockLogEo.getCargoName()) ? "\u4ea7\u54c1\u540d\u79f0\uff1a" + lockLogEo.getCargoName() : "\u4ea7\u54c1\u957f\u7f16\u7801\uff1a" + lockLogEo.getLongCode()) + COMMA + "\u6279\u6b21\u53f7\uff1a" + lockLogEo.getBatch() + COMMA + (StringUtils.isNotBlank((CharSequence)lockLogEo.getWarehouseName()) ? "\u4ed3\u5e93\u540d\u79f0\uff1a" + lockLogEo.getWarehouseName() : "\u4ed3\u5e93\u7f16\u7801\uff1a" + lockLogEo.getWarehouseCode());
        }
        return "";
    }

    private void updateInventory(String type, CsLockOrderUpdateReqDto updateReqDto, String documentNo) {
        ArrayList details = Lists.newArrayList();
        CalcDetailDto detail = new CalcDetailDto();
        detail.setLogicWarehouseCode(updateReqDto.getWarehouseCode());
        detail.setSkuCode(updateReqDto.getLongCode());
        detail.setNum(BigDecimalUtils.abs((BigDecimal)updateReqDto.getCurrentLockQuantity()));
        detail.setBatch(updateReqDto.getBatch());
        details.add(detail);
        if (CsLockTypeEnum.LOCK.getCode().equals(type)) {
            LockDto lockParam = new LockDto();
            lockParam.setSourceNo(documentNo);
            lockParam.setSourceType(CsInventorySourceTypeEnum.LOCK_INVENTORY.getCode());
            lockParam.setBusinessType(CsPcpBusinessTypeEnum.LOCK_ORDER.getCode());
            lockParam.setDetails((List)details);
            lockParam.setNoneLineNo(Boolean.valueOf(true));
            this.calcInventoryService.lock(lockParam);
        } else {
            ReleaseLockDto releaseLockParam = new ReleaseLockDto();
            releaseLockParam.setSourceNo(documentNo);
            releaseLockParam.setSourceType(CsInventorySourceTypeEnum.UNLOCK_INVENTORY.getCode());
            releaseLockParam.setBusinessType(CsPcpBusinessTypeEnum.LOCK_ORDER.getCode());
            releaseLockParam.setDetails((List)details);
            releaseLockParam.setNoneLineNo(Boolean.valueOf(true));
            this.calcInventoryService.releaseLock(releaseLockParam);
        }
    }

    private void checkParam(String type, CsLockOrderUpdateReqDto updateReqDto, CsLockLogEo lockLogEo) {
        AssertUtil.isTrue(Objects.nonNull(CsLockTypeEnum.getByCode((String)type)), "\u9501\u5e93\u5355\u8bb0\u5f55\u7c7b\u578b\u6709\u8bef");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)updateReqDto.getWarehouseCode()), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)updateReqDto.getLongCode()), "\u5546\u54c1\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)updateReqDto.getBatch()), "\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(updateReqDto.getCurrentLockQuantity()), CsLockTypeEnum.getByCode((String)type).getDesc() + "\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(BigDecimalUtils.geZero((BigDecimal)updateReqDto.getCurrentLockQuantity()), "\u64cd\u4f5c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u6216\u5c0f\u4e8e0");
        if (CsLockTypeEnum.UNLOCK.getCode().equals(type)) {
            List csLockOrderEos = this.csLockOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsLockOrderEo.class).eq(CsLockOrderEo::getWarehouseCode, (Object)updateReqDto.getWarehouseCode())).eq(CsLockOrderEo::getLongCode, (Object)updateReqDto.getLongCode())).eq(CsLockOrderEo::getBatch, (Object)updateReqDto.getBatch())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtil.assertEmpty(csLockOrderEos, "\u9501\u5b9a\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
            CsLockOrderEo csLockOrderEo = (CsLockOrderEo)csLockOrderEos.get(0);
            logger.info("CsLockOrderEo : {}", (Object)JSON.toJSONString((Object)csLockOrderEo));
            AssertUtil.isTrue(BigDecimalUtils.ge((BigDecimal)csLockOrderEo.getCurrentLockQuantity(), (BigDecimal)updateReqDto.getCurrentLockQuantity()), "\u89e3\u9501\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u9501\u5e93\u6570\u91cf");
            CubeBeanUtils.copyProperties((Object)lockLogEo, (Object)csLockOrderEo, (String[])new String[]{"createTime", "id", "currentLockQuantity", "remark"});
        }
        if (CsLockTypeEnum.LOCK.getCode().equals(type)) {
            CsLockOrderQueryDto queryDto = new CsLockOrderQueryDto();
            queryDto.setWarehouseCode(updateReqDto.getWarehouseCode());
            queryDto.setLongCode(updateReqDto.getLongCode());
            queryDto.setBatch(updateReqDto.getBatch());
            queryDto.setIsNearOverdue(updateReqDto.getIsNearOverdue());
            PageInfo<CsLockOrderRespDto> pageInfo = this.csLockOrderQueryService.queryByPage(queryDto);
            AssertUtil.assertNotEmpty(pageInfo.getList(), "\u8be5\u5e93\u5b58\u8bb0\u5f55\uff0c\u6709\u6548\u671f\u5b58\u5728\u5f02\u5e38", new Object[0]);
            CsLockOrderRespDto respDto = (CsLockOrderRespDto)pageInfo.getList().get(0);
            CubeBeanUtils.copyProperties((Object)lockLogEo, (Object)respDto, (String[])new String[]{"createTime", "id", "currentLockQuantity", "remark"});
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateLockInventory(String type, List<CsLockOrderUpdateReqDto> list) {
        logger.info("batchUpdateLockInventory==>\u6279\u91cf\u6839\u636e\u7c7b\u578b\u66f4\u65b0\u9501\u5b9a\u5e93\u5b58,\u5f00\u59cb,type:{},list:{}", (Object)type, (Object)JSON.toJSONString(list));
        String key = "UPDATE_LOCK_INVENTORY:" + type + list.size();
        this.repeatFilter.checkRepeat(key, () -> this.validParam(type, list), true, "\u64cd\u4f5c\u9891\u7e41\uff0c\u6279\u91cf\u6839\u636e\u7c7b\u578b\u66f4\u65b0\u9501\u5b9a\u5e93\u5b58");
        String generateCodeStrategy = CsLockTypeEnum.LOCK.getCode().equals(type) ? CsGenerateCodeStrategyEnum.LOCK_ORDER.getCode() : CsGenerateCodeStrategyEnum.UNLOCK_ORDER.getCode();
        String documentNo = GenerateCodeUtils.getStrategy(generateCodeStrategy).getCode();
        logger.info("batchUpdateLockInventory==>\u6279\u91cf\u6839\u636e\u7c7b\u578b\u66f4\u65b0\u9501\u5b9a\u5e93\u5b58\uff0c\u6821\u9a8c\u901a\u8fc7\uff0c\u751f\u6210\u5355\u53f7,documentNo:{}", (Object)documentNo);
        this.batchUpdateInventory(type, list, documentNo);
        logger.info("batchUpdateLockInventory==>\u6279\u91cf\u6839\u636e\u7c7b\u578b\u66f4\u65b0\u9501\u5b9a\u5e93\u5b58\uff0c\u6821\u9a8c\u901a\u8fc7\uff0c\u9501\u5b9a/\u89e3\u9501\u6210\u529f,documentNo:{}", (Object)documentNo);
        this.batchInsertLockLog(type, list, documentNo);
        this.batchUpdateLockOrder(type, list);
        logger.info("batchUpdateLockInventory==>\u6279\u91cf\u6839\u636e\u7c7b\u578b\u66f4\u65b0\u9501\u5b9a\u5e93\u5b58\uff0c\u6821\u9a8c\u901a\u8fc7\uff0c\u6210\u529f,documentNo:{}", (Object)documentNo);
    }

    private void batchUpdateLockOrder(String type, List<CsLockOrderUpdateReqDto> list) {
        List warehouseCodeList = list.stream().map(CsLockOrderUpdateReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
        List longCodeList = list.stream().map(CsLockOrderUpdateReqDto::getLongCode).distinct().collect(Collectors.toList());
        List batchList = list.stream().map(CsLockOrderUpdateReqDto::getBatch).distinct().collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        queryWrapper.in((Object)"long_code", longCodeList);
        queryWrapper.in((Object)"batch", batchList);
        queryWrapper.eq((Object)"dr", (Object)0);
        List lockOrderEos = this.csLockOrderMapper.selectList((Wrapper)queryWrapper);
        HashMap<String, CsLockOrderEo> lockOrderEoMap = new HashMap<String, CsLockOrderEo>();
        for (CsLockOrderEo lockOrderEo : lockOrderEos) {
            String key = lockOrderEo.getWarehouseCode() + "_" + lockOrderEo.getLongCode() + "_" + lockOrderEo.getBatch();
            lockOrderEoMap.put(key, lockOrderEo);
        }
        ArrayList<CsLockOrderEo> insertList = new ArrayList<CsLockOrderEo>();
        if (CollectionUtils.isNotEmpty((Collection)lockOrderEos)) {
            for (CsLockOrderUpdateReqDto updateReqDto : list) {
                String key = updateReqDto.getWarehouseCode() + "_" + updateReqDto.getLongCode() + "_" + updateReqDto.getBatch();
                CsLockOrderEo csLockOrderEo = (CsLockOrderEo)lockOrderEoMap.get(key);
                if (null != csLockOrderEo) {
                    BigDecimal currentLockQuantity = CsLockTypeEnum.LOCK.getCode().equals(type) ? updateReqDto.getCurrentLockQuantity() : updateReqDto.getCurrentLockQuantity().negate();
                    csLockOrderEo.setCurrentLockQuantity(currentLockQuantity);
                    csLockOrderEo.setRemark(updateReqDto.getRemark());
                    csLockOrderEo.setUpdatePerson(updateReqDto.getCreatePerson());
                    this.csLockOrderMapper.updateLock(csLockOrderEo);
                    continue;
                }
                CsLockOrderEo lockOrderEo = new CsLockOrderEo();
                CubeBeanUtils.copyProperties((Object)lockOrderEo, (Object)updateReqDto, (String[])new String[0]);
                lockOrderEo.setNumber(Integer.valueOf(1));
                lockOrderEo.setUpdatePerson(updateReqDto.getCreatePerson());
                insertList.add(lockOrderEo);
            }
        } else {
            for (CsLockOrderUpdateReqDto updateReqDto : list) {
                CsLockOrderEo lockOrderEo = new CsLockOrderEo();
                CubeBeanUtils.copyProperties((Object)lockOrderEo, (Object)updateReqDto, (String[])new String[0]);
                lockOrderEo.setNumber(Integer.valueOf(1));
                lockOrderEo.setUpdatePerson(updateReqDto.getCreatePerson());
                insertList.add(lockOrderEo);
            }
        }
        if (CollectionUtils.isNotEmpty(insertList)) {
            this.csLockOrderMapper.insertBatch(insertList);
        }
    }

    private void batchInsertLockLog(String type, List<CsLockOrderUpdateReqDto> list, String documentNo) {
        ArrayList<CsLockLogEo> lockLogEoList = new ArrayList<CsLockLogEo>();
        for (CsLockOrderUpdateReqDto updateReqDto : list) {
            CsLockLogEo lockLogEo = new CsLockLogEo();
            CubeBeanUtils.copyProperties((Object)lockLogEo, (Object)updateReqDto, (String[])new String[0]);
            lockLogEo.setCurrentQuantity(updateReqDto.getCurrentLockQuantity());
            lockLogEo.setType(type);
            lockLogEo.setDocumentNo(documentNo);
            lockLogEoList.add(lockLogEo);
        }
        this.csLockLogMapper.insertBatch(lockLogEoList);
    }

    private void batchUpdateInventory(String type, List<CsLockOrderUpdateReqDto> list, String documentNo) {
        ArrayList details = Lists.newArrayList();
        for (CsLockOrderUpdateReqDto updateReqDto : list) {
            CalcDetailDto detail = new CalcDetailDto();
            detail.setLogicWarehouseCode(updateReqDto.getWarehouseCode());
            detail.setSkuCode(updateReqDto.getLongCode());
            detail.setNum(BigDecimalUtils.abs((BigDecimal)updateReqDto.getCurrentLockQuantity()));
            if (BigDecimalUtils.eqZero((BigDecimal)detail.getNum()).booleanValue()) continue;
            detail.setBatch(updateReqDto.getBatch());
            details.add(detail);
        }
        if (CsLockTypeEnum.LOCK.getCode().equals(type)) {
            LockDto lockParam = new LockDto();
            lockParam.setSourceNo(documentNo);
            lockParam.setSourceType(CsInventorySourceTypeEnum.LOCK_INVENTORY.getCode());
            lockParam.setBusinessType(CsPcpBusinessTypeEnum.LOCK_ORDER.getCode());
            lockParam.setNoneLineNo(Boolean.valueOf(true));
            lockParam.setDetails((List)details);
            if (CollectionUtils.isNotEmpty((Collection)details)) {
                this.calcInventoryService.lock(lockParam);
            }
        } else {
            ReleaseLockDto releaseLockParam = new ReleaseLockDto();
            releaseLockParam.setSourceNo(documentNo);
            releaseLockParam.setSourceType(CsInventorySourceTypeEnum.UNLOCK_INVENTORY.getCode());
            releaseLockParam.setBusinessType(CsPcpBusinessTypeEnum.LOCK_ORDER.getCode());
            releaseLockParam.setNoneLineNo(Boolean.valueOf(true));
            releaseLockParam.setDetails((List)details);
            if (CollectionUtils.isNotEmpty((Collection)details)) {
                this.calcInventoryService.releaseLock(releaseLockParam);
            }
        }
    }

    private void validParam(String type, List<CsLockOrderUpdateReqDto> list) {
        AssertUtil.isTrue(Objects.nonNull(CsLockTypeEnum.getByCode((String)type)), "\u9501\u5e93\u5355\u8bb0\u5f55\u7c7b\u578b\u6709\u8bef");
        list = list.stream().distinct().collect(Collectors.toList());
        for (CsLockOrderUpdateReqDto csLockOrderUpdateReqDto : list) {
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csLockOrderUpdateReqDto.getWarehouseCode()), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csLockOrderUpdateReqDto.getLongCode()), "\u5546\u54c1\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csLockOrderUpdateReqDto.getBatch()), "\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List warehouseCodeList = list.stream().map(CsLockOrderUpdateReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
        List list2 = list.stream().map(CsLockOrderUpdateReqDto::getLongCode).distinct().collect(Collectors.toList());
        List batchList = list.stream().map(CsLockOrderUpdateReqDto::getBatch).distinct().collect(Collectors.toList());
        QueryWrapper queryLogicWrapper = new QueryWrapper();
        queryLogicWrapper.in((Object)"warehouse_code", warehouseCodeList);
        queryLogicWrapper.eq((Object)"dr", (Object)0);
        List logicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)queryLogicWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicWarehouseEoList), "\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        queryWrapper.in((Object)"sku_code", list2);
        queryWrapper.in((Object)"batch", batchList);
        queryWrapper.eq((Object)"dr", (Object)0);
        List logicInventoryEoList = this.logicInventoryDomain.getMapper().selectList((Wrapper)queryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicInventoryEoList), "\u903b\u8f91\u4ed3\u5e93\u5b58\u4e0d\u8db3");
        HashMap<String, LogicInventoryEo> logicInventoryEoMap = new HashMap<String, LogicInventoryEo>();
        for (LogicInventoryEo csLogicInventoryEo : logicInventoryEoList) {
            String string = csLogicInventoryEo.getWarehouseCode() + "_" + csLogicInventoryEo.getSkuCode() + "_" + csLogicInventoryEo.getBatch();
            logicInventoryEoMap.put(string, csLogicInventoryEo);
        }
        Map<String, LogicWarehouseEo> logicWarehouseEoMap = logicWarehouseEoList.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, entity -> entity));
        this.lockAllSetNum(type, list, logicInventoryEoList);
        for (CsLockOrderUpdateReqDto csLockOrderUpdateReqDto : list) {
            AssertUtil.isTrue(Objects.nonNull(csLockOrderUpdateReqDto.getCurrentLockQuantity()), CsLockTypeEnum.getByCode((String)type) + "\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(Objects.nonNull(csLockOrderUpdateReqDto.getCurrentLockQuantity()) && csLockOrderUpdateReqDto.getCurrentLockQuantity().compareTo(BigDecimal.ZERO) >= 0, "\u64cd\u4f5c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u6216\u5c0f\u4e8e0");
            String key = csLockOrderUpdateReqDto.getWarehouseCode() + "_" + csLockOrderUpdateReqDto.getLongCode() + "_" + csLockOrderUpdateReqDto.getBatch();
            LogicInventoryEo csLogicInventoryEo = (LogicInventoryEo)logicInventoryEoMap.get(key);
            AssertUtil.isTrue(Objects.nonNull(csLogicInventoryEo), csLockOrderUpdateReqDto.getLongCode() + "\u903b\u8f91\u4ed3\u5e93\u5b58\u4e0d\u5b58\u5728");
            csLockOrderUpdateReqDto.setWarehouseName(csLogicInventoryEo.getWarehouseName());
            csLockOrderUpdateReqDto.setCargoName(csLogicInventoryEo.getSkuName());
            csLockOrderUpdateReqDto.setArtNo(csLogicInventoryEo.getSkuCode());
            csLockOrderUpdateReqDto.setProduceTime(csLogicInventoryEo.getProduceTime());
            csLockOrderUpdateReqDto.setExpireTime(csLogicInventoryEo.getExpireTime());
            LogicWarehouseEo csLogicWarehouseEo = logicWarehouseEoMap.get(csLockOrderUpdateReqDto.getWarehouseCode());
            csLockOrderUpdateReqDto.setOrganizationId(csLogicWarehouseEo.getOrganizationId());
            csLockOrderUpdateReqDto.setOrganizationCode(csLogicWarehouseEo.getOrganizationCode());
            csLockOrderUpdateReqDto.setOrganizationName(csLogicWarehouseEo.getOrganizationName());
        }
    }

    private void lockAllSetNum(String type, List<CsLockOrderUpdateReqDto> list, List<LogicInventoryEo> logicInventoryEoList) {
        Boolean lockAll = list.get(0).getLockAll();
        if (lockAll.booleanValue()) {
            String key;
            logger.info("batchUpdateLockInventory==>\u6279\u91cf\u6839\u636e\u7c7b\u578b\u66f4\u65b0\u9501\u5b9a\u5e93\u5b58,\u6307\u5b9a\u7c7b\u578b\u662f\u6309\u5168\u91cf\u5904\u7406,\u8d4b\u503c\u5f85\u5904\u7406\u503c");
            HashMap<String, BigDecimal> availableMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> lockMap = new HashMap<String, BigDecimal>();
            for (LogicInventoryEo csLogicInventoryEo : logicInventoryEoList) {
                key = csLogicInventoryEo.getWarehouseCode() + "_" + csLogicInventoryEo.getSkuCode() + "_" + csLogicInventoryEo.getBatch();
                availableMap.put(key, csLogicInventoryEo.getAvailable());
                lockMap.put(key, csLogicInventoryEo.getLockInventory());
            }
            for (CsLockOrderUpdateReqDto updateReqDto : list) {
                key = updateReqDto.getWarehouseCode() + "_" + updateReqDto.getLongCode() + "_" + updateReqDto.getBatch();
                BigDecimal currentLockNum = CsLockTypeEnum.LOCK.getCode().equals(type) ? (BigDecimal)availableMap.get(key) : (BigDecimal)lockMap.get(key);
                updateReqDto.setCurrentLockQuantity(currentLockNum);
            }
        }
    }
}

