/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsPhysicsInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsVersionDistinguishEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="CsUpdatePreemptServer")
public class CsUpdatePreemptServer {
    private static final Logger logger = LoggerFactory.getLogger(CsUpdatePreemptServer.class);
    @Resource
    IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Resource
    private ICsLogicInventoryExposedService csLogicInventoryExposedService;
    @Resource
    private ICsPhysicsInventoryExposedService csPhysicsInventoryExposedService;

    public void updatePhysicsPreemptRecord(String warehouseType, String orderNo, Boolean portionFlag, List<CsInOutResultDetailRespDto> detailRespDtoList) {
        logger.info("updatePreemptRecord===>\u4fee\u6539\u9884\u5360\u8bb0\u5f55,\u4ed3\u5e93\u7c7b\u578b\uff1a{},\u5355\u53f7\uff1a{},portionFlag:{},csOutResultOrderDetailEoList:{}", new Object[]{warehouseType, orderNo, portionFlag, JSONObject.toJSONString(detailRespDtoList)});
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryPreemptionDomain.filter().eq((Object)"warehouse_classify", (Object)warehouseType)).eq((Object)"source_no", (Object)orderNo)).eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            if (portionFlag.booleanValue()) {
                List<InventoryPreemptionEo> batchPreemption = list.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getBatch())).collect(Collectors.toList());
                List<InventoryPreemptionEo> preemption = list.stream().filter(x -> StringUtils.isBlank((CharSequence)x.getBatch())).collect(Collectors.toList());
                Map map = detailRespDtoList.stream().collect(Collectors.toMap(x -> x.getSkuCode() + x.getBatch(), Function.identity()));
                if (CollectionUtils.isNotEmpty(batchPreemption)) {
                    batchPreemption.forEach(info -> {
                        String key = info.getSkuCode() + info.getBatch();
                        if (map.containsKey(key)) {
                            CsInOutResultDetailRespDto detailRespDto = (CsInOutResultDetailRespDto)map.get(key);
                            InventoryPreemptionEo InventoryPreemptionEo2 = new InventoryPreemptionEo();
                            InventoryPreemptionEo2.setPreemptNum(info.getPreemptNum().subtract(detailRespDto.getQuantity()));
                            InventoryPreemptionEo2.setId(info.getId());
                            this.inventoryPreemptionDomain.updateSelective((BaseEo)InventoryPreemptionEo2);
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(preemption)) {
                    Map<String, List<CsInOutResultDetailRespDto>> longCodeMap = detailRespDtoList.stream().collect(Collectors.groupingBy(CsInOutResultDetailRespDto::getSkuCode));
                    preemption.forEach(info -> {
                        if (longCodeMap.containsKey(info.getSkuCode())) {
                            List csOutResultOrderDetailEos = (List)longCodeMap.get(info.getSkuCode());
                            BigDecimal doneQuantity = csOutResultOrderDetailEos.stream().map(CsInOutResultDetailRespDto::getQuantity).reduce(BigDecimal::add).get();
                            InventoryPreemptionEo InventoryPreemptionEo2 = new InventoryPreemptionEo();
                            InventoryPreemptionEo2.setPreemptNum(info.getPreemptNum().subtract(doneQuantity));
                            InventoryPreemptionEo2.setId(info.getId());
                            this.inventoryPreemptionDomain.updateSelective((BaseEo)InventoryPreemptionEo2);
                        }
                    });
                }
            } else {
                List<Long> idList = list.stream().map(BaseEo::getId).collect(Collectors.toList());
                this.updateDisable(idList);
            }
        }
    }

    public void updateLogicPreemptRecord(String warehouseType, List<String> sourceNoList, Boolean portionFlag, List<CsDeliveryReceiveResultDetailRespDto> detailRespDtoList) {
        logger.info("updatePreemptRecord===>\u4fee\u6539\u9884\u5360\u8bb0\u5f55,\u4ed3\u5e93\u7c7b\u578b\uff1a{},\u5355\u53f7\uff1a{},portionFlag:{},csOutResultOrderDetailEoList:{}", new Object[]{warehouseType, JSON.toJSONString(sourceNoList), portionFlag, JSONObject.toJSONString(detailRespDtoList)});
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryPreemptionDomain.filter().eq((Object)"warehouse_classify", (Object)warehouseType)).in((Object)"source_no", sourceNoList)).eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoEnum.NO.getValue())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            if (portionFlag.booleanValue()) {
                List<InventoryPreemptionEo> batchPreemption = list.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getBatch())).collect(Collectors.toList());
                List<InventoryPreemptionEo> preemption = list.stream().filter(x -> StringUtils.isBlank((CharSequence)x.getBatch())).collect(Collectors.toList());
                Map map = detailRespDtoList.stream().collect(Collectors.toMap(x -> x.getLongCode() + x.getBatch(), Function.identity()));
                if (CollectionUtils.isNotEmpty(batchPreemption)) {
                    batchPreemption.forEach(info -> {
                        String key = info.getSkuCode() + info.getBatch();
                        if (map.containsKey(key)) {
                            CsDeliveryReceiveResultDetailRespDto detailRespDto = (CsDeliveryReceiveResultDetailRespDto)map.get(key);
                            InventoryPreemptionEo InventoryPreemptionEo2 = new InventoryPreemptionEo();
                            InventoryPreemptionEo2.setPreemptNum(info.getPreemptNum().subtract(detailRespDto.getQuantity()));
                            InventoryPreemptionEo2.setId(info.getId());
                            this.inventoryPreemptionDomain.updateSelective((BaseEo)InventoryPreemptionEo2);
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(preemption)) {
                    Map<String, List<CsDeliveryReceiveResultDetailRespDto>> longCodeMap = detailRespDtoList.stream().collect(Collectors.groupingBy(CsDeliveryReceiveResultDetailRespDto::getLongCode));
                    preemption.forEach(info -> {
                        if (longCodeMap.containsKey(info.getSkuCode())) {
                            List csOutResultOrderDetailEos = (List)longCodeMap.get(info.getSkuCode());
                            BigDecimal doneQuantity = csOutResultOrderDetailEos.stream().map(CsDeliveryReceiveResultDetailRespDto::getQuantity).reduce(BigDecimal::add).get();
                            InventoryPreemptionEo InventoryPreemptionEo2 = new InventoryPreemptionEo();
                            InventoryPreemptionEo2.setPreemptNum(info.getPreemptNum().subtract(doneQuantity));
                            InventoryPreemptionEo2.setId(info.getId());
                            this.inventoryPreemptionDomain.updateSelective((BaseEo)InventoryPreemptionEo2);
                        }
                    });
                }
            } else {
                List<Long> idList = list.stream().map(BaseEo::getId).collect(Collectors.toList());
                this.updateDisable(idList);
            }
        }
    }

    private void updateDisable(List<Long> idList) {
        InventoryPreemptionEo updateEo = new InventoryPreemptionEo();
        updateEo.setValid(CsValidFlagEnum.DISABLE.getCode());
        updateEo.setDisplay(YesNoEnum.NO.getValue());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.in((Object)"id", idList);
        logger.info("updatePreemptRecord==>\u9884\u5360\u8bb0\u5f55\u5373\u5c06\u6279\u91cf\u7f6e\u4e3a\u65e0\u6548,updateEo:{},updateWrapper:{}", (Object)LogUtils.buildLogContent(updateEo), (Object)LogUtils.buildLogContent(updateWrapper));
        this.inventoryPreemptionDomain.getMapper().update((Object)updateEo, (Wrapper)updateWrapper);
    }

    public void disableBySourceNo(String warehouseType, String storageOrderNo) {
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryPreemptionDomain.filter().eq((Object)"warehouse_classify", (Object)warehouseType)).eq((Object)"source_no", (Object)storageOrderNo)).eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List<Long> idList = list.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.updateDisable(idList);
        }
    }

    public void disableBySourceNo(List<InventoryPreemptionEo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> idList = list.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.updateDisable(idList);
        }
    }

    public Boolean cancelLogicAndPhysicsOrder(String orderNo, String sourceType, String platformOrderNo) {
        logger.info("cancelLogicAndPhysicsOrder==>orderNo:{}", (Object)orderNo);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u6765\u6e90\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> warehouseClassify = new ArrayList<String>(3);
        warehouseClassify.add(CsWarehouseClassifyEnum.PHYSICS.getCode());
        warehouseClassify.add(CsWarehouseClassifyEnum.LOGIC.getCode());
        List csInventoryPreemptionEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryPreemptionDomain.filter().in((Object)"warehouse_classify", warehouseClassify)).eq((Object)"source_no", (Object)orderNo)).eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)csInventoryPreemptionEoList)) {
            logger.error("cancelOrder==>\u67e5\u8be2\u4e0d\u5230\u9884\u5360\u8bb0\u5f55,orderNo:{}", (Object)orderNo);
            return null;
        }
        Map<String, List<InventoryPreemptionEo>> inventoryMap = csInventoryPreemptionEoList.stream().collect(Collectors.groupingBy(InventoryPreemptionEo::getWarehouseClassify));
        logger.info("cancelOrder==>inventoryMap:{}", (Object)LogUtils.buildLogContent(inventoryMap));
        List<InventoryPreemptionEo> logicPreemptionEoList = inventoryMap.get(CsWarehouseClassifyEnum.LOGIC.getCode());
        Boolean logicCancelFlag = true;
        CsInventoryOperateReqDto releaseOperateReqDto = new CsInventoryOperateReqDto();
        releaseOperateReqDto.setSourceNo(orderNo);
        releaseOperateReqDto.setSourceType(sourceType);
        releaseOperateReqDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        releaseOperateReqDto.setOperateVersion(CsVersionDistinguishEnum.SECOND.getCode());
        releaseOperateReqDto.setDisablePreemptionFlag(Boolean.valueOf(false));
        releaseOperateReqDto.setPlatformOrderNo(platformOrderNo);
        if (CollectionUtils.isNotEmpty(logicPreemptionEoList)) {
            this.getReleaseOperateReqDto(logicPreemptionEoList, releaseOperateReqDto);
            if (CollectionUtils.isNotEmpty((Collection)releaseOperateReqDto.getOperateCargoReqDtoList())) {
                logicCancelFlag = this.csLogicInventoryExposedService.releaseInventory(releaseOperateReqDto);
            }
        }
        return logicCancelFlag;
    }

    private void getReleaseOperateReqDto(List<InventoryPreemptionEo> preemptionEoList, CsInventoryOperateReqDto releaseOperateReqDto) {
        ArrayList releaseCargoReqDtoList = Lists.newArrayList();
        for (InventoryPreemptionEo csInventoryPreemptionEo : preemptionEoList) {
            if (Objects.isNull(csInventoryPreemptionEo.getPreemptNum()) || csInventoryPreemptionEo.getPreemptNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            CsInventoryOperateCargoReqDto releaseCargoReqDto = new CsInventoryOperateCargoReqDto();
            releaseCargoReqDto.setCargoCode(csInventoryPreemptionEo.getSkuCode());
            releaseCargoReqDto.setLongCode(csInventoryPreemptionEo.getSkuCode());
            releaseCargoReqDto.setWarehouseCode(csInventoryPreemptionEo.getWarehouseCode());
            releaseCargoReqDto.setChangeInventory(csInventoryPreemptionEo.getPreemptNum());
            releaseCargoReqDto.setBatch(csInventoryPreemptionEo.getBatch());
            releaseCargoReqDto.setActivityId(csInventoryPreemptionEo.getActivityId());
            releaseCargoReqDtoList.add(releaseCargoReqDto);
        }
        releaseOperateReqDto.setOperateCargoReqDtoList((List)releaseCargoReqDtoList);
    }
}

