/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInspectionReleaseTaskService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INVENTORY_BUSINESS_TOPIC", tag="TRANSFER_COMPLETE")
public class TransferCompleteProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(TransferCompleteProcess.class);
    @Autowired
    IInspectionReleaseTaskService inspectionReleaseTaskService;

    public MessageResponse process(MessageVo message) {
        log.info("TransferCompleteProcess\uff1a{}", (Object)LogUtils.buildLogContent(message));
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        String transferOrderNo = (String)JSON.parseObject((String)message.getData().toString(), String.class);
        this.endInspectionReleaseTaskItem(transferOrderNo);
        return MessageResponse.SUCCESS;
    }

    private void endInspectionReleaseTaskItem(String transferOrderNo) {
        try {
            log.info("endInspectionReleaseTaskItem: {}", (Object)transferOrderNo);
            this.inspectionReleaseTaskService.endByTransferOrderNo(transferOrderNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("endInspectionReleaseTaskItem \u5931\u8d25\uff1a{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

