/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.IcsShipmenetEnterpriseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.other.CsShipmenetEnterpriseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsShipmenetEnterpriseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsShipmenetEnterpriseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOrderPreRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentCodePrefixEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentTypeEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csShipmenetEnterpriseQueryService")
public class CsShipmenetEnterpriseQueryServiceImpl
implements IcsShipmenetEnterpriseQueryService {
    private static final Logger logger = LoggerFactory.getLogger(CsShipmenetEnterpriseQueryServiceImpl.class);
    @Autowired
    CsShipmenetEnterpriseDas csShipmenetEnterpriseDas;
    @Resource
    CsShipmenetEnterpriseMapper csShipmenetEnterpriseMapper;
    @Autowired
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Autowired
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;

    @Override
    public CsShipmenetEnterpriseEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "ID\u4e0d\u80fd\u4e3a\u7a7a");
        return this.csShipmenetEnterpriseDas.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<CsShipmenetEnterpriseRespDto> queryByPage(CsShipmenetEnterpriseQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        AssertUtil.emptyValidated(queryDto, "pageNum", "pageSize");
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)queryDto.getShipmentEnterpriseCode())) {
            wrapper.like((Object)"shipment_enterprise_code", (Object)queryDto.getShipmentEnterpriseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getShipmentEnterpriseName())) {
            wrapper.like((Object)"shipment_enterprise_name", (Object)queryDto.getShipmentEnterpriseName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getShipmentEnterpriseReduceName())) {
            wrapper.like((Object)"shipment_enterprise_reduce_name", (Object)queryDto.getShipmentEnterpriseReduceName());
        }
        if (Objects.nonNull(queryDto.getShipmentEnterpriseType())) {
            wrapper.eq((Object)"shipment_enterprise_type", (Object)queryDto.getShipmentEnterpriseType());
        }
        if (Objects.nonNull(queryDto.getShipmentEnterpriseStatus())) {
            wrapper.eq((Object)"shipment_enterprise_status", (Object)queryDto.getShipmentEnterpriseStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getCustomerName())) {
            wrapper.like((Object)"customer_name", (Object)queryDto.getCustomerName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getCustomerCode())) {
            wrapper.like((Object)"customer_code", (Object)queryDto.getCustomerCode());
        }
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.orderByDesc((Object)"update_time");
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        List selectList = this.csShipmenetEnterpriseMapper.selectList((Wrapper)wrapper);
        PageInfo selectPage = new PageInfo(selectList);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList csShipmenetEnterpriseRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)selectList, (Collection)csShipmenetEnterpriseRespDtos, CsShipmenetEnterpriseRespDto.class);
        pageInfo.setList((List)csShipmenetEnterpriseRespDtos);
        return pageInfo;
    }

    @Override
    public List<CsShipmenetEnterpriseEo> queryByParam(CsShipmenetEnterpriseQueryDto queryDto) {
        logger.info("queryByParam==>\u591a\u6761\u4ef6\u67e5\u8be2,queryDto:{}", (Object)LogUtils.buildLogContent(queryDto));
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)queryDto.getShipmentEnterpriseCode())) {
            wrapper.eq((Object)"shipment_enterprise_code", (Object)queryDto.getShipmentEnterpriseCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getShipmentEnterpriseCodeList())) {
            wrapper.in((Object)"shipment_enterprise_code", (Collection)queryDto.getShipmentEnterpriseCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getShipmentEnterpriseName())) {
            wrapper.like((Object)"shipment_enterprise_name", (Object)queryDto.getShipmentEnterpriseName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getShipmentEnterpriseNameAccurate())) {
            wrapper.eq((Object)"shipment_enterprise_name", (Object)queryDto.getShipmentEnterpriseNameAccurate());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getShipmentEnterpriseReduceName())) {
            wrapper.like((Object)"shipment_enterprise_reduce_name", (Object)queryDto.getShipmentEnterpriseReduceName());
        }
        if (Objects.nonNull(queryDto.getShipmentEnterpriseType())) {
            wrapper.eq((Object)"shipment_enterprise_type", (Object)queryDto.getShipmentEnterpriseType());
        }
        if (Objects.nonNull(queryDto.getShipmentEnterpriseStatus())) {
            wrapper.eq((Object)"shipment_enterprise_status", (Object)queryDto.getShipmentEnterpriseStatus());
        }
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"shipment_enterprise_status", (Object)YesNoEnum.YES.getValue());
        List selectList = this.csShipmenetEnterpriseMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)selectList)) {
            return Lists.newArrayList();
        }
        return selectList;
    }

    @Override
    public List<CsOrderPreRespDto> handlePreDocumentInfoByOrderNo(String orderNo) {
        AssertUtil.isTrue(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orderNo}), "ID\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList result = Lists.newArrayList();
        ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2 = new ReceiveDeliveryNoticeOrderEo();
        ReceiveDeliveryNoticeOrderEo2.setRelevanceNo(orderNo);
        List csDeliveryNoticeOrderList = this.receiveDeliveryNoticeOrderDomain.selectList((BaseEo)ReceiveDeliveryNoticeOrderEo2);
        if (CollectionUtils.isNotEmpty((Collection)csDeliveryNoticeOrderList)) {
            csDeliveryNoticeOrderList.stream().map(order -> {
                CsOrderPreRespDto dto = new CsOrderPreRespDto();
                dto.setDocumentType(CsDocumentTypeEnum.DELIVERY_NOTICE_ORDER.getCode());
                dto.setDocumentName(CsDocumentCodePrefixEnum.DON.getDesc());
                dto.setDocumentNo(order.getDocumentNo());
                dto.setOrderStatus(order.getOrderStatus());
                dto.setPreOrderNo(orderNo);
                if (order.getCreateTime() != null) {
                    dto.setCreateTime(order.getCreateTime());
                }
                if (StringUtils.isNotBlank((CharSequence)order.getExtension())) {
                    try {
                        ContactDto contactDto = (ContactDto)JSON.parseObject((String)order.getExtension(), ContactDto.class);
                        dto.setContactDto(contactDto);
                    }
                    catch (Exception ex) {
                        logger.info("\u6355\u83b7\u5f02\u5e38\uff0c\u903b\u8f91\u4e0d\u5904\u7406\uff1a\u524d\u7f6e\u5355\u636e\u6536\u8d27\u4fe1\u606f\u9519\u8bef");
                    }
                }
                result.add(dto);
                return dto;
            }).collect(Collectors.toList());
        }
        InOutNoticeOrderEo InOutNoticeOrderEo2 = new InOutNoticeOrderEo();
        InOutNoticeOrderEo2.setRelevanceNo(orderNo);
        List InOutNoticeOrderEoList = this.inOutNoticeOrderDomain.selectList((BaseEo)InOutNoticeOrderEo2);
        if (CollectionUtils.isNotEmpty((Collection)InOutNoticeOrderEoList)) {
            InOutNoticeOrderEoList.stream().map(order -> {
                CsOrderPreRespDto dto = new CsOrderPreRespDto();
                dto.setDocumentType(CsDocumentTypeEnum.OUT_NOTICE_ORDER.getCode());
                dto.setDocumentName(CsDocumentCodePrefixEnum.PDON.getDesc());
                dto.setDocumentNo(order.getDocumentNo());
                dto.setOrderStatus(order.getOrderStatus());
                dto.setPreOrderNo(orderNo);
                if (order.getCreateTime() != null) {
                    dto.setCreateTime(order.getCreateTime());
                }
                result.add(dto);
                return dto;
            }).collect(Collectors.toList());
        }
        InOutResultOrderEo InOutResultOrderEo2 = new InOutResultOrderEo();
        InOutResultOrderEo2.setRelevanceNo(orderNo);
        List InOutResultOrderEoList = this.inOutResultOrderDomain.selectList((BaseEo)InOutResultOrderEo2);
        if (CollectionUtils.isNotEmpty((Collection)InOutResultOrderEoList)) {
            InOutResultOrderEoList.stream().map(order -> {
                CsOrderPreRespDto dto = new CsOrderPreRespDto();
                dto.setDocumentType(CsDocumentTypeEnum.OUT_RESULT_ORDER.getCode());
                dto.setDocumentName(CsDocumentCodePrefixEnum.PSR.getDesc());
                dto.setDocumentNo(order.getDocumentNo());
                dto.setOrderStatus(order.getOrderStatus());
                dto.setPreOrderNo(orderNo);
                if (order.getCreateTime() != null) {
                    dto.setCreateTime(order.getCreateTime());
                }
                result.add(dto);
                return dto;
            }).collect(Collectors.toList());
        }
        ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = new ReceiveDeliveryResultOrderEo();
        csDeliveryResultOrderEo.setRelevanceNo(orderNo);
        List csDeliveryResultOrderList = this.receiveDeliveryResultOrderDomain.selectList((BaseEo)csDeliveryResultOrderEo);
        if (CollectionUtils.isNotEmpty((Collection)csDeliveryResultOrderList)) {
            csDeliveryResultOrderList.stream().map(order -> {
                CsOrderPreRespDto dto = new CsOrderPreRespDto();
                dto.setDocumentType(CsDocumentTypeEnum.DELIVERY_RESULT_ORDER.getCode());
                dto.setDocumentName(CsDocumentCodePrefixEnum.DS.getDesc());
                dto.setDocumentNo(order.getDocumentNo());
                dto.setOrderStatus(order.getOrderStatus());
                dto.setPreOrderNo(orderNo);
                if (order.getCreateTime() != null) {
                    dto.setCreateTime(order.getCreateTime());
                }
                result.add(dto);
                return dto;
            }).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public CsShipmenetEnterpriseRespDto queryByCode(String code) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"shipment_enterprise_code", (Object)code);
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"shipment_enterprise_status", (Object)YesNoEnum.YES.getValue());
        List selectList = this.csShipmenetEnterpriseMapper.selectList((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)selectList)) {
            return new CsShipmenetEnterpriseRespDto();
        }
        CsShipmenetEnterpriseEo eo = (CsShipmenetEnterpriseEo)selectList.get(0);
        CsShipmenetEnterpriseRespDto dto = new CsShipmenetEnterpriseRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        return dto;
    }
}

