/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.IPcpOutNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutNoticeOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcpOutNoticeOrderService")
public class PcpOutNoticeOrderServiceImpl
implements IPcpOutNoticeOrderService {
    private static final Logger logger = LoggerFactory.getLogger(PcpOutNoticeOrderServiceImpl.class);
    @Resource
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    private ICsDeliveryNoticeOrderQueryService csDeliveryNoticeOrderQueryService;
    @Resource
    private ICsOutNoticeOrderQueryService csOutNoticeOrderQueryService;
    @Resource
    private RepeatFilter repeatFilter;
    @Autowired
    IRelWarehouseDomain relWarehouseDomain;
    @Autowired
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;

    @Override
    public Long add(CsOutNoticeOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InOutNoticeOrderEo insertEo = new InOutNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.inOutNoticeOrderDomain.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsOutNoticeOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InOutNoticeOrderEo updateEo = new InOutNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.inOutNoticeOrderDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        InOutNoticeOrderEo eo = this.csOutNoticeOrderQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        this.inOutNoticeOrderDomain.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createOutNoticeOrder(String deliveryDocumentNo) {
        this.repeatFilter.checkRepeat("OutNotice:" + deliveryDocumentNo, () -> this.preValid(deliveryDocumentNo), true);
        QueryWrapper ReceiveDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)deliveryDocumentNo);
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_status", (Object)BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
        List ReceiveDeliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)ReceiveDeliveryNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)ReceiveDeliveryNoticeOrderEoList), "\u67e5\u8be2\u4e0d\u5230\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f");
        ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2 = (ReceiveDeliveryNoticeOrderEo)ReceiveDeliveryNoticeOrderEoList.get(0);
        CsDeliveryNoticeOrderRespDto dto = this.csDeliveryNoticeOrderQueryService.queryById(ReceiveDeliveryNoticeOrderEo2.getId());
        String logicWarehouseCode = dto.getWarehouseCode();
        QueryWrapper csRelWarehouseEoQueryWrapper = new QueryWrapper();
        csRelWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)logicWarehouseCode);
        csRelWarehouseEoQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        List csRelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)csRelWarehouseEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csRelWarehouseEoList), "\u67e5\u8be2\u4e0d\u5230\u5173\u8054\u7269\u7406\u4ed3\u5e93");
        RelWarehouseEo csRelWarehouseEo = (RelWarehouseEo)csRelWarehouseEoList.get(0);
        dto.setOutPhysicsWarehouseCode(csRelWarehouseEo.getRefWarehouseCode());
        dto.setOutPhysicsWarehouseName(csRelWarehouseEo.getRefWarehouseName());
        dto.setWarehouseId(csRelWarehouseEo.getWarehouseId());
        dto.setWarehouseCode(csRelWarehouseEo.getWarehouseCode());
        dto.setWarehouseName(csRelWarehouseEo.getWarehouseName());
        InOutNoticeOrderEo InOutNoticeOrderEo2 = new InOutNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)InOutNoticeOrderEo2, (Object)dto, (String[])new String[]{"id"});
        String documentNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.OUT_NOTICE_ORDER.getCode()).getCode();
        InOutNoticeOrderEo2.setDocumentNo(documentNo);
        InOutNoticeOrderEo2.setBusinessType(CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode());
        InOutNoticeOrderEo2.setOrderStatus(BaseOrderStatusEnum.ONO_WAIT_OUT.getCode());
        InOutNoticeOrderEo2.setRelevanceNo(dto.getRelevanceNo());
        InOutNoticeOrderEo2.setExternalOrderNo(dto.getExternalOrderNo());
        InOutNoticeOrderEo2.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode());
        InOutNoticeOrderEo2.setExtension(JSON.toJSONString((Object)dto.getContactDto()));
        InOutNoticeOrderEo2.setOrderType("out");
        ArrayList detailEoList = Lists.newArrayList();
        BigDecimal totalQuantity = BigDecimal.ZERO;
        for (CsDeliveryNoticeOrderDetailRespDto detailRespDto : dto.getDeliveryNoticeOrderDetailRespDtoList()) {
            InOutNoticeOrderDetailEo detailEo = new InOutNoticeOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)dto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailRespDto, (String[])new String[]{"id"});
            detailEo.setSkuCode(detailRespDto.getLongCode());
            detailEo.setDocumentNo(documentNo);
            detailEo.setRelevanceNo(InOutNoticeOrderEo2.getRelevanceNo());
            detailEo.setPreOrderNo(InOutNoticeOrderEo2.getPreOrderNo());
            detailEo.setDocumentNo(InOutNoticeOrderEo2.getDocumentNo());
            totalQuantity = totalQuantity.add(detailRespDto.getPlanQuantity());
            detailEo.setInitFlag(YesNoEnum.YES.getValue());
            detailEoList.add(detailEo);
        }
        InOutNoticeOrderEo2.setTotalQuantity(totalQuantity);
        InOutNoticeOrderEo2.setOutLogicWarehouseCode(dto.getDeliveryLogicWarehouseCode());
        InOutNoticeOrderEo2.setOutLogicWarehouseName(dto.getDeliveryLogicWarehouseName());
        InOutNoticeOrderEo2.setOutPhysicsWarehouseCode(dto.getDeliveryPhysicsWarehouseCode());
        InOutNoticeOrderEo2.setOutPhysicsWarehouseName(dto.getDeliveryPhysicsWarehouseName());
        InOutNoticeOrderEo2.setPreOrderNo(dto.getDocumentNo());
        InOutNoticeOrderEo2.setRelevanceNo(dto.getRelevanceNo());
        this.inOutNoticeOrderDomain.insert((BaseEo)InOutNoticeOrderEo2);
        this.inOutNoticeOrderDetailDomain.insertBatch((List)detailEoList);
        return InOutNoticeOrderEo2.getId();
    }

    @Override
    public void cancelOutNoticeOrderByPreOrderNo(String preOrderNo) {
        List InOutNoticeOrderEos = this.inOutNoticeOrderDomain.queryByPreOrderNo(preOrderNo);
        if (CollectionUtils.isNotEmpty((Collection)InOutNoticeOrderEos)) {
            for (InOutNoticeOrderEo InOutNoticeOrderEo2 : InOutNoticeOrderEos) {
                InOutNoticeOrderEo2.setOrderStatus(BaseOrderStatusEnum.ONO_CANCEL.getCode());
                this.inOutNoticeOrderDomain.getMapper().updateById((BaseEo)InOutNoticeOrderEo2);
            }
        }
    }

    private void preValid(String relevanceNo) {
        List oldList = this.inOutNoticeOrderDomain.queryByRelevanceNo(relevanceNo);
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (InOutNoticeOrderEo outNoticeOrderEo : oldList) {
                AssertUtil.isTrue(BaseOrderStatusEnum.DELIVERY_CANCEL.getCode().equals(outNoticeOrderEo.getOrderStatus()), "304", outNoticeOrderEo.getPreOrderNo() + "\u5df2\u5b58\u5728\u6d41\u8f6c\u6b63\u5e38\u7684\u524d\u7f6e\u5355\u636e");
            }
        }
    }
}

