/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryTotalQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.MqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryTotalQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.FetchDataProcessService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTotalQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryTotalBatchQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryTotalQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryTotalRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInventoryLogRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.LogicSupplyInventoryVo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class LogicInventoryTotalQueryApiImpl
implements ICsLogicInventoryTotalQueryApi {
    private static final Logger log = LoggerFactory.getLogger(LogicInventoryTotalQueryApiImpl.class);
    @Autowired
    protected ICsLogicInventoryTotalQueryService csLogicInventoryTotalQueryService;
    @Autowired
    MqService mqService;
    private final FetchDataProcessService<CsInventoryTotalQueryReqDto, CsLogicInventoryTotalRespDto> fetchDataProcessService = req -> this.csLogicInventoryTotalQueryService.queryByLogicWarehouseCodePage((CsInventoryTotalQueryReqDto)req);

    public RestResponse<CsLogicInventoryTotalRespDto> queryByPrimaryKey(Long id) {
        log.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        LogicInventoryTotalEo eo = this.csLogicInventoryTotalQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        CsLogicInventoryTotalRespDto dto = new CsLogicInventoryTotalRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)eo, (String[])new String[0]);
        return new RestResponse((Object)dto);
    }

    public RestResponse<List<CsLogicInventoryTotalRespDto>> queryWarehouseInventory(CsLogicInventoryTotalBatchQueryDto batchQueryDto) {
        List<CsLogicInventoryTotalRespDto> list = this.csLogicInventoryTotalQueryService.queryWarehouseInventory(batchQueryDto);
        return new RestResponse(list);
    }

    public RestResponse<PageInfo<CsLogicInventoryTotalRespDto>> queryByLogicWarehouseCodePage(CsInventoryTotalQueryReqDto csInventoryTotalQueryReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.csLogicInventoryTotalQueryService.queryByLogicWarehouseCodePage(csInventoryTotalQueryReqDto, pageNum, pageSize));
    }

    public RestResponse<PageInfo<CsLogicInventoryTotalRespDto>> queryAvailableGtZeroByPage(CsLogicInventoryTotalQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u53ef\u7528\u5e93\u5b58\u5927\u4e8e0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        return new RestResponse(this.csLogicInventoryTotalQueryService.queryAvailableGtZeroByPage(queryDto));
    }

    public RestResponse<List<CsLogicInventoryTotalRespDto>> queryByList(List<CsLogicInventoryTotalQueryDto> list) {
        log.info("\u6839\u636e\u96c6\u5408\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(list));
        return new RestResponse(this.csLogicInventoryTotalQueryService.queryByList(list));
    }

    public RestResponse<Map<String, List<CsLogicInventoryTotalRespDto>>> queryMapByList(List<CsLogicInventoryTotalQueryDto> list) {
        log.info("\u6839\u636e\u96c6\u5408\u67e5\u8be2map\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(list));
        List<CsLogicInventoryTotalRespDto> respDtoList = this.csLogicInventoryTotalQueryService.queryByList(list);
        Map<String, List<CsLogicInventoryTotalRespDto>> map = respDtoList.stream().collect(Collectors.groupingBy(CsLogicInventoryTotalRespDto::getWarehouseCode));
        return new RestResponse(map);
    }

    public RestResponse<Void> queryAndSendChangeLog(CsInventoryTotalQueryReqDto queryDto) {
        this.fetchDataProcessService.processAll(queryDto, data -> data.forEach(logicInventory -> {
            CsInventoryLogRespDto logInventory = new CsInventoryLogRespDto();
            BeanUtils.copyProperties((Object)logicInventory, (Object)logInventory);
            logInventory.setId(Long.valueOf(IdWorker.getId()));
            logInventory.setBeforeActivityAllocate(BigDecimal.ZERO);
            logInventory.setAfterActivityAllocate(logicInventory.getActivityAllocate());
            logInventory.setChangeActivityAllocate(logicInventory.getActivityAllocate());
            logInventory.setBeforeAllocate(BigDecimal.ZERO);
            logInventory.setAfterAllocate(logicInventory.getAllocate());
            logInventory.setChangeAllocate(logicInventory.getAllocate());
            logInventory.setBeforeAvailable(BigDecimal.ZERO);
            logInventory.setAfterAvailable(logicInventory.getAvailable());
            logInventory.setChangeAvailable(logicInventory.getAvailable());
            logInventory.setBeforeBalance(BigDecimal.ZERO);
            logInventory.setAfterBalance(logicInventory.getBalance());
            logInventory.setChangeBalance(logicInventory.getBalance());
            logInventory.setBeforePreempt(BigDecimal.ZERO);
            logInventory.setAfterPreempt(logicInventory.getPreempt());
            logInventory.setChangePreempt(logicInventory.getPreempt());
            logInventory.setBeforeIntransit(BigDecimal.ZERO);
            logInventory.setAfterIntransit(logicInventory.getIntransit());
            logInventory.setChangeIntransit(logicInventory.getIntransit());
            logInventory.setBeforeTransfer(BigDecimal.ZERO);
            logInventory.setAfterTransfer(logicInventory.getTransfer());
            logInventory.setChangeTransfer(logicInventory.getTransfer());
            logInventory.setBeforeLockInventory(BigDecimal.ZERO);
            logInventory.setAfterLockInventory(logicInventory.getLockInventory());
            logInventory.setChangeLockInventory(logicInventory.getLockInventory());
            BigDecimal otherChangePreempt = BigDecimalUtils.subtract((BigDecimal)logInventory.getChangePreempt(), (BigDecimal)logInventory.getChangeAllocate());
            logInventory.setSupplyChangeNum(BigDecimalUtils.subtract((BigDecimal)logInventory.getChangeBalance(), (BigDecimal)otherChangePreempt));
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)JSONObject.toJSONString((Object)Lists.newArrayList((Object[])new CsInventoryLogRespDto[]{logInventory})));
            this.mqService.sendInventoryChange(messageVo);
        }));
        return RestResponse.VOID;
    }

    public RestResponse<List<LogicSupplyInventoryVo>> queryLogicSupplyInventorys(List<String> warehouseCodes, List<String> cargoCodes) {
        return new RestResponse(this.csLogicInventoryTotalQueryService.queryLogicSupplyInventory(warehouseCodes, cargoCodes));
    }

    public RestResponse<List<LogicSupplyInventoryVo>> queryLogicSupplyInventory(List<String> warehouseCodes) {
        return new RestResponse(this.csLogicInventoryTotalQueryService.queryLogicSupplyInventory(warehouseCodes, null));
    }

    public RestResponse<List<CsLogicInventoryTotalRespDto>> queryListByParam(CsLogicInventoryTotalQueryDto param) {
        return null;
    }
}

