/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.IInventoryAutoAuditService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InventoryAutoAuditDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InventoryAutoAuditEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.InventoryAutoAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.InventoryAutoAuditRespDto;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InventoryAutoAuditServiceImpl
implements IInventoryAutoAuditService {
    private static Logger logger = LoggerFactory.getLogger(InventoryAutoAuditServiceImpl.class);
    @Resource
    private InventoryAutoAuditDas inventoryAutoAuditDas;

    @Override
    public Long addInventoryAutoAudit(InventoryAutoAuditReqDto addReqDto) {
        this.repeatConfirm(addReqDto);
        InventoryAutoAuditEo inventoryAutoAuditEo = new InventoryAutoAuditEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)inventoryAutoAuditEo);
        this.inventoryAutoAuditDas.insert((BaseEo)inventoryAutoAuditEo);
        return inventoryAutoAuditEo.getId();
    }

    @Override
    public Integer addInventoryAutoAuditBatch(List<InventoryAutoAuditReqDto> addReqDtos) {
        addReqDtos.forEach(addReqDto -> this.repeatConfirm((InventoryAutoAuditReqDto)addReqDto));
        ArrayList eos = new ArrayList();
        CubeBeanUtils.copyCollection(eos, addReqDtos, InventoryAutoAuditEo.class);
        return this.inventoryAutoAuditDas.insertBatch(eos);
    }

    @Override
    public void modifyInventoryAutoAudit(InventoryAutoAuditReqDto modifyReqDto) {
        this.repeatConfirm(modifyReqDto);
        InventoryAutoAuditEo inventoryAutoAuditEo = new InventoryAutoAuditEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)inventoryAutoAuditEo);
        this.inventoryAutoAuditDas.updateSelective((BaseEo)inventoryAutoAuditEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeInventoryAutoAudit(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.inventoryAutoAuditDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public InventoryAutoAuditRespDto queryById(Long id) {
        InventoryAutoAuditEo inventoryAutoAuditEo = (InventoryAutoAuditEo)this.inventoryAutoAuditDas.selectByPrimaryKey(id);
        InventoryAutoAuditRespDto inventoryAutoAuditRespDto = new InventoryAutoAuditRespDto();
        DtoHelper.eo2Dto((BaseEo)inventoryAutoAuditEo, (BaseVo)inventoryAutoAuditRespDto);
        return inventoryAutoAuditRespDto;
    }

    @Override
    public PageInfo<InventoryAutoAuditRespDto> queryByPage(InventoryAutoAuditReqDto queryDto, Integer pageNum, Integer pageSize) {
        logger.info("\u5e93\u5b58\u5ba1\u6838\u81ea\u52a8\u914d\u7f6e\u5206\u9875\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
        InventoryAutoAuditReqDto inventoryAutoAuditReqDto = queryDto;
        InventoryAutoAuditEo inventoryAutoAuditEo = new InventoryAutoAuditEo();
        DtoHelper.dto2Eo((BaseVo)inventoryAutoAuditReqDto, (BaseEo)inventoryAutoAuditEo);
        ExtQueryChainWrapper filter = this.inventoryAutoAuditDas.filter();
        if (StringUtils.isNotBlank((CharSequence)queryDto.getDocumentTypeCode())) {
            filter.eq((Object)"document_type_code", (Object)queryDto.getDocumentTypeCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getBusinessType())) {
            filter.like((Object)"business_type", (Object)queryDto.getBusinessType());
        }
        PageInfo eoPageInfo = filter.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)eoPageInfo.getList())) {
            return dtoPageInfo;
        }
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, InventoryAutoAuditRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private void repeatConfirm(InventoryAutoAuditReqDto reqDto) {
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryAutoAuditDas.filter().eq((Object)"document_type_code", (Object)reqDto.getDocumentTypeCode())).eq((Object)"business_type_code", (Object)reqDto.getBusinessTypeCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            AssertUtil.isTrue(false, "500", reqDto.getDocumentType() + "-->\u5e93\u5b58\u5ba1\u6838\u914d\u7f6e\u5df2\u5b58\u5728\uff01");
        }
    }
}

