/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.ICspMqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.IEasMqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.MqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.AbstractCsBasicsOrderOperateService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.anno.CsBasicsOrderOperateStrategy;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsBusinessOrderCallBackUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBusinessCallBackStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderItemStatusEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BasicsOrderOperateTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@CsBasicsOrderOperateStrategy(strategyName="receiveDeliveryResultOrder")
@Component(value="CsreceiveDeliveryResultOrderbasicsOrderStrategyService")
public class CsReceiveDeliveryResultOrderOperateServiceImpl
extends AbstractCsBasicsOrderOperateService {
    private static final Logger logger = LoggerFactory.getLogger(CsReceiveDeliveryResultOrderOperateServiceImpl.class);
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    private IEasMqService easMqService;
    @Resource
    private ICspMqService cspMqService;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private MqService mqService;

    private Long generateReceiveDeliveryOrder(CsBasicsOrderReqDto orderReqDto) {
        ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = new ReceiveDeliveryResultOrderEo();
        String documentNo = orderReqDto.getDocumentNo();
        if (StringUtils.isEmpty((CharSequence)documentNo)) {
            String generateCodeStrategy;
            if (BasicsOrderOperateTypeEnum.RECEIVE.getCode().equals(orderReqDto.getBasicsOrderOperateType())) {
                generateCodeStrategy = CsGenerateCodeStrategyEnum.RECEIVE_RESULT_ORDER.getCode();
                if (CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT_IN.getCode().equals(orderReqDto.getBusinessType())) {
                    generateCodeStrategy = CsGenerateCodeStrategyEnum.IN_TRANSIT_RECEIVE_RESULT_ORDER.getCode();
                }
                documentNo = GenerateCodeUtils.getStrategy(generateCodeStrategy).getCode();
            } else {
                generateCodeStrategy = CsGenerateCodeStrategyEnum.DELIVERY_RESULT_ORDE.getCode();
                if (CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT_OUT.getCode().equals(orderReqDto.getBusinessType())) {
                    generateCodeStrategy = CsGenerateCodeStrategyEnum.IN_TRANSIT_DELIVERY_RESULT_ORDER.getCode();
                }
                documentNo = GenerateCodeUtils.getStrategy(generateCodeStrategy).getCode();
            }
            orderReqDto.setDocumentNo(documentNo);
        }
        CubeBeanUtils.copyProperties((Object)csDeliveryResultOrderEo, (Object)orderReqDto, (String[])new String[0]);
        if (CsRelevanceTableNameEnum.CS_BATCH_ADJUSTMENT_ORDER.getCode().equals(orderReqDto.getRelevanceTableName())) {
            csDeliveryResultOrderEo.setDeliveryLogicWarehouseCode(orderReqDto.getLogicWarehouseCode());
            csDeliveryResultOrderEo.setDeliveryLogicWarehouseName(orderReqDto.getLogicWarehouseName());
            csDeliveryResultOrderEo.setDeliveryPhysicsWarehouseCode(orderReqDto.getPhysicsWarehouseCode());
            csDeliveryResultOrderEo.setDeliveryPhysicsWarehouseName(orderReqDto.getPhysicsWarehouseName());
            csDeliveryResultOrderEo.setReceiveLogicWarehouseCode(orderReqDto.getLogicWarehouseCode());
            csDeliveryResultOrderEo.setReceiveLogicWarehouseName(orderReqDto.getLogicWarehouseName());
            csDeliveryResultOrderEo.setReceivePhysicsWarehouseCode(orderReqDto.getPhysicsWarehouseCode());
            csDeliveryResultOrderEo.setReceivePhysicsWarehouseName(orderReqDto.getPhysicsWarehouseName());
        } else if (BasicsOrderOperateTypeEnum.DELIVERY.getCode().equals(orderReqDto.getBasicsOrderOperateType())) {
            csDeliveryResultOrderEo.setDeliveryLogicWarehouseCode(orderReqDto.getLogicWarehouseCode());
            csDeliveryResultOrderEo.setDeliveryLogicWarehouseName(orderReqDto.getLogicWarehouseName());
            csDeliveryResultOrderEo.setDeliveryPhysicsWarehouseCode(orderReqDto.getPhysicsWarehouseCode());
            csDeliveryResultOrderEo.setDeliveryPhysicsWarehouseName(orderReqDto.getPhysicsWarehouseName());
        } else {
            csDeliveryResultOrderEo.setReceiveLogicWarehouseCode(orderReqDto.getLogicWarehouseCode());
            csDeliveryResultOrderEo.setReceiveLogicWarehouseName(orderReqDto.getLogicWarehouseName());
            csDeliveryResultOrderEo.setReceivePhysicsWarehouseCode(orderReqDto.getPhysicsWarehouseCode());
            csDeliveryResultOrderEo.setReceivePhysicsWarehouseName(orderReqDto.getPhysicsWarehouseName());
        }
        csDeliveryResultOrderEo.setOrderType(BasicsOrderOperateTypeEnum.DELIVERY.getCode().equals(orderReqDto.getBasicsOrderOperateType()) ? "delivery" : "receive");
        csDeliveryResultOrderEo.setTotalQuantity(orderReqDto.getTotalQuantity() == null ? BigDecimal.ZERO : orderReqDto.getTotalQuantity());
        csDeliveryResultOrderEo.setRemark(orderReqDto.getRemark());
        List csOutResultOrderEos = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderEo.class).eq(InOutResultOrderEo::getRelevanceNo, (Object)csDeliveryResultOrderEo.getRelevanceNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        logger.info("\u67e5\u8be2\u51fa\u5e93\u7ed3\u679c\u5355\u4fe1\u606f: {}", (Object)LogUtils.buildLogContent(csOutResultOrderEos));
        if (CollectionUtils.isNotEmpty((Collection)csOutResultOrderEos)) {
            InOutResultOrderEo csOutResultOrderEo = (InOutResultOrderEo)csOutResultOrderEos.get(0);
            csDeliveryResultOrderEo.setShippingCode(csOutResultOrderEo.getShippingCode());
            csDeliveryResultOrderEo.setShippingCompanyCode(csOutResultOrderEo.getShippingCompanyCode());
            csDeliveryResultOrderEo.setShippingType(csOutResultOrderEo.getShippingType());
            csDeliveryResultOrderEo.setShippingCompany(csOutResultOrderEo.getShippingCompany());
            csDeliveryResultOrderEo.setShippingCode(csOutResultOrderEo.getShippingCode());
            csDeliveryResultOrderEo.setShippingJson(csOutResultOrderEo.getShippingJson());
        }
        List reqDtoList = orderReqDto.getOrderBasicsDetailReqDtoList();
        ArrayList<ReceiveDeliveryResultOrderDetailEo> detailEoList = new ArrayList<ReceiveDeliveryResultOrderDetailEo>(reqDtoList.size());
        for (CsBasicsOrderDetailReqDto d : reqDtoList) {
            ReceiveDeliveryResultOrderDetailEo detailEo = new ReceiveDeliveryResultOrderDetailEo();
            detailEo.setSkuCode(d.getLongCode());
            detailEo.setSkuName(d.getItemName());
            detailEo.setBatch(d.getBatch());
            detailEo.setDocumentNo(documentNo);
            detailEo.setPlanQuantity(d.getQuantity());
            detailEo.setWaitQuantity(BigDecimal.ZERO);
            detailEo.setCancelQuantity(BigDecimal.ZERO);
            detailEo.setDoneQuantity(d.getQuantity());
            detailEo.setQuantity(d.getQuantity());
            detailEo.setExternalOrderNo(orderReqDto.getExternalOrderNo());
            detailEo.setPreOrderNo(orderReqDto.getPreOrderNo());
            detailEo.setRelevanceNo(orderReqDto.getRelevanceNo());
            detailEo.setPreOrderItemId(d.getTradeOrderItemId());
            detailEo.setInitFlag(YesNoEnum.YES.getValue());
            detailEo.setItemStatus(CsPlannedOrderItemStatusEnum.COMMON.getCode());
            detailEo.setExtension(d.getExtension());
            detailEoList.add(detailEo);
        }
        List shippingInfoReqDtoList = orderReqDto.getShippingInfoReqDtoList();
        if (CollectionUtils.isNotEmpty((Collection)shippingInfoReqDtoList)) {
            String shippingJSON = JSON.toJSONString((Object)shippingInfoReqDtoList);
            csDeliveryResultOrderEo.setShippingJson(shippingJSON);
        }
        this.receiveDeliveryResultOrderDomain.insert((BaseEo)csDeliveryResultOrderEo);
        this.receiveDeliveryResultOrderDetailDomain.insertBatch(detailEoList);
        CsOrderBusinessCallBackContext context = new CsOrderBusinessCallBackContext();
        CsDeliveryReceiveResultRespDto csDeliveryReceiveResultRespDto = new CsDeliveryReceiveResultRespDto();
        CubeBeanUtils.copyProperties((Object)csDeliveryReceiveResultRespDto, (Object)csDeliveryResultOrderEo, (String[])new String[0]);
        ArrayList deliveryReceiveResultDetailRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)deliveryReceiveResultDetailRespDtoList, detailEoList, CsDeliveryReceiveResultDetailRespDto.class);
        csDeliveryReceiveResultRespDto.setDeliveryReceiveResultDetailRespDtoList((List)deliveryReceiveResultDetailRespDtoList);
        context.setDeliveryReceiveResultOrderNo(csDeliveryResultOrderEo.getDocumentNo());
        context.setCsDeliveryReceiveResultRespDto(csDeliveryReceiveResultRespDto);
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)orderReqDto.getRelevanceTableName());
        if (null == callBackStrategyEnum) {
            return csDeliveryResultOrderEo.getId();
        }
        ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        context.setCsBasicsOrderReqDto(orderReqDto);
        context.setInFlag(Boolean.valueOf(false));
        if (BasicsOrderOperateTypeEnum.RECEIVE.getCode().equals(orderReqDto.getBasicsOrderOperateType())) {
            context.setInFlag(Boolean.valueOf(true));
        }
        context.setRelevanceNo(csDeliveryResultOrderEo.getRelevanceNo());
        context.setDocumentNo(documentNo);
        context.setInResultOrderNo(documentNo);
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSON.toJSONString((Object)csDeliveryReceiveResultRespDto));
        if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(orderReqDto.getRelevanceTableName())) {
            if (BasicsOrderOperateTypeEnum.RECEIVE.getCode().equals(orderReqDto.getBasicsOrderOperateType())) {
                this.mqService.publicSendResultDetailDelayProcessor(messageVo);
                logger.info("\u751f\u6210\u6536\u53d1\u8d27\u7ed3\u679c\u5355,\u5ef6\u65f6\u5e7f\u64ad\u7ed3\u679c:{}", (Object)LogUtils.buildLogContent(messageVo));
            } else {
                this.mqService.publicSendResultDetailProcessor(messageVo);
                logger.info("\u751f\u6210\u6536\u53d1\u8d27\u7ed3\u679c\u5355,\u5e7f\u64ad\u7ed3\u679c:{}", (Object)LogUtils.buildLogContent(messageVo));
            }
            businessOrderCallBackService.deliveryReceiveResultOrderCallBack(context);
        } else {
            businessOrderCallBackService.deliveryReceiveResultOrderCallBack(context);
            this.mqService.publicSendResultDetailProcessor(messageVo);
            logger.info("\u751f\u6210\u6536\u53d1\u8d27\u7ed3\u679c\u5355,\u5e7f\u64ad\u7ed3\u679c:{}", (Object)LogUtils.buildLogContent(messageVo));
        }
        return csDeliveryResultOrderEo.getId();
    }
}

