/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInventoryAdjustQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.adjust.CsInventoryAdjustEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.adjust.CsInventoryAdjustDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.adjust.CsInventoryAdjustMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInventoryAdjustQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInventoryAdjustDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInventoryAdjustRespDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="csInventoryAdjustQueryService")
public class CsInventoryAdjustQueryServiceImpl
implements ICsInventoryAdjustQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsInventoryAdjustQueryServiceImpl.class);
    @Resource
    private CsInventoryAdjustMapper csInventoryAdjustMapper;
    @Resource
    private CsInventoryAdjustDetailMapper csInventoryAdjustDetailMapper;

    @Override
    public CsInventoryAdjustEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        return (CsInventoryAdjustEo)this.csInventoryAdjustMapper.selectById((Serializable)id);
    }

    @Override
    public CsInventoryAdjustRespDto queryById(Long id) {
        CsInventoryAdjustEo csInventoryAdjustEo = (CsInventoryAdjustEo)this.csInventoryAdjustMapper.selectById((Serializable)id);
        AssertUtil.isTrue(null != csInventoryAdjustEo && null != csInventoryAdjustEo.getId(), "\u8c03\u6574\u5355\u4e0d\u5b58\u5728");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"document_no", (Object)csInventoryAdjustEo.getDocumentNo());
        List detailEoList = this.csInventoryAdjustDetailMapper.selectList((Wrapper)wrapper);
        CsInventoryAdjustRespDto dto = new CsInventoryAdjustRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)csInventoryAdjustEo, (String[])new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
            ArrayList detailRespDtoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)detailRespDtoList, (Collection)detailEoList, CsInventoryAdjustDetailRespDto.class);
            dto.setAdjustDetailRespDtoList((List)detailRespDtoList);
        }
        return dto;
    }

    @Override
    public PageInfo<CsInventoryAdjustRespDto> queryByPage(CsInventoryAdjustQueryDto queryDto) {
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtil.isNotBlank((String)queryDto.getOrderStatus())) {
            wrapper.eq((Object)"order_status", (Object)queryDto.getOrderStatus());
        }
        if (StringUtil.isNotBlank((String)queryDto.getDocumentNo())) {
            wrapper.like((Object)"document_no", (Object)queryDto.getDocumentNo());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseName())) {
            wrapper.like((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseCode())) {
            wrapper.like((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtil.isNotBlank((String)queryDto.getCreateTimeStart()) && StringUtil.isNotBlank((String)queryDto.getCreateTimeEnd())) {
            wrapper.between((Object)"create_time", (Object)queryDto.getCreateTimeStart(), (Object)queryDto.getCreateTimeEnd());
        }
        wrapper.orderByDesc((Object)queryDto.getOrderByDesc());
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List selectList = this.csInventoryAdjustMapper.selectList((Wrapper)wrapper);
        PageInfo page = new PageInfo(selectList);
        ArrayList list = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)page.getList(), (Collection)list, CsInventoryAdjustRespDto.class);
        PageInfo pageInfo = new PageInfo((List)list);
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        return pageInfo;
    }

    @Override
    public List<CsInventoryAdjustEo> queryByParam(CsInventoryAdjustQueryDto queryDto) {
        logger.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto));
        return null;
    }

    @Override
    public List<CsInventoryAdjustEo> queryByIds(List<Long> ids) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"id", ids);
        return this.csInventoryAdjustMapper.selectList((Wrapper)wrapper);
    }
}

