/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInspectionReleaseTaskService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INVENTORY_BUSINESS_TOPIC", tag="CANCEL_DELIVERY_NOTICE")
public class CancelDeliveryNoticeProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(CancelDeliveryNoticeProcess.class);
    @Autowired
    IInspectionReleaseTaskService inspectionReleaseTaskService;

    public MessageResponse process(MessageVo message) {
        log.info("CancelDeliveryNoticeProcess\uff1a{}", (Object)LogUtils.buildLogContent(message));
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        String orderNo = String.valueOf(message.getData());
        this.cancelOtherOut(orderNo);
        this.cancelTransfer(orderNo);
        return MessageResponse.SUCCESS;
    }

    private void cancelOtherOut(String orderNo) {
        try {
            log.info("cancelOtherOut : {}", (Object)orderNo);
            this.inspectionReleaseTaskService.cancelOtherOut(orderNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("cancelOtherOut \u5931\u8d25\uff1a{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void cancelTransfer(String orderNo) {
        try {
            log.info("cancelTransfer : {}", (Object)orderNo);
            this.inspectionReleaseTaskService.cancelTransfer(orderNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("cancelTransfer \u5931\u8d25\uff1a{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

