/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.IGenerateCodeService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.CsBasicsOrderStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.ICsBasicsOrderOperateService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.ICsOutPlannedOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.ICsOutPlannedOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.ICsStorageAuditRecordService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.out.CsOutPlannedOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.out.CsOutPlannedOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.other.CsInventorySupplierDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutPlannedOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsInventorySupplierEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics.ResultStateEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsStorageAuditRecordReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.basics.CsOverchargeAdjustDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.basics.CsOverchargeAdjustReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedDifferenceAdjustReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedRelieveDifferenceReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderAuditResultEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderItemStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderOperateEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csOutPlannedOrderService")
public class CsOutPlannedOrderServiceImpl
implements ICsOutPlannedOrderService {
    private static final Logger logger = LoggerFactory.getLogger(CsOutPlannedOrderServiceImpl.class);
    @Autowired
    CsOutPlannedOrderDas csOutPlannedOrderDas;
    @Autowired
    ICsOutPlannedOrderQueryService csOutPlannedOrderQueryService;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    CsInventorySupplierDas inventorySupplierDas;
    @Resource
    CsOutPlannedOrderDetailDas outPlannedOrderDetailDas;
    @Resource
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    CsBasicsOrderStrategyUtils csBasicsOrderStrategyUtils;
    @Resource
    ICsStorageAuditRecordService storageAuditRecordService;
    @Resource
    IRelWarehouseDomain relWarehouseDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    ILogicInventoryDomain logicInventoryDomain;
    @Resource
    IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Resource
    ICsInventoryPreemptionQueryService csInventoryPreemptionQueryService;
    @Resource
    ICalcInventoryService calcInventoryService;
    @Autowired
    private RepeatFilter repeatFilter;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private CsOutPlannedOrderDetailDas csOutPlannedOrderDetailDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CsOutPlannedOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsOutPlannedOrderEo insertEo = CsOutPlannedOrderEo.newInstance();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.csOutPlannedOrderDas.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(Long id, CsOutPlannedOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsOutPlannedOrderEo updateEo = CsOutPlannedOrderEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.csOutPlannedOrderDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        CsOutPlannedOrderEo eo = this.csOutPlannedOrderQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.csOutPlannedOrderDas.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long generateRetreatOrder(CsOutPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        logger.info("generateRetreatOrder==>\u751f\u6210\u9000\u8d27\u5355\u636e,plannedOrderGenerateReqDto:{}", (Object)LogUtils.buildLogContent(plannedOrderGenerateReqDto));
        this.checkParams(plannedOrderGenerateReqDto);
        String operateFlag = plannedOrderGenerateReqDto.getOperateFlag();
        CsOutPlannedOrderAddReqDto addReqDto = new CsOutPlannedOrderAddReqDto();
        CubeBeanUtils.copyProperties((Object)addReqDto, (Object)plannedOrderGenerateReqDto, (String[])new String[0]);
        addReqDto.setPlatformOrderNo(plannedOrderGenerateReqDto.getPlatformOrderNo());
        addReqDto.setDeliveryWarehouseId(plannedOrderGenerateReqDto.getWarehouseId());
        addReqDto.setDeliveryWarehouseCode(plannedOrderGenerateReqDto.getWarehouseCode());
        addReqDto.setDeliveryWarehouseName(plannedOrderGenerateReqDto.getWarehouseName());
        String orderNo = plannedOrderGenerateReqDto.getOrderNo();
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            String orderType = plannedOrderGenerateReqDto.getOrderType();
            orderNo = this.generateCode(orderType);
        }
        addReqDto.setOrderNo(orderNo);
        addReqDto.setOrderStatus(CsPlannedOrderStatusEnum.WAIT_SUBMIT.getCode());
        if (CsPlannedOrderOperateEnum.SUBMIT.getCode().equals(operateFlag)) {
            addReqDto.setOrderStatus(CsPlannedOrderStatusEnum.WAIT_AUDIT.getCode());
        }
        List itemDetailList = plannedOrderGenerateReqDto.getItemDetailList();
        BigDecimal totalPlanQuantity = itemDetailList.stream().map(CsOutPlannedOrderGenerateDetailReqDto::getPlanQuantity).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        addReqDto.setTotalQuantity(totalPlanQuantity);
        CsOutPlannedOrderEo insertEo = new CsOutPlannedOrderEo();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        insertEo.setNoBatch(StringUtils.isBlank((CharSequence)((CsOutPlannedOrderGenerateDetailReqDto)itemDetailList.get(0)).getBatch()) ? YesNoEnum.YES.getValue() : YesNoEnum.NO.getValue());
        this.csOutPlannedOrderDas.insert((BaseEo)insertEo);
        Long plannedOrderId = insertEo.getId();
        ArrayList orderDetailEoList = Lists.newArrayList();
        for (CsOutPlannedOrderGenerateDetailReqDto itemDto : itemDetailList) {
            CsOutPlannedOrderDetailEo outPlannedOrderDetailEo = new CsOutPlannedOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)outPlannedOrderDetailEo, (Object)itemDto, (String[])new String[0]);
            outPlannedOrderDetailEo.setCargoName(itemDto.getCargoName());
            outPlannedOrderDetailEo.setPlatformOrderNo(plannedOrderGenerateReqDto.getPlatformOrderNo());
            outPlannedOrderDetailEo.setOrderNo(orderNo);
            outPlannedOrderDetailEo.setLongCode(itemDto.getLongCode());
            outPlannedOrderDetailEo.setBatch(itemDto.getBatch());
            outPlannedOrderDetailEo.setPlanQuantity(itemDto.getPlanQuantity());
            outPlannedOrderDetailEo.setDoneQuantity(BigDecimal.ZERO);
            outPlannedOrderDetailEo.setWaitQuantity(itemDto.getPlanQuantity());
            outPlannedOrderDetailEo.setCancelQuantity(BigDecimal.ZERO);
            outPlannedOrderDetailEo.setDifferenceQuantity(BigDecimal.ZERO);
            outPlannedOrderDetailEo.setExpireTime(itemDto.getExpireTime());
            outPlannedOrderDetailEo.setProduceTime(itemDto.getProduceTime());
            outPlannedOrderDetailEo.setItemStatus(CsPlannedOrderItemStatusEnum.COMMON.getCode());
            orderDetailEoList.add(outPlannedOrderDetailEo);
        }
        this.outPlannedOrderDetailDas.insertBatch((List)orderDetailEoList);
        return plannedOrderId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CsOutPlannedOrderResultRespDto auditRetreatOrder(CsOutPlannedOrderAuditReqDto plannedOrderAuditReqDto) {
        logger.info("auditRetreatOrder==>\u5ba1\u6838\u9000\u8d27\u5355\u636e,plannedOrderAuditReqDto:{}", (Object)LogUtils.buildLogContent(plannedOrderAuditReqDto));
        String key = "OUT_PLANNED_AUDIT:" + plannedOrderAuditReqDto.getOrderNo();
        this.repeatFilter.checkRepeat(key, () -> this.checkParams(plannedOrderAuditReqDto), true);
        String orderNo = plannedOrderAuditReqDto.getOrderNo();
        CsOutPlannedOrderEo csOutPlannedOrderEo = (CsOutPlannedOrderEo)((ExtQueryChainWrapper)this.csOutPlannedOrderDas.filter().eq((Object)"order_no", (Object)orderNo)).one();
        AssertUtil.isTrue(null != csOutPlannedOrderEo, "\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CsPlannedOrderStatusEnum.WAIT_AUDIT.getCode().equals(csOutPlannedOrderEo.getOrderStatus()), "\u975e\u5f85\u5ba1\u6838\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c");
        List orderDetailEoList = ((ExtQueryChainWrapper)this.outPlannedOrderDetailDas.filter().eq((Object)"order_no", (Object)orderNo)).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)orderDetailEoList), "\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        String auditResult = plannedOrderAuditReqDto.getAuditResult();
        CsOutPlannedOrderResultRespDto csOutPlannedOrderResultRespDto = new CsOutPlannedOrderResultRespDto();
        csOutPlannedOrderResultRespDto.setStatus(ResultStateEnum.SUCCESS.getCode());
        csOutPlannedOrderResultRespDto.setMessage("\u5ba1\u6838\u5b8c\u6210");
        if (CsPlannedOrderAuditResultEnum.AUDIT_PASS.getCode().equals(auditResult)) {
            csOutPlannedOrderResultRespDto = this.auditPassPlannedOrder(plannedOrderAuditReqDto, csOutPlannedOrderEo, orderDetailEoList);
        } else if (CsPlannedOrderAuditResultEnum.AUDIT_FAILED.getCode().equals(auditResult)) {
            this.auditFailedOrder(plannedOrderAuditReqDto, csOutPlannedOrderEo);
        }
        return csOutPlannedOrderResultRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelByOrderNo(String orderNo) {
        logger.info("cancelByOrderNo==>\u6839\u636e\u5355\u636e\u53f7\u5173\u95ed\u9000\u8d27\u5355\u636e,orderNo:{}", (Object)orderNo);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u5355\u636e\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsOutPlannedOrderEo csOutPlannedOrderEo = (CsOutPlannedOrderEo)((ExtQueryChainWrapper)this.csOutPlannedOrderDas.filter().eq((Object)"order_no", (Object)orderNo)).one();
        AssertUtil.isTrue(null != csOutPlannedOrderEo, "\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        ArrayList<String> statusList = new ArrayList<String>(3);
        statusList.add(CsPlannedOrderStatusEnum.WAIT_SUBMIT.getCode());
        statusList.add(CsPlannedOrderStatusEnum.WAIT_AUDIT.getCode());
        statusList.add(CsPlannedOrderStatusEnum.AUDIT_FAILED.getCode());
        String orderStatus = csOutPlannedOrderEo.getOrderStatus();
        if (!statusList.contains(orderStatus)) {
            throw new BizException(String.format("\u5f53\u524d\u3010%s\u3011\u72b6\u6001\u4e0d\u5141\u8bb8\u53d6\u6d88", CsPlannedOrderStatusEnum.getByCode((String)orderStatus).getDesc()));
        }
        csOutPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.CANCEL.getCode());
        this.csOutPlannedOrderDas.updateSelective((BaseEo)csOutPlannedOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long editRetreatOrder(CsOutPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        logger.info("editPlannedOrder==>\u8ba1\u5212\u5355\u636e\u7f16\u8f91\u91cd\u65b0\u63d0\u4ea4,plannedOrderGenerateReqDto:{}", (Object)LogUtils.buildLogContent(plannedOrderGenerateReqDto));
        String orderNo = plannedOrderGenerateReqDto.getOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u5355\u636e\u53f7\u4e0d\u5b58\u5728");
        CsOutPlannedOrderEo csOutPlannedOrderEo = (CsOutPlannedOrderEo)((ExtQueryChainWrapper)this.csOutPlannedOrderDas.filter().eq((Object)"order_no", (Object)orderNo)).one();
        AssertUtil.isTrue(null != csOutPlannedOrderEo, "\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        String orderStatus = csOutPlannedOrderEo.getOrderStatus();
        AssertUtil.isTrue(CsPlannedOrderStatusEnum.WAIT_SUBMIT.getCode().equals(orderStatus) || CsPlannedOrderStatusEnum.AUDIT_FAILED.getCode().equals(orderStatus), String.format("\u5f53\u524d\u3010%s\u3011\u72b6\u6001\u4e0d\u5141\u8bb8\u7f16\u8f91", CsPlannedOrderStatusEnum.getByCode((String)orderStatus).getDesc()));
        this.csOutPlannedOrderDas.logicDeleteById(csOutPlannedOrderEo.getId());
        List orderDetailList = ((ExtQueryChainWrapper)this.outPlannedOrderDetailDas.filter().eq((Object)"order_no", (Object)orderNo)).list();
        if (CollectionUtils.isNotEmpty((Collection)orderDetailList)) {
            List ids = orderDetailList.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.outPlannedOrderDetailDas.logicDeleteByIds(ids);
        }
        plannedOrderGenerateReqDto.setCreateTime(csOutPlannedOrderEo.getCreateTime());
        plannedOrderGenerateReqDto.setCreatePerson(csOutPlannedOrderEo.getCreatePerson());
        Long plannedOrderId = this.generateRetreatOrder(plannedOrderGenerateReqDto);
        return plannedOrderId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitByOrderNo(String orderNo) {
        logger.info("submitByOrderNo==>\u6839\u636e\u5355\u636e\u53f7\u63d0\u4ea4\u9000\u8d27\u5355\u636e,orderNo:{}", (Object)orderNo);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u5355\u636e\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsOutPlannedOrderEo csOutPlannedOrderEo = (CsOutPlannedOrderEo)((ExtQueryChainWrapper)this.csOutPlannedOrderDas.filter().eq((Object)"order_no", (Object)orderNo)).one();
        AssertUtil.isTrue(null != csOutPlannedOrderEo, "\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        String orderStatus = csOutPlannedOrderEo.getOrderStatus();
        AssertUtil.isTrue(CsPlannedOrderStatusEnum.WAIT_SUBMIT.getCode().equals(orderStatus) || CsPlannedOrderStatusEnum.AUDIT_FAILED.getCode().equals(orderStatus), String.format("\u5f53\u524d\u3010%s\u3011\u72b6\u6001\u4e0d\u5141\u8bb8\u63d0\u4ea4", CsPlannedOrderStatusEnum.getByCode((String)orderStatus).getDesc()));
        CsOutPlannedOrderEo outPlannedOrderEo = new CsOutPlannedOrderEo();
        outPlannedOrderEo.setId(csOutPlannedOrderEo.getId());
        outPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.WAIT_AUDIT.getCode());
        this.csOutPlannedOrderDas.updateSelective((BaseEo)outPlannedOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void relieveDifferenceByOrderDocumentNo(CsOutPlannedRelieveDifferenceReqDto outPlannedRelieveDifferenceReqDto) {
        logger.info("relieveDifferenceByOrderDocumentNo==>\u6839\u636e\u51fa\u5e93\u7ed3\u679c\u5355\u5355\u53f7\u89e3\u6302\u51fa\u5e93\u7ed3\u679c\u5355,outPlannedRelieveDifferenceReqDto:{}", (Object)LogUtils.buildLogContent(outPlannedRelieveDifferenceReqDto));
        ICsBasicsOrderOperateService basicsOrderOperateService = CsBasicsOrderStrategyUtils.getBasicsOrderOperateService("inOutResultOrder");
        basicsOrderOperateService.relieveOvercharge(outPlannedRelieveDifferenceReqDto.getOutResultDocumentNo());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void differenceAdjust(CsOutPlannedDifferenceAdjustReqDto differenceAdjustReqDto) {
        logger.info("differenceAdjust==>\u8d85\u6536\u6570\u636e\u8c03\u6574\u4fdd\u5b58\u63d0\u4ea4,overchargeAdjustReqDto:{}", (Object)LogUtils.buildLogContent(differenceAdjustReqDto));
        ICsBasicsOrderOperateService basicsOrderOperateService = CsBasicsOrderStrategyUtils.getBasicsOrderOperateService("inOutResultOrder");
        CsOverchargeAdjustReqDto csOverchargeAdjustReqDto = new CsOverchargeAdjustReqDto();
        csOverchargeAdjustReqDto.setInResultDocumentNo(differenceAdjustReqDto.getOutResultDocumentNo());
        csOverchargeAdjustReqDto.setRemark(differenceAdjustReqDto.getRemark());
        ArrayList adjustDetailReqDtoList = new ArrayList();
        CubeBeanUtils.copyCollection(adjustDetailReqDtoList, (Collection)differenceAdjustReqDto.getDetailReqDtoList(), CsOverchargeAdjustDetailReqDto.class);
        csOverchargeAdjustReqDto.setDetailReqDtoList(adjustDetailReqDtoList);
        basicsOrderOperateService.relieveOvercharge(csOverchargeAdjustReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateInventoryFoyOutPlannedOrder(CsOutPlannedOrderEo csOutPlannedOrderEo, String outResultOrderDocumentNo, Boolean portionFlag) {
    }

    private List<String> getChannelWarehouseCode(String logicWarehouseCode) {
        QueryWrapper csRelWarehouseEoQueryWrapper = new QueryWrapper();
        csRelWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csRelWarehouseEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)logicWarehouseCode);
        csRelWarehouseEoQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.CHANNEL.getCode());
        List csRelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)csRelWarehouseEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csRelWarehouseEoList)) {
            return Lists.newArrayList();
        }
        return csRelWarehouseEoList.stream().map(RelWarehouseEo::getRefWarehouseCode).collect(Collectors.toList());
    }

    private void auditFailedOrder(CsOutPlannedOrderAuditReqDto plannedOrderAuditReqDto, CsOutPlannedOrderEo csOutPlannedOrderEo) {
        logger.info("auditPassFailedOrder==>\u5ba1\u6838\u4e0d\u901a\u8fc7,plannedOrderAuditReqDto:{},csInPlannedOrderEo:{}", (Object)LogUtils.buildLogContent(plannedOrderAuditReqDto), (Object)LogUtils.buildLogContent(csOutPlannedOrderEo));
        csOutPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.AUDIT_FAILED.getCode());
        csOutPlannedOrderEo.setRemark(plannedOrderAuditReqDto.getRemark());
        this.csOutPlannedOrderDas.updateSelective((BaseEo)csOutPlannedOrderEo);
        this.auditPlannedOrderResult(plannedOrderAuditReqDto);
    }

    private CsOutPlannedOrderResultRespDto auditPassPlannedOrder(CsOutPlannedOrderAuditReqDto plannedOrderAuditReqDto, CsOutPlannedOrderEo outPlannedOrderEo, List<CsOutPlannedOrderDetailEo> orderDetailEoList) {
        logger.info("auditPassPlannedOrder==>\u5ba1\u6838\u901a\u8fc7,plannedOrderAuditReqDto:{},outPlannedOrderEo:{}", (Object)LogUtils.buildLogContent(plannedOrderAuditReqDto), (Object)LogUtils.buildLogContent(outPlannedOrderEo));
        CsOutPlannedOrderResultRespDto csOutPlannedOrderResultRespDto = new CsOutPlannedOrderResultRespDto();
        csOutPlannedOrderResultRespDto.setStatus(ResultStateEnum.SUCCESS.getCode());
        csOutPlannedOrderResultRespDto.setMessage("\u5ba1\u6838\u5b8c\u6210");
        List<String> errorList = this.checkInventory(outPlannedOrderEo, orderDetailEoList);
        AssertUtil.isTrue(CollectionUtils.isEmpty(errorList), String.join((CharSequence)",", errorList) + "\u5e93\u5b58\u4e0d\u8db3");
        outPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.WAIT_OUT.getCode());
        this.csOutPlannedOrderDas.updateSelective((BaseEo)outPlannedOrderEo);
        this.auditPlannedOrderResult(plannedOrderAuditReqDto);
        this.generateReceiveOrderInfo(outPlannedOrderEo, orderDetailEoList);
        return csOutPlannedOrderResultRespDto;
    }

    private void preemptInventory(CsOutPlannedOrderEo outPlannedOrderEo, List<CsOutPlannedOrderDetailEo> orderDetailEoList) {
        PreemptDto preemptParam = new PreemptDto();
        preemptParam.setSourceNo(outPlannedOrderEo.getOrderNo());
        preemptParam.setSourceType(outPlannedOrderEo.getBusinessType());
        preemptParam.setBusinessType(outPlannedOrderEo.getBusinessType());
        preemptParam.setExternalOrderNo(outPlannedOrderEo.getPlatformOrderNo());
        ArrayList detailParams = Lists.newArrayList();
        for (CsOutPlannedOrderDetailEo detailReqDto : orderDetailEoList) {
            CalcDetailDto detailParam = new CalcDetailDto();
            BigDecimal preempt = BigDecimalUtils.abs((BigDecimal)detailReqDto.getPlanQuantity());
            detailParam.setNum(preempt);
            detailParam.setSkuCode(detailReqDto.getLongCode());
            String warehouseCode = outPlannedOrderEo.getDeliveryWarehouseCode();
            detailParam.setLogicWarehouseCode(warehouseCode);
            detailParam.setBatch(detailReqDto.getBatch());
            detailParams.add(detailParam);
            preemptParam.setNoneBatch(Boolean.valueOf(StringUtils.isEmpty((CharSequence)detailReqDto.getBatch())));
            preemptParam.setShoutBatch(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)detailReqDto.getBatch())));
        }
        preemptParam.setDetails((List)detailParams);
        this.calcInventoryService.preempt(preemptParam);
    }

    private void generateReceiveOrderInfo(final CsOutPlannedOrderEo csOutPlannedOrderEo, List<CsOutPlannedOrderDetailEo> orderDetailEoList) {
        logger.info("generateReceiveOrderInfo==>\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,orderNo:{}", (Object)csOutPlannedOrderEo.getOrderNo());
        ReceiveDeliveryNoticeOrderFacadeBo deliveryNoticeOrderContext = new ReceiveDeliveryNoticeOrderFacadeBo();
        deliveryNoticeOrderContext.setBusinessType(csOutPlannedOrderEo.getBusinessType());
        deliveryNoticeOrderContext.setSourceType(csOutPlannedOrderEo.getBusinessType());
        deliveryNoticeOrderContext.setPreOrderNo(csOutPlannedOrderEo.getPlatformOrderNo());
        deliveryNoticeOrderContext.setExternalOrderNo(csOutPlannedOrderEo.getPlatformOrderNo());
        deliveryNoticeOrderContext.setRelevanceNo(csOutPlannedOrderEo.getOrderNo());
        deliveryNoticeOrderContext.setRelevanceTableName(CsRelevanceTableNameEnum.CS_OUT_PLANNED_ORDER);
        deliveryNoticeOrderContext.setLogicWarehouseCode(csOutPlannedOrderEo.getDeliveryWarehouseCode());
        deliveryNoticeOrderContext.setRemark(csOutPlannedOrderEo.getRemark());
        ReceiveDeliveryNoticeOrderFacadeBo receiveNoticeOrderContext = new ReceiveDeliveryNoticeOrderFacadeBo();
        BeanUtils.copyProperties((Object)deliveryNoticeOrderContext, (Object)receiveNoticeOrderContext);
        receiveNoticeOrderContext.setSourceType(CsInventorySourceTypeEnum.IN_TO_ADJUST.getCode());
        ArrayList deliveryNoticeOrderDetails = Lists.newArrayList();
        for (CsOutPlannedOrderDetailEo detail : orderDetailEoList) {
            BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
            detailReqDto.setPreOrderItemId(detail.getId());
            detailReqDto.setBatch(detail.getBatch());
            detailReqDto.setQuantity(BigDecimalUtils.abs((BigDecimal)detail.getPlanQuantity()));
            detailReqDto.setSkuCode(detail.getCargoCode());
            detailReqDto.setSkuName(detail.getCargoName());
            detailReqDto.setExpireTime(detail.getExpireTime());
            detailReqDto.setProduceTime(detail.getProduceTime());
            detailReqDto.setExtension(detail.getExtension());
            deliveryNoticeOrderDetails.add(detailReqDto);
        }
        deliveryNoticeOrderContext.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                if (context instanceof ReceiveDeliveryNoticeOrderContext) {
                    ReceiveDeliveryNoticeOrderContext context1 = (ReceiveDeliveryNoticeOrderContext)context;
                    ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = context1.getReceiveDeliveryNoticeOrderEo();
                    receiveDeliveryNoticeOrderEo.setExtension(csOutPlannedOrderEo.getExtension());
                    receiveDeliveryNoticeOrderEo.setTotalQuantity(csOutPlannedOrderEo.getTotalQuantity());
                }
            }

            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        deliveryNoticeOrderContext.setOrderBasicsDetailReqDtoList((List)deliveryNoticeOrderDetails);
        logger.info("CsOutPlannedOrderServiceImpl deliveryNoticeOrderGen:{}", (Object)LogUtils.buildLogContent(deliveryNoticeOrderContext));
        this.baseOrderFacade.deliveryNoticeOrderGen(deliveryNoticeOrderContext);
    }

    private List<CsBasicsOrderDetailReqDto> getOrderDetailReqDtoList(CsOutPlannedOrderEo csOutPlannedOrderEo, List<CsOutPlannedOrderDetailEo> orderDetailEoList, List<CsBasicsOrderDetailReqDto> deliveryDetailList) {
        List<InventoryPreemptionEo> InventoryPreemptionEoList;
        if (StringUtils.isBlank((CharSequence)orderDetailEoList.get(0).getBatch()) && CollectionUtils.isNotEmpty(InventoryPreemptionEoList = this.csInventoryPreemptionQueryService.queryPreemptTypeBySourceNo(csOutPlannedOrderEo.getOrderNo(), CsValidFlagEnum.ENABLE.getCode(), CsWarehouseClassifyEnum.LOGIC.getCode()))) {
            Map extensionMap = deliveryDetailList.stream().collect(HashMap::new, (m, v) -> m.put(v.getLongCode(), v.getExtension()), HashMap::putAll);
            ArrayList<CsBasicsOrderDetailReqDto> deliveryDetailList1 = new ArrayList<CsBasicsOrderDetailReqDto>();
            for (InventoryPreemptionEo InventoryPreemptionEo2 : InventoryPreemptionEoList) {
                CsBasicsOrderDetailReqDto basic = new CsBasicsOrderDetailReqDto();
                basic.setLongCode(InventoryPreemptionEo2.getSkuCode());
                basic.setItemName(InventoryPreemptionEo2.getSkuName());
                basic.setCargoCode(InventoryPreemptionEo2.getSkuCode());
                basic.setArtNo(InventoryPreemptionEo2.getSkuCode());
                basic.setQuantity(InventoryPreemptionEo2.getPreemptNum());
                basic.setBatch(InventoryPreemptionEo2.getBatch());
                basic.setExtension((String)extensionMap.get(InventoryPreemptionEo2.getSkuCode()));
                deliveryDetailList1.add(basic);
            }
            return deliveryDetailList1;
        }
        return deliveryDetailList;
    }

    private void auditPlannedOrderResult(CsOutPlannedOrderAuditReqDto plannedOrderAuditReqDto) {
        logger.info("auditPlannedOrderResult==>\u8bb0\u5f55\u5ba1\u6838\u65e5\u5fd7,plannedOrderAuditReqDto:{}", (Object)LogUtils.buildLogContent(plannedOrderAuditReqDto));
        CsStorageAuditRecordReqDto storageAuditRecordReqDto = new CsStorageAuditRecordReqDto();
        storageAuditRecordReqDto.setOrderSrcNo(plannedOrderAuditReqDto.getOrderNo());
        storageAuditRecordReqDto.setRemark(plannedOrderAuditReqDto.getRemark());
        storageAuditRecordReqDto.setAuditResult(plannedOrderAuditReqDto.getAuditResult());
        storageAuditRecordReqDto.setType(CsOtherStorageOrderEnum.InOrOut.PURCHASE_RETREAT.getCode());
        this.storageAuditRecordService.addCsStorageAuditRecord(storageAuditRecordReqDto);
    }

    private void checkParams(CsOutPlannedOrderAuditReqDto plannedOrderAuditReqDto) {
        AssertUtil.isTrue(null != plannedOrderAuditReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String orderNo = plannedOrderAuditReqDto.getOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u5ba1\u6838\u5355\u636e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String auditResult = plannedOrderAuditReqDto.getAuditResult();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)auditResult) && null != CsPlannedOrderAuditResultEnum.getByCode((String)auditResult), "\u5ba1\u6838\u7ed3\u679c\u53c2\u6570\u6709\u8bef");
    }

    public List<String> checkInventory(CsOutPlannedOrderEo outPlannedOrderEo, List<CsOutPlannedOrderDetailEo> orderDetailEoList) {
        ArrayList<String> errorList = new ArrayList<String>();
        List longCodeList = orderDetailEoList.stream().map(CsOutPlannedOrderDetailEo::getLongCode).distinct().collect(Collectors.toList());
        List batchList = orderDetailEoList.stream().map(CsOutPlannedOrderDetailEo::getBatch).distinct().collect(Collectors.toList());
        List itemList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDomain.filter().eq((Object)"warehouse_code", (Object)outPlannedOrderEo.getDeliveryWarehouseCode())).in((Object)"sku_code", longCodeList)).in((Object)"batch", batchList)).list();
        Map eoMap = itemList.stream().collect(Collectors.toMap(k -> k.getSkuCode() + k.getBatch(), Function.identity()));
        orderDetailEoList.forEach(itemDetail -> {
            String key = itemDetail.getLongCode() + itemDetail.getBatch();
            if (eoMap.containsKey(key)) {
                LogicInventoryEo logicInventoryEo = (LogicInventoryEo)eoMap.get(key);
                if (itemDetail.getWaitQuantity().compareTo(logicInventoryEo.getAvailable()) == 1) {
                    String info = String.format("\u5546\u54c1\u7f16\u7801:%s \u6279\u6b21\u53f7:%s", itemDetail.getLongCode(), itemDetail.getBatch());
                    errorList.add(info);
                }
            }
        });
        return errorList;
    }

    private String generateCode(String orderType) {
        IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(orderType);
        String code = generateCodeService.getCode();
        return code;
    }

    private void checkParams(CsOutPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        List platformList;
        AssertUtil.isTrue(null != plannedOrderGenerateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String operateFlag = plannedOrderGenerateReqDto.getOperateFlag();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)operateFlag) && null != CsPlannedOrderOperateEnum.getByCode((String)operateFlag), "\u64cd\u4f5c\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
        String orderType = plannedOrderGenerateReqDto.getOrderType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderType) && null != CsPlannedOrderTypeEnum.getByCode((String)orderType), "\u5355\u636e\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
        String businessType = plannedOrderGenerateReqDto.getBusinessType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)businessType) && null != CsPlannedOrderBusinessTypeEnum.getByCode((String)businessType), "\u4e1a\u52a1\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
        String warehouseCode = plannedOrderGenerateReqDto.getWarehouseCode();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseCode), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ExtQueryChainWrapper filter = this.logicWarehouseDomain.filter();
        filter.eq((Object)"warehouse_code", (Object)warehouseCode);
        filter.eq((Object)"warehouse_status", (Object)CsLogicWarehouseStatusEnum.ENABLE.getCode());
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)filter.one();
        AssertUtil.isTrue(null != csLogicWarehouseEo, "\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
        plannedOrderGenerateReqDto.setWarehouseId(csLogicWarehouseEo.getId());
        plannedOrderGenerateReqDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
        plannedOrderGenerateReqDto.setOrganizationId(csLogicWarehouseEo.getOrganizationId());
        plannedOrderGenerateReqDto.setOrganizationName(csLogicWarehouseEo.getOrganizationName());
        String supplierCode = plannedOrderGenerateReqDto.getSupplierCode();
        if (StringUtils.isNotBlank((CharSequence)supplierCode)) {
            ExtQueryChainWrapper supplierFilter = this.inventorySupplierDas.filter();
            supplierFilter.eq((Object)"supplier_code", (Object)supplierCode);
            supplierFilter.eq((Object)"status", (Object)YesNoEnum.YES.getValue());
            CsInventorySupplierEo csInventorySupplierEo = (CsInventorySupplierEo)supplierFilter.one();
            AssertUtil.isTrue(null != csInventorySupplierEo, "\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u5b58\u5728");
            plannedOrderGenerateReqDto.setSupplierId(csInventorySupplierEo.getId());
            plannedOrderGenerateReqDto.setSupplierName(csInventorySupplierEo.getSupplierName());
        }
        List itemDetailList = plannedOrderGenerateReqDto.getItemDetailList();
        itemDetailList.forEach(dto -> {
            String longCode = dto.getLongCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)longCode), "\u5546\u54c1\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal planQuantity = dto.getPlanQuantity();
            AssertUtil.isTrue(null != planQuantity && planQuantity.compareTo(BigDecimal.ZERO) > 0, "\u5546\u54c1\u6570\u91cf\u53c2\u6570\u6709\u8bef");
            String batch = dto.getBatch();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)batch), "\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        });
        List longCodeList = itemDetailList.stream().map(CsOutPlannedOrderGenerateDetailReqDto::getLongCode).distinct().collect(Collectors.toList());
        List csItemEoList = this.itemSkuProxy.queryBySkuCodes(longCodeList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csItemEoList), "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map itemEoMap = csItemEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity()));
        for (CsOutPlannedOrderGenerateDetailReqDto detailReqDto : itemDetailList) {
            String longCode = detailReqDto.getLongCode();
            ItemSkuDto csItemEo = (ItemSkuDto)itemEoMap.get(longCode);
            if (null == csItemEo) continue;
            detailReqDto.setArtNo(csItemEo.getSkuCode());
            detailReqDto.setCargoId(csItemEo.getId());
            detailReqDto.setCargoCode(csItemEo.getSkuCode());
            detailReqDto.setCargoName(csItemEo.getSkuName());
        }
        if (StringUtils.isNotBlank((CharSequence)plannedOrderGenerateReqDto.getPlatformOrderNo()) && CollectionUtils.isNotEmpty((Collection)(platformList = ((ExtQueryChainWrapper)this.csOutPlannedOrderDas.filter().eq((Object)"platform_order_no", (Object)plannedOrderGenerateReqDto.getPlatformOrderNo())).list()))) {
            List collect = platformList.stream().filter(obj -> !CsPlannedOrderStatusEnum.CANCEL.getCode().equals(obj.getOrderStatus())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                collect = platformList.stream().filter(obj -> plannedOrderGenerateReqDto.getOrganizationName().equals(obj.getOrganizationName())).collect(Collectors.toList());
            }
            AssertUtil.isTrue(CollectionUtils.isEmpty(collect), "EAS\u5355\u53f7\u5df2\u5b58\u5728");
        }
    }

    public void updatePreemptRecord(String warehouseType, String orderNo, Boolean portionFlag, List<InOutResultOrderDetailEo> csOutResultOrderDetailEoList) {
        logger.info("updatePreemptRecord===>\u4fee\u6539\u9884\u5360\u8bb0\u5f55,\u4ed3\u5e93\u7c7b\u578b\uff1a{},\u5355\u53f7\uff1a{},portionFlag:{},csOutResultOrderDetailEoList:{}", new Object[]{warehouseType, orderNo, portionFlag, JSONObject.toJSONString(csOutResultOrderDetailEoList)});
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryPreemptionDomain.filter().eq((Object)"warehouse_classify", (Object)warehouseType)).eq((Object)"source_no", (Object)orderNo)).eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            if (portionFlag.booleanValue()) {
                List<InventoryPreemptionEo> batchPreemption = list.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getBatch())).collect(Collectors.toList());
                List<InventoryPreemptionEo> preemption = list.stream().filter(x -> StringUtils.isBlank((CharSequence)x.getBatch())).collect(Collectors.toList());
                Map map = csOutResultOrderDetailEoList.stream().collect(Collectors.toMap(x -> x.getSkuCode() + x.getBatch(), Function.identity()));
                if (CollectionUtils.isNotEmpty(batchPreemption)) {
                    batchPreemption.forEach(info -> {
                        String key = info.getSkuCode() + info.getBatch();
                        if (map.containsKey(key)) {
                            InOutResultOrderDetailEo csOutResultOrderDetailEo = (InOutResultOrderDetailEo)map.get(key);
                            InventoryPreemptionEo InventoryPreemptionEo2 = new InventoryPreemptionEo();
                            InventoryPreemptionEo2.setPreemptNum(info.getPreemptNum().subtract(csOutResultOrderDetailEo.getDoneQuantity()));
                            InventoryPreemptionEo2.setId(info.getId());
                            this.inventoryPreemptionDomain.updateSelective((BaseEo)InventoryPreemptionEo2);
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(preemption)) {
                    Map<String, List<InOutResultOrderDetailEo>> longCodeMap = csOutResultOrderDetailEoList.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode));
                    preemption.forEach(info -> {
                        if (longCodeMap.containsKey(info.getSkuCode())) {
                            List csOutResultOrderDetailEos = (List)longCodeMap.get(info.getSkuCode());
                            BigDecimal doneQuantity = csOutResultOrderDetailEos.stream().map(InOutResultOrderDetailEo::getDoneQuantity).reduce(BigDecimal::add).get();
                            InventoryPreemptionEo InventoryPreemptionEo2 = new InventoryPreemptionEo();
                            InventoryPreemptionEo2.setPreemptNum(info.getPreemptNum().subtract(doneQuantity));
                            InventoryPreemptionEo2.setId(info.getId());
                            this.inventoryPreemptionDomain.updateSelective((BaseEo)InventoryPreemptionEo2);
                        }
                    });
                }
            } else {
                List idList = list.stream().map(BaseEo::getId).collect(Collectors.toList());
                InventoryPreemptionEo updateEo = new InventoryPreemptionEo();
                updateEo.setValid(CsValidFlagEnum.DISABLE.getCode());
                updateEo.setDisplay(YesNoEnum.NO.getValue());
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.in((Object)"id", idList);
                logger.info("updatePreemptRecord==>\u9884\u5360\u8bb0\u5f55\u5373\u5c06\u6279\u91cf\u7f6e\u4e3a\u65e0\u6548,updateEo:{},updateWrapper:{}", (Object)LogUtils.buildLogContent(updateEo), (Object)LogUtils.buildLogContent(updateWrapper));
                this.inventoryPreemptionDomain.getMapper().update((Object)updateEo, (Wrapper)updateWrapper);
            }
        }
    }
}

