/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.pcp.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.mj.biz.commons.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.pcp.ICsLockOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsLockOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.pcp.CsLockOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLockOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLockOrderRespDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.basicdata.api.IPcpDictApi;
import com.yunxi.dg.base.center.basicdata.enums.DictEnum;
import com.yunxi.dg.base.center.inventory.dao.vo.InventoryWarehouseVo;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csLockOrderQueryService")
public class CsLockOrderQueryServiceImpl
implements ICsLockOrderQueryService {
    private static final Logger logger = LoggerFactory.getLogger(CsLockOrderQueryServiceImpl.class);
    @Resource
    ILogicInventoryDomain logicInventoryDomain;
    @Resource
    CsLockOrderMapper csLockOrderMapper;
    @Resource
    IPcpDictApi pcpDictApi;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;

    @Override
    public PageInfo<CsLockOrderRespDto> queryByPage(CsLockOrderQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto));
        Integer pageNum = Objects.isNull(queryDto.getPageNum()) ? 1 : queryDto.getPageNum();
        Integer pageSize = Objects.isNull(queryDto.getPageSize()) ? 10 : queryDto.getPageSize();
        InventoryWarehouseVo vo = new InventoryWarehouseVo();
        CubeBeanUtils.copyProperties((Object)vo, (Object)queryDto, (String[])new String[0]);
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.pcpDictApi.queryByGroupCodeAndCode(DictEnum.INVENTORY_SETTING_EXPIRATION_WARNING.getGroupCode(), DictEnum.INVENTORY_SETTING_EXPIRATION_WARNING.getCode()));
        logger.info("\u83b7\u53d6\u6709\u6548\u671f\u9884\u8b66:{}", (Object)JSON.toJSONString((Object)dictDto));
        AssertUtil.isTrue(Objects.nonNull(dictDto) && StringUtils.isNotBlank((CharSequence)dictDto.getValue()), "\u8bf7\u5728\u201c\u7cfb\u7edf\u914d\u7f6e-\u901a\u7528\u914d\u7f6e-\u5e93\u5b58\u8bbe\u7f6e\u201d\uff0c\u8bbe\u7f6e\u6709\u6548\u671f\u9884\u8b66");
        Integer dictValue = Integer.parseInt(dictDto.getValue());
        DateTime endOfDay = DateUtil.endOfDay((Date)new Date());
        Date time = DateUtils.addDate((Date)endOfDay, dictValue);
        vo.setExpireTime(time);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List voList = this.logicInventoryDomain.queryQualifiedCargoInventory(vo);
        PageInfo pageInfoVo = new PageInfo(voList);
        List<CsLockOrderRespDto> list = this.getCsLockOrderRespDtoPageInfo(time, null, voList);
        if (list == null) {
            return new PageInfo();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoVo, (String[])new String[]{"list"});
        pageInfo.setList(list);
        return pageInfo;
    }

    private List<CsLockOrderRespDto> getCsLockOrderRespDtoPageInfo(Date time, Map<String, ItemSkuDto> itemMap, List<InventoryWarehouseVo> voList) {
        List longCodes;
        List itemEos;
        if (CollectionUtils.isEmpty(voList)) {
            return null;
        }
        if (Objects.isNull(itemMap) && CollectionUtils.isNotEmpty((Collection)(itemEos = this.itemSkuProxy.queryBySkuCodes(longCodes = voList.stream().map(InventoryWarehouseVo::getLongCode).distinct().collect(Collectors.toList()))))) {
            itemMap = itemEos.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList<CsLockOrderRespDto> list = new ArrayList<CsLockOrderRespDto>();
        for (InventoryWarehouseVo inventoryWarehouseVo : voList) {
            CsLockOrderRespDto respDto = new CsLockOrderRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)inventoryWarehouseVo, (String[])new String[0]);
            respDto.setIsNearOverdue(Integer.valueOf(respDto.getExpireTime().compareTo(time) > 0 ? 0 : 1));
            if (Objects.nonNull(itemMap) && Objects.nonNull(itemMap.get(inventoryWarehouseVo.getLongCode()))) {
                ItemSkuDto itemEo = (ItemSkuDto)itemMap.get(inventoryWarehouseVo.getLongCode());
                respDto.setCargoCode(itemEo.getSkuCode());
                respDto.setArtNo(itemEo.getSkuCode());
            }
            if (Objects.nonNull(inventoryWarehouseVo.getCreateTime())) {
                int day = DateUtils.diffByDay(inventoryWarehouseVo.getCreateTime());
                respDto.setInventoryDay(Integer.valueOf(day));
            }
            QueryWrapper lockOrderEoQueryWrapper = new QueryWrapper();
            lockOrderEoQueryWrapper.eq((Object)"long_code", (Object)inventoryWarehouseVo.getLongCode());
            lockOrderEoQueryWrapper.eq((Object)"warehouse_code", (Object)inventoryWarehouseVo.getWarehouseCode());
            lockOrderEoQueryWrapper.eq((Object)"batch", (Object)inventoryWarehouseVo.getBatch());
            lockOrderEoQueryWrapper.eq((Object)"dr", (Object)0);
            CsLockOrderEo lockOrderEo = (CsLockOrderEo)this.csLockOrderMapper.selectOne((Wrapper)lockOrderEoQueryWrapper);
            if (Objects.nonNull(lockOrderEo)) {
                respDto.setCurrentLockQuantity(lockOrderEo.getCurrentLockQuantity());
                respDto.setRemark(lockOrderEo.getRemark());
                respDto.setNumber(lockOrderEo.getNumber());
            }
            list.add(respDto);
        }
        return list;
    }
}

