/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.IPcpDeliveryResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryResultOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryResultOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDocumentExpressReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsRelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pcpDeliveryResultOrderServiceImpl")
public class PcpDeliveryResultOrderServiceImpl
implements IPcpDeliveryResultOrderService {
    private static final Logger logger = LoggerFactory.getLogger(PcpDeliveryResultOrderServiceImpl.class);
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private ICsOutResultOrderQueryService csOutResultOrderQueryService;
    @Resource
    private SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    private RepeatFilter repeatFilter;
    @Resource
    private CsCommonService csCommonService;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private ICsRelWarehouseQueryService csRelWarehouseQueryService;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;

    @Override
    public Long add(CsDeliveryResultOrderAddReqDto addReqDto) {
        logger.info("\u521b\u5efa\u53d1\u8d27\u5355\u7ed3\u679c\u5355\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(addReqDto));
        String relevanceNo = addReqDto.getRelevanceNo();
        this.repeatFilter.checkRepeat("DeliveryNotice:" + addReqDto.getPreOrderNo(), () -> this.preValid(relevanceNo), true);
        this.dataValid(addReqDto);
        ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = new ReceiveDeliveryResultOrderEo();
        CubeBeanUtils.copyProperties((Object)csDeliveryResultOrderEo, (Object)addReqDto, (String[])new String[0]);
        CsGenerateCodeEnum generateCodeEnum = this.simpleGenerateCodeUtil.generateCode("102");
        String documentNo = generateCodeEnum.getCode();
        String orderStatus = generateCodeEnum.getStatus();
        csDeliveryResultOrderEo.setDocumentNo(documentNo);
        csDeliveryResultOrderEo.setOrderStatus(orderStatus);
        csDeliveryResultOrderEo.setOrderType("delivery");
        csDeliveryResultOrderEo.setExtension(JSON.toJSONString((Object)addReqDto.getContactDto()));
        this.receiveDeliveryResultOrderDomain.insert((BaseEo)csDeliveryResultOrderEo);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsDeliveryResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            ReceiveDeliveryResultOrderDetailEo eo = new ReceiveDeliveryResultOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)eo, (Object)addReqDto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)eo, (Object)detailAddReqDto, (String[])new String[]{"id"});
            eo.setDocumentNo(documentNo);
            detailEoList.add(eo);
        }
        this.receiveDeliveryResultOrderDetailDomain.insertBatch((List)detailEoList);
        return csDeliveryResultOrderEo.getId();
    }

    @Override
    public void update(Long id, CsDeliveryResultOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ReceiveDeliveryResultOrderEo updateEo = new ReceiveDeliveryResultOrderEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.receiveDeliveryResultOrderDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
    }

    public void dataValid(CsDeliveryResultOrderAddReqDto addReqDto) {
        List<RelWarehouseEo> relPhysicList;
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getWarehouseCode()), "\u672a\u4f20\u5165\u4ed3\u5e93\u7f16\u7801");
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getPreOrderNo()), "\u672a\u4f20\u5165\u524d\u7f6e\u4e1a\u52a1\u5355\u636e");
        AssertUtil.isTrue(addReqDto.getBusinessType() != null, "\u672a\u4f20\u5165\u7c7b\u578b");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)BusinessTypeEnum.getDescByCode((String)addReqDto.getBusinessType())), "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
        List logicWarehouseEos = this.logicWarehouseDomain.queryByCodes((List)Lists.newArrayList((Object[])new String[]{addReqDto.getWarehouseCode()}));
        List itemList = addReqDto.getDetailAddReqDtoList().stream().map(CsDeliveryResultOrderDetailAddReqDto::getLongCode).collect(Collectors.toList());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicWarehouseEos), "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(itemList), "\u8d27\u54c1\u4e0d\u5b58\u5728");
        List itemEoList = this.itemSkuProxy.queryBySkuCodes(itemList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)itemEoList), "\u5546\u54c1\u672a\u914d\u7f6e");
        if (itemEoList.size() != itemEoList.size()) {
            logger.info("error,\u8d27\u54c1\u4e0d\u4e00\u81f4\uff0c\u540e\u7eed\u5904\u7406\uff1b");
        }
        if (CollectionUtils.isNotEmpty(relPhysicList = this.csRelWarehouseQueryService.queryByRefWarehouseCode(addReqDto.getWarehouseCode(), CsWarehouseClassifyEnum.LOGIC.getCode()))) {
            addReqDto.setDeliveryPhysicsWarehouseCode(relPhysicList.get(0).getRefWarehouseCode());
            addReqDto.setDeliveryPhysicsWarehouseName(relPhysicList.get(0).getRefWarehouseName());
        }
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)logicWarehouseEos.get(0);
        addReqDto.setWarehouseId(csLogicWarehouseEo.getId());
        addReqDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
        addReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        addReqDto.setOrganizationId(csLogicWarehouseEo.getOrganizationId());
        addReqDto.setOrganizationName(csLogicWarehouseEo.getOrganizationName());
        Map<String, ItemSkuDto> cargoMap = itemEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, entity -> entity));
        for (CsDeliveryResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            ItemSkuDto itemEo = cargoMap.get(detailAddReqDto.getCargoCode());
            if (null == itemEo) {
                logger.info("error,\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u540e\u7eed\u5904\u7406");
                continue;
            }
            detailAddReqDto.setCargoId(itemEo.getId());
            detailAddReqDto.setCargoName(itemEo.getSkuName());
        }
    }

    @Override
    public void updateExpressInfo(CsDocumentExpressReqDto reqDto) {
        List list = this.receiveDeliveryResultOrderDomain.queryByDocumentNo(reqDto.getDocumentNo());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)list), "\u5355\u636e\u4e0d\u5b58\u5728");
        ReceiveDeliveryResultOrderEo eo = new ReceiveDeliveryResultOrderEo();
        BeanUtils.copyProperties((Object)reqDto, (Object)eo);
        eo.setId(((ReceiveDeliveryResultOrderEo)list.get(0)).getId());
        this.receiveDeliveryResultOrderDomain.getMapper().updateById((BaseEo)eo);
    }

    @Override
    public Long createDeliveryResultOrder(String relevanceNo, String preOrderNo) {
        this.repeatFilter.checkRepeat("DeliveryResult:" + relevanceNo + preOrderNo, () -> this.preValid(relevanceNo), true);
        QueryWrapper InOutResultOrderEoQueryWrapper = new QueryWrapper();
        InOutResultOrderEoQueryWrapper.eq((Object)"document_no", (Object)relevanceNo);
        InOutResultOrderEo InOutResultOrderEo2 = (InOutResultOrderEo)this.inOutResultOrderDomain.getMapper().selectOne((Wrapper)InOutResultOrderEoQueryWrapper);
        String outResultDocumentNo = InOutResultOrderEo2.getDocumentNo();
        CsOutResultOrderRespDto dto = this.csOutResultOrderQueryService.queryByDocumentNo(outResultDocumentNo);
        QueryWrapper ReceiveDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)preOrderNo);
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_status", (Object)BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
        ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2 = (ReceiveDeliveryNoticeOrderEo)this.receiveDeliveryNoticeOrderDomain.getMapper().selectOne((Wrapper)ReceiveDeliveryNoticeOrderEoQueryWrapper);
        ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = new ReceiveDeliveryResultOrderEo();
        CubeBeanUtils.copyProperties((Object)csDeliveryResultOrderEo, (Object)dto, (String[])new String[0]);
        CsGenerateCodeEnum generateCodeEnum = this.simpleGenerateCodeUtil.pcpGenerateCode("102");
        String documentNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.DELIVERY_RESULT_ORDE.getCode()).getCode();
        String orderStatus = generateCodeEnum.getStatus();
        csDeliveryResultOrderEo.setDocumentNo(documentNo);
        csDeliveryResultOrderEo.setOrderStatus(orderStatus);
        csDeliveryResultOrderEo.setRelevanceNo(relevanceNo);
        csDeliveryResultOrderEo.setExtension(dto.getExtension());
        CsRelWarehouseQueryDto queryDto = new CsRelWarehouseQueryDto();
        queryDto.setWarehouseId(csDeliveryResultOrderEo.getWarehouseId());
        queryDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        queryDto.setRefWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        queryDto.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
        List<CsRelWarehouseRespDto> csRelWarehouseRespDtos = this.csRelWarehouseQueryService.queryWarehouseByConditions(queryDto);
        if (CollectionUtils.isNotEmpty(csRelWarehouseRespDtos)) {
            csDeliveryResultOrderEo.setDeliveryPhysicsWarehouseName(csRelWarehouseRespDtos.get(0).getRefWarehouseName());
            csDeliveryResultOrderEo.setDeliveryPhysicsWarehouseCode(csRelWarehouseRespDtos.get(0).getRefWarehouseCode());
        }
        csDeliveryResultOrderEo.setRelevanceNo(dto.getRelevanceNo());
        csDeliveryResultOrderEo.setPreOrderNo(dto.getDocumentNo());
        csDeliveryResultOrderEo.setOrderStatus(BaseOrderStatusEnum.RRO_RECEIVED.getCode());
        csDeliveryResultOrderEo.setDeliveryLogicWarehouseCode(ReceiveDeliveryNoticeOrderEo2.getDeliveryLogicWarehouseCode());
        csDeliveryResultOrderEo.setDeliveryLogicWarehouseName(ReceiveDeliveryNoticeOrderEo2.getDeliveryLogicWarehouseName());
        csDeliveryResultOrderEo.setDeliveryPhysicsWarehouseCode(ReceiveDeliveryNoticeOrderEo2.getDeliveryPhysicsWarehouseCode());
        csDeliveryResultOrderEo.setDeliveryPhysicsWarehouseName(ReceiveDeliveryNoticeOrderEo2.getDeliveryPhysicsWarehouseName());
        csDeliveryResultOrderEo.setOrderType("delivery");
        this.receiveDeliveryResultOrderDomain.insert((BaseEo)csDeliveryResultOrderEo);
        Map<String, Long> activityIdMap = this.queryActivityMap(relevanceNo);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsOutResultOrderDetailRespDto detailRespDto : dto.getDetailRespDtoList()) {
            ReceiveDeliveryResultOrderDetailEo detailEo = new ReceiveDeliveryResultOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)dto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailRespDto, (String[])new String[]{"id"});
            detailEo.setDocumentNo(documentNo);
            detailEo.setRelevanceNo(relevanceNo);
            detailEo.setSkuCode(detailRespDto.getLongCode());
            detailEo.setActivityId(activityIdMap.get(detailRespDto.getCargoCode() + detailRespDto.getBatch() + detailRespDto.getTradeOrderItemId()));
            detailEoList.add(detailEo);
        }
        this.receiveDeliveryResultOrderDetailDomain.insertBatch((List)detailEoList);
        return csDeliveryResultOrderEo.getId();
    }

    private Map<String, Long> queryActivityMap(String relevanceNo) {
        HashMap<String, Long> activityIdMap = new HashMap<String, Long>();
        List noticeOrderDetailEoList = this.receiveDeliveryNoticeOrderDetailDomain.queryByDocumentNo(relevanceNo);
        if (CollectionUtils.isNotEmpty((Collection)noticeOrderDetailEoList)) {
            for (ReceiveDeliveryNoticeOrderDetailEo detailEo : noticeOrderDetailEoList) {
                activityIdMap.put(detailEo.getSkuCode() + detailEo.getBatch() + detailEo.getPreOrderItemId(), detailEo.getActivityId());
            }
        }
        return activityIdMap;
    }

    private void preValid(String relevanceNo) {
        List oldList = this.receiveDeliveryResultOrderDomain.queryByRelevanceNo(relevanceNo);
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (ReceiveDeliveryResultOrderEo deliveryResultOrderEo : oldList) {
                AssertUtil.isTrue(BaseOrderStatusEnum.DELIVERY_CANCEL.getCode().equals(deliveryResultOrderEo.getOrderStatus()), deliveryResultOrderEo.getPreOrderNo() + "\u5df2\u5b58\u5728\u6d41\u8f6c\u6b63\u5e38\u7684\u524d\u7f6e\u5355\u636e");
            }
        }
    }
}

