/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InspectionReleaseTaskReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.InspectionReleaseTaskItemRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.InspectionReleaseTaskRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IAdjustmentInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInspectionReleaseTaskService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.CsBasicsExternalStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.ICsBasicsExternalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.CodeGenerateUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InspectionReleaseOperateLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InspectionReleaseOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InspectionReleaseTaskDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InspectionReleaseTaskItemDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionNotReleaseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionReleaseOperateLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionReleaseOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionReleaseTaskEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionReleaseTaskItemEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.InspectionNotReleaseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.InspectionReleaseOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.InspectionReleaseTaskItemMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.InspectionReleaseTaskMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsTransferOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.OutNoticeOrderDetailRespVo;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsAdjustmentChangeTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsExternalStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.OutNoticeOrderDetailVo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionReleaseTaskServiceImpl
implements IInspectionReleaseTaskService {
    private static final Logger log = LoggerFactory.getLogger(InspectionReleaseTaskServiceImpl.class);
    @Autowired
    InspectionReleaseTaskDas inspectionReleaseTaskDas;
    @Autowired
    InspectionReleaseTaskMapper inspectionReleaseTaskMapper;
    @Autowired
    InspectionReleaseTaskItemDas inspectionReleaseTaskItemDas;
    @Autowired
    InspectionReleaseTaskItemMapper inspectionReleaseTaskItemMapper;
    @Autowired
    InspectionReleaseOperateLogDas inspectionReleaseOperateLogDas;
    @Autowired
    InspectionReleaseOrderMapper inspectionReleaseOrderMapper;
    @Autowired
    InspectionReleaseOrderDas inspectionReleaseOrderDas;
    @Autowired
    ILogicInventoryDomain logicInventoryDomain;
    @Autowired
    ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    CodeGenerateUtil codeGenerateUtil;
    @Autowired
    ICommonsMqService commonsMqService;
    @Autowired
    TransactionCallBackService transactionCallBackService;
    @Autowired
    IRelWarehouseDomain relWarehouseDomain;
    @Resource(name="${yunxi.dg.base.project}_AdjustmentInventoryApi")
    IAdjustmentInventoryApi adjustmentInventoryApi;
    @Autowired
    ICsTransferOrderService transferOrderService;
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Autowired
    IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Autowired
    InspectionNotReleaseMapper inspectionNotReleaseMapper;
    @Autowired
    CsTransferOrderMapper transferOrderMapper;
    @Autowired
    BaseOrderFacade baseOrderFacade;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;

    @Override
    public Long addInspectionReleaseTask(InspectionReleaseTaskReqDto addReqDto) {
        InspectionReleaseTaskEo inspectionReleaseTaskEo = new InspectionReleaseTaskEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)inspectionReleaseTaskEo);
        this.inspectionReleaseTaskDas.insert((BaseEo)inspectionReleaseTaskEo);
        return inspectionReleaseTaskEo.getId();
    }

    @Override
    public void modifyInspectionReleaseTask(InspectionReleaseTaskReqDto modifyReqDto) {
        InspectionReleaseTaskEo inspectionReleaseTaskEo = new InspectionReleaseTaskEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)inspectionReleaseTaskEo);
        this.inspectionReleaseTaskDas.updateSelective((BaseEo)inspectionReleaseTaskEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeInspectionReleaseTask(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.inspectionReleaseTaskDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public InspectionReleaseTaskRespDto queryById(Long id) {
        InspectionReleaseTaskEo inspectionReleaseTaskEo = (InspectionReleaseTaskEo)this.inspectionReleaseTaskDas.selectByPrimaryKey(id);
        InspectionReleaseTaskRespDto inspectionReleaseTaskRespDto = new InspectionReleaseTaskRespDto();
        DtoHelper.eo2Dto((BaseEo)inspectionReleaseTaskEo, (BaseVo)inspectionReleaseTaskRespDto);
        return inspectionReleaseTaskRespDto;
    }

    @Override
    public PageInfo<InspectionReleaseTaskRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        InspectionReleaseTaskReqDto inspectionReleaseTaskReqDto = (InspectionReleaseTaskReqDto)JSON.parseObject((String)filter, InspectionReleaseTaskReqDto.class);
        InspectionReleaseTaskEo inspectionReleaseTaskEo = new InspectionReleaseTaskEo();
        DtoHelper.dto2Eo((BaseVo)inspectionReleaseTaskReqDto, (BaseEo)inspectionReleaseTaskEo);
        PageInfo eoPageInfo = this.inspectionReleaseTaskDas.selectPage((BaseEo)inspectionReleaseTaskEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, InspectionReleaseTaskRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<InspectionReleaseTaskRespDto> queryList(InspectionReleaseTaskReqDto inspectionReleaseTaskReqDto) {
        if (StringUtils.isBlank((CharSequence)inspectionReleaseTaskReqDto.getStatus()) && StringUtils.isBlank((CharSequence)inspectionReleaseTaskReqDto.getTaskNo()) && StringUtils.isBlank((CharSequence)inspectionReleaseTaskReqDto.getInspectionReleaseNo())) {
            throw new CsInventoryException("\u67e5\u8be2\u5bf9\u8c61\u4e0d\u5b58\u5728\u6709\u6548\u53c2\u6570", new Object[0]);
        }
        List inspectionReleaseTaskEos = this.inspectionReleaseTaskMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskEo.class).eq(StringUtils.isNotBlank((CharSequence)inspectionReleaseTaskReqDto.getStatus()), InspectionReleaseTaskEo::getStatus, (Object)inspectionReleaseTaskReqDto.getStatus())).eq(StringUtils.isNotBlank((CharSequence)inspectionReleaseTaskReqDto.getInspectionReleaseNo()), InspectionReleaseTaskEo::getInspectionReleaseNo, (Object)inspectionReleaseTaskReqDto.getInspectionReleaseNo())).eq(StringUtils.isNotBlank((CharSequence)inspectionReleaseTaskReqDto.getTaskNo()), InspectionReleaseTaskEo::getTaskNo, (Object)inspectionReleaseTaskReqDto.getTaskNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inspectionReleaseTaskEos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtoList = Lists.newArrayList();
        for (InspectionReleaseTaskEo inspectionReleaseTaskEo : inspectionReleaseTaskEos) {
            InspectionReleaseTaskRespDto respDto = new InspectionReleaseTaskRespDto();
            BeanUtils.copyProperties((Object)inspectionReleaseTaskEo, (Object)respDto);
            respDtoList.add(respDto);
        }
        return respDtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createTaskByInspectionReleaseNo(String inspectionReleaseNo) {
        InspectionReleaseOperateLogEo logEo;
        InspectionReleaseOrderEo updateReleaseOrderEo;
        AssertUtil.assertNotBlank(inspectionReleaseNo, "\u653e\u884c\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        InspectionReleaseOrderEo inspectionReleaseOrderEo = (InspectionReleaseOrderEo)this.inspectionReleaseOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseOrderEo.class).eq(InspectionReleaseOrderEo::getInspectionReleaseNo, (Object)inspectionReleaseNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(inspectionReleaseOrderEo, String.format("\u653e\u884c\u5355\u5355\u53f7[%s]\u67e5\u8be2\u4fe1\u606f\u4e0d\u5b58\u5728", inspectionReleaseNo), new Object[0]);
        if (!Objects.equals(-1, inspectionReleaseOrderEo.getOrderStatus())) {
            log.info("\u653e\u884c\u5355\u4e0d\u5904\u4e8e\u5f85\u6267\u884c\u72b6\u6001");
            return "\u653e\u884c\u5355\u4e0d\u5904\u4e8e\u5f85\u6267\u884c\u72b6\u6001";
        }
        List csLogicWarehouseEos = this.logicWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getWarehouseQuality, (Object)CsLogicWarehouseQualityEnum.WAIT_INSPECTION.getCode())).eq(LogicWarehouseEo::getWarehouseClassify, (Object)CsWarehouseClassifyEnum.LOGIC.getCode())).eq(LogicWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)csLogicWarehouseEos)) {
            log.info("\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u5f85\u68c0\u4ed3\u5e93");
            return "\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u5f85\u68c0\u4ed3\u5e93";
        }
        List logicWarehouseIds = csLogicWarehouseEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List intransitWarehouseEos = this.logicWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).in(LogicWarehouseEo::getSubordinateLogicWarehouseId, logicWarehouseIds)).eq(LogicWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        List logicWarehouseCodes = csLogicWarehouseEos.stream().map(LogicWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List csLogicInventoryEos = this.logicInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).in(LogicInventoryEo::getWarehouseCode, logicWarehouseCodes)).eq(LogicInventoryEo::getSkuCode, (Object)inspectionReleaseOrderEo.getSkuCode())).eq(LogicInventoryEo::getBatch, (Object)inspectionReleaseOrderEo.getBatch())).eq(BaseEo::getDr, (Object)YesNoHelper.NO)).gt(LogicInventoryEo::getAvailable, (Object)BigDecimal.ZERO));
        List intransitWarehouseIds = intransitWarehouseEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        List intransitLogicInventoryEos = this.logicInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).in(LogicInventoryEo::getWarehouseId, intransitWarehouseIds)).eq(LogicInventoryEo::getSkuCode, (Object)inspectionReleaseOrderEo.getSkuCode())).eq(LogicInventoryEo::getBatch, (Object)inspectionReleaseOrderEo.getBatch())).eq(BaseEo::getDr, (Object)YesNoHelper.NO)).gt(LogicInventoryEo::getAvailable, (Object)BigDecimal.ZERO));
        List inventoryPreemptionEos = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryPreemptionEo.class).eq(InventoryPreemptionEo::getSkuCode, (Object)inspectionReleaseOrderEo.getSkuCode())).eq(InventoryPreemptionEo::getBatch, (Object)inspectionReleaseOrderEo.getBatch())).in(InventoryPreemptionEo::getWarehouseCode, logicWarehouseCodes)).in(InventoryPreemptionEo::getSourceType, (Collection)Lists.newArrayList((Object[])new String[]{CsPcpBusinessTypeEnum.ALLOT_OUT.getCode(), CsPcpBusinessTypeEnum.OTHER_OUT.getCode()}))).eq(InventoryPreemptionEo::getValid, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        List notReleaseEos = this.inspectionNotReleaseMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionNotReleaseEo.class).eq(InspectionNotReleaseEo::getSkuCode, (Object)inspectionReleaseOrderEo.getSkuCode())).eq(InspectionNotReleaseEo::getBatch, (Object)inspectionReleaseOrderEo.getBatch())).eq(InspectionNotReleaseEo::getValid, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        InspectionReleaseTaskEo taskEo = new InspectionReleaseTaskEo();
        taskEo.setTaskNo(this.codeGenerateUtil.generateNo("FX-TN", 6));
        taskEo.setInspectionReleaseNo(inspectionReleaseNo);
        taskEo.setSkuCode(inspectionReleaseOrderEo.getSkuCode());
        taskEo.setSkuName(inspectionReleaseOrderEo.getSkuName());
        taskEo.setBatch(inspectionReleaseOrderEo.getBatch());
        taskEo.setStatus("ing");
        ArrayList itemEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)csLogicInventoryEos)) {
            for (LogicInventoryEo csLogicInventoryEo : csLogicInventoryEos) {
                InspectionReleaseTaskItemEo itemEo = new InspectionReleaseTaskItemEo();
                itemEo.setInspectionReleaseNo(inspectionReleaseNo);
                itemEo.setTaskNo(taskEo.getTaskNo());
                itemEo.setTaskItemNo(this.codeGenerateUtil.generateNo("FXJL", 6));
                itemEo.setTaskType("inspection");
                itemEo.setWarehouseCode(csLogicInventoryEo.getWarehouseCode());
                itemEo.setSkuCode(inspectionReleaseOrderEo.getSkuCode());
                itemEo.setSkuName(inspectionReleaseOrderEo.getSkuName());
                itemEo.setBatch(inspectionReleaseOrderEo.getBatch());
                itemEo.setStep("execute_transfer");
                itemEo.setEndStep("execute_transfer");
                itemEo.setPlanReleaseNum(csLogicInventoryEo.getAvailable());
                itemEo.setReleaseNum(csLogicInventoryEo.getAvailable());
                itemEo.setStatus("ing");
                itemEo.setRemark(csLogicInventoryEo.getRemark());
                itemEos.add(itemEo);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)intransitLogicInventoryEos)) {
            List outNoticeOrderDetailVos = this.inOutNoticeOrderDomain.queryTransferInNoticeDetails(inspectionReleaseOrderEo.getSkuCode(), inspectionReleaseOrderEo.getBatch());
            AssertUtils.notEmpty((Collection)outNoticeOrderDetailVos, (String)"\u5728\u9014\u653e\u884c\u5173\u8054\u901a\u77e5\u5355\u660e\u7ec6\u67e5\u8be2\u4e0d\u5b58\u5728");
            List inLogicWarehouseCodes = outNoticeOrderDetailVos.stream().map(OutNoticeOrderDetailVo::getReceiveWarehouseCode).distinct().collect(Collectors.toList());
            AssertUtils.notEmpty(inLogicWarehouseCodes, (String)"\u5728\u9014\u5165\u5e93\u903b\u8f91\u4ed3\u4fe1\u606f\u7f16\u7801\u4e0d\u5b58\u5728");
            List inLogicWarehouseEos = this.logicWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).in(LogicWarehouseEo::getWarehouseCode, inLogicWarehouseCodes)).eq(LogicWarehouseEo::getWarehouseStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtils.notEmpty((Collection)inLogicWarehouseEos, (String)"\u5728\u9014\u5165\u5e93\u903b\u8f91\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
            List inLogicWarehouseIds = inLogicWarehouseEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            List inIntransitWarehouseEos = this.logicWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).in(LogicWarehouseEo::getSubordinateLogicWarehouseId, inLogicWarehouseIds)).eq(LogicWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            Map<String, List<OutNoticeOrderDetailVo>> noticeMap = outNoticeOrderDetailVos.stream().collect(Collectors.groupingBy(OutNoticeOrderDetailVo::getDocumentNo));
            for (Map.Entry<String, List<OutNoticeOrderDetailVo>> entry : noticeMap.entrySet()) {
                OutNoticeOrderDetailVo detailVo = entry.getValue().get(0);
                BigDecimal num = BigDecimal.ZERO;
                for (OutNoticeOrderDetailVo vo : entry.getValue()) {
                    num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)vo.getPlanQuantity());
                }
                InspectionReleaseTaskItemEo itemEo = new InspectionReleaseTaskItemEo();
                itemEo.setInspectionReleaseNo(inspectionReleaseNo);
                itemEo.setTaskNo(taskEo.getTaskNo());
                itemEo.setNoticeNo(detailVo.getDocumentNo());
                itemEo.setPreOrderNo(detailVo.getRelevanceNo());
                itemEo.setPreOrderType(detailVo.getBusinessType());
                itemEo.setTaskItemNo(this.codeGenerateUtil.generateNo("FXJL", 6));
                itemEo.setTaskType("intransit_inspection");
                itemEo.setIntransitTransferNo(detailVo.getRelevanceNo());
                inLogicWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)detailVo.getReceiveWarehouseCode())).findFirst().flatMap(lw -> inIntransitWarehouseEos.stream().filter(o -> Objects.equals(o.getSubordinateLogicWarehouseId(), lw.getId())).findFirst()).ifPresent(liw -> itemEo.setWarehouseCode(liw.getWarehouseCode()));
                itemEo.setSkuCode(inspectionReleaseOrderEo.getSkuCode());
                itemEo.setSkuName(inspectionReleaseOrderEo.getSkuName());
                itemEo.setBatch(inspectionReleaseOrderEo.getBatch());
                itemEo.setStep("cancel_wms_notice");
                itemEo.setEndStep("execute_adjust");
                itemEo.setPlanReleaseNum(num);
                itemEo.setReleaseNum(num);
                itemEo.setStatus("ing");
                itemEos.add(itemEo);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)inventoryPreemptionEos)) {
            Map<String, List<InventoryPreemptionEo>> preemptEoMap = inventoryPreemptionEos.stream().collect(Collectors.groupingBy(InventoryPreemptionEo::getSourceType));
            List<InventoryPreemptionEo> transferPreemptList = preemptEoMap.getOrDefault(CsInventorySourceTypeEnum.ALLOT_OUT.getCode(), Lists.newArrayList());
            if (CollectionUtils.isNotEmpty((Collection)transferPreemptList)) {
                List transferNoList = transferPreemptList.stream().map(InventoryPreemptionEo::getSourceNo).distinct().collect(Collectors.toList());
                List transferOrderEos = this.transferOrderMapper.selectList((Wrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).in(CsTransferOrderEo::getTransferOrderNo, transferNoList));
                List transferInLogicWarehouseCodeList = transferOrderEos.stream().map(CsTransferOrderEo::getInLogicWarehouseCode).distinct().collect(Collectors.toList());
                List transferInLogicWarehouseEos = this.logicWarehouseDomain.getMapper().selectList((Wrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).in(LogicWarehouseEo::getWarehouseCode, transferInLogicWarehouseCodeList));
                List transferInLogicWarehouseIds = transferInLogicWarehouseEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                List transferInIntransitWarehouseEos = this.logicWarehouseDomain.getMapper().selectList((Wrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).in(LogicWarehouseEo::getSubordinateLogicWarehouseId, transferInLogicWarehouseIds));
                for (InventoryPreemptionEo transferPreemptEo : transferPreemptList) {
                    transferOrderEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getTransferOrderNo(), (CharSequence)transferPreemptEo.getSourceNo())).findFirst().flatMap(transferOrderEo -> transferInLogicWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)transferOrderEo.getInLogicWarehouseCode())).findFirst()).flatMap(lwEo -> transferInIntransitWarehouseEos.stream().filter(o -> Objects.equals(o.getSubordinateLogicWarehouseId(), lwEo.getId())).findFirst()).ifPresent(inwEo -> {
                        InspectionReleaseTaskItemEo itemEo = new InspectionReleaseTaskItemEo();
                        itemEo.setInspectionReleaseNo(inspectionReleaseNo);
                        itemEo.setTaskNo(taskEo.getTaskNo());
                        itemEo.setTaskItemNo(this.codeGenerateUtil.generateNo("FXJL", 6));
                        itemEo.setTaskType("intransit_inspection");
                        itemEo.setPreOrderNo(transferPreemptEo.getSourceNo());
                        itemEo.setPreOrderType(transferPreemptEo.getSourceType());
                        itemEo.setWarehouseCode(inwEo.getWarehouseCode());
                        itemEo.setSkuCode(inspectionReleaseOrderEo.getSkuCode());
                        itemEo.setSkuName(inspectionReleaseOrderEo.getSkuName());
                        itemEo.setBatch(inspectionReleaseOrderEo.getBatch());
                        itemEo.setStep("cancel_wms_notice");
                        itemEo.setEndStep("execute_adjust");
                        itemEo.setPlanReleaseNum(transferPreemptEo.getPreemptNum());
                        itemEo.setReleaseNum(transferPreemptEo.getPreemptNum());
                        itemEo.setStatus("wait_exec");
                        itemEo.setIntransitTransferNo(transferPreemptEo.getSourceNo());
                        itemEos.add(itemEo);
                    });
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)notReleaseEos)) {
                List<InventoryPreemptionEo> outOtherPreemptList = preemptEoMap.getOrDefault(CsPcpBusinessTypeEnum.OTHER_OUT.getCode(), Lists.newArrayList());
                List notReleaseBusinessNoList = notReleaseEos.stream().map(InspectionNotReleaseEo::getBusinessNo).distinct().collect(Collectors.toList());
                log.info("notReleaseBusinessNoList: {}", (Object)LogUtils.buildLogContent(notReleaseBusinessNoList));
                if (CollectionUtils.isNotEmpty(outOtherPreemptList)) {
                    for (InventoryPreemptionEo otherOutPreemptEo : outOtherPreemptList) {
                        if (!notReleaseBusinessNoList.contains(otherOutPreemptEo.getSourceNo())) continue;
                        InspectionReleaseTaskItemEo itemEo = new InspectionReleaseTaskItemEo();
                        itemEo.setInspectionReleaseNo(inspectionReleaseNo);
                        itemEo.setTaskNo(taskEo.getTaskNo());
                        itemEo.setTaskItemNo(this.codeGenerateUtil.generateNo("FXJL", 6));
                        itemEo.setTaskType("inspection");
                        itemEo.setPreOrderNo(otherOutPreemptEo.getSourceNo());
                        itemEo.setPreOrderType(otherOutPreemptEo.getSourceType());
                        itemEo.setWarehouseCode(otherOutPreemptEo.getWarehouseCode());
                        itemEo.setSkuCode(inspectionReleaseOrderEo.getSkuCode());
                        itemEo.setSkuName(inspectionReleaseOrderEo.getSkuName());
                        itemEo.setBatch(inspectionReleaseOrderEo.getBatch());
                        itemEo.setStep("execute_transfer");
                        itemEo.setEndStep("execute_transfer");
                        itemEo.setPlanReleaseNum(otherOutPreemptEo.getPreemptNum());
                        itemEo.setReleaseNum(otherOutPreemptEo.getPreemptNum());
                        itemEo.setStatus("wait_exec");
                        itemEos.add(itemEo);
                    }
                }
            }
        }
        BigDecimal targetReleaseNum = BigDecimal.ZERO;
        for (InspectionReleaseTaskItemEo itemEo : itemEos) {
            targetReleaseNum = BigDecimalUtils.add((BigDecimal)targetReleaseNum, (BigDecimal)itemEo.getPlanReleaseNum());
        }
        if (BigDecimalUtils.gtZero((BigDecimal)inspectionReleaseOrderEo.getPlanTargetReleaseNum()).booleanValue() && BigDecimalUtils.gt((BigDecimal)targetReleaseNum, (BigDecimal)inspectionReleaseOrderEo.getPlanTargetReleaseNum()).booleanValue()) {
            updateReleaseOrderEo = new InspectionReleaseOrderEo();
            updateReleaseOrderEo.setId(inspectionReleaseOrderEo.getId());
            if (BigDecimalUtils.eqZero((BigDecimal)inspectionReleaseOrderEo.getPlanTargetReleaseNum()).booleanValue()) {
                updateReleaseOrderEo.setPlanTargetReleaseNum(targetReleaseNum);
            }
            updateReleaseOrderEo.setReleaseNum(targetReleaseNum);
            updateReleaseOrderEo.setOrderStatus(Integer.valueOf(-99));
            updateReleaseOrderEo.setRemark("\u5f85\u68c0\u5728\u5e93\u6570\u4e0e\u8ba1\u5212\u76ee\u6807\u653e\u884c\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u56de\u64a4\u540e\u91cd\u65b0\u653e\u884c");
            this.inspectionReleaseOrderDas.updateSelective((BaseEo)updateReleaseOrderEo);
            return "\u5f85\u68c0\u5728\u5e93\u6570\u4e0e\u8ba1\u5212\u76ee\u6807\u653e\u884c\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u56de\u64a4\u540e\u91cd\u65b0\u653e\u884c";
        }
        itemEos.removeIf(o -> BigDecimalUtils.eqZero((BigDecimal)o.getReleaseNum()));
        AssertUtils.notEmpty((Collection)itemEos, (String)"\u65e0\u6cd5\u751f\u6210\u6709\u6548\u660e\u7ec6\u884c\uff0c\u751f\u6210\u4efb\u52a1\u5931\u8d25");
        this.inspectionReleaseTaskItemDas.insertBatch((List)itemEos);
        this.transactionCallBackService.execute(() -> this.sendDoTaskMq(taskEo.getTaskNo()));
        this.inspectionReleaseTaskDas.insert((BaseEo)taskEo);
        updateReleaseOrderEo = new InspectionReleaseOrderEo();
        updateReleaseOrderEo.setId(inspectionReleaseOrderEo.getId());
        if (BigDecimalUtils.eqZero((BigDecimal)inspectionReleaseOrderEo.getPlanTargetReleaseNum()).booleanValue()) {
            updateReleaseOrderEo.setPlanTargetReleaseNum(targetReleaseNum);
        }
        updateReleaseOrderEo.setReleaseNum(targetReleaseNum);
        updateReleaseOrderEo.setOrderStatus(Integer.valueOf(1));
        updateReleaseOrderEo.setRemark("");
        this.inspectionReleaseOrderDas.updateSelective((BaseEo)updateReleaseOrderEo);
        if (StringUtils.equals((CharSequence)"PRE", (CharSequence)inspectionReleaseOrderEo.getRemark())) {
            logEo = new InspectionReleaseOperateLogEo();
            logEo.setSourceNo(inspectionReleaseOrderEo.getInspectionReleaseNo());
            logEo.setSkuCode(inspectionReleaseOrderEo.getSkuCode());
            logEo.setSkuName(inspectionReleaseOrderEo.getSkuName());
            logEo.setBatch(inspectionReleaseOrderEo.getBatch());
            logEo.setOperate("receive_report_pass");
            logEo.setDescription("\u62a5\u544a\u5408\u683c\uff0c\u9884\u653e\u884c\u81ea\u52a8\u66f4\u65b0\u4e3a\u5df2\u653e\u884c, \u653e\u884c\u5355\u53f7: " + inspectionReleaseOrderEo.getInspectionReleaseNo());
            this.inspectionReleaseOperateLogDas.insert((BaseEo)logEo);
        }
        logEo = new InspectionReleaseOperateLogEo();
        logEo.setSourceNo(inspectionReleaseOrderEo.getInspectionReleaseNo());
        logEo.setSkuCode(inspectionReleaseOrderEo.getSkuCode());
        logEo.setSkuName(inspectionReleaseOrderEo.getSkuName());
        logEo.setBatch(inspectionReleaseOrderEo.getBatch());
        logEo.setOperate("create_release_task");
        logEo.setDescription("\u521b\u5efa\u653e\u884c\u4efb\u52a1\u6210\u529f");
        this.inspectionReleaseOperateLogDas.insert((BaseEo)logEo);
        return "";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createTaskItemByTask(InspectionReleaseTaskEo taskEo, List<LogicInventoryEo> csLogicInventoryEos, List<LogicInventoryEo> intransitLogicInventoryEos) {
        InspectionReleaseTaskItemEo itemEo;
        InspectionReleaseTaskItemEo dbItemEo;
        List dbItemEos = this.inspectionReleaseTaskItemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskItemEo.class).eq(InspectionReleaseTaskItemEo::getTaskNo, (Object)taskEo.getTaskNo())).in(InspectionReleaseTaskItemEo::getStatus, (Collection)Lists.newArrayList((Object[])new String[]{"ing", "error"}))).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        ArrayList itemEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(csLogicInventoryEos)) {
            for (LogicInventoryEo csLogicInventoryEo : csLogicInventoryEos) {
                dbItemEo = dbItemEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getTaskType(), (CharSequence)"inspection") && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)csLogicInventoryEo.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)csLogicInventoryEo.getBatch()) && StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)csLogicInventoryEo.getWarehouseCode())).findFirst().orElse(null);
                if (null != dbItemEo || BigDecimalUtils.leZero((BigDecimal)csLogicInventoryEo.getAvailable()).booleanValue()) continue;
                itemEo = new InspectionReleaseTaskItemEo();
                itemEo.setInspectionReleaseNo(taskEo.getInspectionReleaseNo());
                itemEo.setTaskNo(taskEo.getTaskNo());
                itemEo.setTaskItemNo(this.codeGenerateUtil.generateNo("FXJL", 6));
                itemEo.setTaskType("inspection");
                itemEo.setWarehouseCode(csLogicInventoryEo.getWarehouseCode());
                itemEo.setSkuCode(taskEo.getSkuCode());
                itemEo.setSkuName(taskEo.getSkuName());
                itemEo.setBatch(taskEo.getBatch());
                itemEo.setStep("execute_transfer");
                itemEo.setEndStep("execute_transfer");
                itemEo.setPlanReleaseNum(csLogicInventoryEo.getAvailable());
                itemEo.setReleaseNum(csLogicInventoryEo.getAvailable());
                itemEo.setStatus("ing");
                itemEo.setRemark(csLogicInventoryEo.getRemark());
                itemEos.add(itemEo);
            }
        }
        if (CollectionUtils.isNotEmpty(intransitLogicInventoryEos)) {
            for (LogicInventoryEo intransitLogicInventoryEo : intransitLogicInventoryEos) {
                dbItemEo = dbItemEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getTaskType(), (CharSequence)"intransit_inspection") && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)intransitLogicInventoryEo.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)intransitLogicInventoryEo.getBatch()) && StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)intransitLogicInventoryEo.getWarehouseCode())).findFirst().orElse(null);
                if (null != dbItemEo) continue;
                itemEo = new InspectionReleaseTaskItemEo();
                itemEo.setInspectionReleaseNo(taskEo.getInspectionReleaseNo());
                itemEo.setTaskNo(taskEo.getTaskNo());
                itemEo.setTaskItemNo(this.codeGenerateUtil.generateNo("FXJL", 6));
                itemEo.setTaskType("intransit_inspection");
                itemEo.setWarehouseCode(intransitLogicInventoryEo.getWarehouseCode());
                itemEo.setSkuCode(taskEo.getSkuCode());
                itemEo.setSkuName(taskEo.getSkuName());
                itemEo.setBatch(taskEo.getBatch());
                itemEo.setStep("cancel_wms_notice");
                itemEo.setEndStep("execute_adjust");
                itemEo.setPlanReleaseNum(intransitLogicInventoryEo.getAvailable());
                itemEo.setReleaseNum(intransitLogicInventoryEo.getAvailable());
                itemEo.setStatus("ing");
                itemEo.setRemark(intransitLogicInventoryEo.getRemark());
                itemEos.add(itemEo);
            }
        }
        itemEos.removeIf(o -> BigDecimalUtils.leZero((BigDecimal)o.getReleaseNum()));
        if (CollectionUtils.isNotEmpty((Collection)itemEos)) {
            this.inspectionReleaseTaskItemDas.insertBatch((List)itemEos);
            this.transactionCallBackService.execute(() -> this.sendDoTaskMq(taskEo.getTaskNo()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void doTask(String taskNo) {
        AssertUtil.assertNotBlank(taskNo, "\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        InspectionReleaseTaskEo taskEo = (InspectionReleaseTaskEo)this.inspectionReleaseTaskMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskEo.class).eq(InspectionReleaseTaskEo::getTaskNo, (Object)taskNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(taskEo, "\u4efb\u52a1\u7f16\u53f7\u67e5\u8be2\u4efb\u52a1\u4e0d\u5b58\u5728", new Object[0]);
        this.checkTaskStatus(taskEo);
        List itemEos = this.inspectionReleaseTaskItemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskItemEo.class).eq(InspectionReleaseTaskItemEo::getTaskNo, (Object)taskEo.getTaskNo())).eq(InspectionReleaseTaskItemEo::getStatus, (Object)"ing")).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)itemEos)) {
            return;
        }
        for (InspectionReleaseTaskItemEo itemEo : itemEos) {
            InspectionReleaseTaskItemRespDto respDto = new InspectionReleaseTaskItemRespDto();
            BeanUtils.copyProperties((Object)itemEo, (Object)respDto);
            this.sendDoTaskItemMq(respDto);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void doTaskItem(InspectionReleaseTaskItemEo itemEo, List<OutNoticeOrderDetailRespVo> noticeOrderDetailRespVoList) {
        if ("inspection".equals(itemEo.getTaskType())) {
            this.doInspectionTask(itemEo);
        } else if ("intransit_inspection".equals(itemEo.getTaskType())) {
            this.doIntransitInspectionTask(itemEo, noticeOrderDetailRespVoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void endByTransferOrderNo(String transferOrderNo) {
        List itemEos = this.inspectionReleaseTaskItemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskItemEo.class).eq(InspectionReleaseTaskItemEo::getExecuteTransferNo, (Object)transferOrderNo)).eq(InspectionReleaseTaskItemEo::getStatus, (Object)"ing")).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)itemEos)) {
            return;
        }
        for (InspectionReleaseTaskItemEo itemEo : itemEos) {
            InspectionReleaseTaskItemEo updateItemEo = new InspectionReleaseTaskItemEo();
            updateItemEo.setId(itemEo.getId());
            updateItemEo.setStatus("end");
            this.inspectionReleaseTaskItemDas.updateSelective((BaseEo)updateItemEo);
        }
        InspectionReleaseTaskEo taskEo = (InspectionReleaseTaskEo)this.inspectionReleaseTaskMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskEo.class).eq(InspectionReleaseTaskEo::getTaskNo, (Object)((InspectionReleaseTaskItemEo)itemEos.get(0)).getTaskNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(taskEo, "\u4efb\u52a1\u7f16\u53f7\u67e5\u8be2\u4efb\u52a1\u4e0d\u5b58\u5728", new Object[0]);
        this.checkTaskStatus(taskEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void errorByTransferCancel(String transferOrderNo) {
        List itemEos = this.inspectionReleaseTaskItemMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskItemEo.class).eq(InspectionReleaseTaskItemEo::getExecuteTransferNo, (Object)transferOrderNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)itemEos)) {
            itemEos = this.inspectionReleaseTaskItemMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskItemEo.class).eq(InspectionReleaseTaskItemEo::getIntransitTransferNo, (Object)transferOrderNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        }
        if (CollectionUtils.isEmpty((Collection)itemEos)) {
            return;
        }
        for (InspectionReleaseTaskItemEo itemEo : itemEos) {
            InspectionReleaseTaskItemEo updateItemEo = new InspectionReleaseTaskItemEo();
            updateItemEo.setId(itemEo.getId());
            updateItemEo.setStatus("error");
            updateItemEo.setReleaseNum(BigDecimal.ZERO);
            this.inspectionReleaseTaskItemDas.updateSelective((BaseEo)updateItemEo);
        }
        InspectionReleaseTaskEo taskEo = (InspectionReleaseTaskEo)this.inspectionReleaseTaskMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskEo.class).eq(InspectionReleaseTaskEo::getTaskNo, (Object)((InspectionReleaseTaskItemEo)itemEos.get(0)).getTaskNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(taskEo, "\u4efb\u52a1\u7f16\u53f7\u67e5\u8be2\u4efb\u52a1\u4e0d\u5b58\u5728", new Object[0]);
        this.checkTaskStatus(taskEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelOtherOut(String otherOutNo) {
        List itemEos = this.inspectionReleaseTaskItemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskItemEo.class).eq(InspectionReleaseTaskItemEo::getStatus, (Object)"wait_exec")).eq(InspectionReleaseTaskItemEo::getPreOrderNo, (Object)otherOutNo)).eq(InspectionReleaseTaskItemEo::getPreOrderType, (Object)CsPcpBusinessTypeEnum.OTHER_OUT.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)itemEos)) {
            return;
        }
        for (InspectionReleaseTaskItemEo itemEo : itemEos) {
            InspectionReleaseTaskItemEo updateItemEo = new InspectionReleaseTaskItemEo();
            updateItemEo.setId(itemEo.getId());
            updateItemEo.setStatus("ing");
            this.inspectionReleaseTaskItemDas.updateSelective((BaseEo)updateItemEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelTransfer(String transferOrderNo) {
        List itemEos = this.inspectionReleaseTaskItemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskItemEo.class).eq(InspectionReleaseTaskItemEo::getStatus, (Object)"wait_exec")).eq(InspectionReleaseTaskItemEo::getPreOrderNo, (Object)transferOrderNo)).eq(InspectionReleaseTaskItemEo::getPreOrderType, (Object)CsInventorySourceTypeEnum.ALLOT_OUT.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)itemEos)) {
            return;
        }
        CsTransferOrderEo transferOrderEo = (CsTransferOrderEo)this.transferOrderMapper.selectOne((Wrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getTransferOrderNo, (Object)transferOrderNo));
        for (InspectionReleaseTaskItemEo itemEo : itemEos) {
            this.changeIntransitTaskItem(itemEo, transferOrderEo.getOutLogicWarehouseCode(), "WMS\u4e3b\u52a8\u53d6\u6d88\u5176\u4ed6\u51fa\u5e93\u901a\u77e5\u5355\uff0c\u6267\u884c\u5f85\u68c0\u653e\u884c");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void outStockCall(CsDeliveryReceiveResultRespDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getRelevanceNo())) {
            return;
        }
        String inOutResultDocumentNo = dto.getPreOrderNo();
        List inOutResultOrderEos = this.inOutResultOrderDomain.queryByDocumentNo(inOutResultDocumentNo);
        AssertUtils.notEmpty((Collection)inOutResultOrderEos, (String)"\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u5355\u53f7\u67e5\u8be2\u4e0d\u5b58\u5728: %s", (Object[])new Object[]{inOutResultDocumentNo});
        InOutResultOrderEo inOutResultOrderEo = (InOutResultOrderEo)inOutResultOrderEos.get(0);
        List itemEos = this.inspectionReleaseTaskItemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskItemEo.class).eq(InspectionReleaseTaskItemEo::getStatus, (Object)"wait_exec")).eq(InspectionReleaseTaskItemEo::getPreOrderNo, (Object)dto.getRelevanceNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)itemEos)) {
            return;
        }
        Map<String, List<InspectionReleaseTaskItemEo>> itemEoMap = itemEos.stream().collect(Collectors.groupingBy(InspectionReleaseTaskItemEo::getPreOrderType));
        List<InspectionReleaseTaskItemEo> transferItemEos = itemEoMap.getOrDefault(CsPcpBusinessTypeEnum.ALLOT_OUT.getCode(), Lists.newArrayList());
        List<InspectionReleaseTaskItemEo> otherOutItemEos = itemEoMap.getOrDefault(CsPcpBusinessTypeEnum.OTHER_OUT.getCode(), Lists.newArrayList());
        if (CollectionUtils.isNotEmpty(otherOutItemEos)) {
            for (InspectionReleaseTaskItemEo otherOutItemEo : otherOutItemEos) {
                InspectionReleaseTaskItemEo updateItemEo = new InspectionReleaseTaskItemEo();
                updateItemEo.setId(otherOutItemEo.getId());
                updateItemEo.setStatus("error");
                updateItemEo.setReleaseNum(BigDecimal.ZERO);
                updateItemEo.setRemark("WMS\u5df2\u51fa\u5e93\uff0c\u6267\u884c\u5931\u8d25");
                this.inspectionReleaseTaskItemDas.updateSelective((BaseEo)updateItemEo);
            }
        }
        List detailRespDtoList = dto.getDeliveryReceiveResultDetailRespDtoList();
        if (CollectionUtils.isEmpty(transferItemEos)) {
            return;
        }
        for (InspectionReleaseTaskItemEo transferItemEo : transferItemEos) {
            InspectionReleaseTaskItemEo updateItemEo;
            CsDeliveryReceiveResultDetailRespDto detailRespDto = detailRespDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getLongCode(), (CharSequence)transferItemEo.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)transferItemEo.getBatch())).findFirst().orElse(null);
            if ("receive".equals(dto.getOrderType())) {
                if (!StringUtils.equals((CharSequence)transferItemEo.getPreInNoticeOrderNo(), (CharSequence)inOutResultOrderEo.getPreOrderNo())) {
                    return;
                }
                updateItemEo = new InspectionReleaseTaskItemEo();
                updateItemEo.setId(transferItemEo.getId());
                if (null != detailRespDto) {
                    updateItemEo.setStatus("ing");
                    updateItemEo.setReleaseNum(detailRespDto.getDoneQuantity());
                    this.inspectionReleaseTaskItemDas.updateSelective((BaseEo)updateItemEo);
                    continue;
                }
                updateItemEo.setStatus("error");
                updateItemEo.setReleaseNum(BigDecimal.ZERO);
                updateItemEo.setRemark("WMS\u5165\u5e93\u672a\u5305\u542b\u8be5\u54c1\u6279\uff0c\u653e\u884c\u6267\u884c\u5931\u8d25");
                this.inspectionReleaseTaskItemDas.updateSelective((BaseEo)updateItemEo);
                continue;
            }
            if (null != detailRespDto) {
                if (BigDecimalUtils.equals((BigDecimal)detailRespDto.getDoneQuantity(), (BigDecimal)transferItemEo.getPlanReleaseNum()).booleanValue()) {
                    updateItemEo = new InspectionReleaseTaskItemEo();
                    updateItemEo.setId(transferItemEo.getId());
                    updateItemEo.setStatus("ing");
                    this.inspectionReleaseTaskItemDas.updateSelective((BaseEo)updateItemEo);
                    continue;
                }
                if (BigDecimalUtils.gt((BigDecimal)detailRespDto.getDoneQuantity(), (BigDecimal)transferItemEo.getPlanReleaseNum()).booleanValue()) {
                    updateItemEo = new InspectionReleaseTaskItemEo();
                    updateItemEo.setId(transferItemEo.getId());
                    updateItemEo.setStatus("error");
                    updateItemEo.setReleaseNum(BigDecimal.ZERO);
                    updateItemEo.setRemark("\u51fa\u5e93\u6570\u91cf\u5927\u4e8e\u8ba1\u5212\u653e\u884c\u6570\u91cf\uff0c\u653e\u884c\u5931\u8d25");
                    this.inspectionReleaseTaskItemDas.updateSelective((BaseEo)updateItemEo);
                    continue;
                }
                updateItemEo = new InspectionReleaseTaskItemEo();
                updateItemEo.setId(transferItemEo.getId());
                updateItemEo.setReleaseNum(detailRespDto.getDoneQuantity());
                updateItemEo.setStatus("ing");
                this.inspectionReleaseTaskItemDas.updateSelective((BaseEo)updateItemEo);
                BigDecimal subNum = BigDecimalUtils.subtract((BigDecimal)transferItemEo.getPlanReleaseNum(), (BigDecimal)detailRespDto.getDoneQuantity());
                InspectionReleaseTaskItemEo newItemEo = new InspectionReleaseTaskItemEo();
                newItemEo.setInspectionReleaseNo(transferItemEo.getInspectionReleaseNo());
                newItemEo.setTaskNo(transferItemEo.getTaskNo());
                newItemEo.setTaskItemNo(this.codeGenerateUtil.generateNo("FXJL", 6));
                newItemEo.setTaskType("inspection");
                newItemEo.setWarehouseCode(dto.getDeliveryLogicWarehouseCode());
                newItemEo.setSkuCode(transferItemEo.getSkuCode());
                newItemEo.setSkuName(transferItemEo.getSkuName());
                newItemEo.setBatch(transferItemEo.getBatch());
                newItemEo.setStep("execute_transfer");
                newItemEo.setEndStep("execute_transfer");
                newItemEo.setPlanReleaseNum(subNum);
                newItemEo.setReleaseNum(subNum);
                newItemEo.setStatus("ing");
                newItemEo.setRemark("\u653e\u884c\u5b50\u4efb\u52a1\u5355\u53f7:" + transferItemEo.getTaskItemNo() + ", \u90e8\u4efd\u8f6c\u5f85\u68c0\u884c");
                this.inspectionReleaseTaskItemDas.insert((BaseEo)newItemEo);
                continue;
            }
            this.changeIntransitTaskItem(transferItemEo, dto.getDeliveryLogicWarehouseCode(), "WMS\u51fa\u5e93\u672a\u5305\u542b\u8be5\u54c1\u6279\uff0c\u653e\u884c\u6267\u884c\u5931\u8d25");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeIntransitTaskItem(String taskItemNo) {
        InspectionReleaseTaskItemEo itemEo = (InspectionReleaseTaskItemEo)this.inspectionReleaseTaskItemMapper.selectOne((Wrapper)Wrappers.lambdaQuery(InspectionReleaseTaskItemEo.class).eq(InspectionReleaseTaskItemEo::getTaskItemNo, (Object)taskItemNo));
        AssertUtils.notNull((Object)itemEo, (String)"\u5b50\u4efb\u52a1[%s]\u4e0d\u5b58\u5728", (Object[])new Object[]{taskItemNo});
        CsTransferOrderEo transferOrderEo = (CsTransferOrderEo)this.transferOrderMapper.selectOne((Wrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getTransferOrderNo, (Object)itemEo.getIntransitTransferNo()));
        AssertUtils.notNull((Object)transferOrderEo, (String)"\u5728\u9014\u8c03\u62e8\u5355[%s]\u67e5\u8be2\u4e0d\u5b58\u5728", (Object[])new Object[]{itemEo.getIntransitTransferNo()});
        this.changeIntransitTaskItem(itemEo, transferOrderEo.getInLogicWarehouseCode(), "\u5165\u5e93\u901a\u77e5\u5355\u5df2\u5b8c\u6210\u5165\u5e93");
    }

    private void doInspectionTask(InspectionReleaseTaskItemEo itemEo) {
        if (StringUtils.isNotBlank((CharSequence)itemEo.getExecuteTransferNo())) {
            return;
        }
        this.executeTransfer(itemEo);
    }

    private void doIntransitInspectionTask(InspectionReleaseTaskItemEo itemEo, List<OutNoticeOrderDetailRespVo> noticeOrderDetailRespVoList) {
        if (StringUtils.isNotBlank((CharSequence)itemEo.getExecuteTransferNo())) {
            return;
        }
        String currentStep = itemEo.getStep();
        String taskNo = itemEo.getTaskNo();
        if ("cancel_wms_notice".equals(currentStep)) {
            InspectionReleaseTaskItemEo updateItemEo = new InspectionReleaseTaskItemEo();
            updateItemEo.setId(itemEo.getId());
            updateItemEo.setStep("modify_notice_send_wms");
            updateItemEo.setExtension(JSON.toJSONString((Object)noticeOrderDetailRespVoList));
            this.inspectionReleaseTaskItemDas.updateSelective((BaseEo)updateItemEo);
            itemEo.setStep("modify_notice_send_wms");
            InspectionReleaseTaskItemRespDto respDto = new InspectionReleaseTaskItemRespDto();
            BeanUtils.copyProperties((Object)itemEo, (Object)respDto);
            this.sendDoTaskItemMq(respDto);
        } else if ("modify_notice_send_wms".equals(currentStep)) {
            noticeOrderDetailRespVoList = JSONArray.parseArray((String)itemEo.getExtension(), OutNoticeOrderDetailRespVo.class);
            this.executeCancelWms(itemEo, noticeOrderDetailRespVoList);
            List itemEos = this.inspectionReleaseTaskItemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskItemEo.class).eq(InspectionReleaseTaskItemEo::getTaskNo, (Object)taskNo)).eq(InspectionReleaseTaskItemEo::getSkuCode, (Object)itemEo.getSkuCode())).eq(InspectionReleaseTaskItemEo::getBatch, (Object)itemEo.getBatch())).eq(InspectionReleaseTaskItemEo::getTaskType, (Object)"intransit_inspection")).eq(InspectionReleaseTaskItemEo::getStatus, (Object)"ing")).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            for (InspectionReleaseTaskItemEo taskItemEo : itemEos) {
                InspectionReleaseTaskItemRespDto respDto = new InspectionReleaseTaskItemRespDto();
                BeanUtils.copyProperties((Object)taskItemEo, (Object)respDto);
                this.sendDoTaskItemMq(respDto);
            }
        } else if ("execute_adjust".equals(currentStep)) {
            this.executeIntransitAndAdjust(Lists.newArrayList((Object[])new InspectionReleaseTaskItemEo[]{itemEo}));
        }
    }

    private void checkTaskStatus(InspectionReleaseTaskEo taskEo) {
        List itemEos = this.inspectionReleaseTaskItemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskItemEo.class).eq(InspectionReleaseTaskItemEo::getTaskNo, (Object)taskEo.getTaskNo())).in(InspectionReleaseTaskItemEo::getStatus, (Collection)Lists.newArrayList((Object[])new String[]{"ing", "wait_exec"}))).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)itemEos)) {
            this.endTask(taskEo);
        }
    }

    private void endTask(InspectionReleaseTaskEo taskEo) {
        InspectionReleaseTaskEo updateTaskEo = new InspectionReleaseTaskEo();
        updateTaskEo.setId(taskEo.getId());
        updateTaskEo.setStatus("end");
        this.inspectionReleaseTaskDas.updateSelective((BaseEo)updateTaskEo);
    }

    private void sendDoTaskMq(String taskNo) {
        log.info("sendDoTaskMq: {}", (Object)taskNo);
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)taskNo);
        this.commonsMqService.sendSingleMessage("INSPECTION_RELEASE_BUSINESS_TOPIC", "DO_INSPECTION_RELEASE_TASK", (Object)messageVo);
    }

    private void sendDoTaskItemMq(InspectionReleaseTaskItemRespDto respDto) {
        log.info("sendDoTaskItemMq: {}", (Object)respDto);
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)respDto);
        this.commonsMqService.sendSingleMessage("INSPECTION_RELEASE_BUSINESS_TOPIC", "DO_INSPECTION_RELEASE_TASK_ITEM", (Object)messageVo);
    }

    private void executeTransfer(InspectionReleaseTaskItemEo itemEo) {
        InspectionReleaseTaskItemEo updateItemEo = new InspectionReleaseTaskItemEo();
        updateItemEo.setId(itemEo.getId());
        String inspectionWarehouseCode = itemEo.getWarehouseCode();
        LogicWarehouseEo inspectionWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getWarehouseCode, (Object)inspectionWarehouseCode)).eq(LogicWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(inspectionWarehouseEo, "\u5f85\u68c0\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]);
        String logicWarehouseCode = inspectionWarehouseEo.getInQualifyWarehouse();
        AssertUtil.assertNotBlank(logicWarehouseCode, "\u5f85\u68c0\u4ed3\u5173\u8054\u5408\u683c\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]);
        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getWarehouseCode, (Object)logicWarehouseCode)).eq(LogicWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(logicWarehouseEo, "\u5f85\u68c0\u4ed3\u5173\u8054\u5408\u683c\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]);
        QueryWrapper csRelWarehouseEoQueryWrapper = new QueryWrapper();
        csRelWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)logicWarehouseCode);
        csRelWarehouseEoQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        csRelWarehouseEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        List csRelWarehouseEoList = this.relWarehouseDomain.getMapper().selectList((Wrapper)csRelWarehouseEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csRelWarehouseEoList), "\u67e5\u8be2\u4e0d\u5230\u5173\u8054\u7269\u7406\u4ed3\u5e93");
        RelWarehouseEo csRelWarehouseEo = (RelWarehouseEo)csRelWarehouseEoList.get(0);
        List logicInventoryEos = this.logicInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).eq(LogicInventoryEo::getWarehouseCode, (Object)inspectionWarehouseCode)).eq(LogicInventoryEo::getSkuCode, (Object)itemEo.getSkuCode())).eq(LogicInventoryEo::getBatch, (Object)itemEo.getBatch())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)logicInventoryEos, (String)"\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        EasTransferOrderReqDto transferOrder = new EasTransferOrderReqDto();
        transferOrder.setOutWarehouseCode(inspectionWarehouseEo.getWarehouseCode());
        transferOrder.setSupplierCode(inspectionWarehouseEo.getOrganizationCode());
        transferOrder.setPlatformOrderNo(this.codeGenerateUtil.generateNo("DBDJ", 6));
        transferOrder.setfOwner("TCBJ");
        transferOrder.setSourceSystem("PCP");
        transferOrder.setAutoAudit(Boolean.TRUE);
        transferOrder.setfPhyWarehs(csRelWarehouseEo.getRefWarehouseCode());
        transferOrder.setAllotType(CsPcpBusinessTypeEnum.INSPECTION_QUALIFIED.getCode());
        transferOrder.setInWarehouseCode(logicWarehouseEo.getWarehouseCode());
        ArrayList itemDetailList = Lists.newArrayList();
        EasTransferOrderDetailReqDto dto = (EasTransferOrderDetailReqDto)BeanUtil.copyProperties((Object)itemEo, EasTransferOrderDetailReqDto.class, (String[])new String[0]);
        dto.setLongCode(itemEo.getSkuCode());
        dto.setQuantity(itemEo.getReleaseNum());
        dto.setBatch(itemEo.getBatch());
        dto.setOutWarehouseCode(inspectionWarehouseEo.getWarehouseCode());
        dto.setInWarehouseCode(logicWarehouseEo.getWarehouseCode());
        dto.setProduceTime(((LogicInventoryEo)logicInventoryEos.get(0)).getProduceTime());
        dto.setExpireTime(((LogicInventoryEo)logicInventoryEos.get(0)).getExpireTime());
        itemDetailList.add(dto);
        transferOrder.setItemDetailList((List)itemDetailList);
        transferOrder.setRemark(itemEo.getRemark());
        log.info("Eas\u65b0\u589e\u8c03\u62e8\u5355\u8868==>{}", (Object)JSON.toJSONString((Object)transferOrder));
        Long transferOrderId = this.transferOrderService.easAddTransferOrder(transferOrder);
        CsAuditReqDto auditReqDto = new CsAuditReqDto();
        auditReqDto.setBusinessOrderNo(transferOrder.getBusinessOrderNo());
        auditReqDto.setAuditResult(CsOtherStorageOrderEnum.AuditEnum.AUDIT_PASS.getCode());
        this.transferOrderService.auditTransferOrder(auditReqDto);
        CsTransferOrderRespDto transferOrderRespDto = this.transferOrderService.queryById(transferOrderId);
        AssertUtil.assertNotNull(transferOrderRespDto, "\u67e5\u8be2\u63d2\u5165\u8c03\u62e8\u5355\u5931\u8d25", new Object[0]);
        updateItemEo.setExecuteTransferNo(transferOrderRespDto.getTransferOrderNo());
        this.inspectionReleaseTaskItemDas.updateSelective((BaseEo)updateItemEo);
    }

    private void executeCancelWms(InspectionReleaseTaskItemEo itemEo, List<OutNoticeOrderDetailRespVo> noticeOrderDetailRespVoList) {
        Map<String, List<OutNoticeOrderDetailRespVo>> noticeMap = noticeOrderDetailRespVoList.stream().collect(Collectors.groupingBy(OutNoticeOrderDetailRespVo::getDocumentNo));
        ArrayList insertItemEoList = Lists.newArrayList();
        List transferNoList = noticeOrderDetailRespVoList.stream().map(OutNoticeOrderDetailRespVo::getRelevanceNo).distinct().collect(Collectors.toList());
        List csTransferOrderEos = this.transferOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).in(CsTransferOrderEo::getTransferOrderNo, transferNoList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        boolean i = false;
        InspectionReleaseTaskItemEo updateItemEo = new InspectionReleaseTaskItemEo();
        updateItemEo.setId(itemEo.getId());
        for (Map.Entry<String, List<OutNoticeOrderDetailRespVo>> entry : noticeMap.entrySet()) {
            OutNoticeOrderDetailRespVo detailRespVo = entry.getValue().get(0);
            if (detailRespVo.getCancelResult().booleanValue()) {
                CsBasicsCancelReqDto csBasicsCancelReqDto = new CsBasicsCancelReqDto();
                csBasicsCancelReqDto.setBusinessType(detailRespVo.getBusinessType());
                csBasicsCancelReqDto.setNoticeOrderNo(detailRespVo.getDocumentNo());
                csBasicsCancelReqDto.setPlatformOrderNo(detailRespVo.getRelevanceNo());
                csBasicsCancelReqDto.setOnlyNodeCancel(Boolean.valueOf(true));
                ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
                String noticeOrderNo = csBasicsCancelReqDto.getNoticeOrderNo();
                QueryWrapper csOutNoticeOrderEoQueryWrapper = new QueryWrapper();
                csOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)noticeOrderNo);
                csOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
                InOutNoticeOrderEo csOutNoticeOrderEo = (InOutNoticeOrderEo)this.inOutNoticeOrderDomain.getMapper().selectOne((Wrapper)csOutNoticeOrderEoQueryWrapper);
                AssertUtil.isTrue(null != csOutNoticeOrderEo, "\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
                ArrayList cancelStatusList = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_CANCEL.getCode(), BaseOrderStatusEnum.DNO_CANCEL.getCode(), BaseOrderStatusEnum.INO_CANCEL.getCode()});
                if (!cancelStatusList.contains(csOutNoticeOrderEo.getOrderStatus())) {
                    wmsExternalService.cancel(csBasicsCancelReqDto);
                }
            }
            CsTransferOrderEo csTransferOrderEo = csTransferOrderEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getTransferOrderNo(), (CharSequence)detailRespVo.getRelevanceNo())).findFirst().orElse(null);
            AssertUtils.notNull((Object)csTransferOrderEo, (String)"\u8c03\u62e8\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
            BigDecimal releaseNum = BigDecimal.ZERO;
            BigDecimal failReleaseNum = BigDecimal.ZERO;
            for (OutNoticeOrderDetailRespVo outNoticeOrderDetailRespVo : entry.getValue()) {
                if (!StringUtils.equals((CharSequence)itemEo.getSkuCode(), (CharSequence)outNoticeOrderDetailRespVo.getLongCode()) || !StringUtils.equals((CharSequence)itemEo.getBatch(), (CharSequence)outNoticeOrderDetailRespVo.getBatch())) continue;
                if (outNoticeOrderDetailRespVo.getCancelResult().booleanValue()) {
                    releaseNum = BigDecimalUtils.add((BigDecimal)releaseNum, (BigDecimal)outNoticeOrderDetailRespVo.getPlanQuantity());
                    continue;
                }
                failReleaseNum = BigDecimalUtils.add((BigDecimal)failReleaseNum, (BigDecimal)outNoticeOrderDetailRespVo.getPlanQuantity());
            }
            updateItemEo.setReleaseNum(releaseNum);
            if (!detailRespVo.getCancelResult().booleanValue()) {
                updateItemEo.setStatus("error");
                updateItemEo.setReleaseNum(BigDecimal.ZERO);
                updateItemEo.setRemark(detailRespVo.getRemark());
                InspectionReleaseTaskItemEo insertItemEo = new InspectionReleaseTaskItemEo();
                BeanUtils.copyProperties((Object)itemEo, (Object)insertItemEo);
                insertItemEo.setId(null);
                insertItemEo.setTaskItemNo(this.codeGenerateUtil.generateNo("FXJL", 6));
                insertItemEo.setTaskType("inspection");
                insertItemEo.setPreOrderNo(csTransferOrderEo.getTransferOrderNo());
                insertItemEo.setPreOrderType(csTransferOrderEo.getType());
                insertItemEo.setPreInNoticeOrderNo(detailRespVo.getDocumentNo());
                insertItemEo.setWarehouseCode(csTransferOrderEo.getInLogicWarehouseCode());
                insertItemEo.setStatus("wait_exec");
                insertItemEo.setStep("execute_transfer");
                insertItemEo.setEndStep("execute_transfer");
                insertItemEo.setReleaseNum(failReleaseNum);
                insertItemEo.setPlanReleaseNum(failReleaseNum);
                insertItemEo.setCreateTime(new Date());
                insertItemEo.setUpdateTime(new Date());
                insertItemEoList.add(insertItemEo);
            }
            updateItemEo.setIntransitTransferNo(detailRespVo.getRelevanceNo());
            updateItemEo.setStep("execute_adjust");
        }
        String intransitInspectionWarehouseCode = itemEo.getWarehouseCode();
        AssertUtil.assertNotBlank(intransitInspectionWarehouseCode, "\u5f85\u68c0\u5728\u9014\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        LogicWarehouseEo intransitInspectionWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getWarehouseCode, (Object)intransitInspectionWarehouseCode)).eq(LogicWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(intransitInspectionWarehouseEo, "\u5f85\u68c0\u5728\u9014\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]);
        AssertUtil.assertNotNull(intransitInspectionWarehouseEo.getSubordinateLogicWarehouseId(), "\u5f85\u68c0\u5728\u9014\u4ed3\u6ca1\u6709\u5bf9\u5e94\u5f85\u68c0\u4ed3ID", new Object[0]);
        LogicWarehouseEo inspectionWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectById((Serializable)intransitInspectionWarehouseEo.getSubordinateLogicWarehouseId());
        AssertUtil.assertNotNull(inspectionWarehouseEo, "\u5f85\u68c0\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]);
        AssertUtil.assertNotBlank(inspectionWarehouseEo.getInQualifyWarehouse(), "\u5f85\u68c0\u4ed3\u8f6c\u5165\u5408\u683c\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728", new Object[0]);
        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getWarehouseCode, (Object)inspectionWarehouseEo.getInQualifyWarehouse())).eq(LogicWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(logicWarehouseEo, "\u5408\u683c\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]);
        this.inspectionReleaseTaskItemDas.updateSelective((BaseEo)updateItemEo);
        this.inspectionReleaseTaskItemDas.insertBatch((List)insertItemEoList);
        this.doUpdateOrder(itemEo, noticeOrderDetailRespVoList, logicWarehouseEo);
    }

    private void executeIntransitAndAdjust(List<InspectionReleaseTaskItemEo> taskItemEos) {
        Map<String, List<InspectionReleaseTaskItemEo>> groupItemEos = taskItemEos.stream().collect(Collectors.groupingBy(InspectionReleaseTaskItemEo::getWarehouseCode));
        for (List<InspectionReleaseTaskItemEo> itemEos : groupItemEos.values()) {
            BigDecimal releaseNum = BigDecimal.ZERO;
            for (InspectionReleaseTaskItemEo itemEo : itemEos) {
                releaseNum = BigDecimalUtils.add((BigDecimal)releaseNum, (BigDecimal)itemEo.getReleaseNum());
            }
            String intransitInspectionWarehouseCode = itemEos.get(0).getWarehouseCode();
            AssertUtil.assertNotBlank(intransitInspectionWarehouseCode, "\u5f85\u68c0\u5728\u9014\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
            LogicWarehouseEo intransitInspectionWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getWarehouseCode, (Object)intransitInspectionWarehouseCode)).eq(LogicWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtil.assertNotNull(intransitInspectionWarehouseEo, "\u5f85\u68c0\u5728\u9014\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]);
            AssertUtil.assertNotNull(intransitInspectionWarehouseEo.getSubordinateLogicWarehouseId(), "\u5f85\u68c0\u5728\u9014\u4ed3\u6ca1\u6709\u5bf9\u5e94\u5f85\u68c0\u4ed3ID", new Object[0]);
            LogicWarehouseEo inspectionWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectById((Serializable)intransitInspectionWarehouseEo.getSubordinateLogicWarehouseId());
            AssertUtil.assertNotNull(inspectionWarehouseEo, "\u5f85\u68c0\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]);
            AssertUtil.assertNotBlank(inspectionWarehouseEo.getInQualifyWarehouse(), "\u5f85\u68c0\u4ed3\u8f6c\u5165\u5408\u683c\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728", new Object[0]);
            LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getWarehouseCode, (Object)inspectionWarehouseEo.getInQualifyWarehouse())).eq(LogicWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtil.assertNotNull(logicWarehouseEo, "\u5408\u683c\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]);
            LogicWarehouseEo intransitLogicWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getSubordinateLogicWarehouseId, (Object)logicWarehouseEo.getId())).eq(LogicWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtil.assertNotNull(intransitLogicWarehouseEo, "\u5408\u683c\u5728\u9014\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728", new Object[0]);
            List logicInventoryEos = this.logicInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).eq(LogicInventoryEo::getWarehouseCode, (Object)inspectionWarehouseEo.getWarehouseCode())).eq(LogicInventoryEo::getSkuCode, (Object)itemEos.get(0).getSkuCode())).eq(LogicInventoryEo::getBatch, (Object)itemEos.get(0).getBatch())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtils.notEmpty((Collection)logicInventoryEos, (String)"\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
            CsTransferOrderComboReqDto reqDto = new CsTransferOrderComboReqDto();
            CsTransferOrderReqDto transferOrderReqDto = new CsTransferOrderReqDto();
            String preOrderNo = itemEos.stream().map(InspectionReleaseTaskItemEo::getIntransitTransferNo).collect(Collectors.joining(","));
            transferOrderReqDto.setPreOrderNo(preOrderNo);
            transferOrderReqDto.setTransferOrderNo(this.codeGenerateUtil.generateNo("DBIN", 6));
            transferOrderReqDto.setType(CsPcpBusinessTypeEnum.IN_TRANSIT_TRANSFER.getCode());
            transferOrderReqDto.setIsEnd(Boolean.valueOf(true));
            transferOrderReqDto.setOutLogicWarehouseCode(intransitInspectionWarehouseCode);
            transferOrderReqDto.setInLogicWarehouseCode(intransitLogicWarehouseEo.getWarehouseCode());
            transferOrderReqDto.setPlanInTime(new Date());
            transferOrderReqDto.setPlanOutTime(new Date());
            transferOrderReqDto.setSourceSystem(CsSourceSystemEnum.PCP.getCode());
            CsTransferOrderDetailReqDto detailReqDto = new CsTransferOrderDetailReqDto();
            detailReqDto.setCargoCode(itemEos.get(0).getSkuCode());
            detailReqDto.setLongCode(itemEos.get(0).getSkuCode());
            detailReqDto.setBatch(itemEos.get(0).getBatch());
            detailReqDto.setCargoName(itemEos.get(0).getSkuName());
            detailReqDto.setQuantity(releaseNum);
            detailReqDto.setTransferOrderNo(transferOrderReqDto.getTransferOrderNo());
            transferOrderReqDto.setRemark(itemEos.get(0).getRemark());
            reqDto.setCsOtherStorageOrderReqDto(transferOrderReqDto);
            reqDto.setDetailList((List)Lists.newArrayList((Object[])new CsTransferOrderDetailReqDto[]{detailReqDto}));
            log.info("\u65b0\u589e\u8c03\u62e8\u5355\u8868==>{}", (Object)JSON.toJSONString((Object)reqDto));
            this.transferOrderService.addTransferOrder(reqDto);
            for (InspectionReleaseTaskItemEo itemEo : itemEos) {
                InspectionReleaseTaskItemEo updateItemEo = new InspectionReleaseTaskItemEo();
                updateItemEo.setId(itemEo.getId());
                updateItemEo.setStatus("end");
                updateItemEo.setExecuteTransferNo(transferOrderReqDto.getTransferOrderNo());
                this.inspectionReleaseTaskItemDas.updateSelective((BaseEo)updateItemEo);
            }
            AdjustmentInventoryReqDto decreaseAdjustAddReqDto = new AdjustmentInventoryReqDto();
            decreaseAdjustAddReqDto.setPreOrderNo(transferOrderReqDto.getTransferOrderNo());
            decreaseAdjustAddReqDto.setRelevanceNo(preOrderNo);
            decreaseAdjustAddReqDto.setAdjustmentRemark(itemEos.get(0).getRemark());
            decreaseAdjustAddReqDto.setAutoAuditPass(Boolean.TRUE);
            decreaseAdjustAddReqDto.setSourceType(CsPcpBusinessTypeEnum.IN_TRANSIT_TRANSFER.getCode());
            decreaseAdjustAddReqDto.setWarehouseCode(intransitInspectionWarehouseEo.getWarehouseCode());
            decreaseAdjustAddReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.IN_TRANSIT.getCode());
            decreaseAdjustAddReqDto.setWarehouseName(intransitInspectionWarehouseEo.getWarehouseName());
            decreaseAdjustAddReqDto.setWarehouseId(intransitInspectionWarehouseEo.getId());
            decreaseAdjustAddReqDto.setBusinessType(CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT_OUT.getCode());
            decreaseAdjustAddReqDto.setAdjustmentType(CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT.getCode());
            AdjustmentInventoryDetailReqDto decreaseDetailAdjustReqDto = new AdjustmentInventoryDetailReqDto();
            decreaseDetailAdjustReqDto.setCargoCode(itemEos.get(0).getSkuCode());
            decreaseDetailAdjustReqDto.setBatch(itemEos.get(0).getBatch());
            decreaseDetailAdjustReqDto.setLongCode(itemEos.get(0).getSkuCode());
            decreaseDetailAdjustReqDto.setCargoName(itemEos.get(0).getSkuName());
            decreaseDetailAdjustReqDto.setChangeQuantity(releaseNum);
            decreaseDetailAdjustReqDto.setChangeType(CsAdjustmentChangeTypeEnum.DECREASE.getCode());
            decreaseDetailAdjustReqDto.setRemark(itemEos.get(0).getRemark());
            decreaseDetailAdjustReqDto.setProduceTime(((LogicInventoryEo)logicInventoryEos.get(0)).getProduceTime());
            decreaseDetailAdjustReqDto.setExpireTime(((LogicInventoryEo)logicInventoryEos.get(0)).getExpireTime());
            decreaseAdjustAddReqDto.setDetailReqDtoList((List)Lists.newArrayList((Object[])new AdjustmentInventoryDetailReqDto[]{decreaseDetailAdjustReqDto}));
            this.adjustmentInventoryApi.addAdjustmentInventory(decreaseAdjustAddReqDto);
            AdjustmentInventoryReqDto increaseAdjustAddReqDto = new AdjustmentInventoryReqDto();
            increaseAdjustAddReqDto.setPreOrderNo(transferOrderReqDto.getTransferOrderNo());
            increaseAdjustAddReqDto.setRelevanceNo(preOrderNo);
            increaseAdjustAddReqDto.setAdjustmentRemark(itemEos.get(0).getRemark());
            increaseAdjustAddReqDto.setAutoAuditPass(Boolean.TRUE);
            increaseAdjustAddReqDto.setSourceType(CsPcpBusinessTypeEnum.IN_TRANSIT_TRANSFER.getCode());
            increaseAdjustAddReqDto.setWarehouseCode(intransitLogicWarehouseEo.getWarehouseCode());
            increaseAdjustAddReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.IN_TRANSIT.getCode());
            increaseAdjustAddReqDto.setWarehouseName(intransitLogicWarehouseEo.getWarehouseName());
            increaseAdjustAddReqDto.setWarehouseId(intransitLogicWarehouseEo.getId());
            increaseAdjustAddReqDto.setBusinessType(CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT_IN.getCode());
            increaseAdjustAddReqDto.setAdjustmentType(CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT.getCode());
            AdjustmentInventoryDetailReqDto increaseDetailAdjustReqDto = new AdjustmentInventoryDetailReqDto();
            increaseDetailAdjustReqDto.setCargoCode(itemEos.get(0).getSkuCode());
            increaseDetailAdjustReqDto.setBatch(itemEos.get(0).getBatch());
            increaseDetailAdjustReqDto.setLongCode(itemEos.get(0).getSkuCode());
            increaseDetailAdjustReqDto.setCargoName(itemEos.get(0).getSkuName());
            increaseDetailAdjustReqDto.setChangeQuantity(releaseNum);
            increaseDetailAdjustReqDto.setChangeType(CsAdjustmentChangeTypeEnum.INCREASE.getCode());
            increaseDetailAdjustReqDto.setRemark(itemEos.get(0).getRemark());
            increaseDetailAdjustReqDto.setProduceTime(((LogicInventoryEo)logicInventoryEos.get(0)).getProduceTime());
            increaseDetailAdjustReqDto.setExpireTime(((LogicInventoryEo)logicInventoryEos.get(0)).getExpireTime());
            increaseAdjustAddReqDto.setDetailReqDtoList((List)Lists.newArrayList((Object[])new AdjustmentInventoryDetailReqDto[]{increaseDetailAdjustReqDto}));
            this.adjustmentInventoryApi.addAdjustmentInventory(increaseAdjustAddReqDto);
        }
    }

    private void doUpdateOrder(InspectionReleaseTaskItemEo itemEo, List<OutNoticeOrderDetailRespVo> noticeOrders, LogicWarehouseEo logicWarehouseEo) {
        log.info("doUpdateOrder: {}, {}", (Object)JSON.toJSONString((Object)itemEo), (Object)JSON.toJSONString(noticeOrders));
        if (!noticeOrders.get(0).getCancelResult().booleanValue()) {
            return;
        }
        ArrayList oldWarehouseNoticeList = Lists.newArrayList();
        ArrayList transferDetails = Lists.newArrayList();
        List longCodeList = noticeOrders.stream().map(OutNoticeOrderDetailRespVo::getLongCode).distinct().collect(Collectors.toList());
        List batchList = noticeOrders.stream().map(OutNoticeOrderDetailRespVo::getBatch).distinct().collect(Collectors.toList());
        List csLogicInventoryEos = this.logicInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).eq(LogicInventoryEo::getWarehouseCode, (Object)noticeOrders.get(0).getReceiveWarehouseCode())).in(LogicInventoryEo::getSkuCode, longCodeList)).in(LogicInventoryEo::getBatch, batchList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        for (OutNoticeOrderDetailRespVo vo : noticeOrders) {
            LogicInventoryEo csLogicInventoryEo = csLogicInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)vo.getLongCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)vo.getBatch())).findFirst().orElse(null);
            AssertUtils.notNull((Object)csLogicInventoryEo, (String)"\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
            AssertUtils.notNull((Object)csLogicInventoryEo.getProduceTime(), (String)"\u5e93\u5b58\u4fe1\u606f\u751f\u4ea7\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)csLogicInventoryEo.getExpireTime(), (String)"\u5e93\u5b58\u4fe1\u606f\u8fc7\u671f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            vo.setProduceTime(csLogicInventoryEo.getProduceTime());
            vo.setExpireTime(csLogicInventoryEo.getExpireTime());
            if (StringUtils.equals((CharSequence)vo.getLongCode(), (CharSequence)itemEo.getSkuCode()) && StringUtils.equals((CharSequence)vo.getBatch(), (CharSequence)itemEo.getBatch())) {
                vo.setDoneQuantity(vo.getWaitQuantity());
                transferDetails.add(vo);
                continue;
            }
            oldWarehouseNoticeList.add(vo);
        }
        if (CollectionUtils.isEmpty((Collection)transferDetails)) {
            return;
        }
        this.addNewNoticeOrder(transferDetails, logicWarehouseEo);
        log.info("\u539f\u6536\u8d27\u901a\u77e5\u5355\u5269\u4f59\u660e\u7ec6: {}", (Object)JSON.toJSONString((Object)oldWarehouseNoticeList));
        this.addOldNoticeOrder(oldWarehouseNoticeList);
    }

    private void addNewNoticeOrder(List<OutNoticeOrderDetailRespVo> transferDetails, LogicWarehouseEo logicWarehouseEo) {
        log.info("addNewNoticeOrder: {}, \u6536\u8d27\u5f85\u68c0\u4ed3: {}", (Object)JSON.toJSONString(transferDetails), (Object)JSON.toJSONString((Object)logicWarehouseEo));
        Map<String, List<OutNoticeOrderDetailRespVo>> newDataMap = transferDetails.stream().collect(Collectors.groupingBy(OutNoticeOrderDetailRespVo::getRelevanceNo));
        log.info("newDataMap: {}", (Object)JSON.toJSONString(newDataMap));
        newDataMap.forEach((k, v) -> {
            log.info("vos: {}", (Object)JSON.toJSONString((Object)v));
            if (((OutNoticeOrderDetailRespVo)v.get(0)).getCancelResult().booleanValue()) {
                ReceiveDeliveryNoticeOrderFacadeBo basicsOrderReqDto = this.getCsCommonBasicsOrderReqDto((List<OutNoticeOrderDetailRespVo>)v);
                log.info("basicsOrderReqDto: {}", (Object)JSON.toJSONString((Object)basicsOrderReqDto));
                basicsOrderReqDto.setLogicWarehouseCode(logicWarehouseEo.getWarehouseCode());
                basicsOrderReqDto.setLogicWarehouseName(logicWarehouseEo.getWarehouseName());
                log.info("\u751f\u6210\u65b0\u6536\u8d27\u901a\u77e5\u5355\u8f6c\u5355:{},:{}", k, (Object)JSONObject.toJSONString((Object)basicsOrderReqDto));
                basicsOrderReqDto.setIgnoreRepeat(Boolean.valueOf(true));
                if (CollectionUtils.isNotEmpty((Collection)basicsOrderReqDto.getOrderBasicsDetailReqDtoList())) {
                    this.baseOrderFacade.receiveNoticeOrderGen(basicsOrderReqDto);
                }
            }
        });
    }

    private void addOldNoticeOrder(List<OutNoticeOrderDetailRespVo> oldWarehouseNotice) {
        if (CollectionUtils.isEmpty(oldWarehouseNotice)) {
            return;
        }
        ReceiveDeliveryNoticeOrderFacadeBo basicsOrderReqDto = this.getCsCommonBasicsOrderReqDto(oldWarehouseNotice);
        basicsOrderReqDto.setRelevanceTableName(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER);
        basicsOrderReqDto.setLogicWarehouseCode(oldWarehouseNotice.get(0).getReceiveWarehouseCode());
        basicsOrderReqDto.setLogicWarehouseName(oldWarehouseNotice.get(0).getReceiveWarehouseName());
        basicsOrderReqDto.setIgnoreRepeat(Boolean.valueOf(true));
        log.info("\u751f\u6210\u65b0\u6536\u8d27\u901a\u77e5\u5355\u539f\u5355:{}", (Object)JSONObject.toJSONString(oldWarehouseNotice));
        log.info("\u751f\u6210\u65b0\u6536\u8d27\u901a\u77e5\u5355:{}", (Object)JSONObject.toJSONString((Object)basicsOrderReqDto));
        this.baseOrderFacade.receiveNoticeOrderGen(basicsOrderReqDto);
    }

    private ReceiveDeliveryNoticeOrderFacadeBo getCsCommonBasicsOrderReqDto(List<OutNoticeOrderDetailRespVo> v) {
        OutNoticeOrderDetailRespVo outNoticeOrderDetailRespVo = v.get(0);
        InOutNoticeOrderEo csOutNoticeOrderEo = (InOutNoticeOrderEo)this.inOutNoticeOrderDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutNoticeOrderEo.class).eq(InOutNoticeOrderEo::getDocumentNo, (Object)v.get(0).getDocumentNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        List inOutNoticeOrderDetailEos = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutNoticeOrderDetailEo.class).eq(InOutNoticeOrderDetailEo::getDocumentNo, (Object)v.get(0).getDocumentNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notNull((Object)csOutNoticeOrderEo, (String)"\u901a\u77e5\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
        ReceiveDeliveryNoticeOrderFacadeBo basicsOrderReqDto = (ReceiveDeliveryNoticeOrderFacadeBo)BeanUtil.copyProperties((Object)outNoticeOrderDetailRespVo, ReceiveDeliveryNoticeOrderFacadeBo.class, (String[])new String[0]);
        basicsOrderReqDto.setRelevanceTableName(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER);
        basicsOrderReqDto.setPreOrderNo(outNoticeOrderDetailRespVo.getPreOrderNo());
        basicsOrderReqDto.setRelevanceNo(outNoticeOrderDetailRespVo.getRelevanceNo());
        basicsOrderReqDto.setBusinessType(csOutNoticeOrderEo.getBusinessType());
        basicsOrderReqDto.setRemark("");
        basicsOrderReqDto.setOrderBasicsDetailReqDtoList(v.stream().map(detail -> {
            InOutNoticeOrderDetailEo inOutNoticeOrderDetailEo = inOutNoticeOrderDetailEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)detail.getLongCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)detail.getBatch())).findFirst().orElse(null);
            AssertUtils.notNull((Object)inOutNoticeOrderDetailEo, (String)"\u901a\u77e5\u5355\u660e\u7ec6\u68c0\u7d22\u4e0d\u5b58\u5728");
            BaseOrderDetailReqDto csBasicsOrderDetailReqDto = (BaseOrderDetailReqDto)BeanUtil.copyProperties((Object)detail, BaseOrderDetailReqDto.class, (String[])new String[0]);
            csBasicsOrderDetailReqDto.setQuantity(detail.getWaitQuantity());
            csBasicsOrderDetailReqDto.setSkuCode(detail.getLongCode());
            csBasicsOrderDetailReqDto.setSkuName(detail.getCargoName());
            csBasicsOrderDetailReqDto.setExpireTime(detail.getExpireTime());
            csBasicsOrderDetailReqDto.setProduceTime(detail.getProduceTime());
            csBasicsOrderDetailReqDto.setPreOrderItemId(inOutNoticeOrderDetailEo.getPreOrderItemId());
            return csBasicsOrderDetailReqDto;
        }).collect(Collectors.toList()));
        return basicsOrderReqDto;
    }

    private void changeIntransitTaskItem(InspectionReleaseTaskItemEo transferItemEo, String logicWarehouseCode, String errorMsg) {
        InspectionReleaseTaskItemEo newItemEo = new InspectionReleaseTaskItemEo();
        newItemEo.setInspectionReleaseNo(transferItemEo.getInspectionReleaseNo());
        newItemEo.setTaskNo(transferItemEo.getTaskNo());
        newItemEo.setTaskItemNo(this.codeGenerateUtil.generateNo("FXJL", 6));
        newItemEo.setTaskType("inspection");
        newItemEo.setWarehouseCode(logicWarehouseCode);
        newItemEo.setSkuCode(transferItemEo.getSkuCode());
        newItemEo.setSkuName(transferItemEo.getSkuName());
        newItemEo.setBatch(transferItemEo.getBatch());
        newItemEo.setStep("execute_transfer");
        newItemEo.setEndStep("execute_transfer");
        newItemEo.setPlanReleaseNum(transferItemEo.getPlanReleaseNum());
        newItemEo.setReleaseNum(transferItemEo.getReleaseNum());
        newItemEo.setStatus("ing");
        this.inspectionReleaseTaskItemDas.insert((BaseEo)newItemEo);
        InspectionReleaseTaskItemEo updateItemEo = new InspectionReleaseTaskItemEo();
        updateItemEo.setId(transferItemEo.getId());
        updateItemEo.setStatus("error");
        updateItemEo.setReleaseNum(BigDecimal.ZERO);
        updateItemEo.setRemark(errorMsg);
        this.inspectionReleaseTaskItemDas.updateSelective((BaseEo)updateItemEo);
    }
}

