/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.IInspectionReleaseTaskApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InspectionReleaseTaskReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInspectionReleaseTaskService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionReleaseTaskItemEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.InspectionReleaseTaskItemMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.OutNoticeOrderDetailRespVo;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InspectionReleaseTaskApiImpl
implements IInspectionReleaseTaskApi {
    @Resource
    private IInspectionReleaseTaskService inspectionReleaseTaskService;
    @Autowired
    InspectionReleaseTaskItemMapper inspectionReleaseTaskItemMapper;
    @Autowired
    ILockService lockService;

    public RestResponse<Long> addInspectionReleaseTask(InspectionReleaseTaskReqDto addReqDto) {
        return new RestResponse((Object)this.inspectionReleaseTaskService.addInspectionReleaseTask(addReqDto));
    }

    public RestResponse<Void> modifyInspectionReleaseTask(InspectionReleaseTaskReqDto modifyReqDto) {
        this.inspectionReleaseTaskService.modifyInspectionReleaseTask(modifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeInspectionReleaseTask(String ids, Long instanceId) {
        this.inspectionReleaseTaskService.removeInspectionReleaseTask(ids, instanceId);
        return RestResponse.VOID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse<Void> doTaskItem(String taskItemNo, List<OutNoticeOrderDetailRespVo> noticeOrderDetailRespVoList) {
        AssertUtil.assertNotBlank(taskItemNo, "\u4efb\u52a1\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Mutex mutex = this.lockService.lock("InspectionReleaseTaskApiImpl_doTaskItem", taskItemNo, 25, 20, TimeUnit.SECONDS);
        try {
            InspectionReleaseTaskItemEo itemEo = (InspectionReleaseTaskItemEo)this.inspectionReleaseTaskItemMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionReleaseTaskItemEo.class).eq(InspectionReleaseTaskItemEo::getTaskItemNo, (Object)taskItemNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            if (!"ing".equals(itemEo.getStatus())) {
                throw new CsInventoryException("\u5f53\u524d\u4efb\u52a1\u5df2\u4e0d\u5904\u4e8e\u8fdb\u884c\u4e2d\u7684\u72b6\u6001", new Object[0]);
            }
            this.inspectionReleaseTaskService.doTaskItem(itemEo, noticeOrderDetailRespVoList);
        }
        finally {
            this.lockService.unlock(mutex);
        }
        return RestResponse.VOID;
    }

    public RestResponse<Void> doTask(String taskNo) {
        Mutex mutex = this.lockService.lock("InspectionReleaseTaskApiImpl_doTask", taskNo, 25, 20, TimeUnit.SECONDS);
        try {
            this.inspectionReleaseTaskService.doTask(taskNo);
        }
        finally {
            this.lockService.unlock(mutex);
        }
        return RestResponse.VOID;
    }

    public RestResponse<Void> outStockCall(CsDeliveryReceiveResultRespDto dto) {
        this.inspectionReleaseTaskService.outStockCall(dto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> changeIntransitTaskItem(String taskItemNo) {
        this.inspectionReleaseTaskService.changeIntransitTaskItem(taskItemNo);
        return RestResponse.VOID;
    }
}

