/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.AbstractCsInventoryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventoryBasicsOperateService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryCoverInventoryFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="CslogicinventoryStrategyService")
public class CsLogicInventoryServiceImpl
extends AbstractCsInventoryService {
    private Logger logger = LoggerFactory.getLogger(CsLogicInventoryServiceImpl.class);
    @Autowired
    ILogicInventoryDomain logicInventoryDomain;
    @Autowired
    ILogicInventoryTotalDomain logicInventoryTotalDomain;
    @Autowired
    ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    private IContext context;
    @Autowired
    @Qualifier(value="CslogicinventoryStrategyService")
    private ICsInventoryBasicsOperateService logicBasicsOperateService;

    @Override
    protected String getInventoryLogTableName(CsInventoryInOutBasicsDto inOutBasicDto, CsInventoryInOutBasicsCargoDto basicDetailDto) {
        String batch = basicDetailDto.getBatch();
        Table tableAnnotation = null;
        tableAnnotation = StringUtils.isNotBlank((CharSequence)batch) ? LogicInventoryEo.class.getAnnotation(Table.class) : LogicInventoryTotalEo.class.getAnnotation(Table.class);
        return tableAnnotation.name();
    }

    @Override
    protected void sortList(CsInventoryInOutBasicsDto inParamDto) {
        String key;
        List inOutBasicsCargoDtoList = inParamDto.getInOutBasicsCargoDtoList();
        ArrayList batchDtoList = Lists.newArrayList();
        ArrayList unBatchDtoList = Lists.newArrayList();
        for (CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto : inOutBasicsCargoDtoList) {
            String batch = inOutBasicsCargoDto.getBatch();
            if (StringUtils.isBlank((CharSequence)batch)) {
                unBatchDtoList.add(inOutBasicsCargoDto);
                continue;
            }
            batchDtoList.add(inOutBasicsCargoDto);
        }
        Map<Object, Object> batchInventoryEoMap = Maps.newHashMap();
        Map<Object, Object> unBatchInventoryEoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)batchDtoList)) {
            List batchList = batchDtoList.stream().map(CsInventoryInOutBasicsCargoDto::getBatch).collect(Collectors.toList());
            List warehouseCodeList = batchDtoList.stream().map(CsInventoryInOutBasicsCargoDto::getWarehouseCode).collect(Collectors.toList());
            List cargoCodeList = batchDtoList.stream().map(CsInventoryInOutBasicsCargoDto::getCargoCode).collect(Collectors.toList());
            QueryWrapper LogicInventoryEoQueryWrapper = new QueryWrapper();
            LogicInventoryEoQueryWrapper.in((Object)"batch", batchList);
            LogicInventoryEoQueryWrapper.in((Object)"warehouse_code", warehouseCodeList);
            LogicInventoryEoQueryWrapper.in((Object)"sku_code", cargoCodeList);
            List batchLogicInventoryEoList = this.logicInventoryDomain.getMapper().selectList((Wrapper)LogicInventoryEoQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)batchLogicInventoryEoList)) {
                batchInventoryEoMap = batchLogicInventoryEoList.stream().collect(Collectors.toMap(eo -> eo.getWarehouseCode() + "_" + eo.getSkuCode() + "_" + eo.getBatch(), Function.identity()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)unBatchDtoList)) {
            List warehouseCodeList = unBatchDtoList.stream().map(CsInventoryInOutBasicsCargoDto::getWarehouseCode).collect(Collectors.toList());
            List cargoCodeList = unBatchDtoList.stream().map(CsInventoryInOutBasicsCargoDto::getCargoCode).collect(Collectors.toList());
            QueryWrapper LogicInventoryTotalEoQueryWrapper = new QueryWrapper();
            LogicInventoryTotalEoQueryWrapper.in((Object)"warehouse_code", warehouseCodeList);
            LogicInventoryTotalEoQueryWrapper.in((Object)"sku_code", cargoCodeList);
            List unBatchLogicInventoryEoList = this.logicInventoryTotalDomain.getMapper().selectList((Wrapper)LogicInventoryTotalEoQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)unBatchLogicInventoryEoList)) {
                unBatchInventoryEoMap = unBatchLogicInventoryEoList.stream().collect(Collectors.toMap(eo -> eo.getWarehouseCode() + "_" + eo.getSkuCode(), Function.identity()));
            }
        }
        ArrayList sortOperateList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)batchDtoList)) {
            ArrayList sortBatchOperateList = Lists.newArrayList();
            ArrayList unSortBatchOperateList = Lists.newArrayList();
            for (CsInventoryInOutBasicsCargoDto batchDto : batchDtoList) {
                key = batchDto.getWarehouseCode() + "_" + batchDto.getCargoCode() + "_" + batchDto.getBatch();
                LogicInventoryEo inventoryEo = (LogicInventoryEo)batchInventoryEoMap.get(key);
                if (null == inventoryEo) {
                    unSortBatchOperateList.add(batchDto);
                    continue;
                }
                batchDto.setId(inventoryEo.getId());
                sortBatchOperateList.add(batchDto);
            }
            if (CollectionUtils.isNotEmpty((Collection)sortBatchOperateList)) {
                Collections.sort(sortBatchOperateList, Comparator.comparing(CsInventoryInOutBasicsCargoDto::getId));
                sortOperateList.addAll(sortBatchOperateList);
            }
            if (CollectionUtils.isNotEmpty((Collection)unSortBatchOperateList)) {
                sortOperateList.addAll(unSortBatchOperateList);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)unBatchDtoList)) {
            ArrayList sortUnBatchOperateList = Lists.newArrayList();
            ArrayList unSortUnBatchOperateList = Lists.newArrayList();
            for (CsInventoryInOutBasicsCargoDto unBatchDto : unBatchDtoList) {
                key = unBatchDto.getWarehouseCode() + "_" + unBatchDto.getCargoCode();
                LogicInventoryTotalEo LogicInventoryTotalEo2 = (LogicInventoryTotalEo)unBatchInventoryEoMap.get(key);
                if (null == LogicInventoryTotalEo2) {
                    unSortUnBatchOperateList.add(unBatchDto);
                    continue;
                }
                unBatchDto.setId(LogicInventoryTotalEo2.getId());
                sortUnBatchOperateList.add(unBatchDto);
            }
            if (CollectionUtils.isNotEmpty((Collection)sortUnBatchOperateList)) {
                Collections.sort(sortUnBatchOperateList, Comparator.comparing(CsInventoryInOutBasicsCargoDto::getId));
                sortOperateList.addAll(sortUnBatchOperateList);
            }
            if (CollectionUtils.isNotEmpty((Collection)unSortUnBatchOperateList)) {
                sortOperateList.addAll(unSortUnBatchOperateList);
            }
        }
        inParamDto.setInOutBasicsCargoDtoList((List)sortOperateList);
        this.logger.info("sortList==>\u903b\u8f91\u5e93\u5b58\u6392\u5e8f\u5904\u7406\u540e,inParamDto:{}", (Object)LogUtils.buildLogContent(inParamDto));
    }

    @Override
    public Boolean existWarehouse(CsInventoryInOutBasicsDto csInventoryInOutBasicsDto) {
        List inOutBasicDetailDtoList = csInventoryInOutBasicsDto.getInOutBasicsCargoDtoList();
        List warehouseCodeList = inOutBasicDetailDtoList.stream().map(CsInventoryInOutBasicsCargoDto::getWarehouseCode).distinct().collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        queryWrapper.eq((Object)"warehouse_status", (Object)CsLogicWarehouseStatusEnum.ENABLE.getCode());
        List csPhysicsWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)queryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csPhysicsWarehouseEoList), "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        Map logicWarehouseEoMap = csPhysicsWarehouseEoList.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity()));
        for (CsInventoryInOutBasicsCargoDto detailDto : inOutBasicDetailDtoList) {
            String warehouseCode = detailDto.getWarehouseCode();
            LogicWarehouseEo LogicWarehouseEo2 = (LogicWarehouseEo)logicWarehouseEoMap.get(warehouseCode);
            if (null == LogicWarehouseEo2) continue;
            detailDto.setWarehouseCode(LogicWarehouseEo2.getWarehouseCode());
            detailDto.setWarehouseId(LogicWarehouseEo2.getId());
            detailDto.setWarehouseType(LogicWarehouseEo2.getWarehouseType());
            detailDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            detailDto.setWarehouseName(LogicWarehouseEo2.getWarehouseName());
        }
        return true;
    }

    @Override
    public Long existInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        String batch = inDetailDto.getBatch();
        if (StringUtils.isNotBlank((CharSequence)batch)) {
            return this.batchExistInventory(inDetailDto);
        }
        return this.totalExistInventory(inDetailDto);
    }

    private Long totalExistInventory(CsInventoryInOutBasicsCargoDto inDetailDto) {
        String warehouseCode = inDetailDto.getWarehouseCode();
        String cargoCode = inDetailDto.getCargoCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        queryWrapper.eq((Object)"sku_code", (Object)cargoCode);
        queryWrapper.eq((Object)"dr", (Object)0);
        LogicInventoryTotalEo LogicInventoryTotalEo2 = (LogicInventoryTotalEo)this.logicInventoryTotalDomain.getMapper().selectOne((Wrapper)queryWrapper);
        this.logger.info("query LogicInventoryTotalEo result is {} .", (Object)JSON.toJSONString((Object)LogicInventoryTotalEo2));
        if (null == LogicInventoryTotalEo2) {
            return null;
        }
        return LogicInventoryTotalEo2.getId();
    }

    private Long batchExistInventory(CsInventoryInOutBasicsCargoDto inDetailDto) {
        String batch = inDetailDto.getBatch();
        String warehouseCode = inDetailDto.getWarehouseCode();
        String cargoCode = inDetailDto.getCargoCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        queryWrapper.eq((Object)"sku_code", (Object)cargoCode);
        queryWrapper.eq((Object)"batch", (Object)batch);
        queryWrapper.eq((Object)"dr", (Object)0);
        LogicInventoryEo LogicInventoryEo2 = (LogicInventoryEo)this.logicInventoryDomain.getMapper().selectOne((Wrapper)queryWrapper);
        if (null == LogicInventoryEo2) {
            return null;
        }
        return LogicInventoryEo2.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean doInitInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        Mutex mutex = null;
        try {
            mutex = this.lock(inParamDto, inDetailDto);
            Boolean bl = this.logicBasicsOperateService.initInventory(inParamDto, inDetailDto);
            return bl;
        }
        finally {
            this.unLock(mutex);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Boolean initInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        this.logger.info("logic,initInventory==>\u5373\u5c06\u6267\u884c\u521d\u59cb\u5316\u5e93\u5b58\u64cd\u4f5c,inParamDto:{},inDetailDto:{}", (Object)LogUtils.buildLogContent(inParamDto), (Object)LogUtils.buildLogContent(inDetailDto));
        if (null != this.existInventory(inParamDto, inDetailDto)) {
            return true;
        }
        return this.executeInitInventory(inParamDto, inDetailDto);
    }

    private Boolean executeInitInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        String batch = inDetailDto.getBatch();
        Boolean result = true;
        result = StringUtils.isNotBlank((CharSequence)batch) ? this.batchInitInventory(inParamDto, inDetailDto) : this.totalInitInventory(inParamDto, inDetailDto);
        if (!result.booleanValue()) {
            throw new BizException("\u521d\u59cb\u5316\u5e93\u5b58\u5f02\u5e38");
        }
        return result;
    }

    private Boolean totalInitInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        AssertUtil.isTrue(null != inDetailDto.getBalance(), CsInventoryExceptionCode.INVENTORY_IS_NOT_EXIST.getCode(), inDetailDto.getCargoCode() + CsInventoryExceptionCode.INVENTORY_IS_NOT_EXIST.getMsg());
        AssertUtil.isTrue(inDetailDto.getBalance().compareTo(BigDecimal.valueOf(0L)) >= 0, CsInventoryExceptionCode.INVENTORY_IS_NEGATIVE.getCode(), CsInventoryExceptionCode.INVENTORY_IS_NEGATIVE.getMsg());
        LogicInventoryTotalEo logicInventoryTotalEo = new LogicInventoryTotalEo();
        CubeBeanUtils.copyProperties((Object)logicInventoryTotalEo, (Object)inDetailDto, (String[])new String[0]);
        logicInventoryTotalEo.setWarehouseId(inDetailDto.getWarehouseId());
        logicInventoryTotalEo.setWarehouseCode(inDetailDto.getWarehouseCode());
        logicInventoryTotalEo.setSkuCode(inDetailDto.getCargoCode());
        logicInventoryTotalEo.setAvailable(this.calculateInsertAvailableInventory(inParamDto, inDetailDto));
        logicInventoryTotalEo.setUpdateTime(new Date());
        logicInventoryTotalEo.setCreateTime(new Date());
        logicInventoryTotalEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        logicInventoryTotalEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        logicInventoryTotalEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        logicInventoryTotalEo.setCreatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        int result = this.logicInventoryTotalDomain.insert((BaseEo)logicInventoryTotalEo);
        return result > 0;
    }

    private Boolean batchInitInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        AssertUtil.isTrue(null != inDetailDto.getBalance(), CsInventoryExceptionCode.INVENTORY_IS_NOT_EXIST.getCode(), inDetailDto.getCargoCode() + CsInventoryExceptionCode.INVENTORY_IS_NOT_EXIST.getMsg());
        AssertUtil.isTrue(inDetailDto.getBalance().compareTo(BigDecimal.valueOf(0L)) >= 0, CsInventoryExceptionCode.INVENTORY_IS_NEGATIVE.getCode(), CsInventoryExceptionCode.INVENTORY_IS_NEGATIVE.getMsg());
        LogicInventoryEo batchEo = new LogicInventoryEo();
        CubeBeanUtils.copyProperties((Object)batchEo, (Object)inDetailDto, (String[])new String[0]);
        batchEo.setWarehouseId(inDetailDto.getWarehouseId());
        batchEo.setWarehouseCode(inDetailDto.getWarehouseCode());
        batchEo.setSkuCode(inDetailDto.getCargoCode());
        batchEo.setBatch(inDetailDto.getBatch());
        batchEo.setAvailable(this.calculateInsertAvailableInventory(inParamDto, inDetailDto));
        batchEo.setUpdateTime(new Date());
        batchEo.setCreateTime(new Date());
        batchEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        batchEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        batchEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        batchEo.setCreatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        int result = this.logicInventoryDomain.insert((BaseEo)batchEo);
        if (result <= 0) {
            return false;
        }
        Integer updateTotalFlag = inParamDto.getUpdateTotalFlag();
        if (null == updateTotalFlag || YesNoEnum.NO.getValue().equals(updateTotalFlag)) {
            return true;
        }
        CsInventoryInOutBasicsCargoDto tempDto = new CsInventoryInOutBasicsCargoDto();
        CubeBeanUtils.copyProperties((Object)tempDto, (Object)inDetailDto, (String[])new String[0]);
        Long totalId = this.totalExistInventory(tempDto);
        LogicInventoryTotalEo logicInventoryTotalEo = new LogicInventoryTotalEo();
        CubeBeanUtils.copyProperties((Object)logicInventoryTotalEo, (Object)tempDto, (String[])new String[0]);
        logicInventoryTotalEo.setWarehouseId(inDetailDto.getWarehouseId());
        logicInventoryTotalEo.setWarehouseCode(inDetailDto.getWarehouseCode());
        logicInventoryTotalEo.setSkuCode(inDetailDto.getCargoCode());
        String coverInventoryFlag = inParamDto.getCoverInventoryFlag();
        if (null == totalId) {
            this.logicInventoryTotalDomain.insert((BaseEo)logicInventoryTotalEo);
        } else {
            LogicInventoryTotalEo logicInventoryTotalUpdateEo = new LogicInventoryTotalEo();
            logicInventoryTotalUpdateEo.setUpdateTime(new Date());
            logicInventoryTotalUpdateEo.setCreateTime(new Date());
            logicInventoryTotalUpdateEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
            logicInventoryTotalUpdateEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
            logicInventoryTotalUpdateEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
            logicInventoryTotalUpdateEo.setCreatePerson(null == this.context.userName() ? "-1" : this.context.userName());
            logicInventoryTotalUpdateEo.setId(totalId);
            if (CsInventoryCoverInventoryFlagEnum.UPDATE.getCode().equals(coverInventoryFlag)) {
                logicInventoryTotalUpdateEo.setBalance(batchEo.getBalance());
                logicInventoryTotalUpdateEo.setAvailable(batchEo.getAvailable());
            } else if (CsInventoryCoverInventoryFlagEnum.COVER.getCode().equals(coverInventoryFlag)) {
                // empty if block
            }
        }
        return result > 0;
    }

    @Override
    public boolean doUpdateInventory(Long inventoryId, CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        String batch = inDetailDto.getBatch();
        if (StringUtils.isNotBlank((CharSequence)batch)) {
            return this.batchUpdateInventory(inventoryId, inDetailDto, inParamDto);
        }
        return this.totalUpdateInventory(inventoryId, inParamDto, inDetailDto);
    }

    private boolean totalUpdateInventory(Long inventoryId, CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        this.logger.info("\u6dfb\u52a0\u65e5\u5fd7\u6392\u67e5\u95ee\u9898\uff0c\u903b\u8f91\u4ed3\u603b\u8868\u66f4\u65b0,inventoryId\uff1a{}", (Object)inventoryId);
        LogicInventoryTotalEo logicInventoryTotalEo = new LogicInventoryTotalEo();
        CubeBeanUtils.copyProperties((Object)logicInventoryTotalEo, (Object)inDetailDto, (String[])new String[0]);
        logicInventoryTotalEo.setWarehouseId(inDetailDto.getWarehouseId());
        logicInventoryTotalEo.setWarehouseCode(inDetailDto.getWarehouseCode());
        logicInventoryTotalEo.setSkuCode(inDetailDto.getCargoCode());
        logicInventoryTotalEo.setId(inventoryId);
        logicInventoryTotalEo.setUpdateTime(new Date());
        logicInventoryTotalEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        logicInventoryTotalEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        logicInventoryTotalEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        String coverInventoryFlag = inParamDto.getCoverInventoryFlag();
        int result = 0;
        if (CsInventoryCoverInventoryFlagEnum.UPDATE.getCode().equals(coverInventoryFlag)) {
            this.logger.info("\u6dfb\u52a0\u65e5\u5fd7\u6392\u67e5\u95ee\u9898\uff0c\u903b\u8f91\u4ed3\u603b\u8868\u66f4\u65b0,balance\uff1a{}", (Object)logicInventoryTotalEo.getBalance());
        } else if (CsInventoryCoverInventoryFlagEnum.COVER.getCode().equals(coverInventoryFlag)) {
            // empty if block
        }
        this.logger.info("\u6dfb\u52a0\u65e5\u5fd7\u6392\u67e5\u95ee\u9898\uff0c\u903b\u8f91\u4ed3\u603b\u8868\u66f4\u65b0,result\uff1a{}", (Object)result);
        return result > 0;
    }

    private boolean batchUpdateInventory(Long inventoryId, CsInventoryInOutBasicsCargoDto inDetailDto, CsInventoryInOutBasicsDto inParamDto) {
        this.logger.info("\u6dfb\u52a0\u65e5\u5fd7\u6392\u67e5\u95ee\u9898\uff0c\u903b\u8f91\u4ed3\u66f4\u65b0,inventoryId\uff1a{}", (Object)inventoryId);
        String coverInventoryFlag = inParamDto.getCoverInventoryFlag();
        LogicInventoryEo LogicInventoryEo2 = new LogicInventoryEo();
        CubeBeanUtils.copyProperties((Object)LogicInventoryEo2, (Object)inDetailDto, (String[])new String[0]);
        LogicInventoryEo2.setWarehouseId(inDetailDto.getWarehouseId());
        LogicInventoryEo2.setWarehouseCode(inDetailDto.getWarehouseCode());
        LogicInventoryEo2.setSkuCode(inDetailDto.getCargoCode());
        LogicInventoryEo2.setBatch(inDetailDto.getBatch());
        LogicInventoryEo2.setId(inventoryId);
        LogicInventoryEo2.setUpdateTime(new Date());
        LogicInventoryEo2.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        LogicInventoryEo2.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        LogicInventoryEo2.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        int batchResult = 0;
        if (!CsInventoryCoverInventoryFlagEnum.UPDATE.getCode().equals(coverInventoryFlag) && CsInventoryCoverInventoryFlagEnum.COVER.getCode().equals(coverInventoryFlag)) {
            batchResult = this.logicInventoryDomain.updateSelective((BaseEo)LogicInventoryEo2);
        }
        if (batchResult <= 0) {
            return false;
        }
        Integer updateTotalFlag = inParamDto.getUpdateTotalFlag();
        if (null == updateTotalFlag || YesNoEnum.NO.getValue().equals(updateTotalFlag)) {
            return true;
        }
        Long totalId = this.totalExistInventory(inDetailDto);
        this.logger.info("\u6dfb\u52a0\u65e5\u5fd7\u6392\u67e5\u95ee\u9898\uff0c\u903b\u8f91\u4ed3\u66f4\u65b0,totalId\uff1a{}", (Object)totalId);
        this.totalUpdateInventory(totalId, inParamDto, inDetailDto);
        this.logger.info("\u6dfb\u52a0\u65e5\u5fd7\u6392\u67e5\u95ee\u9898\uff0c\u903b\u8f91\u4ed3\u3001\u603b\u8868\u66f4\u65b0\u7ed3\u675f");
        return true;
    }

    @Override
    public String getStrategy() {
        return null;
    }

    @Override
    public Boolean inInventory(CsInventoryInOutBasicsDto inBasicsDto) {
        return null;
    }

    @Override
    public Boolean outInventory(CsInventoryInOutBasicsDto outBasicsDto) {
        return null;
    }
}

