/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics;

import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.ICsBasicsOrderOperateService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.ICsBasicsOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.anno.CsBasicsOrderOperateStrategy;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.anno.CsBasicsOrderQueryStrategy;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsOrderStrategyEnum;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="csOrderStrategyUtils")
public class CsBasicsOrderStrategyUtils
implements ApplicationContextAware {
    private static Logger logger = LoggerFactory.getLogger(CsBasicsOrderStrategyUtils.class);
    private ApplicationContext applicationContext;
    private static Map<String, ICsBasicsOrderOperateService> basicsOrderOperateServiceMap = Maps.newHashMap();
    private static Map<String, ICsBasicsOrderQueryService> basicsOrderQueryServiceMap = Maps.newHashMap();
    public static final String DETAIL_SUFFIX = "_detail";
    public static final String PREFIX = "Cs";
    public static final String SUFFIX = "basicsOrderStrategyService";
    public static final String QUERY_SUFFIX = "basicsOrderStrategyQueryService";
    public static final String RECEIVE_DELIVERY_NOTICE_ORDER = "receiveDeliveryNoticeOrder";
    public static final String IN_OUT_NOTICE_ORDER = "inOutNoticeOrder";
    public static final String RECEIVE_DELIVERY_RESULT_ORDER = "receiveDeliveryResultOrder";
    public static final String IN_OUT_RESULT_ORDER = "inOutResultOrder";

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map queryBeanMap;
        String strategyName;
        boolean effect;
        Annotation annotation;
        this.applicationContext = applicationContext;
        Map operateBeanMap = applicationContext.getBeansWithAnnotation(CsBasicsOrderOperateStrategy.class);
        if (MapUtils.isNotEmpty((Map)operateBeanMap)) {
            Set entrySet = operateBeanMap.entrySet();
            for (Map.Entry entry : entrySet) {
                ICsBasicsOrderOperateService csBasicsOrderOperateService = (ICsBasicsOrderOperateService)entry.getValue();
                Class targetClass = AopUtils.getTargetClass((Object)csBasicsOrderOperateService);
                annotation = targetClass.getDeclaredAnnotation(CsBasicsOrderOperateStrategy.class);
                if (null == annotation || !(effect = annotation.effect())) continue;
                strategyName = annotation.strategyName();
                basicsOrderOperateServiceMap.put(strategyName, csBasicsOrderOperateService);
            }
        }
        if (MapUtils.isNotEmpty((Map)(queryBeanMap = applicationContext.getBeansWithAnnotation(CsBasicsOrderQueryStrategy.class)))) {
            Set entrySet = queryBeanMap.entrySet();
            for (Map.Entry entry : entrySet) {
                ICsBasicsOrderQueryService csBasicsOrderQueryService = (ICsBasicsOrderQueryService)entry.getValue();
                annotation = csBasicsOrderQueryService.getClass().getDeclaredAnnotation(CsBasicsOrderQueryStrategy.class);
                if (null == annotation || !(effect = annotation.effect())) continue;
                strategyName = annotation.strategyName();
                basicsOrderQueryServiceMap.put(strategyName, csBasicsOrderQueryService);
            }
        }
    }

    public static ICsBasicsOrderOperateService getBasicsOrderOperateService(String strategy) {
        logger.info("getInventoryService==>\u6839\u636e\u4f20\u5165\u7684\u7b56\u7565\u83b7\u53d6\u64cd\u4f5c\u5355\u636e\u7684\u7b56\u7565\u7c7b,strategy:{}", (Object)strategy);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategy), "\u64cd\u4f5c\u7b56\u7565\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsBasicsOrderStrategyEnum basicsOrderStrategyEnum = CsBasicsOrderStrategyEnum.getByCode((String)strategy);
        AssertUtil.isTrue(null != basicsOrderStrategyEnum, "\u5355\u636e\u64cd\u4f5c\u7b56\u7565\u83b7\u53d6\u6709\u8bef");
        return basicsOrderOperateServiceMap.get(basicsOrderStrategyEnum.getCode());
    }

    public static ICsBasicsOrderQueryService getBasicsOrderQueryService(String strategy) {
        logger.info("getInventoryService==>\u6839\u636e\u4f20\u5165\u7684\u7b56\u7565\u83b7\u53d6\u67e5\u8be2\u5355\u636e\u7684\u7b56\u7565\u7c7b,strategy:{}", (Object)strategy);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategy), "\u67e5\u8be2\u7b56\u7565\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsBasicsOrderStrategyEnum basicsOrderStrategyEnum = CsBasicsOrderStrategyEnum.getByCode((String)strategy);
        AssertUtil.isTrue(null != basicsOrderStrategyEnum, "\u5355\u636e\u67e5\u8be2\u7b56\u7565\u83b7\u53d6\u6709\u8bef");
        return basicsOrderQueryServiceMap.get(basicsOrderStrategyEnum.getCode());
    }
}

