/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.cs.order;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.RollbackDeliveryOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutResultOrderRepairDataDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderStringValidReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutResultSolutionToHangReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutResultSolutionToHangRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutResultOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutResultOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryCoverInventoryFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csOutResultOrderApi")
public class CsOutResultOrderApiImpl
implements ICsOutResultOrderApi {
    private static Logger logger = LoggerFactory.getLogger(CsOutResultOrderApiImpl.class);
    @Resource
    private ICsOutResultOrderService csOutResultOrderService;
    @Resource
    private ICsDeliveryNoticeOrderService csDeliveryNoticeOrderService;
    @Resource
    private ICsInventoryExposedService csInventoryExposedService;
    @Resource
    private ICsInventoryPreemptionService csInventoryPreemptionService;
    @Resource
    private ICsInventoryPreemptionQueryService csInventoryPreemptionQueryService;
    @Resource
    private ICsOutResultOrderQueryService csOutResultOrderQueryService;

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public RestResponse<String> sendBack(TcbjResGenReqDto reqDto) {
        logger.info("\u8425\u9500\u4e91\u53d1\u8d27\u56de\u4f20,\u5165\u53c2\uff1a[reqDto:{}]", (Object)LogUtils.buildLogContent(reqDto));
        CsOutResultOrderAddReqDto addReqDto = this.changeParam(reqDto);
        Long id = this.csOutResultOrderService.add(addReqDto);
        logger.info("\u8425\u9500\u4e91\u53d1\u8d27\u56de\u4f20,\u751f\u6210\u51fa\u5e93\u7ed3\u679c\u5355\uff1a[id:{}]", (Object)id);
        if (BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_SALES_ISSUE.getCode().equals(addReqDto.getBusinessType())) {
            this.csDeliveryNoticeOrderService.updateOrderStatus(reqDto.getPreNo(), CsDocumentActionEnum.SUCCESS_OUT.getCode());
            logger.info("\u8425\u9500\u4e91\u53d1\u8d27\u56de\u4f20,\u66f4\u65b0\u53d1\u8d27\u901a\u77e5\u5355\u3001\u51fa\u5e93\u901a\u77e5\u5355\u72b6\u6001\u5b8c\u6210\uff1a[preOrderNo:{}]", (Object)reqDto.getPreNo());
        } else if (BusinessTypeEnum.INVOKE_CUBE_ORDER_MATERIAL_ADJUST_OUT.getCode().equals(addReqDto.getBusinessType()) || BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_OTHER_OUT.getCode().equals(addReqDto.getBusinessType()) || BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_RETAILSALE_OUT.getCode().equals(addReqDto.getBusinessType()) || BusinessTypeEnum.INVOKE_CUBE_ORDER_SCRAP_OUT.getCode().equals(addReqDto.getBusinessType())) {
            this.directBatchUpdateInInventory(addReqDto);
            this.csInventoryPreemptionService.updateStatusDisableBySourceNo(reqDto.getPreNo());
            logger.info("\u8425\u9500\u4e91\u53d1\u8d27\u56de\u4f20,\u53d8\u66f4\u9884\u5360\u8bb0\u5f55\u72b6\u6001\u5b8c\u6210");
        } else {
            List<InventoryPreemptionEo> preemptionEoList = this.csInventoryPreemptionQueryService.queryCsInventoryPreemptionBySourceNo(reqDto.getPreNo(), CsValidFlagEnum.ENABLE.getCode());
            AssertUtil.isTrue(CollectionUtils.isNotEmpty(preemptionEoList), "\u5355\u636e\u65e0\u6709\u6548\u9884\u5360\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u540e\u64cd\u4f5c");
            CompletableFuture.runAsync(() -> {
                logger.info("\u5f02\u6b65\u64cd\u4f5c\u5f00\u59cb\uff1a\u8425\u9500\u4e91\u53d1\u8d27\u56de\u4f20\uff0c\u53d8\u52a8\u7269\u7406\u4ed3\u3001\u903b\u8f91\u4ed3\u5e93\u5b58\u3001\u603b\u5e93\u5b58\uff1a[{}]", (Object)JSON.toJSONString((Object)addReqDto));
                this.batchUpdateInInventory(addReqDto);
                logger.info("\u5f02\u6b65\u64cd\u4f5c\u7ed3\u675f\uff0c\u8425\u9500\u4e91\u53d1\u8d27\u56de\u4f20,\u51fa\u5e93\u5b8c\u6210");
                this.csInventoryPreemptionService.updateStatusDisableBySourceNo(reqDto.getPreNo());
                logger.info("\u8425\u9500\u4e91\u53d1\u8d27\u56de\u4f20,\u53d8\u66f4\u9884\u5360\u8bb0\u5f55\u72b6\u6001\u5b8c\u6210");
            });
        }
        return new RestResponse((Object)id.toString());
    }

    public RestResponse<Void> updateStringValidResult(List<CsOutResultOrderStringValidReqDto> stringValidReqDtoList) {
        return null;
    }

    public RestResponse<Void> repairData(String documentNo, List<CsOutResultOrderRepairDataDto> repairDataDtos) {
        return null;
    }

    public RestResponse<Void> updateSapNoById(Long id, String sapNo) {
        return null;
    }

    public RestResponse<CsOutResultSolutionToHangRespDto> solutionToHang(CsOutResultSolutionToHangReqDto csOutResultSolutionToHangReqDto) {
        return null;
    }

    public RestResponse<Void> outInResultOrderCallBackNoticeOrderSend(List<String> documentNos) {
        return null;
    }

    public RestResponse<Void> rollbackOutResultOrder(RollbackDeliveryOrderReqDto rollbackDeliveryOrderReqDto) {
        AssertUtil.isTrue(StringUtil.isNotBlank((String)rollbackDeliveryOrderReqDto.getPreOrderNo()) || StringUtil.isNotBlank((String)rollbackDeliveryOrderReqDto.getDocumentNo()) || StringUtil.isNotBlank((String)rollbackDeliveryOrderReqDto.getRelevanceNo()), "\u6807\u8bc6\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01");
        CsOutResultOrderAddReqDto csOutResultOrderAddReqDto = new CsOutResultOrderAddReqDto();
        csOutResultOrderAddReqDto.setPreOrderNo(rollbackDeliveryOrderReqDto.getPreOrderNo());
        csOutResultOrderAddReqDto.setDocumentNo(rollbackDeliveryOrderReqDto.getDocumentNo());
        csOutResultOrderAddReqDto.setRelevanceNo(rollbackDeliveryOrderReqDto.getRelevanceNo());
        CsOutResultOrderRespDto csOutResultOrderRespDto = this.csOutResultOrderQueryService.queryCsOutResultOrder(csOutResultOrderAddReqDto);
        logger.info("\u6839\u636e\u5165\u5e93\u7ed3\u679c\u5355\u53d8\u52a8\u7269\u7406\u4ed3\u3001\u903b\u8f91\u4ed3\u5e93\u5b58\u3001\u603b\u5e93\u5b58");
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = this.joinInInventoryParams(csOutResultOrderRespDto);
        this.csInventoryExposedService.operateInventory(csInventoryInOutBasicsDto);
        List collect = csInventoryInOutBasicsDto.getInOutBasicsCargoDtoList().stream().filter(c -> ObjectUtils.isNotEmpty((Object)c.getBatch())).map(e -> {
            e.setBatch(null);
            return e;
        }).collect(Collectors.toList());
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList(collect);
        this.csInventoryExposedService.operateInventory(csInventoryInOutBasicsDto);
        logger.info("\u6839\u636e\u5165\u5e93\u7ed3\u679c\u5355\u51fa\u5e93\u5b8c\u6210");
        return RestResponse.SUCCESS;
    }

    public RestResponse<Long> updateOutResultOrder(CsOutResultOrderAddReqDto updateReqDto) {
        return null;
    }

    public RestResponse<Void> unhook(String documentNo, String remark) {
        return null;
    }

    public RestResponse<Void> createConsignmentByOutResultOrderNo(String documentNo) {
        return null;
    }

    private CsInventoryInOutBasicsDto joinInInventoryParams(CsOutResultOrderRespDto addReqDto) {
        logger.info("\u8425\u9500\u4e91\u56de\u4f20==>\u51fa\u5e93\u903b\u8f91\u3001\u7269\u7406\u4ed3\u5e93\u5b58,addReqDto:{}", (Object)LogUtils.buildLogContent(addReqDto));
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.IN.getCode());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.NO.getValue());
        csInventoryInOutBasicsDto.setSourceNo(addReqDto.getPreOrderNo());
        csInventoryInOutBasicsDto.setSourceType(Objects.requireNonNull(CsInventorySourceTypeEnum.OUT_ROLLBACK_ADJUST.getCode()));
        csInventoryInOutBasicsDto.setCoverInventoryFlag(CsInventoryCoverInventoryFlagEnum.UPDATE.getCode());
        for (CsOutResultOrderDetailRespDto actDto : addReqDto.getDetailRespDtoList()) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setCargoCode(actDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
            inOutBasicsCargoDto.setBalance(actDto.getQuantity().abs());
            inOutBasicsCargoDto.setAvailable(actDto.getQuantity().abs());
            inOutBasicsCargoDto.setWarehouseCode(addReqDto.getWarehouseCode());
            inOutBasicsCargoDto.setWarehouseId(addReqDto.getWarehouseId());
            inOutBasicsCargoDto.setWarehouseName(addReqDto.getWarehouseName());
            inOutBasicsCargoDto.setWarehouseClassify(addReqDto.getWarehouseClassify());
            inOutBasicsCargoDto.setBatch(actDto.getBatch());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        return csInventoryInOutBasicsDto;
    }

    private CsOutResultOrderAddReqDto changeParam(TcbjResGenReqDto reqDto) {
        CsOutResultOrderAddReqDto addReqDto = new CsOutResultOrderAddReqDto();
        CubeBeanUtils.copyProperties((Object)addReqDto, (Object)reqDto, (String[])new String[0]);
        addReqDto.setRelevanceNo(reqDto.getNotiNo());
        addReqDto.setPreOrderNo(reqDto.getPreNo());
        addReqDto.setBusinessType(reqDto.getType() + "");
        addReqDto.setExternalOrderNo(reqDto.getNotiNo());
        ContactDto contactDto = new ContactDto();
        CubeBeanUtils.copyProperties((Object)contactDto, (Object)reqDto, (String[])new String[0]);
        ArrayList detailAddReqDtoList = Lists.newArrayList();
        BigDecimal totalQuantity = BigDecimal.valueOf(0L);
        for (TcbjResGenItemReqDto resGenItemReqDto : reqDto.getResGenItemReqDtos()) {
            CsOutResultOrderDetailAddReqDto detailAddReqDto = new CsOutResultOrderDetailAddReqDto();
            detailAddReqDto.setCargoCode(resGenItemReqDto.getCargoCode());
            detailAddReqDto.setQuantity(BigDecimal.valueOf(resGenItemReqDto.getNum().intValue()));
            detailAddReqDto.setBatch(resGenItemReqDto.getBatch());
            totalQuantity = totalQuantity.add(detailAddReqDto.getQuantity());
            if (StringUtils.isNotBlank((CharSequence)resGenItemReqDto.getOtherField1())) {
                try {
                    JSONObject json = JSON.parseObject((String)resGenItemReqDto.getOtherField1());
                    Long tradeOrderItemId = (Long)json.getObject("tradeOrderItemId", Long.class);
                    detailAddReqDto.setTradeOrderItemId(tradeOrderItemId);
                }
                catch (Exception ex) {
                    logger.info("\u53c2\u6570\u8f6c\u6362\u9519\u8bef\uff0c\u4e0d\u5904\u7406:{}", (Object)JSON.toJSONString((Object)ex));
                }
            }
            detailAddReqDtoList.add(detailAddReqDto);
        }
        addReqDto.setTotalQuantity(totalQuantity);
        addReqDto.setContactDto(contactDto);
        addReqDto.setDetailAddReqDtoList((List)detailAddReqDtoList);
        return addReqDto;
    }

    public void batchUpdateInInventory(CsOutResultOrderAddReqDto addReqDto) {
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.NO.getValue());
        csInventoryInOutBasicsDto.setSourceNo(addReqDto.getPreOrderNo());
        csInventoryInOutBasicsDto.setSourceType(Objects.requireNonNull(CsInventorySourceTypeEnum.getByValue((String)addReqDto.getBusinessType())).getCode());
        csInventoryInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        csInventoryInOutBasicsDto.setCoverInventoryFlag(CsInventoryCoverInventoryFlagEnum.UPDATE.getCode());
        for (CsOutResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setCargoCode(detailAddReqDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
            inOutBasicsCargoDto.setBalance(detailAddReqDto.getQuantity().abs().negate());
            inOutBasicsCargoDto.setPreempt(detailAddReqDto.getQuantity().abs().negate());
            inOutBasicsCargoDto.setWarehouseCode(addReqDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(detailAddReqDto.getBatch());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        this.csInventoryExposedService.operateInventory(csInventoryInOutBasicsDto);
        csInventoryInOutBasicsDto.getInOutBasicsCargoDtoList().forEach(e -> e.setBatch(null));
        this.csInventoryExposedService.operateInventory(csInventoryInOutBasicsDto);
    }

    public void directBatchUpdateInInventory(CsOutResultOrderAddReqDto addReqDto) {
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.YES.getValue());
        csInventoryInOutBasicsDto.setSourceNo(addReqDto.getPreOrderNo());
        csInventoryInOutBasicsDto.setSourceType(Objects.requireNonNull(CsInventorySourceTypeEnum.getByValue((String)addReqDto.getBusinessType())).getCode());
        csInventoryInOutBasicsDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        csInventoryInOutBasicsDto.setCoverInventoryFlag(CsInventoryCoverInventoryFlagEnum.UPDATE.getCode());
        for (CsOutResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setCargoCode(detailAddReqDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
            inOutBasicsCargoDto.setBalance(detailAddReqDto.getQuantity().abs().negate());
            inOutBasicsCargoDto.setWarehouseCode(addReqDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(detailAddReqDto.getBatch());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        this.csInventoryExposedService.operateInventory(csInventoryInOutBasicsDto);
        csInventoryInOutBasicsDto.getInOutBasicsCargoDtoList().forEach(e -> e.setBatch(null));
        this.csInventoryExposedService.operateInventory(csInventoryInOutBasicsDto);
    }
}

