/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq.impl;

import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.IMqCommonsService;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.MqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MqServiceImpl
implements MqService {
    private static final Logger log = LoggerFactory.getLogger(MqServiceImpl.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Value(value="${mq.inventory.topic.change:SINGLE_TOPIC}")
    private String mqInventoryChangeTopic;
    @Value(value="${mq.inventory.tag.change:INVENTORZY_CHANGE_TAG}")
    private String mqInventoryChangeTag;
    @Value(value="${mq.inventory.send.wms.delay:60}")
    private Long sendWmsDelay;
    @Resource
    private IMqCommonsService commonsService;

    @Override
    public MessageResponse sendToChangeOrderStatus(MessageVo messageVo) {
        log.info("mqService=>sendToChangeOrderStatus: {}", (Object)LogUtils.buildLogContent(messageVo));
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", "ORDER_STATUS_FINISH_TAG", (Object)messageVo);
        this.commonsService.saveMqSendLog("SINGLE_TOPIC", "ORDER_STATUS_FINISH_TAG", messageVo, messageResponse);
        return messageResponse;
    }

    @Override
    public MessageResponse noticeOrderDetail(MessageVo messageVo) {
        log.info("mqService=>noticeOrderDetail: {}", (Object)LogUtils.buildLogContent(messageVo));
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", "ORDER_STATUS_FINISH_TAG", (Object)messageVo);
        this.commonsService.saveMqSendLog("SINGLE_TOPIC", "ORDER_STATUS_FINISH_TAG", messageVo, messageResponse);
        return messageResponse;
    }

    @Override
    public MessageResponse sendInPurchaseToOrder(MessageVo messageVo) {
        log.info("mqService=>sendInPurchaseToOrder: {}", (Object)LogUtils.buildLogContent(messageVo));
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", "SUBTENANT_ORDER_CONFIRM_TAG", (Object)messageVo);
        this.commonsService.saveMqSendLog("SINGLE_TOPIC", "SUBTENANT_ORDER_CONFIRM_TAG", messageVo, messageResponse);
        return messageResponse;
    }

    @Override
    public MessageResponse stockOutAndInAddProcessor(MessageVo messageVo) {
        log.info("mqService=>stockOutAndInAddProcessor: {}", (Object)LogUtils.buildLogContent(messageVo));
        String topic = StringUtils.isNotBlank((CharSequence)"OP_EXTERNAL_TOPIC") ? "OP_EXTERNAL_TOPIC" : "SINGLE_TOPIC";
        MessageResponse messageResponse = this.commonsMqService.publishDelayMessage(topic, "WMS_OUT_DELIVERY_ADD", (Object)messageVo, this.sendWmsDelay);
        this.commonsService.saveMqSendLog(topic, "WMS_OUT_DELIVERY_ADD", messageVo, messageResponse);
        return messageResponse;
    }

    @Override
    public MessageResponse publicSendResultDetailProcessor(MessageVo messageVo) {
        log.info("mqService=>publicSendResultDetailProcessor: {}", (Object)LogUtils.buildLogContent(messageVo));
        MessageResponse messageResponse = this.commonsMqService.publishDelayMessage("INVENTORY_BUSINESS_TOPIC", "PUBLIC_SEND_RESULT_DETAIL", (Object)messageVo, Long.valueOf(10L));
        this.commonsService.saveMqSendLog("INVENTORY_BUSINESS_TOPIC", "PUBLIC_SEND_RESULT_DETAIL", messageVo, messageResponse);
        return messageResponse;
    }

    @Override
    public MessageResponse publicSendResultDetailDelayProcessor(MessageVo messageVo) {
        log.info("mqService=>publicSendResultDetailDelayProcessor: {}", (Object)LogUtils.buildLogContent(messageVo));
        MessageResponse messageResponse = this.commonsMqService.publishDelayMessage("INVENTORY_BUSINESS_TOPIC", "PUBLIC_SEND_RESULT_DETAIL", (Object)messageVo, Long.valueOf(15L));
        this.commonsService.saveMqSendLog("INVENTORY_BUSINESS_TOPIC", "PUBLIC_SEND_RESULT_DETAIL", messageVo, messageResponse);
        return messageResponse;
    }

    @Override
    public MessageResponse transferCompleteProcessor(MessageVo messageVo) {
        log.info("mqService=>transferCompleteProcessor: {}", (Object)LogUtils.buildLogContent(messageVo));
        MessageResponse messageResponse = this.commonsMqService.publishMessage("INVENTORY_BUSINESS_TOPIC", "TRANSFER_COMPLETE", (Object)messageVo);
        this.commonsService.saveMqSendLog("INVENTORY_BUSINESS_TOPIC", "TRANSFER_COMPLETE", messageVo, messageResponse);
        return messageResponse;
    }

    @Override
    public MessageResponse transferCompleteNeedCreateNextProcessor(MessageVo messageVo) {
        log.info("mqService=>transferCompleteNeedCreateNextProcessor: {}", (Object)LogUtils.buildLogContent(messageVo));
        MessageResponse messageResponse = this.commonsMqService.sendDelaySingleMessageAsync("INVENTORY_BUSINESS_TOPIC", "TRANSFER_COMPLETE_CREATE_NEXT", (Object)messageVo, Long.valueOf(5L));
        this.commonsService.saveMqSendLog("INVENTORY_BUSINESS_TOPIC", "TRANSFER_COMPLETE_CREATE_NEXT", messageVo, messageResponse);
        return messageResponse;
    }

    @Override
    public MessageResponse wmsCancelCompleteProcessor(MessageVo messageVo) {
        log.info("mqService=>wmsCancelCompleteProcessor: {}", (Object)LogUtils.buildLogContent(messageVo));
        MessageResponse messageResponse = this.commonsMqService.publishMessage("INVENTORY_BUSINESS_TOPIC", "WMS_CANCEL_COMPLETE", (Object)messageVo);
        this.commonsService.saveMqSendLog("INVENTORY_BUSINESS_TOPIC", "WMS_CANCEL_COMPLETE", messageVo, messageResponse);
        return messageResponse;
    }

    @Override
    public MessageResponse transferOutCompleteProcessor(MessageVo messageVo) {
        log.info("mqService=>transferOutCompleteProcessor,\u5ef6\u65f65s\u901a\u77e5: {}", (Object)LogUtils.buildLogContent(messageVo));
        MessageResponse messageResponse = this.commonsMqService.sendDelaySingleMessageAsync("INVENTORY_BUSINESS_TOPIC", "TRANSFER_OUT_COMPLETE", (Object)messageVo, Long.valueOf(5L));
        this.commonsService.saveMqSendLog("INVENTORY_BUSINESS_TOPIC", "TRANSFER_OUT_COMPLETE", messageVo, messageResponse);
        return messageResponse;
    }

    @Override
    public MessageResponse inTransitAdjustmentCompleteProcessor(MessageVo messageVo) {
        log.info("mqService=>adjustmentCompleteProcessor,\u5ef6\u65f65s\u901a\u77e5: {}", (Object)LogUtils.buildLogContent(messageVo));
        MessageResponse messageResponse = this.commonsMqService.sendDelaySingleMessageAsync("SINGLE_TOPIC", "IN_TRANSIT_ADJUSTMENT_COMPLETE", (Object)messageVo, Long.valueOf(5L));
        this.commonsService.saveMqSendLog("SINGLE_TOPIC", "IN_TRANSIT_ADJUSTMENT_COMPLETE", messageVo, messageResponse);
        return messageResponse;
    }

    @Override
    public MessageResponse stockInToE3Processor(MessageVo messageVo) {
        log.info("mqService=>stockInToE3Processor: {}", (Object)LogUtils.buildLogContent(messageVo));
        String topic = StringUtils.isNotBlank((CharSequence)"OP_EXTERNAL_TOPIC") ? "OP_EXTERNAL_TOPIC" : "SINGLE_TOPIC";
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage(topic, "IN_NOTICE_TO_E3", (Object)messageVo);
        this.commonsService.saveMqSendLog(topic, "IN_NOTICE_TO_E3", messageVo, messageResponse);
        return messageResponse;
    }

    @Override
    public MessageResponse returnOrderToWmsProcessor(MessageVo messageVo) {
        log.info("mqService=>returnOrderToWmsProcessor: {}", (Object)LogUtils.buildLogContent(messageVo));
        String topic = StringUtils.isNotBlank((CharSequence)"OP_EXTERNAL_TOPIC") ? "OP_EXTERNAL_TOPIC" : "SINGLE_TOPIC";
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage(topic, "RETURN_ORDER_CREATE", (Object)messageVo);
        this.commonsService.saveMqSendLog(topic, "RETURN_ORDER_CREATE", messageVo, messageResponse);
        return messageResponse;
    }

    @Override
    public MessageResponse sendInventoryChange(MessageVo messageVo) {
        log.info("mqService=>sendInventoryChange=> topic: {}, tag: {}, messageVo: {}", new Object[]{this.mqInventoryChangeTopic, this.mqInventoryChangeTag, LogUtils.buildLogContent(messageVo)});
        MessageResponse messageResponse = this.commonsMqService.publishMessage(this.mqInventoryChangeTopic, this.mqInventoryChangeTag, (Object)messageVo);
        this.commonsService.saveMqSendLog(this.mqInventoryChangeTopic, this.mqInventoryChangeTag, messageVo, messageResponse);
        return messageResponse;
    }
}

