/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsChannelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicSupplyWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsWarehouseAddressRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseStatusEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csLogicWarehouseQueryService")
public class CsLogicWarehouseQueryServiceImpl
implements ICsLogicWarehouseQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsLogicWarehouseQueryServiceImpl.class);
    @Autowired
    ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    IWarehouseAddressDomain warehouseAddressDomain;
    @Autowired
    CsCommonService csCommonService;

    @Override
    public CsLogicWarehouseRespDto selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.selectByPrimaryKey(id);
        CsLogicWarehouseRespDto warehouseRespDto = new CsLogicWarehouseRespDto();
        CubeBeanUtils.copyProperties((Object)warehouseRespDto, (Object)csLogicWarehouseEo, (String[])new String[0]);
        if (null != csLogicWarehouseEo || null != csLogicWarehouseEo.getId()) {
            WarehouseAddressEo csWarehouseAddressEo = new WarehouseAddressEo();
            csWarehouseAddressEo.setWarehouseId(id);
            csWarehouseAddressEo.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            List warehouseAddressEos = this.warehouseAddressDomain.selectList((BaseEo)csWarehouseAddressEo);
            if (CollectionUtils.isNotEmpty((Collection)warehouseAddressEos)) {
                CsWarehouseAddressRespDto warehouseAddressRespDto = new CsWarehouseAddressRespDto();
                CubeBeanUtils.copyProperties((Object)warehouseAddressRespDto, warehouseAddressEos.get(0), (String[])new String[0]);
                warehouseRespDto.setWarehouseAddress(warehouseAddressRespDto);
            }
        }
        return warehouseRespDto;
    }

    @Override
    public PageInfo<CsLogicWarehouseRespDto> queryByPage(CsLogicWarehouseQueryDto queryDto) {
        logger.info("\u67e5\u8be2\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        queryDto.setPageNum((Integer)ObjectUtils.defaultIfNull((Object)pageNum, (Object)1));
        queryDto.setPageSize((Integer)ObjectUtils.defaultIfNull((Object)pageSize, (Object)1000));
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        LogicWarehouseEo csLogicWarehouseEo = new LogicWarehouseEo();
        DtoHelper.dto2Eo((BaseVo)queryDto, (BaseEo)csLogicWarehouseEo);
        Long orgId = this.csCommonService.getUserOrganizationId();
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getOrganizationIds())) {
            csLogicWarehouseEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"organization_id", (Object)queryDto.getOrganizationIds())}));
        } else if (Objects.nonNull(queryDto.getOrganizationId()) || Objects.nonNull(orgId)) {
            csLogicWarehouseEo.setOrganizationId(Objects.nonNull(queryDto.getOrganizationId()) ? queryDto.getOrganizationId() : orgId);
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getType())) {
            csLogicWarehouseEo.setWarehouseType(queryDto.getType());
        }
        csLogicWarehouseEo.setOrderByDesc(queryDto.getOrderByDesc());
        PageInfo selectPage = this.logicWarehouseDomain.selectPage((BaseEo)csLogicWarehouseEo, pageNum, pageSize);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)selectPage.getList(), dtoList, CsLogicWarehouseRespDto.class);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            List warehouseIds = dtoList.stream().map(BaseRespDto::getId).collect(Collectors.toList());
            WarehouseAddressEo csWarehouseAddressEo = new WarehouseAddressEo();
            csWarehouseAddressEo.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            csWarehouseAddressEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"warehouse_id", warehouseIds)));
            List warehouseAddressEos = this.warehouseAddressDomain.selectList((BaseEo)csWarehouseAddressEo);
            if (CollectionUtils.isNotEmpty((Collection)warehouseAddressEos)) {
                Map<Long, WarehouseAddressEo> addressEoMap = warehouseAddressEos.stream().collect(Collectors.toMap(WarehouseAddressEo::getWarehouseId, entity -> entity));
                for (CsLogicWarehouseRespDto warehouseRespDto : dtoList) {
                    CsWarehouseAddressRespDto warehouseAddressRespDto = new CsWarehouseAddressRespDto();
                    WarehouseAddressEo addressEo = addressEoMap.get(warehouseRespDto.getId());
                    CubeBeanUtils.copyProperties((Object)warehouseAddressRespDto, (Object)addressEo, (String[])new String[0]);
                    warehouseRespDto.setWarehouseAddress(warehouseAddressRespDto);
                }
            }
            for (CsLogicWarehouseRespDto csLogicWarehouseRespDto : dtoList) {
                csLogicWarehouseRespDto.setCode(csLogicWarehouseRespDto.getWarehouseCode());
                csLogicWarehouseRespDto.setName(csLogicWarehouseRespDto.getWarehouseName());
                csLogicWarehouseRespDto.setType(csLogicWarehouseRespDto.getWarehouseType());
            }
        }
        pageInfo.setList(dtoList);
        logger.info("\u4ed3\u5e93\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
        return pageInfo;
    }

    @Override
    public List<CsLogicWarehouseRespDto> queryByParam(CsLogicWarehouseQueryDto queryDto) {
        logger.info("\u83b7\u53d6\u4ed3\u5e93-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        QueryWrapper wrapper = new QueryWrapper();
        Long orgId = this.csCommonService.getUserOrganizationId();
        if (Objects.nonNull(queryDto.getOrganizationId()) || Objects.nonNull(orgId)) {
            wrapper.eq((Object)"organization_id", (Object)(Objects.nonNull(queryDto.getOrganizationId()) ? queryDto.getOrganizationId() : orgId));
        }
        if (StringUtil.isNotBlank((String)queryDto.getOrganizationCode())) {
            wrapper.eq((Object)"organization_code", (Object)queryDto.getOrganizationCode());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseCode())) {
            wrapper.eq((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getWarehouseCodeList())) {
            wrapper.in((Object)"warehouse_code", (Collection)queryDto.getWarehouseCodeList());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseName())) {
            wrapper.eq((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseStatus())) {
            wrapper.eq((Object)"warehouse_status", (Object)queryDto.getWarehouseStatus());
        }
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.orderByDesc((Object)"create_time");
        List eoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)wrapper);
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            return list;
        }
        for (LogicWarehouseEo logicWarehouseEo : eoList) {
            CsLogicWarehouseRespDto respDto = new CsLogicWarehouseRespDto();
            BeanUtils.copyProperties((Object)logicWarehouseEo, (Object)respDto);
            respDto.setCargoEscheatageId(logicWarehouseEo.getCargoEscheatageId());
            list.add(respDto);
        }
        logger.info("\u83b7\u53d6\u4ed3\u5e93-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)list));
        return list;
    }

    @Override
    public PageInfo<CsLogicWarehouseRespDto> queryListByIds(List<Long> ids, CsChannelWarehouseQueryDto queryDto, List<Long> outIds) {
        QueryWrapper wrapper = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(ids)) {
            wrapper.in((Object)"id", ids);
        }
        if (CollectionUtils.isNotEmpty(outIds)) {
            wrapper.notIn((Object)"id", outIds);
        }
        wrapper.eq((Object)"warehouse_status", (Object)CsLogicWarehouseStatusEnum.ENABLE.getCode());
        if (StringUtils.isNotBlank((CharSequence)queryDto.getLogicWarehouseName())) {
            wrapper.like((Object)"warehouse_name", (Object)queryDto.getLogicWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getLogicWarehouseCode())) {
            wrapper.like((Object)"warehouse_code", (Object)queryDto.getLogicWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getLogicWarehouseStatus())) {
            wrapper.eq((Object)"warehouse_status", (Object)queryDto.getLogicWarehouseStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getCommonQuery())) {
            Consumer<QueryWrapper> consumer = qw -> {
                qw.like((Object)"warehouse_code", (Object)queryDto.getCommonQuery());
                qw.or();
                qw.like((Object)"warehouse_name", (Object)queryDto.getCommonQuery());
            };
            wrapper.and(consumer);
        }
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.orderByDesc((Object)"create_time");
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        List selectList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)wrapper);
        PageInfo selectPage = new PageInfo(selectList);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList csLogicWarehouseRespList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)selectList, (Collection)csLogicWarehouseRespList, CsLogicWarehouseRespDto.class);
        pageInfo.setList((List)csLogicWarehouseRespList);
        return pageInfo;
    }

    @Override
    public CsLogicWarehouseRespDto queryReturnWarehouseByOrganizationId(Long organizationId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"organization_id", (Object)organizationId);
        wrapper.eq((Object)"is_return_warehouse", (Object)YesNoEnum.YES.getValue());
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.orderByDesc((Object)"create_time");
        List selectList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)selectList)) {
            CsLogicWarehouseRespDto dto = new CsLogicWarehouseRespDto();
            CubeBeanUtils.copyProperties((Object)dto, selectList.get(0), (String[])new String[0]);
            return dto;
        }
        return null;
    }

    @Override
    public List<CsLogicWarehouseRespDto> queryList(List<String> warehouseCodes) {
        logger.info("\u903b\u8f91\u4ed3\u8be6\u60c5\u5217\u8868\u67e5\u8be2\uff1a{}", warehouseCodes);
        List<LogicWarehouseEo> logicWarehouseEos = this.queryByWarehouseCodes(warehouseCodes);
        return BeanUtil.copyToList(logicWarehouseEos, CsLogicWarehouseRespDto.class);
    }

    @Override
    public List<LogicWarehouseEo> queryByWarehouseCodes(List<String> warehouseCodes) {
        QueryWrapper wrapper = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(warehouseCodes)) {
            wrapper.in((Object)"warehouse_code", warehouseCodes);
        }
        List selectList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)wrapper);
        return selectList;
    }

    @Override
    public PageInfo<CsLogicSupplyWarehouseRespDto> querySupplyByPage(CsLogicWarehouseQueryDto queryDto) {
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        LogicWarehouseEo csLogicWarehouseEo = new LogicWarehouseEo();
        DtoHelper.dto2Eo((BaseVo)queryDto, (BaseEo)csLogicWarehouseEo);
        Long orgId = this.csCommonService.getUserOrganizationId();
        if (Objects.nonNull(queryDto.getOrganizationId()) || Objects.nonNull(orgId)) {
            csLogicWarehouseEo.setOrganizationId(Objects.nonNull(queryDto.getOrganizationId()) ? queryDto.getOrganizationId() : orgId);
        }
        csLogicWarehouseEo.setOrderByDesc(queryDto.getOrderByDesc());
        PageInfo selectPage = this.logicWarehouseDomain.selectPage((BaseEo)csLogicWarehouseEo, pageNum, pageSize);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)selectPage.getList(), dtoList, CsLogicSupplyWarehouseRespDto.class);
        pageInfo.setList(dtoList);
        logger.info("\u5206\u4ed3\u4ed3\u5e93\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
        return pageInfo;
    }

    @Override
    public CsLogicWarehouseRespDto queryByCodeAndFlag(String warehouseCode) {
        AssertUtil.isFalse(StringUtils.isEmpty((CharSequence)warehouseCode), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        wrapper.eq((Object)"interconnection_flag", (Object)1);
        List logicWarehouseEos = this.logicWarehouseDomain.getMapper().selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)logicWarehouseEos)) {
            CsLogicWarehouseRespDto dto = new CsLogicWarehouseRespDto();
            CubeBeanUtils.copyProperties((Object)dto, logicWarehouseEos.get(0), (String[])new String[0]);
            return dto;
        }
        return null;
    }
}

