/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter.bd;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsInSendBackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.adapter.WmsApiImpl;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.CsBasicsExternalStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.ICsBasicsExternalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.ICsPcpExternalQimenTestOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.in.CsInPlannedOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.in.CsInPlannedOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsWmsBasicsDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutNoticeOrderPushStatusPostbackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsPlannedCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsInSendBackDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsInSendBackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsWmsOutSendBackDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsWmsOutSendBackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsQimenOrderTestReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsExternalStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.CsOutNoticePushStatusEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleaseFutureInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service(value="bd_WmsApi")
public class BdWmsApiImpl
extends WmsApiImpl {
    private static final Logger log = LoggerFactory.getLogger(BdWmsApiImpl.class);
    private static Logger logger = LoggerFactory.getLogger(BdWmsApiImpl.class);
    private final String ALREADY_EXIST = "\u5df2\u5b58\u5728";
    @Autowired
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Autowired
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Autowired
    private IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Autowired
    private IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Autowired
    private CsInPlannedOrderDas inPlannedOrderDas;
    @Autowired
    private CsInPlannedOrderDetailDas csInPlannedOrderDetailDas;
    @Resource(name="csBdWmsExternalService")
    private ICsBasicsExternalService csBdWmsExternalService;
    @Resource
    private ICalcInventoryService calcInventoryService;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private ICsPcpExternalQimenTestOrderService csPcpExternalQimenTestOrderService;
    private final ExecutorService executorService = new ThreadPoolExecutor(2, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    public RestResponse<Void> appendLogistics(CsWmsOutSendBackReqDto csWmsInSendBackReqDto) {
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<String> inSendBack(CsWmsInSendBackReqDto csWmsInSendBackReqDto) {
        logger.info("inSendBack==>wms\u5165\u5e93\u56de\u4f20,csWmsInSendBackReqDto:{}", (Object)LogUtils.buildLogContent(csWmsInSendBackReqDto));
        AssertUtil.isTrue(null != csWmsInSendBackReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Date inTime = csWmsInSendBackReqDto.getInTime();
        if (null == inTime) {
            csWmsInSendBackReqDto.setInTime(new Date());
        }
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = new CsBasicsReceiveReqDto();
        csBasicsReceiveReqDto.setPlatformOrderNo(csWmsInSendBackReqDto.getPlatformOrderNo());
        csBasicsReceiveReqDto.setInOutNoticeOrderNo(csWmsInSendBackReqDto.getInNoticeOrderNo());
        csBasicsReceiveReqDto.setInOutTime(csWmsInSendBackReqDto.getInTime());
        csBasicsReceiveReqDto.setWmsOrderNo(csWmsInSendBackReqDto.getWmsOrderNo());
        ArrayList detailReqDtoList = Lists.newArrayList();
        List inDetailList = csWmsInSendBackReqDto.getDetailReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)inDetailList), "\u5546\u54c1\u660e\u7ec6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsWmsInSendBackDetailReqDto csWmsInSendBackDetailReqDto : inDetailList) {
            CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto = new CsWmsBasicsDetailReqDto();
            csWmsBasicsDetailReqDto.setBatch(csWmsInSendBackDetailReqDto.getBatch());
            csWmsBasicsDetailReqDto.setQuantity(csWmsInSendBackDetailReqDto.getQuantity());
            csWmsBasicsDetailReqDto.setSkuCode(csWmsInSendBackDetailReqDto.getSkuCode());
            csWmsBasicsDetailReqDto.setWarehouseCode(csWmsInSendBackDetailReqDto.getWarehouseCode());
            csWmsBasicsDetailReqDto.setProduceTime(csWmsInSendBackDetailReqDto.getProduceTime());
            csWmsBasicsDetailReqDto.setTradeOrderItemId(csWmsInSendBackDetailReqDto.getTradeOrderItemId());
            detailReqDtoList.add(csWmsBasicsDetailReqDto);
        }
        csBasicsReceiveReqDto.setDetailReqDtoList((List)detailReqDtoList);
        csBasicsReceiveReqDto.setTotalVolume(csWmsInSendBackReqDto.getTotalVolume());
        csBasicsReceiveReqDto.setTotalWeight(csWmsInSendBackReqDto.getTotalWeight());
        this.csBdWmsExternalService.receiveIn(csBasicsReceiveReqDto);
        return RestResponse.SUCCEED;
    }

    public RestResponse<String> outSendBack(CsWmsOutSendBackReqDto csWmsOutSendBackReqDto) {
        logger.info("outSendBack==>wms\u51fa\u5e93\u56de\u4f20,csWmsOutSendBackReqDto:{}", (Object)LogUtils.buildLogContent(csWmsOutSendBackReqDto));
        AssertUtil.isTrue(null != csWmsOutSendBackReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Date outTime = csWmsOutSendBackReqDto.getOutTime();
        if (null == outTime) {
            csWmsOutSendBackReqDto.setOutTime(new Date());
        }
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = new CsBasicsReceiveReqDto();
        csBasicsReceiveReqDto.setPlatformOrderNo(csWmsOutSendBackReqDto.getPlatformOrderNo());
        csBasicsReceiveReqDto.setInOutNoticeOrderNo(csWmsOutSendBackReqDto.getOutNoticeOrderNo());
        csBasicsReceiveReqDto.setInOutTime(csWmsOutSendBackReqDto.getOutTime());
        csBasicsReceiveReqDto.setWmsOrderNo(csWmsOutSendBackReqDto.getWmsOrderNo());
        csBasicsReceiveReqDto.setEstimatedTime(csWmsOutSendBackReqDto.getEstimatedTime());
        csBasicsReceiveReqDto.setMergeQuantity(csWmsOutSendBackReqDto.getMergeQuantity());
        csBasicsReceiveReqDto.setTotalCartons(csWmsOutSendBackReqDto.getTotalCartons());
        csBasicsReceiveReqDto.setShippingInfoReqDtoList(csWmsOutSendBackReqDto.getShippingInfoReqDtoList());
        List outDetailList = csWmsOutSendBackReqDto.getDetailReqDtoList();
        List packingMaterialsOutDetailList = csWmsOutSendBackReqDto.getPackageMaterialDetailReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)outDetailList) || CollectionUtils.isNotEmpty((Collection)packingMaterialsOutDetailList), "\u5546\u54c1\u660e\u7ec6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List<CsWmsBasicsDetailReqDto> detailReqDtoList = this.detailReqDtoListInfo(outDetailList);
        csBasicsReceiveReqDto.setDetailReqDtoList(detailReqDtoList);
        List<CsWmsBasicsDetailReqDto> packingMaterialsDetailReqDtoList = this.detailReqDtoListInfo(packingMaterialsOutDetailList);
        csBasicsReceiveReqDto.setPackageMaterialDetailReqDtoList(packingMaterialsDetailReqDtoList);
        csBasicsReceiveReqDto.setWarehouseCode(csWmsOutSendBackReqDto.getWarehouseCode());
        csBasicsReceiveReqDto.setTotalVolume(csWmsOutSendBackReqDto.getTotalVolume());
        csBasicsReceiveReqDto.setTotalWeight(csWmsOutSendBackReqDto.getTotalWeight());
        this.csBdWmsExternalService.receiveOut(csBasicsReceiveReqDto);
        return RestResponse.SUCCEED;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<String> cancel(final CsWmsCancelReqDto csWmsCancelReqDto) {
        logger.info("cancel==>wms\u53d6\u6d88\u5355\u636e,csWmsCancelReqDto:{}", (Object)LogUtils.buildLogContent(csWmsCancelReqDto));
        this.checkParams(csWmsCancelReqDto);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"document_no", (Object)csWmsCancelReqDto.getNoticeOrderNo());
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        final InOutNoticeOrderEo csInNoticeOrderEo = (InOutNoticeOrderEo)this.inOutNoticeOrderDomain.getMapper().selectOne((Wrapper)queryWrapper);
        AssertUtil.isTrue(null != csInNoticeOrderEo, "\u67e5\u8be2\u4e0d\u5230\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        AssertUtil.isTrue(!BaseOrderStatusEnum.INO_CANCEL.getCode().equals(csInNoticeOrderEo.getOrderStatus()) && !BaseOrderStatusEnum.ONO_CANCEL.getCode().equals(csInNoticeOrderEo.getOrderStatus()), "\u5df2\u53d6\u6d88\u5355\u636e\u65e0\u6cd5\u518d\u6b21\u53d6\u6d88");
        QueryWrapper csReceiveResultOrderEoQueryWrapper = new QueryWrapper();
        csReceiveResultOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)csInNoticeOrderEo.getRelevanceNo());
        csReceiveResultOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List csReceiveResultOrderEoList = this.receiveDeliveryResultOrderDomain.getMapper().selectList((Wrapper)csReceiveResultOrderEoQueryWrapper);
        String orderType = null;
        orderType = CollectionUtils.isNotEmpty((Collection)csReceiveResultOrderEoList) ? this.endOrderInfo(csWmsCancelReqDto, csInNoticeOrderEo) : this.cancelOrderInfo(csWmsCancelReqDto, csInNoticeOrderEo);
        final String finalOrderType = orderType;
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                logger.info("\u5f00\u59cb\u66f4\u65b0\u5e93\u5b58:{}", (Object)LogUtils.buildLogContent(csInNoticeOrderEo));
                BdWmsApiImpl.this.cancelInventoryInfo(csWmsCancelReqDto, csInNoticeOrderEo, finalOrderType);
            }
        });
        return RestResponse.SUCCEED;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<String> cancelRetreat(CsWmsCancelReqDto csWmsCancelReqDto) {
        this.csWmsService.cancelRetreat(csWmsCancelReqDto);
        return RestResponse.SUCCEED;
    }

    public RestResponse<String> plannedOrderExposedCancel(CsPlannedCancelReqDto plannedCancelReqDto) {
        logger.info("\u5317\u9f0e\u65e0\u6b64\u4e1a\u52a1");
        return null;
    }

    public RestResponse<String> retreatExposedCancel(CsPlannedCancelReqDto plannedCancelReqDto) {
        logger.info("\u5317\u9f0e\u65e0\u6b64\u4e1a\u52a1");
        return null;
    }

    public RestResponse<Boolean> pushStatusPostback(CsOutNoticeOrderPushStatusPostbackReqDto outNoticeOrderPushStatusPostbackReqDto) {
        logger.info("pushStatusPostback==>\u8fde\u63a5\u5668\u56de\u5199\u5355\u636e\u63a8\u9001WMS\u7684\u72b6\u6001,outNoticeOrderPushStatusPostbackReqDto:{}", (Object)LogUtils.buildLogContent(outNoticeOrderPushStatusPostbackReqDto));
        String documentNo = outNoticeOrderPushStatusPostbackReqDto.getDocumentNo();
        QueryWrapper InOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        InOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        List InOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)InOutNoticeOrderEoQueryWrapper);
        logger.info("pushStatusPostback==>\u8fde\u63a5\u5668\u56de\u5199\u5355\u636e\u63a8\u9001WMS\u7684\u72b6\u6001,InOutNoticeOrderEoList:{}", (Object)LogUtils.buildLogContent(InOutNoticeOrderEoList));
        if (CollectionUtils.isEmpty((Collection)InOutNoticeOrderEoList)) {
            return new RestResponse((Object)Boolean.TRUE);
        }
        InOutNoticeOrderEo InOutNoticeOrderEo2 = (InOutNoticeOrderEo)InOutNoticeOrderEoList.get(0);
        String pushStatus = InOutNoticeOrderEo2.getPushStatus();
        if (!CsOutNoticePushStatusEnum.WAITING.getCode().equals(pushStatus) && !CsOutNoticePushStatusEnum.PUSHING.getCode().equals(pushStatus)) {
            return new RestResponse((Object)Boolean.TRUE);
        }
        String postbackInfo = outNoticeOrderPushStatusPostbackReqDto.getPostbackInfo();
        if (StringUtils.isNotBlank((CharSequence)postbackInfo) && postbackInfo.contains("\u5df2\u5b58\u5728")) {
            logger.info("pushStatusPostback==>\u8fde\u63a5\u5668\u56de\u5199\u5355\u636e\u63a8\u9001WMS\u7684\u72b6\u6001,\u5355\u636e\u5df2\u5b58\u5728,\u4e0d\u9700\u8981\u6539\u72b6\u6001:{}", (Object)postbackInfo);
            if (CsOutNoticePushStatusEnum.PUSHING.getCode().equals(pushStatus)) {
                InOutNoticeOrderEoQueryWrapper.clear();
                InOutNoticeOrderEo2.setPushStatus(CsOutNoticePushStatusEnum.SUCCESS.getCode());
                InOutNoticeOrderEo2.setPushMsg(CsOutNoticePushStatusEnum.SUCCESS.getDesc());
                InOutNoticeOrderEoQueryWrapper.eq((Object)"id", (Object)InOutNoticeOrderEo2.getId());
                this.inOutNoticeOrderDomain.getMapper().update((Object)InOutNoticeOrderEo2, (Wrapper)InOutNoticeOrderEoQueryWrapper);
            }
            return new RestResponse((Object)Boolean.TRUE);
        }
        InOutNoticeOrderEoQueryWrapper.clear();
        InOutNoticeOrderEo2.setPushStatus(outNoticeOrderPushStatusPostbackReqDto.getPushStatus());
        InOutNoticeOrderEo2.setPushMsg(outNoticeOrderPushStatusPostbackReqDto.getPostbackInfo());
        InOutNoticeOrderEoQueryWrapper.eq((Object)"id", (Object)InOutNoticeOrderEo2.getId());
        this.inOutNoticeOrderDomain.getMapper().update((Object)InOutNoticeOrderEo2, (Wrapper)InOutNoticeOrderEoQueryWrapper);
        return new RestResponse((Object)Boolean.TRUE);
    }

    public RestResponse<Void> heavyPushWms(List<String> documentNos) {
        logger.info("\u91cd\u63a8\u51fa\u5165\u5e93\u901a\u77e5\u5355\u521b\u5efa\u5230wms\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString(documentNos));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(documentNos), "\u53c2\u6570\u6709\u8bef");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"document_no", documentNos);
        queryWrapper.eq((Object)"dr", (Object)0);
        List eoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)queryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)eoList), "\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u901a\u77e5\u5355\u4fe1\u606f");
        ArrayList abnormalDocumentNos = new ArrayList(documentNos.size());
        ArrayList invalidStatusDocumentNos = new ArrayList(documentNos.size());
        ArrayList ids = new ArrayList(documentNos.size());
        eoList.stream().forEach(e -> {
            if (!CsOutNoticePushStatusEnum.FAIL.getCode().equals(e.getPushStatus())) {
                abnormalDocumentNos.add(e.getDocumentNo());
            }
            if (!BaseOrderStatusEnum.ONO_WAIT_OUT.getCode().equals(e.getOrderStatus()) && !BaseOrderStatusEnum.INO_WAIT_IN.getCode().equals(e.getOrderStatus())) {
                invalidStatusDocumentNos.add(e.getDocumentNo());
            }
            ids.add(e.getId());
        });
        AssertUtil.isTrue(CollectionUtils.isEmpty(abnormalDocumentNos), String.format("\u5355\u53f7\uff1a%s \u975e\u63a8\u9001\u5931\u8d25\u72b6\u6001\u4e0d\u80fd\u91cd\u63a8\u5230wms", JSON.toJSONString(abnormalDocumentNos)));
        AssertUtil.isTrue(CollectionUtils.isEmpty(invalidStatusDocumentNos), String.format("\u5355\u53f7\uff1a%s \u975e\u5f85\u51fa/\u5165\u5e93\u72b6\u6001\u4e0d\u80fd\u91cd\u63a8\u5230wms", JSON.toJSONString(invalidStatusDocumentNos)));
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.in((Object)"id", ids);
        updateWrapper.eq((Object)"dr", (Object)0);
        InOutNoticeOrderEo noticeOrderEo = new InOutNoticeOrderEo();
        noticeOrderEo.setPushStatus(CsOutNoticePushStatusEnum.PUSHING.getCode());
        this.inOutNoticeOrderDomain.getMapper().update((Object)noticeOrderEo, (Wrapper)updateWrapper);
        logger.info("\u5df2\u66f4\u65b0\u63a8\u9001\u72b6\u6001\u4e3a\u63a8\u9001\u4e2d");
        for (String documentNo : documentNos) {
            CsQimenOrderTestReqDto csQimenOrderTestReqDto = new CsQimenOrderTestReqDto();
            csQimenOrderTestReqDto.setDocumentNo(documentNo);
            logger.info("\u591a\u7ebf\u7a0b\u91cd\u63a8\u901a\u77e5\u5355\u53d1\u9001mq\u5230\u8fde\u63a5\u5668\u901a\u77e5\u5355\u5355\u53f7\uff1a{}", (Object)documentNo);
            FutureTask<Boolean> futureTask = new FutureTask<Boolean>(() -> this.csPcpExternalQimenTestOrderService.sendOrderInfoToQimen(csQimenOrderTestReqDto));
            this.executorService.execute(futureTask);
        }
        logger.info("\u591a\u7ebf\u7a0b\u91cd\u63a8\u901a\u77e5\u5355\u53d1\u9001mq\u5b8c\u6210");
        return RestResponse.VOID;
    }

    public RestResponse<String> cancelInstruct(CsWmsCancelReqDto csWmsCancelReqDto) {
        logger.info("cancelInstruct==>WMS\u53d1\u8d77\u7684\u53d6\u6d88,csWmsCancelReqDto:{}", (Object)LogUtils.buildLogContent(csWmsCancelReqDto));
        this.checkParams(csWmsCancelReqDto);
        CsBasicsCancelReqDto basicsCancelReqDto = new CsBasicsCancelReqDto();
        basicsCancelReqDto.setNoticeOrderNo(csWmsCancelReqDto.getNoticeOrderNo());
        basicsCancelReqDto.setPlatformOrderNo(csWmsCancelReqDto.getPlatformOrderNo());
        this.csBdWmsExternalService.cancel(basicsCancelReqDto);
        return RestResponse.SUCCEED;
    }

    private void checkParams(CsWmsCancelReqDto csWmsCancelReqDto) {
        AssertUtil.isTrue(null != csWmsCancelReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String inNoticeOrderNo = csWmsCancelReqDto.getNoticeOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inNoticeOrderNo), "\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancelInventoryInfo(CsWmsCancelReqDto csWmsCancelReqDto, InOutNoticeOrderEo csInNoticeOrderEo, String orderType) {
        QueryWrapper csInNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        csInNoticeOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)csInNoticeOrderEo.getDocumentNo());
        csInNoticeOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List csInNoticeOrderDetailEoList = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)csInNoticeOrderDetailEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csInNoticeOrderDetailEoList), "\u67e5\u8be2\u4e0d\u5230\u5546\u54c1\u660e\u7ec6\u4fe1\u606f");
        QueryWrapper csReceiveNoticeOrderEoQueryWrapper = new QueryWrapper();
        csReceiveNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)csInNoticeOrderEo.getPreOrderNo());
        csReceiveNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        ReceiveDeliveryNoticeOrderEo csReceiveNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)this.receiveDeliveryNoticeOrderDomain.getMapper().selectOne((Wrapper)csReceiveNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(null != csReceiveNoticeOrderEo, "\u67e5\u8be2\u4e0d\u5230\u6536\u8d27\u901a\u77e5\u5355\u4fe1\u606f");
        ReleaseFutureInDto releaseFutureInParam = new ReleaseFutureInDto();
        releaseFutureInParam.setSourceNo(csInNoticeOrderEo.getRelevanceNo());
        releaseFutureInParam.setSourceType(csInNoticeOrderEo.getBusinessType());
        releaseFutureInParam.setBusinessType(csInNoticeOrderEo.getBusinessType());
        releaseFutureInParam.setExternalOrderNo(csInNoticeOrderEo.getExternalOrderNo());
        ArrayList detailParams = Lists.newArrayList();
        for (InOutNoticeOrderDetailEo csInNoticeOrderDetailEo : csInNoticeOrderDetailEoList) {
            CalcDetailDto detailParam = new CalcDetailDto();
            BigDecimal futureInNum = BigDecimalUtils.abs((BigDecimal)csInNoticeOrderDetailEo.getCancelQuantity());
            detailParam.setNum(futureInNum);
            detailParam.setSkuCode(csInNoticeOrderDetailEo.getSkuCode());
            String warehouseCode = csReceiveNoticeOrderEo.getReceiveLogicWarehouseCode();
            detailParam.setLogicWarehouseCode(warehouseCode);
            detailParam.setBatch(csInNoticeOrderDetailEo.getBatch());
            detailParams.add(detailParam);
            releaseFutureInParam.setNoneBatch(Boolean.valueOf(StringUtils.isEmpty((CharSequence)csInNoticeOrderDetailEo.getBatch())));
        }
        releaseFutureInParam.setDetails((List)detailParams);
        this.calcInventoryService.releaseFutureIn(releaseFutureInParam);
        if (CsPlannedOrderTypeEnum.PRODUCTION.getCode().equals(orderType)) {
            releaseFutureInParam.getDetails().forEach(e -> e.setBatch(null));
            this.calcInventoryService.releaseFutureIn(releaseFutureInParam);
        }
    }

    @Override
    public RestResponse<Void> packageMaterialOutResultToSap(List<String> packageMaterialOutResultDocumentNos) {
        logger.info("\u63a8\u9001\u5305\u6750\u51fa\u5e93\u7ed3\u679c\u5355\u5230sap\uff08\u540e\u95e8\u63a5\u53e3\uff09\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(packageMaterialOutResultDocumentNos));
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        for (String documentNo : packageMaterialOutResultDocumentNos) {
            List outResultOrderEos = this.inOutResultOrderDomain.queryByDocumentNo(documentNo);
            logger.info("\u6839\u636e\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u53f7\uff1a{}\u67e5\u8be2\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u4fe1\u606f:{}", (Object)documentNo, (Object)JSON.toJSONString((Object)outResultOrderEos));
            if (CollectionUtils.isEmpty((Collection)outResultOrderEos)) continue;
            InOutResultOrderEo outResultOrderEo = (InOutResultOrderEo)outResultOrderEos.get(0);
            List detailEos = this.inOutResultOrderDetailDomain.queryByDocumentNo(documentNo);
            logger.info("\u6839\u636e\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u53f7\uff1a{}\u67e5\u8be2\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u660e\u7ec6\u4fe1\u606f:{}", (Object)documentNo, (Object)JSON.toJSONString((Object)detailEos));
            if (CollectionUtils.isEmpty((Collection)detailEos)) continue;
            CsInOutResultRespDto csInOutResultRespDto = new CsInOutResultRespDto();
            CubeBeanUtils.copyProperties((Object)csInOutResultRespDto, (Object)outResultOrderEo, (String[])new String[0]);
            ArrayList inOutResultDetailRespDtoList = new ArrayList();
            CubeBeanUtils.copyCollection(inOutResultDetailRespDtoList, (Collection)detailEos, CsInOutResultDetailRespDto.class);
            csInOutResultRespDto.setInOutResultDetailRespDtoList(inOutResultDetailRespDtoList);
            CsOrderBusinessCallBackContext callBackContext = new CsOrderBusinessCallBackContext();
            callBackContext.setCsInOutResultRespDto(csInOutResultRespDto);
            callBackContext.setOutResultOrderId(outResultOrderEo.getId());
            callBackContext.setInFlag(Boolean.valueOf("in".equals(outResultOrderEo.getOrderType())));
            this.csBdWmsExternalService.pushPackageMaterialDeliveryResultOrderMsg(callBackContext);
        }
        return RestResponse.VOID;
    }

    public RestResponse<String> noticeTransferConsignment(WmsInSendBackReqDto wmsInSendBackReqDto) {
        return null;
    }

    public RestResponse<String> confirmTransferConsignment(WmsInSendBackReqDto wmsInSendBackReqDto) {
        return null;
    }

    private String cancelOrderInfo(CsWmsCancelReqDto csWmsCancelReqDto, InOutNoticeOrderEo csInNoticeOrderEo) {
        ReceiveDeliveryNoticeOrderEo csReceiveNoticeOrderEo;
        logger.info("cancelOrderInfo==>\u53d6\u6d88\u5355\u636e\u64cd\u4f5c,csWmsCancelReqDto:{},csInNoticeOrderEo:{}", (Object)LogUtils.buildLogContent(csWmsCancelReqDto), (Object)LogUtils.buildLogContent(csInNoticeOrderEo));
        String plannedOrderNo = csInNoticeOrderEo.getRelevanceNo();
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)((ExtQueryChainWrapper)this.inPlannedOrderDas.filter().eq((Object)"order_no", (Object)plannedOrderNo)).one();
        AssertUtil.isTrue(null != csInPlannedOrderEo, "\u67e5\u8be2\u4e0d\u5230\u8ba1\u5212\u5355\u636e\u4fe1\u606f");
        String orderType = csInPlannedOrderEo.getOrderType();
        AssertUtil.isTrue(CsPlannedOrderTypeEnum.PURCHASE.getCode().equals(orderType) || CsPlannedOrderTypeEnum.OUTSOURCE.getCode().equals(orderType) || CsPlannedOrderTypeEnum.PRODUCTION.getCode().equals(orderType), "\u975e\u91c7\u8d2d/\u59d4\u5916\u7c7b\u578b\u5355\u636e\u4e0d\u5141\u8bb8WMS\u53d1\u8d77\u53d6\u6d88");
        csInPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.CANCEL.getCode());
        this.inPlannedOrderDas.updateSelective((BaseEo)csInPlannedOrderEo);
        List csInPlannedOrderDetailEoList = ((ExtQueryChainWrapper)this.csInPlannedOrderDetailDas.filter().eq((Object)"order_no", (Object)plannedOrderNo)).list();
        if (CollectionUtils.isNotEmpty((Collection)csInPlannedOrderDetailEoList)) {
            csInPlannedOrderDetailEoList.forEach(detailEo -> {
                detailEo.setWaitQuantity(BigDecimal.ZERO);
                detailEo.setCancelQuantity(detailEo.getPlanQuantity().subtract(detailEo.getDoneQuantity()));
                this.csInPlannedOrderDetailDas.updateSelective((BaseEo)detailEo);
            });
        }
        csInNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.INO_CANCEL.getCode());
        this.inOutNoticeOrderDomain.updateSelective((BaseEo)csInNoticeOrderEo);
        List csOutNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"relevance_no", (Object)plannedOrderNo)).list();
        if (CollectionUtils.isNotEmpty((Collection)csOutNoticeOrderDetailEoList)) {
            csOutNoticeOrderDetailEoList.forEach(detailEo -> {
                detailEo.setWaitQuantity(BigDecimal.ZERO);
                detailEo.setCancelQuantity(detailEo.getPlanQuantity().subtract(detailEo.getDoneQuantity()));
                this.inOutNoticeOrderDetailDomain.updateSelective((BaseEo)detailEo);
            });
        }
        AssertUtil.isTrue(null != (csReceiveNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"document_no", (Object)csInNoticeOrderEo.getPreOrderNo())).one()), "\u67e5\u8be2\u4e0d\u5230\u6536\u8d27\u901a\u77e5\u5355\u4fe1\u606f");
        csReceiveNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.RNO_CANCEL.getCode());
        this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)csReceiveNoticeOrderEo);
        List csDeliveryNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)csInNoticeOrderEo.getPreOrderNo())).list();
        if (CollectionUtils.isNotEmpty((Collection)csDeliveryNoticeOrderDetailEoList)) {
            csDeliveryNoticeOrderDetailEoList.forEach(detailEo -> {
                detailEo.setWaitQuantity(BigDecimal.ZERO);
                detailEo.setCancelQuantity(detailEo.getPlanQuantity().subtract(detailEo.getDoneQuantity()));
                this.receiveDeliveryNoticeOrderDetailDomain.updateSelective((BaseEo)detailEo);
            });
        }
        return orderType;
    }

    private String endOrderInfo(CsWmsCancelReqDto csWmsCancelReqDto, InOutNoticeOrderEo csInNoticeOrderEo) {
        ReceiveDeliveryNoticeOrderEo csReceiveNoticeOrderEo;
        logger.info("endOrderInfo==>\u5355\u636e\u64cd\u4f5c,csWmsCancelReqDto:{},csInNoticeOrderEo:{}", (Object)LogUtils.buildLogContent(csWmsCancelReqDto), (Object)LogUtils.buildLogContent(csInNoticeOrderEo));
        String plannedOrderNo = csInNoticeOrderEo.getRelevanceNo();
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)((ExtQueryChainWrapper)this.inPlannedOrderDas.filter().eq((Object)"order_no", (Object)plannedOrderNo)).one();
        AssertUtil.isTrue(null != csInPlannedOrderEo, "\u67e5\u8be2\u4e0d\u5230\u8ba1\u5212\u5355\u636e\u4fe1\u606f");
        String orderType = csInPlannedOrderEo.getOrderType();
        AssertUtil.isTrue(CsPlannedOrderTypeEnum.PURCHASE.getCode().equals(orderType) || CsPlannedOrderTypeEnum.OUTSOURCE.getCode().equals(orderType) || CsPlannedOrderTypeEnum.PRODUCTION.getCode().equals(orderType), "\u975e\u91c7\u8d2d/\u59d4\u5916\u7c7b\u578b\u5355\u636e\u4e0d\u5141\u8bb8WMS\u53d1\u8d77\u53d6\u6d88");
        csInPlannedOrderEo.setOrderStatus(CsPlannedOrderStatusEnum.FINISH.getCode());
        this.inPlannedOrderDas.updateSelective((BaseEo)csInPlannedOrderEo);
        List csInPlannedOrderDetailEoList = ((ExtQueryChainWrapper)this.csInPlannedOrderDetailDas.filter().eq((Object)"order_no", (Object)plannedOrderNo)).list();
        if (CollectionUtils.isNotEmpty((Collection)csInPlannedOrderDetailEoList)) {
            csInPlannedOrderDetailEoList.forEach(detailEo -> {
                detailEo.setWaitQuantity(BigDecimal.ZERO);
                detailEo.setCancelQuantity(detailEo.getPlanQuantity().subtract(detailEo.getDoneQuantity()));
                this.csInPlannedOrderDetailDas.updateSelective((BaseEo)detailEo);
            });
        }
        csInNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.INO_CANCEL.getCode());
        this.inOutNoticeOrderDomain.updateSelective((BaseEo)csInNoticeOrderEo);
        List csOutNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"relevance_no", (Object)plannedOrderNo)).list();
        if (CollectionUtils.isNotEmpty((Collection)csOutNoticeOrderDetailEoList)) {
            csOutNoticeOrderDetailEoList.forEach(detailEo -> {
                detailEo.setWaitQuantity(BigDecimal.ZERO);
                detailEo.setCancelQuantity(detailEo.getPlanQuantity().subtract(detailEo.getDoneQuantity()));
                this.inOutNoticeOrderDetailDomain.updateSelective((BaseEo)detailEo);
            });
        }
        AssertUtil.isTrue(null != (csReceiveNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"document_no", (Object)csInNoticeOrderEo.getPreOrderNo())).one()), "\u67e5\u8be2\u4e0d\u5230\u6536\u8d27\u901a\u77e5\u5355\u4fe1\u606f");
        csReceiveNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.RNO_CANCEL.getCode());
        this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)csReceiveNoticeOrderEo);
        List csDeliveryNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)csInNoticeOrderEo.getPreOrderNo())).list();
        if (CollectionUtils.isNotEmpty((Collection)csDeliveryNoticeOrderDetailEoList)) {
            csDeliveryNoticeOrderDetailEoList.forEach(detailEo -> {
                detailEo.setWaitQuantity(BigDecimal.ZERO);
                detailEo.setCancelQuantity(detailEo.getPlanQuantity().subtract(detailEo.getDoneQuantity()));
                this.receiveDeliveryNoticeOrderDetailDomain.updateSelective((BaseEo)detailEo);
            });
        }
        return orderType;
    }

    private List<CsWmsBasicsDetailReqDto> detailReqDtoListInfo(List<CsWmsOutSendBackDetailReqDto> outDetailList) {
        ArrayList detailReqDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(outDetailList)) {
            return detailReqDtoList;
        }
        for (CsWmsOutSendBackDetailReqDto csWmsOutSendBackDetailReqDto : outDetailList) {
            CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto = new CsWmsBasicsDetailReqDto();
            csWmsBasicsDetailReqDto.setBatch(csWmsOutSendBackDetailReqDto.getBatch());
            csWmsBasicsDetailReqDto.setQuantity(csWmsOutSendBackDetailReqDto.getQuantity());
            csWmsBasicsDetailReqDto.setSkuCode(csWmsOutSendBackDetailReqDto.getSkuCode());
            csWmsBasicsDetailReqDto.setWarehouseCode(csWmsOutSendBackDetailReqDto.getWarehouseCode());
            csWmsBasicsDetailReqDto.setSnCodes(csWmsOutSendBackDetailReqDto.getSnCodes());
            csWmsBasicsDetailReqDto.setTradeOrderItemId(csWmsOutSendBackDetailReqDto.getTradeOrderItemId());
            detailReqDtoList.add(csWmsBasicsDetailReqDto);
        }
        return detailReqDtoList;
    }
}

