/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.ICsInventoryWarningQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.other.CsInventoryWarningDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsInventoryWarningEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsInventoryWarningMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsInventoryWarningQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsInventoryWarningRespDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csInventoryWarningQueryService")
public class CsInventoryWarningQueryServiceImpl
implements ICsInventoryWarningQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsInventoryWarningQueryServiceImpl.class);
    @Autowired
    private CsInventoryWarningDas csInventoryWarningDas;
    @Autowired
    private CsInventoryWarningMapper csInventoryWarningMapper;
    @Autowired
    ILogicInventoryDomain logicInventoryDomain;

    @Override
    public CsInventoryWarningEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        return (CsInventoryWarningEo)this.csInventoryWarningDas.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<CsInventoryWarningRespDto> queryByPage(CsInventoryWarningQueryDto csInventoryWarningQueryDto) {
        logger.info("queryByPage==>\u5e93\u5b58\u9884\u8b66\u5206\u9875\u67e5\u8be2,csInventoryWarningQueryDto:{}", (Object)LogUtils.buildLogContent(csInventoryWarningQueryDto));
        this.checkParams(csInventoryWarningQueryDto);
        QueryWrapper csInventoryWarningEoQueryWrapper = new QueryWrapper();
        this.buildQueryWrapper(csInventoryWarningQueryDto, (QueryWrapper<CsInventoryWarningEo>)csInventoryWarningEoQueryWrapper);
        PageHelper.startPage((int)csInventoryWarningQueryDto.getPageNum(), (int)csInventoryWarningQueryDto.getPageSize());
        List csInventoryWarningEoList = this.csInventoryWarningMapper.selectList((Wrapper)csInventoryWarningEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csInventoryWarningEoList)) {
            return new PageInfo();
        }
        PageInfo inventoryWarningEoPageInfo = new PageInfo(csInventoryWarningEoList);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)inventoryWarningEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)inventoryWarningEoPageInfo.getList(), CsInventoryWarningRespDto.class);
        pageInfo.setList((List)list);
        String warehouseClassify = csInventoryWarningQueryDto.getWarehouseClassify();
        if (CsWarehouseClassifyEnum.LOGIC.getCode().equals(warehouseClassify)) {
            this.buildAvailableInventory(list);
        }
        return pageInfo;
    }

    @Override
    public PageInfo<CsInventoryWarningRespDto> warningSettingPage(CsInventoryWarningQueryDto csInventoryWarningQueryDto) {
        logger.info("warningSettingPage==>\u5b9e\u7269/\u865a\u62df\u4ed3\u5e93\u5b58\u9884\u8b66\u8bbe\u7f6e\u5206\u9875\u67e5\u8be2,csInventoryWarningQueryDto:{}", (Object)LogUtils.buildLogContent(csInventoryWarningQueryDto));
        this.checkParams(csInventoryWarningQueryDto);
        QueryWrapper csInventoryWarningEoQueryWrapper = new QueryWrapper();
        this.buildQueryWrapper(csInventoryWarningQueryDto, (QueryWrapper<CsInventoryWarningEo>)csInventoryWarningEoQueryWrapper);
        PageHelper.startPage((int)csInventoryWarningQueryDto.getPageNum(), (int)csInventoryWarningQueryDto.getPageSize());
        String warehouseClassify = csInventoryWarningQueryDto.getWarehouseClassify();
        List<Object> warningEoList = Lists.newArrayList();
        if (CsWarehouseClassifyEnum.LOGIC.getCode().equals(warehouseClassify)) {
            warningEoList = this.warningSettingPageLogic(csInventoryWarningQueryDto);
        } else if (CsWarehouseClassifyEnum.VIRTUAL.getCode().equals(warehouseClassify)) {
            warningEoList = this.warningSettingPageVirtual(csInventoryWarningQueryDto);
        }
        if (CollectionUtils.isEmpty((Collection)warningEoList)) {
            return new PageInfo();
        }
        PageInfo inventoryWarningEoPageInfo = new PageInfo((List)warningEoList);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)inventoryWarningEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)inventoryWarningEoPageInfo.getList(), CsInventoryWarningRespDto.class);
        pageInfo.setList((List)list);
        return pageInfo;
    }

    private List<CsInventoryWarningEo> warningSettingPageVirtual(CsInventoryWarningQueryDto csInventoryWarningQueryDto) {
        return null;
    }

    private List<CsInventoryWarningEo> warningSettingPageLogic(CsInventoryWarningQueryDto csInventoryWarningQueryDto) {
        return Lists.newArrayList();
    }

    private void buildAvailableInventory(List<CsInventoryWarningRespDto> list) {
        List warehouseCodeList = list.stream().map(CsInventoryWarningRespDto::getWarehouseCode).distinct().collect(Collectors.toList());
        List skuCodeList = list.stream().map(CsInventoryWarningRespDto::getSkuCode).distinct().collect(Collectors.toList());
        QueryWrapper csLogicInventoryEoQueryWrapper = new QueryWrapper();
        csLogicInventoryEoQueryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        csLogicInventoryEoQueryWrapper.in((Object)"sku_code", skuCodeList);
        csLogicInventoryEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List csLogicInventoryEoList = this.logicInventoryDomain.getMapper().selectList((Wrapper)csLogicInventoryEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csLogicInventoryEoList)) {
            return;
        }
        Map logicInventoryEoMap = csLogicInventoryEoList.stream().collect(Collectors.toMap(e -> e.getWarehouseCode() + "_" + e.getSkuCode(), Function.identity()));
        for (CsInventoryWarningRespDto warningRespDto : list) {
            String key = warningRespDto.getWarehouseCode() + "_" + warningRespDto.getSkuCode();
            LogicInventoryEo csLogicInventoryEo = (LogicInventoryEo)logicInventoryEoMap.get(key);
            if (null == csLogicInventoryEo) continue;
            warningRespDto.setAvailable(csLogicInventoryEo.getAvailable());
        }
    }

    private void buildQueryWrapper(CsInventoryWarningQueryDto csInventoryWarningQueryDto, QueryWrapper<CsInventoryWarningEo> csInventoryWarningEoQueryWrapper) {
        String warehouseType;
        String warehouseCode;
        String skuName;
        String skuCode = csInventoryWarningQueryDto.getSkuCode();
        if (StringUtils.isNotBlank((CharSequence)skuCode)) {
            csInventoryWarningEoQueryWrapper.like((Object)"sku_code", (Object)skuCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(skuName = csInventoryWarningQueryDto.getSkuName()))) {
            csInventoryWarningEoQueryWrapper.like((Object)"sku_name", (Object)skuName);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseCode = csInventoryWarningQueryDto.getWarehouseCode()))) {
            csInventoryWarningEoQueryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseType = csInventoryWarningQueryDto.getWarehouseType()))) {
            csInventoryWarningEoQueryWrapper.eq((Object)"warehouse_type", (Object)warehouseType);
        }
        csInventoryWarningEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
    }

    private void checkParams(CsInventoryWarningQueryDto csInventoryWarningQueryDto) {
        AssertUtil.isTrue(null != csInventoryWarningQueryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Integer pageNum = csInventoryWarningQueryDto.getPageNum();
        Integer pageSize = csInventoryWarningQueryDto.getPageSize();
        AssertUtil.isTrue(null != pageNum && pageNum > 0, "\u9875\u7801\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != pageSize && pageSize > 0, "\u9875\u7801\u53c2\u6570\u6709\u8bef");
        String warehouseClassify = csInventoryWarningQueryDto.getWarehouseClassify();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseClassify) && null != CsWarehouseClassifyEnum.getByCode((String)warehouseClassify), "\u4ed3\u5e93\u5206\u7c7b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

