/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.impl;

import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.ICsInPlannedOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.in.CsInPlannedOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInPlannedOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsPlannedOrderAuditEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInPlannedOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInPlannedOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsPlannedOrderAuditMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderPageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderDetailQueryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderRelOrderInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsPlannedOrderAuditRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInResultOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csInPlannedOrderQueryService")
public class CsInPlannedOrderQueryServiceImpl
implements ICsInPlannedOrderQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsInPlannedOrderQueryServiceImpl.class);
    @Autowired
    private CsInPlannedOrderDas csInPlannedOrderDas;
    @Autowired
    private CsInPlannedOrderMapper csInPlannedOrderMapper;
    @Autowired
    private CsInPlannedOrderDetailMapper csInPlannedOrderDetailMapper;
    @Autowired
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Autowired
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Autowired
    private CsPlannedOrderAuditMapper csPlannedOrderAuditMapper;

    @Override
    public CsInPlannedOrderEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        return (CsInPlannedOrderEo)this.csInPlannedOrderDas.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<CsInPlannedOrderRespDto> queryByPage(CsInPlannedOrderPageQueryDto inPlannedOrderPageQueryDto) {
        logger.info("queryByPage==>\u5206\u9875\u67e5\u8be2,inPlannedOrderPageQueryDto:{}", (Object)LogUtils.buildLogContent(inPlannedOrderPageQueryDto));
        this.checkParams(inPlannedOrderPageQueryDto);
        QueryWrapper queryWrapper = new QueryWrapper();
        this.buildQueryWrapper((QueryWrapper<CsInPlannedOrderEo>)queryWrapper, inPlannedOrderPageQueryDto);
        PageHelper.startPage((int)inPlannedOrderPageQueryDto.getPageNum(), (int)inPlannedOrderPageQueryDto.getPageSize());
        List list = this.csInPlannedOrderMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new PageInfo();
        }
        PageInfo selectPage = new PageInfo(list);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, CsInPlannedOrderRespDto.class);
        pageInfo.setList(dtoList);
        return pageInfo;
    }

    @Override
    public CsInPlannedOrderDetailQueryInfoRespDto queryDetailByOrderNo(String orderNo) {
        logger.info("queryDetailByOrderNo==>\u6839\u636e\u5355\u636e\u7f16\u7801\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u4fe1\u606f,orderNo:{}", (Object)orderNo);
        AssertUtil.isTrue(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderNo), "\u5355\u636e\u7f16\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper csInPlannedOrderEoQueryWrapper = new QueryWrapper();
        csInPlannedOrderEoQueryWrapper.eq((Object)"order_no", (Object)orderNo);
        csInPlannedOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)csInPlannedOrderEoQueryWrapper);
        AssertUtil.isTrue(null != csInPlannedOrderEo, "\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        CsInPlannedOrderDetailQueryInfoRespDto infoRespDto = new CsInPlannedOrderDetailQueryInfoRespDto();
        CubeBeanUtils.copyProperties((Object)infoRespDto, (Object)csInPlannedOrderEo, (String[])new String[0]);
        this.buildItemInfo(infoRespDto);
        this.buildRelOrderInfo(infoRespDto);
        this.buildAuditInfo(infoRespDto);
        return infoRespDto;
    }

    private void buildAuditInfo(CsInPlannedOrderDetailQueryInfoRespDto infoRespDto) {
        String orderNo = infoRespDto.getOrderNo();
        QueryWrapper csPlannedOrderAuditEoQueryWrapper = new QueryWrapper();
        csPlannedOrderAuditEoQueryWrapper.eq((Object)"order_no", (Object)orderNo);
        List csPlannedOrderAuditEoList = this.csPlannedOrderAuditMapper.selectList((Wrapper)csPlannedOrderAuditEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csPlannedOrderAuditEoList)) {
            return;
        }
        ArrayList auditRespDtoList = Lists.newArrayList();
        for (CsPlannedOrderAuditEo csPlannedOrderAuditEo : csPlannedOrderAuditEoList) {
            CsPlannedOrderAuditRespDto auditRespDto = new CsPlannedOrderAuditRespDto();
            CubeBeanUtils.copyProperties((Object)auditRespDto, (Object)csPlannedOrderAuditEo, (String[])new String[0]);
            auditRespDto.setCreatePerson(StringUtils.isEmpty((CharSequence)auditRespDto.getCreatePerson()) ? "system" : (auditRespDto.getCreatePerson().equals("-1") ? "system" : auditRespDto.getCreatePerson()));
            auditRespDtoList.add(auditRespDto);
        }
        infoRespDto.setAuditRespDtoList((List)auditRespDtoList);
    }

    @Override
    public List<CsInResultOrderDetailRespDto> queryOverchargeDetailByDocumentNo(String receiveDocumentNo) {
        logger.info("queryOverchargeDetailByNo==>\u6839\u636e\u5165\u5e93\u7ed3\u679c\u5355\u5355\u53f7\u67e5\u8be2\u8d85\u6536\u4fe1\u606f,receiveDocumentNo:{}", (Object)receiveDocumentNo);
        AssertUtil.isTrue(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)receiveDocumentNo), "\u5165\u5e93\u7ed3\u679c\u5355\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper csInResultOrderEoQueryWrapper = new QueryWrapper();
        csInResultOrderEoQueryWrapper.eq((Object)"document_no", (Object)receiveDocumentNo);
        InOutResultOrderEo csInResultOrderEo = (InOutResultOrderEo)this.inOutResultOrderDomain.getMapper().selectOne((Wrapper)csInResultOrderEoQueryWrapper);
        AssertUtil.isTrue(null != csInResultOrderEo, "\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        QueryWrapper csInResultOrderDetailEoQueryWrapper = new QueryWrapper();
        csInResultOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)receiveDocumentNo);
        List csInResultOrderDetailEoList = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)csInResultOrderDetailEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csInResultOrderDetailEoList)) {
            return Lists.newArrayList();
        }
        ArrayList inResultOrderDetailRespDtoList = Lists.newArrayList();
        Map<String, Double> cargoNumMap = csInResultOrderDetailEoList.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode, Collectors.summingDouble(obj -> obj.getDoneQuantity().doubleValue())));
        HashMap<String, List> listMap = new HashMap<String, List>();
        for (InOutResultOrderDetailEo csInResultOrderDetailEo : csInResultOrderDetailEoList) {
            CsInResultOrderDetailRespDto csInResultOrderDetailRespDto = new CsInResultOrderDetailRespDto();
            BigDecimal waitQuantity = csInResultOrderDetailEo.getWaitQuantity();
            if (waitQuantity.compareTo(BigDecimal.ZERO) >= 0) {
                Double doneQuantity = cargoNumMap.get(csInResultOrderDetailEo.getSkuCode());
                BigDecimal doneQuantity1 = BigDecimal.valueOf(doneQuantity);
                if (doneQuantity1.compareTo(csInResultOrderDetailEo.getPlanQuantity()) <= 0) continue;
                List detailRespDtoList = (List)listMap.get(csInResultOrderDetailEo.getSkuCode());
                detailRespDtoList = CollectionUtils.isEmpty((Collection)detailRespDtoList) ? new ArrayList() : detailRespDtoList;
                CubeBeanUtils.copyProperties((Object)csInResultOrderDetailRespDto, (Object)csInResultOrderDetailEo, (String[])new String[0]);
                csInResultOrderDetailRespDto.setWaitQuantity(doneQuantity1);
                detailRespDtoList.add(csInResultOrderDetailRespDto);
                listMap.put(csInResultOrderDetailEo.getSkuCode(), detailRespDtoList);
                continue;
            }
            CubeBeanUtils.copyProperties((Object)csInResultOrderDetailRespDto, (Object)csInResultOrderDetailEo, (String[])new String[0]);
            inResultOrderDetailRespDtoList.add(csInResultOrderDetailRespDto);
        }
        if (listMap.size() > 0) {
            for (String key : listMap.keySet()) {
                List detailRespDtoList = (List)listMap.get(key);
                CsInResultOrderDetailRespDto csInResultOrderDetailRespDto = new CsInResultOrderDetailRespDto();
                CubeBeanUtils.copyProperties((Object)csInResultOrderDetailRespDto, detailRespDtoList.get(0), (String[])new String[0]);
                csInResultOrderDetailRespDto.setDoneQuantity(((CsInResultOrderDetailRespDto)detailRespDtoList.get(0)).getWaitQuantity());
                csInResultOrderDetailRespDto.setBatch(null);
                csInResultOrderDetailRespDto.setDetailRespDtoList(detailRespDtoList);
                inResultOrderDetailRespDtoList.add(csInResultOrderDetailRespDto);
            }
        }
        return inResultOrderDetailRespDtoList;
    }

    @Override
    public List<CsInPlannedOrderRespDto> queryByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List eos = this.csInPlannedOrderDas.selectByIds(ids);
        if (CollectionUtils.isEmpty((Collection)eos)) {
            return null;
        }
        ArrayList dtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eos, (Collection)dtoList, CsInPlannedOrderRespDto.class);
        return dtoList;
    }

    private void buildRelOrderInfo(CsInPlannedOrderDetailQueryInfoRespDto infoRespDto) {
        ArrayList relOrderInfoList = Lists.newArrayList();
        infoRespDto.setRelOrderInfoList((List)relOrderInfoList);
        String orderNo = infoRespDto.getOrderNo();
        String platformOrderNo = infoRespDto.getPlatformOrderNo();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)platformOrderNo)) {
            CsInPlannedOrderRelOrderInfoRespDto easRelOrderInfo = new CsInPlannedOrderRelOrderInfoRespDto();
            easRelOrderInfo.setId(infoRespDto.getId());
            easRelOrderInfo.setOrderNo(infoRespDto.getPlatformOrderNo());
            easRelOrderInfo.setOrderType(infoRespDto.getBusinessType());
            easRelOrderInfo.setBusinessType(infoRespDto.getBusinessType());
            easRelOrderInfo.setCreateTime(infoRespDto.getCreateTime());
            relOrderInfoList.add(easRelOrderInfo);
        }
        QueryWrapper csReceiveNoticeOrderEoQueryWrapper = new QueryWrapper();
        csReceiveNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)orderNo);
        ReceiveDeliveryNoticeOrderEo csReceiveNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)this.receiveDeliveryNoticeOrderDomain.getMapper().selectOne((Wrapper)csReceiveNoticeOrderEoQueryWrapper);
        if (null != csReceiveNoticeOrderEo) {
            CsInPlannedOrderRelOrderInfoRespDto receiveNoticeOrderInfoDto = new CsInPlannedOrderRelOrderInfoRespDto();
            receiveNoticeOrderInfoDto.setId(csReceiveNoticeOrderEo.getId());
            receiveNoticeOrderInfoDto.setOrderNo(csReceiveNoticeOrderEo.getDocumentNo());
            receiveNoticeOrderInfoDto.setOrderType(CsDocumentTypeEnum.RECEIVE_NOTICE_ORDER.getCode());
            receiveNoticeOrderInfoDto.setOrderStatus(csReceiveNoticeOrderEo.getOrderStatus());
            receiveNoticeOrderInfoDto.setRemark(csReceiveNoticeOrderEo.getRemark());
            receiveNoticeOrderInfoDto.setCreateTime(csReceiveNoticeOrderEo.getCreateTime());
            relOrderInfoList.add(receiveNoticeOrderInfoDto);
        }
        QueryWrapper csReceiveResultOrderEoQueryWrapper = new QueryWrapper();
        csReceiveResultOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)orderNo);
        List csReceiveResultOrderEoList = this.receiveDeliveryResultOrderDomain.getMapper().selectList((Wrapper)csReceiveResultOrderEoQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)csReceiveResultOrderEoList)) {
            for (ReceiveDeliveryResultOrderEo csReceiveResultOrderEo : csReceiveResultOrderEoList) {
                CsInPlannedOrderRelOrderInfoRespDto receiveResultOrderInfoDto = new CsInPlannedOrderRelOrderInfoRespDto();
                receiveResultOrderInfoDto.setId(csReceiveResultOrderEo.getId());
                receiveResultOrderInfoDto.setOrderNo(csReceiveResultOrderEo.getDocumentNo());
                receiveResultOrderInfoDto.setOrderType(CsDocumentTypeEnum.RECEIVE_RESULT_ORDER.getCode());
                receiveResultOrderInfoDto.setOrderStatus(csReceiveResultOrderEo.getOrderStatus());
                receiveResultOrderInfoDto.setRemark(csReceiveResultOrderEo.getRemark());
                receiveResultOrderInfoDto.setCreateTime(csReceiveResultOrderEo.getCreateTime());
                relOrderInfoList.add(receiveResultOrderInfoDto);
            }
        }
        QueryWrapper csInNoticeOrderEoQueryWrapper = new QueryWrapper();
        csInNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)orderNo);
        InOutNoticeOrderEo csInNoticeOrderEo = (InOutNoticeOrderEo)this.inOutNoticeOrderDomain.getMapper().selectOne((Wrapper)csInNoticeOrderEoQueryWrapper);
        if (null != csInNoticeOrderEo) {
            CsInPlannedOrderRelOrderInfoRespDto inNoticeOrderInfoDto = new CsInPlannedOrderRelOrderInfoRespDto();
            inNoticeOrderInfoDto.setId(csInNoticeOrderEo.getId());
            inNoticeOrderInfoDto.setOrderNo(csInNoticeOrderEo.getDocumentNo());
            inNoticeOrderInfoDto.setOrderType(CsDocumentTypeEnum.IN_NOTICE_ORDER.getCode());
            inNoticeOrderInfoDto.setOrderStatus(csInNoticeOrderEo.getOrderStatus());
            inNoticeOrderInfoDto.setRemark(csInNoticeOrderEo.getRemark());
            inNoticeOrderInfoDto.setCreateTime(csInNoticeOrderEo.getCreateTime());
            relOrderInfoList.add(inNoticeOrderInfoDto);
        }
        QueryWrapper csInResultOrderEoQueryWrapper = new QueryWrapper();
        csInResultOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)orderNo);
        List csInResultOrderEoList = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)csInResultOrderEoQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)csInResultOrderEoList)) {
            for (InOutResultOrderEo InOutResultOrderEo2 : csInResultOrderEoList) {
                CsInPlannedOrderRelOrderInfoRespDto inResultOrderInfoDto = new CsInPlannedOrderRelOrderInfoRespDto();
                inResultOrderInfoDto.setId(InOutResultOrderEo2.getId());
                inResultOrderInfoDto.setOrderNo(InOutResultOrderEo2.getDocumentNo());
                inResultOrderInfoDto.setOrderType(CsDocumentTypeEnum.IN_RESULT_ORDER.getCode());
                inResultOrderInfoDto.setOrderStatus(InOutResultOrderEo2.getOrderStatus());
                inResultOrderInfoDto.setRemark(InOutResultOrderEo2.getRemark());
                inResultOrderInfoDto.setCreateTime(InOutResultOrderEo2.getCreateTime());
                relOrderInfoList.add(inResultOrderInfoDto);
            }
        }
    }

    private void buildItemInfo(CsInPlannedOrderDetailQueryInfoRespDto infoRespDto) {
        String orderNo = infoRespDto.getOrderNo();
        QueryWrapper detailEoQueryWrapper = new QueryWrapper();
        detailEoQueryWrapper.eq((Object)"order_no", (Object)orderNo);
        detailEoQueryWrapper.eq((Object)"dr", (Object)0);
        List orderDetailEoList = this.csInPlannedOrderDetailMapper.selectList((Wrapper)detailEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)orderDetailEoList), "\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        ArrayList itemInfoList = Lists.newArrayList();
        infoRespDto.setItemInfoList((List)itemInfoList);
        for (CsInPlannedOrderDetailEo detailEo : orderDetailEoList) {
            CsInPlannedOrderDetailRespDto detailRespDto = new CsInPlannedOrderDetailRespDto();
            CubeBeanUtils.copyProperties((Object)detailRespDto, (Object)detailEo, (String[])new String[0]);
            itemInfoList.add(detailRespDto);
        }
    }

    private void buildQueryWrapper(QueryWrapper<CsInPlannedOrderEo> queryWrapper, CsInPlannedOrderPageQueryDto inPlannedOrderPageQueryDto) {
        String receiveWarehouseName;
        String receiveWarehouseCode;
        String businessType;
        String orderStatus;
        String orderNo = inPlannedOrderPageQueryDto.getOrderNo();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderNo)) {
            queryWrapper.like((Object)"order_no", (Object)orderNo);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(orderStatus = inPlannedOrderPageQueryDto.getOrderStatus()))) {
            queryWrapper.eq((Object)"order_status", (Object)orderStatus);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(businessType = inPlannedOrderPageQueryDto.getBusinessType()))) {
            queryWrapper.eq((Object)"business_type", (Object)businessType);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(receiveWarehouseCode = inPlannedOrderPageQueryDto.getReceiveWarehouseCode()))) {
            queryWrapper.like((Object)"receive_warehouse_code", (Object)receiveWarehouseCode);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(receiveWarehouseName = inPlannedOrderPageQueryDto.getReceiveWarehouseName()))) {
            queryWrapper.like((Object)"receive_warehouse_name", (Object)receiveWarehouseName);
        }
        String createTimeStart = inPlannedOrderPageQueryDto.getCreateTimeStart();
        String createTimeEnd = inPlannedOrderPageQueryDto.getCreateTimeEnd();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)createTimeStart) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)createTimeEnd)) {
            queryWrapper.ge((Object)"create_time", (Object)createTimeStart);
            queryWrapper.le((Object)"create_time", (Object)createTimeStart);
        }
        queryWrapper.orderByDesc((Object)"create_time");
    }

    private void checkParams(CsInPlannedOrderPageQueryDto inPlannedOrderPageQueryDto) {
        AssertUtil.isTrue(null != inPlannedOrderPageQueryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != inPlannedOrderPageQueryDto.getPageNum() && inPlannedOrderPageQueryDto.getPageNum() > 0, "\u5206\u9875\u9875\u7801\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != inPlannedOrderPageQueryDto.getPageSize() && inPlannedOrderPageQueryDto.getPageSize() > 0, "\u5206\u9875\u5927\u5c0f\u53c2\u6570\u6709\u8bef");
        String orderType = inPlannedOrderPageQueryDto.getOrderType();
        AssertUtil.isTrue(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderType) && null != CsPlannedOrderTypeEnum.getByCode((String)orderType), "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

