/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyConfigReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyRelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyConfigRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyRelRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseSupplyConfigService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseSupplyRelService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.constant.ItemInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseSupplyRelDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseSupplyRelEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsRelWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class WarehouseSupplyRelServiceImpl
implements IWarehouseSupplyRelService {
    private static final Logger log = LoggerFactory.getLogger(WarehouseSupplyRelServiceImpl.class);
    @Resource
    private WarehouseSupplyRelDas warehouseSupplyRelDas;
    @Resource
    private IWarehouseSupplyConfigService warehouseSupplyConfigService;
    @Resource
    private ICsRelWarehouseQueryService relWarehouseQueryService;
    @Resource
    private ICustomerQueryApi customerQueryApi;

    @Override
    public Long addWarehouseSupplyRel(WarehouseSupplyRelReqDto addReqDto) {
        log.info("\u6307\u5b9a\u5ba2\u6237\u53d1\u8d27\u4ed3\u914d\u7f6e reqParams is {} . ", (Object)JSON.toJSONString((Object)addReqDto));
        AssertUtil.assertTrue(CollectionUtils.isEmpty((Collection)addReqDto.getWarehouseCodeList()), "\u4ed3\u5e93\u7f16\u7801\u4e3a\u7a7a");
        AssertUtil.assertNotNull(addReqDto.getOrganizationId(), "\u7ec4\u7ec7ID\u4e3a\u7a7a");
        AssertUtil.assertNotNull(addReqDto.getCustomerId(), "\u5ba2\u6237ID\u4e3a\u7a7a");
        List<CsRelWarehouseEo> csRelWarehouseEos = this.relWarehouseQueryService.queryByRefWarehouseCode(addReqDto.getWarehouseCode(), CsWarehouseClassifyEnum.PHYSICS.getCode());
        AssertUtil.assertTrue(CollectionUtils.isEmpty(csRelWarehouseEos), "\u5f53\u524d\u4ed3\u5e93\u4e0d\u5b58\u5728");
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(addReqDto.getCustomerId()));
        AssertUtil.assertNotNull(customerRespDto, "\u5ba2\u6237\u4e0d\u5b58\u5728");
        WarehouseSupplyConfigReqDto warehouseSupplyConfigReqDto = new WarehouseSupplyConfigReqDto();
        warehouseSupplyConfigReqDto.setOrganizationId(addReqDto.getOrganizationId());
        warehouseSupplyConfigReqDto.setCustomerCode(customerRespDto.getCode());
        PageInfo<WarehouseSupplyConfigRespDto> warehouseSupplyConfigRespDtoPageInfo = this.warehouseSupplyConfigService.queryByPage(JSON.toJSONString((Object)warehouseSupplyConfigReqDto), 1, Integer.MAX_VALUE);
        if (CollectionUtils.isEmpty((Collection)warehouseSupplyConfigRespDtoPageInfo.getList())) {
            WarehouseSupplyConfigReqDto warehouseSupplyConfig = new WarehouseSupplyConfigReqDto(addReqDto.getOrganizationId(), addReqDto.getOrganizationCode(), addReqDto.getOrganizationName(), ItemInventoryStrategyEnum.SEPARATE.getTypeCode(), customerRespDto.getId(), customerRespDto.getCode());
            this.warehouseSupplyConfigService.addWarehouseSupplyConfig(warehouseSupplyConfig);
        }
        WarehouseSupplyRelEo warehouseSupplyRelEo = new WarehouseSupplyRelEo();
        warehouseSupplyRelEo.setCustomerId(addReqDto.getCustomerId());
        this.warehouseSupplyRelDas.delete((BaseEo)warehouseSupplyRelEo);
        List collect = addReqDto.getWarehouseCodeList().stream().map(warehouseCode -> new WarehouseSupplyRelEo(customerRespDto.getId(), customerRespDto.getCode(), YesNoEnum.YES.getValue(), warehouseCode, addReqDto.getOrganizationId())).collect(Collectors.toList());
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)warehouseSupplyRelEo);
        this.warehouseSupplyRelDas.insertBatch(collect);
        return null;
    }

    @Override
    public void modifyWarehouseSupplyRel(WarehouseSupplyRelReqDto modifyReqDto) {
        WarehouseSupplyRelEo warehouseSupplyRelEo = new WarehouseSupplyRelEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)warehouseSupplyRelEo);
        this.warehouseSupplyRelDas.updateSelective((BaseEo)warehouseSupplyRelEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeWarehouseSupplyRel(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.warehouseSupplyRelDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public WarehouseSupplyRelRespDto queryById(Long id) {
        WarehouseSupplyRelEo warehouseSupplyRelEo = (WarehouseSupplyRelEo)this.warehouseSupplyRelDas.selectByPrimaryKey(id);
        WarehouseSupplyRelRespDto warehouseSupplyRelRespDto = new WarehouseSupplyRelRespDto();
        DtoHelper.eo2Dto((BaseEo)warehouseSupplyRelEo, (BaseVo)warehouseSupplyRelRespDto);
        return warehouseSupplyRelRespDto;
    }

    @Override
    public PageInfo<WarehouseSupplyRelRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        WarehouseSupplyRelReqDto warehouseSupplyRelReqDto = (WarehouseSupplyRelReqDto)JSON.parseObject((String)filter, WarehouseSupplyRelReqDto.class);
        WarehouseSupplyRelEo warehouseSupplyRelEo = new WarehouseSupplyRelEo();
        DtoHelper.dto2Eo((BaseVo)warehouseSupplyRelReqDto, (BaseEo)warehouseSupplyRelEo);
        PageInfo eoPageInfo = this.warehouseSupplyRelDas.selectPage((BaseEo)warehouseSupplyRelEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, WarehouseSupplyRelRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<WarehouseSupplyRelRespDto> queryByCustomerId(String customerId) {
        WarehouseSupplyRelEo params = new WarehouseSupplyRelEo();
        params.setCustomerId(Long.valueOf(customerId));
        List select = this.warehouseSupplyRelDas.select((BaseEo)params);
        ArrayList warehouseSupplyRelRespDto = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)select, (Collection)warehouseSupplyRelRespDto, WarehouseSupplyRelRespDto.class);
        return warehouseSupplyRelRespDto;
    }

    @Override
    public PageInfo<WarehouseSupplyRelRespDto> queryWarehousePage(String filter, Integer pageNum, Integer pageSize) {
        WarehouseSupplyRelReqDto warehouseSupplyRelReqDto = (WarehouseSupplyRelReqDto)JSON.parseObject((String)filter, WarehouseSupplyRelReqDto.class);
        AssertUtil.assertTrue(ObjectUtils.isEmpty((Object)warehouseSupplyRelReqDto.getOrganizationId()), "\u7ec4\u7ec7ID\u4e3a\u7a7a");
        Page warehouseSupplyRelEos = this.warehouseSupplyRelDas.queryWarehousePage(warehouseSupplyRelReqDto, pageNum, pageSize);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)warehouseSupplyRelEos, (String[])new String[]{"list", "navigatepageNums"});
        List warehouseSupplyRelEoList = warehouseSupplyRelEos.getResult();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)warehouseSupplyRelEoList)) {
            respDtoPageInfo.setList(warehouseSupplyRelEoList);
        }
        return respDtoPageInfo;
    }
}

