/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.StockChangeDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.constant.InventoryConstant;
import com.dtyunxi.yundt.cube.center.inventory.biz.dto.CloudInventoryDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.enus.OrderTypeEnu;
import com.dtyunxi.yundt.cube.center.inventory.biz.enus.StorageTypeEnu;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ITransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.ITcbjInventoryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.order.ITcbjBaseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageTotalEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ChangeLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DRAOrderCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DRAOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.CargoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.CargoStorageMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.CargoStorageTotalMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjCargoOccupyMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjChangeLogMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjDRAOrderCargoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjDRAOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.TcbjNotiDetailCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.TcbjResDetailCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.OrderStatus;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.OrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmDetailReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmReqDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TcbjBaseServiceImpl
implements ITcbjBaseService {
    private static final Logger logger = LoggerFactory.getLogger(TcbjBaseServiceImpl.class);
    @Autowired
    private TcbjCargoOccupyMapper tcbjCargoOccupyMapper;
    @Autowired
    private TcbjDRAOrderMapper tcbjDRAOrderMapper;
    @Autowired
    private TcbjDRAOrderCargoMapper tcbjDRAOrderCargoMapper;
    @Autowired
    private TcbjWarehouseMapper tcbjWarehouseMapper;
    @Autowired
    private CargoMapper cargoMapper;
    @Autowired
    private CargoStorageMapper cargoStorageMapper;
    @Autowired
    private ITransferOrderService transferOrderService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Autowired
    private TcbjChangeLogMapper tcbjChangeLogMapper;
    @Autowired
    private CargoStorageTotalMapper cargoStorageTotalMapper;
    @Autowired
    private ITcbjInventoryService tcbjInventoryService;
    @Resource
    private IContext context;
    @Resource
    private ICacheService cacheService;
    private final ExecutorService executorService = new ThreadPoolExecutor(2, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(DRAOrderEo draOrderEo, List<DRAOrderCargoEo> draOrderCargoEos, int action, DRAOrderEo notiEo) {
        logger.info("TcbjBaseServiceImpl#add,draOrderEo:{},draOrderCargoEos:{},action:{},notiEo:{}", new Object[]{LogUtils.buildLogContent(draOrderEo), LogUtils.buildLogContent(draOrderCargoEos), LogUtils.buildLogContent(action), LogUtils.buildLogContent(notiEo)});
        draOrderEo.setNum(draOrderCargoEos.stream().map(e -> {
            if (Objects.nonNull(e.getNum())) {
                return e.getNum();
            }
            if (Objects.nonNull(e.getPlanNum())) {
                return e.getPlanNum();
            }
            return 0;
        }).reduce(0, Integer::sum));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)draOrderEo.getWarehouseCode());
        WarehouseEo warehouseEo = (WarehouseEo)this.tcbjWarehouseMapper.selectOne((Wrapper)queryWrapper);
        if (warehouseEo == null) {
            throw new BizException("\u627e\u4e0d\u5230\u5bf9\u5e94\u4ed3\u5e93\uff1a{}\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff01", draOrderEo.getWarehouseCode());
        }
        draOrderEo.setOrganizationId(warehouseEo.getOrganizationId());
        this.add(draOrderEo);
        ArrayList<StorageOrderDetailEo> storageOrderDetailList = new ArrayList<StorageOrderDetailEo>();
        for (DRAOrderCargoEo cargoEo : draOrderCargoEos) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"dr", (Object)"0");
            if (!Strings.isNullOrEmpty((String)cargoEo.getCargoCode())) {
                wrapper.eq((Object)"code", (Object)cargoEo.getCargoCode());
            }
            if (cargoEo.getCargoId() != null && cargoEo.getCargoId() > 0L) {
                wrapper.eq((Object)"id", (Object)cargoEo.getCargoId());
            }
            CargoEo one = (CargoEo)this.cargoMapper.selectOne((Wrapper)wrapper);
            AssertUtil.isTrue(Objects.nonNull(one), "\u5546\u54c1\u7f16\u7801\u672a\u627e\u5230\uff1a" + cargoEo.getCargoCode());
            cargoEo.setCargoName(one.getName());
            cargoEo.setCargoCode(one.getCode());
            cargoEo.setCargoNo(one.getArtNo());
            cargoEo.setCargoId(one.getId());
            cargoEo.setOrderNo(draOrderEo.getNo());
            cargoEo.setCreatePerson("sys");
            cargoEo.setCreateTime((java.util.Date)new Date(new java.util.Date().getTime()));
            cargoEo.setUpdatePerson("sys");
            cargoEo.setUpdateTime((java.util.Date)new Date(new java.util.Date().getTime()));
            cargoEo.setDr(0);
            this.tcbjDRAOrderCargoMapper.insert((Object)cargoEo);
            this.incrTotalStorage(action, warehouseEo, cargoEo, one);
            StorageOrderDetailEo storageOrderDetailEo = new StorageOrderDetailEo();
            storageOrderDetailEo.setCargoId(one.getId());
            storageOrderDetailEo.setOrderId(cargoEo.getOrderId());
            storageOrderDetailEo.setOrderNo(draOrderEo.getPreNo());
            storageOrderDetailEo.setWarehouseId(warehouseEo.getId());
            storageOrderDetailEo.setBatch(cargoEo.getBatch());
            Long num = (long)cargoEo.getNum();
            if (notiEo != null) {
                notiEo.setStatus(OrderStatusEnum.DELIVERY_OUT_FINISH.getCode());
            }
            if (2 == action || 3 == action) {
                num = -num.longValue();
                if (notiEo != null) {
                    notiEo.setStatus(OrderStatusEnum.RECIPT_FINISH.getCode());
                }
            }
            storageOrderDetailEo.setNum(num);
            if (draOrderEo.getType() < 200) {
                storageOrderDetailEo.setActualNum(num);
                storageOrderDetailEo.setNum(Long.valueOf(0L));
            }
            QueryWrapper storageEoQuerywrapper = new QueryWrapper();
            storageEoQuerywrapper.eq((Object)"dr", (Object)"0");
            storageEoQuerywrapper.eq((Object)"warehouse_id", (Object)storageOrderDetailEo.getWarehouseId());
            storageEoQuerywrapper.eq((Object)"cargo_id", (Object)storageOrderDetailEo.getCargoId());
            storageEoQuerywrapper.eq((Object)"batch", (Object)storageOrderDetailEo.getBatch());
            CargoStorageEo cargoStorageEo = (CargoStorageEo)this.cargoStorageMapper.selectOne((Wrapper)storageEoQuerywrapper);
            ChangeLogEo changeLogEo = new ChangeLogEo();
            changeLogEo.setRelevanceNo(draOrderEo.getPreNo());
            if (cargoStorageEo == null) {
                cargoStorageEo = new CargoStorageEo();
                cargoStorageEo.setBalance(BigDecimal.ZERO);
                cargoStorageEo.setAvailable(BigDecimal.ZERO);
                if (2 == action || 3 == action) {
                    cargoStorageEo.setBalance(new BigDecimal(cargoEo.getNum()));
                    cargoStorageEo.setAvailable(new BigDecimal(cargoEo.getNum()));
                }
                cargoStorageEo.setPreempt(BigDecimal.ZERO);
                cargoStorageEo.setCargoName(one.getName());
                cargoStorageEo.setCargoId(one.getId());
                cargoStorageEo.setCargoCode(cargoEo.getCargoCode());
                cargoStorageEo.setWarehouseId(warehouseEo.getId());
                cargoStorageEo.setWarehouseName(warehouseEo.getName());
                cargoStorageEo.setWarehouseCode(warehouseEo.getCode());
                cargoStorageEo.setProduceTime(cargoEo.getProduceTime());
                cargoStorageEo.setExpireTime(cargoEo.getExpireTime());
                cargoStorageEo.setBatch(cargoEo.getBatch());
                this.cargoStorageMapper.insert((Object)cargoStorageEo);
                BeanUtils.copyProperties((Object)cargoStorageEo, (Object)changeLogEo);
                changeLogEo.setId(null);
                changeLogEo.setNewNum(cargoStorageEo.getBalance().subtract(new BigDecimal(num)));
                changeLogEo.setChangeNum(new BigDecimal(cargoEo.getNum()));
                changeLogEo.setOldNum(BigDecimal.ZERO);
                changeLogEo.setType(StorageTypeEnu.BALANCE.getCode());
                changeLogEo.setOrderType(draOrderEo.getType() + "");
                changeLogEo.setUpdateTime(null);
                int insert = this.tcbjChangeLogMapper.insert((Object)changeLogEo);
                logger.info("\u63d2\u5165\u64cd\u4f5c\u65e5\u5fd7\u5b8c\u6210{},{}", (Object)JSON.toJSONString((Object)changeLogEo), (Object)insert);
                continue;
            }
            BeanUtils.copyProperties((Object)cargoStorageEo, (Object)changeLogEo);
            changeLogEo.setId(null);
            BigDecimal preempt = BigDecimal.ZERO;
            if (cargoStorageEo.getPreempt() != null) {
                preempt = cargoStorageEo.getPreempt();
            }
            if (2 == action || 3 == action) {
                changeLogEo.setNewNum(cargoStorageEo.getBalance().add(new BigDecimal(cargoEo.getNum())));
            }
            if (1 == action) {
                changeLogEo.setNewNum(cargoStorageEo.getBalance().subtract(new BigDecimal(cargoEo.getNum())));
            }
            changeLogEo.setNewNum(changeLogEo.getNewNum().add(preempt));
            changeLogEo.setChangeNum(new BigDecimal(cargoEo.getNum()));
            changeLogEo.setOldNum(cargoStorageEo.getBalance().add(preempt));
            changeLogEo.setType(StorageTypeEnu.BALANCE.getCode());
            changeLogEo.setOrderType(draOrderEo.getType() + "");
            changeLogEo.setUpdateTime(null);
            int insert = this.tcbjChangeLogMapper.insert((Object)changeLogEo);
            if (201 <= draOrderEo.getType() && draOrderEo.getType() <= 207) {
                changeLogEo.setType(StorageTypeEnu.AVAILABLE.getCode());
                changeLogEo.setOrderType(draOrderEo.getType() + "");
                changeLogEo.setUpdateTime(null);
                changeLogEo.setId(null);
                changeLogEo.setNewNum(cargoStorageEo.getAvailable().add(new BigDecimal(cargoEo.getNum())));
                changeLogEo.setChangeNum(new BigDecimal(cargoEo.getNum()));
                changeLogEo.setOldNum(cargoStorageEo.getAvailable());
                int insert1 = this.tcbjChangeLogMapper.insert((Object)changeLogEo);
                logger.info("\u63d2\u5165\u64cd\u4f5c\u65e5\u5fd7\u5b8c\u6210{},{}", (Object)JSON.toJSONString((Object)changeLogEo), (Object)insert1);
            }
            if (draOrderEo.getType() < 200) {
                ChangeLogEo logEo = new ChangeLogEo();
                BeanUtils.copyProperties((Object)cargoStorageEo, (Object)logEo);
                logEo.setId(null);
                logEo.setRelevanceNo(draOrderEo.getPreNo());
                logEo.setNewNum(cargoStorageEo.getPreempt().subtract(new BigDecimal(cargoEo.getNum())));
                logEo.setChangeNum(new BigDecimal(cargoEo.getNum()));
                logEo.setOldNum(cargoStorageEo.getPreempt());
                logEo.setType(StorageTypeEnu.PREEMPT.getCode());
                logEo.setOrderType(draOrderEo.getType() + "");
                logEo.setUpdateTime(null);
                logEo.setCreateTime(null);
                int insert2 = this.tcbjChangeLogMapper.insert((Object)logEo);
                logger.info("\u63d2\u5165\u64cd\u4f5c\u65e5\u5fd7\u5b8c\u6210{},{}", (Object)JSON.toJSONString((Object)logEo), (Object)insert2);
            }
            storageOrderDetailEo.setVersion(cargoStorageEo.getVersion());
            storageOrderDetailList.add(storageOrderDetailEo);
            cargoStorageEo.setProduceTime(cargoEo.getProduceTime());
            cargoStorageEo.setExpireTime(cargoEo.getExpireTime());
            this.cargoStorageMapper.updateById((BaseEo)cargoStorageEo);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orderTradeStatus", (Object)"SUCC");
        jsonObject.put("orderCode", (Object)draOrderEo.getPreNo());
        if (1 == action) {
            jsonObject.put("type", (Object)"delivery");
        } else if (2 == action) {
            jsonObject.put("type", (Object)"return");
            ReturnItemConfirmReqDto returnItemConfirmReqDto = new ReturnItemConfirmReqDto();
            returnItemConfirmReqDto.setReturnNo(draOrderEo.getPreNo());
            if (CollectionUtil.isNotEmpty(draOrderCargoEos)) {
                List items = draOrderCargoEos.stream().map(e -> {
                    ReturnItemConfirmDetailReqDto returnItemConfirmDetailReqDto = new ReturnItemConfirmDetailReqDto();
                    returnItemConfirmDetailReqDto.setItemCode(e.getCargoCode());
                    returnItemConfirmDetailReqDto.setItemId(e.getCargoId() + "");
                    returnItemConfirmDetailReqDto.setItemName(e.getCargoName());
                    returnItemConfirmDetailReqDto.setCurrentNum(Long.valueOf(e.getNum().intValue()));
                    returnItemConfirmDetailReqDto.setCargoSerial(e.getCargoId() + "");
                    returnItemConfirmDetailReqDto.setCargoCode(e.getCargoCode());
                    returnItemConfirmDetailReqDto.setBatchNo(e.getBatch());
                    returnItemConfirmDetailReqDto.setOrderNo(e.getPreNo());
                    return returnItemConfirmDetailReqDto;
                }).collect(Collectors.toList());
                returnItemConfirmReqDto.setReturnItemConfirmDetailReqDtos(items);
                jsonObject.put("items", (Object)returnItemConfirmReqDto);
            }
        } else if (3 == action) {
            jsonObject.put("type", (Object)"finish");
        }
        if (CollectionUtil.isNotEmpty(storageOrderDetailList)) {
            StockChangeDto stockChangeDto = new StockChangeDto();
            stockChangeDto.setOrderNo(draOrderEo.getPreNo());
            stockChangeDto.setChangeType("STOCK_IN");
            stockChangeDto.setBizType("TRANSFER_ORDER_PHYSICAL_IN");
            if (1 == action) {
                stockChangeDto.setChangeType("STOCK_OUT");
                stockChangeDto.setBizType("TRANSFER_ORDER_PHYSICAL_OUT");
            }
            try {
                if (101 <= draOrderEo.getType() && draOrderEo.getType() < 200) {
                    this.tcbjInventoryService.cancelPreOccupy(draOrderEo.getPreNo(), draOrderEo.getType() + "", false, false);
                }
                logger.info("\u4fee\u6539\u5e93\u5b58\u5165\u53c2stockChangeDto:{},storageOrderDetailList{}", (Object)JSON.toJSONString((Object)stockChangeDto), (Object)JSON.toJSONString(storageOrderDetailList));
                int i = this.transferOrderService.tcbjPhysicLogicWarehouseOut(stockChangeDto, storageOrderDetailList);
                logger.info("\u4fee\u6539\u7269\u7406\u5e93\u5b58\u8fd4\u56de\u7ed3\u679c{}", (Object)i);
                if (i != 0 && i != 999) {
                    MessageVo messageVo = new MessageVo();
                    messageVo.setData((Object)jsonObject);
                    this.executorService.execute(new Thread(() -> this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", "ORDER_STATUS_FINISH_TAG", (Object)messageVo)));
                    logger.info("\u53d1mq\u901a\u77e5\u8ba2\u5355\u4fee\u6539\u5df2\u5b8c\u6210\uff1a{}", (Object)JSON.toJSONString((Object)jsonObject));
                    if (notiEo != null) {
                        QueryWrapper notiWrapper = new QueryWrapper();
                        notiWrapper.eq((Object)"pre_no", (Object)notiEo.getPreNo());
                        List dbRecords = this.tcbjDRAOrderMapper.selectList((Wrapper)notiWrapper);
                        if (CollectionUtil.isNotEmpty((Collection)dbRecords)) {
                            dbRecords.forEach(e -> {
                                e.setUpdateTime(new java.util.Date());
                                e.setStatus(action == 1 ? OrderStatus.DELIVERY_OUT_FINISH : OrderStatus.RECIPT_FINISH);
                                this.tcbjDRAOrderMapper.updateById((BaseEo)e);
                            });
                        }
                    }
                }
            }
            catch (Exception e2) {
                throw new BizException("\u51fa\u5e93\u6263\u51cf\u5e93\u5b58\u9519\u8bef\uff1a{}" + e2.getMessage());
            }
        }
    }

    private void incrTotalStorage(int action, WarehouseEo warehouseEo, DRAOrderCargoEo cargoEo, CargoEo one) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.eq((Object)"cargo_code", (Object)one.getCode());
        objectQueryWrapper.eq((Object)"warehouse_code", (Object)warehouseEo.getCode());
        objectQueryWrapper.isNull((Object)"batch");
        CargoStorageTotalEo cargoStorageTotalEo = (CargoStorageTotalEo)this.cargoStorageTotalMapper.selectOne((Wrapper)objectQueryWrapper);
        if (cargoStorageTotalEo == null) {
            QueryWrapper batchStorage = new QueryWrapper();
            batchStorage.eq((Object)"cargo_code", (Object)one.getCode());
            batchStorage.eq((Object)"warehouse_code", (Object)warehouseEo.getCode());
            batchStorage.isNotNull((Object)"batch");
            List cargoStorageEos = this.cargoStorageMapper.selectList((Wrapper)batchStorage);
            if (CollectionUtil.isNotEmpty((Collection)cargoStorageEos)) {
                BigDecimal balance = cargoStorageEos.stream().map(StdCargoStorageEo::getBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
                CargoStorageTotalEo totalStorage = new CargoStorageTotalEo();
                BeanUtils.copyProperties(cargoStorageEos.get(0), (Object)totalStorage);
                totalStorage.setId(null);
                totalStorage.setCreateTime(null);
                totalStorage.setUpdateTime(null);
                totalStorage.setBalance(balance);
                totalStorage.setAvailable(balance);
                totalStorage.setBatch(null);
                int insert = this.cargoStorageTotalMapper.insert((Object)totalStorage);
                if (insert <= 0) {
                    throw new BizException("\u521d\u59cb\u5316\u603b\u5e93\u5b58\u5931\u8d25" + JSON.toJSONString((Object)totalStorage));
                }
                if (1 == action) {
                    totalStorage.setBalance(totalStorage.getBalance().subtract(new BigDecimal(cargoEo.getNum())));
                    totalStorage.setAvailable(totalStorage.getAvailable().subtract(new BigDecimal(cargoEo.getNum())));
                } else if (2 == action || 3 == action) {
                    totalStorage.setBalance(totalStorage.getBalance().add(new BigDecimal(cargoEo.getNum())));
                    totalStorage.setAvailable(totalStorage.getAvailable().add(new BigDecimal(cargoEo.getNum())));
                }
                int i = this.cargoStorageTotalMapper.updateTotalNum(totalStorage);
                if (i <= 0) {
                    throw new BizException("\u66f4\u65b0\u5e93\u5b58\u603b\u8868\u64cd\u4f5c\u9519\u8bef\uff01" + JSON.toJSONString((Object)totalStorage));
                }
            }
        } else {
            if (1 == action) {
                cargoStorageTotalEo.setBalance(cargoStorageTotalEo.getBalance().subtract(new BigDecimal(cargoEo.getNum())));
                cargoStorageTotalEo.setAvailable(cargoStorageTotalEo.getAvailable().subtract(new BigDecimal(cargoEo.getNum())));
            } else if (2 == action || 3 == action) {
                cargoStorageTotalEo.setBalance(cargoStorageTotalEo.getBalance().add(new BigDecimal(cargoEo.getNum())));
                cargoStorageTotalEo.setAvailable(cargoStorageTotalEo.getAvailable().add(new BigDecimal(cargoEo.getNum())));
            }
            int i = this.cargoStorageTotalMapper.updateTotalNum(cargoStorageTotalEo);
            if (i <= 0) {
                throw new BizException("\u66f4\u65b0\u5e93\u5b58\u603b\u8868\u64cd\u4f5c\u9519\u8bef\uff01" + JSON.toJSONString((Object)cargoStorageTotalEo));
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(DRAOrderEo draOrderEo) {
        String orderCategory;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)draOrderEo.getWarehouseCode());
        WarehouseEo warehouseEo = (WarehouseEo)this.tcbjWarehouseMapper.selectOne((Wrapper)queryWrapper);
        AssertUtil.isTrue(Objects.nonNull(warehouseEo), "\u4ed3\u5e93\u672a\u627e\u5230");
        String pre = "";
        int status = 0;
        switch (orderCategory = draOrderEo.getCategory()) {
            case "101": {
                pre = "FHTZ";
                status = OrderStatus.DELIVERY_WAIT_AUDIT;
                break;
            }
            case "102": {
                pre = "FHJG";
                status = OrderStatus.DELIVERY_OUT_FINISH;
                break;
            }
            case "201": {
                pre = "SHTZ";
                status = OrderStatus.RECIPT_WAIT_AUDIT;
                break;
            }
            case "202": {
                pre = "SHJG";
                status = OrderStatus.RECIPT_FINISH;
                break;
            }
            case "301": {
                pre = "TH";
                status = OrderStatus.ADJUST_WAIT_AUDIT;
                break;
            }
        }
        String no = pre + InventoryConstant.createId();
        draOrderEo.setNo(no);
        draOrderEo.setStatus(Integer.valueOf(status));
        draOrderEo.setNum(draOrderEo.getNum());
        draOrderEo.setWarehouseId(warehouseEo.getId());
        draOrderEo.setWarehouseCode(warehouseEo.getCode());
        draOrderEo.setWarehouseName(warehouseEo.getName());
        draOrderEo.setCreatePerson("sys");
        draOrderEo.setCreateTime((java.util.Date)new Date(new java.util.Date().getTime()));
        draOrderEo.setUpdatePerson("sys");
        draOrderEo.setUpdateTime((java.util.Date)new Date(new java.util.Date().getTime()));
        draOrderEo.setDr(0);
        this.checkRepeat(draOrderEo);
        this.tcbjDRAOrderMapper.insert((Object)draOrderEo);
    }

    @Override
    public void checkRepeat(DRAOrderEo draOrderEo) {
        boolean lockFlag = this.cacheService.setIfAbsent("DRA_ORDER_LOCK_KEY_" + draOrderEo.getPreNo() + "_" + draOrderEo.getType() + "_" + draOrderEo.getCategory(), (Object)true, 60);
        if (!lockFlag) {
            throw new BizException("301", "\u5355\u636e\u7c7b\u578b\u548c\u5355\u636e\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u91cd\u8bd5");
        }
        QueryWrapper eoQueryWrapper = new QueryWrapper();
        eoQueryWrapper.eq((Object)"pre_no", (Object)draOrderEo.getPreNo());
        eoQueryWrapper.eq((Object)"type", (Object)draOrderEo.getType());
        eoQueryWrapper.eq((Object)"category", (Object)draOrderEo.getCategory());
        List draOrderEos = this.tcbjDRAOrderMapper.selectList((Wrapper)eoQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)draOrderEos)) {
            throw new BizException("304", "\u76f8\u540c\u7c7b\u578b\u7684\u5355\u636e\u53f7\u5df2\u88ab\u5360\u7528\uff0c\u7981\u6b62\u91cd\u590d\u63d0\u4ea4");
        }
    }

    @Override
    public List<TcbjResDetailCargoRespDto> getResCargo(String orderNo) {
        QueryWrapper qwrapper = new QueryWrapper();
        qwrapper.eq((Object)"order_no", (Object)orderNo);
        List cargoEos = this.tcbjDRAOrderCargoMapper.selectList((Wrapper)qwrapper);
        List<TcbjResDetailCargoRespDto> collect = cargoEos.stream().map(c -> {
            TcbjResDetailCargoRespDto tmp = new TcbjResDetailCargoRespDto();
            tmp.setCargoCode(c.getCargoCode());
            tmp.setCargoName(c.getCargoName());
            tmp.setCargoNo(c.getCargoNo());
            tmp.setNum(c.getNum());
            tmp.setBatch(c.getBatch());
            tmp.setTradeOrderItemId(c.getTradeOrderItemId());
            return tmp;
        }).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<TcbjNotiDetailCargoRespDto> getNotiCargo(String orderNo) {
        QueryWrapper qwrapper = new QueryWrapper();
        qwrapper.eq((Object)"order_no", (Object)orderNo);
        List cargoEos = this.tcbjDRAOrderCargoMapper.selectList((Wrapper)qwrapper);
        List<TcbjNotiDetailCargoRespDto> collect = cargoEos.stream().map(c -> {
            TcbjNotiDetailCargoRespDto tmp = new TcbjNotiDetailCargoRespDto();
            tmp.setNum(c.getNum());
            tmp.setCargoCode(c.getCargoCode());
            tmp.setCargoName(c.getCargoName());
            tmp.setCargoNo(c.getCargoNo());
            tmp.setCancelNum(c.getCancelNum());
            tmp.setPlanNum(c.getPlanNum());
            tmp.setSentNum(c.getSentNum());
            tmp.setWaitNum(c.getWaitNum());
            tmp.setBatch(c.getBatch());
            return tmp;
        }).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<TcbjNotiDetailCargoRespDto> getNotifyCargoListByOrderNoList(List<String> orderNoList) {
        logger.info("getNotifyCargoListByOrderNoList==>orderNoList:{}", (Object)LogUtils.buildLogContent(orderNoList));
        if (CollectionUtils.isEmpty(orderNoList)) {
            return new ArrayList<TcbjNotiDetailCargoRespDto>();
        }
        QueryWrapper qwrapper = new QueryWrapper();
        qwrapper.in((Object)"order_no", orderNoList);
        List cargoEos = this.tcbjDRAOrderCargoMapper.selectList((Wrapper)qwrapper);
        List<TcbjNotiDetailCargoRespDto> respList = cargoEos.stream().map(c -> {
            TcbjNotiDetailCargoRespDto tmp = new TcbjNotiDetailCargoRespDto();
            tmp.setNum(c.getNum());
            tmp.setCargoCode(c.getCargoCode());
            tmp.setCargoName(c.getCargoName());
            tmp.setCargoNo(c.getCargoNo());
            tmp.setCancelNum(c.getCancelNum());
            tmp.setPlanNum(c.getPlanNum());
            tmp.setSentNum(c.getSentNum());
            tmp.setWaitNum(c.getWaitNum());
            tmp.setBatch(c.getBatch());
            return tmp;
        }).collect(Collectors.toList());
        return respList;
    }

    @Override
    public List<CloudInventoryDto> getInventory() {
        String urlString = "http://test-tcbjjxc.by-health.com/erp/api/inv/query/availableStock?access_token=270fe85e315f4fea83381bfffecdcf591914465b1df242239cea253557410685";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantId", "34cc4109705e4c058b7b3b0352e57d31");
        HashMap<String, String> materialList = new HashMap<String, String>();
        materialList.put("materialNo", "A.A.01.02.AA010208");
        map.put("materialList", Collections.singletonList(materialList));
        String post = HttpUtil.post((String)urlString, map);
        JSONObject jsonObject = JSON.parseObject((String)post);
        String string = jsonObject.getString("returnObject");
        List dtos = JSON.parseArray((String)string, CloudInventoryDto.class);
        return dtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void physicWarehouseAdjustInOut(DRAOrderEo draOrderEo, List<DRAOrderCargoEo> draOrderCargoEos, int action) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)draOrderEo.getWarehouseCode());
        WarehouseEo warehouseEo = (WarehouseEo)this.tcbjWarehouseMapper.selectOne((Wrapper)queryWrapper);
        if (warehouseEo == null) {
            throw new BizException("\u627e\u4e0d\u5230\u5bf9\u5e94\u4ed3\u5e93\uff1a{}\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff01", draOrderEo.getWarehouseCode());
        }
        draOrderEo.setOrganizationId(warehouseEo.getOrganizationId());
        ArrayList storageOrderDetailList = Lists.newArrayList();
        for (DRAOrderCargoEo cargoEo : draOrderCargoEos) {
            QueryWrapper storageEoQuerywrapper = new QueryWrapper();
            storageEoQuerywrapper.eq((Object)"dr", (Object)"0");
            storageEoQuerywrapper.eq((Object)"warehouse_id", (Object)draOrderEo.getWarehouseId());
            storageEoQuerywrapper.eq((Object)"cargo_id", (Object)cargoEo.getCargoId());
            storageEoQuerywrapper.eq((Object)"batch", (Object)cargoEo.getBatch());
            CargoStorageEo cargoStorageEo = (CargoStorageEo)this.cargoStorageMapper.selectOne((Wrapper)storageEoQuerywrapper);
            Long num = (long)cargoEo.getNum();
            StorageOrderDetailEo storageOrderDetailEo = new StorageOrderDetailEo();
            storageOrderDetailEo.setCargoId(cargoEo.getCargoId());
            storageOrderDetailEo.setWarehouseId(draOrderEo.getWarehouseId());
            storageOrderDetailEo.setBatch(cargoEo.getBatch());
            if (2 == action || 3 == action) {
                num = -num.longValue();
            }
            storageOrderDetailEo.setNum(num);
            storageOrderDetailEo.setVersion(cargoStorageEo.getVersion());
            storageOrderDetailList.add(storageOrderDetailEo);
            ChangeLogEo changeLogEo = new ChangeLogEo();
            BigDecimal preempt = BigDecimal.ZERO;
            if (cargoStorageEo.getPreempt() != null) {
                preempt = cargoStorageEo.getPreempt();
            }
            BigDecimal balance = BigDecimal.ZERO;
            BigDecimal available = BigDecimal.ZERO;
            if (2 == action || 3 == action) {
                changeLogEo.setNewNum(cargoStorageEo.getBalance().add(new BigDecimal(cargoEo.getNum())));
            }
            if (1 == action) {
                changeLogEo.setNewNum(cargoStorageEo.getBalance().subtract(new BigDecimal(cargoEo.getNum())));
            }
            if (changeLogEo.getNewNum().compareTo(BigDecimal.ZERO) == -1) {
                throw new BizException("\u5e93\u5b58\u4e0d\u8db3\u4e0d\u5141\u8bb8\u8c03\u6574\u5e93\u5b58\uff01");
            }
            changeLogEo.setRelevanceNo(draOrderEo.getNo());
            changeLogEo.setWarehouseId(warehouseEo.getId().toString());
            changeLogEo.setWarehouseName(warehouseEo.getName());
            changeLogEo.setWarehouseCode(warehouseEo.getCode());
            changeLogEo.setBatch(cargoEo.getBatch());
            changeLogEo.setCargoId(cargoEo.getCargoId());
            changeLogEo.setCargoName(cargoEo.getCargoName());
            changeLogEo.setCargoCode(cargoEo.getCargoCode());
            changeLogEo.setNewNum(balance.add(preempt));
            changeLogEo.setChangeNum(new BigDecimal(cargoEo.getNum()));
            changeLogEo.setOldNum(cargoStorageEo.getBalance().add(preempt));
            changeLogEo.setNewNum(changeLogEo.getOldNum().subtract(changeLogEo.getChangeNum()));
            changeLogEo.setType(StorageTypeEnu.BALANCE.getCode());
            changeLogEo.setOrderType(OrderTypeEnu.INVOKE_CUBE_ORDER_MATERIAL_ADJUST_OUT.getCode());
            changeLogEo.setUpdateTime(null);
            logger.info("physicWarehouseAdjustInOut==>\u5373\u65f6\u5e93\u5b58,\u63d2\u5165\u64cd\u4f5c\u65e5\u5fd7\u5b8c\u6210,changeLogEo:{}", (Object)JSON.toJSONString((Object)changeLogEo));
            int insert = this.tcbjChangeLogMapper.insert((Object)changeLogEo);
            changeLogEo.setType(StorageTypeEnu.AVAILABLE.getCode());
            changeLogEo.setOrderType(OrderTypeEnu.INVOKE_CUBE_ORDER_MATERIAL_ADJUST_OUT.getCode());
            changeLogEo.setUpdateTime(null);
            changeLogEo.setId(null);
            changeLogEo.setNewNum(available);
            changeLogEo.setChangeNum(new BigDecimal(cargoEo.getNum()));
            changeLogEo.setOldNum(cargoStorageEo.getAvailable());
            changeLogEo.setNewNum(changeLogEo.getOldNum().subtract(changeLogEo.getChangeNum()));
            int insert1 = this.tcbjChangeLogMapper.insert((Object)changeLogEo);
            logger.info("physicWarehouseAdjustInOut==>\u53ef\u7528\u5e93\u5b58,\u63d2\u5165\u64cd\u4f5c\u65e5\u5fd7\u5b8c\u6210,changeLogEo:{}", (Object)JSON.toJSONString((Object)changeLogEo));
        }
        if (CollectionUtil.isNotEmpty((Collection)storageOrderDetailList)) {
            StockChangeDto stockChangeDto = new StockChangeDto();
            stockChangeDto.setOrderNo(draOrderEo.getNo());
            stockChangeDto.setChangeType("STOCK_IN");
            stockChangeDto.setBizType("TRANSFER_ORDER_PHYSICAL_IN");
            if (1 == action) {
                stockChangeDto.setChangeType("STOCK_OUT");
                stockChangeDto.setBizType("TRANSFER_ORDER_PHYSICAL_OUT");
            }
            try {
                logger.info("\u4fee\u6539\u5e93\u5b58\u5165\u53c2stockChangeDto:{},storageOrderDetailList{}", (Object)JSON.toJSONString((Object)stockChangeDto), (Object)JSON.toJSONString((Object)storageOrderDetailList));
                int i = this.transferOrderService.tcbjPhysicLogicWarehouseOut(stockChangeDto, (List)storageOrderDetailList);
                logger.info("\u4fee\u6539\u7269\u7406\u5e93\u5b58\u8fd4\u56de\u7ed3\u679c{}", (Object)i);
            }
            catch (Exception e) {
                throw new BizException("\u51fa\u5e93\u6263\u51cf\u5e93\u5b58\u9519\u8bef\uff1a{}" + e.getMessage());
            }
        }
    }
}

