/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInventoryAdjustQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInventoryAdjustService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsLogicInventoryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.adjust.CsInventoryAdjustDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.adjust.CsInventoryAdjustEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsLogicWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsLogicInventoryMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.adjust.CsInventoryAdjustDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.adjust.CsInventoryAdjustMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsLogicWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.OrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInventoryAdjustAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInventoryAdjustAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInventoryAdjustDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryCoverInventoryFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csInventoryAdjustService")
public class CsInventoryAdjustServiceImpl
implements ICsInventoryAdjustService {
    private static Logger logger = LoggerFactory.getLogger(CsInventoryAdjustServiceImpl.class);
    @Resource
    private CsInventoryAdjustMapper csInventoryAdjustMapper;
    @Resource
    private CsInventoryAdjustDetailMapper csInventoryAdjustDetailMapper;
    @Resource
    private CsLogicWarehouseMapper csLogicWarehouseMapper;
    @Resource
    private CsLogicInventoryMapper csLogicInventoryMapper;
    @Resource
    private ICsInventoryAdjustQueryService csInventoryAdjustQueryService;
    @Resource
    private ICsInventoryExposedService csInventoryExposedService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CsInventoryAdjustAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        this.checkParam(null, addReqDto);
        CsInventoryAdjustEo csInventoryAdjustEo = new CsInventoryAdjustEo();
        CubeBeanUtils.copyProperties((Object)csInventoryAdjustEo, (Object)addReqDto, (String[])new String[0]);
        csInventoryAdjustEo.setDocumentNo("TZD" + System.currentTimeMillis());
        addReqDto.setDocumentNo(csInventoryAdjustEo.getDocumentNo());
        csInventoryAdjustEo.setOrderStatus(OrderStatusEnum.ADJUST_WAIT_AUDIT.getCode() + "");
        csInventoryAdjustEo.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        List<CsInventoryAdjustDetailEo> list = this.getCsInventoryAdjustDetailEos(addReqDto);
        this.csInventoryAdjustMapper.insert((Object)csInventoryAdjustEo);
        this.csInventoryAdjustDetailMapper.insertBatch(list);
        return csInventoryAdjustEo.getId();
    }

    private void checkParam(Long id, CsInventoryAdjustAddReqDto addReqDto) {
        if (id != null) {
            CsInventoryAdjustEo selectEo = this.csInventoryAdjustQueryService.selectByPrimaryKey(id);
            AssertUtil.isTrue(selectEo != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
            String status = OrderStatusEnum.ADJUST_FINISH.getCode() + "";
            AssertUtil.isTrue(!status.equals(selectEo.getOrderStatus()), "\u5df2\u8c03\u6574\u7684\u72b6\u6001\u4e0d\u53ef\u4fee\u6539");
            addReqDto.setDocumentNo(selectEo.getDocumentNo());
        }
        List adjustDetailAddReqDtoList = addReqDto.getAdjustDetailAddReqDtoList();
        List csLogicWarehouseEos = this.csLogicWarehouseMapper.queryByWarehouseCode(addReqDto.getWarehouseCode());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csLogicWarehouseEos), "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        CsLogicWarehouseEo csLogicWarehouseEo = (CsLogicWarehouseEo)csLogicWarehouseEos.get(0);
        addReqDto.setWarehouseId(csLogicWarehouseEo.getId());
        addReqDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"warehouse_code", (Object)addReqDto.getWarehouseCode());
        List cargoCodes = adjustDetailAddReqDtoList.stream().map(CsInventoryAdjustDetailAddReqDto::getCargoCode).collect(Collectors.toList());
        wrapper.in((Object)"cargo_code", cargoCodes);
        List csLogicInventoryEos = this.csLogicInventoryMapper.selectList((Wrapper)wrapper);
        for (CsInventoryAdjustDetailAddReqDto csInventoryAdjustDetailAddReqDto : adjustDetailAddReqDtoList) {
            boolean exist = false;
            for (CsLogicInventoryEo csLogicInventoryEo : csLogicInventoryEos) {
                if (!csLogicInventoryEo.getCargoCode().equals(csInventoryAdjustDetailAddReqDto.getCargoCode())) continue;
                exist = true;
                csInventoryAdjustDetailAddReqDto.setCargoName(csLogicInventoryEo.getCargoName());
                csInventoryAdjustDetailAddReqDto.setArtNo(csLogicInventoryEo.getArtNo());
                break;
            }
            AssertUtil.isTrue(exist, "\u4ed3\u5e93\u4e2d\u4e0d\u5b58\u5728\u8d27\u54c1\uff1a" + csInventoryAdjustDetailAddReqDto.getCargoCode() + csInventoryAdjustDetailAddReqDto.getCargoName());
        }
    }

    private List<CsInventoryAdjustDetailEo> getCsInventoryAdjustDetailEos(CsInventoryAdjustAddReqDto addReqDto) {
        ArrayList list = Lists.newArrayList();
        for (CsInventoryAdjustDetailAddReqDto csInventoryAdjustDetailAddReqDto : addReqDto.getAdjustDetailAddReqDtoList()) {
            CsInventoryAdjustDetailEo csInventoryAdjustDetailEo = new CsInventoryAdjustDetailEo();
            BeanUtils.copyProperties((Object)csInventoryAdjustDetailAddReqDto, (Object)csInventoryAdjustDetailEo);
            csInventoryAdjustDetailEo.setDocumentNo(addReqDto.getDocumentNo());
            list.add(csInventoryAdjustDetailEo);
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(Long id, CsInventoryAdjustAddReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        this.checkParam(id, updateReqDto);
        CsInventoryAdjustEo updateEo = CsInventoryAdjustEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        updateEo.setOrderStatus(OrderStatusEnum.ADJUST_WAIT_AUDIT.getCode() + "");
        this.csInventoryAdjustMapper.updateById((BaseEo)updateEo);
        CsInventoryAdjustDetailEo eo = new CsInventoryAdjustDetailEo();
        eo.setDocumentNo(updateReqDto.getDocumentNo());
        this.csInventoryAdjustDetailMapper.delete((BaseEo)eo);
        List<CsInventoryAdjustDetailEo> list = this.getCsInventoryAdjustDetailEos(updateReqDto);
        this.csInventoryAdjustDetailMapper.insertBatch(list);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        CsInventoryAdjustEo eo = this.csInventoryAdjustQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        this.csInventoryAdjustMapper.deleteLogicById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void audit(CsInventoryAdjustAuditReqDto auditReqDto) {
        logger.info("\u6279\u91cf\u5ba1\u6838\u8c03\u6574\u5355\uff0c\u5165\u53c2\uff1a{}", (Object)LogUtils.buildLogContent(auditReqDto));
        List<CsInventoryAdjustEo> adjustEoList = this.validParam(auditReqDto);
        if (YesNoEnum.NO.getValue().equals(auditReqDto.getIsPass())) {
            for (CsInventoryAdjustEo csInventoryAdjustEo : adjustEoList) {
                String status = OrderStatusEnum.ADJUST_REFUSE.getCode() + "";
                csInventoryAdjustEo.setOrderStatus(status);
                this.csInventoryAdjustMapper.updateById((BaseEo)csInventoryAdjustEo);
            }
        } else {
            List documentNos = adjustEoList.stream().map(CsInventoryAdjustEo::getDocumentNo).collect(Collectors.toList());
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"document_no", documentNos);
            List detailEoList = this.csInventoryAdjustDetailMapper.selectList((Wrapper)wrapper);
            HashMap<String, String> map = new HashMap<String, String>();
            for (CsInventoryAdjustEo csInventoryAdjustEo : adjustEoList) {
                String status = OrderStatusEnum.ADJUST_FINISH.getCode() + "";
                csInventoryAdjustEo.setOrderStatus(status);
                this.csInventoryAdjustMapper.updateById((BaseEo)csInventoryAdjustEo);
                map.put(csInventoryAdjustEo.getDocumentNo(), csInventoryAdjustEo.getWarehouseCode());
            }
            logger.info("\u6279\u91cf\u5ba1\u6838\u8c03\u6574\u5355\uff0c\u5f00\u59cb\u66f4\u65b0\u5e93\u5b58\uff1a{}", (Object)LogUtils.buildLogContent(detailEoList));
            for (CsInventoryAdjustDetailEo adjustDetailEo : detailEoList) {
                CsInventoryOperateCargoReqDto cargoReqDto = new CsInventoryOperateCargoReqDto();
                cargoReqDto.setWarehouseCode((String)map.get(adjustDetailEo.getDocumentNo()));
                cargoReqDto.setCargoCode(adjustDetailEo.getCargoCode());
                cargoReqDto.setChangeInventory(adjustDetailEo.getAdjustNum());
                cargoReqDto.setBatch(adjustDetailEo.getBatch());
                cargoReqDto.setCoverInventoryFlag(CsInventoryCoverInventoryFlagEnum.UPDATE.getCode());
                this.updateInInventory(cargoReqDto, adjustDetailEo.getDocumentNo(), adjustDetailEo.getIsAdd());
            }
            logger.info("\u6279\u91cf\u5ba1\u6838\u8c03\u6574\u5355\uff0c\u66f4\u65b0\u5e93\u5b58\u5b8c\u6bd5\uff1a{}");
        }
    }

    public void updateInInventory(CsInventoryOperateCargoReqDto cargoReqDto, String sourceNo, Integer isAdd) {
        logger.info("updateInInventory==>\u6279\u91cf\u5ba1\u6838\u8c03\u6574\u5355,\u51fa/\u5165\u5e93\u903b\u8f91\u3001\u7269\u7406\u4ed3\u5e93\u5b58,cargoReqDto:{}", (Object)LogUtils.buildLogContent(cargoReqDto));
        this.checkParams(cargoReqDto);
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.PHYSICS.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.NO.getValue());
        csInventoryInOutBasicsDto.setSourceNo(sourceNo);
        csInventoryInOutBasicsDto.setSourceType(YesNoEnum.YES.getValue().equals(isAdd) ? CsInventorySourceTypeEnum.IN_TO_ADJUST.getCode() : CsInventorySourceTypeEnum.OUT_TO_ADJUST.getCode());
        csInventoryInOutBasicsDto.setInOutFlag(YesNoEnum.YES.getValue().equals(isAdd) ? CsInventoryInOutEnum.IN.getCode() : CsInventoryInOutEnum.OUT.getCode());
        csInventoryInOutBasicsDto.setCoverInventoryFlag(cargoReqDto.getCoverInventoryFlag());
        csInventoryInOutBasicsDto.setUpdateTotalFlag(YesNoEnum.YES.getValue());
        CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
        inOutBasicsCargoDto.setCargoCode(cargoReqDto.getCargoCode());
        inOutBasicsCargoDto.setActivityFlag(YesNoEnum.NO.getValue());
        inOutBasicsCargoDto.setBalance(YesNoEnum.YES.getValue().equals(isAdd) ? cargoReqDto.getChangeInventory().abs() : cargoReqDto.getChangeInventory().abs().negate());
        inOutBasicsCargoDto.setAvailable(YesNoEnum.YES.getValue().equals(isAdd) ? cargoReqDto.getChangeInventory().abs() : cargoReqDto.getChangeInventory().abs().negate());
        inOutBasicsCargoDto.setWarehouseCode(cargoReqDto.getWarehouseCode());
        inOutBasicsCargoDto.setBatch(cargoReqDto.getBatch());
        inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        this.csInventoryExposedService.operateInventory(csInventoryInOutBasicsDto);
        logger.info("updateInInventory==>\u6279\u91cf\u5ba1\u6838\u8c03\u6574\u5355,\u51fa/\u5165\u5e93\u903b\u8f91\u3001\u7269\u7406\u4ed3\u5e93\u5b58,csInventoryInOutBasicsDto:{}", (Object)LogUtils.buildLogContent(csInventoryInOutBasicsDto));
    }

    private void checkParams(CsInventoryOperateCargoReqDto inventoryOperateDetailReqDto) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getWarehouseCode()), "\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getCargoCode()), "\u8d27\u54c1\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getBatch()), "\u8d27\u54c1\u6279\u6b21\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != inventoryOperateDetailReqDto.getChangeInventory(), "\u53d8\u52a8\u5e93\u5b58\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private List<CsInventoryAdjustEo> validParam(CsInventoryAdjustAuditReqDto auditReqDto) {
        List<CsInventoryAdjustEo> adjustEoList = this.csInventoryAdjustQueryService.queryByIds(auditReqDto.getIds());
        AssertUtil.isTrue(adjustEoList.size() == auditReqDto.getIds().size(), "\u5165\u53c2\u6709\u4e0d\u5b58\u5728\u7684\u8c03\u6574\u5355id");
        for (CsInventoryAdjustEo csInventoryAdjustEo : adjustEoList) {
            String status = OrderStatusEnum.ADJUST_WAIT_AUDIT.getCode() + "";
            AssertUtil.isTrue(status.equals(csInventoryAdjustEo.getOrderStatus()), "\u8c03\u6574\u5355\u72b6\u6001\u975e\u5f85\u5ba1\u6838");
        }
        return adjustEoList;
    }
}

