/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.order.delivery.ITcbjDeliveryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjNotiGenItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjNotiGenReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.activity.CombinedPackageEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component
public class CreateDeliverInformOrderProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(CreateDeliverInformOrderProcess.class);
    @Autowired
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private ITcbjDeliveryApi tcbjDeliveryApi;

    public MessageResponse process(MessageVo messageVo) {
        logger.info("----->\u8ba2\u5355\u521b\u5efa\u5b8c\u6210\uff0c\u5f00\u59cb\u521b\u5efa\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)messageVo));
        try {
            String orderNoStr = messageVo.getData().toString();
            String orderNo = (String)JacksonUtil.readValue((String)orderNoStr, String.class);
            if (StringUtils.isEmpty((CharSequence)orderNo)) {
                logger.info("----->\u6d88\u8d39\u5f02\u5e38\uff0c\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
                return MessageResponse.ERROR;
            }
            ArrayList<OrderQueryEnum> attrs = new ArrayList<OrderQueryEnum>();
            attrs.add(OrderQueryEnum.ADDRESS);
            attrs.add(OrderQueryEnum.ITEM);
            OrderDetailRespDto orderDto = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)this.orderBizQueryApi.getOrderDetail(orderNo, StringUtils.join(attrs, (String)",")));
            logger.info("----->\u83b7\u53d6\u8ba2\u5355\u660e\u7ec6\uff1a{}", (Object)JSONObject.toJSONString((Object)orderDto));
            if (ObjectUtil.isEmpty((Object)orderDto)) {
                logger.info("----->\u83b7\u53d6\u8ba2\u5355\u660e\u7ec6\u5f02\u5e38\uff0c\u6ca1\u6709\u8ba2\u5355\u660e\u7ec6\uff1a{}", (Object)orderNo);
                return MessageResponse.ERROR;
            }
            OrderDeliveryRespDto orderDelivery = new OrderDeliveryRespDto();
            if (ObjectUtil.isNotEmpty((Object)orderDto.getDeliveryAddress())) {
                orderDelivery = (OrderDeliveryRespDto)JSONObject.parseObject((String)orderDto.getDeliveryAddress(), OrderDeliveryRespDto.class);
            }
            TcbjNotiGenReqDto tcbjNotiGenReqDto = new TcbjNotiGenReqDto();
            tcbjNotiGenReqDto.setPreNo(orderDto.getOrderNo());
            tcbjNotiGenReqDto.setAddress(orderDelivery.getAddress());
            tcbjNotiGenReqDto.setPlanTime(orderDto.getPlaceTime().toString());
            tcbjNotiGenReqDto.setReciveName(orderDelivery.getDeliveryName());
            tcbjNotiGenReqDto.setRecivePhone(orderDelivery.getDeliveryMobile());
            tcbjNotiGenReqDto.setWarehouseCode(orderDto.getWarehouseCode());
            tcbjNotiGenReqDto.setOrganizationId(orderDto.getOrganizationId());
            ArrayList<TcbjNotiGenItemReqDto> notiGenItemReqDtos = new ArrayList<TcbjNotiGenItemReqDto>();
            for (TradeItemRespDto item : orderDto.getOrderItems()) {
                TcbjNotiGenItemReqDto dto = new TcbjNotiGenItemReqDto();
                dto.setBatch(item.getBatchNo());
                dto.setCargoCode(item.getCargoSerial());
                dto.setNum(item.getItemNum());
                if (CombinedPackageEnum.YES.getType().equals(item.getIsCombinedPackage())) {
                    dto.setActivityId(item.getCombinedPackageActivityId());
                    dto.setCombinationFlag(item.getIsCombinedPackage());
                }
                dto.setType(item.getGift());
                dto.setTradeOrderItemId(item.getId());
                notiGenItemReqDtos.add(dto);
            }
            tcbjNotiGenReqDto.setNotiGenItemReqDtos(notiGenItemReqDtos);
            tcbjNotiGenReqDto.setType(Integer.valueOf(101));
            logger.info("----->\u521b\u5efa\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)tcbjNotiGenReqDto));
            this.tcbjDeliveryApi.send(tcbjNotiGenReqDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("----->\u6d88\u8d39\u8ba2\u5355\u521b\u5efaMQ\u4fe1\u606f\u5f02\u5e38:{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }
}

